/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager.mysqls;

import com.bokesoft.erp.mid.util.NotImplemented;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.IPreparedStatementSetParaCount;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.PreparedStatementNotImplemented;
import com.bokesoft.yes.mid.mysqls.dsntablename.DeleteDSNTableNameCalc;
import com.bokesoft.yes.mid.mysqls.dsntablename.InsertDSNTableNameCalc;
import com.bokesoft.yes.mid.mysqls.dsntablename.SelectDSNTableNameCalc;
import com.bokesoft.yes.mid.mysqls.dsntablename.UpdateDSNTableNameCalc;
import com.bokesoft.yes.mid.mysqls.execute.DDLExecute;
import com.bokesoft.yes.mid.mysqls.execute.DeleteExecute;
import com.bokesoft.yes.mid.mysqls.execute.ExecuteUtil;
import com.bokesoft.yes.mid.mysqls.execute.InsertExecute;
import com.bokesoft.yes.mid.mysqls.execute.SelectExecute;
import com.bokesoft.yes.mid.mysqls.execute.UpdateExecute;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.oidpool.OIDPool;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.sql.DeleteSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.InsertSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.mid.mysqls.sql.UpdateSqlInfo;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.boke.jsqlparser.expression.operators.SqlParametricCheck;

public class MultiDBPreparedStatement
extends PreparedStatementNotImplemented
implements IPreparedStatementSetParaCount {
    MultiDBManager dbManager;
    private String sql;
    private Parameters curParameters = null;
    private List<Parameters> parametersList = Collections.synchronizedList(new ArrayList());
    Map<DSNTableName, List<Parameters>> dsnNameToParametersList;
    private int parameterCount = -1;

    public MultiDBPreparedStatement(MultiDBManager dbManager, String sql) {
        this.dbManager = dbManager;
        this.sql = sql;
    }

    public MultiDBPreparedStatement(MultiDBManager dbManager) {
        this.dbManager = dbManager;
    }

    public void changeSql(String sql, List<Parameters> parametersList) {
        this.sql = sql;
        this.setParametersList(parametersList);
    }

    public String getSql() {
        return this.sql;
    }

    public List<Parameters> getParametersList() {
        return this.parametersList;
    }

    public void setParametersList(List<Parameters> parametersList) {
        this.parametersList = parametersList != null ? parametersList : Collections.synchronizedList(new ArrayList());
        this.curParameters = null;
        this.dsnNameToParametersList = null;
    }

    @Override
    public void addBatch() throws SQLException {
        int count = this.parametersList.size();
        if (count == 0) {
            this.parametersList.add(this.curParameters);
        } else if (this.parametersList.get(count - 1) != this.curParameters) {
            this.parametersList.add(this.curParameters);
        }
        this.curParameters = null;
        this.dsnNameToParametersList = null;
    }

    public int[] realExecute() throws SQLException {
        this.dbManager.begin();
        SqlInfo sqlInfo = SqlInfos.instance.getSqlInfo(this.sql);
        if (sqlInfo instanceof InsertSqlInfo) {
            return InsertExecute.execute(this.dbManager, this);
        }
        if (sqlInfo instanceof UpdateSqlInfo) {
            return UpdateExecute.execute(this.dbManager, this);
        }
        if (sqlInfo instanceof DeleteSqlInfo) {
            return DeleteExecute.execute(this.dbManager, this);
        }
        throw new RuntimeException();
    }

    @Override
    public boolean execute() throws SQLException {
        if (ExecuteUtil.isDDL(this.sql)) {
            DDLExecute.execute(this.dbManager, this);
            return true;
        }
        this.realExecute();
        return true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.sql = sql;
        return this.execute();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.realExecute();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        block2: {
            try {
                new SqlParametricCheck().checkSelectSQL(this.sql);
            }
            catch (Throwable throwable) {
                if (DataObjects.isNoBusinessForm()) break block2;
                throw new RuntimeException(throwable.getMessage());
            }
        }
        ResultSetGetObjectByPos result = SelectExecute.execute(this.dbManager, this);
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.sql = sql;
        return this.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            new SqlParametricCheck().checkSelectSQL(this.sql);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        if (ExecuteUtil.isDDL(this.sql)) {
            return DDLExecute.execute(this.dbManager, this);
        }
        if (ExecuteUtil.isMerge(this.sql)) {
            if (this.parametersList != null && this.parametersList.size() > 1) {
                throw new RuntimeException("\u6267\u884c\u51fa\u9519\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e2d\u53c2\u6570\u7ec4\u5e94\u5c0f\u4e8e\u7b49\u4e8e1\u4e2a\u3002");
            }
            int result = (Integer)UpdateExecute.execute(this.dbManager, this.dbManager.getKey(), this.sql, this.getParametersList());
            this.setExecuted();
            return result;
        }
        int[] realExecute = this.realExecute();
        return realExecute == null ? 0 : realExecute[0];
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.sql = sql.trim();
        return this.executeUpdate();
    }

    private void ensureParametersNotNull() {
        if (this.curParameters == null) {
            int parameterCount = this.getParameterCount();
            this.curParameters = new Parameters(parameterCount);
            if (this.parametersList.size() == 0) {
                this.parametersList.add(this.curParameters);
            }
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, 3, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, 4, x ? 1 : 0);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, 91, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, 4, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, -5, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, sqlType, null);
    }

    @Override
    public void setObject(int parameterIndex, Object parameterObj) throws SQLException {
        if (parameterObj == null) {
            this.setNull(parameterIndex, 1111);
        } else if (parameterObj instanceof Byte) {
            this.setInt(parameterIndex, ((Byte)parameterObj).intValue());
        } else if (parameterObj instanceof String) {
            this.setString(parameterIndex, (String)parameterObj);
        } else if (parameterObj instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)parameterObj);
        } else if (parameterObj instanceof Short) {
            this.setShort(parameterIndex, (Short)parameterObj);
        } else if (parameterObj instanceof Integer) {
            this.setInt(parameterIndex, (Integer)parameterObj);
        } else if (parameterObj instanceof Long) {
            this.setLong(parameterIndex, (Long)parameterObj);
        } else if (parameterObj instanceof Float) {
            this.setFloat(parameterIndex, ((Float)parameterObj).floatValue());
        } else if (parameterObj instanceof Double) {
            this.setDouble(parameterIndex, (Double)parameterObj);
        } else if (parameterObj instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])parameterObj);
        } else if (parameterObj instanceof Date) {
            this.setDate(parameterIndex, (Date)parameterObj);
        } else if (parameterObj instanceof Time) {
            this.setTime(parameterIndex, (Time)parameterObj);
        } else if (parameterObj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)parameterObj);
        } else if (parameterObj instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)parameterObj);
        } else if (parameterObj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)parameterObj, -1);
        } else if (parameterObj instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)parameterObj);
        } else if (parameterObj instanceof Clob) {
            this.setClob(parameterIndex, (Clob)parameterObj);
        } else if (parameterObj instanceof BigInteger) {
            this.setString(parameterIndex, parameterObj.toString());
        } else {
            throw new NotImplemented();
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, 12, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, 92, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ensureParametersNotNull();
        this.curParameters.setArg(parameterIndex, 93, x);
    }

    @Override
    public void close() throws SQLException {
    }

    public String toString() {
        StringBuilder result = new StringBuilder(512).append(this.sql);
        result.append("#").append(this.parametersList);
        return result.toString();
    }

    public void setParameterSOID(Long soid) {
        this.ensureParametersNotNull();
        this.curParameters.setHeadOID("SOID", soid);
    }

    public OneOrMultiValue<DSNTableName> getDSNNames() throws SQLException {
        OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
        for (DSNTableName dsnName : this.getDSNNameToParametersList().keySet()) {
            result.addValue(dsnName);
        }
        return result;
    }

    public void clearDsnNameParaList() {
        this.curParameters = null;
        this.parametersList.clear();
        this.dsnNameToParametersList = null;
    }

    public Map<DSNTableName, List<Parameters>> getDSNNameToParametersList() throws SQLException {
        if (this.dsnNameToParametersList == null || this.dsnNameToParametersList.size() == 0) {
            this.calcDSNNames();
        }
        return this.dsnNameToParametersList;
    }

    private void calcDSNNames() throws SQLException {
        HashMap<DSNTableName, List<Parameters>> tmp = new HashMap<DSNTableName, List<Parameters>>();
        if (this.parametersList == null) {
            this.parametersList = Collections.synchronizedList(new ArrayList());
        }
        if (this.parametersList.size() == 0) {
            OneOrMultiValue<DSNTableName> dsnNames = this.calcDSNNames(null);
            this.putDSNNameParameters(dsnNames, null, tmp);
        } else {
            for (Parameters parameters : this.parametersList) {
                OneOrMultiValue<DSNTableName> dsnNames = this.calcDSNNames(parameters);
                this.putDSNNameParameters(dsnNames, parameters, tmp);
            }
        }
        this.dsnNameToParametersList = tmp;
    }

    private void putDSNNameParameters(OneOrMultiValue<DSNTableName> dsnNames, Parameters parameters, Map<DSNTableName, List<Parameters>> tmp) {
        if (parameters == null) {
            for (DSNTableName dsnTableName : dsnNames) {
                if (tmp.containsKey(dsnTableName)) continue;
                tmp.put(dsnTableName, null);
            }
        } else {
            for (DSNTableName dsnName : dsnNames) {
                List<Parameters> parametersInOneDSN = tmp.get(dsnName);
                if (parametersInOneDSN == null) {
                    parametersInOneDSN = new ArrayList<Parameters>();
                    tmp.put(dsnName, parametersInOneDSN);
                }
                parametersInOneDSN.add(parameters);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OneOrMultiValue<DSNTableName> calcDSNNames(Parameters parameters) throws SQLException {
        SqlInfo sqlInfo = SqlInfos.instance.getSqlInfo(this.getSql());
        String tableName = sqlInfo.getTableName();
        OneOrMultiValue<DSNTableName> result = null;
        TableGroupProp tableGroupProp = null;
        if (MetaFactory.getGlobalInstance() != null) {
            tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(tableName);
        }
        if (tableGroupProp != null) {
            OIDPool oidPool = this.dbManager.getOIDToDSNName();
            try {
                if (sqlInfo instanceof SelectSqlInfo) {
                    return SelectDSNTableNameCalc.calcDSNTableName(tableGroupProp, (SelectSqlInfo)sqlInfo, parameters, oidPool, this.dbManager);
                }
                if (sqlInfo instanceof InsertSqlInfo) {
                    return InsertDSNTableNameCalc.calcDSNTableName(tableGroupProp, (InsertSqlInfo)sqlInfo, parameters, oidPool, this.dbManager);
                }
                if (sqlInfo instanceof DeleteSqlInfo) {
                    return DeleteDSNTableNameCalc.calcDSNTableName(tableGroupProp, (DeleteSqlInfo)sqlInfo, parameters, oidPool, (IDBManager)this.dbManager);
                }
                if (!(sqlInfo instanceof UpdateSqlInfo)) return result;
                return UpdateDSNTableNameCalc.calcDSNTableName(tableGroupProp, (UpdateSqlInfo)sqlInfo, parameters, oidPool, this.dbManager);
            }
            catch (Throwable e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("PreparedStatementDelayExecute.calcDSNNames()\u65f6\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002", e);
            }
        }
        String defaultDSNName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
        DSNTableName dsnTableName = new DSNTableName(defaultDSNName);
        return new OneOrMultiValue<DSNTableName>(dsnTableName);
    }

    public void setExecuted() {
        this.parametersList.clear();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    private int getParameterCount() {
        if (this.parameterCount < 0) {
            this.parameterCount = SqlInfos.instance.getJDBCParameterCount(this.sql);
        }
        return this.parameterCount;
    }

    @Override
    public void setParameterCount(int count) {
        this.parameterCount = count;
    }
}

