/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager.mysqls;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.bokesoft.erp.mid.util.DocumentDBUtil;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.DruidConnectionFactory;
import com.bokesoft.yes.mid.connection.MdbConnectionProfile;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.connection.MultiDBManagerFactory;
import com.bokesoft.yes.mid.connection.XAConnectionFactory;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedAlter;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSqls;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.execute.DDLExecute;
import com.bokesoft.yes.mid.mysqls.execute.MoveHeadDataAfterGroupDetailChangeDSN;
import com.bokesoft.yes.mid.mysqls.oidpool.OIDPool;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.Unions;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.LimitProcess;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSet;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.statement.select.PlainSelect;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDBManager
extends GeneralDBManager {
    private static final Logger logger = LoggerFactory.getLogger(MultiDBManager.class);
    private Map<String, Connection> thread_allConnections = null;
    private Map<String, Connection> thread_allXAConnections = null;
    private boolean ignoreXA = false;
    private OIDPool oidToDSNName;
    private UserTransactionManager utxa = null;
    private MoveHeadDataAfterGroupDetailChangeDSN moveHeadDataAfterGroupDetailChangeDSN;
    private boolean isBegin = false;
    private DBStruct dbStruct;
    private IDBManager dbManagerDefaultDSN;

    public MultiDBManager(IConnectionProfile profile, Connection connection) {
        super(profile, connection);
    }

    public OIDPool getOIDToDSNName() {
        if (this.oidToDSNName == null) {
            this.oidToDSNName = new OIDPool(this);
        }
        return this.oidToDSNName;
    }

    public MoveHeadDataAfterGroupDetailChangeDSN getMoveHeadDataAfterGroupDetailChangeDSN() {
        if (this.moveHeadDataAfterGroupDetailChangeDSN == null) {
            this.moveHeadDataAfterGroupDetailChangeDSN = new MoveHeadDataAfterGroupDetailChangeDSN();
        }
        return this.moveHeadDataAfterGroupDetailChangeDSN;
    }

    public void moveHeadData(String headTableName) throws Throwable {
        if (this.moveHeadDataAfterGroupDetailChangeDSN != null) {
            this.moveHeadDataAfterGroupDetailChangeDSN.submit(this, headTableName);
        }
    }

    public void setIgnoreXA(boolean ignoreXA) {
        this.ignoreXA = ignoreXA;
    }

    public void begin() throws SQLException {
        if (this.isBegin || this.ignoreXA) {
            return;
        }
        if (this.utxa == null) {
            try {
                logger.debug("MultiDBManager.begin().\u5f53\u524d\u7ebf\u7a0b\uff1a{}", (Object)Thread.currentThread().getId());
                UserTransactionManager utm = new UserTransactionManager();
                if (utm.getTransaction() == null) {
                    this.utxa = utm;
                    this.utxa.setTransactionTimeout(0);
                    this.utxa.begin();
                    logger.debug("XA\u4e8b\u52a1\u542f\u52a8============{}", (Object)this.hashCode());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.isBegin = true;
    }

    @Override
    public void commit() throws SQLException {
        Object[] actions = new Object[]{"DB commit"};
        int action = Performance.startAction((Object[])actions);
        try {
            block13: {
                if (this.cacheDBRequest != null) {
                    this.cacheDBRequest.submit();
                }
                if (this.moveHeadDataAfterGroupDetailChangeDSN != null) {
                    this.moveHeadDataAfterGroupDetailChangeDSN.submit(this);
                }
                if (this.oidToDSNName != null) {
                    try {
                        this.oidToDSNName.commit();
                    }
                    catch (Throwable e) {
                        logger.debug(e.getMessage());
                    }
                }
                if (this.utxa != null) {
                    try {
                        if (this.utxa.getTransaction() != null) {
                            this.utxa.commit();
                            this.utxa = null;
                            logger.debug("XA\u4e8b\u52a1\u63d0\u4ea4==============={}", (Object)this.hashCode());
                            break block13;
                        }
                        throw new RuntimeException("utxa.commit\uff0c\u4e0d\u5e94\u8be5\u8fd0\u884c\u5230\u8fd9\u91cc  " + this.hashCode());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("utxa.commit\u65f6\u51fa\u9519  " + this.hashCode(), e);
                    }
                }
            }
            if (this.thread_allConnections != null) {
                for (Connection con : this.thread_allConnections.values()) {
                    con.commit();
                }
            }
        }
        catch (Throwable e) {
            this.rollback();
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("MultiDBManager.commit\u65f6\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002", e);
        }
        Performance.endActive((int)action, (Object[])actions);
    }

    @Override
    public void rollback() throws SQLException {
        block11: {
            if (this.cacheDBRequest != null) {
                this.cacheDBRequest.rollback();
            }
            if (this.moveHeadDataAfterGroupDetailChangeDSN != null) {
                this.moveHeadDataAfterGroupDetailChangeDSN.rollback();
            }
            if (this.oidToDSNName != null) {
                this.oidToDSNName.rollback();
            }
            if (this.utxa != null) {
                logger.debug("XA\u4e8b\u52a1\u56de\u6eda================={}", (Object)this.hashCode());
                try {
                    try {
                        this.utxa.rollback();
                    }
                    catch (Exception exception) {
                        this.utxa = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.utxa = null;
                    throw throwable;
                }
                this.utxa = null;
            }
        }
        if (this.thread_allConnections != null) {
            for (Connection con : this.thread_allConnections.values()) {
                con.rollback();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.dbManagerDefaultDSN != null) {
            this.dbManagerDefaultDSN.close();
            this.dbManagerDefaultDSN = null;
        }
        if (this.utxa != null) {
            try {
                this.utxa.rollback();
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
            this.utxa = null;
            logger.debug("XA\u4e8b\u52a1\u5173\u95ed==============={}", (Object)this.hashCode());
        }
        if (this.thread_allConnections != null) {
            for (Connection con : this.thread_allConnections.values()) {
                if (con.isClosed()) continue;
                con.close();
            }
            this.thread_allConnections.clear();
            this.thread_allConnections = null;
        }
        if (this.thread_allXAConnections != null) {
            for (Connection con : this.thread_allXAConnections.values()) {
                if (con.isClosed()) continue;
                con.close();
            }
            this.thread_allXAConnections.clear();
            this.thread_allXAConnections = null;
        }
    }

    @Override
    public PreparedStatement prepareStatementJDBC(String sql) throws SQLException {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)sql.trim(), (CharSequence)"select")) {
            this.begin();
        }
        MultiDBPreparedStatement result = new MultiDBPreparedStatement(this, sql);
        return result;
    }

    @Override
    protected Statement createStatementJDBC() throws SQLException {
        MultiDBPreparedStatement result = new MultiDBPreparedStatement(this);
        return result;
    }

    public Connection getConnectionByDSNName(String dsnName) throws SQLException {
        if (this.utxa == null) {
            if (this.thread_allConnections == null) {
                this.thread_allConnections = new HashMap<String, Connection>();
            }
            if (!this.thread_allConnections.containsKey(dsnName)) {
                Connection connection = MultiDBManager.getJDBCConnection(dsnName);
                this.thread_allConnections.put(dsnName, connection);
            }
            return this.thread_allConnections.get(dsnName);
        }
        if (this.thread_allXAConnections == null) {
            this.thread_allXAConnections = new HashMap<String, Connection>();
        }
        if (!this.thread_allXAConnections.containsKey(dsnName)) {
            Connection connection = this.createXAConnection(dsnName);
            this.thread_allXAConnections.put(dsnName, connection);
        }
        return this.thread_allXAConnections.get(dsnName);
    }

    public Connection getJDBCConnectionByDSNName(String dsnName) throws SQLException {
        if (this.thread_allConnections == null) {
            this.thread_allConnections = new HashMap<String, Connection>();
        }
        if (!this.thread_allConnections.containsKey(dsnName)) {
            Connection connection = MultiDBManager.getJDBCConnection(dsnName);
            this.thread_allConnections.put(dsnName, connection);
        }
        return this.thread_allConnections.get(dsnName);
    }

    private Connection createXAConnection(String dsnName) throws SQLException {
        Connection connection;
        MultiDBDSNItem dbDSNItem = MdbDSNItems.instance.getDSNItem(dsnName);
        if (dbDSNItem == null) {
            throw new RuntimeException("DSN " + dsnName + "\u4e0d\u5b58\u5728\u3002");
        }
        MdbConnectionProfile profile = new MdbConnectionProfile();
        profile.setKey(dbDSNItem.getName());
        profile.setDBType(dbDSNItem.getDBType());
        profile.setConnectionType(dbDSNItem.getConnectionType());
        profile.setDriver(dbDSNItem.getDriver());
        profile.setURL(dbDSNItem.getURL());
        profile.setUser(dbDSNItem.getUser());
        profile.setPassword(dbDSNItem.getPassword());
        profile.setExtPropMap(dbDSNItem.getExtPropMap());
        profile.setExtPropMap2(dbDSNItem.getExtPropMap2());
        profile.setDriverExt(dbDSNItem.getDriverExt());
        XAConnectionFactory connectionFactory = new XAConnectionFactory();
        try {
            connection = connectionFactory.getConnection((IConnectionProfile)profile);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff0c" + profile.getKey(), e);
        }
        connection.setAutoCommit(false);
        return connection;
    }

    public IDBManager getDBManagerByDsnName(String dsnName) throws Throwable {
        Connection connectionByDSNName = this.getConnectionByDSNName(dsnName);
        MultiDBDSNItem dbDSNItem = MdbDSNItems.instance.getDSNItem(dsnName);
        if (dbDSNItem == null) {
            throw new RuntimeException("DSN " + dsnName + "\u4e0d\u5b58\u5728\u3002");
        }
        MdbConnectionProfile profile = new MdbConnectionProfile();
        profile.setKey(dbDSNItem.getName());
        profile.setDBType(dbDSNItem.getDBType());
        profile.setConnectionType(3);
        profile.setDriver(dbDSNItem.getDriverExt());
        profile.setURL(dbDSNItem.getURL());
        profile.setUser(dbDSNItem.getUser());
        profile.setPassword(dbDSNItem.getPassword());
        profile.setExtPropMap(dbDSNItem.getExtPropMap2());
        MultiDBManagerFactory dbf = new MultiDBManagerFactory(false);
        IDBManager dbManager = dbf.getDBManager((IConnectionProfile)profile, connectionByDSNName);
        return dbManager;
    }

    public static IDBManager createDBManager(String dsnName) throws Throwable {
        MultiDBDSNItem dbDSNItem = MdbDSNItems.instance.getDSNItem(dsnName);
        if (dbDSNItem == null) {
            throw new RuntimeException("DSN " + dsnName + "\u4e0d\u5b58\u5728\u3002");
        }
        MdbConnectionProfile profile = new MdbConnectionProfile();
        profile.setKey(dbDSNItem.getName());
        profile.setDBType(dbDSNItem.getDBType());
        profile.setConnectionType(3);
        profile.setDriver(dbDSNItem.getDriverExt());
        profile.setURL(dbDSNItem.getURL());
        profile.setUser(dbDSNItem.getUser());
        profile.setPassword(dbDSNItem.getPassword());
        profile.setExtPropMap(dbDSNItem.getExtPropMap2());
        MultiDBManagerFactory dbf = new MultiDBManagerFactory(false);
        return dbf.getDBManager((IConnectionProfile)profile);
    }

    public static Connection getJDBCConnection(String dsnName) throws SQLException {
        Connection connection;
        String clsname;
        MdbConnectionProfile profile;
        MultiDBDSNItem dbDSNItem;
        block11: {
            dbDSNItem = MdbDSNItems.instance.getDSNItem(dsnName);
            if (dbDSNItem == null) {
                throw new RuntimeException("DSN " + dsnName + "\u4e0d\u5b58\u5728\u3002");
            }
            profile = new MdbConnectionProfile();
            profile.setKey(dbDSNItem.getName());
            profile.setConnectionType(3);
            clsname = dbDSNItem.getDriverExt();
            if (clsname == null) {
                try {
                    InputStream fis = PropertyUtil.readProperties((String)(String.valueOf(dsnName) + ".properties"));
                    PropertyResourceBundle dsnBundle = new PropertyResourceBundle(fis);
                    fis.close();
                    if (dsnBundle.containsKey("DriverExt")) {
                        clsname = dsnBundle.getString("DriverExt");
                        dbDSNItem.setDriverExt(clsname);
                        break block11;
                    }
                    throw new RuntimeException("\u6570\u636e\u6e90\uff1a" + dsnName + "\u672a\u8bbe\u7f6e DriverExt");
                }
                catch (Throwable e) {
                    logger.debug(e.getMessage());
                }
            }
        }
        profile.setDriver(clsname);
        profile.setURL(dbDSNItem.getURL());
        profile.setUser(dbDSNItem.getUser());
        profile.setPassword(dbDSNItem.getPassword());
        if (dbDSNItem.getExtPropMap2() == null) {
            try {
                InputStream extfis = PropertyUtil.readProperties((String)"druid.properties");
                PropertyResourceBundle extConfigBundle = new PropertyResourceBundle(extfis);
                extfis.close();
                Enumeration<String> extPropKeys = extConfigBundle.getKeys();
                while (extPropKeys.hasMoreElements()) {
                    String extPropKey = extPropKeys.nextElement();
                    String extPropValue = extConfigBundle.getString(extPropKey);
                    dbDSNItem.addExtProp2(extPropKey, extPropValue);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        profile.setExtPropMap(dbDSNItem.getExtPropMap2());
        DruidConnectionFactory connectionFactory = new DruidConnectionFactory();
        try {
            connection = connectionFactory.getConnection((IConnectionProfile)profile);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519\uff0c" + profile.getKey(), e);
        }
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public IDBManager getNewDBManager() throws Throwable {
        MultiDBManagerFactory dbf = new MultiDBManagerFactory(true);
        return dbf.getDBManager(this.profile);
    }

    @Override
    public void initDataBaseInfo(DataBaseInfo info) throws Throwable {
        IDBManager dbManager = this.getDBManagerDefaultDSN();
        dbManager.initDataBaseInfo(info);
    }

    public DBStruct getDBStruct() {
        if (this.dbStruct == null) {
            this.dbStruct = new DBStruct(this);
        }
        return this.dbStruct;
    }

    public void setParameterSOID(PreparedStatement ps, Long soid) {
        if (ps instanceof MultiDBPreparedStatement) {
            MultiDBPreparedStatement preparedStatementDelayExecute = (MultiDBPreparedStatement)ps;
            preparedStatementDelayExecute.setParameterSOID(soid);
        }
    }

    @Override
    protected void postProcessQueryDataTable(String sql, DataTable table, ResultSet resultSet) throws Throwable {
        if (MetaFactory.getGlobalInstance() != null) {
            Expression having;
            SelectSqlInfo sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
            if (sqlInfo.getSelect().getSelectBody() instanceof PlainSelect && (having = ((PlainSelect)sqlInfo.getSelect().getSelectBody()).getHaving()) != null) {
                String sFilter = ParsedSqlUtil.getFilterByHaving(having, (PlainSelect)sqlInfo.getSelect().getSelectBody());
                table.setFilter(sFilter);
                table.filter();
            }
            if (sqlInfo.getComplexSQL() instanceof Unions || resultSet instanceof UnionResultSet || resultSet instanceof JoinResultSet) {
                this.processOrderBy(table, sql);
                LimitProcess.process(sql, table, null);
            }
        }
    }

    private void processOrderBy(DataTable table, String sql) throws Throwable {
        if (table == null || table.size() == 0) {
            return;
        }
        SelectSqlInfo sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        SortCriteria[] vCriteria = sqlInfo.getSortCriteriaAlias();
        if (vCriteria == null || vCriteria.length == 0) {
            return;
        }
        table.setSort(vCriteria);
        table.sort();
    }

    @Override
    public boolean checkTableExist(String tableKey) throws Throwable {
        String dsnName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
        return this.getDBStruct().existTableName(dsnName, tableKey);
    }

    @Override
    public HashSet<String> getTableColumnSet(String tableKey) throws Throwable {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getTableColumnSet(tableKey);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HashSet<String> getIndexSet(String tableKey) throws Throwable {
        HashSet<String> set = new HashSet<String>();
        String dsnName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
        HashMapIgnoreCase<String> indexes = DBStruct.getConfirmedIndexes(dsnName, tableKey);
        if (indexes == null) {
            return set;
        }
        for (Map.Entry indexName : indexes.entrySet()) {
            set.add(((String)indexName.getKey()).toUpperCase());
        }
        return set;
    }

    @Override
    public String searchIndex(String indexName) throws Throwable {
        IDBManager iManager = this.getDBManagerDefaultDSN();
        return iManager.searchIndex(indexName);
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable table, List<MetaSchemaColumn> list) throws Throwable {
        IDBManager iManager = this.getDBManagerDefaultDSN();
        return iManager.getAlterTableStr(table, list);
    }

    public String getColumnDef(MetaSchemaColumn column) throws Throwable {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getColumnDef(column);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String keyWordEscape(String key) {
        switch (this.getDBType()) {
            case 4: {
                return "`" + key + "`";
            }
            case 8: {
                key = "\"" + key.toUpperCase() + "\"";
                return key;
            }
        }
        throw new NotImplementedException("Code is not implemented");
    }

    public StringBuilder appendKeyWordEscape(StringBuilder sb, String key) {
        switch (this.getDBType()) {
            case 4: {
                return sb.append("`").append(key).append("`");
            }
            case 8: {
                return sb.append("\"").append(key.toUpperCase()).append("\"");
            }
        }
        throw new NotImplementedException("Code is not implemented");
    }

    public int getDBType() {
        return this.profile.getDBType();
    }

    public String getConditionValue(int dataType, String value) {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getConditionValue(dataType, value);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getLikeConditionValue(String columnName, int dataType, String value) {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getLikeConditionValue(columnName, dataType, value);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public PrepareSQL getLimitString(String query, String orderBy, boolean hasOffset, int startRow, int endRow) {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getLimitString(query, orderBy, hasOffset, startRow, endRow);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getColumnCheckSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getColumnCheckSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getColumnStructSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getColumnStructSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getIndexCheckSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getIndexCheckSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getIndexSearchSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getIndexSearchSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getIndexStructSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getIndexStructSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getTableExistCheckSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getTableExistCheckSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getTableStructSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getTableStructSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public IDBManager getDBManagerDefaultDSN() throws Throwable {
        if (this.dbManagerDefaultDSN == null) {
            String dsnName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
            this.dbManagerDefaultDSN = MultiDBManager.createDBManager(dsnName);
        }
        return this.dbManagerDefaultDSN;
    }

    public String getViewExistCheckSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getViewExistCheckSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean checkViewExist(String viewKey) throws Throwable {
        IDBManager iManager = this.getDBManagerDefaultDSN();
        return iManager.checkViewExist(viewKey);
    }

    public String getViewStructSql() {
        try {
            IDBManager iManager = this.getDBManagerDefaultDSN();
            return iManager.getViewStructSql();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public DataTable execPrepareQuery(String dsnName, String sql, List<Object> arguments) throws Throwable {
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        Connection connection = this.getConnectionByDSNName(dsnName);
        try {
            DataTable result;
            ps = connection.prepareStatement(sql, 1004, 1007);
            int i = 0;
            int size = arguments.size();
            while (i < size) {
                ps.setObject(i + 1, arguments.get(i));
                ++i;
            }
            resultSet = ps.executeQuery();
            DataTable dataTable = result = DocumentDBUtil.populate(this, resultSet);
            return dataTable;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public DataTable execPrepareQuery(String dsnName, String sql, Object ... arguments) throws Throwable {
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        Connection connection = this.getConnectionByDSNName(dsnName);
        try {
            DataTable result;
            ps = connection.prepareStatement(sql, 1004, 1007);
            int i = 0;
            int size = arguments.length;
            while (i < size) {
                ps.setObject(i + 1, arguments[i]);
                ++i;
            }
            resultSet = ps.executeQuery();
            DataTable dataTable = result = DocumentDBUtil.populate(this, resultSet);
            return dataTable;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public int execPrepareUpdate(String dsnName, String sql, Object ... arguments) throws Throwable {
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        this.begin();
        Connection connection = this.getConnectionByDSNName(dsnName);
        try {
            ps = connection.prepareStatement(sql);
            int i = 0;
            int size = arguments.length;
            while (i < size) {
                ps.setObject(i + 1, arguments[i]);
                ++i;
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Override
    public int execPrepareUpdate(String sql, Object ... arguments) throws Throwable {
        this.execInShardingIfNeed(sql);
        this.begin();
        return super.execPrepareUpdate(sql, arguments);
    }

    @Override
    public int execPrepareUpdate(String sql, List<Object> arguments) throws Throwable {
        this.begin();
        return super.execPrepareUpdate(sql, arguments);
    }

    @Override
    public int execPrepareUpdate(String sql, List<Integer> types, List<Object> arguments) throws Throwable {
        this.begin();
        return super.execPrepareUpdate(sql, types, arguments);
    }

    @Override
    public int execUpdate(String sql) throws Throwable {
        this.begin();
        return super.execUpdate(sql);
    }

    @Override
    public int executeUpdate(PsPara para, QueryArguments args) throws Throwable {
        this.begin();
        return super.executeUpdate(para, args);
    }

    @Override
    public void executeUpdate(BatchPsPara bpp) throws Throwable {
        this.begin();
        super.executeUpdate(bpp);
    }

    @Override
    public int[] executeUpdateReturn(BatchPsPara bpp) throws Throwable {
        this.begin();
        return super.executeUpdateReturn(bpp);
    }

    @Override
    public void setRowLock(String tableKey, String condition, QueryArguments args) throws Throwable {
        this.begin();
        super.setRowLock(tableKey, condition, args);
    }

    @Override
    public void setRowLockEnsureInSYSLock(String key) throws Throwable {
        this.begin();
        super.setRowLockEnsureInSYSLock(key);
    }

    @Override
    protected void setRowLock(String sql, QueryArguments args) throws Throwable {
        this.begin();
        super.setRowLock(sql, args);
    }

    @Override
    public Statement createUpdateStatement() throws Throwable {
        this.begin();
        return super.createUpdateStatement();
    }

    @Override
    public PreparedStatement preparedUpdateStatement(String sql) throws Throwable {
        this.begin();
        return super.preparedUpdateStatement(sql);
    }

    @Override
    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)sql.trim(), (CharSequence)"select")) {
            this.begin();
        }
        return super.prepareStatement(sql);
    }

    public int execPrepareUpdate(String dsnName, String sql, List<Object> arguments) throws Throwable {
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        this.begin();
        Connection connection = this.getConnectionByDSNName(dsnName);
        try {
            ps = connection.prepareStatement(sql);
            int i = 0;
            int size = arguments.size();
            while (i < size) {
                ps.setObject(i + 1, arguments.get(i));
                ++i;
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    protected PreparedStatement prepareStatement(String dsnName, String sql) throws SQLException {
        Connection connection = this.getConnectionByDSNName(dsnName);
        return connection.prepareStatement(sql);
    }

    public void executeUpdate(String dsnName, DataTableBatchPsPara bpp) throws Throwable {
        String sql = bpp.getSql();
        if (sql == null || sql.length() == 0 || bpp.getBatchArgumentList().size() == 0) {
            return;
        }
        ArrayList psArgses = bpp.getBatchArgumentList();
        Object[] actions = new Object[]{sql, psArgses};
        int action = Performance.startAction((Object[])actions);
        Statement ps = null;
        Statement fullInsertPS = null;
        QueryArguments args2 = null;
        int psArgsCount = psArgses.size();
        try {
            try {
                int valuesPos;
                if (psArgsCount > 1 && (this.cacheDBRequest == null || !this.cacheDBRequest.isUseCacheDB()) && sql.startsWith("insert into ") && (valuesPos = sql.indexOf(" VALUES ")) > 0) {
                    int i;
                    String afterValues = sql.substring(valuesPos + " VALUES ".length());
                    int step = 0;
                    int argCount = ((QueryArguments)psArgses.get(0)).size();
                    while ((step + 1) * 100 < psArgsCount) {
                        if (fullInsertPS == null) {
                            StringBuilder fullInsertSql = new StringBuilder(sql.length() + (afterValues.length() + 1) * 100);
                            fullInsertSql.append(sql);
                            i = 1;
                            while (i < 100) {
                                fullInsertSql.append(",").append(afterValues);
                                ++i;
                            }
                            fullInsertPS = this.prepareStatement(dsnName, fullInsertSql.toString());
                        }
                        int i2 = 0;
                        int parameterIndex = 0;
                        while (i2 < 100) {
                            args2 = (QueryArguments)psArgses.get(step * 100 + i2);
                            int j = 0;
                            while (j < argCount) {
                                this.setParameter((PreparedStatement)fullInsertPS, ++parameterIndex, args2.get(j), args2.getType(j));
                                ++j;
                            }
                            ++i2;
                        }
                        fullInsertPS.execute();
                        ++step;
                    }
                    if (step * 100 < psArgsCount) {
                        StringBuilder insertSql = new StringBuilder(sql.length() + (afterValues.length() + 1) * (psArgsCount - step * 100));
                        insertSql.append(sql);
                        i = step * 100 + 1;
                        while (i < psArgsCount) {
                            insertSql.append(",").append(afterValues);
                            ++i;
                        }
                        ps = this.prepareStatement(dsnName, insertSql.toString());
                        i = step * 100;
                        int parameterIndex = 0;
                        while (i < psArgsCount) {
                            args2 = (QueryArguments)psArgses.get(i);
                            int j = 0;
                            while (j < argCount) {
                                this.setParameter((PreparedStatement)ps, ++parameterIndex, args2.get(j), args2.getType(j));
                                ++j;
                            }
                            ++i;
                        }
                        ps.execute();
                    }
                } else {
                    ps = this.prepareStatement(dsnName, sql);
                    int mark = 0;
                    int index = 0;
                    for (QueryArguments args2 : psArgses) {
                        int parameterIndex = 0;
                        int size = args2.size();
                        while (parameterIndex < size) {
                            this.setParameter((PreparedStatement)ps, parameterIndex + 1, args2.get(parameterIndex), args2.getType(parameterIndex));
                            ++parameterIndex;
                        }
                        ps.addBatch();
                        if (++mark != 100) continue;
                        ps.executeBatch();
                        mark = 0;
                        index += 100;
                    }
                    if (mark > 0) {
                        ps.executeBatch();
                    }
                }
            }
            catch (Throwable e) {
                this.sqlErrorLog(sql, args2, e);
                throw e;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (fullInsertPS != null) {
                fullInsertPS.close();
            }
        }
        Performance.endActive((int)action, (Object[])actions);
    }

    public static String getConnStatusReport() {
        StringBuffer result = new StringBuffer("DB Connection create Trace Info");
        return result.toString();
    }

    @Override
    public String getDBName() throws Throwable {
        IDBManager iManager = this.getDBManagerDefaultDSN();
        return iManager.getDBName();
    }

    private void execInShardingIfNeed(String sql) {
        ParsedSql parsedSql = ParsedSqls.getInstance().getParsedSql(sql);
        if (parsedSql instanceof ParsedAlter) {
            ParsedAlter alter = (ParsedAlter)parsedSql;
            String tableName = alter.getTableNames().get(0);
            for (MultiDBDSNItem dsnItem : MdbDSNItems.instance) {
                if (MdbDSNItems.instance.getDefaultDSN() == dsnItem) continue;
                IDBManager manager = null;
                try {
                    manager = this.getDBManagerByDsnName(dsnItem.getName());
                    if (!manager.checkTableExist(tableName)) continue;
                    DDLExecute.execute(dsnItem.getName(), sql, this);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

