/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.ServerID;
import com.bokesoft.yes.mid.connection.IQueryColumnMetaData;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.ConvertSqlByDBType;
import com.bokesoft.yes.mid.connection.dbmanager.IPreparedStatementSetParaCount;
import com.bokesoft.yes.mid.connection.dbmanager.ListQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.PreparedStatementWithLog;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.SQLLogUtils;
import com.bokesoft.yes.mid.connection.dbmanager.SlowSqlSetting;
import com.bokesoft.yes.mid.connection.dbmanager.SqlServerDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.StatementWithLog;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.dbcache.CacheDBRequest;
import com.bokesoft.yes.mid.dbcache.ICacheDBRequest;
import com.bokesoft.yes.mid.dbcache.IWhereExpression;
import com.bokesoft.yes.mid.dbcache.WhereExpressionForCache;
import com.bokesoft.yes.mid.dbcache.structure.CacheDB;
import com.bokesoft.yes.mid.dbcache.structure.CacheTable;
import com.bokesoft.yes.mid.dbmanager.interceptor.ComplexQueryInterceptor;
import com.bokesoft.yes.mid.dbmanager.interceptor.ISqlExecuteInterceptor;
import com.bokesoft.yes.mid.dbmanager.interceptor.UpdateExecuteInterceptor;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.ISqlProcessStage;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.LargeInToSubSelectStage;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSet;
import com.bokesoft.yes.mid.util.DocumentDBUtil;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.TypesStr;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralDBManager
implements IDBManager {
    private static final Logger logger = LoggerFactory.getLogger(GeneralDBManager.class);
    protected VE ve = null;
    protected String key = null;
    protected Connection connection = null;
    protected IConnectionProfile profile = null;
    protected CacheDBRequest cacheDBRequest;
    private static int transactionSequence = 0;
    private int transactionID = 0;
    private ISqlExecuteInterceptor<ResultSet> queryInterceptor = null;
    private ISqlExecuteInterceptor<Integer> updateInterceptor = null;
    public static final String STR_SYS_Lock_TableName = "SYS_Lock";
    public static final String STR_SYS_Lock_GlobalKey = "SYS_Lock_GlobalKey";

    public GeneralDBManager(IConnectionProfile profile, Connection connection) {
        this.profile = profile;
        this.connection = connection;
        int inLimitSize = SlowSqlSetting.instance.getInLimitSize();
        if ((this.getDBType() == 1 || this.getDBType() == 2 || this.getDBType() == 8) && inLimitSize > 0) {
            this.queryInterceptor = ComplexQueryInterceptor.newInstance(this, LargeInToSubSelectStage.newInstance(this.getDBType(), inLimitSize));
            this.updateInterceptor = new UpdateExecuteInterceptor((IDBManager)this, (ISqlProcessStage<Integer>)new LargeInToSubSelectStage<Integer>(this.getDBType(), inLimitSize));
        }
        if (Performance.isIsPrintCompleteSql()) {
            LogSvr.getInstance().info("\u521b\u5efadbManager\uff1a" + this.toString());
        }
    }

    public VE getVE() {
        return this.ve;
    }

    public void setVE(VE ve) {
        this.ve = ve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTransactionID() {
        if (this.transactionID != 0) return this.transactionID;
        Class<GeneralDBManager> clazz = GeneralDBManager.class;
        synchronized (GeneralDBManager.class) {
            if (this.transactionID != 0) return this.transactionID;
            this.transactionID = ServerID.getServerID(this) * 100000 + ++transactionSequence % 100000;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.transactionID;
        }
    }

    public ICacheDBRequest getCacheDBRequest() {
        if (this.cacheDBRequest == null) {
            this.cacheDBRequest = new CacheDBRequest(this);
        }
        return this.cacheDBRequest;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean checkViewExist(String viewKey) throws Throwable {
        PreparedStatement ps = null;
        ResultSet rset = null;
        try {
            String sql = this.getViewExistCheckSql();
            ps = this.prepareStatement(sql);
            PSArgs args = new PSArgs();
            args.addArg(Integer.valueOf(1002), (Object)viewKey.toUpperCase());
            rset = this.executeQuery(ps, sql, (QueryArguments)args);
            boolean bl = rset.first() && rset.getInt(1) == 1;
            return bl;
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public boolean checkTableExist(String tableKey) throws Throwable {
        PreparedStatement ps = null;
        ResultSet rset = null;
        try {
            String sql = this.getTableExistCheckSql();
            ps = this.prepareStatement(sql);
            PSArgs args = new PSArgs();
            args.addArg(Integer.valueOf(1002), (Object)tableKey.toUpperCase());
            rset = this.executeQuery(ps, sql, (QueryArguments)args);
            rset.next();
            boolean bl = rset.getInt(1) == 1;
            return bl;
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String searchIndex(String index) throws Throwable {
        PreparedStatement ps = null;
        ResultSet rset = null;
        try {
            String sql = this.getIndexSearchSql();
            ps = this.prepareStatement(sql);
            PSArgs args = new PSArgs();
            args.addArg(Integer.valueOf(1002), (Object)index.toUpperCase());
            rset = this.executeQuery(ps, sql, (QueryArguments)args);
            if (rset.next()) {
                String string = rset.getString(1);
                return string;
            }
            return null;
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public HashSet<String> getTableColumnSet(String tableKey) throws Throwable {
        String sql = this.getColumnCheckSql();
        HashSet<String> set = new HashSet<String>();
        PreparedStatement ps = null;
        ResultSet rset = null;
        try {
            ps = this.prepareStatement(sql);
            PSArgs args = new PSArgs();
            args.addArg(Integer.valueOf(1002), (Object)tableKey.toUpperCase());
            rset = this.executeQuery(ps, sql, (QueryArguments)args);
            while (rset.next()) {
                set.add(rset.getString(1).toUpperCase());
            }
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return set;
    }

    public HashSet<String> getIndexSet(String tableKey) throws Throwable {
        String sql = this.getIndexCheckSql();
        HashSet<String> set = new HashSet<String>();
        PreparedStatement ps = null;
        ResultSet rset = null;
        try {
            ps = this.prepareStatement(sql);
            PSArgs args = new PSArgs();
            args.addArg(Integer.valueOf(1002), (Object)tableKey.toUpperCase());
            rset = this.executeQuery(ps, sql, (QueryArguments)args);
            while (rset.next()) {
                String name = rset.getString(1);
                if (StringUtil.isBlankOrNull((String)name)) continue;
                set.add(name.toUpperCase());
            }
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return set;
    }

    public String getAlterTableStr(MetaSchemaTable table, List<MetaSchemaColumn> list) throws Throwable {
        Iterator<MetaSchemaColumn> t = list.iterator();
        String alterSql = "alter table " + this.keyWordEscape(table.getKey()) + " add ";
        if (t.hasNext()) {
            alterSql = String.valueOf(alterSql) + this.getColumnDef(t.next());
        }
        while (t.hasNext()) {
            alterSql = String.valueOf(alterSql) + "," + this.getColumnDef(t.next());
        }
        return alterSql;
    }

    public Object convert(Object value, int dataType, int JDBCDataType) throws Throwable {
        if (value != null) {
            switch (dataType) {
                case 1008: {
                    switch (JDBCDataType) {
                        case -4: 
                        case -3: 
                        case -2: {
                            return (byte[])value;
                        }
                        case 2004: {
                            Blob blob = (Blob)value;
                            return blob.getBytes(1L, (int)blob.length());
                        }
                        case 2005: 
                        case 2011: {
                            Clob clob = (Clob)value;
                            return clob.getSubString(1L, (int)clob.length()).getBytes();
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1009: {
                    switch (JDBCDataType) {
                        case 4: 
                        case 5: {
                            if ((Integer)value == 1) {
                                return true;
                            }
                            return false;
                        }
                        case 2: {
                            if (((BigDecimal)value).intValue() == 1) {
                                return true;
                            }
                            return false;
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1003: 
                case 1004: 
                case 1101: {
                    switch (JDBCDataType) {
                        case 91: {
                            return TypeConvertor.toDate((Object)value);
                        }
                        case 92: 
                        case 2013: {
                            return new java.util.Date(((Time)value).getTime());
                        }
                        case 93: 
                        case 2014: {
                            if (value instanceof java.util.Date) {
                                return value;
                            }
                            return new java.util.Date(((Timestamp)value).getTime());
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1005: 
                case 1006: 
                case 1007: {
                    if (value instanceof BigDecimal) {
                        return value;
                    }
                    switch (JDBCDataType) {
                        case 2: 
                        case 3: {
                            return TypeConvertor.toBigDecimal((Object)value);
                        }
                        case 8: {
                            return new BigDecimal((Double)value);
                        }
                        case 6: {
                            return new BigDecimal(((Float)value).floatValue());
                        }
                        case 4: 
                        case 5: {
                            return new BigDecimal((Integer)value);
                        }
                        case -5: {
                            return new BigDecimal((Long)value);
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1001: {
                    switch (JDBCDataType) {
                        case -6: 
                        case 4: 
                        case 5: {
                            if (value instanceof Long) {
                                return ((Long)value).intValue();
                            }
                            return (Integer)value;
                        }
                        case -5: {
                            return TypeConvertor.toLong((Object)value);
                        }
                        case 2: 
                        case 3: {
                            return ((BigDecimal)value).intValue();
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1010: {
                    switch (JDBCDataType) {
                        case 4: 
                        case 5: {
                            if (value instanceof Long) {
                                return (Long)value;
                            }
                            return ((Integer)value).longValue();
                        }
                        case -5: {
                            if (value instanceof BigInteger) {
                                return ((BigInteger)value).longValue();
                            }
                            if (value instanceof Integer) {
                                return ((Integer)value).longValue();
                            }
                            return (Long)value;
                        }
                        case 2: 
                        case 3: {
                            return ((BigDecimal)value).longValue();
                        }
                        case -9: 
                        case 12: {
                            return Long.parseLong((String)value);
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1002: 
                case 1012: {
                    if ("  ".equals(value)) {
                        return "";
                    }
                    return value.toString();
                }
                case 1011: {
                    switch (JDBCDataType) {
                        case 2005: 
                        case 2011: {
                            if (value instanceof String) {
                                if ("  ".equals((String)value)) {
                                    return "";
                                }
                                return value;
                            }
                            Clob clob = (Clob)value;
                            String result = this.ClobtoString(clob);
                            if ("  ".equals(result)) {
                                return "";
                            }
                            return result;
                        }
                        case 2004: {
                            Blob blob = (Blob)value;
                            return new String(blob.getBytes(1L, (int)blob.length()));
                        }
                        case -9: 
                        case -1: 
                        case 12: {
                            if ("  ".equals(value)) {
                                return "";
                            }
                            return (String)value;
                        }
                        case -4: {
                            return new String((byte[])value, "UTF-8");
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
            }
            throw new MidCoreException(7, " \u4e0d\u652f\u6301\u7684JDBC\u6570\u636e\u7c7b\u578b");
        }
        return null;
    }

    private String ClobtoString(Clob clob) throws Throwable {
        if (clob == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Reader inStreamDoc = clob.getCharacterStream();){
                char[] resDoc = new char[(int)clob.length()];
                inStreamDoc.read(resDoc);
                return new String(resDoc);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int convertDataType(int jdbcDataType) {
        switch (jdbcDataType) {
            case -5: {
                return 1010;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 1008;
            }
            case 0: 
            case 2005: 
            case 2011: {
                return 1011;
            }
            case -15: 
            case 1: {
                return 1012;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return 1002;
            }
            case 91: {
                return 1003;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return 1004;
            }
            case 2: 
            case 3: {
                return 1005;
            }
            case 8: {
                return 1006;
            }
            case 6: {
                return 1007;
            }
            case -6: 
            case 4: 
            case 5: {
                return 1001;
            }
        }
        return -1;
    }

    private void fillPrepareParameters(PreparedStatement statement, QueryArguments arguments) throws Throwable {
        if (arguments == null) {
            return;
        }
        if (arguments.supportType()) {
            int length = arguments.size();
            if (statement instanceof IPreparedStatementSetParaCount) {
                ((IPreparedStatementSetParaCount)((Object)statement)).setParameterCount(length);
            }
            int i = 0;
            while (i < length) {
                int type = arguments.getType(i);
                Object value = arguments.get(i);
                this.setParameter(statement, i + 1, value, type);
                ++i;
            }
        } else {
            int length = arguments.size();
            if (statement instanceof IPreparedStatementSetParaCount) {
                ((IPreparedStatementSetParaCount)((Object)statement)).setParameterCount(length);
            }
            int i = 0;
            while (i < length) {
                Object value = arguments.get(i);
                if (!(value instanceof Timestamp) && !(value instanceof Date)) {
                    if (value instanceof java.util.Date) {
                        value = new Timestamp(((java.util.Date)value).getTime());
                    } else if ("".equals(value)) {
                        value = "  ";
                    }
                }
                statement.setObject(i + 1, value);
                ++i;
            }
        }
    }

    private DataTable execPrepareQuery(String sql, QueryArguments arguments, IQueryColumnMetaData columnMetaData) throws Throwable {
        DataTable table = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = this.prepareStatement(sql);
                if (Performance.isIsPrintCompleteSql() && !(statement instanceof StatementWithLog)) {
                    long startData = System.currentTimeMillis();
                    resultSet = this.executeQuery(statement, sql, arguments);
                    long endData = System.currentTimeMillis();
                    Object[] actions = new Object[]{sql, arguments};
                    long l = endData - startData;
                    if (resultSet instanceof DataTableResultSet) {
                        table = ((DataTableResultSet)resultSet).getDataTable();
                        if (!table.first()) {
                            table.beforeFirst();
                        }
                    } else {
                        table = columnMetaData != null ? DocumentDBUtil.populate((IDBManager)this, resultSet, columnMetaData) : DocumentDBUtil.populate(this, resultSet);
                        this.postProcessQueryDataTable(sql, table, resultSet);
                        table.batchUpdate();
                    }
                    int row = table.size();
                    SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
                } else {
                    resultSet = this.executeQuery(statement, sql, arguments);
                    if (resultSet instanceof DataTableResultSet) {
                        table = ((DataTableResultSet)resultSet).getDataTable();
                        if (!table.first()) {
                            table.beforeFirst();
                        }
                    } else {
                        table = columnMetaData != null ? DocumentDBUtil.populate((IDBManager)this, resultSet, columnMetaData) : DocumentDBUtil.populate(this, resultSet);
                        this.postProcessQueryDataTable(sql, table, resultSet);
                        table.batchUpdate();
                    }
                }
            }
            catch (Throwable e) {
                this.sqlErrorLog(sql, arguments, e);
                throw e;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        TraceRecorder.traceData((String)("\u6267\u884cSQL\uff1a" + this.createLogInfo(sql, arguments)), (Object)table);
        return table;
    }

    protected void postProcessQueryDataTable(String sql, DataTable dataTable, ResultSet resultSet) throws Throwable {
    }

    public DataTable execPrepareQuery(String sql, Object ... arguments) throws Throwable {
        return this.execPrepareQuery(sql, (QueryArguments)new NormalQueryArguments(arguments), null);
    }

    public DataTable execPrepareQuery(String sql, IQueryColumnMetaData columnMetaData, Object ... arguments) throws Throwable {
        return this.execPrepareQuery(sql, (QueryArguments)new NormalQueryArguments(arguments), columnMetaData);
    }

    public DataTable execPrepareQuery(String sql, List<Object> arguments) throws Throwable {
        return this.execPrepareQuery(sql, (QueryArguments)new ListQueryArguments(null, arguments), null);
    }

    public DataTable execPrepareQuery(String sql, IQueryColumnMetaData columnMetaData, List<Object> arguments) throws Throwable {
        return this.execPrepareQuery(sql, (QueryArguments)new ListQueryArguments(null, arguments), columnMetaData);
    }

    public DataTable execPrepareQuery(String sql, List<Integer> types, List<Object> arguments) throws Throwable {
        return this.execPrepareQuery(sql, (QueryArguments)new ListQueryArguments(types, arguments), null);
    }

    public DataTable execPrepareQuery(String sql, IQueryColumnMetaData columnMetaData, List<Integer> types, List<Object> arguments) throws Throwable {
        return this.execPrepareQuery(sql, (QueryArguments)new ListQueryArguments(types, arguments), columnMetaData);
    }

    public DataTable execQuery(String sql) throws Throwable {
        return this.execQuery(sql, null);
    }

    public DataTable execQuery(String sql, IQueryColumnMetaData columnMetaData) throws Throwable {
        int action = Performance.startAction((Object[])new Object[]{sql});
        Statement statement = null;
        ResultSet resultSet = null;
        DataTable table = null;
        try {
            try {
                statement = this.createStatement();
                if (Performance.isIsPrintCompleteSql() && !(statement instanceof StatementWithLog)) {
                    long startData = System.currentTimeMillis();
                    resultSet = statement.executeQuery(sql);
                    long endData = System.currentTimeMillis();
                    Object[] actions = new Object[]{sql};
                    long l = endData - startData;
                    if (resultSet instanceof DataTableResultSet) {
                        table = ((DataTableResultSet)resultSet).getDataTable();
                        if (!table.first()) {
                            table.beforeFirst();
                        }
                    } else {
                        table = columnMetaData != null ? DocumentDBUtil.populate((IDBManager)this, resultSet, columnMetaData) : DocumentDBUtil.populate(this, resultSet);
                        this.postProcessQueryDataTable(sql, table, resultSet);
                        table.batchUpdate();
                    }
                    int row = table.size();
                    SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
                } else {
                    resultSet = statement.executeQuery(sql);
                    if (resultSet instanceof DataTableResultSet) {
                        table = ((DataTableResultSet)resultSet).getDataTable();
                        if (!table.first()) {
                            table.beforeFirst();
                        }
                    } else {
                        table = columnMetaData != null ? DocumentDBUtil.populate((IDBManager)this, resultSet, columnMetaData) : DocumentDBUtil.populate(this, resultSet);
                        this.postProcessQueryDataTable(sql, table, resultSet);
                        table.batchUpdate();
                    }
                }
            }
            catch (Throwable e) {
                this.sqlErrorLog(sql, null, e);
                throw e;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        Performance.endActive((int)action, (Object[])new Object[]{sql});
        return table;
    }

    private int execPrepareUpdate(String sql, QueryArguments arguments) throws Throwable {
        int rowsUpdated = 0;
        try (PreparedStatement statement = null;){
            try {
                statement = this.prepareStatement(sql);
                rowsUpdated = this.executeUpdate(statement, sql, arguments);
            }
            catch (Throwable e) {
                this.sqlErrorLog(sql, arguments, e);
                throw e;
            }
        }
        return rowsUpdated;
    }

    public int execPrepareUpdate(String sql, Object ... arguments) throws Throwable {
        return this.execPrepareUpdate(sql, (QueryArguments)new NormalQueryArguments(arguments));
    }

    public int execPrepareUpdate(String sql, List<Object> arguments) throws Throwable {
        return this.execPrepareUpdate(sql, (QueryArguments)new ListQueryArguments(null, arguments));
    }

    public int execPrepareUpdate(String sql, List<Integer> types, List<Object> arguments) throws Throwable {
        return this.execPrepareUpdate(sql, (QueryArguments)new ListQueryArguments(types, arguments));
    }

    public int execUpdate(String sql) throws Throwable {
        int result;
        int action = Performance.startAction((Object[])new Object[]{sql});
        try (Statement statement = null;){
            try {
                statement = this.createStatement();
                result = statement.executeUpdate(sql);
            }
            catch (Throwable e) {
                this.sqlErrorLog(sql, null, e);
                throw e;
            }
        }
        Performance.endActive((int)action, (Object[])new Object[]{sql});
        return result;
    }

    public void rollback() throws SQLException {
        Object[] actions = new Object[]{"DB rollback"};
        int action = Performance.startAction((Object[])actions);
        try {
            if (this.cacheDBRequest != null) {
                this.cacheDBRequest.rollback();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.connection.rollback();
        Performance.endActive((int)action, (Object[])actions);
    }

    public void commit() throws SQLException {
        Object[] actions = new Object[]{"DB commit"};
        int action = Performance.startAction((Object[])actions);
        try {
            if (this.cacheDBRequest != null) {
                this.cacheDBRequest.submit();
            }
        }
        catch (Throwable e) {
            this.connection.rollback();
            throw new RuntimeException(e);
        }
        this.connection.commit();
        Performance.endActive((int)action, (Object[])actions);
    }

    public void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (!this.connection.isClosed()) {
            if (Performance.isIsPrintCompleteSql()) {
                LogSvr.getInstance().info("\u9500\u6bc1dbManager\uff1a" + this.toString());
            }
            this.connection.close();
        }
    }

    public void setParameter(PreparedStatement ps, int parameterIndex, Object value, int dataType) throws SQLException, MidCoreException {
        switch (dataType) {
            case 1001: {
                if (value == null) {
                    ps.setNull(parameterIndex, 4);
                } else {
                    ps.setInt(parameterIndex, TypeConvertor.toInteger((Object)value));
                }
                return;
            }
            case 1002: 
            case 1011: 
            case 1012: {
                String tmp;
                String string = tmp = value == null ? null : value.toString();
                if ("".equals(tmp)) {
                    tmp = "  ";
                }
                ps.setString(parameterIndex, tmp);
                return;
            }
            case 1005: {
                ps.setBigDecimal(parameterIndex, value == null ? null : TypeConvertor.toBigDecimal((Object)value));
                return;
            }
            case 1008: {
                ps.setBytes(parameterIndex, value == null ? null : (byte[])value);
                return;
            }
            case 1010: {
                if (value == null) {
                    ps.setNull(parameterIndex, -5);
                } else {
                    ps.setLong(parameterIndex, TypeConvertor.toLong((Object)value));
                }
                return;
            }
            case 1004: {
                if (value == null) {
                    if (this.getDBType() == 8) {
                        ps.setString(parameterIndex, "");
                    } else {
                        ps.setNull(parameterIndex, 93);
                    }
                } else {
                    ps.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)value).getTime()));
                }
                return;
            }
            case 1003: {
                if (value == null) {
                    ps.setNull(parameterIndex, 91);
                } else {
                    ps.setDate(parameterIndex, new Date(((java.util.Date)value).getTime()));
                }
                return;
            }
            case 1006: {
                if (value == null) {
                    ps.setNull(parameterIndex, 8);
                } else {
                    ps.setDouble(parameterIndex, ((BigDecimal)value).doubleValue());
                }
                return;
            }
            case 1007: {
                if (value == null) {
                    ps.setNull(parameterIndex, 6);
                } else {
                    ps.setFloat(parameterIndex, ((BigDecimal)value).floatValue());
                }
                return;
            }
            case 1009: {
                ps.setInt(parameterIndex, value == null ? null : Integer.valueOf((Boolean)value != false ? 1 : 0));
                return;
            }
            case 1101: {
                if (value == null) {
                    ps.setNull(parameterIndex, 93);
                } else {
                    ps.setTimestamp(parameterIndex, value == null ? null : new Timestamp(((java.util.Date)value).getTime()));
                }
                return;
            }
        }
        throw new MidCoreException(8, "\u65e0\u6cd5\u8f6c\u5316\u7684\u6570\u636e\u7c7b\u578b");
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public ResultSet executeQuery(PreparedStatement ps, String sql, QueryArguments args) throws Throwable {
        this.fillPrepareParameters(ps, args);
        try {
            int action = 0;
            Object[] actions = new Object[]{sql, args};
            if (!(ps instanceof StatementWithLog)) {
                action = Performance.startAction((Object[])actions);
            }
            ResultSet resultSet = null;
            if (Performance.isIsPrintCompleteSql() && !(ps instanceof StatementWithLog)) {
                long startData = System.currentTimeMillis();
                resultSet = this.queryInterceptor != null && !this.queryInterceptor.isIntercepting() ? this.queryInterceptor.execute(ps, sql, args, false) : ps.executeQuery();
                long endData = System.currentTimeMillis();
                int row = 0;
                if (resultSet instanceof DataTableResultSet) {
                    DataTable table = ((DataTableResultSet)resultSet).getDataTable();
                    row = table.size();
                } else if (!(resultSet instanceof JoinResultSet) && !(resultSet instanceof UnionResultSet)) {
                    resultSet.last();
                    row = resultSet.getRow();
                    resultSet.first();
                    if (!(this instanceof SqlServerDBManager) || row != 0) {
                        resultSet.relative(-2);
                    }
                }
                long l = endData - startData;
                SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
            } else {
                resultSet = this.queryInterceptor != null && !this.queryInterceptor.isIntercepting() ? this.queryInterceptor.execute(ps, sql, args, false) : ps.executeQuery();
            }
            if (action > 0) {
                Performance.endActive((int)action, (Object[])actions);
            }
            return resultSet;
        }
        catch (Throwable e) {
            this.sqlErrorLog(sql, args, e);
            throw e;
        }
    }

    public int executeUpdate(PreparedStatement ps, String sql, QueryArguments args) throws Throwable {
        int size;
        try {
            this.fillPrepareParameters(ps, args);
            int action = 0;
            Object[] actions = new Object[]{sql, args};
            if (!(ps instanceof StatementWithLog)) {
                action = Performance.startAction((Object[])actions);
            }
            if (Performance.isIsPrintCompleteSql() && !(ps instanceof StatementWithLog)) {
                long startData = System.currentTimeMillis();
                size = this.updateInterceptor != null && !this.updateInterceptor.isIntercepting() ? this.updateInterceptor.execute(ps, sql, args, false).intValue() : ps.executeUpdate();
                long endData = System.currentTimeMillis();
                long l = endData - startData;
                SQLLogUtils.logSQL(this, logger, l, size, sql, actions);
            } else {
                size = this.updateInterceptor != null && !this.updateInterceptor.isIntercepting() ? this.updateInterceptor.execute(ps, sql, args, false).intValue() : ps.executeUpdate();
            }
            if (action > 0) {
                Performance.endActive((int)action, (Object[])actions);
            }
        }
        catch (Throwable e) {
            this.sqlErrorLog(sql, args, e);
            throw e;
        }
        return size;
    }

    public ResultSet executeQuery(PsPara para, QueryArguments args) throws Throwable {
        ResultSet resultSet = this.executeQuery(para.getPs(), para.getSql(), args);
        return resultSet;
    }

    public int executeUpdate(PsPara para, QueryArguments args) throws Throwable {
        return this.executeUpdate(para.getPs(), para.getSql(), args);
    }

    private boolean isSupportBatchInsert() {
        int dbType = this.getDBType();
        return dbType == 4 || dbType == 14;
    }

    public void executeUpdate(BatchPsPara bpp) throws Throwable {
        String sql = bpp.getSql();
        if (sql == null || sql.length() == 0 || bpp.getBatchArgumentList().size() == 0) {
            return;
        }
        ArrayList psArgses = bpp.getBatchArgumentList();
        Object[] actions = new Object[]{sql, psArgses};
        int action = Performance.startAction((Object[])actions);
        Statement ps = null;
        Statement fullInsertPS = null;
        QueryArguments args = null;
        int psArgsCount = psArgses.size();
        try {
            try {
                int valuesPos;
                if (!(this instanceof MultiDBManager) && this.isSupportBatchInsert() && psArgsCount > 1 && (this.cacheDBRequest == null || !this.cacheDBRequest.isUseCacheDB()) && sql.startsWith("insert into ") && (valuesPos = sql.indexOf(" VALUES ")) > 0) {
                    long l;
                    int row;
                    long endData;
                    int i;
                    String afterValues = sql.substring(valuesPos + " VALUES ".length());
                    int step = 0;
                    int argCount = ((QueryArguments)psArgses.get(0)).size();
                    while ((step + 1) * 100 < psArgsCount) {
                        if (fullInsertPS == null) {
                            StringBuilder fullInsertSql = new StringBuilder(sql.length() + (afterValues.length() + 1) * 100);
                            fullInsertSql.append(sql);
                            i = 1;
                            while (i < 100) {
                                fullInsertSql.append(",").append(afterValues);
                                ++i;
                            }
                            fullInsertPS = this.prepareStatement(fullInsertSql.toString());
                        }
                        int i2 = 0;
                        int parameterIndex = 0;
                        while (i2 < 100) {
                            args = (QueryArguments)psArgses.get(step * 100 + i2);
                            int j = 0;
                            while (j < argCount) {
                                this.setParameter((PreparedStatement)fullInsertPS, ++parameterIndex, args.get(j), args.getType(j));
                                ++j;
                            }
                            ++i2;
                        }
                        if (Performance.isIsPrintCompleteSql() && !(ps instanceof StatementWithLog)) {
                            long startData = System.currentTimeMillis();
                            boolean execute = fullInsertPS.execute();
                            endData = System.currentTimeMillis();
                            row = execute ? 1 : 0;
                            l = endData - startData;
                            SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
                        } else {
                            fullInsertPS.execute();
                        }
                        ++step;
                    }
                    if (step * 100 < psArgsCount) {
                        StringBuilder insertSql = new StringBuilder(sql.length() + (afterValues.length() + 1) * (psArgsCount - step * 100));
                        insertSql.append(sql);
                        i = step * 100 + 1;
                        while (i < psArgsCount) {
                            insertSql.append(",").append(afterValues);
                            ++i;
                        }
                        ps = this.prepareStatement(insertSql.toString());
                        i = step * 100;
                        int parameterIndex = 0;
                        while (i < psArgsCount) {
                            args = (QueryArguments)psArgses.get(i);
                            int j = 0;
                            while (j < argCount) {
                                this.setParameter((PreparedStatement)ps, ++parameterIndex, args.get(j), args.getType(j));
                                ++j;
                            }
                            ++i;
                        }
                        if (Performance.isIsPrintCompleteSql() && !(ps instanceof StatementWithLog)) {
                            long startData = System.currentTimeMillis();
                            ps.execute();
                            endData = System.currentTimeMillis();
                            row = psArgsCount;
                            l = endData - startData;
                            SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
                        } else {
                            ps.execute();
                        }
                    }
                } else {
                    long l;
                    int[] ints;
                    ps = this.prepareStatement(sql);
                    int mark = 0;
                    int index = 0;
                    Iterator it = psArgses.iterator();
                    int size = ((QueryArguments)psArgses.get(0)).size();
                    if (ps instanceof IPreparedStatementSetParaCount) {
                        ((IPreparedStatementSetParaCount)((Object)ps)).setParameterCount(size);
                    }
                    while (it.hasNext()) {
                        args = (QueryArguments)it.next();
                        int parameterIndex = 0;
                        while (parameterIndex < size) {
                            this.setParameter((PreparedStatement)ps, parameterIndex + 1, args.get(parameterIndex), args.getType(parameterIndex));
                            ++parameterIndex;
                        }
                        ps.addBatch();
                        if (++mark != 100) continue;
                        if (Performance.isIsPrintCompleteSql() && !(ps instanceof StatementWithLog)) {
                            long startData = System.currentTimeMillis();
                            ints = ps.executeBatch();
                            long endData = System.currentTimeMillis();
                            int row = 0;
                            if (ints != null) {
                                row = ints.length;
                            }
                            l = endData - startData;
                            SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
                        } else {
                            ps.executeBatch();
                        }
                        mark = 0;
                        index += 100;
                    }
                    if (mark > 0) {
                        if (Performance.isIsPrintCompleteSql() && !(ps instanceof StatementWithLog)) {
                            long startData = System.currentTimeMillis();
                            ints = ps.executeBatch();
                            int row = 0;
                            if (ints != null) {
                                row = ints.length;
                            }
                            long endData = System.currentTimeMillis();
                            l = endData - startData;
                            SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
                        } else {
                            ps.executeBatch();
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.sqlErrorLog(sql, args, e);
                throw e;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (fullInsertPS != null) {
                fullInsertPS.close();
            }
        }
        Performance.endActive((int)action, (Object[])actions);
    }

    public int[] executeUpdateReturn(BatchPsPara bpp) throws Throwable {
        String sql = bpp.getSql();
        ArrayList batchArgumentList = bpp.getBatchArgumentList();
        int argsSize = batchArgumentList.size();
        if (sql == null || sql.length() == 0 || argsSize == 0) {
            return null;
        }
        int[] result = new int[argsSize];
        ArrayList psArgses = batchArgumentList;
        Object[] actions = new Object[]{sql, psArgses};
        int action = Performance.startAction((Object[])actions);
        QueryArguments args = null;
        try (PreparedStatement ps = null;){
            try {
                ps = this.prepareStatement(sql);
                int mark = 0;
                int index = 0;
                while (index < argsSize) {
                    args = (QueryArguments)psArgses.get(index);
                    int parameterIndex = 0;
                    int size = args.size();
                    while (parameterIndex < size) {
                        this.setParameter(ps, parameterIndex + 1, args.get(parameterIndex), args.getType(parameterIndex));
                        ++parameterIndex;
                    }
                    ps.addBatch();
                    if (++mark == 100) {
                        int[] tmp = ps.executeBatch();
                        System.arraycopy(tmp, 0, result, index + 1 - 100, 100);
                        mark = 0;
                    }
                    ++index;
                }
                if (mark > 0) {
                    int[] tmp;
                    if (Performance.isIsPrintCompleteSql() && !(ps instanceof StatementWithLog)) {
                        long startData = System.currentTimeMillis();
                        tmp = ps.executeBatch();
                        long endData = System.currentTimeMillis();
                        int row = tmp.length;
                        long l = endData - startData;
                        SQLLogUtils.logSQL(this, logger, l, row, sql, actions);
                    } else {
                        tmp = ps.executeBatch();
                    }
                    System.arraycopy(tmp, 0, result, argsSize - mark, mark);
                }
            }
            catch (Throwable e) {
                this.sqlErrorLog(sql, args, e);
                throw e;
            }
        }
        Performance.endActive((int)action, (Object[])actions);
        return result;
    }

    private String createLogInfo(String sql, QueryArguments args) {
        if (args != null) {
            StringBuffer sb = new StringBuffer();
            String newSql = ConvertSqlByDBType.convertSql(sql, this.getDBType(), args);
            sb.append(newSql);
            int i = 0;
            while (i < args.size()) {
                sb.append("#");
                sb.append(i);
                sb.append(":");
                sb.append(args.get(i));
                sb.append(";");
                ++i;
            }
            sql = sb.toString();
        }
        return sql;
    }

    protected final void sqlErrorLog(String sql, QueryArguments args, Throwable err) {
        String errorPrefix = "\u6570\u636e\u5e93\u6267\u884c\u9519\u8bef\uff1a";
        LogSvr.getInstance().error("\u6570\u636e\u5e93\u6267\u884c\u9519\u8bef\uff1a" + this.createLogInfo(sql, args) + "\t" + err.getMessage(), null);
    }

    public final void setRowLock(String tableKey, String columnKey, Long OID) throws Throwable {
        String sql = "update " + this.keyWordEscape(tableKey) + " set " + "Slock" + "=1 where " + this.keyWordEscape(columnKey) + "=?";
        PSArgs args = new PSArgs();
        args.addLongArg(OID);
        this.setRowLock(sql, (QueryArguments)args);
    }

    public void setRowLock(String tableKey, String condition, QueryArguments args) throws Throwable {
        String sql = "update " + this.keyWordEscape(tableKey) + " set " + "Slock" + "=1 where " + condition;
        this.setRowLock(sql, args);
    }

    public void setRowLockEnsureInSYSLock(String key) throws Throwable {
        PSArgs args = new PSArgs();
        args.addStringArg(key);
        String sqlUpdate = "update SYS_Lock set Slock=1 where UniqueKey=?";
        PreparedStatement psUpdate = null;
        Statement psInsert = null;
        try {
            psUpdate = this.prepareStatementJDBC(sqlUpdate);
            int result = this.executeUpdate(psUpdate, sqlUpdate, (QueryArguments)args);
            if (result == 0) {
                String insertSql = "insert into SYS_Lock (UniqueKey) values (?)";
                SessionUtils.processWithContext(null, ctx -> {
                    IDBManager dbManager = ctx.getDBManager();
                    dbManager.execPrepareUpdate(sqlUpdate, new Object[]{STR_SYS_Lock_GlobalKey});
                    int res = dbManager.execPrepareUpdate(sqlUpdate, new Object[]{key});
                    if (res == 0) {
                        dbManager.execPrepareUpdate(insertSql, new Object[]{key});
                    }
                    return null;
                });
                result = this.executeUpdate(psUpdate, sqlUpdate, (QueryArguments)args);
                if (result != 1) {
                    throw new RuntimeException("\u6570\u636e\u8868SYS_Lock\u52a0\u884c\u9501\u5931\u8d25\uff0c" + key);
                }
            }
        }
        finally {
            if (psUpdate != null) {
                psUpdate.close();
            }
            if (psInsert != null) {
                psInsert.close();
            }
        }
    }

    protected void setRowLock(String sql, QueryArguments args) throws Throwable {
        try (PreparedStatement ps = null;){
            ps = this.prepareStatementJDBC(sql);
            int n = this.executeUpdate(ps, sql, args);
        }
    }

    public IDBManager getNewDBManager() throws Throwable {
        throw new Exception("\u8bf7\u4f7f\u7528context.newDBManager()");
    }

    public long getCurTime() throws Throwable {
        return System.currentTimeMillis();
    }

    public int getTimezoneOffset() throws Throwable {
        Calendar c = Calendar.getInstance();
        TimeZone timeZone = c.getTimeZone();
        return 0;
    }

    public Statement createUpdateStatement() throws Throwable {
        return this.createStatement();
    }

    public Statement createQueryStatement() throws Throwable {
        return this.createStatement();
    }

    public PreparedStatement preparedQueryStatement(String sql) throws Throwable {
        return this.prepareStatement(sql);
    }

    public PreparedStatement preparedUpdateStatement(String sql) throws Throwable {
        return this.prepareStatement(sql);
    }

    protected PreparedStatement prepareStatementJDBC(String sql) throws SQLException {
        int dbType = this.getDBType();
        sql = ConvertSqlByDBType.convertSql(sql, dbType, null);
        PreparedStatement statement = DBManagerUtil.isScrollInsensitive((int)dbType) ? this.connection.prepareStatement(sql, 1004, 1007) : this.connection.prepareStatement(sql);
        return statement;
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        PreparedStatement ps = cacheDBRequest.isUseCacheDB() ? new PreparedStatementWithLog(this, sql, cacheDBRequest) : this.prepareStatementJDBC(sql);
        return ps;
    }

    protected Statement createStatementJDBC() throws SQLException {
        int dbType = this.getDBType();
        Statement statement = DBManagerUtil.isScrollInsensitive((int)dbType) ? this.connection.createStatement(1004, 1007) : this.connection.createStatement();
        return statement;
    }

    private Statement createStatement() throws SQLException {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        Statement st = cacheDBRequest.isUseCacheDB() ? new StatementWithLog(this, cacheDBRequest) : this.createStatementJDBC();
        return st;
    }

    public PrepareSQL getCountString(String sql) {
        StringBuilder var2 = new StringBuilder(sql.length() + 100);
        PrepareSQL var3 = new PrepareSQL();
        var2.append("select count(1) totalCount from (");
        var2.append(sql);
        var2.append(") t");
        var3.setSQL(var2.toString());
        return var3;
    }

    public void initDataBaseInfo(DataBaseInfo info) throws Throwable {
        String sql = this.getTableStructSql();
        this.initDataBaseInfo(sql, arg_0 -> ((DataBaseInfo)info).initTable(arg_0));
        sql = this.getViewStructSql();
        this.initDataBaseInfo(sql, arg_0 -> ((DataBaseInfo)info).initView(arg_0));
        sql = this.getColumnStructSql();
        this.initDataBaseInfo(sql, arg_0 -> ((DataBaseInfo)info).initColumn(arg_0));
        sql = this.getIndexStructSql();
        this.initDataBaseInfo(sql, arg_0 -> ((DataBaseInfo)info).initIndex(arg_0));
    }

    private void initDataBaseInfo(String sql, IResultSetCallback callback) throws Throwable {
        PreparedStatement ps = null;
        ResultSet rset = null;
        try {
            ps = this.prepareStatement(sql);
            rset = this.executeQuery(ps, sql, null);
            callback.visit(rset);
        }
        finally {
            if (rset != null) {
                rset.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public boolean saveDataTable(DataTable dataTable, String tableName, MetaTable metaTable, Object causeCacheObject) throws SQLException {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        boolean result = cacheDBRequest.saveDataTable(dataTable, tableName, metaTable, causeCacheObject);
        return result;
    }

    public Object getCacheBillEntity(String formKey, Long oid) throws Throwable {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        return cacheDBRequest.getCacheBillEntity(formKey, oid);
    }

    public void cacheBillEntity(String formKey, Long oid, Object billEntity) {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        cacheDBRequest.cacheBillEntity(formKey, oid, billEntity);
    }

    public DataTable queryByOID(String tableKey, Long oid) throws Throwable {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        return cacheDBRequest.queryByOID(tableKey, oid);
    }

    public DataTable queryByWhereExpression(String tableKey, WhereExpressionForCache whereExpression, SortCriteria[] sorts) throws Throwable {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        return cacheDBRequest.queryByWhereExpression(tableKey, (IWhereExpression)whereExpression, sorts);
    }

    public void addPreLoadingArgument(String tableKey, WhereExpressionForCache whereExpressionForCache) throws Throwable {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        cacheDBRequest.addPreLoadingArgument(tableKey, (IWhereExpression)whereExpressionForCache);
    }

    public boolean stopLocalIsUseCacheDB() {
        ICacheDBRequest cacheDBRequest = this.getCacheDBRequest();
        return cacheDBRequest.stopLocalIsUseCacheDB();
    }

    public boolean hasOIDInCacheTable(String tableName, Long oid) throws Throwable {
        CacheDBRequest cacheDBRequest = (CacheDBRequest)this.getCacheDBRequest();
        CacheTable cacheTable = cacheDBRequest.cacheDB.getCacheTable(tableName, false);
        return cacheTable == null ? false : cacheTable.existOID(oid);
    }

    public boolean isNewInsertSOID(String tableName, Long soid) throws SQLException {
        CacheDBRequest cacheDBRequest = (CacheDBRequest)this.getCacheDBRequest();
        CacheDB cacheDB = cacheDBRequest.cacheDB;
        try {
            return cacheDB.isNewInsertSOID(tableName, soid);
        }
        catch (Throwable e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public boolean hasSOIDLoadAllInCacheTable(String tableName, Long soid) throws Throwable {
        CacheDBRequest cacheDBRequest = (CacheDBRequest)this.getCacheDBRequest();
        CacheDB cacheDB = cacheDBRequest.cacheDB;
        if (cacheDB.isNewInsertSOID(tableName, soid)) {
            return true;
        }
        CacheTable cacheTable = cacheDB.getCacheTable(tableName, false);
        return cacheTable == null ? false : cacheTable.existSOID(soid);
    }

    public Object getValueFromCacheTableByOID(String tableName, Long oid, String columnName) throws Throwable {
        CacheDBRequest cacheDBRequest = (CacheDBRequest)this.getCacheDBRequest();
        CacheTable cacheTable = cacheDBRequest.cacheDB.getCacheTable(tableName, false);
        if (cacheTable == null) {
            return null;
        }
        return cacheTable.getValueByOID(oid, columnName);
    }

    public Object getOrgValueFromCacheTableByOID(String tableName, Long oid, String columnName) throws Throwable {
        CacheDBRequest cacheDBRequest = (CacheDBRequest)this.getCacheDBRequest();
        CacheTable cacheTable = cacheDBRequest.cacheDB.getCacheTable(tableName, false);
        if (cacheTable == null) {
            return null;
        }
        return cacheTable.getOrgValueByOID(oid, columnName);
    }

    public Long[] getOIDsbySOID(String tableName, Long soid) throws Throwable {
        CacheDBRequest cacheDBRequest = (CacheDBRequest)this.getCacheDBRequest();
        CacheDB cacheDB = cacheDBRequest.cacheDB;
        CacheTable cacheTable = cacheDB.getCacheTable(tableName, false);
        if (cacheTable == null && cacheDB.isNewInsertSOID(tableName, soid)) {
            return ArrayUtils.EMPTY_LONG_OBJECT_ARRAY;
        }
        if (!cacheTable.existSOID(soid)) {
            cacheDB.isNewInsertSOID(tableName, soid);
        }
        return cacheTable.getOIDsBySOID(soid);
    }

    public boolean checkOIDInTable(String tableName, Long oid) throws Throwable {
        String sql = "SELECT OID FROM " + tableName + " WHERE " + "OID" + "=?";
        DataTable dataTable = this.execPrepareQuery(sql, oid);
        return dataTable.first();
    }

    public String getDBName() throws Throwable {
        return this.connection.getCatalog();
    }

    public String getDefaultValueString(int targetDataType, String defaultValue) {
        String sql = "";
        if (targetDataType != 1002 && targetDataType != 1012) {
            if (targetDataType == 1001 || targetDataType == 1005 || targetDataType == 1006 || targetDataType == 1007 || targetDataType == 1010) {
                if (StringUtil.isBlankOrNull((String)defaultValue)) {
                    sql = " DEFAULT 0 NOT NULL";
                } else {
                    sql = " DEFAULT ".concat(String.valueOf(defaultValue));
                    sql = String.valueOf(sql) + " NOT NULL";
                }
            }
        } else if (StringUtil.isBlankOrNull((String)defaultValue)) {
            sql = " DEFAULT '  ' NOT NULL";
        } else {
            sql = " DEFAULT '" + TypeConvertor.toDataType((int)targetDataType, (Object)defaultValue) + "'";
            sql = String.valueOf(sql) + " NOT NULL";
        }
        return sql;
    }

    public Statement createJDBCPrepareStatement(String sql) throws SQLException {
        return this.prepareStatementJDBC(sql);
    }

    public Statement createJDBCStatement() throws SQLException {
        return this.createStatementJDBC();
    }

    private static interface IResultSetCallback {
        public void visit(ResultSet var1) throws SQLException;
    }
}

