/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection;

import com.bokesoft.yes.mid.connection.MdbDSNGroupValues;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.Groups;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class MdbDSNItems
implements Iterable<MultiDBDSNItem> {
    public static final MdbDSNItems instance = new MdbDSNItems();
    private LinkedHashMap<String, MultiDBDSNItem> dsnMap = new LinkedHashMap();
    private MultiDBDSNItem defaultDSN = null;
    private MultiDBDSNItem defaultArchiveDSN;

    private MdbDSNItems() {
    }

    public void addDSNItem(MultiDBDSNItem item) {
        this.dsnMap.put(item.getName(), item);
    }

    public MultiDBDSNItem getDSNItem(String name) {
        return this.dsnMap.get(name);
    }

    public void setDefaultDSN(MultiDBDSNItem defaultDSN) {
        this.defaultDSN = defaultDSN;
    }

    public MultiDBDSNItem getDefaultDSN() {
        return this.defaultDSN;
    }

    public void setDefaultArchiveDSN(MultiDBDSNItem defaultArchiveDSN) {
        this.defaultArchiveDSN = defaultArchiveDSN;
    }

    public MultiDBDSNItem getDefaultArchiveDSN() {
        return this.defaultArchiveDSN;
    }

    @Override
    public Iterator<MultiDBDSNItem> iterator() {
        return this.dsnMap.values().iterator();
    }

    public boolean isEmpty() {
        return this.dsnMap.isEmpty();
    }

    public int getDSNItemSize() {
        return this.dsnMap.size();
    }

    public void clear() {
        if (this.dsnMap != null) {
            Groups groups = GroupConfig.instance.getGroups();
            for (Group group : groups) {
                group.clearDsn();
            }
            MultiDBDSNItem defaultDSNItem = this.getDefaultDSN();
            for (MultiDBDSNItem dsnItem : this) {
                if (dsnItem == defaultDSNItem) continue;
                for (MdbDSNGroupValues groupValues : dsnItem.getGroupValuesList()) {
                    groupValues.group.clearDsn();
                }
            }
        }
        this.dsnMap.clear();
        this.defaultDSN = null;
        this.defaultArchiveDSN = null;
    }
}

