/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.dev;

import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.util.concurrent.ConcurrentHashMap;

class MetaTableKeyIgnoreCase {
    final MetaTable metaTable;
    private final ConcurrentHashMap<String, MetaColumn> allKeys;
    String formKey;
    String dataObjectKey;
    private SqlString defaultSelect;
    private DataTableMetaData dataTableMetaDataCache;
    private SqlString columnNameCache;
    private int[] ignoreQueryColumnIndexesCache;

    MetaTableKeyIgnoreCase(String key, String dataObjectKey, String formKey) {
        this.metaTable = new MetaTable();
        this.allKeys = new ConcurrentHashMap();
        this.metaTable.setKey(key.intern());
        this.dataObjectKey = dataObjectKey.intern();
        this.formKey = formKey.intern();
    }

    MetaTableKeyIgnoreCase(MetaTable metaTable) {
        this.metaTable = metaTable;
        this.allKeys = new ConcurrentHashMap();
        for (MetaColumn metaColumn : metaTable) {
            String key = metaColumn.getKey();
            this.allKeys.put(key.toLowerCase().intern(), metaColumn);
        }
    }

    public int[] getIgnoreQueryColumnIndexesCache() {
        return this.ignoreQueryColumnIndexesCache;
    }

    public void setIgnoreQueryColumnIndexesCache(int[] ignoreQueryColumnIndexesCache) {
        this.ignoreQueryColumnIndexesCache = ignoreQueryColumnIndexesCache;
    }

    public SqlString getColumnNameCache() {
        return this.columnNameCache;
    }

    public void setColumnNameCache(SqlString columnNameCache) {
        this.columnNameCache = columnNameCache;
    }

    public SqlString getDefaultSelect() {
        return this.defaultSelect;
    }

    public void setDefaultSelect(SqlString defaultSelect) {
        this.defaultSelect = defaultSelect;
    }

    public DataTableMetaData getDataTableMetaDataCache() {
        return this.dataTableMetaDataCache;
    }

    public void setDataTableMetaDataCache(DataTableMetaData dataTableMetaDataCache) {
        this.dataTableMetaDataCache = dataTableMetaDataCache;
    }

    public String getKeyCaseSameInTable(String key) {
        MetaColumn column = this.allKeys.get(key.toLowerCase());
        return column == null ? key : column.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(MetaColumn column) {
        String key = column.getKey();
        boolean exist = this.allKeys.containsKey(key.toLowerCase());
        if (!exist) {
            this.allKeys.put(key.toLowerCase().intern(), column);
        }
        MetaTable metaTable = this.metaTable;
        synchronized (metaTable) {
            if (!this.metaTable.containsKey(column.getKey())) {
                this.metaTable.add((KeyPairMetaObject)column);
            }
        }
    }

    public boolean containsColumn(String columnName) {
        return this.allKeys.containsKey(columnName.toLowerCase());
    }

    public MetaColumn getColumn(String columnName) {
        return this.allKeys.get(columnName.toLowerCase());
    }
}

