/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.datastruct.metaload.ColumnExp;
import com.bokesoft.yes.datastruct.metaload.Point;
import com.bokesoft.yes.datastruct.metaload.Points;
import com.bokesoft.yes.datastruct.metaload.ValueRange;

class Interval
extends ValueRange {
    final Object leftValue;
    final boolean isLeftClosed;
    final Object rightValue;
    final boolean isRightClosed;

    public Interval(Object leftValue, boolean isLeftClosed, Object rightValue, boolean isRightClosed, int dataType) {
        super(dataType);
        this.leftValue = leftValue;
        this.isLeftClosed = isLeftClosed;
        this.rightValue = rightValue;
        this.isRightClosed = isRightClosed;
    }

    private boolean isAPoint() {
        return Interval.compare(this.leftValue, this.rightValue, this.dataType) == 0 && this.isLeftClosed && this.isRightClosed;
    }

    private boolean isInvalidInterval() {
        if (this.leftValue != null && this.rightValue != null) {
            int compare = Interval.compare(this.leftValue, this.rightValue, this.dataType);
            return compare > 0 || compare == 0 && (!this.isLeftClosed || !this.isRightClosed);
        }
        return false;
    }

    @Override
    public boolean isIntersect(ValueRange valueRange) {
        if (valueRange == null) {
            throw new AssertionError((Object)"\u6bd4\u8f83\u9519\u8bef\u3002");
        }
        if (this.isInvalidInterval()) {
            return false;
        }
        if (this.dataType != valueRange.dataType) {
            throw new AssertionError((Object)"\u6bd4\u8f83\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002");
        }
        if (valueRange instanceof Point) {
            Point point = (Point)valueRange;
            if (point.isNotEqual) {
                return !this.isAPoint() || Interval.compare(this.leftValue, point.value, this.dataType) != 0;
            }
            return this.isIntersectValue(point.value);
        }
        if (valueRange instanceof Points) {
            Object[] objectArray = ((Points)valueRange).values;
            int n = ((Points)valueRange).values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                if (this.isIntersectValue(value)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (valueRange instanceof Interval) {
            Interval interval = (Interval)valueRange;
            if (interval.isInvalidInterval()) {
                return false;
            }
            if (interval.isAPoint()) {
                return this.isIntersectValue(interval.leftValue);
            }
            if (interval.leftValue instanceof ColumnExp) {
                return interval.leftValue != this.rightValue || interval.isLeftClosed && this.isRightClosed;
            }
            if (interval.rightValue instanceof ColumnExp) {
                return interval.rightValue != this.leftValue || interval.isRightClosed && this.isLeftClosed;
            }
            if (this.leftValue instanceof ColumnExp || this.rightValue instanceof ColumnExp) {
                return true;
            }
            if (this.leftValue == null && interval.leftValue == null || this.rightValue == null && interval.rightValue == null) {
                return true;
            }
            if (this.leftValue == null && interval.rightValue == null) {
                int compare = Interval.compare(this.rightValue, interval.leftValue, this.dataType);
                return compare > 0 || compare == 0 && this.isRightClosed && interval.isLeftClosed;
            }
            if (this.rightValue == null && interval.leftValue == null) {
                int compare = Interval.compare(this.leftValue, interval.rightValue, this.dataType);
                return compare > 0 || compare == 0 && (!this.isLeftClosed || !interval.isRightClosed);
            }
            int compareLeftRight = Interval.compare(this.leftValue, interval.rightValue, this.dataType);
            int compareRightLeft = Interval.compare(this.rightValue, interval.leftValue, this.dataType);
            return compareLeftRight < 0 && compareRightLeft > 0 || compareLeftRight == 0 && this.isLeftClosed && interval.isRightClosed || compareRightLeft == 0 && this.isRightClosed && interval.isLeftClosed;
        }
        throw new AssertionError((Object)("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff0c" + valueRange.getClass().getName()));
    }

    private boolean isIntersectValue(Object value) {
        if (value instanceof ColumnExp) {
            return this.leftValue == value && this.isLeftClosed || this.rightValue == value && this.isRightClosed;
        }
        if (this.leftValue instanceof ColumnExp || this.rightValue instanceof ColumnExp) {
            return false;
        }
        if (this.leftValue != null) {
            int compareLeft = Interval.compare(this.leftValue, value, this.dataType);
            if (this.isLeftClosed ? compareLeft > 0 : compareLeft >= 0) {
                return false;
            }
        }
        if (this.rightValue != null) {
            int compareRight = Interval.compare(this.rightValue, value, this.dataType);
            if (this.isRightClosed ? compareRight < 0 : compareRight <= 0) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.isLeftClosed ? "[" : "(") + (this.leftValue == null ? "" : String.valueOf(this.leftValue)) + ", " + (this.rightValue == null ? "" : String.valueOf(this.rightValue)) + (this.isRightClosed ? "]" : ")");
    }
}

