/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct;

import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.yes.datastruct.DataStructSourceToolKit;
import com.bokesoft.yes.datastruct.DataStructToolKit;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumnCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLException;

public class ReMigrate {
    public static void reMigrate(DefaultContext context, DataStructToolKit struct) throws Throwable {
        MetaTable relationTable = struct.getRelationTable();
        if (relationTable == null) {
            return;
        }
        IDBManager dbManager = context.getDBManager();
        try (IDBManager dbManager4Lock = null;){
            dbManager4Lock = context.newDBManager();
            dbManager4Lock.setRowLockEnsureInSYSLock("DataStructReMigration:" + struct.meta.getKey());
            try {
                dbManager.execUpdate("drop table " + relationTable.getKey());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ERPSchemaProcess schemaProcess = new ERPSchemaProcess(dbManager);
            schemaProcess.tableRebuild(dbManager, ReMigrate.getSchemaTable(relationTable));
            DataStructSourceToolKit[] dataStructSourceToolKitArray = struct.getSources();
            int n = dataStructSourceToolKitArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataStructSourceToolKit source = dataStructSourceToolKitArray[n2];
                ReMigrate.reMigrate(context, struct, source);
                ++n2;
            }
            dbManager.commit();
        }
    }

    private static MetaSchemaTable getSchemaTable(MetaTable metaTable) {
        MetaSchemaTable table = new MetaSchemaTable();
        table.setKey(metaTable.getBindingDBTableName());
        String primaryKey = metaTable.getPrimaryKey();
        if (primaryKey != null && !primaryKey.isEmpty()) {
            table.setPrimaryKey(primaryKey);
        }
        table.setCaption(metaTable.getCaption());
        MetaSchemaColumnCollection columnCollection = table.getColumnCollection();
        MetaIndexCollection indexCollection = table.getIndexCollection();
        String indexPrefix = metaTable.getIndexPrefix4Create();
        for (MetaColumn column : metaTable) {
            MetaSchemaColumn schemaColumn = new MetaSchemaColumn();
            schemaColumn.setKey(column.getBindingDBColumnName());
            schemaColumn.setCaption(column.getCaption());
            schemaColumn.setDataType(column.getDataType().intValue());
            schemaColumn.setPrecision(column.getPrecision());
            schemaColumn.setScale(column.getScale());
            schemaColumn.setLength(column.getLength());
            schemaColumn.setAutoGen(column.isAutoGen());
            columnCollection.add((KeyPairMetaObject)schemaColumn);
        }
        MetaSchemaColumn slockColumn = new MetaSchemaColumn();
        slockColumn.setKey("Slock");
        slockColumn.setDataType(1001);
        columnCollection.add((KeyPairMetaObject)slockColumn);
        MetaColumn SOIDColumn = metaTable.getSOIDColumn();
        if (SOIDColumn != null) {
            MetaIndex index = new MetaIndex();
            index.setKey(String.valueOf(indexPrefix) + "HIS_SOID_HVER");
            index.setColumns(String.valueOf(SOIDColumn.getBindingDBColumnName()) + "," + "HVER");
            indexCollection.add((KeyPairMetaObject)index);
        }
        return table;
    }

    private static void reMigrate(DefaultContext context, DataStructToolKit struct, DataStructSourceToolKit source) throws Throwable {
        SqlString relationLoadSql = source.getRelationLoadSql();
        DataTable dt = context.getDBManager().execPrepareQuery(relationLoadSql.getSql(), relationLoadSql.getParameterList());
        String insertSql = struct.getInsertRelationSql();
        DataTableBatchPsPara batchPsPara = new DataTableBatchPsPara(insertSql, dt, struct.getInsertRelationSqlArgumentSize());
        context.getDBManager().executeUpdate((BatchPsPara)batchPsPara);
        context.getDBManager().commit();
    }
}

