/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct;

import com.bokesoft.yes.datastruct.DataStructSourceToolKit;
import com.bokesoft.yes.datastruct.meta.MetaDataStruct;
import com.bokesoft.yes.datastruct.meta.MetaDataStructColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSource;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.util.Iterator;

public class DataStructToolKit {
    public static final String STR_DataStructSource_ColumnName = "DataStructSource";
    public static final int INT_DataStructSource_ColumnIndex = 2;
    final MetaDataStruct meta;
    final MetaDataStructSource[] metaSources;
    private MetaTable relationTable;
    private DataStructSourceToolKit[] sources;
    private String insertRelationSql;
    private String loadRelationSql;

    public DataStructToolKit(MetaDataStruct meta, MetaDataStructSource[] metaSources) {
        this.meta = meta;
        this.metaSources = metaSources;
    }

    public MetaTable getRelationTable() {
        String relationTableName = this.meta.getRelationTableName();
        if (this.relationTable == null && relationTableName != null && relationTableName.length() > 0) {
            MetaTable relation = new MetaTable();
            relation.setKey(relationTableName);
            relation.setCaption(this.meta.getCaption());
            Iterator iterator = this.meta.getColumnCollection().iterator();
            while (iterator.hasNext()) {
                MetaDataStructColumn column = (MetaDataStructColumn)iterator.next();
                MetaColumn metaColumn = new MetaColumn();
                metaColumn.setKey(column.getKey());
                if (column.isKeyField()) {
                    metaColumn.setDataType(Integer.valueOf(1010));
                } else {
                    if (column.getDataType() == -1) {
                        column.setDataType(1010);
                    }
                    metaColumn.setDataType(Integer.valueOf(column.getDataType()));
                    metaColumn.setLength(Integer.valueOf(column.getLength()));
                    metaColumn.setPrecision(Integer.valueOf(column.getPrecision()));
                    metaColumn.setScale(Integer.valueOf(column.getScale()));
                }
                relation.add((KeyPairMetaObject)metaColumn);
            }
            MetaColumn oid = new MetaColumn();
            oid.setKey("OID");
            oid.setDataType(Integer.valueOf(1010));
            relation.add((KeyPairMetaObject)oid);
            MetaColumn verid = new MetaColumn();
            verid.setKey("VERID");
            verid.setDataType(Integer.valueOf(1001));
            relation.add((KeyPairMetaObject)verid);
            MetaColumn sourceKey = new MetaColumn();
            sourceKey.setKey(STR_DataStructSource_ColumnName);
            sourceKey.setDataType(Integer.valueOf(1002));
            sourceKey.setLength(Integer.valueOf(50));
            relation.add((KeyPairMetaObject)sourceKey);
            this.relationTable = relation;
        }
        return this.relationTable;
    }

    public DataStructSourceToolKit[] getSources() {
        if (this.sources == null) {
            int size = this.metaSources.length;
            DataStructSourceToolKit[] tmps = new DataStructSourceToolKit[size];
            int i = 0;
            while (i < size) {
                tmps[i] = new DataStructSourceToolKit(this, this.metaSources[i]);
                ++i;
            }
            this.sources = tmps;
        }
        return this.sources;
    }

    public DataStructSourceToolKit getSource(String dataStructSourceKey) {
        int i = 0;
        int size = this.metaSources.length;
        while (i < size) {
            if (this.metaSources[i].getKey().equals(dataStructSourceKey)) break;
            ++i;
        }
        if (i >= size) {
            throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + dataStructSourceKey + "\u672a\u627e\u5230\u3002"));
        }
        return this.getSources()[i];
    }

    public int getInsertRelationSqlArgumentSize() {
        return this.meta.getColumnCollection().size() + 3;
    }

    public String getInsertRelationSql() {
        if (this.insertRelationSql == null) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("insert into ").append(this.meta.getRelationTableName()).append("(OID,VERID,DataStructSource");
            Iterator iterator = this.meta.getColumnCollection().iterator();
            while (iterator.hasNext()) {
                MetaDataStructColumn column = (MetaDataStructColumn)iterator.next();
                sb.append(",").append(column.getKey());
            }
            sb.append(")").append(" VALUES ").append("(?,?,?");
            int i = 0;
            int size = this.meta.getColumnCollection().size();
            while (i < size) {
                sb.append(",?");
                ++i;
            }
            sb.append(")");
            this.insertRelationSql = sb.toString();
        }
        return this.insertRelationSql;
    }

    public Object getLoadRelationDataSql() {
        if (this.loadRelationSql == null) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("SELECT ").append("OID, VERID, DataStructSource");
            Iterator iterator = this.meta.getColumnCollection().iterator();
            while (iterator.hasNext()) {
                MetaDataStructColumn column = (MetaDataStructColumn)iterator.next();
                sb.append(", ").append(column.getKey());
            }
            sb.append(" FROM ").append(this.meta.getRelationTableName());
            this.loadRelationSql = sb.toString();
        }
        return this.loadRelationSql;
    }
}

