/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.util;

import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.erp.mid.schema.ERPSchemaViewDependSchemaTable;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.dbstruct.RuntimeDDL;
import com.bokesoft.yes.mid.mysqls.group.DataObjectRelationTable;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.Groups;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class EnsureSingleDBStruct
extends Thread {
    private String dsnName;
    private Groups groups;
    private DBStruct dbStruct;
    private CountDownLatch countDownLatch;

    public EnsureSingleDBStruct(String dsnName, Groups groups, DBStruct dbStruct, CountDownLatch countDownLatch) {
        this.dsnName = dsnName;
        this.groups = groups;
        this.dbStruct = dbStruct;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        IDBManager subDBManager = null;
        try {
            try {
                subDBManager = MultiDBManager.createDBManager(this.dsnName);
                ERPSchemaProcess schemaProcess = new ERPSchemaProcess(subDBManager);
                Object[] actions = new Object[]{"\u786e\u8ba4\u6570\u636e\u5e93\u7ed3\u6784:", this.dsnName};
                int action = Performance.startAction((Object[])actions);
                for (Group group : this.groups) {
                    boolean containCurDSNName = group.containsDSNName(this.dsnName);
                    if (!containCurDSNName) continue;
                    for (Map.Entry<String, GroupTable> entry : group.getDefTableNams().entrySet()) {
                        String tableName = entry.getKey();
                        this.dbStruct.ensureTableName(subDBManager, this.dsnName, tableName, schemaProcess);
                        List<MetaDataObject> dataObjects = DataObjects.getInstance().getDataObjectsByTableName(tableName);
                        if (dataObjects == null) continue;
                        for (MetaDataObject dataObject : dataObjects) {
                            for (MetaTable metaTableOther : dataObject.getTableCollection()) {
                                String tableNameOther;
                                if (!metaTableOther.isPersist().booleanValue() || (tableNameOther = metaTableOther.getBindingDBTableName()).equalsIgnoreCase(tableName)) continue;
                                this.dbStruct.ensureTableName(subDBManager, this.dsnName, tableNameOther, schemaProcess);
                            }
                            if (dataObject.getSecondaryType() == 6 && dataObject.getMigrationUpdateStrategy() == 5) {
                                this.dbStruct.ensureTableName(subDBManager, this.dsnName, dataObject.getErpMigrationNewTable().getKey(), schemaProcess);
                                this.dbStruct.ensureTableName(subDBManager, this.dsnName, dataObject.getErpMigrationIncrTable().getKey(), schemaProcess);
                                this.dbStruct.ensureTableName(subDBManager, this.dsnName, dataObject.getErpMigrationKeysTable().getKey(), schemaProcess);
                                this.dbStruct.ensureTableName(subDBManager, this.dsnName, dataObject.getErpMigrationKeysPreTable().getKey(), schemaProcess);
                                this.dbStruct.ensureTableName(subDBManager, this.dsnName, dataObject.getErpMigrationNewPreTable().getKey(), schemaProcess);
                                MetaTable table = dataObject.getMigrationLastPointTable();
                                if (table != null) {
                                    this.dbStruct.ensureTableName(subDBManager, this.dsnName, table.getKey(), schemaProcess);
                                }
                                ERPSchemaViewDependSchemaTable views = new ERPSchemaViewDependSchemaTable(dataObject);
                                this.dbStruct.ensureViewName(this.dsnName, views);
                            }
                            String dataObjectKey = dataObject.getKey();
                            DataObjectRelationTable[] dataObjectRelationTableArray = GroupConfig.instance.getDataObjectRelationTables();
                            int n = dataObjectRelationTableArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DataObjectRelationTable dataObjectRelationTable = dataObjectRelationTableArray[n2];
                                if (dataObjectRelationTable.maybeHasDataObject(dataObjectKey)) {
                                    this.dbStruct.ensureTableName(subDBManager, this.dsnName, dataObjectRelationTable.name, schemaProcess);
                                }
                                ++n2;
                            }
                        }
                    }
                    for (HeadDetailTable headDetailTable : group.getDetailTableExtras()) {
                        this.dbStruct.ensureTableName(subDBManager, this.dsnName, headDetailTable.detailTableName, schemaProcess);
                    }
                }
                subDBManager.commit();
                Performance.endActive((int)action, (Object[])actions);
            }
            catch (Throwable e) {
                try {
                    subDBManager.rollback();
                    LogSvr.getInstance().error("\u786e\u8ba4\u6570\u636e\u5e93\u8868\u7ed3\u6784\u5931\u8d25,dsnName=" + this.dsnName, e);
                }
                catch (SQLException ex) {
                    LogSvr.getInstance().error("\u786e\u8ba4\u6570\u636e\u5e93\u8868\u7ed3\u6784\u5931\u8d25\u65f6\u56de\u6eda\u9519\u8bef,dsnName=" + this.dsnName, e);
                }
                try {
                    subDBManager.close();
                    this.countDownLatch.countDown();
                }
                catch (SQLException e2) {
                    LogSvr.getInstance().error("\u5173\u95eddbManager\u5931\u8d25,dsnName=" + this.dsnName, (Throwable)e2);
                }
            }
        }
        finally {
            try {
                subDBManager.close();
                this.countDownLatch.countDown();
            }
            catch (SQLException e) {
                LogSvr.getInstance().error("\u5173\u95eddbManager\u5931\u8d25,dsnName=" + this.dsnName, (Throwable)e);
            }
        }
    }

    public static void buildTablesDataObject(MetaDataObject dataObject, MultiDBManager dbManager) throws Throwable {
        String[] dsns;
        if (StringUtil.isBlankOrNull((String)dataObject.getMainTableKey())) {
            return;
        }
        String tableName = dataObject.getMainTableKey();
        MdbDSNItems dsnCollection = MdbDSNItems.instance;
        Groups groups = GroupConfig.instance.getGroups();
        String[] stringArray = dsns = groups.getDSNNamesByTableName(tableName);
        int n = dsns.length;
        int n2 = 0;
        while (n2 < n) {
            String dsnName = stringArray[n2];
            if (!dsnName.equalsIgnoreCase(dsnCollection.getDefaultDSN().getName())) {
                try (IDBManager subDBM = null;){
                    subDBM = MultiDBManager.createDBManager(dsnName);
                    ERPSchemaProcess schemaProcess = new ERPSchemaProcess(dbManager);
                    RuntimeDDL.updateTableStruct(subDBM, dataObject, dsnName, dbManager.getDBStruct(), schemaProcess);
                    subDBM.commit();
                }
            }
            ++n2;
        }
    }
}

