/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.util;

import com.bokesoft.erp.mid.util.ArchiveDBUtil;
import com.bokesoft.erp.mid.util.EnsureSingleArchiveDBStruct;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.connection.ArchiveDBDSNItem;
import com.bokesoft.yes.mid.connection.ArchiveDSNItems;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.start.IStartListener;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EnsureArchiveDBStruct
implements IStartListener {
    public void invoke(DefaultContext context) throws Throwable {
        if (!ServerSetting.getInstance().isMaster()) {
            return;
        }
        DefaultContext newContext = null;
        int action = -1;
        Object[] actions = new Object[]{"EnsureDBStruct"};
        try {
            action = Performance.startFirstAction((Object[])actions);
            newContext = new DefaultContext(context.getVE());
            IDBManager dbManager = newContext.getDBManager();
            DataTable tmp = dbManager.execPrepareQuery("SELECT UniqueKey FROM sys_lock where UniqueKey=?", new Object[]{"SYS_Lock_GlobalKey"});
            if (tmp == null || tmp.size() == 0) {
                dbManager.execPrepareUpdate("INSERT INTO sys_lock (UniqueKey) values (?)", new Object[]{"SYS_Lock_GlobalKey"});
            }
            this.processEnsureDBStruct(newContext);
            newContext.commit();
        }
        finally {
            if (newContext != null) {
                newContext.close();
            }
            Performance.endActive((int)action, (Object[])actions);
            Performance.printLog();
        }
    }

    public void processEnsureDBStruct(DefaultContext context) throws Throwable {
        ArchiveDSNItems dsnCollection = ArchiveDSNItems.instance;
        if (!ArchiveDBUtil.isEnsureArchive()) {
            return;
        }
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        CountDownLatch countDownLatch = new CountDownLatch(dsnCollection.getDSNItemSize() - 1);
        for (ArchiveDBDSNItem dbdsnItem : dsnCollection) {
            String dsnName = dbdsnItem.getName();
            if (StringUtil.isBlankOrNull((String)dsnName)) continue;
            executorService.submit(new EnsureSingleArchiveDBStruct(context, dsnName, countDownLatch));
        }
        executorService.shutdown();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

