/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.index;

import net.boke.jsqlparser.parser.CCJSqlParserManager;
import net.boke.jsqlparser.statement.create.index.CreateIndex;
import org.apache.commons.lang3.StringUtils;

public class TableIndex {
    public final String name;
    public final String sql;
    private String tableName;
    private String columns;
    private Boolean isUnique;
    private CreateIndex parsedStatement;

    public TableIndex(String name, String sql) {
        this.name = name;
        this.sql = sql;
    }

    public String getTableName() throws Throwable {
        if (this.tableName == null) {
            CreateIndex statement = this.getParsedStatement();
            this.tableName = statement.getTable().getName();
        }
        return this.tableName;
    }

    private CreateIndex getParsedStatement() throws Throwable {
        if (this.parsedStatement == null) {
            CreateIndex statement;
            CCJSqlParserManager parser = new CCJSqlParserManager();
            this.parsedStatement = statement = (CreateIndex)parser.parse(this.sql);
        }
        return this.parsedStatement;
    }

    public String getColumns() throws Throwable {
        if (this.columns == null) {
            CreateIndex statement = this.getParsedStatement();
            this.columns = StringUtils.join(statement.getColumns(), (String)",");
        }
        return this.columns;
    }

    public Boolean isUnique() throws Throwable {
        if (this.isUnique == null) {
            CreateIndex statement = this.getParsedStatement();
            this.isUnique = statement.isUnique();
        }
        return this.isUnique;
    }

    public String getName() {
        return this.name;
    }

    public String getSql() {
        return this.sql;
    }
}

