/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.index;

import com.bokesoft.erp.index.TableIndex;
import com.bokesoft.erp.index.TableIndexes;
import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ERPCreateIndex
implements IStartListener {
    private static Logger logger = LoggerFactory.getLogger(ERPCreateIndex.class);
    private static boolean createIndex = true;
    private static TableIndexes tableIndexes;

    public static void setCreateIndex(boolean createIndex) {
        ERPCreateIndex.createIndex = createIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TableIndexes getTableIndexes() {
        if (tableIndexes != null) return tableIndexes;
        Class<ERPCreateIndex> clazz = ERPCreateIndex.class;
        synchronized (ERPCreateIndex.class) {
            if (tableIndexes != null) return tableIndexes;
            TableIndexes tmpTableIndexes = new TableIndexes();
            IMetaFactory metaFactor = MetaFactory.getGlobalInstance();
            List projectKeys = metaFactor.getProjectKeys();
            for (String key : projectKeys) {
                try {
                    InputStream inputStream = metaFactor.getProjectResolver(key).read("Createindex.xml", 1);
                    if (inputStream == null) continue;
                    ERPCreateIndex.readXML(tmpTableIndexes, inputStream);
                }
                catch (Throwable throwable) {
                    logger.error("Createindex.xml \u6587\u4ef6\u83b7\u53d6\u5931\u8d25");
                }
            }
            tableIndexes = tmpTableIndexes;
            // ** MonitorExit[var0] (shouldn't be in output)
            return tableIndexes;
        }
    }

    public void invoke(DefaultContext defaultContext) throws Throwable {
        ServerSetting setting = ServerSetting.getInstance();
        if (!setting.isMaster()) {
            return;
        }
        if (!createIndex) {
            return;
        }
        this.createIndex(defaultContext);
    }

    private static void readXML(TableIndexes tmpTableIndexes, InputStream inputStream) throws Throwable {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            if (document == null) {
                return;
            }
            Element rootElement = document.getDocumentElement();
            NodeList nodeList = rootElement.getElementsByTagName("TableIndex");
            if (nodeList != null && nodeList.getLength() > 0) {
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() == 1) {
                        NamedNodeMap nodeMap = node.getAttributes();
                        Node nameNode = nodeMap.getNamedItem("indexname");
                        Node sqlNode = nodeMap.getNamedItem("indexsql");
                        if (nameNode != null && sqlNode != null) {
                            String indexName = nameNode.getNodeValue();
                            String indexSql = sqlNode.getNodeValue();
                            if (indexName != null && indexSql != null) {
                                tmpTableIndexes.add(new TableIndex(indexName, indexSql));
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error("xml\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
        }
    }

    private void createIndex(DefaultContext context) throws Throwable {
        logger.debug("\u521b\u5efa\u7d22\u5f15\u5f00\u59cb");
        IDBManager dbm = context.getDBManager();
        ERPSchemaProcess schemaProcess = new ERPSchemaProcess(dbm);
        for (TableIndex tableIndex : ERPCreateIndex.getTableIndexes()) {
            ERPCreateIndex.createIndex(dbm, schemaProcess, tableIndex);
        }
        logger.debug("\u521b\u5efa\u7d22\u5f15\u7ed3\u675f");
    }

    public static void createIndex(IDBManager dbm, ERPSchemaProcess schemaProcess, String indexName, String indexSql) throws Throwable {
        ERPCreateIndex.createIndex(dbm, schemaProcess, new TableIndex(indexName, indexSql));
    }

    public static void createIndex(IDBManager dbm, ERPSchemaProcess schemaProcess, TableIndex index) throws Throwable {
        String tableName = index.getTableName();
        String indexName = index.getName();
        String indexSql = index.getSql();
        if (ERPCreateIndex.checkIndexExist(schemaProcess, tableName, indexName)) {
            if (ERPCreateIndex.checkIndexChanged(schemaProcess, index)) {
                schemaProcess.dropIndex(dbm, tableName, indexName);
            } else {
                return;
            }
        }
        dbm.execPrepareUpdate(indexSql, new Object[0]);
        MetaIndex metaIndex = ERPCreateIndex.parseToMetaIndex(index);
        schemaProcess.getInfo().updateIndexInfo(tableName, Arrays.asList(metaIndex));
        schemaProcess.getInfo().getIndexSet(tableName).add(indexName);
        if (DBManagerUtil.isEsgynDBLikeDatabase((int)dbm.getDBType())) {
            dbm.commit();
        }
    }

    private static MetaIndex parseToMetaIndex(TableIndex index) throws Throwable {
        MetaIndex metaIndex = new MetaIndex();
        metaIndex.setColumns(index.getColumns());
        metaIndex.setKey(index.getName());
        metaIndex.setUnique(index.isUnique());
        return metaIndex;
    }

    private static boolean checkIndexChanged(ERPSchemaProcess schemaProcess, TableIndex index) throws Throwable {
        DataBaseInfo info = schemaProcess.getInfo();
        String tableKey = index.getTableName().toUpperCase();
        String indexName = index.getName().toUpperCase();
        String indexColumns = index.getColumns().toUpperCase();
        Boolean isUnique2Create = index.isUnique();
        if (!info.checkTableExist(tableKey)) {
            return false;
        }
        HashMap indexColumnSet = info.getIndexColumnSet(tableKey);
        String indexColumnInDB = (String)indexColumnSet.get(indexName);
        if (StringUtils.isBlank((CharSequence)indexColumnInDB)) {
            return true;
        }
        HashMap uniqueIndexSet = info.getUniqueIndexSet(tableKey);
        Boolean isUniqueInDB = (Boolean)uniqueIndexSet.get(indexName);
        if (!isUnique2Create.equals(isUniqueInDB)) {
            return true;
        }
        return !indexColumnInDB.equalsIgnoreCase(indexColumns);
    }

    public static boolean checkIndexExist(ERPSchemaProcess schemaProcess, String tableName, String indexName) {
        DataBaseInfo info = schemaProcess.getInfo();
        if (!info.checkTableExist(tableName)) {
            return false;
        }
        HashSet indexSet = info.getIndexSet(tableName);
        for (String index : indexSet) {
            if (!index.equalsIgnoreCase(indexName)) continue;
            return true;
        }
        return false;
    }
}

