(function () {
    var completed = function (fn) {
        window.removeEventListener("load", fn);
        document.removeEventListener("DOMContentLoaded", completed);
        fn();
    };
    //DOMContentLoaded监听来替代$.ready(),不支持的仍用window.onload
    document.ready = function (cb) {
        window.addEventListener("load", cb);
        document.addEventListener("DOMContentLoaded", function () {
            completed(cb);
        });
    };

    //添加一些方法替代jq的dom方法

    HTMLElement.prototype.isShow = function () {
        return getComputedStyle(this).display !== "none";
    };

    HTMLElement.prototype.hide = function () {
        this.style.display = "none";
        return this;
    };

    HTMLElement.prototype.show = function (display) {
        this.style.display = display || "block";
        return this;
    };

    // HTMLElement.prototype.remove = function () {
    //     this.parentNode.removeChild(this);
    // };

    Node.prototype.hasClass = HTMLElement.prototype.hasClass = function (classname) {
        return this.classList.contains(classname);
    };

    Node.prototype.addClass = HTMLElement.prototype.addClass = function (classname) {
        return classHandle.call(this, "add", classname);
    };

    Node.prototype.removeClass = HTMLElement.prototype.removeClass = function (classname) {
        return classHandle.call(this, "remove", classname);
    };

    Node.prototype.toggleClass = HTMLElement.prototype.toggleClass = function (selector) {
        this.classList.toggle(selector);
        return this;
    };

    Node.prototype.css = HTMLElement.prototype.css = function (key, val) {
        if (typeof key === "string") {
            if (val !== undefined) {
                this.style[key] = val;
            } else {
                return getComputedStyle(this)[key];
            }
        } else if (typeof key === "object") {
            for (let k in key) {
                this.style[k] = key[k];
            }
        }
        return this;
    };

    function classHandle(eventTpye, classname) {
        var _this = this;
        if (classname.trim().indexOf(" ") > -1) {
            classname.split(" ").forEach(function (name) {
                _this.classList[eventTpye](name);
            });
        } else {
            _this.classList[eventTpye](classname);
        }
        return _this;
    }

    HTMLElement.prototype.height = function () {
        if (getComputedStyle(this).display !== "none") return this.offsetHeight;
        var cssText = this.style.cssText;
        this.style.cssText +=
            "position:fixed;;left:-9999px;display:block;visibility:hidden";
        var height = this.offsetHeight;
        this.style.cssText = cssText;
        return height;
    };
    HTMLElement.prototype.width = function () {
        if (getComputedStyle(this).display !== "none") return this.offsetWidth;
        var cssText = this.style.cssText;
        this.style.cssText +=
            "position:fixed;;top:-9999px;display:block;visibility:hidden";
        var width = this.offsetWidth;
        this.style.cssText = cssText;
        return width;
    };
    /**
     * @description: 判断有否滚动条出现,默认Y轴
     * @param {string} axis 'x' 或 'y'
     * @return {boolen}
     */
    HTMLElement.prototype.hasScrollbar = function (axis) {
        var dir = axis === "x" ? "scrollLeft" : "scrollTop";
        if (this[dir] > 0) return true;
        this[dir] = 1;
        var x = this[dir];
        this[dir] = 0;
        return x > 0;
    };

    // HTMLElement.prototype.slideDown = async function (fn) {
    //     await SlideElement.down(this);
    //     fn && fn.call(this)
    //     return this;
    // };

    // HTMLElement.prototype.slideUp = async function (fn) {
    //     await SlideElement.up(this);
    //     fn && fn.call(this)
    //     return this;
    // };

    HTMLElement.prototype.slideDown = function (fn) {
        var display = getComputedStyle(this).display;
        var speed = 300;
        if (display !== "none" || this.attr("isMoving")) return this;
        var csstext = this.style.cssText;
        var height = this.height() + "px";
        this.css({ height: 0, display: "block", transition: "height " + speed + "ms" });
        this.attr("isMoving", true);
        setTimeout(() => {
            this.css("height", height);
            
        });
        setTimeout(() => endHandel.call(this),speed);

        function endHandel() {
            this.removeAttribute("isMoving");
            this.style.cssText = csstext + "display:block;"
            fn && fn.call(this);
        }
        return this;
    };

    HTMLElement.prototype.slideUp = async function (fn) {
        if (getComputedStyle(this).display === "none" || this.attr("isMoving"))
            return this;
        var speed = 300;
        var csstext = this.style.cssText;
        var height = this.height() + "px";
        this.css({ transition: "height " + speed+ "ms", height: height });
        this.attr("isMoving", true);
        setTimeout(() => {
            this.css({ height: 0 });
        });
        setTimeout(() => {
            endHandel.call(this);
        },speed);
        function endHandel() {
            this.removeAttribute("isMoving");
            this.style.cssText = csstext + "display:none;"
            fn && fn.call(this);
        }
        return this;
    };

    // HTMLElement.prototype.slideDown = function (fn) {
    //     var display = getComputedStyle(this).display;
    //     if (display !== "none" || this.attr("isMoving")) return this;

    //     if (this.animate) {
    //         (async () => {
    //             var height = this.height() + "px";
    //             this.css({ height: 0, display: "block" });
    //             this.attr("isMoving", true);
    //             await this.animate({ height: ["0", height] }, 300).finished;
    //             this.removeAttribute("isMoving");
    //             this.css("height", "auto");
    //             fn && fn.call(this);
    //         })();
    //     } else {
    //         this.show(display);
    //         fn && fn.call(this);
    //     }
    //     return this;
    // };

    // HTMLElement.prototype.slideUp = async function (fn) {
    //     if (getComputedStyle(this).display === "none" || this.attr("isMoving"))
    //         return this;

    //     if (this.animate) {
    //         (async () => {
    //             var height = this.height() + "px";
    //             this.attr("isMoving", true);
    //             await this.animate({ height: [height, "0"] }, 300).finished;
    //             this.css({ display: "none", height: height });
    //             this.removeAttribute("isMoving");
    //             this.css("height", "auto");
    //             fn && fn.call(this);
    //         })();
    //     } else {
    //         this.hide();
    //         fn && fn.call(this);
    //     }
    //     return this;
    // };

    Node.prototype.appendTo = HTMLElement.prototype.appendTo = function (dom) {
        dom.appendChild(this);
        return this;
    };

    HTMLElement.prototype.parent = function () {
        return this.parentNode;
    };

    HTMLElement.prototype.next = function () {
        return this.nextElementSibling || this.nextSibling;
    };

    HTMLElement.prototype.prev = function () {
        return this.previousElementSibling || this.previousSibling;
    };

    HTMLElement.prototype.matches = (function () {
        return (
            HTMLElement.prototype.matches ||
            HTMLElement.prototype.webkitMatchesSelector ||
            HTMLElement.prototype.mozMatchesSelector ||
            HTMLElement.prototype.msMatchesSelector
        );
    })();

    HTMLElement.prototype.closest = function (selector) {
        var target = this;
        // target 为 #document-fragment 时，target.tagName 为 undefined
        while (target && target.tagName && target.tagName !== "HTML") {
            if (target.matches(selector)) return target;
            target = target.parentNode;
        }
    };

    Node.prototype.attr = HTMLElement.prototype.attr = function (key, val) {
        if (typeof key === "string") {
            if (val !== undefined) {
                this.setAttribute(key, val);
            } else {
                return this.getAttribute(key);
            }
        } else if (typeof key === "object") {
            for (let k in key) {
                this.setAttribute(k, key[k]);
            }
        }
        return this;
    };

    HTMLElement.prototype.delegate = function (selector, eventType, fn) {
        this.addEventListener(eventType, function (e) {
            var e = e || window.event,
                target = e.target.closest(selector);
            if (!target) return;
            if (fn.call(target, e) === false) {
                e.stopPropagation();
                e.preventDefault();
            }
        });
    };

    HTMLElement.prototype.siblings = function () {
        var collection = [];
        var siblings = this.parentNode.children;

        for (var i = 0; i < siblings.length; i++) {
            if (siblings[i] !== this) collection.push(siblings[i]);
        }
        collection.__proto__ = NodeList.prototype;
        return collection;
    };

    HTMLElement.prototype.find = function (selector) {
        return this.querySelectorAll(selector);
    };

    HTMLElement.prototype.contents = function( elem ) {
		if ( elem.contentDocument != null && getProto( elem.contentDocument ) ) {
			return elem.contentDocument;
		}

		if ( nodeName( elem, "template" ) ) {
			elem = elem.content || elem;
		}

		return merge( [], elem.childNodes );
	};

    HTMLElement.prototype.merge = function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
    };
    
    HTMLElement.prototype.prevAll = function () {
        var _parent = this.parentElement;
        var _child = _parent.children;
        var arr = [];
        for (var i = 0; i < _child.length; i++) {
            var _childI = _child[i];
            if (_childI == this) {
                break;
            }
            arr.push(_childI);
        }
        return arr;
    };

    HTMLElement.prototype.nextAll = function () {
        var _parent = this.parentElement;
        var _child = _parent.children;
        var arr = [];
        for (var i = _child.length - 1; i >= 0; i--) {
            var _childI = _child[i];
            if (_childI == this) {
                break;
            }
            arr.unshift(_childI);
        }
        return arr;
    };

    //HTMLCollection
    //NodeList
    NodeList.prototype.first = function () {
        return this[0];
    };

    NodeList.prototype.last = function () {
        return this[this.length - 1];
    };

    /*
     * @description 给NodeList,HTMLCollection对象添加遍历，执行新加的HTMLElement方法
     * @param {}
     */

    (function () {
        const methods = [
            "remove",
            "hide",
            "find",
            "removeClass",
            "addClass",
            "next",
            "slideUp",
            "slideDown",
            "css"
        ];

        methods.forEach(function (method) {
            NodeList.prototype[method] = HTMLCollection.prototype[method] =
                function () {
                    var result = [];
                    var length = this.length;

                    if (length) {
                        var doms = [];

                        for (var i = 0; i < length; i++) {
                            if (method === "remove") {
                                doms.push(this[i]);
                            } else {
                                var nodes = this[i][method].apply(
                                    this[i],
                                    arguments
                                );
                                if (
                                    nodes &&
                                    (nodes.length ||
                                        nodes instanceof HTMLElement)
                                ) {
                                    result = result.concat(nodesToArray(nodes));
                                }
                            }
                        }
                        !!doms.length &&
                            doms.forEach(function (dom) {
                                dom[method].apply(dom, arguments);
                            });
                    }

                    result.__proto__ = NodeList.prototype;
                    return result;
                };
        });
    })();

    function nodesToArray(nodes) {
        return nodes.length ? [].slice.call(nodes) : [nodes];
    }
})();
