import "./modulepreload-polyfill-7faf532e.js";
import { bt as SvrMgr, aN as OperatorParas, aB as SessionParasCache, b7 as SessionInfo, bE as IconSourceLoader, I as I18N, a_ as MainContainer, cR as TabMainContainer, cS as YesCore, a as ControlType, b4 as CookiesUtil, af as ExceptionStack, p as FormBuilder, m as MetaService, W as FormTarget, O as OperationState, _ as NewOpt, Z as OptQueue, cT as RemoteService, F as FormStack, bC as CompSetting, bY as BaseDialog, bT as DictSetting, cU as ViewParser, a3 as FuncMap, as as RTS_Service, cV as IconUtil, V as ViewContext, cW as MenuFavoriteService, bL as GridSetting, i as DesignModeSetting, l as Utils, U as UIScopeTrees, X as DocService, aI as DictService, L as LoadingUtil, T as TypeConvertor, cX as FieldUtil, cY as AppDef, aZ as BaseHandler, bw as BaseControl, ab as extend, cu as TimerTaskManagerFactory, cZ as allocFormID, a$ as LoadOpt, c_ as Base64, aD as AppSetting, y as FormType, aP as NotificationMgr, c$ as DataService, d0 as BeaconService, R as Request, cz as MainFrameInterface, c1 as MapSetting, d1 as afterYIUILoad, o as MainUIOptTracer, d2 as UIOptTraceUtil, j as FormRender, d3 as StatusProxy, d4 as LLMChatInterface } from "./yes-core-73b995f9.js";
import "./vendor-dcacb77b.js";
import { e as YesVBaseComponent, C as ControlMapping, L as treeClickHandle, M as FormRenderUtil, N as YesOwnerDraw, Y as YElement, h, D as Dialog, O as MainContainerBuilder, P as TabModalContainerBuilder, Q as TabModalContainer, R as YesModalContainer, S as LLMChatTrigger, U as LLMChat } from "./yes-ui-29852ed4.js";
import { T as Tabs, E as ERPInit } from "./erp-yes-ui-4313cb43.js";
import "./designer-86ac79d5.js";
import { S as ShowHelpTxt, E as ERPBusinessLock, A as AutoRecord } from "./erp-yes-core-25f33c37.js";
import { M as MainFrame } from "./index-95bcd4da.js";
MainFrameInterface.MainFrame = MainFrame;
const webRoot = (() => {
  let url;
  if (SvrMgr.baseurl) {
    url = `${SvrMgr.baseurl}/${"yesui-vnode"}/`;
  } else {
    url = `${"yesui-vnode"}/`;
  }
  return url;
})();
const initMapSetting = () => {
  var _url = [window.location.protocol, "//", window.location.host, "/"].join("");
  MapSetting.BDUrl = _url + webRoot + "lib/map/bdmap.html";
  MapSetting.GDUrl = _url + webRoot + "lib/map/gdmap.html";
};
initMapSetting();
async function init() {
  let result = await SvrMgr.getSessionInfo();
  if (result) {
    if (result.SessionParas) {
      var sessionData = result.SessionParas;
      if (typeof sessionData === "string") {
        sessionData = JSON.parse(sessionData);
      }
      if (sessionData.hasOwnProperty("OperatorParas")) {
        var operatorParas = sessionData.OperatorParas;
        if (typeof operatorParas === "string") {
          operatorParas = JSON.parse(operatorParas);
        }
        const operatorParasCache = await OperatorParas.getParasObjectByKey(result.UserID);
        if (!operatorParasCache) {
          await OperatorParas.setParasByKey(result.UserID, operatorParas);
        }
      }
      SessionParasCache.setParas(sessionData);
    }
    SessionInfo.setCode(result.Code);
    SessionInfo.setUserName(result.Name);
    SessionInfo.setUserID(result.UserID);
    SessionInfo.setClusterID(result.clusterID);
    SessionInfo.setLoginTime(result.Time);
  } else {
    SessionInfo.clear();
  }
  await IconSourceLoader.loadIconSourceFile();
  let strings = await SvrMgr.loadi18nData();
  I18N.seti18nStrings(strings);
  const mainContainer = MainContainerBuilder(Tabs);
  MainContainer.set(mainContainer);
  const tabContainer = TabModalContainerBuilder(TabModalContainer);
  TabMainContainer.set(tabContainer);
  window.YIUI = {
    ...window.YIUI || {},
    YesCore,
    YesBaseComponent: YesVBaseComponent,
    BuilderMap: ControlMapping,
    treeClickHandle: treeClickHandle(mainContainer),
    SvrMgr,
    SessionInfo,
    I18N,
    ControlType,
    CookiesUtil,
    errorHandle(e) {
      return ExceptionStack.push(e);
    },
    FormBuilder,
    MetaService,
    FormTarget,
    OperationState,
    NewOpt,
    OptQueue,
    FormRenderUtil,
    RemoteService,
    YesOwnerDraw,
    FormStack,
    CompSetting,
    BaseDialog,
    YElement,
    h,
    webRoot,
    DictView: DictSetting,
    // FIXME ?
    ViewParser,
    FuncMap,
    MainContainer,
    RTS_Service,
    IconUtil,
    ViewContext,
    MenuFavoriteService,
    GridSetting,
    isDesignMode: function() {
      return DesignModeSetting.isDesignMode;
    },
    Utils,
    UIScopeTrees,
    DocService,
    DictService,
    Dialog,
    LoadingUtil,
    TypeConvertor,
    FieldUtil,
    AppDef,
    BaseHandler,
    BaseControl,
    extend,
    TimerTaskManagerFactory,
    isShowReloadButton: true,
    // 是否显示reload按钮
    reg: function() {
    },
    allocFormID,
    LoadOpt,
    Expr: FuncMap,
    Base64,
    AppSetting,
    FormType,
    APP: {
      MainFrame
    },
    NotificationMgr,
    DataService,
    BeaconService
  };
  AppSetting.updateClientSetting("mainframe.openEntryByClick", false);
  AppSetting.updateClientSetting("mainframe.closeOtherEntry", false);
  window.Svr = {
    Request
  };
  window.View = {
    FuncMap: null
  };
  window.Expr = {
    regCluster: function(map, funext) {
      FuncMap.regCluster(funext);
    }
  };
  window.exec = async function(formID, formula) {
    var form = FormStack.getForm(formID);
    var cxt = new ViewContext(form);
    if (form) {
      return form.eval(formula, cxt);
    } else {
      var parser = new ViewParser();
      return parser.eval(formula, cxt);
    }
  };
  window.BaseFunsExt = {
    ShowHelpTxt
  };
  AppSetting.updateClientSetting("yescore.component.grid.defaultCustom", false);
  AppSetting.updateClientSetting("yescore.component.grid.defaultZoom", true);
  AppSetting.updateClientSetting("yescore.component.dict.EditType", 0);
  AppSetting.updateClientSetting("yescore.dialog.Placement", "right");
  AppSetting.updateClientSetting("yescore.component.base.CompStyle", "innerLabel");
  AppSetting.updateClientSetting("yescore.component.grid.restoreInitStatus", true);
  DesignModeSetting.addDesignerProjects(ERPDESIGNER.PROJECTKEY_WEBCONFIG, ERPDESIGNER.PROJECTKEY_BPMN);
}
LLMChatInterface.LLMChat = LLMChat;
LLMChatInterface.LLMChatTrigger = LLMChatTrigger;
window.addEventListener("error", function(e) {
  console.error(e);
  ExceptionStack.push(e.error);
});
window.addEventListener("unhandledrejection", function(e) {
  console.error(e);
  ExceptionStack.push(e.reason);
});
window.Yes_TEMP_LoggedInState = true;
const beaconService = new BeaconService();
const TOPIC_PageUnload = "BeaconService.Topic.YIUI_PageUnload";
window.addEventListener("beforeunload", (e) => {
  console.log("main onbeforeunload");
  if (window.Yes_TEMP_LoggedInState) {
    beaconService.cleanTopic(TOPIC_PageUnload);
    beaconService.recordTopic(
      TOPIC_PageUnload,
      () => {
        ERPBusinessLock.UnAllLock();
      }
    );
    e.preventDefault();
    e.returnValue = "";
  }
});
window.addEventListener("unload", (e) => {
  console.log("main onunload");
  if (window.Yes_TEMP_LoggedInState) {
    beaconService.sendBeacon(TOPIC_PageUnload);
  }
});
init().then(async () => {
  afterYIUILoad();
  window.YIUI.MainFrameID = Utils.guid();
  window.YIUI.MainUIOptTracer = MainUIOptTracer;
  await UIOptTraceUtil.init();
  function repeatUploadUserTraces() {
    UIOptTraceUtil.uploadTraces();
    setTimeout(repeatUploadUserTraces, 3e5);
  }
  repeatUploadUserTraces();
});
FormRender.setYesCom(new YesModalContainer());
window.addEventListener("YIUI-loaded", (e) => {
  console.log("设计器初始化");
  ERPInit.init();
  AutoRecord.init();
  StatusProxy.licenseCheck();
});
new Tabs({
  parent: document.querySelector("#app")
});
let LLMChatFlag = false;
AppSetting.registerClientSettingsListener("yescore.llmchat.enable", (key, value) => {
  if (value) {
    LLMChatTrigger.init();
    LLMChatFlag = true;
  } else {
    if (LLMChatFlag) {
      LLMChatTrigger.destroy();
      LLMChatFlag = false;
    }
  }
});
//# sourceMappingURL=main-e0253799.js.map
