window.onload = function () {
  window.parent.addEventListener("YIUI-loaded", (e) => {
    var $user = document.querySelector(".yigom-login-username input"),
      $pwd = document.querySelector(".yigom-login-password input"),
      $error = document.querySelector(".yigom-login-error"),
      $switch = document.querySelector(".yigom-login-switch"),
      $valid = document.querySelector(".login-valid-code"),
      oLocale = document.querySelector(".yigom-login-lang"),
      loginAble = true,
      password = "",
      showPlainText = false; //是否显示明文
    var SvrMgr = parent.YIUI.SvrMgr,
      InterActiveFactory = parent.YIUI.InterActiveFactory,
      MLogin = parent.YIUI.MLogin,
      CookiesUtil = parent.YIUI.CookiesUtil,
      ErrorUtil = parent.YIUI.ErrorUtil;

    let def;
    (async () => {
      def = await SvrMgr.getLoginDef();
      setLanguage(def);
      setValid(def);
    })();

    async function refreshValidateCode() {
       const oImg = document.querySelector(".yigom-login-valid .login_valid_img");
      let id = CookiesUtil.get("tmpClientID");
      if (!id) {
        id = await SvrMgr.getTmpClientID();
        CookiesUtil.set("tmpClientID", id);
      }
      const { result } = await SvrMgr.validateImage({ tmpclientid: id });
      oImg.setAttribute("src", "data:image/png;base64," + result);
      document.querySelector(".login-valid-code").value=""
    }

    const setValid = (def) => {
      const oValid = document.querySelector(".yigom-login-valid");
      if (!def || !def.valid) return oValid.remove();
      oValid.style.display = "block";
      const oImg = oValid.querySelector(".login_valid_img");
      refreshValidateCode();
      oImg.addEventListener("click", refreshValidateCode);
    };

    const setLanguage = async (def) => {
      // const oLocale = document.querySelector(".login_locale");

      if (!def || !def.multiLang) return oLocale.remove();

      oLocale.style.display = "block";
      const supportLang = await SvrMgr.getSupportLang(),
        { items } = supportLang,
        oUl = oLocale.querySelector(".locale-list");

      if (!supportLang || !items || !items.length) return;
      const language = setLang();
      // oParas = oLocale.querySelector(".locale_paras"),
      // oVw = oLocale.querySelector(".login_locale_vw"),
      const langInt = document.querySelector(".yigom-login-lang input");

      items.forEach((item) => {
        addLangItem(item);
        // 注销后显示上次登录语言
        if (item.value === language) {
          langInt.setAttribute("value", item.value);
          langInt.value = item.caption;
        }
      });
      var cmbMousedown = function () {
        let mdHandler = function (e) {
          if (!e.target.closest(".locale-list")) {
            oLocale.querySelector(".locale-list").classList.add("hide");
            document.removeEventListener("mousedown", mdHandler);
            document.removeEventListener("touchstart", mdHandler);
          }
        };
        document.addEventListener("mousedown", mdHandler);
        document.addEventListener("touchstart", mdHandler);
      };
       document.querySelector(".yigom-login-lang").addEventListener("click", (e) => {
        oUl.classList.remove("hide");
        cmbMousedown();
        e.stopPropagation();
      });

      function addLangItem(item) {
        const { value, caption } = item,
          oLi = document.createElement("li");
        oLi.setAttribute("value", value);
        oLi.classList.add("login-combox-item");

        if (value === language) {
          oLi.classList.add("sel");
        }

        oLi.innerHTML = caption;
        oUl.appendChild(oLi);

        oLi.addEventListener("click", async (e) => {
          var target = e.target.closest("li");
          if (!target) return;
          if (target.classList.contains("sel")) {
            oUl.classList.add("hide");
            return;
          } else {
            oUl.querySelector(".sel") &&
              oUl.querySelector(".sel").classList.remove("sel");
            target.classList.add("sel");

            const caption = target.innerHTML,
              value = target.getAttribute("value");

            langInt.setAttribute("value", value);
            langInt.value = caption;
            if (CookiesUtil.get("locale") !== value) {
              CookiesUtil.set("locale", value);
            }
            oUl.classList.add("hide");
            // 多语言
            const { setDefaultLanguage } = await import("../../utils/utils.js");
            await setDefaultLanguage(parent);
          }
          e.stopPropagation();
        });
      }

      function setLang() {
        let locale = CookiesUtil.get("locale");
        if (!locale) {
          locale = (navigator.language || navigator.userLanguage).toLowerCase();
          const idx = locale.indexOf("-");
          locale =
            locale.substring(0, idx) +
            "-" +
            locale.substring(idx + 1).toUpperCase();
          CookiesUtil.set("locale", locale);
        }
        return locale;
      }
    };
    function changeValue() {
      if (showPlainText) {
        $pwd.value = password;
      } else {
        $pwd.value = "•".repeat(password.length);
      }
    }

    function login() {
      $user.blur();
      $pwd.blur();
      $valid.blur();
      if (!loginAble) return;
      loginAble = false;
      var username = $user.value;
      $error.classList.remove("show");
      var getSessionParas = function () {
        return { OrgCode : "000"};
      };

      var getValidateCode = function () {
        let codeInput = document.querySelector(".login-valid-code");
        return codeInput ? codeInput.value : "";
      };
      SvrMgr.doLogin(
        username,
        password,
        getSessionParas(),
        getValidateCode(),
        CookiesUtil.get("tmpClientID"),
        2
      )
        .then(function (ret) {
          if (ret) {
            let Interactive = InterActiveFactory.Interactive;
            if (Interactive.canInteractive()) {
              Interactive.saveCookie({ clientID: ret.clientID });
            }
            MLogin.remove();
            //登录完初始化
            $user.value = "";
            $pwd.value = "";
            $valid.value = "";
          }
        })
        .catch(function (err) {
          def && def.valid && refreshValidateCode()
          const message = ErrorUtil.getErrorMessage(err);
          const errorText = message.message ? message.message : message;
          $error.innerHTML = errorText;
          $error.classList.add("show");
        })
        .finally(function () {
          loginAble = true;
        });
    }

    function display(e) {
      e.preventDefault();
      MLogin.removeHtml();
    }
    function cursorMove(inp, spos = -1) {
      // spos 光标的位置 -1为最后一位
      if (spos < 0) spos = inp.value.length;
      if (inp.setSelectionRange) {
        //兼容火狐,谷歌
        inp.setSelectionRange(spos, spos);
        inp.focus();
      } else if (inp.createTextRange) {
        //兼容IE
        var rng = inp.createTextRange();
        rng.move("character", spos);
        rng.select();
      }
    }

    $pwd.oninput = function () {
      var v = this.value;
      var focusPosition = this.selectionStart;
      password = password.split("");
      if (v.length < password.length) {
        password.splice(focusPosition, 1);
      } else if (v.length > password.length) {
        var beforev = v.slice(focusPosition - 1, focusPosition);
        password.splice(focusPosition - 1, 0, beforev);
      }
      password = password.join("");
      changeValue();
      cursorMove(this, focusPosition);
    };
    function switchShowPlainText() {
      showPlainText = !showPlainText;
      var showPT = document.querySelector(".show-plaintext");
      if (showPlainText) {
        showPT.classList.add("show");
      } else {
        showPT.classList.remove("show");
      }
      changeValue();
    }
    document
      .querySelector(".yigom-login-loginBtn")
      .addEventListener("click", login);
    document.querySelector(".yigom-login-disBtn") &&
      document
        .querySelector(".yigom-login-disBtn")
        .addEventListener("touchend", display);
    document.querySelector(".show-plaintext").addEventListener('click', switchShowPlainText);
    document.addEventListener("keydown", function (e) {
      if (e.keyCode == 13) login();
    });
  });
};
