import { R as Request, W as FormTarget, F as FormStack, V as ViewContext, i as DesignModeSetting, p as FormBuilder, a as ControlType, aj as RichDocService, M as MetaFormProcess, I as I18N, ak as DictCacheProxy, ab as extend, m as MetaService, al as UICalcProcess, am as ButtonHandler, an as ToolBarHandler, ao as Errordialog, ap as GridHandler, aq as ListViewHandler, ar as DictViewHandler, ac as TabPanelHandler, as as RTS_Service, at as ToolBar, au as ToolBarBuilder, G as GridLayoutPanelBuilder, av as GridLayoutPanel, aw as TabPanel, ax as TabPanelBuilder, C as CompBuilder, ay as DictViewBuilder, az as DictBuilder, aA as DynamicDictBuilder, aB as SessionParasCache, aC as InplaceToolbarItemAction, D as DataUtil, U as UIScopeTrees, a3 as FuncMap, aD as AppSetting, d as MetaForm, aE as FORM_SERIALIZATION_ERROR, aF as ContainerStyle, O as OperationState, L as LoadingUtil, r as FormParasUtil, T as TypeConvertor, y as FormType, aG as FileUtil, $ as YesJSONUtil, v as COMPONENT_NOT_EXISTS, Y as FormFactory, aH as GridUtil, aI as DictService, aJ as BatchUtil, J as SystemField, aK as ExprUtil, u as checkParamNum, w as TreeType, aL as ComponentLocationUtil, aM as NO_ROW_SELECTED, aN as OperatorParas, aO as DataDef, x as FormUIStatusMask, b as LRUCache, aP as NotificationMgr, aQ as HeadInfoOptType, aR as HeadInfoUtil, aS as ItemData, aT as Form, l as Utils, s as ColorPickerDialog, aU as UNEQUAL_PARAM_NUM, aV as DocumentType, N as MetaCache, aW as SecondaryType, X as DocService, aX as NewOIDCache, aY as DictHandler, aZ as BaseHandler, a7 as DocCache, a_ as MainContainer, a1 as CssUtil, Z as OptQueue, a$ as LoadOpt, k as SizeUtil, b0 as SetValue, b1 as GetFormEntryKey, b2 as AttachmentHandler, b3 as AttachField, b4 as CookiesUtil, b5 as GridUIProcess, b6 as LocalMenuFavoriteSetting } from "./yes-core-73b995f9.js";
import { D as Decimal } from "./vendor-dcacb77b.js";
const __variableDynamicImportRuntimeHelper = (glob, path) => {
  const v = glob[path];
  if (v) {
    return typeof v === "function" ? v() : Promise.resolve(v);
  }
  return new Promise((_, reject) => {
    (typeof queueMicrotask === "function" ? queueMicrotask : setTimeout)(reject.bind(null, new Error("Unknown variable dynamic import: " + path)));
  });
};
const _RecordCase = class _RecordCase2 {
  // 录制用例步骤
  static async requestRecordStep(content2) {
    if (!content2.startsWith("选择:表格:")) {
      _RecordCase2.recordRowClickContent = "";
    }
    await _RecordCase2.requestRecord("step", content2);
  }
  // 录制请求接口
  static async requestRecord(type2, content2) {
    let paras = {
      service: "AutoRecord",
      cmd: "AutoRecord",
      content: content2,
      type: type2
    };
    await new Request().getData(paras);
  }
  // 增加导航栏响应事件
  static addListening() {
    let startRecord = document.querySelector("#startRecord");
    startRecord.onclick = async function() {
      if (!AutoRecord.AutoRecord) {
        let paras = {
          service: "AutoRecord",
          cmd: "SetAutoRecode",
          autoRecord: "true"
        };
        AutoRecord.AutoRecord = await new Request().getData(paras);
        startRecord.style.color = "red";
        startRecord.nextElementSibling.style.color = "#fff";
      }
    };
    let stopRecord = document.querySelector("#stopRecord");
    stopRecord.onclick = async function() {
      if (AutoRecord.AutoRecord) {
        stopRecord.style.color = "red";
        stopRecord.previousElementSibling.style.color = "#fff";
        stopRecord.nextElementSibling.style.color = "#fff";
        AutoRecord.AutoRecord = false;
        AutoRecord.RecordCheck = "false";
        let paras = {
          service: "AutoRecord",
          cmd: "SetAutoRecode",
          autoRecord: "false"
        };
        await new Request().getData(paras);
      }
    };
    let isRecordCheck = document.querySelector("#isRecordCheck");
    isRecordCheck.onclick = function() {
      if (AutoRecord.AutoRecord) {
        if (AutoRecord.RecordCheck != "true") {
          isRecordCheck.style.color = "red";
          AutoRecord.RecordCheck = "true";
        } else {
          isRecordCheck.style.color = "#fff";
          AutoRecord.RecordCheck = "false";
        }
      }
    };
    let caseManage = document.querySelector("#caseManage");
    caseManage.onclick = async function() {
      let formKey = "CaseManage";
      const builder = new FormBuilder(formKey);
      builder.setTarget(FormTarget.MODAL);
      return builder.newEmpty().then((emptyForm) => {
        return builder.build(emptyForm);
      });
    };
    let checkData = document.querySelector("#checkData");
    let checkdatabox = document.querySelector("#checkdatabox");
    let checkdatalist = document.querySelector("#checkdatalist");
    checkData.onclick = function() {
      checkdatalist.style.display = "block";
    };
    checkdatabox.onmouseleave = function() {
      checkdatalist.style.display = "none";
    };
    let checkControl = document.querySelector("#checkControl");
    let checkcontrolbox = document.querySelector("#checkcontrolbox");
    let checkcontrollist = document.querySelector("#checkcontrollist");
    checkControl.onclick = function() {
      checkcontrollist.style.display = "block";
    };
    checkcontrolbox.onmouseleave = function() {
      checkcontrollist.style.display = "none";
    };
    let designercheck = document.querySelector("#designercheck");
    let designercheckBox = document.querySelector("#designercheckBox");
    let designerchecklist = document.querySelector("#designerchecklist");
    designercheck.onclick = function() {
      designerchecklist.style.display = "block";
    };
    designercheckBox.onmouseleave = function() {
      designerchecklist.style.display = "none";
    };
    let topPrompt = document.querySelector("#topPrompt");
    topPrompt.onclick = function() {
      let content2 = "";
      var tips = document.querySelectorAll("div.tipsClass"), tip, textContent;
      if (tips.length > 0) {
        tip = tips[tips.length - 1];
        textContent = tip.textContent;
        content2 = "设计器提示框:顶部提示框:" + textContent;
      }
      if (content2 != "") {
        _RecordCase2.requestRecordStep(content2);
      }
    };
    let centralPrompt = document.querySelector("#centralPrompt");
    centralPrompt.onclick = function() {
      let content2 = "";
      let tips = document.querySelectorAll("div.layui-layer-msg[type='dialog'][id *= 'layui-layer']"), tip, textContent;
      if (tips.length > 0) {
        tip = tips[tips.length - 1];
        textContent = tip.textContent;
        content2 = "设计器提示框:中部提示框:" + textContent;
      }
      if (content2 != "") {
        _RecordCase2.requestRecordStep(content2);
      }
    };
    let designerVer = document.querySelector("#designerVer");
    let designerVerBox = document.querySelector("#designerVerBox");
    let designerVerlist = document.querySelector("#designerVerlist");
    designerVer.onclick = function() {
      designerVerlist.style.display = "block";
    };
    designerVerBox.onmouseleave = function() {
      designerVerlist.style.display = "none";
    };
    let designerSelect = document.querySelector("#designerSelect");
    let designerSelectBox = document.querySelector("#designerSelectBox");
    let designerSelectlist = document.querySelector("#designerSelectlist");
    let selectNodeTreeLi = document.querySelector("#selectNodeTree");
    let selectFileTreeLi = document.querySelector("#selectFileTree");
    designerSelect.onclick = function() {
      designerSelectlist.style.display = "block";
    };
    designerSelectBox.onmouseleave = function() {
      designerSelectlist.style.display = "none";
    };
    selectNodeTreeLi.onclick = function() {
      if (AutoRecord.AutoRecord) {
        if (selectNodeTreeLi.style.color == "red") {
          AutoRecord.SelectNodeTree = "false";
          selectNodeTreeLi.style.color = "rgb(51, 51, 51)";
        } else {
          AutoRecord.SelectNodeTree = "true";
          selectNodeTreeLi.style.color = "red";
        }
      }
    };
    selectFileTreeLi.onclick = function() {
      if (AutoRecord.AutoRecord) {
        if (selectFileTreeLi.style.color == "red") {
          AutoRecord.SelectFileTree = "false";
          selectFileTreeLi.style.color = "rgb(51, 51, 51)";
        } else {
          AutoRecord.SelectFileTree = "true";
          selectFileTreeLi.style.color = "red";
        }
      }
    };
    let designerPrompt = document.querySelector("#designerPrompt");
    let designerPromptBox = document.querySelector("#designerPromptBox");
    let designerPromptlist = document.querySelector("#designerPromptlist");
    designerPrompt.onclick = function() {
      designerPromptlist.style.display = "block";
    };
    designerPromptBox.onmouseleave = function() {
      designerPromptlist.style.display = "none";
    };
    setTimeout(() => {
      document.querySelectorAll(".nav-right .nav-field-items a").forEach((item) => {
        let content2 = item.textContent;
        let spanEl = item.querySelector("span");
        if (spanEl != null && spanEl.textContent != null && spanEl.textContent != "") {
          content2 = content2.replace(spanEl.textContent, "");
        }
        if (content2 === "注销" || content2 === "退出") {
          item.parentElement.addEventListener("click", () => {
            if (AutoRecord.AutoRecord) {
              if (content2 === "注销") {
                _RecordCase2.requestRecordStep(content2);
              } else {
                _RecordCase2.requestRecordStep("设计器导航操作:" + content2);
              }
            }
          }, true);
        } else {
          item.addEventListener("click", () => {
            if (AutoRecord.AutoRecord) {
              _RecordCase2.requestRecordStep("设计器导航操作:" + content2);
            }
          });
        }
      });
    }, 1e3);
  }
  // 获取实际行号
  static getActualRowIndex(grid, rowIndex) {
    let trELs2 = grid.getEl().vnode.elm.querySelectorAll("tr[id^='ygd']:not([style*='display: none'])");
    for (let i2 = 0; i2 < trELs2.length; i2++) {
      if (trELs2[i2].id.indexOf(rowIndex) > -1) {
        return i2;
      }
    }
  }
  // 获取实际行号
  static getActualColIndex(grid, rowIndex, colIndex) {
    let tdELs = grid.getEl().vnode.elm.querySelectorAll("tr[id^='ygd" + rowIndex + "'] td[role='gridcell']:not([style*='display: none'])");
    for (let i2 = 0; i2 < tdELs.length; i2++) {
      if (tdELs[i2].getAttribute("aria-describedby").indexOf("column" + colIndex) > -1) {
        return i2;
      }
    }
  }
  // 获取单元格的信息
  static getCellInfo(cell) {
    let tdDescribedby = cell.getAttribute("aria-describedby");
    let trId = cell.parentElement.getAttribute("id");
    let gridKey, colKey, columnCaption, rowIndex, colIndex, rowNum, colNum;
    gridKey = tdDescribedby.replace(/_column[\d]+/, "").replace(/[\d]+_/, "");
    colKey = cell.getAttribute("meta-key");
    let thElement = document.querySelector("[id='" + tdDescribedby + "']");
    let formId2 = tdDescribedby.substring(0, tdDescribedby.indexOf("_"));
    let form2 = FormStack.getForm(formId2);
    columnCaption = thElement.querySelectorAll(".col-caption")[0].innerHTML.trim();
    let thElements = this.getElementsByXpath("./preceding-sibling::th", thElement);
    let columnIndex = 0;
    for (let i2 = 0; i2 < thElements.length; i2++) {
      let thElm = thElements[i2];
      if (thElm.querySelector(".col-caption") == null || thElm.getAttribute("style").indexOf("display: none") > -1 || thElm.getAttribute("style").indexOf("display:none") > -1) {
        continue;
      }
      if (thElm.querySelector(".col-caption").innerHTML.trim() === columnCaption) {
        columnIndex++;
      }
    }
    rowIndex = trId.replace(/ygd/, "");
    colIndex = tdDescribedby.replace(/[\d]+_/, "").replace(gridKey + "_", "");
    rowNum = this.getElementsByXpath("./ancestor::tr[1]/preceding-sibling::tr", cell).length;
    colNum = this.getElementsByXpath("./preceding-sibling::td[not(contains(@style,'display:none')) and not(contains(@style,'display: none'))]", cell).length + 1;
    return {
      gridKey,
      colKey,
      columnCaption: columnCaption + (columnIndex === 0 ? "" : "#" + (columnIndex + 1)),
      rowIndex,
      colIndex,
      rowNum,
      colNum,
      formKey: form2.formKey
    };
  }
  // 通过xpath查找元素
  static getElementByXpath(path, el) {
    let element;
    if (el === null) {
      element = document.evaluate(path, document).iterateNext();
    } else {
      element = document.evaluate(path, el).iterateNext();
    }
    return element;
  }
  // 通过xpath查找元素
  static getElementsByXpath(path, el) {
    let results = [];
    let elements2;
    let element;
    if (el === null) {
      elements2 = document.evaluate(path, document);
    } else if (arguments.length === 2) {
      elements2 = document.evaluate(path, el);
    }
    while (element = elements2.iterateNext()) {
      results.push(element);
    }
    return results;
  }
  // 待录入值的处理
  static replaceToTestCaseStepValue(value2) {
    if (typeof value2 == "string") {
      if (value2.indexOf(":") > -1) {
        value2 = value2.replace(/:/g, "/：");
      }
      if (value2.indexOf(",") > -1) {
        value2 = value2.replace(/,/g, "/，");
      }
      if (value2.indexOf("\r\n") > -1) {
        value2 = value2.replace(/\r\n/g, "/{换行}");
      }
    }
    return value2;
  }
  // 获取当前页面
  static getCurrPage() {
    let dialogs = document.querySelectorAll(".dialog.show:not([style*='display: none']):not([style*='display:none'])"), currPage2;
    if (dialogs.length > 0) {
      currPage2 = dialogs[dialogs.length - 1];
    } else {
      currPage2 = document.querySelectorAll("#app div.tabs-body div:not([style*='display: none']).tabs-body-inner > div.mainContainer")[0];
    }
    return currPage2;
  }
  //获取表头中控件的Caption，传入的需要是控件元素(class中有ui-control)的本身或者是子元素
  static getCompCaption(compElm) {
    let classAttribute = compElm.getAttribute("class");
    if (classAttribute == null || classAttribute.indexOf("ui-control") === -1 && classAttribute.indexOf("ui-rdo") === -1 && classAttribute.indexOf("ui-chk") === -1) {
      compElm = this.getElementByXpath("./ancestor::div[contains(@class,'ui-control') or contains(@class,'ui-rdo') or contains(@class,'ui-chk')]", compElm);
    }
    let idAttribute = compElm.getAttribute("id");
    let formID = idAttribute.substring(0, idAttribute.indexOf("_"));
    let compKey = idAttribute.replace(/[\d]+_/, "");
    let comp2 = FormStack.getForm(formID).getComponent(compKey);
    return {
      fieldKey: comp2.key,
      fieldCaption: this.getCompCaptionForUe(compElm, comp2)
    };
  }
  static getCompCaptionForUe(compElm, comp2) {
    let id = compElm.id;
    let caption2 = this.getCompCaptionByHeadDiv(compElm);
    let headDivs = _RecordCase2.getCurrPage().querySelectorAll("div.ui-control[id]:not(.ui-lbl), div.ui-rdo:not(.ui-lbl)");
    if (caption2 == void 0 || caption2 == "") {
      caption2 = comp2.caption || comp2.key;
      return caption2;
    }
    let index2 = 1;
    for (let i2 = 0; i2 < headDivs.length; i2++) {
      let caption1 = this.getCompCaptionByHeadDiv(headDivs[i2]);
      if (id === headDivs[i2].id) {
        break;
      }
      if (caption1 === caption2) {
        index2++;
      }
    }
    caption2 = index2 > 1 ? caption2 + "#" + index2 : caption2;
    return caption2;
  }
  static getCompCaptionByHeadDiv(headDiv) {
    let compClassAttribute = headDiv.getAttribute("class");
    let isRadio = compClassAttribute.indexOf("ui-rdo") > -1;
    let isCheckBox = compClassAttribute.indexOf("ui-chk") > -1;
    let hasCaption = !isRadio && !isCheckBox;
    let caption2 = hasCaption ? headDiv.getAttribute("caption") : headDiv.getElementsByTagName("label")[0].textContent;
    return caption2;
  }
  //获取列名
  static async getMetaColumnCaption(form2, grid, colIndex) {
    let columns = grid.dataModel.columns, metaColumn = grid.getMetaColumnAt(colIndex), metaColumns, index2 = 0, caption2, captions2;
    if (columns[colIndex].hasOwnProperty("newCaption")) {
      caption2 = columns[colIndex].newCaption;
    } else {
      if (metaColumn.formulaCaption != "") {
        let th = grid.getEl().vnode.elm.querySelectorAll("tr.ui-ygrid-columnheader th[oldkey='" + columns[colIndex].key + "']")[0];
        caption2 = th.getAttribute("title");
        if (!caption2) {
          caption2 = grid.groupHeaders[0][colIndex].caption;
        }
      } else {
        caption2 = metaColumn.caption;
      }
    }
    for (let i2 = 0; i2 < columns.length; i2++) {
      if (columns[i2].visible) {
        metaColumns = grid.getMetaColumnAt(i2);
        if (columns[i2].hasOwnProperty("newCaption")) {
          captions2 = columns[i2].newCaption;
        } else {
          if (metaColumns.formulaCaption != "") {
            captions2 = await form2.eval(metaColumns.formulaCaption, new ViewContext(form2));
            if (!captions2) {
              let th = grid.getEl().vnode.elm.querySelectorAll("tr.ui-ygrid-columnheader th[colindex='" + (i2 + 1) + "']")[0];
              captions2 = th.getAttribute("title");
            }
            if (!captions2) {
              captions2 = grid.groupHeaders[0][colIndex].caption;
            }
          } else {
            captions2 = metaColumns.caption;
          }
        }
        if (captions2 == caption2) {
          index2++;
        }
        if (i2 == colIndex) {
          break;
        }
      }
    }
    if (index2 > 1) {
      caption2 = caption2 + "#" + index2;
    }
    return {
      filedKey: metaColumn.key,
      fieldCaption: caption2
    };
  }
  static getFormId(element) {
    let formId2 = element.getAttribute("id"), index2 = formId2.indexOf("_");
    if (index2 > -1) {
      formId2 = formId2.substring(0, index2);
    }
    return formId2;
  }
  static getCurForm() {
    return FormStack.getActiveForm();
  }
  static getColNameByTdEl(tdEl) {
    let currPage2 = _RecordCase2.getCurrPage();
    let ariaDescribedby = tdEl.getAttribute("aria-describedby");
    let th = currPage2.querySelector("#" + ariaDescribedby);
    return th.getAttribute("title");
  }
  // 获取是否为设计器模式
  static getIsDesignModel() {
    return DesignModeSetting.isDesignMode;
  }
  // 判断一个dom元素是否是另一个dom元素的的子元素
  static isChildOf(parentElement, childElement) {
    let parent = childElement.parentNode;
    while (parent !== null && parent !== document.body) {
      if (parent === parentElement) {
        return true;
      }
      parent = parent.parentNode;
    }
    return false;
  }
  static getActiveExcelForm() {
    let currPage2 = _RecordCase2.getCurrPage();
    if (!currPage2) {
      return null;
    }
    let excelWorkSpace = currPage2.querySelectorAll("div.excel-workspace");
    return excelWorkSpace.length > 0 ? excelWorkSpace[0] : null;
  }
  static getExcelCellInfo(tdElement) {
    let excel = _RecordCase2.getActiveExcelForm();
    if (!excel) {
      return;
    }
    let rowindex = tdElement.getAttribute("rowindex");
    let rowElement = excel.querySelectorAll("th[rowindex='" + rowindex + "']");
    let row2 = rowElement[0].innerText;
    let colindex = tdElement.getAttribute("colindex");
    let colElement = excel.querySelectorAll("th[colindex='" + (parseInt(colindex) + 1) + "']");
    let col2 = colElement[0].innerText;
    return {
      row: row2,
      col: col2,
      rowindex,
      colindex,
      location: col2 + "&" + row2
    };
  }
  static getActiveBPMForm() {
    let currPage2 = _RecordCase2.getCurrPage();
    if (!currPage2) {
      return null;
    }
    let bpmWorkSpace = currPage2.querySelectorAll("div.bpm-workspace");
    return bpmWorkSpace.length > 0 ? bpmWorkSpace[0] : null;
  }
  static getSelectedBPMNode() {
    let bpm = _RecordCase2.getActiveBPMForm();
    let nodes = bpm.querySelectorAll("svg > g path[fill='#0096ff'][style*='fill-opacity: 0.5'], svg > g circle.handler[fill='#0096ff']");
    if (nodes.length == 0) {
      return null;
    }
    let node = nodes[0];
    if (!node || !node.parentElement)
      return;
    while (node.parentElement.tagName != "svg") {
      node = node.parentElement;
      if (!node || node.parentElement.tagName == "body")
        return;
    }
    return node;
  }
  //通过传入工作流的节点元素(svg > g)
  //return 节点的名称、同名节点名称和在工作流画布的位置（位置以120*120为一个单元格）
  static getBpmNodeInfo(node) {
    let isSequentialFlow = node.getAttribute("transform") == "matrix(1,0,0,1,0,0)";
    let textElms = node.querySelectorAll("text:not(.iconfont):not(g g text)");
    let caption2 = textElms.length == 0 ? "" : textElms[textElms.length - 1].textContent;
    let equalCapNum = 0;
    if (caption2 != "") {
      let preSiblingElm = node.previousElementSibling;
      while (preSiblingElm != null && preSiblingElm.tagName == "g") {
        let preBpmNodeInfo = _RecordCase2.getBpmNodeInfo(preSiblingElm);
        if (preBpmNodeInfo.caption == caption2) {
          equalCapNum++;
        }
        preSiblingElm = preSiblingElm.previousElementSibling;
      }
    }
    let gElmBoundingClientRect = node.getBoundingClientRect();
    let svgElmBoundingClientRect = node.parentElement.getBoundingClientRect();
    let row2 = Math.floor((gElmBoundingClientRect.top - svgElmBoundingClientRect.top + gElmBoundingClientRect.height / 2) / 120) + 1;
    let col2 = Math.floor((gElmBoundingClientRect.left - svgElmBoundingClientRect.left + gElmBoundingClientRect.width / 2) / 120) + 1;
    return {
      isSequentialFlow,
      caption: caption2,
      finalCaption: equalCapNum == 0 ? caption2 : caption2 + "#" + (equalCapNum + 1),
      location: row2 + "," + col2
    };
  }
};
_RecordCase.recordRowClickContent = "";
_RecordCase.colThCaption = "";
_RecordCase.colThGridKey = "";
_RecordCase.colThValue = "";
_RecordCase.requestRecordResult = async function(content2) {
  if (content2.length > 15e3) {
    let contents = content2.split("\n");
    for (let i2 = 0; i2 < contents.length; i2++) {
      if (i2 == 0) {
        await _RecordCase.requestRecord("result", contents[i2]);
      } else {
        await _RecordCase.requestRecord("step", "查看:表格");
        await _RecordCase.requestRecord("result", contents[i2]);
      }
    }
  } else {
    await _RecordCase.requestRecord("result", content2);
  }
};
_RecordCase.requestRecordTitle = function(content2) {
  _RecordCase.requestRecord("title", content2);
};
_RecordCase.requestRecordDelStep = function() {
  _RecordCase.requestRecord("delStep", "");
};
let RecordCase = _RecordCase;
const ids$2 = [
  "optVisible",
  "optEnable",
  "dictDropValues",
  "fields",
  "fieldEnable",
  "columns",
  "spelLing",
  "cellEnable",
  "cellStyle",
  "tabs",
  "dictDataStatus",
  "comboBoxDropValues",
  "dicTrace",
  "checkRule",
  "columnWidth",
  "enterPermission",
  "formPermission",
  "dictPermission",
  "dictPermissionData",
  "formPermissionData",
  "menu"
];
const _CheckControl = class _CheckControl2 {
  static addListening() {
    for (let i2 in ids$2) {
      document.getElementById(ids$2[i2]).onclick = function() {
        _CheckControl2.checkControl(ids$2[i2]);
        this.parentElement.parentElement.style.display = "none";
      };
    }
  }
};
_CheckControl.checkControl = async function(type2) {
  if (AutoRecord.AutoRecord) {
    let currPage2 = RecordCase.getCurrPage(), formId2 = RecordCase.getFormId(currPage2), form2 = FormStack.getForm(formId2), content2 = "", keyWord = "";
    if (type2 === "dictDropValues") {
      content2 = checkDictDropValues();
      keyWord = "验证:字典:字典下拉";
    } else if (type2 === "optVisible" || type2 === "optEnable") {
      content2 = getContentOpt(currPage2, form2, type2);
      keyWord = "验证:控件";
    } else if (type2 === "comboBoxDropValues") {
      content2 = checkComboBoxDropValues();
      keyWord = "验证:下拉框";
    } else if (type2 === "checkRule") {
      content2 = erifyCheckRule(currPage2);
      keyWord = "验证:检查公式";
    } else if (type2 === "cellEnable") {
      content2 = checkCellEnable(currPage2);
      keyWord = "验证:表格";
    } else if (type2 === "fields" || type2 === "fieldEnable") {
      content2 = getFields(currPage2, form2, formId2, type2);
      keyWord = "验证:控件";
    } else if (type2 === "columns") {
      content2 = await getColumns(currPage2);
      keyWord = "验证:表格";
    } else if (type2 === "spelLing") {
      content2 = getSpelLing(currPage2);
      keyWord = "验证:检查字段";
    } else if (type2 === "tabs") {
      content2 = getTabsContent(currPage2);
      keyWord = "验证:Tab页";
    } else if (type2 === "dictDataStatus") {
      content2 = verifyDict$1(currPage2);
      keyWord = "验证:字典状态";
    } else if (type2 === "cellStyle") {
      content2 = checkCellStyle(currPage2);
      keyWord = "验证:表格";
    } else if (type2 === "dicTrace") {
      content2 = checkDicTrace(currPage2, form2);
      keyWord = "验证:字典追溯";
    } else if (type2 === "columnWidth") {
      content2 = checkColumnWidth(currPage2, form2);
      keyWord = "验证:列宽";
    } else if (type2 === "enterPermission") {
      content2 = checkEnterPermission();
      keyWord = "权限设置:验证:入口权限";
    } else if (type2 === "formPermission") {
      content2 = checkFormPermission();
      keyWord = "权限设置:验证:表单权限";
    } else if (type2 === "dictPermission") {
      content2 = checkDictPermission();
      keyWord = "权限设置:验证:字典权限";
    } else if (type2 === "dictPermissionData") {
      content2 = checkDictOrFormPermissionData("dict");
      keyWord = "权限设置:验证:字典权限:字典数据";
    } else if (type2 === "formPermissionData") {
      content2 = checkDictOrFormPermissionData("form");
      keyWord = "权限设置:验证:表单权限:表单数据";
    } else if (type2 === "menu") {
      content2 = checkMenu();
      keyWord = "验证:菜单";
    }
    if (content2 !== "" && keyWord !== "") {
      setTimeout(() => {
        RecordCase.requestRecordStep(keyWord);
        setTimeout(() => {
          RecordCase.requestRecordResult(content2);
        }, 200);
      }, 200);
    }
  }
};
let CheckControl = _CheckControl;
function checkColumnWidth(currPage2, form2) {
  let grids = currPage2.querySelectorAll(".vnode.ui-ygrid:not(div[role='tabpanel']:not(.aria-show) .vnode.ui-ygrid)");
  let contents = [];
  for (let i2 = 0; i2 < grids.length; i2++) {
    let gridKey = grids[i2].id.replace(/\d+_/, "").replace("_box", "");
    let thElements = grids[i2].querySelectorAll("th.ui-th-column");
    for (let j2 = 0; j2 < thElements.length; j2++) {
      if (thElements[j2].style.display != "none") {
        let colkey = thElements[j2].getAttribute("meta-key");
        let oldkey = thElements[j2].getAttribute("oldkey");
        if ((oldkey != null && oldkey != "" || colkey != null && colkey != "") && thElements[j2].style.width != "") {
          let key2 = colkey || oldkey;
          let title = thElements[j2].getAttribute("title");
          let width = Math.ceil(thElements[j2].style.width.replace("px", ""));
          let thSortElement = thElements[j2].querySelectorAll(".ui-ygrid-sort");
          if (thSortElement.length >= 1) {
            width = width - Math.ceil(thSortElement[0].getBoundingClientRect().width);
          }
          contents.push("[" + form2.formKey + "&" + gridKey + "&" + key2 + "[" + title + "]]&" + key2 + "&" + gridKey + ":" + width);
        }
      }
    }
  }
  return contents.join("\n");
}
let checkDictDropValues = function() {
  let dictDrops = document.querySelectorAll(".bottomlst[style]:not([style*='display:none']):not([style*='display: none'])"), dialogs = document.querySelectorAll(".dialog.show:not([style*='display:none']):not([style*='display: none'])"), dictDrop, content2 = [];
  dictDrop = dictDrops.length === 0 ? dialogs[dialogs.length - 1] : dictDrops[dictDrops.length - 1];
  let classAttribute = dictDrop.getAttribute("class");
  if (classAttribute.indexOf("dialog") > -1) {
    let codeElm = RecordCase.getElementByXpath(".//th//*[contains(@class,'colCaption') and text()='代码']/ancestor::th[1]", dictDrop);
    let nameElms = RecordCase.getElementsByXpath(".//th//*[contains(@class,'colCaption') and text()='名称']/ancestor::th[1]", dictDrop);
    let trElms = RecordCase.getElementsByXpath(".//tr[contains(@id,'ygd')]", dictDrop);
    if (trElms.length === 0) {
      content2.push("null");
    } else {
      for (let i2 = 0; i2 < trElms.length; i2++) {
        let code = RecordCase.getElementByXpath("./td[@aria-describedby='" + codeElm.getAttribute("id").trim() + "']", trElms[i2]).innerText.trim();
        let text;
        if (nameElms.length === 0) {
          text = code;
        } else {
          let name2 = RecordCase.getElementByXpath("./td[@aria-describedby='" + nameElms[0].getAttribute("id").trim() + "']", trElms[i2]).innerText.trim();
          text = code + (name2.length === 0 ? "" : " " + name2);
        }
        content2.push(text);
      }
    }
  } else if (classAttribute.indexOf("chain") > -1 || classAttribute.indexOf("dtquery") > -1) {
    let elements2 = RecordCase.getElementsByXpath(".//table/tr[not(contains(@class,'thead'))] | .//tr[@class='view']//table/tbody/tr", dictDrop);
    if (elements2 == null || elements2.length === 0) {
      content2.push("null");
    } else {
      let isNeedNext = true;
      let codeThLocation = findChainDictThLocation(dictDrop, ["代码", "单据编号", "银行账号", "版本号", "招聘类型", "系统代码"]);
      if (codeThLocation === -1) {
        throw new Error("当前链式字典不存在code这一列,请检查");
      }
      let nameThLocation = findChainDictThLocation(dictDrop, ["名称", "描述", "招聘岗位", "版本描述"]);
      let next = RecordCase.getElementsByXpath(".//div[contains(@class,'paginationjs-pages')]//*[contains(@class,'paginationjs-next') and not(contains(@class,'disabled'))]", dictDrop);
      let prev = RecordCase.getElementsByXpath(".//div[contains(@class,'paginationjs-pages')]//*[contains(@class,'paginationjs-prev') and not(contains(@class,'disabled'))]", dictDrop);
      let nextOrPrev = next.length === 0 && !(prev.length === 0) ? "prev" : "next";
      do {
        elements2 = RecordCase.getElementsByXpath(".//table/tr[not(contains(@class,'thead'))] | .//tr[@class='view']//table/tbody/tr", dictDrop);
        for (let i2 = 0; i2 < elements2.length; i2++) {
          let codeElement = RecordCase.getElementByXpath("./td[" + codeThLocation + "]/div | ./td[" + codeThLocation + "]/text", elements2[i2]);
          let text;
          if (nameThLocation === -1) {
            text = codeElement.innerText.trim();
          } else {
            let nameElement = RecordCase.getElementByXpath("./td[" + nameThLocation + "]/div | ./td[" + nameThLocation + "]/text", elements2[i2]);
            let name2 = nameElement.innerText.trim();
            text = codeElement.innerText.trim() + (name2.length === 0 ? "" : " " + name2);
          }
          content2.push(text);
        }
        let isLastPage = dictDrop.querySelectorAll("div.paginationjs-pages .paginationjs-" + nextOrPrev + ":not([class*='disabled']) a");
        if (isLastPage.length === 0) {
          isNeedNext = false;
        }
        isNeedNext = false;
        if (isNeedNext) {
          isLastPage[0].click();
        }
      } while (isNeedNext);
    }
  } else {
    let elements2 = RecordCase.getElementsByXpath(".//div/li/ul/li", dictDrop);
    if (elements2 == null || elements2.length === 0) {
      content2.push("null");
    } else {
      clickAllDictTree(elements2, content2);
    }
  }
  return content2.join("\n").trim();
};
let findChainDictThLocation = function(dictDrop, arr) {
  let findByThText = [];
  let dialog = dictDrop;
  for (let i2 = 0; i2 < arr.length; i2++) {
    findByThText[i2] = "text()='" + arr[i2] + "'";
  }
  let thElements = RecordCase.getElementsByXpath(".//th[" + findByThText.join(" or ") + "] | .//a[" + findByThText.join(" or ") + "]/..", dialog);
  return thElements.length === 0 ? -1 : RecordCase.getElementsByXpath("./preceding-sibling::th", thElements[0]).length + 1;
};
let clickAllDictTree = function(dictElements, liTextMap) {
  for (let i2 = 0; i2 < dictElements.length; i2++) {
    let dictELement = dictElements[i2];
    let textElement = RecordCase.getElementByXpath("./a/span[@class='b-txt']", dictELement);
    let text = textElement.innerText.trim();
    liTextMap.push(text);
    let spanEle = RecordCase.getElementsByXpath("./span[contains(@class,'dt-expand') or contains(@class,'dt-collapse')]", dictELement);
    let childElements = [];
    if (spanEle != null && !(spanEle.length === 0)) {
      let classAttribute = spanEle[0].getAttribute("class");
      if (classAttribute.indexOf("dt-expand") > -1) {
        childElements = RecordCase.getElementsByXpath(".//ul/li", dictELement);
      } else if (classAttribute.indexOf("dt-collapse") > -1) {
        let clickButton = RecordCase.getElementByXpath(".//span[contains(@class,'icon') and contains(@class,'dt-collapse')]", dictELement);
        clickButton.click();
        childElements = RecordCase.getElementsByXpath(".//ul/li", dictELement);
      }
    }
    if (!(childElements.length === 0)) {
      clickAllDictTree(childElements, liTextMap);
    }
  }
};
let getContentOpt = function(currPage, form, type) {
  let toolbars = currPage.getElementsByClassName("ui-tbr"), content = "", index, caption, captions, captions_1;
  if (toolbars.length == 0)
    return;
  let toolbar = toolbars[0];
  if (type == "optVisible") {
    let operations = form.metaForm.operations, operation, lis, value;
    for (let i = 0; i < operations.length; i++) {
      index = 1;
      operation = operations[i];
      lis = toolbar.querySelectorAll("li[key='" + operation.key + "']");
      if (lis.length == 0) {
        value = "false";
      } else {
        value = lis[0].style.display == "block" ? "true" : "false";
      }
      caption = operation.caption;
      if (caption.indexOf("/") == -1 && caption.indexOf('"') == -1) {
        captions = eval("content.match(/:" + caption + ":/ig)");
        captions_1 = eval("content.match(/:" + caption + "#/ig)");
      }
      if (captions != void 0) {
        index = index + captions.length;
      }
      if (captions_1 != void 0) {
        index = index + captions_1.length;
      }
      if (index > 1) {
        caption = caption + "#" + index;
      }
      if (content == "") {
        content = "操作按钮:可见性:" + caption + ":" + value;
      } else {
        content = content + "\n操作按钮:可见性:" + caption + ":" + value;
      }
      if (operation.items != void 0) {
        content = getItemOptContent(toolbar, operation.items, content);
      }
    }
  } else if (type == "optEnable") {
    let opts = toolbar.getElementsByTagName("li"), opt, value;
    for (let j = 0; j < opts.length; j++) {
      index = 1;
      opt = opts[j];
      value = opt.item.enable;
      if (value == void 0) {
        value = "true";
      }
      if (!opt.item.visible)
        continue;
      caption = opt.firstChild.innerText;
      if (caption.indexOf("/") == -1 && caption.indexOf('"') == -1) {
        captions = eval("content.match(/:" + caption + ":/ig)");
        captions_1 = eval("content.match(/:" + caption + "#/ig)");
      }
      if (captions != void 0) {
        index = index + captions.length;
      }
      if (captions_1 != void 0) {
        index = index + captions_1.length;
      }
      if (index > 1) {
        caption = caption + "#" + index;
      }
      if (content == "") {
        content = "操作按钮:可用性:" + caption + ":" + value;
      } else {
        content = content + "\n操作按钮:可用性:" + caption + ":" + value;
      }
    }
  }
  return content;
};
let getItemOptContent = function(toolbar, items, content) {
  let lis, value, index, caption, captions, captions_1;
  for (let i = 0; i < items.length; i++) {
    index = 1;
    lis = toolbar.querySelectorAll("li[key='" + items[i].key + "']");
    if (lis.length == 0) {
      value = "false";
    } else {
      value = lis[0].style.display == "block" ? "true" : "false";
    }
    caption = items[i].caption;
    if (caption.indexOf("/") == -1 && caption.indexOf('"') == -1) {
      captions = eval("content.match(/:" + caption + ":/ig)");
      captions_1 = eval("content.match(/:" + caption + "#/ig)");
    }
    if (captions != void 0) {
      index = index + captions.length;
    }
    if (captions_1 != void 0) {
      index = index + captions_1.length;
    }
    if (index > 1) {
      caption = caption + "#" + index;
    }
    content = content + "\n操作按钮:可见性:" + caption + ":" + value;
  }
  return content;
};
let checkComboBoxDropValues = function() {
  let comboBoxDrops = document.getElementsByClassName("cmb-vw"), comboBoxDrop, comboBoxLis, content2 = "";
  for (let i2 = 0; i2 < comboBoxDrops.length; i2++) {
    comboBoxDrop = comboBoxDrops[i2];
    if (comboBoxDrop.style.display != "none") {
      comboBoxLis = comboBoxDrop.getElementsByTagName("li");
      if (comboBoxLis != void 0 && comboBoxLis.length != 0) {
        for (let j2 = 0; j2 < comboBoxLis.length; j2++) {
          if (content2 == "") {
            content2 = content2 + comboBoxLis[j2].textContent;
          } else {
            content2 = content2 + "\n" + comboBoxLis[j2].textContent;
          }
        }
      }
    }
  }
  return content2;
};
let erifyCheckRule = function(currPage2) {
  let needVerifyCheckRules = currPage2.querySelectorAll(".ui-cell-error, .ui-cell-required, .error-icon, .required-icon");
  let contents = [];
  for (let i2 = 0; i2 < needVerifyCheckRules.length; i2++) {
    let caption2 = "";
    let content2 = "";
    let cellInfo;
    let needVerifyCheckRule = needVerifyCheckRules[i2];
    if (needVerifyCheckRule.getAttribute("class").indexOf("error-icon") > -1 || needVerifyCheckRule.getAttribute("class").indexOf("required-icon") > -1) {
      let form2 = RecordCase.getCurForm();
      let fieldInfo = RecordCase.getCompCaption(needVerifyCheckRule);
      caption2 = fieldInfo.fieldCaption;
      content2 = "[" + form2.formKey + "&NoGrid&" + fieldInfo.fieldKey + "[" + caption2 + "]]:false";
    } else {
      cellInfo = RecordCase.getCellInfo(RecordCase.getElementByXpath("./ancestor::td[1]", needVerifyCheckRule));
      caption2 = cellInfo.gridKey + "," + cellInfo.rowNum + "," + cellInfo.colNum;
      content2 = "单元格:" + caption2 + ":false";
    }
    contents.push(content2);
  }
  return contents.join("\n");
};
let checkCellEnable = function(currPage2) {
  let highlightCells = currPage2.getElementsByClassName("ui-state-highlight"), highlightCell, enable, cellInfo, dt_txt, content2 = "";
  for (let i2 = 0; i2 < highlightCells.length; i2++) {
    highlightCell = highlightCells[i2];
    if (highlightCell.tagName != "TD" || highlightCell.hasAttribute("style") && highlightCell.getAttribute("style").indexOf("display: none") != -1)
      continue;
    cellInfo = RecordCase.getCellInfo(highlightCell);
    enable = highlightCell.getAttribute("class").indexOf("ui-cell-disabled") == -1;
    dt_txt = "表格:可编辑:[" + cellInfo.formKey + "&" + cellInfo.gridKey + "&" + cellInfo.colKey + "[" + cellInfo.columnCaption + "]]," + cellInfo.gridKey + "," + cellInfo.rowNum + ":" + enable;
    if (content2 == "") {
      content2 = dt_txt;
    } else {
      content2 = content2 + "\n" + dt_txt;
    }
  }
  return content2;
};
let getFields = function(currPage2, form2, formId2, type2) {
  let content2 = "", showTabs = currPage2.querySelectorAll(".ui-tabs-panel.ui-widget-content.ui-corner-bottom.aria-show"), fields;
  if (showTabs != void 0 && showTabs.length != 0) {
    fields = currPage2.querySelectorAll(".ui-tabs-panel.ui-widget-content.ui-corner-bottom.aria-show .ui-control:not([class*='ui-lbl']):not([class*='ui-hidden'])");
  } else {
    fields = currPage2.querySelectorAll(".ui-control:not([class*='ui-lbl']):not([class*='ui-hidden'])");
  }
  for (let i2 = 0; i2 < fields.length; i2++) {
    let key2 = fields[i2].id.replace(formId2 + "_", ""), comp2 = form2.getComponent(key2);
    if (comp2 == void 0 || comp2.type == void 0)
      continue;
    if (isControl(comp2)) {
      if (type2 == "fields") {
        if (content2 == "") {
          content2 = "可见字段:[" + form2.formKey + "&NoGrid&" + key2 + "[" + comp2.caption + "]]";
        } else {
          content2 = content2 + ",[" + form2.formKey + "&NoGrid&" + key2 + "[" + comp2.caption + "]]";
        }
      } else if (type2 == "fieldEnable") {
        if (content2 == "") {
          content2 = "控件:可编辑:" + comp2.caption + ":" + comp2.enable;
        } else {
          content2 = content2 + "\n控件:可编辑:" + comp2.caption + ":" + comp2.enable;
        }
      }
    }
  }
  return content2;
};
let isControl = function(comp2) {
  return comp2.type == ControlType.CHECKBOX || comp2.type == ControlType.CHECKLISTBOX || comp2.type == ControlType.COMBOBOX || comp2.type == ControlType.DATEPICKER || comp2.type == ControlType.DICT || comp2.type == ControlType.NUMBEREDITOR || comp2.type == ControlType.TEXTBUTTON || comp2.type == ControlType.TEXTEDITOR || comp2.type == ControlType.TEXTAREA || comp2.type == ControlType.TIMEPICKER || comp2.type == ControlType.UTCDATEPICKER || comp2.type == ControlType.BUTTON;
};
let getColumns = async function(currPage2) {
  let content2 = [], girds = currPage2.querySelectorAll(".ui-ygrid:not(div[role='tabpanel']:not(.aria-show) .vnode.ui-ygrid)");
  if (girds.length > 0) {
    let gridkey;
    for (let i2 = 0; i2 < girds.length; i2++) {
      gridkey = girds[i2].getAttribute("id").replace(/[\d]+_/, "").replace("_box", "");
      let thElms = RecordCase.getElementsByXpath(".//th[contains(@id,'column') and not(contains(@style,'display:none')) and not(contains(@style,'display: none'))]", girds[i2]);
      let thColCaption = [];
      let map = /* @__PURE__ */ new Map();
      for (let j2 = 0; j2 < thElms.length; j2++) {
        let thCaption = thElms[j2].querySelectorAll(".col-caption")[0].innerText.trim();
        if (map.has(thCaption)) {
          map.set(thCaption, map.get(thCaption) + 1);
          thColCaption.push(thCaption + "#" + map.get(thCaption));
        } else {
          map.set(thCaption, 1);
          thColCaption.push(thElms[j2].querySelectorAll(".col-caption")[0].innerText);
        }
      }
      content2.push("表格列," + gridkey + ":" + thColCaption.join(","));
    }
  }
  return content2.join("\n");
};
let getSpelLing = function(currPage2) {
  let highlightCells = currPage2.getElementsByClassName("ui-state-highlight"), highlightCell, cellInfo, content2 = [];
  for (let i2 = 0; i2 < highlightCells.length; i2++) {
    highlightCell = highlightCells[i2];
    if (highlightCell.tagName !== "TD" || highlightCell.getAttribute("style").indexOf("display: none") > -1 || highlightCell.getAttribute("style").indexOf("display:none") > -1)
      continue;
    let error = highlightCell.querySelectorAll(".ui-cell-error, .ui-cell-required");
    if (error.length === 0)
      continue;
    cellInfo = RecordCase.getCellInfo(highlightCell);
    content2.push("单元格:" + cellInfo.gridKey + "," + cellInfo.rowNum + "," + cellInfo.colNum + ":" + error[0].title);
  }
  return content2.join("\n");
};
let getTabsContent = function(currPage2) {
  let tabs = currPage2.querySelectorAll("ul.tab-list li[role='tab']");
  let contents = [];
  let form2 = RecordCase.getCurForm();
  for (let i2 = 0; i2 < tabs.length; i2++) {
    let caption2 = tabs[i2].textContent;
    let style = tabs[i2].getAttribute("style");
    let status = style == null || !(style.indexOf("display: none") > -1 || style.indexOf("display:none") > -1);
    let tabKey = tabs[i2].getAttribute("control-key");
    contents.push("TAB页:完整名称:[" + form2.formKey + "&NoGrid&" + tabKey + "[" + caption2 + "]]:" + status);
  }
  return contents.join("\n");
};
let verifyDict$1 = function(currPage2) {
  let content2 = "", dictViews = currPage2.getElementsByClassName("ui-dv paginationjs");
  if (dictViews.length > 0) {
    let elements2, element, value2, enable;
    for (let i2 = 0; i2 < dictViews.length; i2++) {
      elements2 = dictViews[i2].getElementsByClassName("selected");
      if (elements2.length == 0) {
        alert("没有选择验证的字典行");
        return "";
      } else {
        element = elements2[0];
        enable = element.getAttribute("class");
        value2 = element.firstElementChild.innerText.trim();
        if (enable == null || enable === "selected") {
          value2 = value2 + ":启用";
        } else if (enable.indexOf("disabled") > -1) {
          value2 = value2 + ":停用";
        } else if (enable.indexOf("invalid") > -1) {
          value2 = value2 + ":作废";
        }
        if (content2 == "") {
          content2 = value2;
        } else {
          content2 = content2 + "\n" + value2;
        }
      }
    }
  }
  return content2;
};
let checkCellStyle = function(currPage2) {
  let highlightCells = currPage2.getElementsByClassName("ui-state-highlight"), highlightCell, cellInfo, gridKey, rowindex, cellHeadTitle, cellStyle, cellStyles, content2 = "", dt_txt;
  for (let i2 = 0; i2 < highlightCells.length; i2++) {
    let color = "字体颜色[默认]", background_color = "背景颜色[默认]", text_align = "行对齐[默认]", border = "边框[无]", font_family = "字体[默认]", font_size = "字体大小[默认]", font_weight = "加粗[否]", font_style = "斜体[否]";
    highlightCell = highlightCells[i2];
    if (highlightCell.tagName != "TD")
      continue;
    cellInfo = RecordCase.getCellInfo(highlightCell);
    gridKey = cellInfo.gridKey;
    rowindex = cellInfo.rowNum;
    cellHeadTitle = cellInfo.columnCaption;
    cellStyle = highlightCell.getAttribute("style");
    let styleString = "表格:样式:[" + cellInfo.formKey + "&" + gridKey + "&" + cellInfo.colKey + "[" + cellHeadTitle + "]]," + gridKey + "," + rowindex + ":";
    if (cellStyle != void 0 && cellStyle != "") {
      cellStyles = cellStyle.split(";");
      for (let j2 = 0; j2 < cellStyles.length; j2++) {
        if (cellStyles[j2].indexOf("background") > -1) {
          background_color = "背景颜色[" + cellStyles[j2].split(": ")[1] + "]";
        } else if (cellStyles[j2].indexOf("color") > -1) {
          color = "字体颜色[" + cellStyles[j2].split(": ")[1] + "]";
        } else if (cellStyles[j2].indexOf("text-align") > -1) {
          if (cellStyles[j2].indexOf("center") > -1) {
            text_align = "行对齐[居中]";
          } else if (cellStyles[j2].indexOf("left") > -1) {
            text_align = "行对齐[左对齐]";
          } else {
            text_align = "行对齐[右对齐]";
          }
        } else if (cellStyles[j2].indexOf("border") > -1) {
          if (cellStyles[j2].indexOf("width") > -1 && cellStyles[j2].indexOf("initial") == -1) {
            border = "边框[所有框线]";
          } else if (cellStyles[j2].indexOf("top") > -1 && cellStyles[j2].indexOf("none") == -1) {
            border = "边框[上框线]";
          } else if (cellStyles[j2].indexOf("bottom") > -1 && cellStyles[j2].indexOf("none") == -1) {
            border = "边框[下框线]";
          } else if (cellStyles[j2].indexOf("left") > -1 && cellStyles[j2].indexOf("none") == -1) {
            border = "边框[左框线]";
          } else if (cellStyles[j2].indexOf("right") > -1 && cellStyles[j2].indexOf("none") == -1) {
            border = "边框[右框线]";
          }
        } else if (cellStyles[j2].indexOf("font-family") > -1) {
          font_family = "字体[" + cellStyles[j2].split(": ")[1] + "]";
        } else if (cellStyles[j2].indexOf("font-size") > -1) {
          font_size = "字体大小[" + cellStyles[j2].split(": ")[1] + "]";
        } else if (cellStyles[j2].indexOf("font-weight") > -1) {
          if (cellStyles[j2].indexOf("bold") > -1) {
            font_weight = "加粗[是]";
          }
        } else if (cellStyles[j2].indexOf("font-style") > -1) {
          if (cellStyles[j2].indexOf("italic") > -1) {
            font_style = "斜体[是]";
          }
        }
      }
    }
    dt_txt = styleString + color + "," + background_color + "," + text_align + "," + border + "," + font_family + "," + font_size + "," + font_weight + "," + font_style;
    if (content2 == "") {
      content2 = dt_txt;
    } else {
      content2 = content2 + "\n" + dt_txt;
    }
  }
  return content2;
};
let checkDicTrace = function(currPage2, form2) {
  let content2 = "";
  currPage2.querySelectorAll("div.popup-dic-img-not").forEach(function(btn) {
    if (btn.parentElement.tagName == "td") {
      let tdEl = btn.parentElement;
      let gridKey = tdEl.getAttribute("aria-describedby").split("_")[1];
      let colKey = tdEl.getAttribute("meta-key");
      let trId = tdEl.parentElement.getAttribute("id");
      let rowIndex = trId.charAt(trId.length - 1);
      let colTitle = RecordCase.getColNameByTdEl(tdEl);
      content2 = content2 + gridKey + ",[" + form2.formKey + "&" + gridKey + "&" + colKey + "[" + colTitle + "]]," + rowIndex + ":true\n";
    } else {
      let id = btn.parentElement.getAttribute("id");
      let caption2 = btn.parentElement.getAttribute("caption");
      if (id == void 0 || id == "") {
        id = btn.parentElement.firstElementChild.getAttribute("id");
        caption2 = btn.parentElement.firstElementChild.getAttribute("caption");
      }
      id = id.replace(/[0-9]_/, "");
      content2 = content2 + "[" + form2.formKey + "&NoGrid&" + id + "[" + caption2 + "]]:true\n";
    }
  });
  return content2.substring(0, content2.length - 1);
};
let checkEnterPermission = function() {
  let content2 = "";
  let iframe = document.querySelector("div[id*='RightsSet'] iframe");
  let iframeDocument = iframe.contentDocument;
  let entryTrs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-entry div.t-bdiv table tbody tr:not([style*='display: none'])");
  if (entryTrs.length == 0) {
    return content2;
  }
  for (let i2 = 0; i2 < entryTrs.length; i2++) {
    let entryTr = entryTrs[i2];
    let entryCheckSpan = entryTr.querySelector("td span.checkbox");
    let isCheck = entryCheckSpan.getAttribute("chkstate") == "1" ? "true" : "false";
    let circulateNum = 0;
    let nameTd = entryTr.querySelector("td");
    let entryPath = nameTd.textContent;
    while (entryTr.hasAttribute("pid") && circulateNum < 10) {
      let pid = entryTr.getAttribute("pid");
      entryTr = iframeDocument.querySelector("[id='" + pid + "']");
      nameTd = entryTr.querySelector("td");
      entryPath = nameTd.textContent + "," + entryPath;
      circulateNum++;
    }
    if (content2 == "") {
      content2 = entryPath + ":" + isCheck;
    } else {
      content2 += "\n" + entryPath + ":" + isCheck;
    }
  }
  return content2;
};
let checkFormPermission = function() {
  let content2 = "";
  let permissionContent = "";
  let displayContent = "";
  let editContent = "";
  let iframe = document.querySelector("div[id*='RightsSet'] iframe");
  let iframeDocument = iframe.contentDocument;
  let permissionThs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-form-opt div.t-hdiv table thead tr input");
  let displayOrEditThs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-form-field div.t-hdiv table thead tr input");
  if (permissionThs.length == 0) {
    return content2;
  }
  let isPermissionThCheck = permissionThs[0].getAttribute("value") == "true" ? "true" : "false";
  let isDisplayThCheck = displayOrEditThs[0].getAttribute("value") == "true" ? "true" : "false";
  let isEditThCheck = displayOrEditThs[1].getAttribute("value") == "true" ? "true" : "false";
  permissionContent = "列头:有权限:" + isPermissionThCheck;
  displayContent = "列头:可见:" + isDisplayThCheck;
  editContent = "列头:可编辑:" + isEditThCheck;
  let permissionTrs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-form-opt div.t-bdiv table tbody tr:not([style*='display: none'])");
  let displayOrEditTrs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-form-field div.t-bdiv table tbody tr:not([style*='display: none'])");
  for (let i2 = 0; i2 < permissionTrs.length; i2++) {
    let permissionTr = permissionTrs[i2];
    let trKey = permissionTr.getAttribute("key");
    let permissionInput = permissionTr.querySelector("input");
    let isCheck = permissionInput.getAttribute("value") == "true" ? "true" : "false";
    permissionContent += "\n" + trKey + ":有权限:" + isCheck;
  }
  for (let i2 = 0; i2 < displayOrEditTrs.length; i2++) {
    let displayOrEditTr = displayOrEditTrs[i2];
    let trKey = displayOrEditTr.getAttribute("key");
    let displayInput = RecordCase.getElementByXpath("./td[3]/input", displayOrEditTr);
    let editInput = RecordCase.getElementByXpath("./td[4]/input", displayOrEditTr);
    let displayIsCheck = displayInput.getAttribute("value") == "true" ? "true" : "false";
    let editIsCheck = editInput.getAttribute("value") == "true" ? "true" : "false";
    displayContent += "\n" + trKey + ":可见:" + displayIsCheck;
    editContent += "\n" + trKey + ":可编辑:" + editIsCheck;
  }
  content2 = permissionContent + "\n" + displayContent + "\n" + editContent;
  return content2;
};
let checkDictPermission = function() {
  let content2 = "";
  let displayContent = "";
  let editContent = "";
  let iframe = document.querySelector("div[id*='RightsSet'] iframe");
  let iframeDocument = iframe.contentDocument;
  let dictThs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-dict-right div.t-hdiv table thead tr input");
  if (dictThs.length == 0) {
    return content2;
  }
  let isPermissionThCheck = dictThs[1].getAttribute("value") == "true" ? "true" : "false";
  let isDisplayThCheck = dictThs[0].getAttribute("value") == "true" ? "true" : "false";
  let isEditThCheck = dictThs[2].getAttribute("value") == "true" ? "true" : "false";
  displayContent = "列头:空值有权限:" + isPermissionThCheck + "\n列头:可见:" + isDisplayThCheck;
  editContent = "列头:可编辑" + isEditThCheck;
  let dictTrs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-dict-right div.t-bdiv table tbody tr");
  for (let i2 = 0; i2 < dictTrs.length; i2++) {
    let dictTr = dictTrs[i2];
    let codeSpan = RecordCase.getElementByXpath("./td[1]/span[2]", dictTr);
    let trCode = codeSpan.textContent;
    let displayInput = RecordCase.getElementByXpath("./td[3]/input", dictTr);
    let editInput = RecordCase.getElementByXpath("./td[4]/input", dictTr);
    let displayIsCheck = displayInput.getAttribute("value") == "true" ? "true" : "false";
    let editIsCheck = editInput.getAttribute("value") == "true" ? "true" : "false";
    displayContent += "\n" + trCode + ":可见:" + displayIsCheck;
    editContent += "\n" + trCode + ":可编辑:" + editIsCheck;
  }
  content2 = displayContent + "\n" + editContent;
  return content2;
};
let checkDictOrFormPermissionData = function(type2) {
  let content2 = "";
  let iframe = document.querySelector("div[id*='RightsSet'] iframe");
  let iframeDocument = iframe.contentDocument;
  let dictOrFormDataTrs;
  if (type2 == "dict") {
    dictOrFormDataTrs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-dict-left div.t-bdiv table tbody tr");
  } else if (type2 == "form") {
    dictOrFormDataTrs = iframeDocument.querySelectorAll("div.rts-main div.tab-item.show div.rts-form-left div.t-bdiv table tbody tr");
  }
  if (dictOrFormDataTrs.length == 0) {
    return content2;
  }
  for (let i2 = 0; i2 < dictOrFormDataTrs.length; i2++) {
    let dictDataTr = dictOrFormDataTrs[i2];
    let nameSpan = RecordCase.getElementByXpath("./td[1]/span[2]", dictDataTr);
    if (content2 == "") {
      content2 = nameSpan.textContent;
    } else {
      content2 += "\n" + nameSpan.textContent;
    }
  }
  return content2;
};
let checkMenu = function() {
  let content2 = "";
  let menuLis = document.querySelectorAll("div.mainLeft div[id='listBox'] ul li[class='tm-node']");
  for (let i2 = 0; i2 < menuLis.length; i2++) {
    let menuLi = menuLis[i2];
    let nodeName = menuLi.querySelector("span.tm-name").textContent;
    let menuPath = nodeName;
    let previousLevelNum = 0;
    while (previousLevelNum < 20 && menuLi.getAttribute("class").indexOf("top-level") <= 0) {
      menuLi = menuLi.parentElement.parentElement.parentElement;
      nodeName = menuLi.querySelector("span.tm-name").textContent;
      menuPath = nodeName + ";" + menuPath;
      previousLevelNum++;
    }
    if (content2 == "") {
      content2 = "菜单:" + menuPath + ":true";
    } else {
      content2 = content2 + "\n菜单:" + menuPath + ":true";
    }
  }
  return content2;
};
let code_a = "";
const _ShortcutKey = class _ShortcutKey2 {
  static addShortcutKey() {
    document.onkeydown = function(e) {
      if (AutoRecord.AutoRecord) {
        if (code_a == "" || e.code == "ControlLeft") {
          code_a = e.code;
        } else {
          if (code_a + e.code == "ControlLeftNumpad1" || code_a + e.code == "ControlLeftDigit1") {
            let r = confirm("是否增加录制步骤");
            if (r == true) {
              let content2 = prompt("录制步骤", "");
              if (content2 != void 0) {
                RecordCase.requestRecordStep(content2);
              }
            }
          } else if (code_a + e.code == "ControlLeftNumpad2" || code_a + e.code == "ControlLeftDigit2") {
            let r = confirm("是否删除一行");
            if (r == true) {
              RecordCase.requestRecordDelStep();
            }
          } else if (code_a + e.code == "ControlLeftNumpad3" || code_a + e.code == "ControlLeftDigit3") {
            let r = confirm("是否查看");
            if (r == true) {
              let content2 = prompt("输入查看类型数值:1.表格 2.非表格 3.字典树  4.表格行  5.表格行数 6.历史记录 7.表格部分数据", "");
              if (content2 != void 0) {
                if (content2 == "1") {
                  CheckData.checkData("checkGrid");
                } else if (content2 == "2") {
                  CheckData.checkData("checkNonGrid");
                } else if (content2 == "3") {
                  CheckData.checkData("checkDictView");
                } else if (content2 == "4") {
                  CheckData.checkData("checkGridRow");
                } else if (content2 == "5") {
                  CheckData.checkData("checkAllGridRow");
                } else if (content2 == "6") {
                  _ShortcutKey2.CHRInputValue = prompt("请输入此时输入框中的内容，默认为空格", "空格");
                  CheckData.checkData("checkHistoryRecords");
                } else if (content2 == "7") {
                  CheckData.checkData("checkGridPartData");
                } else {
                  alert("没有查看类型'" + content2 + "'");
                }
              }
            }
          } else if (code_a + e.code == "ControlLeftNumpad4" || code_a + e.code == "ControlLeftDigit4") {
            let r = confirm("是否验证");
            if (r == true) {
              let content2 = prompt("输入验证类型数值:1.操作可见性 2.操作可用性 3.可见字段 4.字段可用性 5.可见表格列 6.单元格可用性 7.单元格样式 8.可见Tab页 9.字典状态 10.字典下拉框 11.下拉框", "");
              if (content2 != void 0) {
                if (content2 == "1") {
                  CheckControl.checkControl("optVisible");
                } else if (content2 == "2") {
                  CheckControl.checkControl("optEnable");
                } else if (content2 == "3") {
                  CheckControl.checkControl("fields");
                } else if (content2 == "4") {
                  CheckControl.checkControl("fieldEnable");
                } else if (content2 == "5") {
                  CheckControl.checkControl("columns");
                } else if (content2 == "6") {
                  CheckControl.checkControl("cellEnable");
                } else if (content2 == "7") {
                  CheckControl.checkControl("cellStyle");
                } else if (content2 == "8") {
                  CheckControl.checkControl("tabs");
                } else if (content2 == "9") {
                  CheckControl.checkControl("dictDataStatus");
                } else if (content2 == "10") {
                  CheckControl.checkControl("dictDropValues");
                } else if (content2 == "11") {
                  CheckControl.checkControl("comboBoxDropValues");
                } else {
                  alert("没有验证类型'" + content2 + "'");
                }
              }
            }
          } else if (code_a + e.code == "ControlLeftNumpad5" || code_a + e.code == "ControlLeftDigit5") {
            let r = confirm("是否增加标题");
            if (r == true) {
              let content2 = prompt("标题", "");
              if (content2 != void 0) {
                RecordCase.requestRecordTitle(content2);
              }
            }
          }
          code_a = "";
        }
      }
    };
    document.addEventListener("keydown", function(e) {
      if (!RecordCase.getIsDesignModel()) {
        return;
      } else if (e.ctrlKey && e.code === "KeyZ") {
        if (AutoRecord.AutoRecord) {
          RecordCase.requestRecordStep("设计器快捷键:源代码:ctrl+z");
        }
      } else if (e.ctrlKey) {
        AutoRecord.isCtrlDown = true;
      }
    });
    document.addEventListener("keyup", function(e) {
      if (e.ctrlKey) {
        AutoRecord.isCtrlDown = false;
      }
    });
  }
};
_ShortcutKey.CHRInputValue = "空格";
let ShortcutKey = _ShortcutKey;
const ids$1 = ["checkGrid", "checkNonGrid", "checkGridRow", "checkDictView", "checkAllGridRow", "checkHistoryRecords", "checkGridSearch", "checkLongText", "currentPage", "checkGridPartData"];
const _CheckData = class _CheckData2 {
  static addListening() {
    for (let i2 in ids$1) {
      document.getElementById(ids$1[i2]).onclick = function() {
        _CheckData2.checkData(ids$1[i2]);
        this.parentElement.parentElement.style.display = "none";
      };
    }
  }
};
_CheckData.checkData = async function(type2) {
  if (AutoRecord.AutoRecord) {
    let currPage2 = RecordCase.getCurrPage(), formId2 = RecordCase.getFormId(currPage2), form2 = FormStack.getForm(formId2), content2 = "", keyWord = "";
    if (type2 === "checkNonGrid") {
      keyWord = "查看:单据";
      content2 = getCurrPageContent(currPage2);
    } else if (type2 === "checkGrid") {
      keyWord = "查看:表格";
      content2 = await getCurrPageContent_grid(currPage2, form2, formId2, 9999);
    } else if (type2 === "checkGridRow") {
      keyWord = "查看:表格行";
      content2 = GridRowValues(currPage2, formId2);
    } else if (type2 === "checkDictView") {
      keyWord = "查看:字典树";
      content2 = verifyDict(currPage2);
    } else if (type2 === "checkAllGridRow") {
      keyWord = "查看:表格行数";
      content2 = checkAllGridRow(currPage2);
    } else if (type2 === "checkHistoryRecords") {
      let contents = checkHistoryRecords(currPage2, formId2, form2);
      keyWord = "查看:历史记录:" + contents[0] + ":" + ShortcutKey.CHRInputValue;
      content2 = contents[1];
    } else if (type2 === "checkGridSearch") {
      keyWord = "查看:表格搜索";
      content2 = checkGridSearch(currPage2);
    } else if (type2 === "checkLongText") {
      keyWord = "查看:表格搜索";
      content2 = checkLongText();
    } else if (type2 === "currentPage") {
      checkCurrentPage();
      return;
    } else if (type2 === "checkGridPartData") {
      let commandInfo = getGridSelectContent(currPage2);
      keyWord = commandInfo[0];
      content2 = commandInfo[1];
    }
    if (content2 !== "" && keyWord !== "") {
      setTimeout(() => {
        RecordCase.requestRecordStep(keyWord);
        setTimeout(() => {
          RecordCase.requestRecordResult(content2);
        }, 200);
      }, 200);
    }
  }
};
let CheckData = _CheckData;
let getCurrPageContent = function(currPage2, form2, formId2) {
  let formIds = [];
  formIds.push(currPage2.getAttribute("id").split("_")[0]);
  let embedElements = currPage2.querySelectorAll(".mainContainer");
  for (let i2 = 0; i2 < embedElements.length; i2++) {
    formIds.push(embedElements[i2].getAttribute("id").split("_")[0]);
  }
  let content2;
  for (let i2 = 0; i2 < formIds.length; i2++) {
    let elements2 = currPage2.querySelectorAll(".ui-control[id^= '" + formIds[i2] + "_']:not([class*='ui-lbl']):not([class*='ui-hidden']), div.ui-rdo[id^='" + formIds[i2] + "']");
    let embed_form = FormStack.getForm(formIds[i2]);
    if (!content2) {
      content2 = getContent(elements2, embed_form, formIds[i2]);
    } else {
      content2 = content2 + "\n" + getContent(elements2, embed_form, formIds[i2]);
    }
  }
  return content2;
};
let getContent = function(elements, form, formId) {
  let content = "", key, value, caption, captions, captions_, comp, rowContent, special_char = [".", '"', "(", ")", "/", "$", "[", "]", "{", "}", "|", "+", "?", "^", "*"];
  for (let i = 0; i < elements.length; i++) {
    key = elements[i].id.replace(formId + "_", "");
    comp = form.getComponent(key);
    if (comp == void 0 || comp.type == void 0)
      continue;
    if (comp.type == ControlType.CHECKBOX || comp.type == ControlType.CHECKLISTBOX || comp.type == ControlType.COMBOBOX || comp.type == ControlType.DATEPICKER || comp.type == ControlType.DICT || comp.type == ControlType.NUMBEREDITOR || comp.type == ControlType.TEXTBUTTON || comp.type == ControlType.TEXTEDITOR || comp.type == ControlType.TEXTAREA || comp.type == ControlType.TIMEPICKER || comp.type == ControlType.UTCDATEPICKER || comp.type == ControlType.DYNAMICDICT || comp.type == ControlType.RADIOBUTTON || comp.type == ControlType.HYPERLINK) {
      if (comp.visible) {
        caption = key;
        if (comp.buddyKey != void 0 && comp.buddyKey != "") {
          let buddyLabel = document.querySelectorAll("[id='" + formId + "_" + comp.buddyKey + "']");
          if (buddyLabel != void 0 && buddyLabel.length != 0) {
            caption = buddyLabel[0].firstElementChild.innerText.trim();
          }
        }
        if (comp.type == ControlType.CHECKBOX) {
          caption = elements[i].textContent + ",,复选框";
          value = comp.value;
        } else if (comp.type == ControlType.TEXTEDITOR || comp.type == ControlType.TEXTBUTTON || comp.type == ControlType.TEXTAREA) {
          if (comp.type == ControlType.TEXTBUTTON && comp.value == void 0) {
            value = "";
          } else if (comp.type == ControlType.TEXTEDITOR && comp.value == void 0) {
            value = "";
          } else {
            value = comp.value;
          }
        } else if (comp.type == ControlType.TIMEPICKER) {
          value = comp.getText();
        } else if (comp.type == ControlType.RADIOBUTTON) {
          value = "" + comp.getEl().vnode.elm.hasAttribute("ischecked");
        } else {
          value = comp.showText;
        }
        value = RecordCase.replaceToTestCaseStepValue(value);
        if (AutoRecord.ISUE) {
          caption = comp.caption || comp.key || caption;
        }
        let matchCaption = caption;
        for (let k = 0; k < special_char.length; k++) {
          matchCaption = matchCaption.replaceAll(special_char[k], "\\" + special_char[k]);
        }
        captions = eval("content.match(/\\n" + matchCaption + ":/ig)");
        let isStartWithCaption = content.startsWith(matchCaption);
        if (captions != void 0 || isStartWithCaption) {
          captions_ = eval("content.match(/\\n" + matchCaption + "#/ig)");
          if (captions_ != void 0) {
            caption = caption + "#" + (captions_.length + 2);
          } else {
            caption = caption + "#2";
          }
        }
        rowContent = "[" + form.formKey + "&NoGrid&" + comp.key + "[" + caption + "]]:" + value;
        if (content == "") {
          content = rowContent;
        } else {
          content = content + "\n" + rowContent;
        }
      }
    }
  }
  return content;
};
let getCurrPageContent_grid = async function(currPage2, form2, formId2, until) {
  let content_grid = "", girds = currPage2.querySelectorAll(".ui-ygrid:not(div[role='tabpanel']:not(.aria-show) .vnode.ui-ygrid)");
  if (girds.length > 0) {
    content_grid = await getContentGridByElements(girds, form2, formId2, until);
  }
  girds = currPage2.getElementsByClassName("ui-lv paginationjs");
  if (girds.length > 0) {
    if (content_grid == "") {
      content_grid = getListViewContentByElement(girds);
    } else {
      content_grid = content_grid + "\n" + getListViewContentByElement(girds);
    }
  }
  return content_grid;
};
let getGridSelectContent = function(currentPage) {
  let commandAndContent = ["", ""];
  let tdEls = currentPage.querySelectorAll("td.ui-state-highlight:not([style*='display: none'])");
  if (tdEls.length != 0) {
    let contentMap = /* @__PURE__ */ new Map();
    let firstTdInfo = RecordCase.getCellInfo(tdEls[0]);
    let gridKey = firstTdInfo.gridKey;
    let firstColName = firstTdInfo.columnCaption;
    for (let i2 = 0; i2 < tdEls.length; i2++) {
      let cellInfo = RecordCase.getCellInfo(tdEls[i2]);
      if (!contentMap.has(cellInfo.columnCaption)) {
        contentMap.set(cellInfo.columnCaption, []);
      }
      let values = contentMap.get(cellInfo.columnCaption);
      let value2 = tdEls[i2].innerText;
      if (value2.indexOf("\n") > -1) {
        value2 = "{{{" + value2 + "}}}";
      }
      values.push(value2);
    }
    let content2 = "[" + firstTdInfo.formKey + "&" + gridKey + "&" + firstTdInfo.colKey + "[" + firstColName + "]]:" + contentMap.get(firstColName).join(";");
    contentMap.delete(firstColName);
    for (let item of contentMap.entries()) {
      content2 = content2 + "\n" + item[0] + ":" + item[1].join(";");
    }
    commandAndContent[0] = "查看:表格部分数据:" + gridKey;
    commandAndContent[1] = content2;
  }
  return commandAndContent;
};
let getContentGridByElements = async function(elements2, form2, formId2, until) {
  let content2 = "", gridkey, grid, content_grid = "", gridId = "", embed_formId = "", embed_form;
  for (let i2 = 0; i2 < elements2.length; i2++) {
    if (elements2[i2].getAttribute("class").indexOf("hidden") > -1)
      continue;
    gridId = elements2[i2].getAttribute("id");
    embed_formId = gridId.split("_")[0];
    if (embed_formId != "" && embed_formId != formId2) {
      gridkey = gridId.replace(embed_formId + "_", "").replace("_box", "");
      if (embed_form == void 0) {
        embed_form = FormStack.getForm(embed_formId);
      }
      grid = embed_form.getComponent(gridkey);
      content_grid = await getContentGrid(grid, embed_form, until);
    } else {
      gridkey = gridId.replace(formId2 + "_", "").replace("_box", "");
      grid = form2.getComponent(gridkey);
      content_grid = await getContentGrid(grid, form2, until);
    }
    if (content_grid != "") {
      if (content2 == "") {
        content2 = content_grid;
      } else {
        content2 = content2 + "\n" + content_grid;
      }
    }
  }
  return content2;
};
let getContentGrid = async function(grid, form2, until) {
  let detailMetaRow = grid.getDetailMetaRow(), data = grid.dataModel.data, columns = grid.dataModel.columns, cells, metaColumn, cellComp, value2, check, caption2, content_grid = "";
  if (detailMetaRow == void 0) {
    detailMetaRow = grid.getMetaObj().rows[0];
  }
  if (data.length == 0) {
    return "表格:行数:0," + grid.key;
  } else {
    cells = detailMetaRow.cells;
  }
  if (until > data.length) {
    until = data.length;
  }
  let trs = grid.getEl().vnode.elm.querySelectorAll("tr[id][role='row']");
  if (trs.length < data.length && until > 30) {
    trs = await getContentGridByScroll(grid);
  }
  for (let i2 = 0; i2 < cells.length; i2++) {
    check = "";
    metaColumn = grid.getMetaColumnAt(i2);
    if (metaColumn == void 0)
      continue;
    cellComp = detailMetaRow.cells[i2];
    if (cellComp.cellType == ControlType.BUTTON)
      continue;
    if (columns[i2].visible) {
      for (let j2 = 0; j2 < until; j2++) {
        if (data[j2].visible != void 0 && !data[j2].visible)
          continue;
        let rowEl = grid.getEl().$table.getRow(j2) ? grid.getEl().$table.getRow(j2).vnode.elm : trs[j2];
        if (rowEl.style != void 0 && rowEl.style.display == "none")
          continue;
        value2 = data[j2].data[i2].caption;
        if (value2 == void 0) {
          value2 = "";
        }
        value2 = "" + value2.trim();
        if (value2.indexOf("\n") > -1) {
          value2 = "{{{" + value2 + "}}}";
        }
        if (cellComp.cellType == ControlType.CHECKBOX && value2 == "")
          value2 = data[j2].data[i2].value == null ? "" : data[j2].data[i2].value;
        if (check == "") {
          let colInfo = await RecordCase.getMetaColumnCaption(form2, grid, i2);
          caption2 = colInfo.fieldCaption;
          check = grid.key + "&[" + form2.formKey + "&" + grid.key + "&" + colInfo.filedKey + "[" + caption2 + "]]:" + value2;
        } else {
          check = check + ";" + value2;
        }
      }
      if (check != "") {
        if (content_grid == "") {
          content_grid = check;
        } else {
          content_grid = content_grid + "\n" + check;
        }
      }
    }
  }
  return content_grid;
};
let getContentGridByScroll = async function(grid) {
  alert("当前表格" + grid.key + "数据较多未加载完全，需要滚动查看，请勿操作页面，点击确定继续");
  let bDiv = grid.getEl().vnode.elm.querySelector(".ui-ygrid-bdiv");
  bDiv.scrollTop = 0;
  await sleep(500);
  let trs = grid.getEl().vnode.elm.querySelectorAll("tr[id][role='row']");
  let allTrs = trs;
  let mergedArray;
  let uniqueArray;
  let i2 = 0;
  while (true) {
    mergedArray = Array.from(allTrs).concat(Array.from(trs));
    uniqueArray = mergedArray.filter((item, index2) => mergedArray.indexOf(item) === index2);
    if (allTrs.length === uniqueArray.length && i2 !== 0) {
      break;
    }
    allTrs = uniqueArray;
    trs[trs.length - 1].scrollIntoViewIfNeeded({ behavior: "smooth" });
    await sleep(500);
    trs = grid.getEl().vnode.elm.querySelectorAll("tr[id][role='row']");
    i2++;
    if (i2 === 9999) {
      break;
    }
  }
  bDiv = grid.getEl().vnode.elm.querySelector(".ui-ygrid-bdiv");
  bDiv.scrollTop = 0;
  alert("当前表格" + grid.key + "数据已滚动加载完成，点击确定继续");
  return allTrs;
};
let sleep = function(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
};
let getListViewContentByElement = function(listViewEls) {
  let content = "";
  let caption, captions, captions_;
  let special_char = [".", '"', "(", ")", "/", "$", "[", "]", "{", "}", "|", "+", "?", "^", "*"];
  for (let i = 0; i < listViewEls.length; i++) {
    let thEls = listViewEls[i].getElementsByTagName("th");
    let trELs = listViewEls[i].getElementsByClassName("data");
    let listViewId = listViewEls[i].getAttribute("id");
    let listViewKey = listViewId.substring(listViewId.indexOf("_") + 1);
    for (let j = 0; j < thEls.length; j++) {
      let thClass = thEls[j].getAttribute("class");
      let colContent = "";
      if (thClass == "seq" || thClass == "lv-h-btn" || thClass == "space")
        continue;
      caption = listViewKey + "&" + thEls[j].firstChild.textContent;
      let thListViewColumnKey = thEls[j].getAttribute("listviewcolumn-key");
      for (let k = 0; k < trELs.length; k++) {
        let tdEls = trELs[k].getElementsByTagName("td");
        let tdText = "";
        for (let t = 0; t < tdEls.length; t++) {
          let tdListViewColumnKey = tdEls[t].getAttribute("listviewcolumn-key");
          if (tdListViewColumnKey != thListViewColumnKey)
            continue;
          if (thClass == "lv-h-chk") {
            if (tdEls[t].firstChild.getAttribute("class").indexOf("checked") > -1) {
              tdText = "true";
            } else {
              tdText = "false";
            }
          } else {
            tdText = tdEls[t].textContent;
          }
        }
        if (k == 0) {
          colContent = tdText.trim();
        } else {
          colContent = colContent + ";" + tdText.trim();
        }
      }
      let matchCaption = caption;
      for (let k = 0; k < special_char.length; k++) {
        matchCaption = matchCaption.replaceAll(special_char[k], "\\" + special_char[k]);
      }
      captions = eval("content.match(/&" + matchCaption + ":/ig)");
      if (captions != void 0) {
        captions_ = eval("content.match(/&" + matchCaption + "#/ig)");
        if (captions_ != void 0) {
          caption = caption + "#" + (captions_.length + 2);
        } else {
          caption = caption + "#" + (captions.length + 1);
        }
      }
      if (content == "") {
        content = caption + ":" + colContent;
      } else {
        content = content + "\n" + caption + ":" + colContent;
      }
    }
  }
  return content;
};
let GridRowValues = function(currPage2, formId2) {
  let content2, grids = currPage2.getElementsByClassName("vnode ui-ygrid");
  if (grids.length > 0) {
    content2 = getContentGridRow(grids, formId2);
  } else {
    alert("当前界面没有表格");
  }
  return content2;
};
let getContentGridRow = function(grids, formId2) {
  let grids_data_content = "", element, elements2, content2 = "", value2 = "", style = "", gridId = "", gridKey, embed_formId = "";
  for (let index2 = 0; index2 < grids.length; index2++) {
    element = grids[index2].getElementsByClassName("ui-ygrid-btable")[0];
    gridId = grids[index2].getAttribute("id");
    embed_formId = gridId.split("_")[0];
    if (embed_formId != "" && embed_formId != formId2) {
      gridKey = gridId.replace(embed_formId + "_", "").replace("_box", "");
    } else {
      gridKey = gridId.replace(formId2 + "_", "").replace("_box", "");
    }
    for (let i2 = 1; i2 < element.getElementsByTagName("tr").length; i2++) {
      elements2 = element.getElementsByTagName("tr")[i2];
      content2 = "";
      for (let j2 = 1; j2 < elements2.cells.length; j2++) {
        style = elements2.cells[j2].getAttribute("style") + "";
        if (style.indexOf("display") != -1)
          continue;
        grids_data_content = elements2.cells[j2].innerText.trim();
        if (elements2.cells[j2].getElementsByTagName("span").length == 1) {
          grids_data_content = elements2.cells[j2].getElementsByTagName("span")[0].getAttribute("class");
          grids_data_content = grids_data_content + "";
          if (grids_data_content.indexOf("checked") > -1) {
            grids_data_content = "true";
          } else {
            grids_data_content = "false";
          }
        }
        if (elements2.cells[j2].getElementsByTagName("textarea").length == 1) {
          grids_data_content = elements2.cells[j2].getElementsByTagName("textarea")[0].innerHTML;
        }
        if (content2 == "") {
          content2 = gridKey + "&" + i2 + ":" + grids_data_content;
        } else {
          content2 = content2 + ";" + grids_data_content;
        }
      }
      if (value2 == "") {
        value2 = content2;
      } else {
        value2 = value2 + "\n" + content2;
      }
    }
  }
  return value2;
};
let verifyDict = function(currPage2) {
  let content2 = "", dictViews = currPage2.getElementsByClassName("ui-dv");
  if (dictViews.length > 0) {
    content2 = "";
    let elements2, element, value2;
    for (let i2 = 0; i2 < dictViews.length; i2++) {
      elements2 = dictViews[i2].getElementsByTagName("tr");
      for (let j2 = 0; j2 < elements2.length; j2++) {
        element = elements2[j2];
        if (element.getAttribute("itemkey") != void 0) {
          value2 = element.firstElementChild.innerText.trim();
          if (value2 == "")
            continue;
          if (content2 == "") {
            content2 = value2;
          } else {
            content2 = content2 + ";" + value2;
          }
        }
      }
    }
    return content2;
  }
  return content2;
};
let checkAllGridRow = function(currPage2) {
  let content2 = "", rows, id, grids = currPage2.getElementsByClassName("vnode ui-ygrid");
  if (grids.length > 0) {
    for (let i2 = 0; i2 < grids.length; i2++) {
      if (grids[i2].id === "")
        continue;
      rows = grids[i2].querySelectorAll(".ui-ygrid-bdiv tr").length - 1;
      id = grids[i2].id.replace(/[0-9]+_/, "").replace("_box", "");
      content2 = content2 + "表格:行数:" + rows + "," + id;
      if (i2 !== grids.length - 1) {
        content2 = content2 + "\n";
      }
    }
  }
  return content2;
};
let checkHistoryRecords = async function(currPage2, formId2, form2) {
  let inputOrDivEl = currPage2.getElementsByClassName("jqui-autocomplete-input focus");
  let fieldName;
  if (inputOrDivEl != void 0 && inputOrDivEl != "" && inputOrDivEl.length != 0 && inputOrDivEl[0].id.indexOf("column") > -1) {
    let tdEl = inputOrDivEl[0].parentElement.parentElement.parentElement;
    let td_aria_describedby = tdEl.getAttribute("aria-describedby");
    let tdInfo = td_aria_describedby.split("_");
    let gridKey = tdInfo[1];
    let grid = form2.getComponent(gridKey);
    let colIndex = tdInfo[2].charAt(tdInfo[2].length - 1);
    let trId = tdEl.parentElement.getAttribute("id");
    let rowIndex = trId.charAt(trId.length - 1);
    let colInfo = await RecordCase.getMetaColumnCaption(form2, grid, colIndex);
    fieldName = colInfo.fieldCaption + "&" + gridKey + "&" + (parseInt(rowIndex) + 1);
  } else {
    inputOrDivEl = currPage2.getElementsByClassName("jqui-autocomplete-input focus");
    if (inputOrDivEl == void 0 || inputOrDivEl == "" || inputOrDivEl.length == 0) {
      alert("当前界面没有控件获取焦点，无法查看历史记录");
      return;
    } else {
      let targetSpanEl = inputOrDivEl[0].parentElement.parentElement;
      let fieldKey = targetSpanEl.getAttribute("id").replace(formId2 + "_", "");
      let fieldNameEl = document.getElementById(formId2 + "_Inner_" + fieldKey);
      if (fieldNameEl == null) {
        fieldNameEl = document.getElementById(formId2 + "_Lab_" + fieldKey);
      }
      if (fieldNameEl == null) {
        fieldName = fieldKey;
      } else {
        fieldName = fieldNameEl.firstElementChild.textContent;
        let labelElements = currPage2.getElementsByTagName("label");
        let index2 = 0, quantity = 0;
        for (let i2 = 0; i2 < labelElements.length; i2++) {
          if (labelElements[i2].innerText == fieldName && labelElements[i2].parentElement.getAttribute("class").indexOf("ui-hidden") == -1 && labelElements[i2].parentElement.getAttribute("class").indexOf("ui-lbl") > -1) {
            quantity++;
            if (labelElements[i2].parentElement.id == fieldNameEl.id) {
              index2 = quantity;
            }
          }
        }
        if (index2 > 1) {
          fieldName = fieldName + "#" + index2;
        }
      }
    }
  }
  let historyUlEls = document.getElementsByClassName("jqui-menu"), historyUlEl, content2 = "";
  for (let i2 = 0; i2 < historyUlEls.length; i2++) {
    if (!(historyUlEls[i2].getAttribute("style").indexOf("display: none") > -1)) {
      historyUlEl = historyUlEls[i2];
    }
  }
  if (historyUlEl != "") {
    let historyLiEls = historyUlEl.children;
    for (let i2 = 0; i2 < historyLiEls.length; i2++) {
      if (content2 == "") {
        content2 = historyLiEls[i2].firstElementChild.textContent;
      } else {
        content2 = content2 + "\n" + historyLiEls[i2].firstElementChild.textContent;
      }
    }
  } else {
    content2 = "历史记录:空";
  }
  return [fieldName, content2];
};
let checkGridSearch = function(currPage2) {
  let tds = currPage2.querySelectorAll(".search-matched-cell-selected,.search-matched-cell");
  let content2 = "";
  for (let i2 = 0; i2 < tds.length; i2++) {
    if (tds[i2].style.display == "none") {
      continue;
    }
    let cellInfo = RecordCase.getCellInfo(tds[i2]);
    let info = cellInfo.gridKey + "," + cellInfo.columnCaption.replace(/#\d/, "") + "," + cellInfo.colKey + "," + cellInfo.rowNum;
    if (content2 == "") {
      content2 = info;
    } else {
      content2 = content2 + "\n" + info;
    }
  }
  return content2;
};
let checkLongText = function() {
  let content2 = "";
  let dialogPath = "//div[contains(@class,'modal dialog show')] | //div[contains(@class,'ui-dlg dialog')] | //div[contains(@class,'dialog error') or contains(@class,'dialog show error')]";
  let longTextPath = ".//div[contains(@class,'dialog-detail-long-text')] | .//div[contains(@class,'ql-container')]";
  let dialogEls = RecordCase.getElementsByXpath(dialogPath, null);
  let dialogEl;
  if (dialogEls.length > 0) {
    dialogEl = dialogEls[dialogEls.length - 1];
  } else {
    return content2;
  }
  let longTextEls = RecordCase.getElementsByXpath(longTextPath, dialogEl);
  if (longTextEls.length > 0) {
    content2 = longTextEls[0].textContent;
  }
  return content2;
};
let checkCurrentPage = function() {
  let pageCaptionEL = document.querySelector("div.tabs-header ul li.tabcontainer.aria-selected label");
  let pageCaption = pageCaptionEL.textContent;
  RecordCase.requestRecordStep("当前界面:" + pageCaption);
};
const ids = [
  "verSubOpt",
  "verSourceCodeTab",
  "verNodeTreeCaption",
  "verNoDateSource",
  "verSubAttrUsability",
  "verColUsability",
  "verColLocation",
  "verFieldLocation",
  "verGroupButton",
  "verCtrlDot",
  "verSubExist",
  "verPrintTableRowAndCol",
  "verGridPanelRowAndColNum",
  "verToolTip",
  "verConnectLineExist",
  "verConnectLineColor",
  "verBoardAttrUsability",
  "verBoardAttrExist",
  "verBoardAttrCmb",
  "verConstCanAdd",
  "verDataFieldExit",
  "verBPMNodeState",
  "verBPMNodeVisibility"
];
const _DesignVerify = class _DesignVerify2 {
  static addListening() {
    for (let i2 in ids) {
      document.getElementById(ids[i2]).onclick = function() {
        _DesignVerify2.record(ids[i2]);
        this.parentElement.parentElement.style.display = "none";
      };
    }
  }
};
_DesignVerify.record = async function(type2) {
  if (AutoRecord.AutoRecord) {
    let content2 = "", keyWord = "";
    if (type2 === "verSubOpt") {
      keyWord = "设计器验证:组件操作可用性";
      content2 = getSubOpt();
    } else if (type2 === "verSourceCodeTab") {
      keyWord = "设计器验证:源码Tab页";
      content2 = getSourceCodeTab();
    } else if (type2 === "verNodeTreeCaption") {
      keyWord = "设计器验证:节点树标题";
      content2 = getNodeTreeCaption();
    } else if (type2 === "verSubAttrUsability") {
      keyWord = "设计器验证:组件属性可用性";
      content2 = getSubAttrUsability();
    } else if (type2 === "verColUsability") {
      keyWord = "设计器验证:表格列可编辑性";
      content2 = getColUsability();
    } else if (type2 === "verPrintTableRowAndCol") {
      keyWord = "打印模板验证:表格行列";
      content2 = getPrintTableRowAndCol();
    } else if (type2 === "verColLocation") {
      keyWord = "设计器验证:列位置";
      content2 = getColLocation();
    } else if (type2 === "verNoDateSource") {
      keyWord = "设计器验证:空白数据源";
      content2 = getNoDataSource();
    } else if (type2 === "verFieldLocation") {
      keyWord = "设计器验证:控件位置";
      content2 = getFieldLocation();
    } else if (type2 === "verGroupButton") {
      keyWord = "设计器验证:收缩按钮";
      content2 = getGroupButton();
    } else if (type2 === "verCtrlDot") {
      keyWord = "设计器验证:控制点类型";
      content2 = getCtrlDot();
    } else if (type2 === "verSubExist") {
      keyWord = "设计器验证:组件存在性";
      content2 = getSubExist();
    } else if (type2 === "verGridPanelRowAndColNum") {
      keyWord = "设计器验证:网格行列数";
      content2 = getGridPanelRowAndColNum();
    } else if (type2 === "verToolTip") {
      keyWord = "设计器验证:公式描述";
      content2 = getToolTip();
    } else if (type2 === "verConnectLineExist") {
      keyWord = "设计器验证:连接线存在性";
      content2 = getConnectLineExist();
    } else if (type2 === "verConnectLineColor") {
      keyWord = "设计器验证:连接线颜色";
      content2 = getConnectLineColor();
    } else if (type2 === "verBoardAttrUsability") {
      keyWord = "设计器验证:画板属性可编辑性";
      content2 = getBoardAttrUsability();
    } else if (type2 === "verBoardAttrExist") {
      keyWord = "设计器验证:画板属性存在性";
      content2 = getBoardAttrExist();
    } else if (type2 === "verBoardAttrCmb") {
      keyWord = "设计器验证:画板属性下拉框";
      content2 = getBoardAttrCmb();
    } else if (type2 === "verConstCanAdd") {
      keyWord = "设计器验证:公式常量是否可添加";
      content2 = getConstCanAdd();
    } else if (type2 === "verDataFieldExit") {
      verDataFieldExit();
    } else if (type2 === "verBPMNodeState") {
      keyWord = "设计器工作流验证:节点状态";
      content2 = verBPMNodeState();
    } else if (type2 === "verBPMNodeVisibility") {
      keyWord = "设计器工作流验证:节点可见性";
      content2 = verBPMNodeVisibility();
    }
    if (content2 !== "" && keyWord !== "") {
      setTimeout(() => {
        RecordCase.requestRecordStep(keyWord);
        setTimeout(() => {
          RecordCase.requestRecordResult(content2);
        }, 200);
      }, 200);
    }
  }
};
_DesignVerify.getDesignPanelElm = function() {
  let designPanelElm = document.querySelector(".RightDesignPanelContainer.designer .ui-tabs-panel > div[caption='设计']");
  return designPanelElm;
};
_DesignVerify.getSourceCodePanelElm = function() {
  let sourceCodePanelElm = document.querySelector(".RightDesignPanelContainer.designer .ui-tabs-panel > div[caption='源代码']");
  return sourceCodePanelElm;
};
let DesignVerify = _DesignVerify;
let verBPMNodeState = function() {
  let form2 = RecordCase.getCurrPage();
  let elements2 = form2.querySelectorAll("svg circle, svg text, svg rect");
  let bpmNodeState = /* @__PURE__ */ new Map();
  let recordNodeState = false;
  for (let i2 = 0; i2 < elements2.length; i2++) {
    let element = elements2[i2];
    let tagName = element.tagName;
    if ("text" == tagName) {
      let text = element.innerText.trim();
      let index2 = 1;
      while (bpmNodeState.has(text)) {
        index2++;
        text += "#" + index2;
      }
      bpmNodeState.set(text, recordNodeState ? "1" : "0");
      recordNodeState = false;
    } else {
      let stroke = element.getAttribute("stroke");
      if ("#ff0000" == stroke) {
        recordNodeState = true;
      }
    }
  }
  let content2 = [""];
  let count = 0;
  if (bpmNodeState.size == 0) {
    content2[count] = "无节点";
  } else {
    bpmNodeState.forEach((value2, key2) => {
      content2[count++] = key2 + ":" + value2;
    });
  }
  return content2.join("\n");
};
let verBPMNodeVisibility = function() {
  let form2 = RecordCase.getActiveBPMForm();
  let gElements = form2.querySelectorAll("svg > g");
  let bpmNodeState = /* @__PURE__ */ new Map();
  let recordNodeState = true;
  for (let i2 = 0; i2 < gElements.length; i2++) {
    let gElm = gElements[i2];
    let bpmNodeInfo = RecordCase.getBpmNodeInfo(gElm);
    let caption2 = bpmNodeInfo.finalCaption;
    let transform = gElm.getAttribute("transform");
    let elements2 = transform == "matrix(1,0,0,1,0,0)" ? gElm.querySelectorAll("path") : gElm.querySelectorAll("text");
    for (let j2 = 0; j2 < elements2.length; j2++) {
      let element = elements2[j2];
      let display = element.style.display;
      if (display != null && display == "none") {
        recordNodeState = false;
        break;
      }
    }
    bpmNodeState.set(caption2, recordNodeState ? "true" : "false");
  }
  let content2 = [""];
  let count = 0;
  bpmNodeState.forEach((value2, key2) => {
    content2[count++] = key2 + ":" + value2;
  });
  return content2.join("\n");
};
let getSubOpt = function() {
  let content2 = [];
  let subOptElms = document.querySelectorAll("span.design-location.selectedButton");
  for (let i2 = 0; i2 < subOptElms.length; i2++) {
    let subOptElm = subOptElms[i2];
    let top = parseFloat(subOptElm.style.top.replace(/px/, ""));
    let left = parseFloat(subOptElm.style.left.replace(/px/, ""));
    content2.push(subOptElm.title + ":" + (top > 0 && left > 0 ? "true" : "false"));
  }
  return content2.join("\n");
};
let getSourceCodeTab = function() {
  let content2 = [];
  let tabLabelElms = DesignVerify.getSourceCodePanelElm().querySelectorAll("ul > li > a > label");
  for (let i2 = 0; i2 < tabLabelElms.length; i2++) {
    let tabLabelElm = tabLabelElms[i2];
    content2.push(tabLabelElm.innerText.trim().replace("*", ""));
  }
  return content2.join(",");
};
let getNodeTreeCaption = function() {
  let content2 = [];
  let trElements = DesignVerify.getDesignPanelElm().querySelectorAll("div.ui-ygrid[caption='表单节点树'] tr.ygrow");
  for (let i2 = 0; i2 < trElements.length; i2++) {
    let trElement = trElements[i2];
    if (trElement.style.display != "none") {
      let panelKey = trElement.querySelector("td[meta-columnkey='PanelKey']").innerText.trim();
      let text;
      if (panelKey.indexOf("数据源") > -1) {
        text = panelKey.replace(/\s+/, ":");
      } else {
        let caption2 = trElement.querySelector("td[meta-columnkey='Caption']").innerText.trim();
        if (panelKey != "" && caption2 != "") {
          text = panelKey + ":" + caption2;
        }
      }
      if (text) {
        content2.push(text);
      }
    }
  }
  return content2.join("\n");
};
let getSubAttrUsability = function() {
  let content2 = [];
  let subElements = DesignVerify.getDesignPanelElm().querySelectorAll("div.ui-control.innerLabel:not(.ui-hidden)");
  for (let i2 = 0; i2 < subElements.length; i2++) {
    let caption2 = subElements[i2].getAttribute("caption");
    if (caption2 && caption2 != "") {
      content2.push(caption2 + ":" + !(subElements[i2].getAttribute("class").indexOf("ui-readonly") > -1));
    }
  }
  return content2.join("\n");
};
let getColUsability = function() {
  let content2 = [];
  let grids = getAllVisibleGrids();
  for (let i2 = 0; i2 < grids.length; i2++) {
    let grid = grids[i2];
    let gridkey = grid.getAttribute("id").replace(/\d+_/, "").replace("_box", "");
    let thElements = grid.querySelectorAll("th");
    for (let j2 = 0; j2 < thElements.length; j2++) {
      let caption2 = thElements[j2].getAttribute("title");
      let colkey = thElements[j2].getAttribute("meta-key");
      let oldkey = thElements[j2].getAttribute("oldkey");
      let id = thElements[j2].getAttribute("id");
      if (colkey != null && oldkey != null && (colkey != "" || oldkey != "")) {
        let tdElements = grid.querySelectorAll("td[aria-describedby='" + id + "']");
        if (tdElements.length <= 0) {
          continue;
        }
        let result = !(tdElements[0].getAttribute("class").indexOf("ui-cell-disabled") > -1);
        let isAllRight = true;
        for (let k = 1; k < tdElements.length; k++) {
          if (result != !(tdElements[k].getAttribute("class").indexOf("ui-cell-disabled") > -1)) {
            isAllRight = false;
            break;
          }
        }
        if (isAllRight) {
          content2.push(caption2 + "&" + (colkey != "" ? colkey : oldkey) + "&" + gridkey + ":" + result);
        }
      }
    }
  }
  return content2.join("\n");
};
let getPrintTableRowAndCol = function() {
  let content2 = [];
  let tables = document.querySelectorAll("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.complex-design-view div.printarea table");
  for (let i2 = 0; i2 < tables.length; i2++) {
    let table = tables[i2];
    let trs = table.querySelectorAll("tr:not([class*='first'])");
    let tds = trs[0].querySelectorAll("td");
    content2.push(i2 + 1 + ":" + trs.length + "," + tds.length);
  }
  return content2.join("\n");
};
let getColLocation = function() {
  let content2 = [];
  console.log("获取表格子序列...");
  let grids = getAllVisibleGrids();
  for (let i2 = 0; i2 < grids.length; i2++) {
    let grid = grids[i2];
    let gridkey = grid.getAttribute("id").replace(/\d+_/, "").replace("_box", "");
    let trElements = grid.querySelectorAll("thead tr.ui-ygrid-columnheader");
    if (trElements.length < 2)
      continue;
    for (let j2 = 1; j2 < trElements.length; j2++) {
      let trElement = trElements[j2];
      let thElements = trElement.querySelectorAll("th");
      for (let k = 0; k < thElements.length; k++) {
        let thElement = thElements[k];
        let caption2 = thElement.innerText;
        let key2 = thElement.getAttribute("meta-key");
        content2.push(caption2 + "&" + key2 + "&" + gridkey + ":" + (j2 + 1) + "," + (k + 1));
      }
    }
  }
  return content2.join("\n");
};
let getAllVisibleGrids = function() {
  let currPage2 = RecordCase.getCurrPage();
  return currPage2.querySelectorAll(".ui-ygrid:not(div[role='tabpanel']:not(.aria-show) .vnode.ui-ygrid)");
};
let getNoDataSource = function() {
  var dataSourceElm = document.querySelector("div.dialog.show div.spl-item.v-item div.ui-pnl[id$='_TabPanel2']");
  let content2 = "";
  if (dataSourceElm) {
    content2 = "" + (dataSourceElm.getAttribute("class").indexOf("ui-hidden") > -1);
  }
  return content2;
};
let getFieldLocation = function() {
  let content2 = [];
  let currPage2 = RecordCase.getCurrPage();
  let panelElms = currPage2.querySelectorAll("div.ui-pnl.ui-glp");
  for (let i2 = 0; i2 < panelElms.length; i2++) {
    let panelElm = panelElms[i2];
    let parentElement = panelElm.parentElement;
    let classAttribute = parentElement.getAttribute("class");
    if (classAttribute.indexOf("ui-tabs-panel") > -1 && classAttribute.indexOf("aria-show") == -1)
      continue;
    let idAttribute = panelElm.getAttribute("id");
    let panelKey = idAttribute.replace(/\d+_/, "");
    let componentElms = panelElm.querySelectorAll(".ui-control");
    for (let j2 = 0; j2 < componentElms.length; j2++) {
      let componentElm = componentElms[j2];
      let caption2 = componentElm.getAttribute("caption");
      let key2 = componentElm.getAttribute("id").replace(/\d+_/, "");
      let col2 = parseInt(RecordCase.getElementByXpath("./ancestor::td[1]", componentElm).getAttribute("col")) + 1;
      let row2 = parseInt(RecordCase.getElementByXpath("./ancestor::tr[1]", componentElm).getAttribute("row")) + 1;
      content2.push(caption2 + "&" + key2 + "&" + panelKey + ":" + row2 + "," + col2);
    }
  }
  return content2.join("\n");
};
let getGroupButton = function() {
  let content2 = [];
  let currPage2 = RecordCase.getCurrPage();
  let groupButtonElms = currPage2.querySelectorAll(".group-lbl .erp-group-title");
  for (let i2 = 0; i2 < groupButtonElms.length; i2++) {
    let groupButtonElm = groupButtonElms[i2];
    content2.push(groupButtonElm.querySelector("label").innerText.trim());
  }
  return content2.join(",");
};
let getCtrlDot = function() {
  let content2 = [];
  let currPage2 = RecordCase.getCurrPage();
  let groupButtonElms = currPage2.querySelectorAll(".group-lbl .erp-group-title");
  for (let i2 = 0; i2 < groupButtonElms.length; i2++) {
    let groupButtonElm = groupButtonElms[i2];
    let caption2 = groupButtonElm.querySelector("label").innerText.trim();
    let classAttribute = groupButtonElm.querySelector(".iconfont").getAttribute("class");
    let type2;
    if (classAttribute.indexOf("icon-jianhaoshouqi") > -1 || classAttribute.indexOf("icon-jiahaozhankai") > -1) {
      type2 = "加减符号";
    } else if (classAttribute.indexOf("icon-collapse_arrowdown") > -1 || classAttribute.indexOf("icon-collapse_arrowup") > -1) {
      type2 = "上下图标";
    } else if (classAttribute.indexOf("icon-switch-on") > -1 || classAttribute.indexOf("icon-switch-off") > -1) {
      type2 = "开关按钮";
    } else {
      type2 = "自定义";
    }
    content2.push(caption2 + ":" + type2);
  }
  return content2.join("\n");
};
let getSubExist = function() {
  let content2 = [];
  let currPage2 = RecordCase.getCurrPage();
  let isExist = "true";
  let components = currPage2.querySelectorAll(".ui-control:not(.cellEditor), .ui-rdo:not(.cellEditor)");
  for (let i2 = 0; i2 < components.length; i2++) {
    let component = components[i2];
    let classAttribute = component.getAttribute("class");
    let caption2;
    let key2 = component.getAttribute("id").replace(/\d+_/, "");
    if (classAttribute.indexOf("ui-rdo") > -1 || classAttribute.indexOf("ui-chk") > -1) {
      caption2 = component.querySelector("label").innerText.trim();
    } else {
      caption2 = component.getAttribute("caption");
    }
    content2.push(caption2 + "&" + key2 + ":" + isExist);
  }
  let grids = getAllVisibleGrids();
  for (let i2 = 0; i2 < grids.length; i2++) {
    let grid = grids[i2];
    let gridkey = grid.getAttribute("id").replace(/\d+_/, "").replace("_box", "");
    let thElements = grid.querySelectorAll("th");
    for (let j2 = 0; j2 < thElements.length; j2++) {
      let thElement = thElements[j2];
      let caption2 = !thElement.innerText ? thElement.getAttribute("title") : thElement.innerText;
      let key2 = !thElement.getAttribute("meta-key") ? thElement.getAttribute("oldkey") : thElement.getAttribute("meta-key");
      if (!caption2 || !key2 || !gridkey)
        continue;
      content2.push(caption2 + "&" + key2 + "&" + gridkey + ":" + isExist);
    }
  }
  let tabs = currPage2.querySelectorAll("ul.ui-tabs-nav.tab-list > li:not(.addPanel)");
  for (let i2 = 0; i2 < tabs.length; i2++) {
    let tab = tabs[i2];
    let caption2 = tab.innerText;
    let key2 = tab.getAttribute("control-key");
    content2.push(caption2 + "&" + key2 + ":" + isExist);
  }
  return content2.join("\n");
};
let getGridPanelRowAndColNum = function() {
  let content2 = [];
  let currPage2 = RecordCase.getCurrPage();
  let panelElms = currPage2.querySelectorAll("div.ui-pnl.ui-glp");
  for (let i2 = 0; i2 < panelElms.length; i2++) {
    let panelElm = panelElms[i2];
    let parentElement = panelElm.parentElement;
    let classAttribute = parentElement.getAttribute("class");
    if (classAttribute.indexOf("ui-tabs-panel") > -1 && classAttribute.indexOf("aria-show") == -1)
      continue;
    let idAttribute = panelElm.getAttribute("id");
    let panelKey = idAttribute.replace(/\d+_/, "");
    let trElements = panelElm.querySelectorAll("tr");
    let row2 = trElements.length;
    let col2 = 0;
    for (let j2 = 0; j2 < trElements.length; j2++) {
      let tdElements = trElements[i2].querySelectorAll("td");
      col2 = tdElements.length > col2 ? tdElements.length : col2;
    }
    content2.push(panelKey + ":" + row2 + "," + col2);
  }
  return content2.join("\n");
};
let getToolTip = function() {
  let tooltipElms = document.querySelectorAll(".CodeMirror-hover-tooltip");
  if (tooltipElms.length == 0)
    return "";
  let tooltipElm = tooltipElms[tooltipElms.length - 1];
  return tooltipElm.innerText.trim();
};
let getConnectLineExist = function() {
  let content2 = [];
  let middleBoard = getMiddleBoard();
  if (!middleBoard)
    return "";
  let lineElms = getConnectLines(middleBoard);
  let isExist = "true";
  for (let i2 = 0; i2 < lineElms.length; i2++) {
    let lineElm = lineElms[i2];
    let keyArray = lineElm.getAttribute("pathId").split("*_*");
    let sourceKey = keyArray[1].replace(/,/g, "/，");
    let targetKey = keyArray[3].replace(/,/g, "/，");
    content2.push(sourceKey + "," + targetKey + ":" + isExist);
  }
  return content2.join("\n");
};
let getConnectLineColor = function() {
  let content2 = [];
  let middleBoard = getMiddleBoard();
  if (!middleBoard)
    return "";
  let lineElms = getConnectLines(middleBoard);
  for (let i2 = 0; i2 < lineElms.length; i2++) {
    let lineElm = lineElms[i2];
    let keyArray = lineElm.getAttribute("pathId").split("*_*");
    let color = lineElm.getAttribute("stroke");
    let sourceKey = keyArray[1].replace(/,/g, "/，");
    let targetKey = keyArray[3].replace(/,/g, "/，");
    content2.push(sourceKey + "," + targetKey + ":" + color);
  }
  return content2.join("\n");
};
let getConnectLines = function(middleBoard) {
  return middleBoard.querySelectorAll("svg g path.fieldCell_pointer");
};
let getMiddleBoard = function() {
  let middleBoard = document.querySelectorAll("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.complex-design-view");
  if (middleBoard.length > 0) {
    return middleBoard[0];
  }
  return null;
};
let getBoardAttrUsability = function() {
  let content2 = [];
  let captions2 = [];
  let boardAttrPanel = getBoardAttrPanel();
  if (!boardAttrPanel)
    return "";
  let properties = boardAttrPanel.querySelectorAll("li.property-control-line");
  for (let i2 = 0; i2 < properties.length; i2++) {
    let labelElm = properties[i2].querySelector(".property-label");
    let caption2 = labelElm.innerText;
    for (let j2 = 1; ; j2++) {
      let finalCaption = caption2 + (j2 == 1 ? "" : "#" + j2);
      if (captions2.indexOf(finalCaption) != -1)
        continue;
      caption2 = finalCaption;
      break;
    }
    let isUsability = labelElm.getAttribute("class").indexOf("property-disable") == -1;
    content2.push(caption2 + ":" + isUsability);
  }
  return content2.join("\n");
};
let getBoardAttrExist = function() {
  let content2 = [];
  let captions2 = [];
  let boardAttrPanel = getBoardAttrPanel();
  if (!boardAttrPanel)
    return "";
  let properties = boardAttrPanel.querySelectorAll("li.property-control-line");
  let isExist = "true";
  for (let i2 = 0; i2 < properties.length; i2++) {
    let labelElm = properties[i2].querySelector(".property-label");
    let caption2 = labelElm.innerText;
    for (let j2 = 1; ; j2++) {
      let finalCaption = caption2 + (j2 == 1 ? "" : "#" + j2);
      if (captions2.indexOf(finalCaption) != -1)
        continue;
      caption2 = finalCaption;
      break;
    }
    content2.push(caption2 + ":" + isExist);
  }
  return content2.join("\n");
};
let getBoardAttrCmb = function() {
  let content2 = [];
  let boardAttrPanel = getBoardAttrPanel();
  if (!boardAttrPanel)
    return "";
  let optionElms = boardAttrPanel.querySelectorAll("li.property-control-line select option");
  for (let i2 = 0; i2 < optionElms.length; i2++) {
    content2.push(optionElms[i2].innerText);
  }
  return content2.join("\n");
};
let getConstCanAdd = function() {
  let content2 = [];
  let middleBoard = getMiddleBoard();
  if (!middleBoard)
    return "";
  let constElms = middleBoard.querySelectorAll("svg foreignObject div table tr[sourcetype] td.tablehead");
  for (let i2 = 0; i2 < constElms.length; i2++) {
    let constElm = constElms[i2];
    let caption2 = constElm.querySelector("span").innerText;
    let isConstCanAdd = constElm.querySelectorAll("button").length > 0;
    content2.push(caption2 + ":" + isConstCanAdd);
  }
  return content2.join("\n");
};
let verDataFieldExit = function() {
  let middleBoard = getMiddleBoard();
  if (!middleBoard)
    return "";
  let dataTables = middleBoard.querySelectorAll("svg foreignObject > div");
  let isExit = "true";
  for (let i2 = 0; i2 < dataTables.length; i2++) {
    let dataTable = dataTables[i2];
    let classAttribute = dataTable.getAttribute("class");
    let tableType = "";
    if (classAttribute === "sourceTableCollectionView" || classAttribute === "sourceColl") {
      tableType = "源表";
    } else if (classAttribute === "targetTableCollectionView" || classAttribute === "targetColl") {
      tableType = "目标表";
    } else if (classAttribute === "feedbackCollectionView0" || classAttribute === "feedbackColl") {
      tableType = "反填表";
    }
    if (!tableType)
      continue;
    RecordCase.requestRecordStep("设计器验证:数据字段存在性:" + tableType);
    let content2 = [], captions2 = [];
    let dataFields = dataTable.querySelectorAll("table tr[sourcetype] td:not([class *='tablehead']) span");
    for (let j2 = 0; j2 < dataFields.length; j2++) {
      let caption2 = dataFields[i2].innerText;
      for (let k = 1; ; k++) {
        let finalCaption = caption2 + (k == 1 ? "" : "#" + k);
        if (captions2.indexOf(finalCaption) != -1)
          continue;
        content2.push(finalCaption + ":" + isExit);
        break;
      }
    }
    RecordCase.requestRecordResult(content2.join("\n"));
  }
};
let getBoardAttrPanel = function() {
  let boardAttrPanel = document.querySelectorAll("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.property-pane");
  if (boardAttrPanel.length > 0) {
    return boardAttrPanel[0];
  }
  return null;
};
class ClickX {
  // 部分监听需要在加载该文件时添加
  static addRecordListening() {
    document.querySelector(".tabs-header ul").addEventListener("click", function(e) {
      if (AutoRecord.AutoRecord) {
        let target = e.target;
        if (target.classList.contains("tab-icon-close")) {
          RecordCase.requestRecordStep("点击:X");
        } else if (target.nodeName != "UL") {
          RecordCase.requestRecordStep("选择:TAB_Head页:" + target.textContent);
        }
      }
    }, true);
  }
  async build(form2, docData, isNotLoad) {
    let builder = await this.base.build(form2, docData, isNotLoad);
    var dialog = document.querySelector("[id='" + form2.formID + "']");
    if (!dialog) {
      return builder;
    }
    let xEl = dialog.querySelector(".dialog-close");
    if (!xEl) {
      return builder;
    }
    xEl.addEventListener("mousedown", function() {
      if (AutoRecord.AutoRecord && form2.formKey !== "CaseManage") {
        RecordCase.requestRecordStep("点击:X");
      }
    });
    return builder;
  }
}
class DOMUtil {
  static waitForElementsReady(selector, callback) {
    const startTime = (/* @__PURE__ */ new Date()).getTime();
    const waiting = function() {
      const isDocumentReady = document.readyState == "complete";
      const elems = isDocumentReady && document.querySelectorAll(selector);
      const isFind = elems && elems.length > 0;
      const timeout = (/* @__PURE__ */ new Date()).getTime() - startTime;
      if (isDocumentReady && (isFind || timeout > 1e4)) {
        callback.apply(window, [elems]);
      } else {
        setTimeout(waiting, 20);
      }
    };
    waiting();
  }
  //寻找指定元素的前面的所有元素
  static prevAll(elm) {
    var _parent = elm.parentElement;
    var _child = _parent.children;
    var arr = [];
    for (var i2 = 0; i2 < _child.length; i2++) {
      var _childI = _child[i2];
      if (_childI == this) {
        break;
      }
      arr.push(_childI);
    }
    return arr;
  }
}
class Polling {
  // 轮询的方式添加表格操作控件的点击事件
  static gridContralPolling() {
    setInterval(() => {
      if (!AutoRecord.AutoRecord) {
        return;
      }
      let currPage2 = RecordCase.getCurrPage();
      if (!currPage2) {
        return;
      }
      currPage2.querySelectorAll("div.vnode.ui-ygrid").forEach((gridEl) => {
        gridEl.querySelectorAll(".ui-icon-seek-first").forEach((item) => {
          item.addEventListener("click", funfirst);
        });
        gridEl.querySelectorAll(".ui-icon-seek-prev").forEach((item) => {
          item.addEventListener("click", funPrev);
        });
        gridEl.querySelectorAll(".ui-icon-seek-next").forEach((item) => {
          item.addEventListener("click", funNext);
        });
        gridEl.querySelectorAll(".ui-pagination ul li").forEach((item) => {
          item.addEventListener("click", funPageli);
        });
        gridEl.querySelectorAll(".ui-icon-seek-end").forEach((item) => {
          item.addEventListener("click", funEnd);
        });
        gridEl.querySelectorAll(".ui-icon-plus").forEach((item) => {
          item.addEventListener("click", funPlus);
        });
        gridEl.querySelectorAll(".ui-icon-trash").forEach((item) => {
          item.addEventListener("click", funTrash);
        });
        gridEl.querySelectorAll(".ui-icon-up").forEach((item) => {
          item.addEventListener("click", funUp);
        });
        gridEl.querySelectorAll(".ui-icon-down").forEach((item) => {
          item.addEventListener("click", funDown);
        });
        gridEl.querySelectorAll(".ui-icon-bestwidth").forEach((item) => {
          item.addEventListener("click", funBestWidth);
        });
        gridEl.querySelectorAll(".ui-icon-recordvariant").forEach((item) => {
          item.addEventListener("click", funRecordvariant);
        });
        gridEl.querySelectorAll(".ui-icon-collapse-all").forEach((item) => {
          item.addEventListener("click", funRecordCollapseAll);
        });
        gridEl.querySelectorAll(".ui-icon-expand-all").forEach((item) => {
          item.addEventListener("click", funRecordExpandAll);
        });
        gridEl.querySelectorAll("td.ui-pg-button[title='创建附加特性'] span").forEach((item) => {
          item.addEventListener("click", funCreateAdditionalFeatures);
        });
        gridEl.querySelectorAll(".ui-ygrid-sort i").forEach((item) => {
          item.addEventListener("click", clickSort);
        });
        gridEl.querySelectorAll(".contextmenu ul li").forEach((item) => {
          item.addEventListener("click", clickTracedBack);
        });
      });
      currPage2.querySelectorAll("div.yg_collapse.erp-group-title span").forEach((item) => {
        item.addEventListener("click", clickShrinkButton);
      });
      currPage2.querySelectorAll("div.ui-ygrid--search-option div").forEach((item) => {
        item.addEventListener("click", clickGridSearchButton);
      });
      document.querySelectorAll("div.dpbtn-vw.bottomlst li").forEach((item) => {
        item.addEventListener("click", clickDropBtn);
      });
      currPage2.querySelectorAll("div.zoom").forEach((item) => {
        item.addEventListener("click", clickPanelZoom);
      });
    }, 500);
    document.querySelectorAll("span.selectedButton").forEach(function(item) {
      item.addEventListener("click", componentOperation);
    });
  }
  // 选择关键字轮询添加监听
  static selectPolling() {
    setInterval(() => {
      if (!AutoRecord.AutoRecord) {
        return;
      }
      let currPage2 = RecordCase.getCurrPage();
      if (!currPage2) {
        return;
      }
      currPage2.querySelectorAll("div.vnode.ui-ygrid  th .chk").forEach((chkEl) => {
        chkEl.addEventListener("click", selectColTh);
      });
      currPage2.querySelectorAll("div.ui-txtbtn:not([class*='cellEditor']) button").forEach((button2) => {
        button2.addEventListener("click", selectTxtBtn);
      });
      currPage2.querySelectorAll(".arrow").forEach((arrow) => {
        arrow.addEventListener("click", selectDictOrCmbBoxBtn);
      });
      document.querySelectorAll("div.historyinput li.historyinput-item").forEach((item) => {
        item.addEventListener("mousedown", selectHistory);
      });
      currPage2.querySelectorAll("div.popup-dic-img").forEach((item) => {
        item.addEventListener("click", clickDicTrace);
      });
      document.querySelectorAll("div.dpbtn-vw[id$='_FavOperator_dropdown'][style*='display: block'] ul li, div.dpbtn-vw[id$='_VariantOpt_dropdown'][style*='display: block'] ul li").forEach((item) => {
        item.addEventListener("click", queryCondition);
      });
      currPage2.querySelectorAll("div.query.advancedquerybutton").forEach((item) => {
        item.addEventListener("click", selectSeniorQuery);
      });
      currPage2.querySelectorAll("span.cell-tree-icon").forEach((item) => {
        item.addEventListener("click", selectTreeGrid);
      });
      currPage2.querySelectorAll(".ui-hlk:not(.cellEditor)").forEach((hlk) => {
        hlk.addEventListener("click", clickHyperLink);
      });
      currPage2.querySelectorAll("div[id*='RightsSet'] ul > li > span.button.chk").forEach((item) => {
        item.addEventListener("click", selectPermissionTreeNode);
      });
    }, 500);
  }
  static designerPolling() {
    setInterval(() => {
      if (!AutoRecord.AutoRecord) {
        return;
      }
      let currPage2 = RecordCase.getCurrPage();
      if (currPage2) {
        currPage2.querySelectorAll("textarea[autocorrect='off']").forEach((item) => {
          item.addEventListener("blur", designExpressionInput);
        });
      }
      document.querySelectorAll("div.area").forEach((item) => {
        item.addEventListener("mousedown", areaMouseDown);
        item.addEventListener("mouseup", areaMouseUp);
      });
      document.querySelectorAll("li.addPanel").forEach((item) => {
        item.addEventListener("click", clickDesignerAddPanel);
      });
      document.querySelectorAll("div.area .ui-icon-trash").forEach((item) => {
        item.addEventListener("click", clickDesignerAreaTrash);
      });
      document.querySelectorAll("div.layui-layer-dialog div.layui-layer-btn a").forEach((item) => {
        item.addEventListener("click", clickDesignerPrompt);
      });
      document.querySelectorAll("div.CodeMirror-dialog.CodeMirror-dialog-top > input").forEach((item) => {
        item.addEventListener("change", designSearch);
      });
      let boardArea = document.querySelector("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.complex-design-view");
      if (boardArea) {
        boardArea.querySelectorAll("div.boardContainer svg foreignObject table tr[sourcetype] td span").forEach((item) => {
          item.addEventListener("mousedown", clickDataRow);
        });
        boardArea.querySelectorAll("div.boardContainer svg g path:nth-of-type(2)").forEach((item) => {
          item.addEventListener("mousedown", clickCnnectLine);
        });
        boardArea.querySelectorAll("div.boardContainer svg foreignObject div table tr td img").forEach((item) => {
          item.addEventListener("click", clickDeleteBtn);
        });
        boardArea.querySelectorAll("div.boardContainer button.linkDataMapButton").forEach((item) => {
          item.addEventListener("click", clickLinkDataMapBtn);
        });
        boardArea.querySelectorAll("div.boardContainer svg foreignObject table tr:nth-of-type(2) td input[type='button']").forEach((item) => {
          item.addEventListener("click", clickMore);
        });
        boardArea.querySelectorAll("div.boardContainer svg foreignObject table tr td button.dataMap-add-button").forEach((item) => {
          item.addEventListener("click", clickAddBtn);
        });
        boardArea.querySelectorAll("div.boardContainer svg foreignObject table tr td button.dataMap-add-button div label").forEach((item) => {
          item.addEventListener("click", clickAddFieldBtn);
        });
        boardArea.querySelectorAll("div.boardContainer svg foreignObject table tr:nth-of-type(2) td span:nth-of-type(1)").forEach((item) => {
          item.addEventListener("click", clickDataCmb);
        });
        boardArea.querySelectorAll("div.boardContainer svg foreignObject table div li span").forEach((item) => {
          item.addEventListener("click", clickDataCmbOption);
        });
      }
      let rightAttributeArea = document.querySelector("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.property-pane");
      if (rightAttributeArea) {
        rightAttributeArea.querySelectorAll("li.property-control-line select").forEach((item) => {
          item.addEventListener("click", clickDataAttributeCmb);
        });
      }
      let designer = document.querySelectorAll(".RightDesignPanelContainer.designer")[0];
      if (!designer) {
        return;
      }
      designer.querySelectorAll(".erp-group-title span").forEach((button2) => {
        button2.addEventListener("click", clickDesignerDropBtn);
      });
      designer.querySelectorAll("div.ui-txtbtn:not([class*='cellEditor']) button").forEach((button2) => {
        button2.addEventListener("click", clickDesignerTxtBtn);
      });
    }, 500);
  }
  static printTemplatePolling() {
    setInterval(() => {
      if (!AutoRecord.AutoRecord) {
        return;
      }
      let boardArea = document.querySelector("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.complex-design-view");
      if (!boardArea) {
        return;
      }
      boardArea.querySelectorAll("div.printarea table td img[width]").forEach((item) => {
        item.addEventListener("click", clickYellowTriangle);
      });
      boardArea.querySelectorAll("li.cmd-change-menu__entry").forEach((entry) => {
        entry.addEventListener("mousedown", clickPrintToolOpt);
      });
    }, 500);
  }
  static designerExcelPolling() {
    setInterval(() => {
      if (!AutoRecord.AutoRecord) {
        return;
      }
      let excel = RecordCase.getActiveExcelForm();
      if (!excel) {
        return;
      }
      excel.querySelectorAll("li.cmd-change-menu__entry").forEach((entry) => {
        entry.addEventListener("mousedown", clickCellToolOpt);
      });
      excel.querySelectorAll("td > img").forEach((img) => {
        img.addEventListener("click", clickCellImg);
      });
      excel.querySelectorAll("button.excel-button").forEach((button2) => {
        button2.addEventListener("click", clickSheetBtn);
      });
    }, 500);
  }
  static designerBPMPolling() {
    setInterval(() => {
      if (!AutoRecord.AutoRecord) {
        return;
      }
      let bpm = RecordCase.getActiveBPMForm();
      if (!bpm) {
        return;
      }
      bpm.querySelectorAll("div.bpm-toolbox > div.entry").forEach((opt2) => {
        opt2.addEventListener("mousedown", clickBPMCreateToolOpt);
      });
      bpm.querySelectorAll("div.cmd-change-menu__body").forEach((entries) => {
        entries.addEventListener("mousedown", clickBPMNodeOpt, true);
      });
      bpm.querySelectorAll("svg > g").forEach((elm) => {
        elm.addEventListener("mousedown", clickBPMNode, true);
      });
    }, 500);
  }
  // 统一开启轮询
  static addPolling() {
    this.gridContralPolling();
    this.selectPolling();
    this.designerPolling();
    this.designerExcelPolling();
    this.designerBPMPolling();
    this.printTemplatePolling();
  }
}
let clickYellowTriangle = function() {
  if (AutoRecord.AutoRecord) {
    let tdEl = this.parentElement;
    let rowIndex = parseInt(tdEl.getAttribute("rowindex"));
    let colIndex = parseInt(tdEl.getAttribute("colindex"));
    let tableBeforeThis = RecordCase.getElementsByXpath("./../../../preceding-sibling::table", tdEl);
    let tableIndex = tableBeforeThis.length;
    RecordCase.requestRecordStep("打印模板点击:" + (tableIndex + 1) + "," + (rowIndex + 1) + "," + (colIndex + 1) + ":黄色三角");
  }
  this.removeEventListener("click", clickYellowTriangle);
};
let clickPrintToolOpt = function() {
  if (AutoRecord.AutoRecord) {
    let selectedTds = document.querySelectorAll("div.main div[class*=tabs-body-inner]:not([style*='display: none']) div.complex-design-view div.printarea table td.selected");
    let caption2 = this.innerText;
    if (selectedTds.length == 0) {
      RecordCase.requestRecordStep("打印模板点击:空白区域@:" + caption2);
    } else {
      let selectedTd = selectedTds[0];
      let rowIndex = parseInt(selectedTd.getAttribute("rowindex"));
      let colIndex = parseInt(selectedTd.getAttribute("colindex"));
      let tableBeforeThis = RecordCase.getElementsByXpath("./../../../preceding-sibling::table", selectedTd);
      let tableIndex = tableBeforeThis.length;
      RecordCase.requestRecordStep("打印模板点击:" + (tableIndex + 1) + "," + (rowIndex + 1) + "," + (colIndex + 1) + "@:" + caption2);
    }
  }
  this.removeEventListener("mousedown", clickPrintToolOpt);
};
let clickBPMCreateToolOpt = function() {
  if (AutoRecord.AutoRecord) {
    Polling.CreateWord = "设计器工作流创建";
    Polling.BPMNodeType = this.title;
  }
  this.removeEventListener("mousedown", clickBPMCreateToolOpt);
};
let clickBPMNodeOpt = function(e) {
  if (AutoRecord.AutoRecord) {
    Polling.CreateWord = "设计器工作流选择:快捷操作";
    Polling.BPMNodeType = e.target.innerText;
  }
  this.removeEventListener("mousedown", clickBPMNodeOpt);
};
let clickBPMNode = function() {
  if (AutoRecord.AutoRecord) {
    Polling.PreNode = Polling.CurNode;
    Polling.CurNode = RecordCase.getBpmNodeInfo(this);
    if (Polling.KeyWord) {
      return;
    }
    RecordCase.requestRecordStep("设计器工作流选择:" + Polling.CurNode.finalCaption);
  }
  this.removeEventListener("mousedown", clickBPMNodeOpt);
};
let clickSheetBtn = function() {
  if (AutoRecord.AutoRecord) {
    let caption2 = this.innerText;
    if (caption2 == "+") {
      RecordCase.requestRecordStep("设计器Excel模板点击:新增Sheet");
    } else {
      RecordCase.requestRecordStep("设计器Excel模板选择:Sheet页:" + caption2);
    }
  }
  this.removeEventListener("mousedown", clickSheetBtn);
};
let clickCellImg = function() {
  if (AutoRecord.AutoRecord) {
    let cellInfo = RecordCase.getExcelCellInfo(this.parentElement);
    if (cellInfo) {
      RecordCase.requestRecordStep("设计器Excel模板点击:单元格选中图片:" + cellInfo.location);
    }
  }
  this.removeEventListener("mousedown", clickCellImg);
};
let clickCellToolOpt = function() {
  if (AutoRecord.AutoRecord) {
    let caption2, cellInfo;
    let excel = RecordCase.getActiveExcelForm();
    let elements2 = excel.querySelectorAll("td.selected");
    cellInfo = RecordCase.getExcelCellInfo(elements2[0]);
    if (cellInfo) {
      caption2 = this.innerText;
      RecordCase.requestRecordStep("设计器Excel模板点击:右击单元格:" + cellInfo.location + ":" + caption2);
    }
  }
  this.removeEventListener("mousedown", clickCellToolOpt);
};
function getGridKey(el) {
  let id = el.getAttribute("id").replace(/.+\d_/, "").replace("_pager", "");
  return id;
}
let funfirst = function() {
  let span = this;
  let gridKey = getGridKey(span.parentElement);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:首页," + gridKey);
  }
  this.removeEventListener("click", funfirst);
};
let funPrev = function() {
  let span = this;
  let gridKey = getGridKey(span.parentElement);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:上一页," + gridKey);
  }
  this.removeEventListener("click", funPrev);
};
let funNext = function() {
  let span = this;
  let gridKey = getGridKey(span.parentElement);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:下一页," + gridKey);
  }
  this.removeEventListener("click", funNext);
};
let funPageli = function() {
  let li = this;
  let gridKey = getGridKey(li.parentElement.parentElement);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:页码," + gridKey + ":" + this.innerText);
  }
  this.removeEventListener("click", funPageli);
};
let funEnd = function() {
  let span = this;
  let gridKey = getGridKey(span.parentElement);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:末页," + gridKey);
  }
  this.removeEventListener("click", funEnd);
};
let funPlus = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":添加");
  }
  this.removeEventListener("click", funPlus);
};
let funTrash = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":删除");
  }
  this.removeEventListener("click", funTrash);
};
let funUp = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":上移");
  }
  this.removeEventListener("click", funUp);
};
let funDown = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":下移");
  }
  this.removeEventListener("click", funDown);
};
let funBestWidth = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":最佳列宽");
  }
  this.removeEventListener("click", funBestWidth);
};
let funRecordvariant = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":记录变式");
  }
  this.removeEventListener("click", funRecordvariant);
};
let funRecordCollapseAll = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":全部折叠");
  }
  this.removeEventListener("click", funRecordCollapseAll);
};
let funRecordExpandAll = function() {
  let gridKey = getGridKey(this);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":全部展开");
  }
  this.removeEventListener("click", funRecordExpandAll);
};
let funCreateAdditionalFeatures = function() {
  let tdEl = this.parentElement.parentElement;
  let gridKey = getGridKey(tdEl);
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:行," + gridKey + ":创建附加特性");
  }
  this.removeEventListener("click", funRecordvariant);
};
let clickSort = function() {
  if (AutoRecord.AutoRecord) {
    let order = this.getAttribute("order");
    let thEl = this.parentElement.parentElement.parentElement;
    let colName = thEl.getAttribute("title");
    let thId = thEl.id;
    let gridKey = thId.replace(/\d_/, "");
    gridKey = gridKey.substring(0, gridKey.lastIndexOf("_"));
    let colKey = thEl.getAttribute("colkey");
    let form2 = RecordCase.getCurForm();
    RecordCase.requestRecordStep("点击:排序#" + order + ":" + gridKey + ",[" + form2.formKey + "&" + gridKey + "&" + colKey + "[" + colName + "]]");
  }
  this.removeEventListener("click", clickSort);
};
let clickTracedBack = function() {
  if (AutoRecord.AutoRecord) {
    let currPage2 = RecordCase.getCurrPage();
    let gridElm = RecordCase.getElementByXpath("./ancestor::div[contains(@class,'ui-ygrid')]", this);
    let gridKey = gridElm.getAttribute("id").replace(/[\d]+_/, "").replace("_box", "");
    let activeThElm = gridElm.querySelector("th.active");
    let nameEl = RecordCase.getElementByXpath("./a", this);
    let name2 = nameEl.textContent;
    let form2 = RecordCase.getCurForm();
    if (activeThElm) {
      let colCaption = activeThElm.getAttribute("title");
      let colKey = activeThElm.getAttribute("colkey");
      RecordCase.requestRecordStep("点击:列头菜单:" + gridKey + "&[" + form2.formKey + "&" + gridKey + "&" + colKey + "[" + colCaption + "]]&" + name2);
    } else {
      let selectTdEL = currPage2.querySelector("div.ui-ygrid td.ui-state-highlight");
      let tdAriaDescribed = selectTdEL.getAttribute("aria-describedby");
      let thEL = RecordCase.getElementByXpath(".//th[@id='" + tdAriaDescribed + "']", currPage2);
      let colCaption = thEL.getAttribute("title");
      let formId2 = tdAriaDescribed.substring(0, tdAriaDescribed.indexOf("_"));
      let grid = FormStack.getForm(formId2).getComponent(gridKey);
      let trEl = RecordCase.getElementByXpath("./..", selectTdEL);
      let rowNum = trEl.getAttribute("id").replace("ygd", "");
      rowNum = RecordCase.getActualRowIndex(grid, rowNum);
      RecordCase.requestRecordStep("追溯:" + gridKey + ":" + colCaption + "," + (parseInt(rowNum) + 1) + ":" + name2);
    }
  }
  this.removeEventListener("click", clickTracedBack);
};
let clickShrinkButton = function() {
  if (AutoRecord.AutoRecord) {
    let btnDiv = this.parentElement;
    let btnLabel = RecordCase.getElementByXpath("./label", btnDiv);
    let btnName = btnLabel.textContent;
    RecordCase.requestRecordStep("点击:收缩按钮:" + btnName);
  }
  this.removeEventListener("click", clickShrinkButton);
};
let clickGridSearchButton = function() {
  if (AutoRecord.AutoRecord) {
    let btnClass = this.getAttribute("class");
    let btnName = "";
    switch (btnClass) {
      case "ui-ygrid--search-next":
        btnName = "下一个";
        break;
      case "ui-ygrid--search-prev":
        btnName = "上一个";
        break;
      case "ui-ygrid--search-close":
        btnName = "关闭";
        break;
    }
    RecordCase.requestRecordStep("点击:表格搜索:" + btnName);
  }
  this.removeEventListener("click", clickGridSearchButton);
};
let clickDropBtn = function() {
  if (AutoRecord.AutoRecord) {
    let viewEl = this.parentElement.parentElement;
    let viewId = viewEl.getAttribute("id");
    let ctrId = viewId.substring(0, viewId.lastIndexOf("_"));
    let ctrEl = document.querySelector("[id='" + ctrId + "']");
    let aEL = this.querySelector("a");
    let firstBtnName = ctrEl.getAttribute("caption");
    let secondBtnName = aEL.textContent;
    RecordCase.requestRecordStep("点击:" + firstBtnName + ":" + secondBtnName);
  }
  this.removeEventListener("click", clickDropBtn);
};
let clickPanelZoom = function() {
  if (AutoRecord.AutoRecord) {
    let panelEL = this.parentElement.parentElement;
    let panelId = panelEL.getAttribute("id");
    let panelKey = panelId.replace(/\d_/, "");
    RecordCase.requestRecordStep("点击:缩放按钮:" + panelKey);
  }
  this.removeEventListener("click", clickPanelZoom);
};
let selectTreeGrid = function() {
  if (this.getAttribute("class").indexOf("cell-collapse") > -1 && AutoRecord.AutoRecord) {
    let tdElm = RecordCase.getElementByXpath("./ancestor::td[1]", this);
    let cellInfo = RecordCase.getCellInfo(tdElm);
    RecordCase.requestRecordStep("选择:表格:" + cellInfo.rowNum + "," + cellInfo.colNum + "," + cellInfo.gridKey + ",选择");
  }
};
let selectColTh = function() {
  if (AutoRecord.AutoRecord) {
    var thELement = RecordCase.getElementByXpath("./ancestor::th[1]", this);
    var thCaption = RecordCase.getElementByXpath(".//*[contains(@class,'col-caption')]", thELement).innerText;
    var thId = thELement.getAttribute("id");
    var thKey = thELement.getAttribute("meta-key");
    var gridKey = thId.replace(/_column[\d]+/, "").substring(thId.indexOf("_") + 1);
    var value2 = this.getAttribute("class").indexOf("checked") > -1;
    var formId2 = thId.substring(0, thId.indexOf("_"));
    var form2 = FormStack.getForm(formId2);
    RecordCase.requestRecordStep("选择:列头,[" + form2.formKey + "&" + gridKey + "&" + thKey + "[" + thCaption + "]]:" + value2 + "," + gridKey);
    RecordCase.colThCaption = thCaption;
    RecordCase.colThGridKey = gridKey;
    RecordCase.colThValue = value2 + "";
  }
  this.removeEventListener("click", selectColTh);
};
let selectTxtBtn = function() {
  if (AutoRecord.AutoRecord) {
    var captioninfo = RecordCase.getCompCaption(this);
    var form2 = RecordCase.getCurForm();
    RecordCase.requestRecordStep("选择:编辑按钮:[" + form2.formKey + "&NoGrid&" + captioninfo.fieldKey + "[" + captioninfo.fieldCaption + "]]");
  }
  this.removeEventListener("click", selectTxtBtn);
};
let selectDictOrCmbBoxBtn = function() {
  if (AutoRecord.AutoRecord && AutoRecord.RecordCheck === "true") {
    var compElm = RecordCase.getElementByXpath("./ancestor::div[contains(@class,'ui-control')]", this);
    var compElmClass = compElm.getAttribute("class");
    var isDict = compElmClass.indexOf("ui-dict") > -1;
    var isComboBox = compElmClass.indexOf("ui-cmb") > -1;
    var isGrid = compElmClass.indexOf("cellEditor") > -1;
    var fieldInfo;
    var caption2;
    var fieldKey;
    if (isGrid) {
      var cellInfo = RecordCase.getCellInfo(RecordCase.getElementByXpath("./ancestor::td[1]", compElm));
      caption2 = "[" + cellInfo.formKey + "&" + cellInfo.gridKey + "&" + cellInfo.colKey + "[" + cellInfo.columnCaption + "]]," + cellInfo.gridKey + "," + cellInfo.rowNum;
    } else {
      fieldInfo = RecordCase.getCompCaption(compElm);
      caption2 = fieldInfo.fieldCaption;
      fieldKey = fieldInfo.fieldKey;
    }
    let form2 = RecordCase.getCurForm();
    if (isDict) {
      RecordCase.requestRecordStep("选择:字典下拉按钮:[" + form2.formKey + "&NoGrid&" + fieldKey + "[" + caption2 + "]]");
    }
    if (isComboBox) {
      RecordCase.requestRecordStep("选择:下拉按钮:[" + form2.formKey + "&NoGrid&" + fieldKey + "[" + caption2 + "]]");
    }
  }
  this.removeEventListener("click", selectDictOrCmbBoxBtn);
};
let selectHistory = function(pointerEvent) {
  if (AutoRecord.AutoRecord) {
    const currPage2 = RecordCase.getCurrPage(), formId2 = RecordCase.getFormId(currPage2), index2 = DOMUtil.prevAll(pointerEvent.currentTarget).length + 1;
    var inputOrDivEl = currPage2.getElementsByClassName("line_focus");
    let content2 = "选择:历史记录:", inputValue = inputOrDivEl[0].value;
    if (inputOrDivEl != void 0 && inputOrDivEl != "" && inputOrDivEl.length != 0 && inputOrDivEl[0].parentElement.tagName.toLowerCase() == "td") {
      var tdEl = inputOrDivEl[0].parentElement;
      var gridKey = tdEl.getAttribute("aria-describedby").split("_")[1];
      var colKey = tdEl.getAttribute("meta-key");
      var trId = tdEl.parentElement.getAttribute("id");
      var rowIndex = trId.charAt(trId.length - 1);
      content2 = content2 + gridKey + "," + colKey + "," + rowIndex + ":" + index2;
    } else {
      if (inputOrDivEl == void 0 || inputOrDivEl == "" || inputOrDivEl.length == 0) {
        alert("录制选择历史记录时，没有找到焦点控件");
        return;
      } else {
        var fieldKey = inputOrDivEl[0].getAttribute("id").replace(formId2 + "_", "");
        content2 = content2 + fieldKey + ":" + index2;
      }
    }
    if (inputValue != void 0 && inputValue != "") {
      content2 = content2 + "," + inputValue;
    }
    RecordCase.requestRecordStep(content2);
  }
  this.removeEventListener("click", selectHistory);
};
let clickHyperLink = function() {
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("点击:" + this.textContent);
  }
  this.removeEventListener("click", clickHyperLink);
};
let clickDicTrace = function(pointerEvent) {
  if (AutoRecord.AutoRecord) {
    const btn = pointerEvent.currentTarget;
    let form2 = RecordCase.getCurForm();
    var content2 = "选择:字典追溯:";
    if (btn.parentElement.tagName == "td") {
      var tdEl = btn.parentElement;
      var gridKey = tdEl.getAttribute("aria-describedby").split("_")[1];
      var colKey = tdEl.getAttribute("meta-key");
      var trId = tdEl.parentElement.getAttribute("id");
      var rowIndex = trId.charAt(trId.length - 1);
      var colName = RecordCase.getColNameByTdEl(tdEl);
      content2 = content2 + gridKey + ",[" + form2.formKey + "&" + gridKey + "&" + colKey + "[" + colName + "]]," + rowIndex;
    } else {
      var id = btn.parentElement.getAttribute("id");
      var caption2 = btn.parentElement.getAttribute("caption");
      if (id == void 0 || id == "") {
        id = btn.parentElement.firstElementChild.getAttribute("id");
        caption2 = btn.parentElement.firstElementChild.getAttribute("caption");
      }
      id = id.replace(/[0-9]_/, "");
      content2 = content2 + "[" + form2.formKey + "&NoGrid&" + id + "[" + caption2 + "]]";
    }
    RecordCase.requestRecordStep(content2);
  }
  this.removeEventListener("click", clickDicTrace);
};
let queryCondition = function() {
  if (AutoRecord.AutoRecord) {
    if (this.textContent === "清除条件") {
      RecordCase.requestRecordStep("清除条件");
    } else {
      RecordCase.requestRecordStep("查询变式:" + this.textContent);
    }
  }
  this.removeEventListener("click", queryCondition);
};
let selectSeniorQuery = function() {
  if (AutoRecord.AutoRecord) {
    let ctrEl = this.parentElement.parentElement;
    let caption2 = ctrEl.getAttribute("caption");
    let fieldKey = ctrEl.getAttribute("id").replace(/\d+_/, "");
    let form2 = RecordCase.getCurForm();
    if (!caption2) {
      caption2 = "noCaption";
    }
    RecordCase.requestRecordStep("选择:高级查询:[" + form2.formKey + "&NoGrid&" + fieldKey + "[" + caption2 + "]]");
  }
  this.removeEventListener("click", selectSeniorQuery);
};
let designExpressionInput = function() {
  if (AutoRecord.AutoRecord) {
    let expressionTextEl = document.querySelectorAll("pre.CodeMirror-line > span");
    let expressionText = expressionTextEl[expressionTextEl.length - 1].textContent;
    RecordCase.requestRecordStep("设计器表达式录入:{" + expressionText + "}");
  }
  this.removeEventListener("blur", designExpressionInput);
};
let isAreaMouseDown = false;
let row = -1;
let col = -1;
let areaMouseDown = function(e) {
  try {
    if (AutoRecord.AutoRecord && !isAreaMouseDown) {
      let element = document.elementFromPoint(e.pageX, e.pageY);
      if (element.tagName.toLowerCase() === "span" && element.getAttribute("class").indexOf("ui-icon-trash") > -1)
        return;
      let tdElement = element.tagName.toLowerCase() === "td" ? element : RecordCase.getElementByXpath("./ancestor::td[1]", element);
      let trElement = RecordCase.getElementByXpath("./ancestor::tr[1]", element);
      col = RecordCase.getElementsByXpath("./preceding-sibling::td", tdElement).length + 1;
      row = RecordCase.getElementsByXpath("./preceding-sibling::tr[not(@class)]", trElement).length + 1;
      isAreaMouseDown = true;
    }
  } catch (e2) {
    this.removeEventListener("click", areaMouseDown);
    isAreaMouseDown = false;
  }
  this.removeEventListener("click", areaMouseDown);
};
let areaMouseUp = function(e) {
  try {
    if (AutoRecord.AutoRecord && isAreaMouseDown) {
      let element = document.elementFromPoint(e.pageX, e.pageY);
      if (element.tagName.toLowerCase() === "span" && element.getAttribute("class").indexOf("ui-icon-trash") > -1)
        return;
      if (element.tagName.toLowerCase() === "div") {
        element = e.target;
      }
      let tdElement = element.tagName.toLowerCase() === "td" ? element : RecordCase.getElementByXpath("./ancestor::td[1]", element);
      let trElement = RecordCase.getElementByXpath("./ancestor::tr[1]", element);
      let upCol = RecordCase.getElementsByXpath("./preceding-sibling::td", tdElement).length + 1;
      let upRow = RecordCase.getElementsByXpath("./preceding-sibling::tr[not(@class)]", trElement).length + 1;
      isAreaMouseDown = false;
      if (upCol === col && upRow === row) {
        RecordCase.requestRecordStep("设计器选择:区域设计:" + row + ":" + col);
      } else {
        let minCol = upCol <= col ? upCol : col;
        let maxCol = upCol >= col ? upCol : col;
        let minRow = upRow <= row ? upRow : row;
        let maxRow = upRow >= row ? upRow : row;
        RecordCase.requestRecordStep("设计器控件拖动:区域设计:" + minRow + "," + minCol + ":" + maxRow + "," + maxCol);
      }
    }
  } catch (e2) {
    this.removeEventListener("click", areaMouseUp);
    isAreaMouseDown = false;
  }
  this.removeEventListener("click", areaMouseUp);
};
let clickDesignerTxtBtn = function() {
  if (AutoRecord.AutoRecord) {
    var captionInfo = RecordCase.getCompCaption(this);
    RecordCase.requestRecordStep("设计器点击:文本按钮:" + captionInfo.fieldCaption);
  }
  this.removeEventListener("click", clickDesignerTxtBtn);
};
let clickDesignerDropBtn = function() {
  if (AutoRecord.AutoRecord) {
    let classAttribute = this.getAttribute("class");
    let labelName = this.nextElementSibling.innerText;
    let result = classAttribute.indexOf("icon-jianhaoshouqi") > -1 ? "展开" : "收缩";
    RecordCase.requestRecordStep("设计器点击:下拉按钮:" + labelName + ":" + result);
  }
  this.removeEventListener("click", clickDesignerDropBtn);
};
let clickDesignerAddPanel = function() {
  if (AutoRecord.AutoRecord) {
    let pnlElement = RecordCase.getElementsByXpath("./ancestor::div[contains(@class,'ui-pnl')]", this);
    let idAttribute = pnlElement[0].getAttribute("id").trim();
    let pnlKey = idAttribute.replace(/\d+_/, "");
    RecordCase.requestRecordStep("设计器点击:增加面板:" + pnlKey);
  }
  this.removeEventListener("click", clickDesignerAddPanel);
};
let clickDesignerAreaTrash = function() {
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("设计器点击:区域设计:删除");
  }
  this.removeEventListener("click", clickDesignerAreaTrash);
};
let componentOperation = function() {
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("设计器控件操作:" + this.getAttribute("title"));
  }
  this.removeEventListener("click", componentOperation);
};
let clickDesignerPrompt = function() {
  if (AutoRecord.AutoRecord) {
    let btnName = this.innerText;
    let dialog = RecordCase.getElementByXpath("./ancestor::div[contains(@class,'layui-layer-dialog')]", this);
    let dialogTitle = dialog.querySelector(".layui-layer-title");
    let dialogContent = dialog.querySelector(".layui-layer-content");
    RecordCase.requestRecordStep("设计器提示框:" + dialogTitle.innerText + ":" + btnName + ":" + dialogContent.innerText);
  }
  this.removeEventListener("click", clickDesignerPrompt);
};
let designSearch = function() {
  if (AutoRecord.AutoRecord) {
    let text = this.value;
    RecordCase.requestRecordStep("设计器快捷键:源代码搜索:" + text);
  }
  this.removeEventListener("change", designSearch);
};
let clickDataRow = function() {
  if (AutoRecord.AutoRecord) {
    let tableType;
    let rowName = this.textContent;
    let trEL = this.parentElement.parentElement;
    let sourcetype = trEL.getAttribute("sourcetype");
    if (sourcetype.indexOf("source") > -1) {
      tableType = "源表";
    } else if (sourcetype.indexOf("target") > -1) {
      tableType = "目标表";
    } else {
      tableType = "反填表";
    }
    RecordCase.requestRecordStep("设计器数据选择:行:" + tableType + ":" + rowName);
  }
  this.removeEventListener("mousedown", clickDataRow);
};
let clickCnnectLine = function() {
  if (AutoRecord.AutoRecord) {
    let pathId = this.getAttribute("pathId");
    let idInfo = pathId.split("*_*");
    let sourceFieldKey = idInfo[1];
    let targetFieldKey = idInfo[3];
    RecordCase.requestRecordStep("设计器数据选择:连接线:" + sourceFieldKey + "," + targetFieldKey);
  }
  this.removeEventListener("mousedown", clickCnnectLine);
};
let clickDeleteBtn = function() {
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("设计器数据点击:删除");
  }
  this.removeEventListener("click", clickDeleteBtn);
};
let clickLinkDataMapBtn = function() {
  if (AutoRecord.AutoRecord) {
    RecordCase.requestRecordStep("设计器数据点击:关联数据映射");
  }
  this.removeEventListener("click", clickLinkDataMapBtn);
};
let clickMore = function() {
  if (AutoRecord.AutoRecord) {
    let tableType = getTableType(this);
    let tableELsBeforeThis = RecordCase.getElementsByXpath("./../../../../preceding-sibling::table", this);
    let index2 = tableELsBeforeThis.length;
    RecordCase.requestRecordStep("设计器数据点击:更多:" + tableType + ":" + (index2 + 1));
  }
  this.removeEventListener("click", clickMore);
};
let index = 0;
let clickAddBtn = function() {
  if (AutoRecord.AutoRecord) {
    let tableELsBeforeThis = RecordCase.getElementsByXpath("./../../../../preceding-sibling::table", this);
    index = tableELsBeforeThis.length;
  }
  this.removeEventListener("click", clickAddBtn);
};
let clickAddFieldBtn = function() {
  if (AutoRecord.AutoRecord) {
    let fieldType = this.textContent == "添加Const类型字段" ? "常量" : "公式";
    let trEl = RecordCase.getElementByXpath("./../../../..", this);
    let sourcetype = trEl.getAttribute("sourcetype");
    let tableType;
    if (sourcetype.indexOf("source") > -1) {
      tableType = "源表";
    } else if (sourcetype.indexOf("target") > -1) {
      tableType = "目标表";
    } else {
      tableType = "反填表";
    }
    RecordCase.requestRecordStep("设计器数据点击:添加字段:" + tableType + ":" + index + ":" + fieldType);
  }
  this.removeEventListener("click", clickAddFieldBtn);
};
let cmbIndex = 0;
let clickDataCmb = function() {
  if (AutoRecord.AutoRecord) {
    let tableELsBeforeThis = RecordCase.getElementsByXpath("./../../../../preceding-sibling::table", this);
    cmbIndex = tableELsBeforeThis.length;
  }
  this.removeEventListener("click", clickDataCmb);
};
let clickDataCmbOption = function() {
  if (AutoRecord.AutoRecord) {
    let optionText = this.textContent;
    let tableType = getTableType(this);
    RecordCase.requestRecordStep("设计器录入:下拉框:" + tableType + ":" + cmbIndex + ":" + optionText);
  }
  this.removeEventListener("click", clickDataCmbOption);
};
let clickDataAttributeCmb = function() {
  if (AutoRecord.AutoRecord) {
    let liEl = this.parentElement;
    let nameSpan = liEl.querySelector("span");
    let name2 = nameSpan.textContent;
    RecordCase.requestRecordStep("设计器数据选择:属性下拉框:" + name2);
  }
  this.removeEventListener("click", clickDataAttributeCmb);
};
let getTableType = function(el) {
  let tableDiv = RecordCase.getElementByXpath("./../../../../..", el);
  let divClass = tableDiv.getAttribute("class");
  let tableType;
  if (divClass.indexOf("source") > -1) {
    tableType = "源表";
  } else if (divClass.indexOf("target") > -1) {
    tableType = "目标表";
  } else {
    tableType = "反填表";
  }
  return tableType;
};
let selectPermissionTreeNode = function() {
  if (AutoRecord.AutoRecord) {
    let nameSpanEl = this.parentElement.querySelector("a span.node_name");
    let currName = nameSpanEl.textContent;
    let isCheck = this.getAttribute("class").indexOf("checkbox_false_full") > -1 ? "true" : "false";
    let treePath = currName;
    if (currName != "全选") {
      let previousLevelNodeNameSpan = this.parentElement.parentElement.parentElement.querySelector("a span.node_name");
      let previousLevelNodeName = previousLevelNodeNameSpan.textContent;
      let previousLevelNum = 0;
      while (previousLevelNodeName != "全选" && previousLevelNum < 20) {
        treePath = previousLevelNodeName + "," + treePath;
        previousLevelNodeNameSpan = previousLevelNodeNameSpan.parentElement.parentElement.parentElement.parentElement.querySelector("a span.node_name");
        previousLevelNodeName = previousLevelNodeNameSpan.textContent;
        previousLevelNum++;
      }
    }
    let content2 = "SAP权限选择:节点:" + treePath + ":" + isCheck;
    RecordCase.requestRecordStep(content2);
  }
  this.removeEventListener("click", selectPermissionTreeNode);
};
const NotERPProKeysCache = {};
class RecordMenus {
  async getNotERPProjectKeys() {
    let result = NotERPProKeysCache["NotERPProKeys"];
    if (result) {
      return result;
    } else {
      result = await new RichDocService().getNotERPProKeys();
      NotERPProKeysCache["NotERPProKeys"] = result;
      return result;
    }
  }
  async getMetaFormByEntry(entryPath, appKey = "") {
    var params = {
      cmd: "GetFormByEntry",
      service: "WebMetaService",
      path: entryPath
    };
    var r = new Request();
    if (appKey) {
      r.addHeader("appKey", appKey);
    }
    var metaForm = await r.getData(params);
    var process = new MetaFormProcess(metaForm);
    process.process();
    const getMetaFormByEntryDef = metaForm;
    const getNotERPProjectKeysDef = this.getNotERPProjectKeys();
    return Promise.all([getMetaFormByEntryDef, getNotERPProjectKeysDef]).then((result) => {
      const [metaForm2, notERPProjectKeys] = result;
      const projectKey = metaForm2.projectKey;
      metaForm2.isERPForm = notERPProjectKeys.indexOf(projectKey) < 0;
      return metaForm2;
    });
  }
}
class InputValue {
  async valueChanged(comp2, ignoreValueChange) {
    await this.base.valueChanged(comp2, ignoreValueChange);
    if (AutoRecord.AutoRecord && comp2.key !== "SearchBox") {
      let _comp = comp2;
      if (comp2.type === ControlType.COMBOBOX && !(RecordCase.getCurrPage().getAttribute("class").indexOf("dialog") > -1)) {
        setTimeout(function() {
          recodeValueChanged(_comp);
        }, 750);
      } else {
        recodeValueChanged(_comp);
      }
    }
  }
  async cellValueChanged(grid, rowIndex, colIndex, editOpt, ignoreValueChange) {
    let self = this;
    if (AutoRecord.AutoRecord && editOpt.enable != "false" && grid.getEl()) {
      let cellType = grid.getDetailMetaRow().cells[colIndex].cellType;
      let form2 = FormStack.getForm(self.form.formID);
      let actualRowIndex = RecordCase.getActualRowIndex(grid, rowIndex);
      let formFormulaScope = await form2.getFormulaScope();
      let scope = formFormulaScope[editOpt.key];
      let isIncludeERPMidFunction = false;
      if (scope && scope.includeERPMidFunction) {
        isIncludeERPMidFunction = true;
      }
      if (cellType === ControlType.COMBOBOX && !(RecordCase.getCurrPage().getAttribute("class").indexOf("dialog") > -1)) {
        setTimeout(function() {
          recodeCellValueChanged(form2, grid, actualRowIndex, colIndex, isIncludeERPMidFunction);
        }, 750);
      } else {
        recodeCellValueChanged(form2, grid, actualRowIndex, colIndex, isIncludeERPMidFunction);
      }
    }
    await this.base.cellValueChanged(grid, rowIndex, colIndex, editOpt, ignoreValueChange);
  }
}
function recodeValueChanged(comp2) {
  var value2, caption2;
  if (comp2.getEl() == null) {
    return;
  }
  var compElm = comp2.getEl().vnode.elm;
  let isCompAttr;
  let compAttrGroupEL = document.querySelector(".RightDesignPanelContainer [id $= 'FlexFlowLayoutPanel1']");
  isCompAttr = RecordCase.getIsDesignModel() && compAttrGroupEL != null && RecordCase.isChildOf(compAttrGroupEL, compElm);
  let inputIndex = 0;
  if (!isCompAttr) {
    var classAttribute = compElm.getAttribute("class");
    if (classAttribute.indexOf("ui-web-bs") > -1) {
      return;
    }
    if (classAttribute.indexOf("ui-control") === -1 && classAttribute.indexOf("ui-rdo") === -1 && classAttribute.indexOf("ui-chk") === -1) {
      compElm = RecordCase.getElementsByXpath(".//div[contains(@class,'ui-control') or contains(@class,'ui-rdo') or contains(@class,'ui-chk')] | ./ancestor::div[contains(@class,'ui-control') or contains(@class,'ui-rdo') or contains(@class,'ui-chk')]", compElm)[0];
      classAttribute = compElm.getAttribute("class");
    }
    var isRadio = classAttribute.indexOf("ui-rdo") > -1;
    var isCheckBox = classAttribute.indexOf("ui-chk") > -1;
    var hasCaption = isRadio || isCheckBox || AutoRecord.ISUE;
    if (!hasCaption && comp2.caption != void 0 && comp2.caption != "" && comp2.buddyKey != void 0 && comp2.buddyKey != "") {
      let componentList = FormStack.getForm(comp2.ofFormID).getComponentList();
      for (let i2 in componentList) {
        if (componentList[i2].key === comp2.buddyKey) {
          hasCaption = true;
          break;
        }
      }
    }
    if (hasCaption) {
      var actulComp = compElm;
      if (isRadio) {
        actulComp = RecordCase.getCurrPage().querySelectorAll(".rdo[type='radio'][name*='" + comp2.groupKey + "'][value='" + comp2.value + "']")[0];
      }
      caption2 = RecordCase.getCompCaption(actulComp).fieldCaption;
    } else {
      caption2 = comp2.key;
    }
  } else {
    caption2 = comp2.caption;
    if (caption2 == "") {
      let captionCompEl = compElm.parentElement.parentElement.querySelector("td[col='0'] > div");
      caption2 = captionCompEl ? captionCompEl.getAttribute("caption") : comp2.key;
      inputIndex = DOMUtil.prevAll(compElm.parentElement).filter((f) => !f.style.display).length + 1;
    }
  }
  if (comp2.type == ControlType.DICT || comp2.type == ControlType.DYNAMICDICT) {
    if (comp2.multiSelect) {
      var text = "";
      if (comp2.value != null) {
        for (let i2 = 0, len = comp2.value.length; i2 < len; i2++) {
          var v = comp2.value[i2];
          if (v.oid != 0) {
            if (i2 == 0) {
              if (v.hasCaption()) {
                text = v.caption || v.getCaption();
              } else {
                text = v.code + " " + v.name;
              }
            } else {
              if (v.hasCaption()) {
                text = text + "," + v.getCaption();
              } else {
                text = text + "," + v.code + " " + v.name;
              }
            }
          } else {
            if (!comp2.independent) {
              text = I18N.getString("RIGHTSSET_SELECTALL", "全选");
              break;
            }
          }
        }
      }
      value2 = text;
    } else {
      if (comp2.value == void 0 || comp2.value.oid <= 0) {
        value2 = "";
      } else if (!comp2.value.hasCaption()) {
        if (!comp2.value.code || !comp2.value.name) {
          value2 = comp2.showText;
        } else {
          value2 = comp2.value.code + " " + comp2.value.name;
        }
      } else {
        value2 = comp2.value.caption || comp2.value.getCaption();
      }
    }
  } else if (comp2.type == ControlType.COMBOBOX) {
    value2 = comp2.showText;
  } else if (comp2.type == ControlType.CHECKBOX) {
    value2 = comp2.value;
  } else if (comp2.type == ControlType.RADIOBUTTON) {
    value2 = "true";
  } else if (comp2.type == ControlType.TEXTBUTTON || comp2.type == ControlType.TEXTEDITOR || comp2.type == ControlType.TEXTAREA || comp2.type == ControlType.TIMEPICKER) {
    value2 = comp2.value || comp2.preSearchValue;
  } else if (comp2.type == ControlType.UTCDATEPICKER || comp2.type == ControlType.DATEPICKER) {
    value2 = comp2.showText;
  } else {
    value2 = comp2.text || comp2.getText();
  }
  if (comp2.multiSelect) {
    if (value2.indexOf(":") > -1) {
      value2 = value2.replace(/:/g, "/：");
    }
  } else {
    value2 = RecordCase.replaceToTestCaseStepValue(value2);
  }
  if (!isCompAttr) {
    let form2 = FormStack.getForm(comp2.ofFormID);
    if (RecordCase.getIsDesignModel()) {
      RecordCase.requestRecordStep("设计器录入:" + caption2 + ":" + value2);
    } else {
      RecordCase.requestRecordStep("录入:[" + form2.formKey + "&NoGrid&" + comp2.key + "[" + caption2 + "]]:" + value2);
    }
  } else {
    RecordCase.requestRecordStep("设计器组件属性录入:" + caption2 + (inputIndex >= 2 ? "@" + inputIndex : "") + ":" + value2);
  }
}
function recodeCellValueChanged(form2, grid, rowIndex, colIndex, isIncludeERPMidFunction) {
  let key2 = "";
  let content2 = "";
  let caption2 = "";
  if (form2.formKey == "CaseManage")
    return;
  let value2;
  if (grid.getDetailMetaRow() != null) {
    let cellComponent = grid.getDetailMetaRow().cells[colIndex];
    let tdElement = RecordCase.getElementByXpath(".//tr[@id='ygd" + rowIndex + "']/td[contains(@aria-describedby,'_column" + colIndex + "') and substring-after(@aria-describedby,'_column" + colIndex + "')='']", grid.getEl().vnode.elm);
    let nextTd = RecordCase.getElementByXpath("./following-sibling::td", tdElement);
    if (!nextTd) {
      nextTd = RecordCase.getElementByXpath("./../following-sibling::tr/td", tdElement);
    }
    if (tdElement.getAttribute("class").indexOf("ui-state-highlight") == -1 && nextTd && nextTd.getAttribute("class").indexOf("ui-state-highlight") == -1) {
      return;
    }
    if (tdElement.style.display == "none") {
      return;
    }
    let cellInfo = RecordCase.getCellInfo(tdElement);
    caption2 = cellInfo.columnCaption;
    value2 = grid.getCellDataAt(rowIndex, colIndex).value;
    if (caption2 == "物料" && value2 != void 0 && value2.caption == void 0) {
      return;
    }
    if (cellComponent.cellType == ControlType.DICT || cellComponent.cellType == ControlType.DYNAMICDICT) {
      if (value2 != void 0) {
        if (value2.caption != void 0) {
          value2 = value2.caption;
        } else if (value2.caption == void 0) {
          value2 = grid.getCellDataAt(rowIndex, colIndex).caption;
        }
      } else if (value2 == void 0 && isIncludeERPMidFunction) {
        value2 = grid.getCellDataAt(rowIndex, colIndex).caption;
      } else {
        value2 = "";
      }
    } else if (cellComponent.cellType == ControlType.UTCDATEPICKER) {
      value2 = grid.getCellDataAt(rowIndex, colIndex).caption;
      if (typeof value2 != "string") {
        value2 = value2.Format("yyyy-MM-dd");
      }
    } else if (cellComponent.cellType == ControlType.CHECKBOX) {
      value2 = grid.getCellDataAt(rowIndex, colIndex).value + "";
      if (caption2 === RecordCase.colThCaption && grid.key === RecordCase.colThGridKey && value2 === RecordCase.colThValue) {
        return;
      } else {
        RecordCase.colThCaption = "";
        RecordCase.colThGridKey = "";
        RecordCase.colThValue = "";
      }
    } else {
      value2 = grid.getCellDataAt(rowIndex, colIndex).caption;
    }
    if (value2 === "") {
      value2 = "清空";
    }
    if (value2 === "-") {
      value2 = "{" + value2 + "}";
    }
    key2 = !RecordCase.getIsDesignModel() ? "表格录入" : "设计器表格录入";
    if (typeof value2 == "string") {
      if (value2.indexOf('"') > -1 || value2.indexOf("'") > -1 || value2.indexOf(";") > -1 || value2.indexOf(":") > -1) {
        value2 = "{" + value2 + "}";
      }
      content2 = "[" + cellInfo.formKey + "&" + grid.key + "&" + cellInfo.colKey + "[" + caption2 + "]]," + grid.key + "," + (rowIndex + 1) + ":" + value2;
    } else {
      value2 = value2 + "";
      if (value2.indexOf("中国标准时间")) {
        let d = new Date(value2);
        let hours = d.getHours() === 0 ? "00" : d.getHours();
        let minutes = d.getMinutes() === 0 ? "00" : d.getHours();
        let seconds = d.getSeconds() === 0 ? "00" : d.getHours();
        let datetime = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate() + " " + hours + ":" + minutes + ":" + seconds;
        content2 = "[" + cellInfo.formKey + "&" + grid.key + "&" + cellInfo.colKey + "[" + caption2 + "]]," + grid.key + "," + (rowIndex + 1) + ":" + datetime.replace(/:/g, "\\：");
      } else {
        content2 = "[" + cellInfo.formKey + "&" + grid.key + "&" + cellInfo.colKey + "[" + caption2 + "]]," + grid.key + "," + (rowIndex + 1) + ":" + value2;
      }
    }
  }
  if (key2 != "") {
    console.log(key2 + ":" + content2);
    RecordCase.requestRecordStep(key2 + ":" + content2);
  }
}
class ButtonClick {
  static doOnClick(btn, formula, key2, eventTarget) {
    if (AutoRecord.AutoRecord) {
      let buttonValue = btn.caption;
      let form2 = RecordCase.getCurForm();
      if (buttonValue == "") {
        let butttonEl = btn.getEl().vnode.elm;
        let btn_icons = butttonEl.getElementsByClassName("icon");
        if (btn_icons.length == 1) {
          if (butttonEl.tagName === "DIV") {
            buttonValue = "样式:" + butttonEl.title;
          }
        }
      }
      RecordCase.requestRecordStep("点击:[" + form2.formKey + "&NoGrid&" + btn.key + "[" + buttonValue + "]]");
    }
    return this.base.doOnClick(btn, formula, key2, eventTarget);
  }
}
class ToolBarOpt {
  static async doOnClick(formID, item, toolbar2, eventTarget) {
    if (!AutoRecord.AutoRecord || toolbar2.form.formKey == "CaseManage") {
      await this.base.doOnClick(formID, item, toolbar2, eventTarget);
      return;
    }
    let caption2 = item.caption;
    let key2 = item.key, secondKey;
    let first, second;
    let isFind;
    let content2;
    let firstArr = toolbar2.items;
    let keyWord = "操作:";
    let isSecond;
    if (eventTarget.parentElement) {
      let el = eventTarget.parentElement;
      let flag = 5;
      while (el.tagName != "LI" && flag > 0) {
        el = el.parentElement;
        flag--;
      }
      isSecond = el.hasClass("dp-item");
    } else {
      isSecond = false;
    }
    for (let index2 = 0; index2 < firstArr.length; index2++) {
      const item2 = firstArr[index2];
      first = item2.caption;
      if (first === caption2 && !isSecond) {
        content2 = first;
        break;
      }
      let secondArr = item2.items;
      if (secondArr) {
        for (let index1 = 0; index1 < secondArr.length; index1++) {
          const item1 = secondArr[index1];
          second = item1.caption;
          secondKey = item1.key;
          if (second === caption2 && key2 === secondKey) {
            isFind = true;
            break;
          }
        }
      }
      if (isFind) {
        content2 = first + ":" + second;
        break;
      }
    }
    if (content2 === "关闭") {
      content2 = "close";
    }
    if (DesignModeSetting.isDesignMode) {
      let leftEl = document.querySelector(".DesignerFileTree .Y_designertoolbar");
      let rightEl = document.querySelector(".RightDesignPanelContainer .ui-tabs-panel.aria-show .Y_designertoolbar");
      if (AutoRecord.isCtrlDown) {
        keyWord = "设计器快捷键:操作:";
      } else if (rightEl != null && RecordCase.isChildOf(rightEl, eventTarget.parentElement ? eventTarget.parentElement : eventTarget.currentTarget)) {
        keyWord = "设计器操作:";
      } else if (leftEl != null && RecordCase.isChildOf(leftEl, eventTarget.parentElement ? eventTarget.parentElement : eventTarget.currentTarget)) {
        keyWord = "设计器文件树操作:";
      } else {
        content2 = null;
      }
    }
    if (content2) {
      RecordCase.requestRecordStep(keyWord + content2);
    }
    await this.base.doOnClick(formID, item, toolbar2, eventTarget);
  }
}
class ErrorDialogOpt {
  show() {
    this.base.show();
    let dialog = document.querySelector("#error_dialog");
    let msg = dialog.querySelector(".dialog-content-inner").textContent || dialog.querySelector(".dialog-detail").textContent || dialog.querySelector(".dialog-content").textContent;
    let closeEl = dialog.querySelector(".dialog-close");
    let buttonEls = dialog.querySelectorAll("button.dialog-button");
    closeEl.addEventListener("mousedown", function() {
      if (AutoRecord.AutoRecord) {
        RecordCase.requestRecordStep("提示框:错误:[X]:" + msg);
      }
    });
    buttonEls.forEach((item) => {
      const element = item;
      element.addEventListener("click", function() {
        if (AutoRecord.AutoRecord) {
          RecordCase.requestRecordStep("提示框:错误:" + element.textContent + ":" + msg);
        }
      });
    });
  }
}
class GridHandlerRecord {
  static async doOnDblClick(grid, rowIndex, colIndex) {
    if (AutoRecord.AutoRecord) {
      const formID = grid.ofFormID, form2 = FormStack.getForm(formID);
      if (grid.getFocusColIndex() != -1 && !grid.getCellDataAt(grid.getFocusRowIndex(), grid.getFocusColIndex()).enable) {
        let stepCaptionInfo = "";
        let row2 = rowIndex + 1;
        let fieldInfo = await RecordCase.getMetaColumnCaption(form2, grid, grid.getFocusColIndex());
        stepCaptionInfo = "[" + form2.formKey + "&" + grid.key + "&" + fieldInfo.filedKey + "[" + fieldInfo.fieldCaption + "]]";
        RecordCase.requestRecordStep("双击:表格:" + stepCaptionInfo + "&" + grid.key + "&" + row2);
      }
    }
    await this.base.doOnDblClick(grid, rowIndex, colIndex);
  }
  static async doOnCellClick(grid, rowIndex, colIndex) {
    if (AutoRecord.AutoRecord) {
      const form2 = FormStack.getForm(grid.ofFormID);
      if (form2.formKey != "CaseManage") {
        const cellType = grid.getCellEditOpt(rowIndex, colIndex).editOptions.cellType;
        if (grid.getDetailMetaRow() != null) {
          let stepCaptionInfo = "";
          var actualRowIndex = RecordCase.getActualRowIndex(grid, rowIndex) + 1;
          var fieldInfo = await RecordCase.getMetaColumnCaption(form2, grid, colIndex);
          stepCaptionInfo = "[" + form2.formKey + "&" + grid.key + "&" + fieldInfo.filedKey + "[" + fieldInfo.fieldCaption + "]]";
          switch (cellType) {
            case ControlType.TEXTBUTTON:
              RecordCase.requestRecordStep("选择:表格,文本按钮:" + stepCaptionInfo + "&" + grid.key + "&" + actualRowIndex);
              break;
            case ControlType.BUTTON:
              RecordCase.requestRecordStep("点击表格:" + grid.key + ":" + stepCaptionInfo + ":" + actualRowIndex);
              break;
            case ControlType.HYPERLINK:
              RecordCase.requestRecordStep("选择:表格:" + stepCaptionInfo + "&" + grid.key + "&" + actualRowIndex);
              break;
          }
        }
      }
    }
    await this.base.doOnCellClick(grid, rowIndex, colIndex);
  }
  static async doOnRowClick(grid, rowIndex) {
    this.base.doOnRowClick(grid, rowIndex);
    if (AutoRecord.AutoRecord && grid.getFocusColIndex() > -1) {
      let form2 = FormStack.getForm(grid.ofFormID);
      if (form2.caption == "文件树" && AutoRecord.SelectFileTree == "true") {
        let row2 = grid.getRowDataAt(rowIndex);
        for (let i2 = 0; i2 < row2.data.length; i2++) {
          if (row2.data[i2].key === "Key") {
            let keyValue = row2.data[i2].value;
            let rootPath = "solutions\\erp-solution-core\\";
            let root = "YigoERP";
            if (keyValue.indexOf("erp-solution-practices") > -1) {
              rootPath = "solutions\\erp-solution-practices\\";
              root = "YigoERPPractices";
            }
            if (keyValue.indexOf(rootPath) == -1) {
              RecordCase.requestRecordStep("设计器选择:文件树:" + root);
              return;
            }
            let paths = keyValue.substring(keyValue.indexOf(rootPath) + rootPath.length).split("\\");
            let path = "";
            for (let i22 = 0; i22 < paths.length; i22++) {
              if (i22 !== paths.length - 1) {
                path += paths[i22] + ":";
              } else {
                path += paths[i22];
              }
            }
            path = path.replace("xml", "");
            RecordCase.requestRecordStep("设计器选择:文件树:" + root + ":" + path);
            break;
          }
        }
      } else if (grid.caption === "表单节点树" && grid.ofFormKey === "D_DesignTab_R" && AutoRecord.SelectNodeTree === "true") {
        let gridEl = grid.getEl().vnode.elm;
        let row2 = grid.getRowDataAt(rowIndex);
        let key2, parentKey;
        for (let i2 = 0; i2 < row2.data.length; i2++) {
          if (row2.data[i2].key === "PanelKey") {
            key2 = row2.data[i2].value.trim();
          }
          if (row2.data[i2].key === "ParentKey") {
            parentKey = row2.data[i2].value.trim();
          }
          if (key2 !== void 0 && parentKey !== void 0) {
            let paths = [key2, parentKey];
            let path = "";
            while (parentKey !== null) {
              let els = RecordCase.getElementsByXpath(".//tr/td[@meta-columnkey='PanelKey' and @title = '" + parentKey + "']/following-sibling::td[@meta-columnkey='ParentKey']", gridEl);
              if (els.length > 0) {
                parentKey = els[0].textContent;
                if (parentKey === "")
                  continue;
                paths.push(parentKey);
              } else {
                parentKey = null;
              }
            }
            for (let i22 = paths.length - 1; i22 >= 0; i22--) {
              if (i22 !== 0) {
                path += paths[i22] + ":";
              } else {
                path += paths[i22];
              }
            }
            RecordCase.requestRecordStep("设计器选择:节点树:" + path);
            break;
          }
        }
      } else if (AutoRecord.RecordCheck == "true" && grid.ofFormKey != "CaseManage") {
        const formId2 = grid.ofFormID;
        const form22 = FormStack.getForm(formId2);
        const colName = grid.getColumnAt(grid.getFocusColIndex()).caption;
        const colKey = grid.getColumnAt(grid.getFocusColIndex()).key;
        const rowNum = RecordCase.getActualRowIndex(grid, grid.getFocusRowIndex()) + 1;
        const gridKey = grid.key;
        let colInfo = "[" + form22.formKey + "&" + gridKey + "&" + colKey + "[" + colName + "]]";
        let content2 = "选择:表格:" + colInfo + "&" + gridKey + "&" + rowNum;
        const colNum = RecordCase.getActualColIndex(grid, grid.getFocusRowIndex(), grid.getFocusColIndex()) + 1;
        let gridId = formId2 + "_" + gridKey + "_box";
        let tdEL = RecordCase.getElementByXpath(".//div[@id='" + gridId + "']//table//tr[@id='ygd" + grid.getFocusRowIndex() + "']//td[@role='gridcell'][" + (grid.getFocusColIndex() + 1) + "]", RecordCase.getCurrPage());
        if (tdEL != void 0) {
          let expandSpan = tdEL.querySelector("span.cell-tree-icon");
          if (expandSpan != void 0) {
            let spanCss = expandSpan.getAttribute("class");
            if (spanCss != "cell-tree-icon") {
              let expandStatus = spanCss.indexOf("cell-expand") ? "0" : "1";
              content2 = "选择:表格:" + rowNum + "," + colNum + "," + gridKey + ",选择," + expandStatus;
            }
          }
        }
        if (RecordCase.recordRowClickContent != content2 && rowNum > 0) {
          RecordCase.requestRecordStep(content2);
          RecordCase.recordRowClickContent = content2;
        }
      }
    }
  }
}
class ListViewHandlerRecord {
  static doOnRowDblClick(listView, rowIndex) {
    if (AutoRecord.AutoRecord) {
      let list = listView.getEl().vnode.elm;
      RecordCase.requestRecordStep("双击:表格:" + (rowIndex + 1) + ",," + list.key);
    }
    return this.base.doOnRowDblClick(listView, rowIndex);
  }
  static async doOnCellClick(listView, rowIndex, colIndex) {
    if (AutoRecord.AutoRecord) {
      const caption2 = listView.columnInfo[colIndex].caption;
      let listViewKey2 = listView.key;
      listViewKey2 = listViewKey2.substring(listViewKey2.indexOf("_") + 1);
      RecordCase.requestRecordStep("点击表格:" + listViewKey2 + ":" + caption2 + ":" + (rowIndex + 1));
    }
    return await this.base.doOnCellClick(listView, rowIndex, colIndex);
  }
}
let last = "";
class DictViewHandlerRecord {
  static doOnFocusRowChange(dictView) {
    let ret = this.base.doOnFocusRowChange(dictView);
    if (AutoRecord.AutoRecord) {
      setTimeout(function() {
        let trElement = RecordCase.getCurrPage().querySelector("div.ui-dv tr.selected");
        let trEls = RecordCase.getCurrPage().querySelectorAll("div.ui-dv tr.row-item");
        let isExpand = trElement.getAttribute("class").indexOf("expanded") > -1;
        var array = [];
        do {
          var pid = trElement.getAttribute("pid");
          var text = trElement.innerText.trim();
          let id = trElement.getAttribute("id");
          let index2 = 1;
          for (let i2 = 0; i2 < trEls.length; i2++) {
            let txt = trEls[i2].innerText.trim();
            let trId = trEls[i2].getAttribute("id");
            if (txt == text && trId == id && index2 > 1) {
              text = text + "#" + index2;
              break;
            } else if (txt == text && trId !== id) {
              index2++;
            }
          }
          if (text.indexOf("\n") > -1) {
            text = text.replace("\n", " ");
          }
          array.push(text.indexOf("	") > -1 ? text.substring(0, text.indexOf("	")) : text);
          if (pid === null || pid.endsWith("_0"))
            break;
          trElement = document.getElementById(pid);
        } while (trElement.getAttribute("class").indexOf("root") === -1);
        var step = "选择:字典:";
        for (let i2 = array.length - 1; i2 >= 0; i2--) {
          step += i2 === 0 ? array[i2] : array[i2] + ",";
        }
        if (isExpand) {
          step += ":展开";
        }
        if (last != step) {
          RecordCase.requestRecordStep(step);
          last = step;
        }
      }, 200);
    }
    return ret;
  }
}
class TabPanelHandlerRecord {
  static doItemChanged(tabPanel) {
    let ret;
    let form2 = FormStack.getForm(tabPanel.ofFormID);
    if (DesignModeSetting.isDesignMode) {
      if (!form2)
        return;
      ret = form2.asyncEval(tabPanel.itemChanged);
    } else {
      ret = this.base.doItemChanged(tabPanel);
    }
    if (AutoRecord.AutoRecord) {
      let target = tabPanel.impl.selectedTab.vnode.elm;
      if (!target) {
        return ret;
      }
      const caption2 = target.innerText;
      const targetId = target.getAttribute("aria-controls");
      const tabKey = target.getAttribute("control-key");
      let tabsLiElms = RecordCase.getCurrPage().querySelectorAll("ul.ui-tabs-nav li:not([style*='display: none'])");
      let keyWordName = "选择:TAB页:";
      let index2 = 0;
      while (target.parentElement != void 0) {
        target = target.parentElement;
        if (target.getAttribute("class") == "vnode RightDesignPanelContainer designer") {
          keyWordName = "设计器选择:右侧TAB:";
          break;
        }
        if (target.getAttribute("class") == "mainLeft") {
          keyWordName = "设计器选择:左侧TAB:";
          break;
        }
      }
      for (let i2 = 0; i2 < tabsLiElms.length; i2++) {
        let tabId = tabsLiElms[i2].getAttribute("aria-controls");
        let tabCaption = tabsLiElms[i2].innerText;
        if (tabCaption === caption2) {
          index2++;
        }
        if (targetId === tabId) {
          break;
        }
      }
      if (index2 > 1) {
        RecordCase.requestRecordStep(keyWordName + "[" + form2.formKey + "&NoGrid&" + tabKey + "[" + caption2 + "#" + index2 + "]]");
      } else {
        RecordCase.requestRecordStep(keyWordName + "[" + form2.formKey + "&NoGrid&" + tabKey + "[" + caption2 + "]]");
      }
    }
    return ret;
  }
}
class RTS_Record {
  static LoadRightsList(operatorID, roleID) {
    let data = this.base.LoadRightsList(operatorID, roleID);
    let currIframeDocument = RecordCase.getCurrPage().querySelectorAll("iframe")[0].contentDocument;
    currIframeDocument.querySelector(".rts-tbr").addEventListener("click", function(e) {
      let ele = e.toElement || e.target;
      let text = ele.innerText;
      if (AutoRecord.AutoRecord) {
        RecordCase.requestRecordStep("权限设置:操作:" + text);
        if (text === "修改") {
          addEventWithEntryRight(currIframeDocument);
          currIframeDocument.querySelectorAll(".tab-item.show .rts-dict-right tr td .checkbox").forEach((item) => {
            item.addEventListener("click", function(e2) {
              if (AutoRecord.AutoRecord) {
                var el = e2.toElement || e2.target;
                RecordCase.requestRecordStep("权限设置:字典权限:字典数据:" + getStr(el.parentElement.parentElement, currIframeDocument, "data") + ":" + el.checked);
              }
            });
          });
          currIframeDocument.querySelectorAll(".tab-item.show .rts-dict-right tr th .checkbox.all").forEach((item) => {
            item.addEventListener("click", function(e2) {
              if (AutoRecord.AutoRecord) {
                var el = e2.toElement || e2.target;
                RecordCase.requestRecordStep("权限设置:字典权限:字典数据:是否有权限" + el.checked);
              }
            });
          });
          currIframeDocument.querySelectorAll(".tab-item.show .rts-dict-right tr th .checkbox.emptyrt").forEach((item) => {
            item.addEventListener("click", function(e2) {
              if (AutoRecord.AutoRecord) {
                var el = e2.toElement || e2.target;
                RecordCase.requestRecordStep("权限设置:字典权限:字典数据:空值权限" + el.checked);
              }
            });
          });
          currIframeDocument.querySelectorAll(".tab-item.show .form .rts-form-opt tr td .checkbox").forEach((item) => {
            item.addEventListener("click", function(e2) {
              if (AutoRecord.AutoRecord) {
                var el = e2.toElement || e2.target;
                RecordCase.requestRecordStep("权限设置:表单权限:操作:" + getStr(el.parentElement.parentElement, currIframeDocument, "opt") + ":" + el.checked);
              }
            });
          });
          currIframeDocument.querySelectorAll(".tab-item.show .form .rts-form-opt tr th .checkbox.all").forEach((item) => {
            item.addEventListener("click", function(e2) {
              if (AutoRecord.AutoRecord) {
                var el = e2.toElement || e2.target;
                RecordCase.requestRecordStep("权限设置:表单权限:操作:是否有权限:" + el.checked);
              }
            });
          });
          currIframeDocument.querySelectorAll(".tab-item.show .form .rts-form-field tr td .checkbox").forEach((item) => {
            item.addEventListener("click", function(e2) {
              if (AutoRecord.AutoRecord) {
                var el = e2.toElement || e2.target;
                if (el.getAttribute("index") == void 0 || el.getAttribute("index") != "1") {
                  RecordCase.requestRecordStep("权限设置:表单权限:控件_是否可见:" + getStr(el.parentElement.parentElement, currIframeDocument, "field") + ":" + el.checked);
                } else {
                  RecordCase.requestRecordStep("权限设置:表单权限:控件_是否可编辑:" + getStr(el.parentElement.parentElement, currIframeDocument, "field") + ":" + el.checked);
                }
              }
            });
          });
          currIframeDocument.querySelectorAll(".tab-item.show .form .rts-form-field tr th .checkbox").forEach((item) => {
            item.addEventListener("click", function(e2) {
              if (AutoRecord.AutoRecord) {
                var el = e2.toElement || e2.target;
                if (el.getAttribute("index") == void 0 || el.getAttribute("index") != "1") {
                  RecordCase.requestRecordStep("权限设置:表单权限:控件_是否可见:全选:" + el.checked);
                } else {
                  RecordCase.requestRecordStep("权限设置:表单权限:控件_是否可编辑:全选:" + el.checked);
                }
              }
            });
          });
        }
      }
    });
    currIframeDocument.querySelectorAll(".rts-set ul.tab-ul li").forEach((item) => {
      item.addEventListener("click", function(e) {
        var el = e.toElement || e.target;
        if (AutoRecord.AutoRecord && el.innerText != void 0) {
          RecordCase.requestRecordStep("权限设置:选择:TAB页:" + el.innerText);
        }
      });
    });
    return data;
  }
  static async LoadEntryRightsData(operatorID, roleID) {
    let data = this.base.LoadEntryRightsData(operatorID, roleID);
    let tab_header = document.getElementsByClassName("tabs-header")[0], form_selected = tab_header.getElementsByClassName("aria-selected"), formId2 = form_selected[0].getAttribute("formid"), form2 = FormStack.getForm(formId2), value2 = await new DictCacheProxy(form2).getDictValue("Role", roleID, "Code"), currIframeDocument = RecordCase.getCurrPage().querySelectorAll("iframe")[0].contentDocument;
    if (AutoRecord.AutoRecord) {
      RecordCase.requestRecordStep("权限设置:选择:数据:" + value2);
    }
    let repeat = "";
    currIframeDocument.querySelectorAll(".entry-left .t-hdiv th .checkbox.all").forEach((item) => {
      item.addEventListener("click", function(event) {
        if (AutoRecord.AutoRecord) {
          let target = event.toElement || event.target;
          let content2 = "权限设置:入口权限:选择_菜单入口:全选:" + target.checked;
          if (content2 != repeat) {
            RecordCase.requestRecordStep(content2);
            repeat = content2;
          }
        }
      });
    });
    currIframeDocument.querySelectorAll(".entry-left .treetable td .checkbox").forEach((item) => {
      item.addEventListener("click", function(event) {
        if (AutoRecord.AutoRecord) {
          let target = event.toElement || event.target;
          let el = target.parentElement.parentElement, entryPath = getEntryPath(el, currIframeDocument), isChecked = target.getAttribute("chkstate") == "0", content2 = "权限设置:入口权限:选择_菜单入口:" + entryPath + ":" + isChecked;
          if (content2 != repeat) {
            RecordCase.requestRecordStep(content2);
            repeat = content2;
          }
        }
      });
    });
    currIframeDocument.querySelectorAll(".entry-left .treetable td").forEach((item) => {
      item.addEventListener("click", function(event) {
        if (AutoRecord.AutoRecord) {
          let target = event.toElement || event.target;
          let el = target.parentElement;
          if (el.tagName != "TR")
            return;
          let entryPath = getEntryPath(el, currIframeDocument), content2 = "权限设置:入口权限:点击_菜单入口:" + entryPath;
          if (content2 != repeat) {
            RecordCase.requestRecordStep(content2);
            repeat = content2;
          }
        }
        setTimeout(() => {
          addEventWithEntryRight(currIframeDocument);
        }, 500);
      });
    });
    currIframeDocument.querySelectorAll(".rts-dict-left .treetable td").forEach((item) => {
      item.addEventListener("click", function(event) {
        if (AutoRecord.AutoRecord) {
          let target = event.toElement || event.target;
          let el = target.parentElement;
          if (el.tagName != "TR")
            return;
          let content2 = "权限设置:字典权限:字典:" + el.getAttribute("key");
          if (content2 != repeat) {
            RecordCase.requestRecordStep(content2);
            repeat = content2;
          }
          RecordCase.requestRecordStep(content2);
        }
      });
    });
    currIframeDocument.querySelectorAll(".rts-form-left .treetable td").forEach((item) => {
      item.addEventListener("click", function(event) {
        if (AutoRecord.AutoRecord) {
          let target = event.toElement || event.target;
          let el = target.parentElement;
          if (el.tagName != "TR")
            return;
          let content2 = "权限设置:表单权限:表单:" + el.getAttribute("key");
          if (content2 != repeat) {
            RecordCase.requestRecordStep(content2);
            repeat = content2;
          }
          RecordCase.requestRecordStep(content2);
        }
      });
    });
    return data;
  }
}
let repeatEntry = "";
let addEventWithEntryRight = function(currIframeDocument) {
  currIframeDocument.querySelectorAll(".tab-item.show .rts-entry .rts-form-opt tr td .checkbox").forEach((item) => {
    item.addEventListener("click", function(e) {
      if (AutoRecord.AutoRecord) {
        var el = e.toElement || e.target;
        let content2 = "权限设置:入口权限:操作:" + getStr(el.parentElement.parentElement, currIframeDocument, "opt") + ":" + el.checked;
        if (content2 != repeatEntry) {
          RecordCase.requestRecordStep(content2);
          repeatEntry = content2;
        }
      }
    });
  });
  currIframeDocument.querySelectorAll(".tab-item.show .rts-entry .rts-form-opt tr th .checkbox.all").forEach((item) => {
    item.addEventListener("click", function(e) {
      if (AutoRecord.AutoRecord) {
        var el = e.toElement || e.target;
        let content2 = "权限设置:入口权限:操作:是否有权限:" + el.checked;
        if (content2 != repeatEntry) {
          RecordCase.requestRecordStep(content2);
          repeatEntry = content2;
        }
      }
    });
  });
  currIframeDocument.querySelectorAll(".tab-item.show .rts-entry .rts-form-field tr td .checkbox").forEach((item) => {
    item.addEventListener("click", function(e) {
      if (AutoRecord.AutoRecord) {
        var el = e.toElement || e.target;
        let content2;
        let field = getStr(el.parentElement.parentElement, currIframeDocument, "field");
        if (el.getAttribute("index") == void 0 || el.getAttribute("index") != "1") {
          content2 = "权限设置:入口权限:控件_是否可见:" + field + ":" + el.checked;
        } else {
          content2 = "权限设置:入口权限:控件_是否可编辑:" + field + ":" + el.checked;
        }
        if (content2 != repeatEntry) {
          RecordCase.requestRecordStep(content2);
          repeatEntry = content2;
        }
      }
    });
  });
  currIframeDocument.querySelectorAll(".tab-item.show .rts-entry .rts-form-field tr th .checkbox").forEach((item) => {
    item.addEventListener("click", function(e) {
      if (AutoRecord.AutoRecord) {
        var el = e.toElement || e.target;
        let content2;
        if (el.getAttribute("index") == void 0 || el.getAttribute("index") != "1") {
          content2 = "权限设置:入口权限:控件_是否可见:全选:" + el.checked;
        } else {
          content2 = "权限设置:入口权限:控件_是否可编辑:全选:" + el.checked;
        }
        if (content2 != repeatEntry) {
          RecordCase.requestRecordStep(content2);
          repeatEntry = content2;
        }
      }
    });
  });
};
let getEntryPath = function(e, currIframeDocument) {
  var entryPath = "", entryKey, currEntryKey = e.getAttribute("key"), entrys = currEntryKey.split("/");
  for (var i2 = 1; i2 < entrys.length; i2++) {
    if (entryPath == "") {
      entryPath = currIframeDocument.getElementById(entrys[i2 - 1] + "_" + entrys[i2]).innerText.trim();
    } else {
      entryKey = "";
      for (var j2 = 0; j2 <= i2; j2++) {
        if (entryKey == "") {
          entryKey = entrys[j2];
        } else {
          entryKey = entryKey + "_" + entrys[j2];
        }
      }
      entryPath = entryPath + "," + currIframeDocument.getElementById(entryKey).innerText.trim();
    }
  }
  return entryPath;
};
let getStr = function(e, currIframeDocument, type2) {
  if (type2 == "opt" || type2 == "field") {
    var id = e.getAttribute("id");
    if (e.getAttribute("pid") == void 0) {
      return id;
    } else {
      return getStr(currIframeDocument.getElementById(e.getAttribute("pid")), currIframeDocument, type2) + "," + id;
    }
  } else if (type2 == "data") {
    if (e.getAttribute("pid") == void 0) {
      return e.getElementsByTagName("td")[0].innerText.trim();
    } else {
      return getStr(currIframeDocument.getElementById(e.getAttribute("pid")), currIframeDocument, type2) + "," + e.getElementsByTagName("td")[0].innerText.trim();
    }
  }
};
class RecordExtend {
  // 拓展
  static addExtend() {
    extend(MetaService, RecordMenus);
    extend(UICalcProcess, InputValue);
    extend(FormBuilder, ClickX);
    extend(ButtonHandler, ButtonClick);
    extend(ToolBarHandler, ToolBarOpt);
    extend(Errordialog, ErrorDialogOpt);
    extend(GridHandler, GridHandlerRecord);
    extend(ListViewHandler, ListViewHandlerRecord);
    extend(DictViewHandler, DictViewHandlerRecord);
    extend(TabPanelHandler, TabPanelHandlerRecord);
    extend(RTS_Service, RTS_Record);
  }
}
class AutoRecord {
  //是否添加录制代码
  static initAutoRecordNavigation(navRight) {
    var html = "<div id='startRecord' style='float: left;width: 65px;'>" + I18N.getString("STARTRECORD", "开始录制") + "</div><div id='stopRecord' style='float: left;width: 65px;'>" + I18N.getString("STOPRECORD", "停止录制") + "</div><div id='isRecordCheck' style='float: left;width: 65px;'>" + I18N.getString("ISRECORDCHECK", "录制选择") + "</div><div id ='designerPromptBox' style='float: left;width: 75px;'><div id='designerPrompt'>" + I18N.getString("DESIGNERPROMPT", "设计器提示框") + "</div><div id ='designerPromptlist' style='position: absolute;top: 48px;right: 370px;display: none; z-index: 999;white-space: nowrap;'><ul class='nav-field-list'><li class='nav-field-items' style='font-size:12px' id='topPrompt'>" + I18N.getString("TOPPROMPT", "顶部提示框") + "</li><li class='nav-field-items' style='font-size:12px' id='centralPrompt'>" + I18N.getString("CENTRALPROMPT", "中部提示框") + "</li></ul></div></div><div id ='designercheckBox' style='float: left;width: 75px;'><div id='designercheck'>" + I18N.getString("DESIGNERCHECK", "设计器查看") + "</div><div id ='designerchecklist' style='position: absolute;top: 48px;right: 300px;display: none; z-index: 999;white-space: nowrap;'><ul class='nav-field-list'><li class='nav-field-items' style='font-size:12px' id='checkSubAtt'>" + I18N.getString("VERSUBOPT", "组件属性") + "</li></ul></div></div><div id ='designerSelectBox' style='float: left;width: 75px;'><div id='designerSelect'>" + I18N.getString("DESIGNERSELECT", "设计器选择") + "</div><div id ='designerSelectlist' style='position: absolute;top: 48px;right: 218px;display: none; z-index: 999;white-space: nowrap;'><ul class='nav-field-list'><li class='nav-field-items' style='font-size:12px' id='selectNodeTree'>" + I18N.getString("SELECTNODETREE", "选择节点树") + "</li><li class='nav-field-items' style='font-size:12px' id='selectFileTree'>" + I18N.getString("SELECTFILETREE", "选择文件树") + "</li></ul></div></div><div id ='checkdatabox' style='float: left;width: 40px;'><div id='checkData'>" + I18N.getString("CHECKDATA", "查看") + "</div><div id ='checkdatalist' style='position: absolute;top: 48px;right: 165px;display: none; z-index: 999;white-space: nowrap;'><ul class='nav-field-list'><li class='nav-field-items' style='font-size:12px' id='checkGrid'>" + I18N.getString("CHECKGRID", "表格") + "</li><li class='nav-field-items' style='font-size:12px' id='checkNonGrid'>" + I18N.getString("CHECKNONGRID", "非表格") + "</li><li class='nav-field-items' style='font-size:12px' id='checkGridRow'>" + I18N.getString("CHECKGRIDROW", "表格行") + "</li><li class='nav-field-items' style='font-size:12px' id='checkDictView'>" + I18N.getString("CHECKDICTVIEW", "字典树") + "</li><li class='nav-field-items' style='font-size:12px' id='checkAllGridRow'>" + I18N.getString("CHECKALLGRIDROW", "表格行数") + "</li><li class='nav-field-items' style='font-size:12px' id='checkHistoryRecords'>" + I18N.getString("CHECKHISTORYRECORDS", "历史记录") + "</li><li class='nav-field-items' style='font-size:12px' id='checkGridSearch'>" + I18N.getString("CHECKGRIDSEARCH", "表格搜索") + "</li><li class='nav-field-items' style='font-size:12px' id='checkLongText'>" + I18N.getString("CHECKLONGTEXT", "长文本") + "</li><li class='nav-field-items' style='font-size:12px' id='checkGridPartData'>" + I18N.getString("CHECKGRIDPARTDATA", "表格部分数据") + "</li><li class='nav-field-items' style='font-size:12px' id='currentPage'>" + I18N.getString("CURRENTPAGE", "当前界面") + "</li></ul></div></div><div id ='checkcontrolbox' style='float: left;width: 40px;'><div id='checkControl'>" + I18N.getString("CHECKCONTROL", "验证") + "</div><div id ='checkcontrollist' style='position: absolute;top: 48px;right: 90px;display: none; z-index: 999;white-space: nowrap;'><ul class='nav-field-list'><li class='nav-field-items' style='font-size:12px' id='optVisible'>" + I18N.getString("OPTVISIBLE", "操作可见性") + "</li><li class='nav-field-items' style='font-size:12px' id='optEnable'>" + I18N.getString("OPTENABLE", "操作可用性") + "</li><li class='nav-field-items' style='font-size:12px' id='fields'>" + I18N.getString("FIELDS", "可见字段") + "</li><li class='nav-field-items' style='font-size:12px' id='fieldEnable'>" + I18N.getString("FIELDENABLE", "字段可用性") + "</li><li class='nav-field-items' style='font-size:12px' id='columns'>" + I18N.getString("COLUMNS", "可见表格列") + "</li><li class='nav-field-items' style='font-size:12px' id='checkRule'>" + I18N.getString("CHECKRULE", "检查公式") + "</li><li class='nav-field-items' style='font-size:12px' id='spelLing'>" + I18N.getString("SPELLING", "检查单元格提示信息") + "</li><li class='nav-field-items' style='font-size:12px' id='cellEnable'>" + I18N.getString("CELLENABLE", "单元格可用性") + "</li><li class='nav-field-items' style='font-size:12px' id='cellStyle'>" + I18N.getString("CELLSTYLE", "单元格样式") + "</li><li class='nav-field-items' style='font-size:12px' id='tabs'>" + I18N.getString("TABS", "可见Tab页") + "</li><li class='nav-field-items' style='font-size:12px' id='dictDataStatus'>" + I18N.getString("DICTDATASTATUS", "字典状态") + "</li><li class='nav-field-items' style='font-size:12px' id='dictDropValues'>" + I18N.getString("DICTDROPVALUES", "字典下拉框") + "</li><li class='nav-field-items' style='font-size:12px' id='comboBoxDropValues'>" + I18N.getString("COMBOBOXDROPVALUES", "下拉框") + "</li><li class='nav-field-items' style='font-size:12px' id='columnWidth'>" + I18N.getString("COLUMNWIDTH", "列宽") + "</li><li class='nav-field-items' style='font-size:12px' id='menu'>" + I18N.getString("MENU", "菜单") + "</li><li class='nav-field-items' style='font-size:12px' id='dicTrace'>" + I18N.getString("DICTRACE", "字典追溯") + "</li><li class='nav-field-items' style='font-size:12px' id='enterPermission'>" + I18N.getString("ENTERPERMISSION", "入口权限") + "</li><li class='nav-field-items' style='font-size:12px' id='formPermission'>" + I18N.getString("FORMPERMISSION", "表单权限") + "</li><li class='nav-field-items' style='font-size:12px' id='dictPermission'>" + I18N.getString("DICTPERMISSION", "字典权限") + "</li><li class='nav-field-items' style='font-size:12px' id='dictPermissionData'>" + I18N.getString("DICTPERMISSIONDATA", "字典权限-数据") + "</li><li class='nav-field-items' style='font-size:12px' id='formPermissionData'>" + I18N.getString("FORMPERMISSIONDATA", "表单权限-数据") + "</li></ul></div></div><div id ='designerVerBox' style='float: left;width: 75px;'><div id='designerVer'>" + I18N.getString("DESIGNERVER", "设计器验证") + "</div><div id ='designerVerlist' style='position: absolute;top: 48px;right: 45px;display: none; z-index: 999;white-space: nowrap;'><ul class='nav-field-list'><li class='nav-field-items' style='font-size:12px' id='verSubOpt'>" + I18N.getString("VERSUBOPT", "组件操作可用性") + "</li><li class='nav-field-items' style='font-size:12px' id='verSourceCodeTab'>" + I18N.getString("VERSOURCECODETAB", "源码tab页") + "</li><li class='nav-field-items' style='font-size:12px' id='verNodeTreeCaption'>" + I18N.getString("VERNODETREECAPTION", "节点树标题") + "</li><li class='nav-field-items' style='font-size:12px' id='verNoDateSource'>" + I18N.getString("VERNODATESOURCE", "数据源空白") + "</li><li class='nav-field-items' style='font-size:12px' id='verSubAttrUsability'>" + I18N.getString("VERSUBATTRUSABILITY", "组件属性可用性") + "</li><li class='nav-field-items' style='font-size:12px' id='verColUsability'>" + I18N.getString("VERCOLUSABILITY", "表格列可编辑性") + "</li><li class='nav-field-items' style='font-size:12px' id='verColLocation'>" + I18N.getString("VERCOLLOCATION", "列位置") + "</li><li class='nav-field-items' style='font-size:12px' id='verFieldLocation'>" + I18N.getString("VERFIELDLOCATION", "控件位置") + "</li><li class='nav-field-items' style='font-size:12px' id='verGroupButton'>" + I18N.getString("VERGROUPBUTTON", "收缩按钮") + "</li><li class='nav-field-items' style='font-size:12px' id='verCtrlDot'>" + I18N.getString("VERCTRLDOT", "控制点类型") + "</li><li class='nav-field-items' style='font-size:12px' id='verSubExist'>" + I18N.getString("VERSUBEXIST", "组件存在性") + "</li><li class='nav-field-items' style='font-size:12px' id='verPrintTableRowAndCol'>" + I18N.getString("VERPRINTTABLEROWANDCOL", "打印模板行列") + "</li><li class='nav-field-items' style='font-size:12px' id='verGridPanelRowAndColNum'>" + I18N.getString("VERGRIDPANELROWANDCOLNUM", "网格行列数") + "</li><li class='nav-field-items' style='font-size:12px' id='verToolTip'>" + I18N.getString("VERTOOLTIP", "公式描述") + "</li><li class='nav-field-items' style='font-size:12px' id='verConnectLineExist'>" + I18N.getString("VERCONNECTLINEEXIST", "连接线存在性") + "</li><li class='nav-field-items' style='font-size:12px' id='verConnectLineColor'>" + I18N.getString("VERCONNECTLINECOLOR", "连接线颜色") + "</li><li class='nav-field-items' style='font-size:12px' id='verBoardAttrUsability'>" + I18N.getString("VERBOARDATTRUSABILITY", "画板属性可编辑性") + "</li><li class='nav-field-items' style='font-size:12px' id='verBoardAttrExist'>" + I18N.getString("VERBOARDATTREXIST", "画板属性存在性") + "</li><li class='nav-field-items' style='font-size:12px' id='verBoardAttrCmb'>" + I18N.getString("VERBOARDATTRCMD", "画板属性下拉框") + "</li><li class='nav-field-items' style='font-size:12px' id='verConstCanAdd'>" + I18N.getString("VERCONSTCANADD", "公式常量是否可添加") + "</li><li class='nav-field-items' style='font-size:12px' id='verDataFieldExit'>" + I18N.getString("VERDATAFIELDEXIT", "数据字段存在性") + "</li><li class='nav-field-items' style='font-size:12px' id='verBPMNodeState'>" + I18N.getString("VERBPMNODESTATE", "工作流节点状态") + "</li><li class='nav-field-items' style='font-size:12px' id='verBPMNodeVisibility'>" + I18N.getString("VERBPMNODEVISIBILITY", "工作流节点可见性") + "</li></ul></div></div><div id='caseManage' style='float: left;width: 65px;'>" + I18N.getString("CASEMANAGE", "用例管理") + "</div>";
    var div = document.createElement("div");
    div.id = "autorecord";
    div.setAttribute("style", "height:50px;float: left;position: relative;color:#fff;line-height: 50px;text-align:center;");
    div.innerHTML = html;
    navRight.insertBefore(div, navRight.firstChild);
    document.querySelectorAll("#autorecord ul li").forEach(function(item) {
      item.style.color = "#333";
    });
    let startRecord = document.querySelector("#startRecord");
    let stopRecord = document.querySelector("#stopRecord");
    if (AutoRecord.AutoRecord == true) {
      startRecord.style.color = "red";
      stopRecord.style.color = "#fff";
    } else if (AutoRecord.AutoRecord == false) {
      startRecord.style.color = "#fff";
      stopRecord.style.color = "red";
    }
  }
  static async init() {
    try {
      var paras = {
        service: "AutoRecord",
        cmd: "GetAutoRecode"
      };
      var records = (await new Request().getData(paras)).split(",");
      AutoRecord.sys_record = records[0];
      AutoRecord.AutoRecord = records[1] === "true";
      if (AutoRecord.sys_record == "true") {
        DOMUtil.waitForElementsReady(".nav .nav-right", (elems) => {
          AutoRecord.initAutoRecordNavigation(elems[0]);
          RecordCase.addListening();
          ClickX.addRecordListening();
          CheckControl.addListening();
          CheckData.addListening();
          DesignVerify.addListening();
        });
        RecordExtend.addExtend();
        Polling.addPolling();
        ShortcutKey.addShortcutKey();
        AutoRecord.ISUE = AutoRecord.getIsUe();
      }
    } catch (e) {
      console.log(e);
    }
  }
  static getIsUe() {
    return true;
  }
}
class ToolBarExt extends ToolBar {
  calcAutoHeight() {
    return this.getEl() ? this.getEl().getHeight() : 36;
  }
}
class ToolBarBuilderExt extends ToolBarBuilder {
  create(meta) {
    return new ToolBarExt(meta);
  }
}
class GridLayoutPanelBuilderExt extends GridLayoutPanelBuilder {
  create(meta) {
    return new GridLayoutPanel(meta);
  }
}
class TabPanelExt extends TabPanel {
  constructor(meta) {
    super(meta);
  }
  doItemChanged() {
    const result = super.doItemChanged();
    this.reLayout();
    return result;
  }
  calcAutoHeight() {
    const activeTab = this.layout ? this.layout.activeTab : 0;
    return 30 + (activeTab >= 0 ? this.items[activeTab].calcAutoHeight() : 0);
  }
}
class TabPanelBuilderExt extends TabPanelBuilder {
  create(meta) {
    return new TabPanelExt(meta);
  }
}
CompBuilder.reg(ControlType.DICTVIEW, new DictViewBuilder());
CompBuilder.reg(ControlType.DICT, new DictBuilder());
CompBuilder.reg(ControlType.DYNAMICDICT, new DynamicDictBuilder());
CompBuilder.reg(ControlType.GRIDLAYOUTPANEL, new GridLayoutPanelBuilderExt());
CompBuilder.reg(ControlType.TABPANEL, new TabPanelBuilderExt());
CompBuilder.reg(ControlType.TOOLBAR, new ToolBarBuilderExt());
class TrRequestManager {
  static getSelectRequestMacroName(form2) {
    if (!form2.saveData2TRFormItems) {
      return false;
    }
    return form2.saveData2TRFormItems.selectRequestMacroName;
  }
  static getEnableTransMacro(form2) {
    if (!form2.saveData2TRFormItems) {
      return false;
    }
    return form2.saveData2TRFormItems.enableTransMacroName;
  }
  static isBackendConfigure(form2) {
    if (!form2.saveData2TRFormItems) {
      return false;
    }
    return form2.saveData2TRFormItems.isBackendConfigure;
  }
  static isSaveData2TROpt(form2, optKey) {
    if (!form2.saveData2TRFormItems || !form2.saveData2TRFormItems.operations) {
      return false;
    }
    return form2.saveData2TRFormItems.operations[optKey];
  }
  static async isSaveData2TR(form2, item) {
    const marcoName = this.getEnableTransMacro(form2);
    if (!marcoName) {
      return false;
    }
    const isEnableTrans = await form2.asyncEval(`${marcoName}()`);
    if (!isEnableTrans) {
      return false;
    }
    const optKey = item.key;
    if (!this.isBackendConfigure(form2) || !this.isSaveData2TROpt(form2, optKey)) {
      return false;
    }
    const hasTRRequestID = this.hasTRRequestPara(form2, this.TrRequestSettings.TRREQUESTID_PARA_KEY);
    return !hasTRRequestID;
  }
  static async showSelectTRRequestForm(form2, item) {
    const marcoName = this.getSelectRequestMacroName(form2);
    if (!marcoName) {
      return;
    }
    const action = item.action;
    const showTr = `${marcoName}("${action}")`;
    return showTr;
  }
  static hasTRRequestPara(form2, key2) {
    if (!form2) {
      return false;
    }
    let value2 = form2.getPara(key2);
    if (value2 == null && form2.getParentForm()) {
      value2 = form2.getParentForm().getPara(key2);
    }
    if (value2 == null) {
      const hasGlobalRequest = SessionParasCache.get(key2);
      return !!hasGlobalRequest;
    }
    return true;
  }
}
TrRequestManager.TrRequestSettings = {
  TRREQUESTID_PARA_KEY: "TRRequestID"
};
class TrRequestManagerToolbarItemProcessor {
  async processAction(form2, item) {
    let action;
    let isSaveData2TR = await TrRequestManager.isSaveData2TR(form2, item);
    if (isSaveData2TR) {
      action = await TrRequestManager.showSelectTRRequestForm(form2, item);
    } else {
      action = item.action;
    }
    return action;
  }
}
InplaceToolbarItemAction.setImpl(new TrRequestManagerToolbarItemProcessor());
class ERPBusinessLock {
  static async UnLock(form2, doc) {
    await this.lockRequest(form2, doc, "UnLock");
  }
  static async UnAllLock() {
    return await ERPBusinessLock.UnAllLockRequest();
  }
  static async UnAllLockRequest() {
    let activeForm = FormStack.getActiveForm();
    if (activeForm) {
      var paras = {
        service: "ERPBusinessLock",
        cmd: "ERPBusinessLock",
        metaFormKey: activeForm.formKey,
        methodName: "UnLock"
      };
      return await new Request(activeForm).getData(paras);
    }
  }
  static async AddLock(form2, doc) {
    await this.lockRequest(form2, doc, "AddLock");
  }
  static async lockRequest(form2, doc, methodName) {
    if (!doc) {
      return;
    }
    doc = DataUtil.toJSONDoc(doc);
    const formKey = form2.getFormKey();
    if (formKey.indexOf("Cond_") == 0 || formKey.endsWith("_Browser") || formKey.indexOf("Cond") == formKey.length - 4) {
      return;
    }
    const topForm = form2.getTopForm();
    const formUUID = topForm.getFormUUID();
    const paras = {
      service: "ERPBusinessLock",
      cmd: "ERPBusinessLock",
      metaFormKey: formKey,
      methodName,
      formUUID
    };
    if (methodName == "AddLock") {
      paras.document = JSON.stringify(doc);
    }
    await new Request(form2).getData(paras);
  }
  static async CheckDocVerAndAddLock(form2, doc) {
    const parameters = form2.getParas();
    const filterMap = form2.filterMap;
    const paras = {
      service: "RichDocument",
      cmd: "RichDocumentCheckDocVerAndAddLock",
      metaFormKey: form2.getFormKey(),
      document: JSON.stringify(doc),
      filterMap: JSON.stringify(filterMap)
    };
    if (parameters) {
      paras.parameters = parameters.toJSON();
    }
    const result = await new Request(form2).getData(paras);
    if (result && result != "null") {
      await UIScopeTrees.processRichDocumentResult(form2, result);
    }
  }
}
let paraDefinesCache;
class ParasExt {
  static async getParaDefines(form2) {
    const paraDefines = paraDefinesCache;
    if (!paraDefines) {
      const formKey = form2.getFormKey();
      const result = await new RichDocService(form2).buildParaDefines(formKey);
      paraDefinesCache = result;
    }
  }
  static async checkScope(form2, paraKey) {
    if (!paraDefinesCache) {
      await this.getParaDefines(form2);
    }
    if (!paraDefinesCache.check) {
      return true;
    }
    const annotation = paraDefinesCache[paraKey];
    if (!annotation && !paraDefinesCache.checkNotExists) {
      return true;
    }
    const formProjectKey = form2.getProjectKey();
    if (!paraDefinesCache.checkAllConfig.includes(formProjectKey)) {
      return true;
    }
    if (!annotation) {
      throw new Error("Yigo-ERP产品中未定义" + paraKey + "的Para参数，请检查！");
    }
    const projectKey = annotation.ParaScope;
    if (projectKey == "") {
      return true;
    }
    if (projectKey == formProjectKey) {
      return true;
    }
    throw new Error(
      "Yigo-ERP产品中定义" + paraKey + "的Para参数仅在" + projectKey + "模块表单使用，不能在" + formProjectKey + "模块表单使用，请检查！"
    );
  }
  static async checkParaType(form2, paraKey, paraValue) {
    if (!paraValue) {
      return true;
    }
    if (!paraDefinesCache) {
      await this.getParaDefines(form2);
    }
    if (!paraDefinesCache.check) {
      return true;
    }
    const annotation = paraDefinesCache[paraKey];
    if (!annotation && !paraDefinesCache.checkNotExists) {
      return true;
    }
    const formProjectKey = form2.getProjectKey();
    if (!paraDefinesCache.checkAllConfig.includes(formProjectKey)) {
      return true;
    }
    if (!annotation) {
      throw new Error("Yigo-ERP产品中未定义" + paraKey + "的Para参数，请检查！");
    }
    const valueType = typeof paraValue;
    const type2 = annotation.type;
    const scope = annotation.ParaScope == "" ? "全局" : annotation.ParaScope;
    switch (type2) {
      case "Integer":
        if (valueType != "number") {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是Integer，请检查!");
        }
        break;
      case "Varchar":
        if (valueType != "string") {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是String，请检查!");
        }
        break;
      case "Date":
        if (valueType != "object") {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是Date，请检查!");
        }
        break;
      case "DateTime":
        if (valueType != "object") {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是Date，请检查!");
        }
        break;
      case "Numeric":
        if (valueType != "object" && paraValue instanceof Decimal) {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是BigDecimal，请检查!");
        }
        break;
      case "Boolean":
        if (valueType != "boolean") {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是Boolean，请检查!");
        }
        break;
      case "Long":
        if (valueType != "number") {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是Long，请检查!");
        }
        break;
      case "SqlString":
        if (valueType != "string" || !paraValue.startsWith("MARK(") && !paraValue.endsWith(")MARK")) {
          throw new Error("定义Para参数" + paraKey + "(" + scope + ")的对应的值类型应该是SqlString，请检查!");
        }
        break;
      case "Object":
        break;
      default:
        throw new Error("定义Para参数" + paraKey + "的对应的值类型系统不支持，请检查!");
    }
  }
}
class HistorySetting {
  static async reloadHistorySetting(form2) {
    HistorySetting.settings = null;
    return HistorySetting.loadSetting(form2);
  }
  static async loadSetting(form2) {
    if (HistorySetting.settings) {
      return HistorySetting.settings;
    }
    const params = {
      cmd: "GetHistorySetting",
      service: "OperatorService"
    };
    let result = {
      maxMatchCount: 10,
      enable: true,
      maxItemCount: 200,
      minItemLength: 1,
      maxItemLength: 255,
      fireLength: 0
    };
    try {
      result = await new Request(form2).getData(params);
    } catch (error) {
      console.error(error);
    }
    HistorySetting.settings = result;
    return HistorySetting.settings;
  }
}
let _SetPara = FuncMap.getFun("SetPara");
const SetPara = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, key2 = args[0], value2 = args[1];
  const check = args[2];
  if (!form2) {
    _SetPara(evl, name2, cxt, args);
    return value2;
  }
  if (!(check === false)) {
    await ParasExt.checkScope(form2, key2);
    await ParasExt.checkParaType(form2, key2, value2);
  }
  _SetPara(evl, "SetPara", cxt, args);
  return value2;
};
const GetPara = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  if (form2 == null) {
    return "";
  }
  const key2 = args[0], check = args[1];
  if (!(check === false)) {
    await ParasExt.checkScope(form2, key2);
  }
  const value2 = form2.getPara(key2);
  if (!(check === false)) {
    await ParasExt.checkParaType(form2, key2, value2);
  }
  return value2;
};
const ReLoadHistorySetting = function(evl, name2, cxt, args) {
  return HistorySetting.reloadHistorySetting(null);
};
const UIFunExt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  GetPara,
  ReLoadHistorySetting,
  SetPara
}, Symbol.toStringTag, { value: "Module" }));
let debugMode = false;
AppSetting.registerClientSettingsListener("erp.formula.debugMode", (key2, value2) => {
  debugMode = value2;
});
let GetValue = FuncMap.getFun("GetValue");
let GetSessionPara = FuncMap.getFun("GetSessionPara");
let InvokeService = FuncMap.getFun("InvokeService");
let GetCellValue = FuncMap.getFun("GetCellValue");
let Confirm$1 = FuncMap.getFun("Confirm");
let GetRowCount = FuncMap.getFun("GetRowCount");
let RemovePara = FuncMap.getFun("RemovePara");
const GetFocusFieldKey = async (evl, name2, cxt, args) => {
  var fieldKey = cxt.form.currentFocusedKey;
  if (!fieldKey) {
    const fo = cxt.form.getFocusManager().getFocusOwner();
    fieldKey = fo && fo.key || "";
  }
  await SetPara(evl, "SetPara", cxt, ["fieldKey", fieldKey]);
};
const GetAndRemovePara = async (evl, name2, cxt, args) => {
  const v = GetPara(evl, name2, cxt, args);
  const key2 = args[0];
  await RemovePara(evl, "RemovePara", cxt, key2);
  return v;
};
const GetEntryPara = async (evl, name2, cxt, args) => {
  const key2 = args[0];
  return await GetPara(evl, "GetPara", cxt, [key2, false]);
};
const SetEntryPara = async (evl, name2, cxt, args) => {
  cxt.form;
  const key2 = args[0], value2 = args[1];
  await SetPara(evl, "SetPara", cxt, [key2, value2, false]);
  return value2;
};
const ERPOpenForm = (evl, name2, cxt, args) => {
  return ERPShowModal(evl, name2, cxt, args);
};
const ERPShowModal = async (evl, name2, cxt, args) => {
  var _a, _b;
  const pForm = cxt.form;
  var metaForm, formKey;
  var meta = args[0];
  if (typeof meta == "object") {
    try {
      metaForm = new MetaForm(meta);
      formKey = metaForm.formKey;
    } catch (e) {
      throw FORM_SERIALIZATION_ERROR();
    }
  } else {
    formKey = args[0];
  }
  pForm.willShow();
  if (!pForm.rendered && !(((_b = (_a = pForm.getContainer()) == null ? void 0 : _a.meta) == null ? void 0 : _b.style) == ContainerStyle.TAB)) {
    pForm.setWillShow(true);
  }
  let onLoad;
  if (args.length > 1 && args[1]) {
    onLoad = args[1];
  }
  let target = FormTarget.MODAL;
  if (DesignModeSetting.isDesignMode) {
    const formList = FormStack.getFormList();
    for (let i2 in formList) {
      if (formList[i2].formKey === formKey) {
        return;
      }
    }
    if (!pForm.rendered) {
      await ERPDESIGNER.UI.reloadForm(pForm);
    }
    target = FormTarget.NEWTAB;
  }
  if (args.length > 2 && args[2] != "") {
    target = FormTarget.parse(args[2]);
  }
  let operationState = OperationState.DEFAULT;
  if (args.length > 3 && args[3] != "") {
    operationState = OperationState.parse(args[3]);
  }
  if (pForm.getPara("DictItemKey")) {
    LoadingUtil.hide();
  }
  LoadingUtil.show(true);
  const container = pForm.getContainer();
  const builder = new FormBuilder(formKey);
  builder.setContainer(container);
  builder.setParentForm(pForm);
  builder.setTarget(target);
  builder.setMateForm(metaForm);
  const emptyForm = await builder.newEmpty();
  FormParasUtil.processCallParas(pForm, emptyForm);
  var defaultTCode = await emptyForm.getDefaultTCode(pForm);
  emptyForm.TCode = defaultTCode || pForm.TCode;
  emptyForm.Activity = pForm.Activity || "03";
  if (onLoad) {
    const cxt1 = new ViewContext(emptyForm);
    emptyForm.regEvent("ERPOnLoad", async function(opt2) {
      emptyForm.setInitOperationState(operationState);
      emptyForm.setOperationState(operationState);
      await emptyForm.asyncEval(onLoad.trim(), cxt1);
    });
    await builder.build(emptyForm);
  } else {
    await builder.build(emptyForm);
  }
  LoadingUtil.hide();
  return true;
};
const ERPInvokeService = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const formula = TypeConvertor.toString(args[0]);
  await form2.refreshParas();
  const dirtyData = await new RichDocService(form2).richDocumentInvokeService(form2.formKey, form2.getDocument(), formula);
  UIScopeTrees.processRichDocumentResult(form2, dirtyData);
};
const EditBill = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  let checkUI = false;
  if (args && args.length == 1) {
    checkUI = args[0];
  }
  if (form2.operationState != OperationState.NEW) {
    if (form2.type == FormType.ENTITY) {
      const doc2 = form2.getDocument();
      await form2.refreshParas();
      await ERPBusinessLock.AddLock(form2, doc2);
    }
    let oldOperationState = form2.getOperationState();
    form2.setOperationState(OperationState.EDIT);
    await form2.checkDataAuthority("02");
    form2.setOperationState(oldOperationState);
    let isCalcEmptyRow = false;
    const gm = form2.getGridArray();
    for (let i2 = 0, size = gm.length; i2 < size; i2++) {
      const grid = form2.getComponent(gm[i2].key);
      const newEmptyRow = await grid.getNewEmptyRow();
      if (newEmptyRow) {
        isCalcEmptyRow = true;
        break;
      }
    }
    if (isCalcEmptyRow) {
      const dirty = await new RichDocService(form2).calcEmptyRowIndependGridsWithGridScope();
      await UIScopeTrees.processRichDocumentResult(form2, dirty);
    }
    const MASK = FormUIStatusMask.ENABLE | FormUIStatusMask.VISIBLE | FormUIStatusMask.OPERATION;
    const MASKCHECK = FormUIStatusMask.ENABLE | FormUIStatusMask.VISIBLE | FormUIStatusMask.OPERATION | FormUIStatusMask.CHECKRULE;
    form2.setInitOperationState(OperationState.EDIT);
    form2.setOperationState(OperationState.EDIT);
    await form2.resetUIStatus(checkUI ? MASKCHECK : MASK);
    const doc = form2.getDocument();
    if (doc != null) {
      doc.setModified();
    }
    form2.doInitFocus();
  }
  return true;
};
const ExistsVariable = (evl, name2, cxt, args) => {
  const form2 = cxt.form, key2 = args[0];
  return TrRequestManager.hasTRRequestPara(form2, key2);
};
const ERPRowExpand = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, type2 = args[0], fieldKey = args[1], expandSource = args[2];
  const paras = ["ERPRowExpandService", true, false, form2.formKey, type2, fieldKey, expandSource];
  const result = await InvokeService(evl, "InvokeService", cxt, paras);
  return result;
};
const IsBackMenu = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  return TrRequestManager.isBackendConfigure(form2);
};
const UIFuncWorkingPaper = async (evl, name2, cxt, args) => {
  const para = new Array();
  para.push("CourseID");
  const courseid = await GetValue("", name2, cxt, para);
  para.length = 0;
  para.push("CBWorkingPaperModelID");
  const CBWorkingPaperModelID = await GetValue(evl, "", cxt, para);
  para.length = 0;
  para.push("CBMergeGroupCondID");
  const CBMergeGroupCondID = await GetValue(evl, "", cxt, para);
  para.length = 0;
  para.push("CBINDEXUNITID");
  const CBINDEXUNITID = await GetValue(evl, "", cxt, para);
  para.length = 0;
  para.push("Grid1");
  const rowCount = await GetRowCount(evl, "", cxt, para);
  if (rowCount == 0) {
    await Confirm$1(evl, name2, cxt, "没有数据,无法生成!");
  }
  const paras = new Array();
  for (let i2 = 0; i2 < rowCount; i2++) {
    const obj = new Object();
    para.length = 0;
    para.push("Grid1");
    para.push(i2);
    para.push("CB_INDEX");
    const CB_INDEX = await GetCellValue(evl, "", cxt, para);
    obj.CB_INDEX = CB_INDEX;
    para.length = 0;
    para.push("Grid1");
    para.push(i2);
    para.push("sumValue");
    const sumValue = await GetCellValue(evl, "", cxt, para);
    obj.sumValue = sumValue;
    paras.push(obj);
  }
  const serParas = new Array();
  serParas.push("ServiceWorkingPaper");
  serParas.push(true);
  serParas.push(false);
  serParas.push(courseid);
  serParas.push(CBWorkingPaperModelID);
  serParas.push(CBMergeGroupCondID);
  serParas.push(CBINDEXUNITID);
  serParas.push(paras);
  await InvokeService(evl, "", cxt, serParas);
};
const ERPImportExcel = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  let fieldKey;
  let importServiceName = "";
  if (args.length > 0) {
    importServiceName = TypeConvertor.toString(args[0]);
  }
  if (args.length > 1) {
    fieldKey = TypeConvertor.toString(args[1]);
  }
  if (args.length > 2)
    ;
  let formKey = cxt.form.formKey;
  if (cxt.form.paras.get("FormKey")) {
    formKey = cxt.form.paras.get("FormKey");
  }
  const parameters = form2 != null ? form2.getParas() : null;
  const options = {
    clearOriginalData: false,
    importServiceName,
    formKey,
    service: "DTS",
    cmd: "ImportExcel",
    mode: 1,
    parameters: parameters.toJSON()
  };
  const success = async function(fileEl, data) {
    LoadingUtil.hide();
    if (!data) {
      return;
    }
    let fileName;
    const files = fileEl.files;
    fileName = "";
    for (let index2 = 0; index2 < files.length; index2++) {
      fileName = fileName + files[index2].name + ",";
    }
    fileName = fileName.substring(0, fileName.length - 1);
    if (fieldKey && fileName) {
      const cmp = form2.getComponent(fieldKey);
      if (cmp) {
        await form2.setComponentValue(fieldKey, fileName, true);
      }
    }
    const filePath = data.items.toString();
    await SetPara(evl, "SetPara", cxt, ["FilePath", filePath]);
  };
  const changeDef = async function(files) {
    LoadingUtil.show();
    try {
      const params = Object.assign({
        file: files
      }, options);
      const data = await new Request(form2).uploadFile(params);
      if (data) {
        await success(files, data);
      }
    } finally {
      LoadingUtil.hide();
    }
  };
  return new Promise((resolve) => {
    var fileCancle = true;
    if (!window.up_target) {
      window.uploadType = "";
      var inputFile = FileUtil.createFileInput(".xlm,.xlc,.xls,.xlt,.xlw,.xlsx,.xlsm,.xlsb,.xltx,.xltm,.xlam,.xla");
      inputFile.onchange = function() {
        fileCancle = false;
        document.getElementById("upload-frame").style.display = "none";
        changeDef(this).finally(
          () => {
            resolve(true);
          }
        );
      };
      window.addEventListener(
        "focus",
        function() {
          setTimeout(function() {
            if (fileCancle) {
              fileCancle = true;
              resolve("");
            }
          }, 100);
        }
      );
    } else {
      if (window.up_target.files[0]) {
        fileCancle = false;
        changeDef(window.up_target).finally(() => {
          resolve(true);
        });
      }
    }
  });
};
const ERPExportExcel = async (evl, name2, cxt, args) => {
  LoadingUtil.show();
  const isTask = args[0];
  const onlyCurrentPage = args[1];
  const useTemplate = args[2];
  const templateKey = args[3];
  const needDownload = !isTask;
  let exportTables;
  let exportFileName;
  let exportServiceName;
  let postExportServiceName;
  if (args.length > 4) {
    exportTables = TypeConvertor.toString(args[4]);
  }
  if (args.length > 5) {
    exportFileName = TypeConvertor.toString(args[5]);
  }
  if (args.length > 6) {
    exportServiceName = TypeConvertor.toString(args[6]);
  }
  if (args.length > 7) {
    postExportServiceName = TypeConvertor.toString(args[7]);
  }
  await new RichDocService(cxt.form).erpExportExcel(exportServiceName, postExportServiceName, templateKey, exportFileName, exportTables, needDownload, onlyCurrentPage, isTask, useTemplate);
  LoadingUtil.hide();
  return true;
};
const DoSearchGridData = async function(name2, cxt, args) {
  const form2 = cxt.form;
  const componentKey = args[0];
  const searchContent = args[1];
  const direction = args[2];
  let resultJson = args[3];
  const uiGrid = form2.getComponent(componentKey);
  if (uiGrid.type != ControlType.GRID)
    return;
  if (!uiGrid.el)
    return;
  if (!searchContent)
    return;
  if (!resultJson) {
    const rowCount = uiGrid.getRowCount();
    if (rowCount < 1)
      return;
    const columnCount = uiGrid.getColumnCount();
    const cells = [];
    for (let row2 = 0; row2 < rowCount; row2++) {
      let flag = false;
      const rowId = $.ygrid.uidPref + row2;
      const row1 = uiGrid.el.getGridRowById(rowId);
      for (let col2 = 0; col2 < columnCount; col2++) {
        const value2 = uiGrid.getCellDataAt(row2, col2)[1];
        const cell = row1.cells[col2 + 1];
        if (value2.indexOf(searchContent) > -1) {
          cells.push({ "row": row2, "col": col2 });
          $(cell).addClass("find-cell-style");
          flag = true;
        } else {
          $(cell).removeClass("find-cell-style");
          $(cell).removeClass("find-focusCell-style");
        }
      }
      if (flag) {
        $(row1).addClass("find-row-style");
      } else {
        $(row1).removeClass("find-row-style");
      }
    }
    resultJson = { "grid": componentKey, "content": searchContent, "pos": 0, "cells": cells };
    setFocusCellStyle("add");
  } else {
    let index2 = resultJson.pos;
    setFocusCellStyle("remove");
    if (direction == 1) {
      index2++;
    } else if (direction == -1) {
      index2--;
    } else {
      index2 = 0;
    }
    if (index2 < 0) {
      index2 = resultJson.cells.length - 1;
    }
    if (index2 >= resultJson.cells.length) {
      index2 = 0;
    }
    resultJson.pos = index2;
    setFocusCellStyle("add");
  }
  function setFocusCellStyle(type2) {
    const index2 = resultJson.pos;
    const row2 = resultJson.cells[index2].row;
    const col2 = resultJson.cells[index2].col;
    const rowId = $.ygrid.uidPref + row2;
    const row1 = uiGrid.el.getGridRowById(rowId);
    if (!$.isDefined(row1)) {
      return;
    }
    const col1 = row1.cells[col2 + 1];
    if (type2 == "add") {
      $(col1).addClass("find-focusCell-style");
      form2.setFocusCell(componentKey, row2, col2);
    } else if (type2 == "remove") {
      $(col1).removeClass("find-focusCell-style");
    }
  }
  return resultJson;
};
const IsERPForm = (evl, name2, cxt, args) => {
  return true;
};
const IsWeb = async (evl, name2, cxt, args) => {
  return true;
};
const GetBlurFilter = async (evl, name2, cxt, args) => {
  const filter = args[0];
  const sBlurFilter = filter ? filter.split(" ") : new Array();
  let sSQL = "";
  const sConnectSQL = "CONCAT(s0,'@#',s1)";
  for (let i2 = 0; i2 < sBlurFilter.length; i2++) {
    if (sBlurFilter[i2] != "") {
      const sBlurFilter0 = sBlurFilter[0];
      const sBlurFilteri = sBlurFilter[i2];
      if (i2 < 1) {
        sSQL += " where oid>0 and " + sConnectSQL + " like '%" + sBlurFilter0 + "%' ";
      }
      sSQL += " or " + sConnectSQL + " like '%" + sBlurFilteri + "%' ";
    }
  }
  return sSQL;
};
const CloseBeforeExpandLoadData = async (evl, name2, cxt, args) => {
};
const GetAnaCaption = async (evl, name2, cxt, args) => {
  const dicfieldKey = args[0].toLowerCase();
  const form2 = cxt.form;
  let dt = form2.getPara("AccountAnalysisSet");
  if (!dt || dt == null) {
    const SQL = "Select * from EFI_AccountAnalysisSet";
    const values = [];
    const paras = YesJSONUtil.toJSONArray(values);
    const params = {
      service: "DBQuery",
      cmd: "DBQuery",
      sql: SQL,
      paras: JSON.stringify(paras)
    };
    dt = await new Request(form2).getData(params);
    form2.setPara("AccountAnalysisSet", dt);
  }
  dt.beforeFirst();
  while (dt.next()) {
    if (dt.getByKey("RelationField").toLowerCase() == dicfieldKey) {
      return dt.getByKey("AnaCaption");
    }
  }
  return "";
};
const RefreshPanelAllHideRow = async (evl, name2, cxt, args) => {
};
const ShowLocateForm = async (evl, name2, cxt, args) => {
  OperationState.NEW;
  const target = FormTarget.MODAL;
  const container = cxt.form.getContainer();
  const form2 = cxt.form;
  let srcFormKey = form2.formKey;
  const gridKey = args[0];
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  const fieldKeys = args[1];
  const metaService = new MetaService(form2);
  const data = await metaService.getGridRowLocateMetaForm(srcFormKey, gridKey, fieldKeys);
  const meta = data.meta;
  let newDocDef;
  const _appEnv = form2.getAppEnv();
  const metaForm = new MetaForm(meta);
  const emptyForm = FormFactory.create(metaForm, _appEnv);
  emptyForm.isOKClose = true;
  emptyForm.LocateFormGridKey = gridKey;
  emptyForm.GridCellKeys = fieldKeys.split(",");
  emptyForm.GridCellKeys.forEach((fieldKey) => {
    const location = form2.getCellLocation(fieldKey);
    if (!location) {
      return COMPONENT_NOT_EXISTS(fieldKey);
    }
    emptyForm.setPara("ColumnCaption_" + fieldKey, GridUtil.getColumnCaptions(grid, fieldKey));
  });
  FormParasUtil.processCallParas(form2, emptyForm);
  const newDoc = newDocDef;
  const builder = new FormBuilder("LocateForm");
  builder.setContainer(container);
  builder.setTarget(target);
  builder.setParentForm(form2);
  var formulaScope = data.formulaScope;
  var result = {};
  if (formulaScope && formulaScope.fieldKey2Scope) {
    for (let i2 = 0; i2 < formulaScope.fieldKey2Scope.length; i2++) {
      const fieldKey = formulaScope.fieldKey2Scope[i2].fieldKey;
      const scope = formulaScope.fieldKey2Scope[i2].scope;
      result[fieldKey] = scope;
    }
    UIScopeTrees.scopeTrees[meta.key] = result;
    emptyForm.formulaScope = void 0;
    emptyForm.setFormulaScope(void 0);
  }
  await builder.build(emptyForm, newDoc);
};
const GetEmployeeID = async (evl, name2, cxt, args) => {
  const paraKey = "EmployeeID";
  const employeeID = await GetSessionPara(evl, "GetSessionPara", cxt, [paraKey]);
  return employeeID;
};
const SetResultValue = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const textKey = args[0];
  const resultJson = args[1];
  if (!resultJson)
    return;
  await form2.setComponentValue(textKey, resultJson.pos + 1 + " of " + resultJson.cells.length, false);
};
const CurDept = async (evl, name2, cxt, args) => {
  const para = new Array();
  para[0] = "CBDeptID";
  const value2 = await GetValue(evl, "", cxt, para);
  const ret = await new DictService(cxt.form).getDictValue("CB_DEPT", value2, "Name");
  return ret;
};
const CurYear = async (evl, name2, cxt, args) => {
  const para = new Array();
  para[0] = "YSYear";
  return await GetValue(evl, "", cxt, para);
};
const getTrSelectOIDs = async (evl, name2, cxt, args) => {
  let form2 = cxt.form;
  if (form2.formKey == "FI_GlobalPara") {
    return form2.getPara("DictOID");
  }
  let formType = form2.type;
  if (formType == FormType.DICT || formType == FormType.CHAINDICT) {
    return form2.getOID();
  }
  if (formType == FormType.COMPDICT) {
    return form2.getPara("OID");
  }
  let oids = "";
  let gridMap = form2.getGridArray();
  let formKey = form2.getFormKey();
  let tbls = form2.document.tbls;
  let gridSize = gridMap.length;
  let tableSize = 0;
  let tempTableKey;
  for (let i2 = 0; i2 < tbls.length; i2++) {
    let tableKey = tbls[i2].key;
    if (tableKey.endsWith("_T") || tableKey.endsWith("_NODB")) {
      continue;
    }
    tempTableKey = tableKey;
    tableSize = tableSize + 1;
  }
  if (tableSize == 1 && gridSize == 1 || formKey === "BatchTRRequest") {
    var listoid = BatchUtil.getSelectOIDs(form2, tempTableKey, SystemField.OID_SYS_KEY, false);
    oids = listoid.join(",");
  } else if (tableSize >= 1 && gridSize == 0) {
    return form2.getOID();
  } else if (tableSize > 1 && gridSize == 1) {
    return form2.getOID();
  } else if (tableSize > 1 && gridSize > 1) {
    let recordNoParentGrid = 0;
    let parentTableKey;
    for (let i2 = 0; i2 < gridSize; i2++) {
      let parentGrid = gridMap[i2].parentGridKey;
      if (parentGrid.length == 0) {
        recordNoParentGrid++;
        parentTableKey = gridMap[i2].tableKey;
      }
    }
    if (recordNoParentGrid == 1) {
      var listoid = BatchUtil.getSelectOIDs(form2, parentTableKey, SystemField.OID_SYS_KEY, false);
      oids = listoid.join(",");
      if (oids.length == 0) {
        throw new Error("请勾选父表的数据进行传输！");
      }
    } else {
      return form2.getOID();
    }
  }
  return oids;
};
const LocateGridFields = async (evl, name2, cxt, args) => {
  let componentLength = cxt.form.GridCellKeys.length;
  var rowIndex = -1;
  let i2 = 0;
  let pForm = FormStack.getForm(cxt.form.pFormID);
  let Pgrid = pForm.getComponent(cxt.form.LocateFormGridKey);
  var values = {};
  var maxValue = 0;
  for (let j22 = 0; j22 < componentLength; j22++) {
    var cellKey = cxt.form.GridCellKeys[j22];
    var value2 = ExprUtil.getImplValue(cxt.form, cellKey, cxt);
    values[cellKey] = value2;
  }
  var map2 = {};
  map2.MaxValue = 0;
  while (i2 < Pgrid.getRowCount()) {
    let row2 = Pgrid.getRowDataAt(i2);
    var j2 = 0;
    if (Pgrid.hasTree && !row2.isLeaf) {
      await Pgrid.showChildren(i2);
    }
    for (let k = 0; k < componentLength; k++) {
      var cellKey1 = cxt.form.GridCellKeys[k];
      var cellValue = Pgrid.getCellDataByKey(i2, cellKey1).caption;
      if (cellValue == values[cellKey1]) {
        j2++;
      }
    }
    if (j2 == componentLength) {
      rowIndex = i2;
      map2.MaxValue = i2;
      break;
    }
    if (j2 > 0) {
      if (j2 > maxValue) {
        map2.MaxValue = i2;
        maxValue = Math.max(maxValue, j2);
      }
    }
    i2++;
  }
  rowIndex = map2.MaxValue;
  Pgrid.setFocusRowIndex(rowIndex);
};
const FIGetExpandSrcValue = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const cellKey = args[0].toString();
  let gridKey = "grid0";
  if (args.length > 1) {
    gridKey = args[1].toString();
  }
  const grid = form2.getComponent(gridKey);
  const columnKey = cellKey;
  let colIndex = -1;
  cxt.getLoc(grid.key);
  if (colIndex == -1) {
    colIndex = cxt.getLoc(grid.key).getColumn();
  }
  const metaCell = grid.getDetailMetaRow().cells[colIndex];
  const crossValueMap = metaCell.crossValueMap;
  if (crossValueMap && columnKey in crossValueMap) {
    return crossValueMap[columnKey].value;
  }
  return null;
};
const ERAF_BalanceCalcSubTotal = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, accountIDKey = args[0], cellKey = args[1], isrootaccount = TypeConvertor.toBoolean(args[2]), cellLoc = form2.getCellLocation(cellKey), accountIDCellLoc = form2.getCellLocation(accountIDKey), grid = form2.getComponent(cellLoc.key);
  if (grid == void 0 || !cellLoc || !accountIDCellLoc) {
    return 0;
  }
  let sum = new Decimal(0);
  for (let i2 = 0, len = grid.getRowCount(); i2 < len; i2++) {
    const rowData = grid.getRowDataAt(i2);
    if (rowData.rowType === "Detail" && !GridUtil.isEmptyRow(rowData)) {
      if (isrootaccount) {
        const level = rowData.data[accountIDCellLoc.column][0];
        if (level && level == 1) {
          const value2 = rowData.data[cellLoc.column][0];
          sum = sum.plus(TypeConvertor.toDecimal(value2));
        }
      } else {
        const value2 = rowData.data[cellLoc.column][0];
        sum = sum.plus(TypeConvertor.toDecimal(value2));
      }
    }
  }
  return sum;
};
const GlobalCache = async (evl, name2, cxt, args) => {
  const formula = args[0];
  let result = YIUI.GlobalFormulaCache[formula];
  if (result == void 0) {
    result = await cxt.form.asyncEval(formula, cxt);
    YIUI.GlobalFormulaCache[formula] = result;
  }
  return result;
};
const GetExchangeDataTargetURL = async (evl, name2, cxt, args) => {
  let result = YIUI.URLCache["targetURL"];
  if (result) {
    return result;
  } else {
    const paras = {
      service: "ExchangeDataService",
      cmd: "GetExchangeDataURLCmd"
    };
    result = await new Request(void 0).getData(paras);
    YIUI.URLCache["targetURL"] = result;
    return result;
  }
};
const ShowHelpTxt = async (evl, name2, cxt, args) => {
  const form2 = FormStack.getActiveForm();
  const formKey = "HelpDocumentShow";
  const builder = new FormBuilder(formKey);
  builder.setParentForm(form2);
  builder.setTarget(FormTarget.MODAL);
  let helpForm = await builder.newEmpty();
  helpForm.setPara("__HELP_DOCUMENT_PARAS", args.join(","));
  return builder.build(helpForm).catch((e) => {
    FormStack.removeForm(helpForm.formID);
    throw e;
  });
};
const LoadOneLevelGridTreeData = async (evl, name2, cxt, args) => {
  checkParamNum(name2, args, 1);
  const gridKey = TypeConvertor.toString(args[0]);
  const form2 = cxt.form;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  const detailRow = grid.getDetailMetaRow();
  const rowTree = detailRow.rowTree;
  if (rowTree.treeType != TreeType.COMMON) {
    return;
  }
  const treeParent = rowTree.columnKey || rowTree.parent;
  const treeForeign = rowTree.foreign;
  const tableKey = grid.getTableKey();
  const document2 = form2.getDocument();
  const table = document2.getByKey(tableKey);
  const loc = cxt.getLoc(gridKey);
  const currentRowIndex = loc.getRow();
  const rowData = grid.getRowDataAt(currentRowIndex);
  const bookmark = rowData.bkmkRow.getBookmark();
  table.setByBkmk(bookmark);
  const parentValue = table.getByKey(treeParent);
  const belongFormKey = table.get(table.indexByKey("BelongFormKey"));
  const formKey = form2.getFormKey();
  const childTable = await new RichDocService(form2).loadGridTreeOneLevel(formKey, tableKey, parentValue, belongFormKey);
  const start = table.size() + 1;
  for (let i2 = 0, size = childTable.size(); i2 < size; i2++) {
    childTable.setPos(i2);
    const childForeignValue = childTable.getByKey(treeForeign);
    if (childForeignValue != null && childForeignValue != 0) {
      continue;
    }
    childTable.setByKey(treeForeign, parentValue);
    childTable.setByKey(treeParent, start + i2);
  }
  return childTable;
};
const getDictFilter = async function(dictView, form2) {
  var self = dictView;
  if (self.dictFilter) {
    return self.dictFilter;
  }
  var filter = await self.handler.getDictFilter(self);
  self.dictFilter = filter;
  return self.dictFilter;
};
const getDictData = async (evl, name2, cxt, args) => {
  var form2 = cxt.getForm();
  var dictForm = form2.getParentForm();
  var formKey = dictForm.formKey;
  var dictViewForm = dictForm.getParentForm();
  var dictView;
  if (dictViewForm == null) {
    dictView = dictForm.getComponent("DictView");
    dictViewForm = dictForm;
  } else {
    dictView = dictViewForm.getComponent("DictView");
  }
  var filter = await getDictFilter(dictView);
  var itemData = { "itemKey": formKey, "oid": "0" };
  var params = {};
  params.itemKey = dictView.itemKey;
  params.formState = 0;
  params.itemData = JSON.parse(JSON.stringify(itemData));
  if (filter != null) {
    params.filter = JSON.parse(JSON.stringify(filter));
  } else {
    params.filter = "";
  }
  params.stateMask = "";
  params.formKey = formKey;
  params.fieldKey = "";
  var paraStr = JSON.stringify(params);
  let reg = new RegExp("'", "g");
  var newValue = paraStr.replace(reg, "$$");
  await form2.eval("Macro_QueryDictData('" + newValue + "')", cxt);
};
const DicEditSetPara = async (evl, name2, cxt, args) => {
  var form2 = cxt.form, key2 = args[0], value2 = args[1];
  if (form2 == null)
    return;
  form2.setPara(key2, value2);
  var comp2 = form2.getComponent("Container");
  if (comp2 && comp2.tagName == "stackcontainer") {
    var activeForm = comp2.getActivePane();
    if (activeForm) {
      var newCxt = activeForm.newCxt();
      newCxt.form.setPara(key2, value2);
    }
  }
  var toolbar2 = form2.defaultToolBar;
  if (!toolbar2 || toolbar2.isDestroyed) {
    form2 = cxt.form.getParentForm();
    if (form2 == null)
      return;
    form2.setPara(key2, value2);
  }
};
const LocateComponentAndCell = async (evl, name2, cxt, args) => {
  checkParamNum(name2, args, 1);
  const componentKey = args[0];
  const row2 = args.length > 1 ? args[1] : 0;
  const parentRowIndex = args.length > 2 ? args[2] : -1;
  const form2 = cxt.form;
  const loc = form2.getCellLocation(componentKey);
  const key2 = loc ? loc.key : componentKey;
  if (loc && parentRowIndex > -1) {
    const grid = form2.getComponent(key2);
    const pGridKey = grid.parentGridKey;
    await ComponentLocationUtil.location(form2, pGridKey, false, parentRowIndex, void 0);
  }
  const rowIndex = loc && row2 > -1 ? row2 : void 0;
  const columnIndex = loc && loc.column;
  await ComponentLocationUtil.location(form2, key2, false, rowIndex, columnIndex);
};
const AddTreeGridRowOpt = async (evl, name2, cxt, args) => {
  checkParamNum(name2, args, 2);
  const form2 = cxt.form;
  const gridKey = args[0];
  const isChild = TypeConvertor.toBoolean(args[1]);
  const grid = form2.getComponent(gridKey);
  if (grid == null) {
    return COMPONENT_NOT_EXISTS(gridKey);
  }
  const oldRowIndex = grid.getFocusRowIndex();
  const oldColIndex = grid.getFocusColIndex();
  if (isChild && !(oldRowIndex >= 0)) {
    return NO_ROW_SELECTED(gridKey);
  }
  let newRowIndex = await form2.asyncEval(`Macro_AddTreeGridRow('${gridKey}', ${oldRowIndex}, ${isChild})`, cxt);
  newRowIndex = newRowIndex > -1 ? newRowIndex : oldRowIndex;
  setTimeout(() => {
    grid && grid.setFocusCell(newRowIndex, oldColIndex);
  }, 100);
};
const DebugMode = async (evl, name2, cxt, args) => {
  return debugMode;
};
const GetOperatorPara = async (evl, name2, cxt, args) => {
  checkParamNum(name2, args, 1);
  const paramID = args[0];
  return await OperatorParas.get(paramID);
};
const SetOperatorPara = async (evl, name2, cxt, args) => {
  checkParamNum(name2, args, 2);
  const paramID = args[0];
  const value2 = TypeConvertor.toString(args[1]);
  await OperatorParas.put(paramID, value2);
};
const IsNewRow = async (evl, name2, cxt, args) => {
  var cellKey = args[0];
  var cellLocation = cxt.form.getCellLocation(cellKey);
  if (!cellLocation) {
    return COMPONENT_NOT_EXISTS(cellKey);
  }
  var tableKey = cellLocation.tableKey;
  var loc = cxt.getLoc(cellLocation.key);
  var dataTable = cxt.form.document.getByKey(tableKey);
  var rowData = cxt.form.getComponent(cellLocation.key).getRowDataAt(loc.row);
  var rowType = rowData.rowType;
  if (rowType != "Detail") {
    throw new Error("不支持非明细行");
  }
  var isEmptyRow = GridUtil.isEmptyRow(rowData);
  if (isEmptyRow) {
    return true;
  }
  var bkmkRow = rowData.bkmkRow;
  var rowIndex = dataTable.getRowIndexByBkmk(bkmkRow.getBookmark());
  if (rowIndex == -1) {
    return true;
  } else {
    var state = dataTable.rows[rowIndex].state;
    if (state == DataDef.D_New) {
      return true;
    }
  }
  return false;
};
const ERPBaseFun = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  AddTreeGridRowOpt,
  CloseBeforeExpandLoadData,
  CurDept,
  CurYear,
  DebugMode,
  DicEditSetPara,
  DoSearchGridData,
  ERAF_BalanceCalcSubTotal,
  ERPExportExcel,
  ERPImportExcel,
  ERPInvokeService,
  ERPOpenForm,
  ERPRowExpand,
  ERPShowModal,
  EditBill,
  ExistsVariable,
  FIGetExpandSrcValue,
  GetAnaCaption,
  GetAndRemovePara,
  GetBlurFilter,
  GetEmployeeID,
  GetEntryPara,
  GetExchangeDataTargetURL,
  GetFocusFieldKey,
  GetOperatorPara,
  GlobalCache,
  IsBackMenu,
  IsERPForm,
  IsNewRow,
  IsWeb,
  LoadOneLevelGridTreeData,
  LocateComponentAndCell,
  LocateGridFields,
  RefreshPanelAllHideRow,
  SetEntryPara,
  SetOperatorPara,
  SetResultValue,
  ShowHelpTxt,
  ShowLocateForm,
  UIFuncWorkingPaper,
  getDictData,
  getTrSelectOIDs
}, Symbol.toStringTag, { value: "Module" }));
const _MessageFun = class _MessageFun2 {
  static showInfo(form2, msgs) {
    if (!msgs) {
      return;
    }
    for (let i2 = 0; i2 < msgs.length; i2++) {
      let msg = msgs[i2];
      if (msg.formID) {
        if (_MessageFun2.cache.contains(msg.digest)) {
          continue;
        }
        let onclickFun = async (data) => {
          if (!_MessageFun2.MessageFunSttings.MessageDetailFormKey) {
            return;
          }
          const builder = new FormBuilder(_MessageFun2.MessageFunSttings.MessageDetailFormKey);
          builder.setTarget(FormTarget.MODAL);
          return builder.newEmpty().then((emptyForm) => {
            emptyForm.setPara(_MessageFun2.MessageFunSttings.MessageDetailCodeKey, data.msgCode);
            emptyForm.setPara(_MessageFun2.MessageFunSttings.MessageDetailContent, data.msgContent);
            return builder.build(emptyForm);
          });
        };
        NotificationMgr.notice({
          form: form2,
          message: msg.content,
          title: I18N.getString("DIALOG_TIPS", "提示"),
          onClick: onclickFun,
          duration: 1e4,
          // position: Position.RIGHT_BOTTOM,
          data: {
            msgCode: msg.code,
            msgContent: msg.content
          }
        });
        _MessageFun2.cache.put(msg.digest, msg.digest);
      }
    }
  }
  static async _findToolbarItem(formId2, optKey) {
    let _form = FormStack.getFormByUUID(formId2);
    if (!_form) {
      return null;
    }
    let _tbl = _form.defaultToolBar;
    if (!_tbl) {
      return null;
    }
    return this._findInItems(_tbl.items || [], optKey);
  }
  static async _findInItems(_items, optKey) {
    for (let i2 = 0; i2 < _items.length; i2++) {
      let _item = _items[i2];
      if (_item && optKey == _item.key) {
        return _item;
      }
      if (_item.items) {
        _item = await this._findInItems(_item.items, optKey);
        if (_item) {
          return _item;
        }
      }
    }
    return null;
  }
  static async execRetry(message) {
    if (await this._hasPopupSubForm(message.formID)) {
      return;
    } else {
      let optKey = message.optKey;
      let optType = message.optType;
      if (optType == HeadInfoOptType.STR_BUTTON) {
        let _form = FormStack.getFormByUUID(message.formID);
        let item = _form.getComponent(optKey);
        if (item) {
          await item.handler.doOnClick(item, item.onClick);
        } else {
          let cellLocation = _form.getCellLocation(optKey);
          if (cellLocation) {
            let grid = _form.getComponent(cellLocation.key);
            let rowIndex = grid.getFocusRowIndex();
            let metaCell = grid.getCellEditOpt(rowIndex, cellLocation.column);
            HeadInfoUtil.put(metaCell, HeadInfoOptType.STR_BUTTON, grid.ofFormID);
            await _form.asyncEval(metaCell.editOptions.onClick, new ViewContext(_form));
          }
        }
      } else if (optType == HeadInfoOptType.STR_TOOLBAR) {
        let item = await this._findToolbarItem(message.formID, optKey);
        if (item) {
          let _form = FormStack.getFormByUUID(message.formID);
          LoadingUtil.show();
          await _form.defaultToolBar.handler.doOnClick(item.formID, item);
          LoadingUtil.hide();
        }
      } else if (optType == HeadInfoOptType.STR_ValueChanged) {
        let _form = FormStack.getFormByUUID(message.formID);
        let item = _form.getComponent(optKey);
        if (item) {
          let newValue = _form.getPara(optKey);
          await item.setValue(newValue, true, true, true);
        } else {
          let cellLocation = _form.getCellLocation(optKey);
          if (cellLocation) {
            let grid = _form.getComponent(cellLocation.key);
            let rowIndex = grid.getFocusRowIndex();
            let newValue = _form.getPara(optKey);
            let metaCell = grid.getCellEditOpt(rowIndex, cellLocation.column);
            if (metaCell.cellType == ControlType.DICT || metaCell.cellType == ControlType.DYNAMICDICT) {
              newValue = new ItemData(newValue);
            }
            await grid.setValueAt(rowIndex, cellLocation.column, newValue, true, true, true);
          }
        }
      } else if (optType == HeadInfoOptType.STR_DeleteRow) {
        let _form = FormStack.getFormByUUID(message.formID);
        let grid = _form.getComponent(optKey);
        let cxt = new ViewContext(_form);
        cxt.setGrid(grid);
        HeadInfoUtil.put(grid, HeadInfoOptType.STR_DeleteRow, grid.ofFormID);
        await _form.asyncEval(grid.meta.onRowDelete, cxt);
      } else if (optType == HeadInfoOptType.STR_RowClick || optType == HeadInfoOptType.STR_RowDblClick) {
        let _form = FormStack.getFormByUUID(message.formID);
        let grid = _form.getComponent(optKey);
        let cxt = new ViewContext(_form);
        cxt.setGrid(grid);
        if (optType == HeadInfoOptType.STR_RowClick) {
          HeadInfoUtil.put(grid, HeadInfoOptType.STR_RowClick, grid.ofFormID);
          await _form.asyncEval(grid.rowClick, cxt, null);
        } else {
          HeadInfoUtil.put(grid, HeadInfoOptType.STR_RowDblClick, grid.ofFormID);
          await _form.asyncEval(grid.getMetaObj().rowDblClick, cxt, null);
        }
      }
    }
  }
  static async _hasPopupSubForm(formID) {
    var formList = FormStack.getFormList();
    for (var i2 = 0; i2 < formList.length; i2++) {
      var tmpForm = formList[i2];
      if (tmpForm && tmpForm.popWidth && tmpForm.popHeight) {
        return await this._isSubForm(formID, tmpForm);
      }
    }
  }
  static async _isSubForm(formID, tmpForm) {
    var parentForm2 = tmpForm.getParentForm();
    if (!parentForm2) {
      return false;
    }
    if (parentForm2.getFormUUID() == formID) {
      return true;
    }
    tmpForm = parentForm2;
    return await this._isSubForm(formID, tmpForm);
  }
};
_MessageFun.MessageFunSttings = {
  MessageDetailFormKey: "MessageDetailShow",
  MessageDetailCodeKey: "__MSG_CODE",
  MessageDetailContent: "__MSG_CONTENT"
};
_MessageFun.cache = new LRUCache(100);
let MessageFun = _MessageFun;
let Confirm = FuncMap.getFun("Confirm");
let RefreshDictView = FuncMap.getFun("RefreshDictView");
let ShowData = FuncMap.getFun("ShowData");
let NewBill = FuncMap.getFun("NewBill");
let ResetEditBill = FuncMap.getFun("ResetEditBill");
let RemoveCache = FuncMap.getFun("RemoveCache");
let RemoveSysExpVals = FuncMap.getFun("RemoveSysExpVals");
let ReloadGrid = FuncMap.getFun("ReloadGrid");
const processUICommands = async function(form2, docDirtyValue, hasShowData) {
  const uiCommands = docDirtyValue.uiCommands;
  if (!uiCommands)
    return;
  for (let i2 = 0, len = uiCommands.length; i2 < len; i2++) {
    const key2 = uiCommands[i2].key;
    const content2 = uiCommands[i2].content;
    const args = uiCommands[i2].args;
    if (key2 == "UpdateDictView") {
      await this.updateDictView(form2, content2);
    } else if (key2 == "AddDictViewNode") {
      await this.addDictViewNode(form2, content2);
    } else if (key2 == "SelectDictViewByOID") {
      await this.selectDictViewByOID(form2, content2);
    } else if (key2 == "UpdateDictViewRowFieldData") {
      await this.updateDictViewRowFieldData(form2, content2);
    } else if (key2 == "DeleteDicViewRow") {
      await this.deleteDicViewRow(form2, content2);
    } else if (key2 == "UpdateTabCaption") {
      await this.updateTabCaption(form2, content2);
    } else if (key2 == "NewFormShow") {
      await this.newFormShow(form2, content2);
    } else if (key2 == "FormShow") {
      await this.FormShow(form2, content2);
    } else if (key2 == "FormShowDefaultStatus" && !hasShowData) {
      form2.document.state = DataDef.D_Normal;
      form2.setOperationState(OperationState.DEFAULT);
      await form2.showDocument();
    } else if (key2 == "NewBill") {
      const cxt = new ViewContext(form2);
      await NewBill(null, name, cxt, null);
    } else if (key2 == "ShowData" && !hasShowData) {
      await ShowData(null, name, new ViewContext(form2), null);
    } else if (key2 == "EditBill") {
      const cxt = new ViewContext(form2);
      await EditBill(null, name, cxt, null);
    } else if (key2 == "ResetEditBill") {
      const cxt = new ViewContext(form2);
      await ResetEditBill(null, name, cxt, null);
    } else if (key2 == "RefreshDictView") {
      const cxt = new ViewContext(form2);
      const itemKey = content2.itemKey, oid = content2.oid, optState = content2.optState;
      await RefreshDictView(null, "RefreshDictView", cxt, ["DictView", itemKey, oid, optState]);
    } else if (key2 == "ERPShowModal") {
      const formKey = content2.FormKey;
      const onLoad = content2.OnLoad;
      const target = content2.Target;
      var operationState = content2.OperationState;
      const cxt = new ViewContext(form2);
      let args2 = [formKey];
      (target || onLoad) && args2.push(onLoad);
      target != void 0 && args2.push(target);
      operationState && args2.push(operationState);
      await ERPShowModal(null, name, cxt, args2);
    } else if (key2 == "SetFieldError") {
      this.setFieldError(form2, content2);
    } else if (key2 == "Alert") {
      const paras = [content2];
      for (let j2 = 0, length = args.length; j2 < length; j2++) {
        paras.push(args[j2]);
      }
      const cxt = new ViewContext(form2);
      await Confirm(null, name, cxt, paras);
    } else if (key2 == "RunUIOpt") {
      const cxt = new ViewContext(form2);
      const action = content2.action;
      if (action) {
        await form2.asyncEval(action, cxt, null);
      }
    } else if (key2 == "RemoveCache") {
      const cxt = new ViewContext(form2);
      let args2 = [content2.itemKey];
      await RemoveCache(null, name, cxt, args2);
    } else if (key2 == "RemoveSysExpVals") {
      const cxt = new ViewContext(form2);
      let args2 = [content2.expValKeys];
      await RemoveSysExpVals(null, name, cxt, args2);
    } else if (key2 == "ShowFormulaErrorInDesignMode") {
      ERPDESIGNER.UI.showTip(content2, "error");
    } else if (key2 == "ReloadGrid") {
      const tableKey = content2.tableKey;
      const tableJson = content2.dataTable;
      const dataTable = DataUtil.fromJSONDataTable(tableJson);
      const grid = form2.getGrid(tableKey);
      const cxt = new ViewContext(form2);
      await ReloadGrid(null, "ReloadGrid", cxt, [grid.key, true, "", dataTable]);
    }
  }
};
UIScopeTrees.setMessageFun(MessageFun);
UIScopeTrees.setProcessUICommands(processUICommands);
class FormExt extends Form {
  async doOnLoad() {
    await this.calcDictTraceDependence();
    const event = this.getEvent("ERPOnLoad");
    if (event) {
      await this.doEvent("ERPOnLoad");
      await this.calcCaption();
    } else {
      await super.doOnLoad();
    }
  }
  async unlock() {
    if (DesignModeSetting.isDesignMode) {
      return;
    }
    let formType = this.metaForm.type;
    let container = this.getDefContainer();
    let form2 = this;
    this.getOperationState();
    let doc = this.getDocument();
    if (container && container.form) {
      formType = container.form.metaForm.type;
      doc = container.form.getDocument();
      form2 = container.form;
      doc = form2.getDocument();
      container.form.getOperationState();
    }
    if (!doc) {
      return;
    }
    if (this.getTopForm().isDestroyed) {
      return await ERPBusinessLock.UnLock(form2, doc);
    }
    if (formType != FormType.ENTITY && formType != FormType.NORMAL && formType != FormType.DICT) {
      return;
    }
    if (this.hasChild) {
      return;
    }
    if (!this.isNewTabForm) {
      return;
    }
    await ERPBusinessLock.UnLock(form2, doc);
  }
  async close() {
    var _a;
    const self = this;
    await self.unlock();
    if (this.impl.el.getElm().getAttribute("formKey") == "MobileFormDesigner") {
      (_a = window.FormDesignEnvironment) == null ? void 0 : _a.resetCurrentFormID(this.formID);
    }
    return super.close();
  }
  // setWFMapping(b) {
  //     this.bWFMapping = b;
  // }
  // isWFMapping() {
  //     return this.bWFMapping;
  // }
  // getCurrentParentBookmark(grid, bks) {
  //     const parentGrid = this.getComponent(grid.parentGridKey);
  //     if (!parentGrid) {
  //         return bks;
  //     }
  //     const parentGridTableKey = parentGrid.tableKey;
  //     const parentDataTable = this.getDocument().getByKey(parentGridTableKey);
  //     if (parentDataTable && parentDataTable.isValid()) {
  //         bks.put(parentGridTableKey, parentDataTable.getBkmk());
  //     } else {
  //         bks.put(parentGridTableKey, -1);
  //     }
  //     return this.getCurrentParentBookmark(parentGrid, bks);
  // }
  // //获得当前行bookmark 包含父表单
  // getCurrentBookmarks(grid, tableKey, rowIndex, colIndex) {
  //     if (!grid) {
  //         return;
  //     }
  //     if (!tableKey) {
  //         tableKey = grid.getTableKey();
  //     }
  //     let bkmk;
  //     if (rowIndex != null && rowIndex >= 0 && grid.getDatas().length > rowIndex) {
  //         const rowData = grid.getRowDataAt(rowIndex);
  //         if (!rowData.bkmkRow || rowData.bkmkRow == null) {
  //         } else if (grid.hasColumnExpand()) {
  //             const rowArray = rowData.bkmkRow.getRowArray();
  //             bkmk = [];
  //             for (let i = 0; i < rowArray.length; i++) {
  //                 bkmk.push(rowArray[i].getBookmark());
  //             }
  //         } else {
  //             bkmk = rowData.bkmkRow.getBookmark();
  //         }
  //     }
  //     const bks = new HashMap();
  //     if (bkmk != undefined) {
  //         bks.put(tableKey, bkmk);
  //     }
  //     else {
  //         bks.put(tableKey, -1);
  //     }
  //     if (colIndex) {
  //         const crossInfo = new HashMap();
  //         const detailRow = grid.getDetailMetaRow();
  //         if (detailRow && detailRow.cells[colIndex]) {
  //             const crossValueMap = detailRow.cells[colIndex].crossValueMap;
  //             crossValueMap && bks.put("__cross__" + tableKey, crossValueMap);
  //         }
  //     }
  //     if (rowIndex != null) {
  //         return this.getCurrentParentBookmark(grid, bks);
  //     }
  //     return bks;
  // }
  // getDataObjectVersion() {
  //     return this.dataObjectVersion;
  // }
  // setDataObjectVersion(version) {
  //     this.dataObjectVersion = version;
  // }
  // setModalDialogEl(modalDialogEl) {
  //     this.modalDialogEl = modalDialogEl;
  // }
  // getModalDialogEl() {
  //     return this.modalDialogEl;
  // }
  // /**
  //  * 用于获取表单上字典追溯的依赖条件
  //  */
  // getDictTraceDependence() {
  //     return this.dictTraceDependence;
  // }
  // setDictTraceDependence(dictTraceDependence: string) {
  //     this.dictTraceDependence = dictTraceDependence;
  // }
  // async calcDictTraceDependence() {
  //     let canPopupDicts = await cache.get("CanPopupDicts");
  //     if (canPopupDicts == null) {
  //         canPopupDicts = await this.__eval('Macro_CanPopupDicts()', (void 0));
  //         cache.put("CanPopupDicts", canPopupDicts);
  //     }
  //     let canPopupFormDicts = await cache.get("CanPopupFormDicts");
  //     if (canPopupDicts == null) {
  //         canPopupFormDicts = await this.__eval('Macro_CanPopupFormDicts()', (void 0));
  //         cache.put("CanPopupFormDicts", canPopupFormDicts);
  //     }
  //     const dictTraceDependence = canPopupDicts + ";" + canPopupFormDicts;
  //     this.setDictTraceDependence(dictTraceDependence);
  //     return dictTraceDependence;
  // }
}
class FormFactoryExt {
  static create(metaForm, appEnv) {
    return new FormExt(metaForm, appEnv);
  }
}
extend(FormFactory, FormFactoryExt);
var _strings = {
  LOGIN_TITLE: "让世界上没有难做的系统",
  LOGIN_USERLOGIN: "用户登录",
  LOGIN_USERNAME: "用户名",
  LOGIN_PASSWORD: "密码",
  LOGIN_LANGUAGE: "语言",
  LOGIN_SELECT: "请选择",
  LOGIN_LOGINBTN: "登录",
  CONTROL_REQUIRED: "-必须填写-",
  ATTACHMENT_Name: "附件名称",
  ATTACHMENT_UPLOADTIME: "上传时间",
  ATTACHMENT_UPLOADOPERATORID: "上传人",
  ATTACHMENT_PATH: "附件路径",
  ATTACHNEMT_OPERATE: "操作",
  ATTACHMENT_UPLOAD: "上传",
  ATTACHMENT_DOWNLOAD: "下载",
  ATTACHMENT_DELETE: "删除",
  ATTACHMENT_PREVIEW: "预览",
  ATTACHMENT_NOCONTENT: "表中无内容",
  ATTACHMENT_UNABLE: "新增状态无法进行上传操作！",
  LISTVIEW_ORDER: "序",
  LISTVIEW_SEQ: "序号",
  DICT_UNKNOWN: "未知的类型：",
  DICT_QUERY: "查询",
  DICT_CANCEL: "取消",
  DICT_EMPTY: "清空",
  DICT_CODE: "代码",
  DICT_KEYWORD: "请输入关键字",
  DICT_HAVE: "有",
  DICT_A: "个",
  DICT_OPTIONS: "选项",
  DICT_SELECTED: "已选",
  DICT_ITEM: "项",
  DATE_TODAY: "今天",
  DATE_CONFIRM: "确认",
  DATE_FORMATERROR: "输入的格式错误",
  DATE_WRONGTIME: "错误的时间：",
  DATE_H: "时",
  DATE_M: "分",
  DATE_S: "秒",
  YESCOMBOBOX_NOTHING: "无",
  YESCOMBOBOX_NODATA: "无匹配数据",
  GRID_SEQ: "序号",
  GRID_CUSTOM: "自定义",
  GRID_DELETECHILDREN: "确定删除当前行及其子数据?",
  GRID_DELETESELECT: "确定删除所有选中行?",
  GRID_NONSUPPORT: "表格排序不支持行分组！",
  GRID_WHETHERCLOSEALL: "是否关闭所有表单?",
  GRID_CLOSEALL: "关闭所有",
  GRID_LUNDEFINED: "扩展源未定义",
  GRID_TOTAL: "共 {0} 条",
  GRID_SELECTROW: "请选中行",
  GRID_NODATA: "无数据显示",
  GRID_RECORDTEXT: "共 {2} 条",
  GRID_JUMPTO: " 跳转至：{0}页",
  GRID_DELETERECORD: "删除所选记录？",
  GRID_SAVE: "保存",
  GRID_CANCEL: "取消",
  GRID_ADDRECORD: "添加新记录",
  GRID_DELRECORD: "删除所选记录",
  GRID_MOVEUP: "上移数据行",
  GRID_MOVEDOWN: "下移数据行",
  GRID_BESTWIDTH: "最佳列宽",
  GRID_FROZENCOL: "冻结列",
  GRID_FROZENROW: "冻结行",
  GRID_UNFROZENCOL: "解冻列",
  GRID_UNFROZENROW: "解冻行",
  GRID_UNFROZENLEFTCOL: "解冻左侧列",
  GRID_UNFROZENRIGHTCOL: "解冻右侧列",
  GRID_FROZENLEFTCOL: "冻结左侧列",
  GRID_FROZENRIGHTCOL: "冻结右侧列",
  GRID_FROZENLEFTROWCOL: "冻结左侧行列",
  GRID_FROZENRIGHTROWCOL: "冻结右侧行列",
  GRID_ISNOTTABLE: "表格初始化错误，初始化所用HtmlElement不是Table类型",
  GRID_ISERRORMODE: "表格所在页面的渲染模式(documentMode)低于5",
  GRID_ISSORTERROR: "行分组情况下不允许进行排序",
  GRID_NOTALLOW: "多选复合字典{0}不允许有数据绑定字段",
  GRID_PROMPT: "提示",
  GRID_SELECT: "打开",
  GRID_SHOW: "查看",
  GRID_RECORDSECTION: "{0} - {1} 条",
  GRID_RECORDSECTIONTEXT: "{0} - {1}　共 {2} 条",
  USERINFOPANE_ADMIN: "系统管理员",
  USERINFOPANE_APPLOGOUT: "注销",
  USERINFOPANE_APPEXIT: "退出",
  USERINFOPANE_APPCHAGEPWD: "修改密码",
  RIGHTSSET_DICTRIGHTS: "字典权限设置",
  RIGHTSSET_MODIFY: "修改",
  RIGHTSSET_SAVE: "保存",
  RIGHTSSET_SELECTALL: "全选",
  RIGHTSSET_KEY: "标志",
  RIGHTSSET_CODE: "编码",
  RIGHTSSET_SEARCH: "搜索",
  RIGHTSSET_FORMRIGHTS: "表单权限设置",
  RIGHTSSET_ENTRYRIGHTS: "入口权限设置",
  FORMRIGHT_KEY: "标识",
  FORMARIGHT_VISIBLE: "可见",
  FORMARIGHT_ENABLE: "可编辑",
  BAIDUMAP_INPUTPLACE: "请输入搜索地点...",
  BAIDUMAP_EVENTTEST: "Event测试",
  BAIDUMAP_ADDRESS: "地址：XX市XX区XXXXXXX",
  BAIDUMAP_CANTON: "行政区",
  BAIDUMAP_INPUTNAME: "请输入行政区名称...",
  BAIDUMAP_FAILTO: "未能获取当前输入行政区域",
  BAIDUMAP_CURRENTDOT: "当前点",
  CALENDAR_MONTHS: "yyyy年MM月",
  CALENDAR_WEEKS: "yyyy年MM月dd-{dd}日",
  CALENDAR_DAYS: "yyyy年MM月dd日-dddd",
  CALENDAR_WEEK: "周",
  CALENDAR_MONTH: "月",
  CALENDAR_DAY: "日",
  CALENDAR_TODAY: "今天",
  CALENDAR_JANUARY: "一月",
  CALENDAR_FEBRUARY: "二月",
  CALENDAR_MARCH: "三月",
  CALENDAR_APRIL: "四月",
  CALENDAR_MAY: "五月",
  CALENDAR_JUNE: "六月",
  CALENDAR_JULY: "七月",
  CALENDAR_AUGUST: "八月",
  CALENDAR_SEPTEMBER: "九月",
  CALENDAR_OCTOBER: "十月",
  CALENDAR_NOVEMBER: "十一月",
  CALENDAR_DECEMBER: "十二月",
  CALENDAR_SUNDAY: "周日",
  CALENDAR_MONDAY: "周一",
  CALENDAR_TUESDAY: "周二",
  CALENDAR_WEDNESDAY: "周三",
  CALENDAR_THURSDAY: "周四",
  CALENDAR_FRIDAY: "周五",
  CALENDAR_SATURDAY: "周六",
  CALENDAR_ALLDAY: "全天",
  CALENDAR_DOT: "点",
  CALENDAR_SCHEDULE: "日程内容：",
  CALENDAR_THING: "记录你将要做的一件事...",
  CALENDAR_STARTTIME: "开始时间：",
  CALENDAR_STOPTIME: "结束时间：",
  CALENDAR_CHOICE: "选择",
  CALENDAR_CURRENT: "当前",
  CALENDAR_NOTEMPTY: "内容不允许为空!",
  CALENDAR_NOTTIME: "开始时间不允许为空!",
  CALENDAR_NEWEVENT: "新建事件",
  CALENDAR_EDITEVENT: "编辑事件",
  CALENDAR_NEW: "新建",
  CALENDAR_CONFIRMDEL: "确定删除？",
  TABPANELEX_PICTURE: "图片",
  TABPANELEX_MATERIALORDER: "物料订单",
  WIZARDPANEL_PREVIOUSSTEP: "上一步",
  WIZARDPANEL_NEXTSTEP: "下一步",
  WIZARDPANEL_COMPLETE: "完成",
  DIALOG_CLOSE: "关闭",
  DIALOG_DETAILS: "详情",
  DIALOG_WCLOSE: "是否关闭",
  DIALOG_YES: "是",
  DIALOG_NO: "否",
  DIALOG_MESSAGE: "消息",
  DIALOG_RETURN: "返回",
  DIALOG_VALIDATECODE: "验证码",
  DIALOG_FAILEDMSG: "登录失败，返回登录界面!",
  PAGINATION_JOINT: "共",
  PAGINATION_TOTALRECORD: "条记录",
  PAGINATION_TOTAL: "条",
  PAGINATION_PAGE: "页",
  FORM_CLOSEINTERFACE: "是否确定要关闭界面？",
  REQUEST_CHECK: "请求状态未初始化，检查服务器连接！",
  OPT_WARNING: "警告",
  OPT_FORM: "表单",
  OPT_TABLE: "表格",
  OPT_THE: "第",
  OPT_LINE: "行:",
  OPT_LINETHE: "行,第",
  OPT_COLUMN: "列:",
  OPT_REQUIRED: "不能为空",
  OPT_HASERROR: "有错误",
  OPT_FORMCONTROL: "组件",
  OPT_NOFILL: "是必填项，当前未填值。",
  DOCSERVICEPROXY_NOFORMDEFINED: "form 不能为空",
  TOOLBAR_REVOCATECOMMITED: "撤销已提交审批",
  TOOLBAR_COMMITWORKITEM: "提交工作项",
  TOOLBAR_VIA: "通过",
  TOOLBAR_STARTINSTANCE: "启动流程",
  TOOLBAR_MORE: "更多",
  TOOLBAR_DIRECTSENDING: "直送",
  TOOLBAR_CLOSEOTHER: "关闭其他",
  TOOLBAR_WHETHERCLOSEOTHER: "是否关闭其他表单?",
  JQUERYEXT_ATTACHMENTEXCEEDMAXSIZE: "超出指定大小!",
  JQUERYEXT_ATTACHMENTTYPERROR: "非指定文件类型!",
  NAVIGATION_APPLICATION: "Yigo应用",
  NAVIGATION_USERNAME: "",
  NAVIGATION_APPVER: "版本：",
  NAVIGATION_APPBUILDID: "创建号：",
  NAVIGATION_APPCOPYRIGHTS: "上海博科资讯股份有限公司",
  NAVIGATION_AUTHORIZE: "授权于：博科资讯 ",
  NAVIGATION_OVERDUETIME: "过期时间：",
  NAVIGATION_APPABOUT: "关于Yigo",
  NAVIAGTION_ABOUTSYS: "系统信息",
  NAVIAGTION_DESIGNER: "设计",
  NAVIGATION_AUTHORIZATIONINFO: "授权信息",
  NAVIGATION_ERPABOUT: "关于ERP",
  NAVIGATION_ERPVER: "ERP版本",
  NAVIGATION_YIGOVER: "平台版本",
  NAVIGATION_ERPVERDATE: "产品发布日期",
  NAVIGATION_OTHER_TAB_LOGIN: "有其他客户端登录,请先退出其他客户端",
  MENUTREE_INPUTKEYWORDS: "请输入关键词...",
  SERVER_ERROR: "服务端错误",
  TITLE_ERROR: "错误",
  TIMEPICKER_NOW: "现在",
  TIMEPICKER_HOURS: "时",
  TIMEPICKER_MINUTES: "分",
  TIMEPICKER_SECONDES: "秒",
  FILEUTIL_NONTYPEFILE: "非指定类型文件!",
  UPLOADBUTTON_TIP: "请选择文件...",
  IMAGE_EDITIMAGE: "编辑图片",
  IMAGE_PHOTOGRAPH: "拍照",
  IMAGE_PHOTOABLUM: "从相册选择",
  IMAGE_UPLOADING: "上传中...",
  IMAGE_LOADINGFAIL: "上传失败",
  IMAGE_LOADING: "加载中...",
  IMAGE_LOADFAIL: "加载失败",
  VIDEO_TAKEVIDEO: "拍摄视频",
  VIDEO_SELECTVIDEO: "选择视频",
  //通用
  CURRENCY_OK: "确定",
  CURRENCY_NAME: "名称",
  CURRENCY_CLEAN: "清除",
  CURRENCY_HASRIGHTS: "有权限",
  IMPORT_FAILED: "导入失败！",
  IMPORT_SUCCESS: "导入成功！",
  GRID_Tree_Operates: "树操作",
  AddTreeGridSiblingRow: "新增行(同级)",
  AddTreeGridChildRow: "新增行(子级)"
};
var _i18nStrings = {};
class I18NExt {
  static seti18nStrings(lang) {
    _i18nStrings = lang;
  }
  static geti18nString(lang, projectKey, key2) {
    if (!_i18nStrings) {
      return void 0;
    }
    var strings = _i18nStrings[projectKey];
    if (Utils.isUndefined(strings)) {
      return void 0;
    }
    return strings[key2];
  }
  static getString(key2, defaultValue, language2) {
    var lang = Utils.getCookie("locale");
    var value2 = this.geti18nString(lang, "Solution", key2) || this.geti18nString(lang, "Solution", defaultValue);
    if (Utils.isUndefined(value2)) {
      for (var i2 in _i18nStrings) {
        value2 = this.geti18nString(lang, i2, key2) || this.geti18nString(lang, i2, defaultValue);
        if (!Utils.isUndefined(value2)) {
          break;
        }
      }
    }
    if (Utils.isUndefined(value2)) {
      value2 = _strings[key2] || _strings[defaultValue];
    }
    if (Utils.isUndefined(value2)) {
      value2 = defaultValue;
    }
    if (value2 == void 0 || value2 == null) {
      return "";
    }
    return value2;
  }
  static localeFormat(projectKey, key2, args) {
    var lang = Utils.getCookie("locale");
    var value2;
    if (Utils.isUndefined(projectKey) || projectKey == "") {
      value2 = this.geti18nString(lang, "Solution", key2);
    } else {
      value2 = this.geti18nString(lang, projectKey, key2);
      if (Utils.isUndefined(value2)) {
        value2 = this.geti18nString(lang, "Solution", key2);
      }
    }
    if (Utils.isUndefined(value2)) {
      value2 = key2;
    }
    if (args != void 0 && args.length > 0) {
      value2 = Utils.format(value2, args);
    }
    return value2;
  }
  static reg(map) {
    _strings = Object.assign(_strings, map);
  }
}
extend(I18N, I18NExt);
const FIX_DIMENSION_KEYS = ["PeriodID", "CompanyCodeID", "LedgerID", "CurrencyID", "BusinessAreaID", "ProfitCenterID", "SegmentID", "FunctionalAreaID"];
const D0_COLUMN_KEY$1 = "D0";
const D1_COLUMN_KEY = "D1";
const funs = {};
const setCellDimension$2 = (form2, key2, rowIndex, columnIndex, value2) => {
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.dimension) {
    cellData.dimension = {};
  }
  let dimensionValue = value2;
  if (value2 && value2 instanceof ItemData) {
    dimensionValue = value2.getOID();
  }
  cellData.dimension[key2] = dimensionValue;
};
const getCellDimension$2 = (form2, key2, rowIndex, columnIndex, defaultValue) => {
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  if (!grid || !grid.rendered) {
    return defaultValue;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return defaultValue;
  }
  if (!cellData.dimension) {
    return defaultValue;
  }
  const value2 = cellData.dimension[key2];
  return value2 ? value2 : defaultValue;
};
const setCellStyle$2 = (form2, key2, rowIndex, columnIndex, value2) => {
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.style) {
    cellData.style = {};
  }
  cellData.style[key2] = value2;
};
const getCellStyle$2 = (form2, key2, rowIndex, columnIndex, defaultValue) => {
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  if (!grid || !grid.rendered) {
    return defaultValue;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return defaultValue;
  }
  if (!cellData.style) {
    return defaultValue;
  }
  const value2 = cellData.style[key2];
  return value2 ? value2 : defaultValue;
};
const deleteCellStyle$2 = (form2, rowIndex, columnIndex, key2 = "") => {
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.style) {
    return;
  }
  if (key2) {
    delete cellData.style[key2];
  } else {
    delete cellData.style;
  }
};
const getGridByColumnKey$2 = (form2, columnKey) => {
  const loc = form2.getCellLocation(columnKey);
  const gridKey = loc.key;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  return grid;
};
const getGridSelectedRange$2 = (grid) => {
  const focusRowIndex = grid.getFocusRowIndex();
  if (focusRowIndex < 0) {
    const msg = "未选择单元格";
    throw new Error(msg);
  }
  const selectionModel = grid.getSelection();
  return {
    startCol: selectionModel.focusCol,
    startRow: selectionModel.focusRow,
    width: selectionModel.right - selectionModel.left + 1,
    height: selectionModel.bottom - selectionModel.top + 1
  };
};
const gridSetCellStyle$2 = (grid, rowIndex, colIndex, style, value2) => {
  if (!grid.rendered) {
    return;
  }
  const elGrid = grid.impl.el.$table;
  const cell = elGrid.getCell(rowIndex, colIndex);
  if (!cell) {
    return;
  }
  cell.$addStyle(style, value2 ? value2 + "" : "unset");
};
const gridSetFontStyle$2 = (grid, rowIndex, colIndex, style, value2) => {
  if ("Bold" == style) {
    gridSetCellStyle$2(grid, rowIndex, colIndex, "fontWeight", value2 == 1 ? "bold" : "normal");
  } else if ("Italic" == style) {
    gridSetCellStyle$2(grid, rowIndex, colIndex, "fontStyle", value2 == 1 ? "italic" : "normal");
  } else if ("Underline" == style) {
    gridSetCellStyle$2(grid, rowIndex, colIndex, "textDecoration", value2 == 1 ? "underline" : "none");
  }
};
const gridSetAlignment$2 = (grid, rowIndex, colIndex, direction, alignment) => {
  if ("Horizontal" == direction) {
    gridSetCellStyle$2(grid, rowIndex, colIndex, "textAlign", alignment);
  }
};
const gridSplitCell$2 = (grid, rowIndex, colIndex) => {
  if (!grid.rendered) {
    return;
  }
  const elGrid = grid.impl.el.$table;
  let cell = elGrid.getCell(rowIndex, colIndex);
  if (!cell) {
    return;
  }
  const cellColSpan = cell.getAttr("colspan") || 1;
  const cellRowSpan = cell.getAttr("rowspan") || 1;
  if (cellColSpan <= 1 && cellRowSpan <= 1) {
    return;
  }
  const rowSpan = cellRowSpan, colSpan = cellColSpan;
  cell.$setAttr("colspan", 1);
  cell.$setAttr("rowspan", 1);
  for (let j2 = 0; j2 < rowSpan; j2++) {
    for (let i2 = 0; i2 < colSpan; i2++) {
      if (i2 == 0 && j2 == 0) {
        continue;
      }
      cell = elGrid.getCell(rowIndex + j2, colIndex + i2);
      cell.$removeClass("ui-hidden");
    }
  }
};
const gridMergeCell$2 = (grid, rowIndex, colIndex, colSpan, rowSpan) => {
  if (!grid.rendered) {
    return;
  }
  const elGrid = grid.impl.el.$table;
  let cell = elGrid.getCell(rowIndex, colIndex);
  if (!cell) {
    return;
  }
  if (colSpan > 1) {
    cell.$setAttr("colspan", colSpan);
  }
  if (rowSpan > 1) {
    cell.$setAttr("rowspan", rowSpan);
  }
  console.log("MergeCell(${rowIndex},${colIndex},${colSpan},${rowSpan})");
  colSpan = colSpan > 1 ? colSpan : 1;
  rowSpan = rowSpan > 1 ? rowSpan : 1;
  for (let j2 = 0; j2 < rowSpan; j2++) {
    for (let i2 = 0; i2 < colSpan; i2++) {
      if (i2 == 0 && j2 == 0) {
        continue;
      }
      cell = elGrid.getCell(rowIndex + j2, colIndex + i2);
      cell.$addClass("ui-hidden");
    }
  }
};
const showCellDimensionInfo$2 = (form2, rowIndex, columnIndex) => {
  let value2;
  value2 = getCellDimension$2(form2, "CellType", rowIndex, columnIndex, 2);
  form2.setComponentValue("CellType", value2, false);
  value2 = getCellDimension$2(form2, "ControlType", rowIndex, columnIndex, 2);
  form2.setComponentValue("ShowControlType", value2, false);
  value2 = getCellDimension$2(form2, "ZBIndexID", rowIndex, columnIndex, 0);
  form2.setComponentValue("ShowZBIndexID", value2, false);
  value2 = getCellDimension$2(form2, "ZBIndexDataTypeID", rowIndex, columnIndex, 0);
  form2.setComponentValue("ShowZBIndexDataTypeID", value2, false);
  value2 = getCellDimension$2(form2, "FormulaFront", rowIndex, columnIndex, "");
  form2.setComponentValue("FormulaFront", value2, false);
  value2 = getCellDimension$2(form2, "FormulaBack", rowIndex, columnIndex, "");
  form2.setComponentValue("FormulaBack", value2, false);
  for (let i2 = 0; i2 < FIX_DIMENSION_KEYS.length; i2++) {
    value2 = getCellDimension$2(form2, FIX_DIMENSION_KEYS[i2], rowIndex, columnIndex, 0);
    form2.setComponentValue("DynShow" + FIX_DIMENSION_KEYS[i2], value2, false);
  }
  for (let i2 = 0; i2 < 20; i2++) {
    value2 = getCellDimension$2(form2, "DictDimensionID" + (i2 + 1), rowIndex, columnIndex, 0);
    form2.setComponentValue("DynShowDimension" + (i2 + 1) + "ID", value2, false);
  }
};
const showCellStyleInfo$2 = (form2, rowIndex, columnIndex) => {
  let value2;
  value2 = getCellStyle$2(form2, "FontName", rowIndex, columnIndex, "");
  form2.setComponentValue("FontNameList", value2, false);
  value2 = getCellStyle$2(form2, "FontSize", rowIndex, columnIndex, "");
  form2.setComponentValue("FontSizeList", value2, false);
};
funs.LoadReport = (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const doc = form2.getDocument();
  const loc = form2.getCellLocation(D1_COLUMN_KEY);
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const headTable = doc.getByKey("EFI_ReportModel");
  headTable.first();
  const tableWidths = headTable.getByKey("TableWidth").split(";");
  let isChanged = false;
  for (let i2 = tableWidths.length - 1; i2 >= 0; i2--) {
    const width = parseInt(tableWidths[i2], 10);
    const column = grid.getColumnAt(loc.column + i2);
    if (!column) {
      continue;
    }
    if (!isChanged) {
      isChanged = column.width == width;
    }
    if (isChanged) {
      column.width = width;
    }
  }
  if (isChanged) {
    grid.refreshGrid();
  }
  if (!grid.rendered) {
    return;
  }
  grid.impl.el.$table.grid.bDiv.addPostpatchHook(() => {
    const dimensionTable = doc.getByKey("EFI_RptCellDimensionInfo");
    dimensionTable.beforeFirst();
    while (dimensionTable.next()) {
      const rowIndex = TypeConvertor.toInt(dimensionTable.getByKey("RowIndex")) - 1;
      const columnIndex = TypeConvertor.toInt(dimensionTable.getByKey("ColumnIndex")) - 1;
      for (let i2 = 0, count = dimensionTable.getColumnCount(); i2 < count; i2++) {
        const colKey = dimensionTable.getCol(i2).getKey();
        if (SystemField.isSystemField(colKey)) {
          continue;
        }
        const value2 = dimensionTable.getByKey(colKey);
        setCellDimension$2(form2, colKey, rowIndex, columnIndex + 1, value2);
        if ("CellType" == colKey) {
          const color = value2 == 1 ? "#fef3c9" : value2 == 3 ? "#ccffcc" : "";
          if (color) {
            grid.setCellBackColor(rowIndex, loc.column + columnIndex, color);
          }
        }
      }
    }
    const styleTable = doc.getByKey("EFI_RptCellStyleInfo");
    styleTable.beforeFirst();
    while (styleTable.next()) {
      const rowIndex = TypeConvertor.toInt(styleTable.getByKey("RowIndex")) - 1;
      const columnIndex = TypeConvertor.toInt(styleTable.getByKey("ColumnIndex")) - 1;
      let xSpan = 0, ySpan = 0;
      for (let i2 = 0, count = styleTable.getColumnCount(); i2 < count; i2++) {
        const colKey = styleTable.getCol(i2).getKey();
        if (SystemField.isSystemField(colKey)) {
          continue;
        }
        const value2 = styleTable.getByKey(colKey);
        if (!value2) {
          continue;
        }
        setCellStyle$2(form2, colKey, rowIndex, columnIndex + 1, value2);
        if ("ForeColor" == colKey) {
          grid.setCellForeColor(rowIndex, loc.column + columnIndex, value2);
        }
        if ("BackColor" == colKey) {
          grid.setCellBackColor(rowIndex, loc.column + columnIndex, value2);
        }
        if ("XSpan" == colKey) {
          xSpan = TypeConvertor.toInt(value2);
        }
        if ("YSpan" == colKey) {
          ySpan = TypeConvertor.toInt(value2);
        }
        if ("Horizontal" == colKey || "Vertical" == colKey) {
          gridSetAlignment$2(grid, rowIndex, loc.column + columnIndex, colKey, value2);
        }
        if (("Bold" == colKey || "Italic" == colKey) && value2 == 1) {
          gridSetFontStyle$2(grid, rowIndex, loc.column + columnIndex, colKey, value2);
        }
        if ("FontName" == colKey && value2 != "") {
          gridSetCellStyle$2(grid, rowIndex, loc.column + columnIndex, "fontFamily", value2);
        }
        if ("FontSize" == colKey && value2 > 0) {
          gridSetCellStyle$2(grid, rowIndex, loc.column + columnIndex, "fontSize", value2 + "px");
        }
        if ("LeftBorder" == colKey && value2 == "true") {
          gridSetCellStyle$2(grid, rowIndex, loc.column + columnIndex, "borderLeft", "2px solid #000000");
        }
        if ("TopBorder" == colKey && value2 == "true") {
          gridSetCellStyle$2(grid, rowIndex, loc.column + columnIndex, "borderTop", "2px solid #000000");
        }
        if ("RightBorder" == colKey && value2 == "true") {
          gridSetCellStyle$2(grid, rowIndex, loc.column + columnIndex, "borderRight", "2px solid #000000");
        }
        if ("BottomBorder" == colKey && value2 == "true") {
          gridSetCellStyle$2(grid, rowIndex, loc.column + columnIndex, "borderBottom", "2px solid #000000");
        }
      }
      if (xSpan > 0 || ySpan > 0) {
        gridMergeCell$2(grid, rowIndex, loc.column + columnIndex, xSpan, ySpan);
      }
    }
  });
};
funs.SaveReport = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  if (!form2.reportModel) {
    form2.reportModel = {};
  }
  form2.reportModel.columnWidths = [];
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const columnLength = grid.getColumnCount() - 1;
  for (let i2 = 0; i2 < columnLength; i2++) {
    const loc = form2.getCellLocation("D" + (i2 + 1));
    if (!loc) {
      continue;
    }
    const columnIndex = loc.column;
    form2.reportModel.columnWidths.push(grid.getColumnAt(columnIndex).width);
    for (let rowIndex = 0, rowCount = grid.getRowCount(); rowIndex < rowCount; rowIndex++) {
      const dataKey = getExcelColumnLabel$1(i2) + "" + (rowIndex + 1);
      const cellData = grid.getCellDataAt(rowIndex, columnIndex);
      if (cellData.dimension) {
        if (!form2.reportModel.dimensions) {
          form2.reportModel.dimensions = {};
        }
        form2.reportModel.dimensions[dataKey] = cellData.dimension;
        form2.reportModel.dimensions[dataKey]["RowIndex"] = rowIndex + 1;
        form2.reportModel.dimensions[dataKey]["ColumnIndex"] = columnIndex;
      }
      if (cellData.style) {
        if (!form2.reportModel.styles) {
          form2.reportModel.styles = {};
        }
        form2.reportModel.styles[dataKey] = cellData.style;
        form2.reportModel.styles[dataKey]["RowIndex"] = rowIndex + 1;
        form2.reportModel.styles[dataKey]["ColumnIndex"] = columnIndex;
      }
    }
  }
  if (form2.reportModel) {
    return JSON.stringify(form2.reportModel);
  }
  return "";
};
funs.ShowCellInfo = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const rowIndex = grid.getFocusRowIndex();
  const columnIndex = grid.getFocusColIndex();
  if (rowIndex >= 0 && columnIndex >= 0) {
    await form2.setComponentValue("Row", rowIndex + 1, false);
    await form2.setComponentValue("COL", getExcelColumnLabel$1(columnIndex - 1), false);
    const value2 = getCellDimension$2(form2, "IsLockCell", rowIndex, columnIndex, 1);
    form2.setComponentValue("IsLock", value2, false);
    showCellDimensionInfo$2(form2, rowIndex, columnIndex);
    showCellStyleInfo$2(form2, rowIndex, columnIndex);
  }
};
funs.SetCellInfo = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, loc = form2.getCellLocation(D0_COLUMN_KEY$1);
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const fielKey = args[0];
  const rowIndex = grid.getFocusRowIndex();
  const columnIndex = grid.getFocusColIndex();
  if (rowIndex >= 0 && columnIndex >= 0) {
    await grid.setValueAt(rowIndex, loc.column, 1, true, true, false);
    setDimensions$1(form2, fielKey, rowIndex, columnIndex);
    if (fielKey == "CellType") {
      const value2 = ExprUtil.getImplValue(form2, "CellType", cxt);
      const color = value2 == 1 ? "#fef3c9" : value2 == 3 ? "#ccffcc" : value2 == 2 ? "#FFFFFF" : "";
      if (color) {
        grid.setCellBackColor(rowIndex, columnIndex, color);
      }
    }
  }
};
const setDimensions$1 = (form2, fielKey, rowIndex, columnIndex) => {
  const cxt = new ViewContext(form2);
  let value2;
  switch (fielKey) {
    case "IsLock":
      value2 = ExprUtil.getImplValue(form2, "IsLock", cxt);
      setCellDimension$2(form2, "IsLockCell", rowIndex, columnIndex, value2);
      break;
    case "CellType":
      value2 = ExprUtil.getImplValue(form2, "CellType", cxt);
      setCellDimension$2(form2, "CellType", rowIndex, columnIndex, value2);
      break;
    case "ShowControlType":
      value2 = ExprUtil.getImplValue(form2, "ShowControlType", cxt);
      setCellDimension$2(form2, "ControlType", rowIndex, columnIndex, value2);
      break;
    case "ShowZBIndexID":
      value2 = ExprUtil.getImplValue(form2, "ShowZBIndexID", cxt);
      setCellDimension$2(form2, "ZBIndexID", rowIndex, columnIndex, value2);
      break;
    case "ShowZBIndexDataTypeID":
      value2 = ExprUtil.getImplValue(form2, "ShowZBIndexDataTypeID", cxt);
      setCellDimension$2(form2, "ZBIndexDataTypeID", rowIndex, columnIndex, value2);
      break;
    case "FormulaFront":
      value2 = ExprUtil.getImplValue(form2, "FormulaFront", cxt);
      setCellDimension$2(form2, "FormulaFront", rowIndex, columnIndex, value2);
      break;
    case "FormulaBack":
      value2 = ExprUtil.getImplValue(form2, "FormulaBack", cxt);
      setCellDimension$2(form2, "FormulaBack", rowIndex, columnIndex, value2);
      break;
    case "fix_dimension_keys":
      for (let i2 = 0; i2 < FIX_DIMENSION_KEYS.length; i2++) {
        value2 = ExprUtil.getImplValue(form2, "Show" + FIX_DIMENSION_KEYS[i2], cxt);
        setCellDimension$2(form2, FIX_DIMENSION_KEYS[i2], rowIndex, columnIndex, value2);
      }
      break;
    case "DynShowDimensionID":
      for (let i2 = 0; i2 < 20; i2++) {
        value2 = ExprUtil.getImplValue(form2, "DynShowDimension" + (i2 + 1) + "ID", cxt);
        setCellDimension$2(form2, "DictDimensionID" + (i2 + 1), rowIndex, columnIndex, value2);
      }
      break;
  }
};
const showColorPicker$1 = (initColor) => {
  const dialog = new ColorPickerDialog({
    color: initColor || "#ffffff"
  });
  return dialog.show();
};
funs.DeleteCellStyleInfo = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const focusRowIndex = grid.getFocusRowIndex();
  if (focusRowIndex >= 0) {
    let loc;
    loc = form2.getCellLocation("StyleRow");
    const rowIndex = TypeConvertor.toInt(grid.getCellDataAt(focusRowIndex, loc.column)[0]) - 1;
    loc = form2.getCellLocation("StyleColumn");
    const columnIndex = TypeConvertor.toInt(grid.getCellDataAt(focusRowIndex, loc.column)[0]);
    deleteCellStyle$2(form2, rowIndex, columnIndex);
  }
};
funs.ShowCellForeColor = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const initColor = "#000000";
  const selectedRange = getGridSelectedRange$2(grid);
  const color = await showColorPicker$1(initColor);
  if (!color) {
    return;
  }
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$2(form2, "ForeColor", row2, col2, color);
      grid.setCellForeColor(row2, col2, color);
    }
  }
};
funs.ShowCellBackColor = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const initColor = "#ffffff";
  const selectedRange = getGridSelectedRange$2(grid);
  const color = await showColorPicker$1(initColor);
  if (!color) {
    return;
  }
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$2(form2, "BackColor", row2, col2, color);
      grid.setCellBackColor(row2, col2, color);
    }
  }
};
funs.SplitCell = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const selectedRange = getGridSelectedRange$2(grid);
  deleteCellStyle$2(form2, selectedRange.startRow, selectedRange.startCol, "XSpan");
  deleteCellStyle$2(form2, selectedRange.startRow, selectedRange.startCol, "YSpan");
  gridSplitCell$2(grid, selectedRange.startRow, selectedRange.startCol);
};
funs.MergeCell = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  form2.getCellLocation(D0_COLUMN_KEY$1);
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const selectedRange = getGridSelectedRange$2(grid);
  const colSpan = selectedRange.width;
  const rowSpan = selectedRange.height;
  setCellStyle$2(form2, "XSpan", selectedRange.startRow, selectedRange.startCol, colSpan);
  setCellStyle$2(form2, "YSpan", selectedRange.startRow, selectedRange.startCol, rowSpan);
  gridMergeCell$2(grid, selectedRange.startRow, selectedRange.startCol, colSpan, rowSpan);
};
funs.SetCellAlignment = async (evl, name2, cxt, args) => {
  const direction = args[0], alignment = args[1], form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const selectedRange = getGridSelectedRange$2(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$2(form2, direction, row2, col2, alignment);
      gridSetAlignment$2(grid, row2, col2, direction, alignment);
    }
  }
};
funs.SetCellBorder = async (evl, name2, cxt, args) => {
  const borderLocation = args[0], form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const selectedRange = getGridSelectedRange$2(grid);
  if ("None" == borderLocation) {
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      for (let j2 = 0; j2 < selectedRange.width; j2++) {
        const col2 = selectedRange.startCol + j2;
        deleteCellStyle$2(form2, row2, col2, "TopBorder");
        deleteCellStyle$2(form2, row2, col2, "LeftBorder");
        deleteCellStyle$2(form2, row2, col2, "RightBorder");
        deleteCellStyle$2(form2, row2, col2, "BottomBorder");
        gridSetCellStyle$2(grid, row2, col2, "borderTop", "1px solid #e6e6e6");
        gridSetCellStyle$2(grid, row2, col2, "borderLeft", "1px solid #e6e6e6");
        gridSetCellStyle$2(grid, row2, col2, "borderRight", "1px solid #e6e6e6");
        gridSetCellStyle$2(grid, row2, col2, "borderBottom", "1px solid #e6e6e6");
      }
    }
    return;
  }
  if ("All" == borderLocation) {
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      for (let j2 = 0; j2 < selectedRange.width; j2++) {
        const col2 = selectedRange.startCol + j2;
        setCellStyle$2(form2, "TopBorder", row2, col2, "true");
        setCellStyle$2(form2, "LeftBorder", row2, col2, "true");
        setCellStyle$2(form2, "RightBorder", row2, col2, "true");
        setCellStyle$2(form2, "BottomBorder", row2, col2, "true");
        gridSetCellStyle$2(grid, row2, col2, "borderTop", "2px solid #000000");
        gridSetCellStyle$2(grid, row2, col2, "borderLeft", "2px solid #000000");
        gridSetCellStyle$2(grid, row2, col2, "borderRight", "2px solid #000000");
        gridSetCellStyle$2(grid, row2, col2, "borderBottom", "2px solid #000000");
      }
    }
    return;
  }
  if ("Outer" == borderLocation || "Top" == borderLocation) {
    const row2 = selectedRange.startRow;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$2(form2, "TopBorder", row2, col2, "true");
      gridSetCellStyle$2(grid, row2, col2, "borderTop", "2px solid #000000");
    }
  }
  if ("Outer" == borderLocation || "Left" == borderLocation) {
    const col2 = selectedRange.startCol;
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      setCellStyle$2(form2, "LeftBorder", row2, col2, "true");
      gridSetCellStyle$2(grid, row2, col2, "borderLeft", "2px solid #000000");
    }
  }
  if ("Outer" == borderLocation || "Right" == borderLocation) {
    const col2 = selectedRange.startCol + selectedRange.width - 1;
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      setCellStyle$2(form2, "RightBorder", row2, col2, "true");
      gridSetCellStyle$2(grid, row2, col2, "borderRight", "2px solid #000000");
    }
  }
  if ("Outer" == borderLocation || "Bottom" == borderLocation) {
    const row2 = selectedRange.startRow + selectedRange.height - 1;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$2(form2, "BottomBorder", row2, col2, j2);
      gridSetCellStyle$2(grid, row2, col2, "borderBottom", "2px solid #000000");
    }
  }
};
funs.SetCellFontName = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, fontName = ExprUtil.getImplValue(form2, "FontNameList", cxt);
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const selectedRange = getGridSelectedRange$2(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$2(form2, "FontName", row2, col2, fontName);
      gridSetCellStyle$2(grid, row2, col2, "fontFamily", fontName == "" ? "" : fontName);
    }
  }
};
funs.SetCellFontSize = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, fontSize = ExprUtil.getImplValue(form2, "FontSizeList", cxt);
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const selectedRange = getGridSelectedRange$2(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$2(form2, "FontSize", row2, col2, fontSize);
      gridSetCellStyle$2(grid, row2, col2, "fontSize", fontSize <= 0 ? "" : fontSize + "px");
    }
  }
};
funs.SetCellFontStyle = async (evl, name2, cxt, args) => {
  const fontStyle = args[0], form2 = cxt.form;
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const selectedRange = getGridSelectedRange$2(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      const value2 = getCellStyle$2(form2, fontStyle, row2, col2, 0);
      setCellStyle$2(form2, fontStyle, row2, col2, value2 == 1 ? 0 : 1);
      gridSetFontStyle$2(grid, row2, col2, fontStyle, value2 == 1 ? 0 : 1);
    }
  }
};
funs.setFixedGridCellFontByJSON = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, gridKey = args[0], cellFonts = JSON.parse(args[1]);
  const grid = form2.getComponent(gridKey);
  for (let cellKey in cellFonts) {
    const font = cellFonts[cellKey];
    const loc = form2.getCellLocation(cellKey);
    const row2 = loc.row, col2 = loc.column;
    if (font.bold) {
      gridSetFontStyle$2(grid, row2, col2, "Bold", 1);
    }
    if (font.italic) {
      gridSetFontStyle$2(grid, row2, col2, "Italic", 1);
    }
    if (font.italic) {
      gridSetFontStyle$2(grid, row2, col2, "Italic", 1);
    }
    if (font.name) {
      gridSetCellStyle$2(grid, row2, col2, "fontFamily", font.name);
    }
    if (font.size > 0) {
      gridSetCellStyle$2(grid, row2, col2, "fontSize", font.size + "px");
    }
  }
};
funs.AddColumn = async (evl, name2, cxt, args) => {
  const activeForm = ERPDESIGNER.UI.getActiveERPForm(), doc = activeForm.document, diff = ERPDESIGNER.Diff;
  diff.formKey = activeForm.formKey;
  const form2 = cxt.form;
  form2.getCellLocation(D0_COLUMN_KEY$1);
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  const columnIndex = grid.getColumnCount();
  const Key = "D" + grid.getColumnCount();
  diff.key = Key;
  diff.reserveOne = Key;
  diff.reserveTwo = "true";
  diff.caption = getExcelColumnLabel$1(columnIndex - 1);
  diff.controlType = "TextEditor";
  diff.sideKey = "D" + (grid.getColumnCount() - 1);
  diff.insertAfter = true;
  diff.parentKey = grid.key;
  diff.metaObjectType = "GridField";
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  const successFlag = await ERPDESIGNER.Service.commitDiff(activeForm.formKey, [diff], "", doc, activeForm.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  saveXmlFile$1(doc);
};
funs.DeleteColumn = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, doc = form2.getDocument();
  const grid = getGridByColumnKey$2(form2, D0_COLUMN_KEY$1);
  if (args && args[0]) {
    if (grid.getColumnCount() - 1 <= args[0]) {
      throw new Error("当前列'" + getExcelColumnLabel$1(grid.getColumnCount() - 2) + "'不能删除,因为已经设置了模板!");
    }
  }
  const allDiv = document.querySelectorAll("div[id$='_DeleteColumn']");
  allDiv && allDiv.forEach((div) => {
    div.style.pointerEvents = "none";
  });
  const Key = "D" + (grid.getColumnCount() - 1);
  const activeForm = ERPDESIGNER.UI.getActiveERPForm();
  const diff = ERPDESIGNER.Diff;
  diff.formKey = activeForm.formKey;
  diff.key = Key;
  diff.metaObjectType = "GridField";
  diff.parentKey = grid.key;
  diff.isDelete = true;
  const successFlag = await ERPDESIGNER.Service.commitDiff(activeForm.formKey, [diff], "", doc, activeForm.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  saveXmlFile$1(doc);
};
const saveXmlFile$1 = async (doc) => {
  const activeForm = ERPDESIGNER.UI.getActiveERPForm();
  const formKey = activeForm.formKey;
  const params = {
    cmd: "SaveFilesByFormKey",
    service: "DesignService",
    uiFormKey: formKey,
    entryParas: ""
  };
  const uiCommands = await new Request(activeForm).getData(params);
  ERPDESIGNER.selectedComponentKey = null;
  const allDiv = document.querySelectorAll("div[id$='_DeleteColumn']");
  allDiv && allDiv.forEach((div) => {
    div.style.pointerEvents = "block";
  });
  if (!uiCommands || uiCommands.length == 0) {
    return;
  }
  for (let i2 = 0; i2 < uiCommands.length; i2++) {
    await ERPDESIGNER.UI.doUICommand(activeForm, uiCommands[i2]);
  }
  let reportModelDetailTable = null;
  const tabls = doc.tbls;
  for (let i2 = 0; i2 < tabls.length; i2++) {
    if (tabls[i2] && tabls[i2].key && tabls[i2].key.toUpperCase() == "EFI_REPORTMODEL_DETAIL") {
      reportModelDetailTable = tabls[i2];
    }
  }
  if (!reportModelDetailTable) {
    return;
  }
  for (let i2 = 0; i2 < reportModelDetailTable.rows.length; i2++) {
    reportModelDetailTable.rows[i2].state = 0;
  }
};
const getExcelColumnLabel$1 = (num) => {
  let temp = "";
  const i2 = Math.floor(Math.log(25 * num / 26 + 1) / Math.log(26)) + 1;
  if (i2 > 1) {
    let sub = num - 26 * (Math.pow(26, i2 - 1) - 1) / 25;
    for (let j2 = i2; j2 > 0; j2--) {
      temp = temp + String.fromCharCode(sub / Math.pow(26, j2 - 1) + 65);
      sub = sub % Math.pow(26, j2 - 1);
    }
  } else {
    temp = temp + String.fromCharCode(num + 65);
  }
  return temp;
};
const FI_ReportModeFun = funs;
const getGridByColumnKey$1 = function(form2, columnKey) {
  const loc = form2.getCellLocation(columnKey);
  const gridKey = loc.key;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  return grid;
};
const setCellDimension$1 = function(form2, key2, rowIndex, columnIndex, value2) {
  const grid = getGridByColumnKey$1(form2, "Column0");
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.dimension) {
    cellData.dimension = {};
  }
  if (value2 && value2 instanceof ItemData) {
    value2 = value2.getOID();
  }
  cellData.dimension[key2] = value2;
};
const getCellDimension$1 = function(form2, key2, rowIndex, columnIndex, defaultValue) {
  const grid = getGridByColumnKey$1(form2, "Column0");
  if (!grid || !grid.rendered) {
    return defaultValue;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return defaultValue;
  }
  if (!cellData.dimension) {
    return defaultValue;
  }
  const value2 = cellData.dimension[key2];
  return value2 ? value2 : defaultValue;
};
const setCellStyle$1 = function(form2, key2, rowIndex, columnIndex, value2) {
  const grid = getGridByColumnKey$1(form2, "Column0");
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.style) {
    cellData.style = {};
  }
  cellData.style[key2] = value2;
};
const getCellStyle$1 = function(form2, key2, rowIndex, columnIndex, defaultValue) {
  const grid = getGridByColumnKey$1(form2, "Column0");
  if (!grid || !grid.rendered) {
    return defaultValue;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return defaultValue;
  }
  if (!cellData.style) {
    return defaultValue;
  }
  const value2 = cellData.style[key2];
  return value2 ? value2 : defaultValue;
};
const deleteCellStyle$1 = function(form2, rowIndex, columnIndex, key2) {
  const grid = getGridByColumnKey$1(form2, "Column0");
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.style) {
    return;
  }
  if (key2) {
    delete cellData.style[key2];
  } else {
    delete cellData.style;
  }
};
const getGridSelectedRange$1 = function(grid) {
  const focusRowIndex = grid.getFocusRowIndex();
  if (focusRowIndex < 0) {
    throw new Error("未选择单元格");
  }
  const selectionModel = grid.getSelection();
  return {
    startCol: selectionModel.left,
    startRow: selectionModel.top,
    width: selectionModel.right - selectionModel.left + 1,
    height: selectionModel.bottom - selectionModel.top + 1
  };
};
const gridSetCellStyle$1 = function(grid, rowIndex, colIndex, style, value2) {
  if (!grid.rendered) {
    return;
  }
  const $t = grid.impl.el.$table;
  const cell = $t.getCell(rowIndex, colIndex);
  if (!cell) {
    return;
  }
  cell.$addStyle(style, value2 ? value2 + "" : "unset");
};
const gridSetFontStyle$1 = function(grid, rowIndex, colIndex, style, value2) {
  if ("Bold" == style) {
    gridSetCellStyle$1(grid, rowIndex, colIndex, "fontWeight", value2 == 1 ? "bold" : "normal");
  }
  if ("Italic" == style) {
    gridSetCellStyle$1(grid, rowIndex, colIndex, "fontStyle", value2 == 1 ? "italic" : "normal");
  }
  if ("Underline" == style) {
    gridSetCellStyle$1(grid, rowIndex, colIndex, "textDecoration", value2 == 1 ? "underline" : "none");
  }
};
const gridSetAlignment$1 = function(grid, rowIndex, colIndex, direction, alignment) {
  if ("Horizontal" == direction) {
    gridSetCellStyle$1(grid, rowIndex, colIndex, "textAlign", alignment);
  }
};
const gridSplitCell$1 = function(grid, rowIndex, colIndex) {
  if (!grid.rendered) {
    return;
  }
  const $t = grid.impl.el.$table;
  let cell = $t.getCell(rowIndex, colIndex);
  if (!cell) {
    return;
  }
  const cellColSpan = cell.getAttr("colspan") || 1;
  const cellRowSpan = cell.getAttr("rowspan") || 1;
  if (cellColSpan <= 1 && cellRowSpan <= 1) {
    return;
  }
  const rowSpan = cellRowSpan, colSpan = cellColSpan;
  cell.$setAttr("colspan", 1);
  cell.$setAttr("rowspan", 1);
  for (let j2 = 0; j2 < rowSpan; j2++) {
    for (let i2 = 0; i2 < colSpan; i2++) {
      if (i2 > 0 || j2 > 0) {
        cell = $t.getCell(rowIndex + j2, colIndex + i2);
        cell.$removeClass("ui-hidden");
      }
    }
  }
};
const gridMergeCell$1 = function(grid, rowIndex, colIndex, colSpan, rowSpan) {
  if (!grid.rendered) {
    return;
  }
  const $t = grid.impl.el.$table;
  let cell = $t.getCell(rowIndex, colIndex);
  if (!cell) {
    return;
  }
  if (colSpan > 1) {
    cell.$setAttr("colspan", colSpan);
  }
  if (rowSpan > 1) {
    cell.$setAttr("rowspan", rowSpan);
  }
  colSpan = colSpan > 1 ? colSpan : 1;
  rowSpan = rowSpan > 1 ? rowSpan : 1;
  for (let j2 = 0; j2 < rowSpan; j2++) {
    for (let i2 = 0; i2 < colSpan; i2++) {
      if (i2 > 0 || j2 > 0) {
        cell = $t.getCell(rowIndex + j2, colIndex + i2);
        cell.$addClass("ui-hidden");
      }
    }
  }
};
const showCellDimensionInfo$1 = function(form2, rowIndex, columnIndex) {
  form2.setComponentValue("ShowRowIndex", rowIndex, false);
  form2.setComponentValue("ShowColumnIndex", columnIndex, false);
  const showCellType = getCellDimension$1(form2, "CellType", rowIndex, columnIndex, "Normal");
  form2.setComponentValue("ShowCellType", showCellType, false);
  const showRefKey = getCellDimension$1(form2, "RefKey", rowIndex, columnIndex, "");
  form2.setComponentValue("ShowRefKey", showRefKey, false);
  const showDataValue = getCellDimension$1(form2, "DataValue", rowIndex, columnIndex, "");
  form2.setComponentValue("ShowDataValue", showDataValue, false);
  const showFormula = getCellDimension$1(form2, "Formula", rowIndex, columnIndex, "");
  form2.setComponentValue("ShowFormula", showFormula, false);
  const showRawType = getCellDimension$1(form2, "RawType", rowIndex, columnIndex, 1);
  form2.setComponentValue("ShowRawType", showRawType, false);
  const showCaptionType = getCellDimension$1(form2, "CaptionType", rowIndex, columnIndex, 1);
  form2.setComponentValue("ShowCaptionType", showCaptionType, false);
  const showIsGroupKey = getCellDimension$1(form2, "IsGroupKey", rowIndex, columnIndex, 0);
  form2.setComponentValue("ShowIsGroupKey", showIsGroupKey, false);
};
const showCellStyleInfo$1 = function(form2, rowIndex, columnIndex) {
  const fontName = getCellStyle$1(form2, "FontName", rowIndex, columnIndex, "");
  form2.setComponentValue("FontNameList", fontName, false);
  const fontSize = getCellStyle$1(form2, "FontSize", rowIndex, columnIndex, "");
  form2.setComponentValue("FontSizeList", fontSize, false);
};
const saveXmlFile = async function(doc) {
  const activeForm = ErpDesignerUI.getActiveERPForm();
  const formKey = activeForm.formKey;
  const params = {
    cmd: "SaveFilesByFormKey",
    service: "DesignService",
    uiFormKey: formKey,
    entryParas: ""
  };
  const uiCommands = await new Request(activeForm).getData(params);
  ERPDESIGNER.selectedComponentKey = null;
  const allDiv = document.querySelectorAll("div[id$='_DeleteColumn']");
  allDiv && allDiv.forEach((div) => {
    div.style.pointerEvents = "block";
  });
  if (!uiCommands || uiCommands.length == 0) {
    return;
  }
  for (let i2 = 0; i2 < uiCommands.length; i2++) {
    await ErpDesignerUI.doUICommand(activeForm, uiCommands[i2]);
  }
  let reportModelDetailTable = null;
  let tables = doc.tbls;
  for (let i2 = 0; i2 < tables.length; i2++) {
    if (tables[i2] && tables[i2].key && tables[i2].key.toUpperCase() == "EGS_CELLDIMRPTCELLCAPTION") {
      reportModelDetailTable = tables[i2];
    }
  }
  if (!reportModelDetailTable) {
    return;
  }
  for (let i2 = 0; i2 < reportModelDetailTable.rows.length; i2++) {
    reportModelDetailTable.rows[i2].state = 0;
  }
};
const getExcelColumnLabel = function(num) {
  let temp = "";
  const i2 = Math.floor(Math.log(25 * num / 26 + 1) / Math.log(26)) + 1;
  if (i2 > 1) {
    let sub = num - 26 * (Math.pow(26, i2 - 1) - 1) / 25;
    for (let j2 = i2; j2 > 0; j2--) {
      temp = temp + String.fromCharCode(sub / Math.pow(26, j2 - 1) + 65);
      sub = sub % Math.pow(26, j2 - 1);
    }
  } else {
    temp = temp + String.fromCharCode(num + 65);
  }
  return temp;
};
const showColorPicker = (initColor) => {
  const dialog = new ColorPickerDialog({
    color: initColor || "#ffffff"
  });
  return dialog.show();
};
const validateCellData = function(form2, grid) {
  const cxt = new ViewContext(form2);
  const showRowIndex = ExprUtil.getImplValue(form2, "ShowRowIndex", cxt);
  const showColumnIndex = ExprUtil.getImplValue(form2, "ShowColumnIndex", cxt);
  if (showRowIndex < 0 || showColumnIndex < 0) {
    return;
  }
  const showCellType = ExprUtil.getImplValue(form2, "ShowCellType", cxt);
  const showRefKey = ExprUtil.getImplValue(form2, "ShowRefKey", cxt);
  const showDataValue = ExprUtil.getImplValue(form2, "ShowDataValue", cxt);
  const showFormula = ExprUtil.getImplValue(form2, "ShowFormula", cxt);
  if (showCellType === "Data" && !showRefKey) {
    grid.setFocusCell(showRowIndex, showColumnIndex);
    throw new Error("请选择'引用字段'！");
  }
  if (showCellType === "GlobalDimension" || showCellType === "ColDimension") {
    if (!showRefKey) {
      grid.setFocusCell(showRowIndex, showColumnIndex);
      throw new Error("请选择'引用字段'！");
    }
    if (!showDataValue && !showFormula) {
      grid.setFocusCell(showRowIndex, showColumnIndex);
      throw new Error("请填写 '值' 或 '表达式'!");
    }
  }
  if (showCellType === "RowDimension") {
    if (!showRefKey) {
      grid.setFocusCell(showRowIndex, showColumnIndex);
      throw new Error("请选择'引用字段'！");
    }
  }
};
const Rpt_RenderCellCaption = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, doc = form2.getDocument(), loc = form2.getCellLocation("Column1");
  const grid = getGridByColumnKey$1(form2, "Column0");
  const headTable = doc.getByKey("EGS_CellDimensionReportModel");
  headTable.first();
  let tableWidthStr = headTable.getByKey("TableWidth");
  const tableWidths = tableWidthStr ? tableWidthStr.split(";") : [];
  let isChanged = false;
  for (let i2 = tableWidths.length - 1; i2 >= 0; i2--) {
    const width = parseInt(tableWidths[i2], 10);
    const column = grid.getColumnAt(loc.column + i2);
    if (!column) {
      continue;
    }
    if (!isChanged) {
      isChanged = column.width == width;
    }
    if (isChanged) {
      column.width = width;
    }
  }
  if (isChanged) {
    grid.refreshGrid();
  }
  if (!grid.rendered) {
    return;
  }
  grid.impl.el.$table.grid.bDiv.addPostpatchHook(() => {
    const dimensionTable = doc.getByKey("EGS_CellDimRptCellData");
    if (!dimensionTable) {
      throw new Error("配置中不存在EGS_CellDimRptCellData");
    }
    dimensionTable.beforeFirst();
    while (dimensionTable.next()) {
      const rowIndex = TypeConvertor.toInt(dimensionTable.getByKey("RowIndex")) - 1;
      const columnIndex = TypeConvertor.toInt(dimensionTable.getByKey("ColumnIndex")) - 1;
      for (let i2 = 0, count = dimensionTable.getColumnCount(); i2 < count; i2++) {
        const colKey = dimensionTable.getCol(i2).getKey();
        if (SystemField.isSystemField(colKey)) {
          continue;
        }
        let value2 = dimensionTable.getByKey(colKey);
        value2 = value2 === "null" ? "" : value2;
        setCellDimension$1(form2, colKey, rowIndex, columnIndex + 1, value2);
        if ("CellType" == colKey) {
          const color = value2 == 1 ? "#fef3c9" : value2 == 3 ? "#ccffcc" : "";
          const cellData = grid.getCellDataAt(rowIndex, loc.column + columnIndex);
          if (cellData) {
            grid.setCellBackColor(rowIndex, loc.column + columnIndex, color);
          }
        }
      }
    }
    const styleTable = doc.getByKey("EGS_CellDimRptCellStyle");
    if (!styleTable) {
      throw new Error("配置中不存在EGS_CellDimRptCellStyle");
    }
    styleTable.beforeFirst();
    while (styleTable.next()) {
      const rowIndex = TypeConvertor.toInt(styleTable.getByKey("RowIndex")) - 1;
      const columnIndex = TypeConvertor.toInt(styleTable.getByKey("ColumnIndex")) - 1;
      let xSpan = 0, ySpan = 0;
      for (let i2 = 0, count = styleTable.getColumnCount(); i2 < count; i2++) {
        const colKey = styleTable.getCol(i2).getKey();
        if (SystemField.isSystemField(colKey)) {
          continue;
        }
        let value2 = styleTable.getByKey(colKey);
        value2 = value2 === "null" ? "" : value2;
        if (!value2) {
          continue;
        }
        setCellStyle$1(form2, colKey, rowIndex, columnIndex + 1, value2);
        if ("ForeColor" == colKey) {
          grid.setCellForeColor(rowIndex, loc.column + columnIndex, value2);
        }
        if ("BackColor" == colKey) {
          grid.setCellBackColor(rowIndex, loc.column + columnIndex, value2);
        }
        if ("XSpan" == colKey) {
          xSpan = TypeConvertor.toInt(value2);
        }
        if ("YSpan" == colKey) {
          ySpan = TypeConvertor.toInt(value2);
        }
        if ("Horizontal" == colKey || "Vertical" == colKey) {
          gridSetAlignment$1(grid, rowIndex, loc.column + columnIndex, colKey, value2);
        }
        if (("Bold" == colKey || "Italic" == colKey) && value2 == 1) {
          gridSetFontStyle$1(grid, rowIndex, loc.column + columnIndex, colKey, value2);
        }
        if ("FontName" == colKey && value2 != "") {
          gridSetCellStyle$1(grid, rowIndex, loc.column + columnIndex, "fontFamily", value2);
        }
        if ("FontSize" == colKey && value2 > 0) {
          gridSetCellStyle$1(grid, rowIndex, loc.column + columnIndex, "fontSize", value2 + "px");
        }
        if ("LeftBorder" == colKey && value2 == "true") {
          gridSetCellStyle$1(grid, rowIndex, loc.column + columnIndex, "borderLeft", "2px solid #000000");
        }
        if ("TopBorder" == colKey && value2 == "true") {
          gridSetCellStyle$1(grid, rowIndex, loc.column + columnIndex, "borderTop", "2px solid #000000");
        }
        if ("RightBorder" == colKey && value2 == "true") {
          gridSetCellStyle$1(grid, rowIndex, loc.column + columnIndex, "borderRight", "2px solid #000000");
        }
        if ("BottomBorder" == colKey && value2 == "true") {
          gridSetCellStyle$1(grid, rowIndex, loc.column + columnIndex, "borderBottom", "2px solid #000000");
        }
      }
      if (xSpan > 0 || ySpan > 0) {
        gridMergeCell$1(grid, rowIndex, loc.column + columnIndex, xSpan, ySpan);
      }
    }
  });
};
const Rpt_ShowCellInfo = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const rowIndex = grid.getFocusRowIndex();
  const columnIndex = grid.getFocusColIndex();
  if (rowIndex < 0 || columnIndex < 0) {
    return;
  }
  const showRowIndex = ExprUtil.getImplValue(form2, "ShowRowIndex", cxt);
  const showColumnIndex = ExprUtil.getImplValue(form2, "ShowColumnIndex", cxt);
  if (rowIndex != showRowIndex || columnIndex != showColumnIndex) {
    validateCellData(form2, grid);
  }
  if (columnIndex > 0) {
    form2.setComponentValue("Row", rowIndex + 1, false);
    form2.setComponentValue("COL", getExcelColumnLabel(columnIndex - 1), false);
  }
  showCellDimensionInfo$1(form2, rowIndex, columnIndex);
  showCellStyleInfo$1(form2, rowIndex, columnIndex);
};
const Rpt_SaveReport = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, grid = getGridByColumnKey$1(form2, "Column0");
  validateCellData(form2, grid);
  const reportModel = {}, dimensions = {}, styles = {}, columnWidths = [];
  const freezeRow = cxt.form.getComponent("FreezeRow").value, freezeColumn = cxt.form.getComponent("FreezeColumn").value;
  const rowCount = grid.getRowCount();
  for (let columnIndex = 1; columnIndex < grid.getColumnCount(); columnIndex++) {
    columnWidths.push(grid.getColumnAt(columnIndex).width);
    for (let rowIndex = 0; rowIndex < rowCount; rowIndex++) {
      const cellData = grid.getCellDataAt(rowIndex, columnIndex);
      if (!cellData) {
        continue;
      }
      const dataKey = getExcelColumnLabel(columnIndex - 1) + "" + (rowIndex + 1);
      const dimension = cellData.dimension;
      if (dimension) {
        dimension["RowIndex"] = rowIndex + 1;
        dimension["ColumnIndex"] = columnIndex;
        dimensions[dataKey] = dimension;
      }
      const style = cellData.style;
      if (style) {
        style["RowIndex"] = rowIndex + 1;
        style["ColumnIndex"] = columnIndex;
        styles[dataKey] = style;
      }
    }
  }
  if (rowCount > 0) {
    reportModel.freezeRow = freezeRow == null ? 0 : freezeRow;
    reportModel.freezeColumn = freezeColumn == null ? "" : freezeColumn;
    reportModel.dimensions = dimensions;
    reportModel.styles = styles;
    reportModel.columnWidths = columnWidths;
    form2.reportModel = reportModel;
    return JSON.parse(JSON.stringify(form2.reportModel));
  }
  return "";
};
const Rpt_ClearCellInfo = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const showRowIndex = ExprUtil.getImplValue(form2, "ShowRowIndex", cxt);
  const showColumnIndex = ExprUtil.getImplValue(form2, "ShowColumnIndex", cxt);
  if (showRowIndex < 0 || showColumnIndex < 0) {
    return;
  }
  setCellDimension$1(form2, "DataValue", showRowIndex, showColumnIndex, "");
};
const Rpt_SetCellInfo = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const showRowIndex = ExprUtil.getImplValue(form2, "ShowRowIndex", cxt);
  const showColumnIndex = ExprUtil.getImplValue(form2, "ShowColumnIndex", cxt);
  if (showRowIndex < 0 || showColumnIndex < 0) {
    return;
  }
  const grid = getGridByColumnKey$1(form2, "Column0");
  const loc = form2.getCellLocation("Column0");
  await grid.setValueAt(showRowIndex, loc.column, 1, true, true, false);
  const showCellType = ExprUtil.getImplValue(form2, "ShowCellType", cxt);
  setCellDimension$1(form2, "CellType", showRowIndex, showColumnIndex, showCellType);
  const showRefKey = ExprUtil.getImplValue(form2, "ShowRefKey", cxt);
  setCellDimension$1(form2, "RefKey", showRowIndex, showColumnIndex, showRefKey);
  const showDataValue = ExprUtil.getImplValue(form2, "ShowDataValue", cxt);
  setCellDimension$1(form2, "DataValue", showRowIndex, showColumnIndex, showDataValue);
  const showFormula = ExprUtil.getImplValue(form2, "ShowFormula", cxt);
  setCellDimension$1(form2, "Formula", showRowIndex, showColumnIndex, showFormula);
  const showRawType = ExprUtil.getImplValue(form2, "ShowRawType", cxt);
  setCellDimension$1(form2, "RawType", showRowIndex, showColumnIndex, showRawType);
  const showCaptionType = ExprUtil.getImplValue(form2, "ShowCaptionType", cxt);
  setCellDimension$1(form2, "CaptionType", showRowIndex, showColumnIndex, showCaptionType);
  const showIsGroupKey = ExprUtil.getImplValue(form2, "ShowIsGroupKey", cxt);
  setCellDimension$1(form2, "IsGroupKey", showRowIndex, showColumnIndex, showIsGroupKey);
  const color = showCellType == "RowDimension" || showCellType == "ColDimension" || showCellType == "GlobalDimension" ? "#fef3c9" : showCellType == "Data" ? "#ccffcc" : "";
  grid.setCellBackColor(showRowIndex, showColumnIndex, color);
  setCellStyle$1(form2, "BackColor", showRowIndex, showColumnIndex, color);
};
const Rpt_DeleteCellStyleInfo = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, rowIndex = args[0], columnIndex = args[1];
  deleteCellStyle$1(form2, rowIndex - 1, columnIndex);
  const grid = getGridByColumnKey$1(form2, "Column0");
  grid.setCellBackColor(rowIndex - 1, columnIndex, "");
};
const Rpt_DeleteCellData = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, rowIndex = args[0], columnIndex = args[1];
  const grid = getGridByColumnKey$1(form2, "Column0");
  grid.setValueAt(rowIndex - 1, columnIndex, "", true, true, false);
  const cellData = grid.getCellDataAt(rowIndex - 1, columnIndex);
  delete cellData.dimension;
  delete cellData.style;
};
const Rpt_ShowCellForeColor = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const initColor = "#000000";
  const selectedRange = getGridSelectedRange$1(grid);
  const color = await showColorPicker(initColor);
  if (!color) {
    return;
  }
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$1(form2, "ForeColor", row2, col2, color);
      grid.setCellForeColor(row2, col2, color);
    }
  }
  if (AutoRecord.AutoRecord == true) {
    RecordCase.requestRecordStep("录入:字体颜色:" + color);
    RecordCase.requestRecordStep("点击:确定");
  }
};
const Rpt_ShowCellBackColor = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const initColor = "#ffffff";
  const selectedRange = getGridSelectedRange$1(grid);
  const color = await showColorPicker(initColor);
  if (!color) {
    return;
  }
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$1(form2, "BackColor", row2, col2, color);
      grid.setCellBackColor(row2, col2, color);
    }
  }
  if (AutoRecord.AutoRecord == true) {
    RecordCase.requestRecordStep("录入:背景色:" + color);
    RecordCase.requestRecordStep("点击:确定");
  }
};
const Rpt_SplitCell = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const selectedRange = getGridSelectedRange$1(grid);
  deleteCellStyle$1(form2, selectedRange.startRow, selectedRange.startCol, "XSpan");
  deleteCellStyle$1(form2, selectedRange.startRow, selectedRange.startCol, "YSpan");
  gridSplitCell$1(grid, selectedRange.startRow, selectedRange.startCol);
};
const Rpt_MergeCell = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const selectedRange = getGridSelectedRange$1(grid);
  const colSpan = selectedRange.width;
  const rowSpan = selectedRange.height;
  const startRow = selectedRange.startRow;
  const startCol = selectedRange.startCol;
  setCellStyle$1(form2, "XSpan", startRow, startCol, colSpan);
  setCellStyle$1(form2, "YSpan", startRow, startCol, rowSpan);
  gridMergeCell$1(grid, startRow, startCol, colSpan, rowSpan);
  for (let j2 = 0; j2 < rowSpan; j2++) {
    for (let i2 = 0; i2 < colSpan; i2++) {
      if (j2 < 1 && i2 < 1)
        continue;
      const currentRow = startRow + j2;
      const currentCol = startCol + i2;
      grid.setValueAt(currentRow, currentCol, "", true, true, false);
      const cellData = grid.getCellDataAt(currentRow, currentCol);
      delete cellData.dimension;
      delete cellData.style;
    }
  }
};
const Rpt_SetCellAlignment = async (evl, name2, cxt, args) => {
  const direction = args[0], alignment = args[1], form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const selectedRange = getGridSelectedRange$1(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$1(form2, direction, row2, col2, alignment);
      gridSetAlignment$1(grid, row2, col2, direction, alignment);
    }
  }
};
const Rpt_SetCellBorder = async (evl, name2, cxt, args) => {
  const borderLocation = args[0], form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const selectedRange = getGridSelectedRange$1(grid);
  if ("None" == borderLocation) {
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      for (let j2 = 0; j2 < selectedRange.width; j2++) {
        const col2 = selectedRange.startCol + j2;
        deleteCellStyle$1(form2, row2, col2, "TopBorder");
        deleteCellStyle$1(form2, row2, col2, "LeftBorder");
        deleteCellStyle$1(form2, row2, col2, "RightBorder");
        deleteCellStyle$1(form2, row2, col2, "BottomBorder");
        gridSetCellStyle$1(grid, row2, col2, "borderTop", "1px solid #e6e6e6");
        gridSetCellStyle$1(grid, row2, col2, "borderLeft", "1px solid #e6e6e6");
        gridSetCellStyle$1(grid, row2, col2, "borderRight", "1px solid #e6e6e6");
        gridSetCellStyle$1(grid, row2, col2, "borderBottom", "1px solid #e6e6e6");
      }
    }
    return;
  }
  if ("All" == borderLocation) {
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      for (let j2 = 0; j2 < selectedRange.width; j2++) {
        const col2 = selectedRange.startCol + j2;
        setCellStyle$1(form2, "TopBorder", row2, col2, "true");
        setCellStyle$1(form2, "LeftBorder", row2, col2, "true");
        setCellStyle$1(form2, "RightBorder", row2, col2, "true");
        setCellStyle$1(form2, "BottomBorder", row2, col2, "true");
        gridSetCellStyle$1(grid, row2, col2, "borderTop", "2px solid #000000");
        gridSetCellStyle$1(grid, row2, col2, "borderLeft", "2px solid #000000");
        gridSetCellStyle$1(grid, row2, col2, "borderRight", "2px solid #000000");
        gridSetCellStyle$1(grid, row2, col2, "borderBottom", "2px solid #000000");
      }
    }
    return;
  }
  if ("Outer" == borderLocation || "Top" == borderLocation) {
    const row2 = selectedRange.startRow;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$1(form2, "TopBorder", row2, col2, "true");
      gridSetCellStyle$1(grid, row2, col2, "borderTop", "2px solid #000000");
    }
  }
  if ("Outer" == borderLocation || "Left" == borderLocation) {
    const col2 = selectedRange.startCol;
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      setCellStyle$1(form2, "LeftBorder", row2, col2, "true");
      gridSetCellStyle$1(grid, row2, col2, "borderLeft", "2px solid #000000");
    }
  }
  if ("Outer" == borderLocation || "Right" == borderLocation) {
    const col2 = selectedRange.startCol + selectedRange.width - 1;
    for (let i2 = 0; i2 < selectedRange.height; i2++) {
      const row2 = selectedRange.startRow + i2;
      setCellStyle$1(form2, "RightBorder", row2, col2, "true");
      gridSetCellStyle$1(grid, row2, col2, "borderRight", "2px solid #000000");
    }
  }
  if ("Outer" == borderLocation || "Bottom" == borderLocation) {
    const row2 = selectedRange.startRow + selectedRange.height - 1;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$1(form2, "BottomBorder", row2, col2, "true");
      gridSetCellStyle$1(grid, row2, col2, "borderBottom", "2px solid #000000");
    }
  }
};
const Rpt_SetCellFontName = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, fontName = ExprUtil.getImplValue(form2, "FontNameList", cxt);
  const grid = getGridByColumnKey$1(form2, "Column0");
  const selectedRange = getGridSelectedRange$1(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$1(form2, "FontName", row2, col2, fontName);
      gridSetCellStyle$1(grid, row2, col2, "fontFamily", fontName == "" ? "" : fontName);
    }
  }
};
const Rpt_SetCellFontSize = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, fontSize = ExprUtil.getImplValue(form2, "FontSizeList", cxt);
  const grid = getGridByColumnKey$1(form2, "Column0");
  const selectedRange = getGridSelectedRange$1(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      setCellStyle$1(form2, "FontSize", row2, col2, fontSize);
      gridSetCellStyle$1(grid, row2, col2, "fontSize", fontSize <= 0 ? "" : fontSize + "px");
    }
  }
};
const Rpt_SetCellFontStyle = async (evl, name2, cxt, args) => {
  const fontStyle = args[0], form2 = cxt.form;
  const grid = getGridByColumnKey$1(form2, "Column0");
  const selectedRange = getGridSelectedRange$1(grid);
  for (let i2 = 0; i2 < selectedRange.height; i2++) {
    const row2 = selectedRange.startRow + i2;
    for (let j2 = 0; j2 < selectedRange.width; j2++) {
      const col2 = selectedRange.startCol + j2;
      const value2 = getCellStyle$1(form2, fontStyle, row2, col2, 0);
      setCellStyle$1(form2, fontStyle, row2, col2, value2 == 1 ? 0 : 1);
      gridSetFontStyle$1(grid, row2, col2, fontStyle, value2 == 1 ? 0 : 1);
    }
  }
};
const Rpt_setFixedGridCellFontByJSON = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, gridKey = args[0], cellFonts = JSON.parse(args[1]);
  const grid = form2.getComponent(gridKey);
  for (let cellKey in cellFonts) {
    const font = cellFonts[cellKey];
    const loc = form2.getCellLocation(cellKey);
    const row2 = loc.row, col2 = loc.column;
    if (font.bold) {
      gridSetFontStyle$1(grid, row2, col2, "Bold", 1);
    }
    if (font.italic) {
      gridSetFontStyle$1(grid, row2, col2, "Italic", 1);
    }
    if (font.italic) {
      gridSetFontStyle$1(grid, row2, col2, "Italic", 1);
    }
    if (font.name) {
      gridSetCellStyle$1(grid, row2, col2, "fontFamily", font.name);
    }
    if (font.size > 0) {
      gridSetCellStyle$1(grid, row2, col2, "fontSize", font.size + "px");
    }
  }
};
const Rpt_AddColumn = async (evl, name2, cxt, args) => {
  const activeForm = ErpDesignerUI.getActiveERPForm(), doc = activeForm.document, diff = ERPDESIGNER.Diff;
  diff.formKey = activeForm.formKey;
  const form2 = cxt.form;
  form2.getCellLocation("Column0");
  const grid = getGridByColumnKey$1(form2, "Column0");
  const columnIndex = grid.getColumnCount();
  const Key = "Column" + grid.getColumnCount();
  diff.key = Key;
  diff.reserveOne = Key;
  diff.reserveTwo = "true";
  diff.caption = getExcelColumnLabel(columnIndex - 1);
  diff.controlType = "TextEditor";
  diff.sideKey = "Column" + (grid.getColumnCount() - 1);
  diff.insertAfter = true;
  diff.parentKey = grid.key;
  diff.metaObjectType = "GridField";
  if (form2.entryParas && form2.getDefContainer() && form2.paras.map.FormKey) {
    diff.ContainerKey = form2.paras.map.FormKey;
  }
  const successFlag = await ERPDESIGNER.Service.commitDiff(activeForm.formKey, [diff], "", doc, activeForm.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  saveXmlFile(doc);
};
const Rpt_DeleteColumn = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, doc = form2.getDocument();
  const grid = getGridByColumnKey$1(form2, "Column0");
  if (args && args[0]) {
    if (grid.getColumnCount() - 1 <= args[0]) {
      throw new Error("当前列'" + getExcelColumnLabel(grid.getColumnCount() - 2) + "'不能删除,因为已经设置了模板!");
    }
  }
  const allDiv = document.querySelectorAll("div[id$='_DeleteColumn']");
  allDiv && allDiv.forEach((div) => {
    div.style.pointerEvents = "none";
  });
  const Key = "Column" + (grid.getColumnCount() - 1);
  const activeForm = ErpDesignerUI.getActiveERPForm();
  const diff = ERPDESIGNER.Diff;
  diff.formKey = activeForm.formKey;
  diff.key = Key;
  diff.metaObjectType = "GridField";
  diff.parentKey = grid.key;
  diff.isDelete = true;
  const successFlag = await ERPDESIGNER.Service.commitDiff(activeForm.formKey, [diff], "", doc, activeForm.paras.map.FormKey);
  if (!successFlag) {
    return;
  }
  saveXmlFile(doc);
};
const SetMetaFormVersion = async (evl, name2, cxt, args) => {
  if (args.length < 2) {
    throw UNEQUAL_PARAM_NUM(name2);
  }
  const form2 = cxt.form, reportCode = args[0], controlKey = args[1];
  const metaKey = "undefined_getMetaForm_" + reportCode + "_";
  const metaCache2 = new MetaCache();
  let version = -1;
  const setFunc = () => {
    metaCache2.get(metaKey).then((metaDef) => {
      if (metaDef) {
        version = metaDef.version;
      }
      if (version < 0) {
        setTimeout(setFunc, 500);
      }
      form2.setComponentValue(controlKey, version, false);
    });
  };
  setTimeout(setFunc, 500);
};
const OpenBillDocClearCache = async (evl, name2, cxt, args) => {
  const formKey = args[0];
  UIScopeTrees.clear(formKey);
};
const DimensionExportExcel = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  let needDownload = true;
  let exportTables = "";
  let exportCurPage = false;
  let postExportServiceName = "";
  let exportServiceName = "";
  let exportFileName = "";
  let exportGrid = "";
  if (args.length > 0) {
    needDownload = TypeConvertor.toBoolean(args[0]);
  }
  if (args.length > 1) {
    exportTables = TypeConvertor.toString(args[1]);
  }
  if (args.length > 2) {
    exportCurPage = TypeConvertor.toBoolean(args[2]);
  }
  if (args.length > 3) {
    postExportServiceName = TypeConvertor.toString(args[3]);
  }
  if (args.length > 4) {
    exportServiceName = TypeConvertor.toString(args[4]);
  }
  if (args.length > 5) {
    exportFileName = TypeConvertor.toString(args[5]);
  }
  if (args.length > 6) {
    exportGrid = TypeConvertor.toString(args[6]);
  }
  const docData = form2.getComponent(exportGrid).dataModel.data;
  if (docData) {
    for (let i2 = 0; i2 < docData.length; i2++) {
      let docDataKey = docData[i2];
      for (let j2 = 0; docDataKey && docDataKey.data && j2 < docDataKey.data.length; j2++) {
        docDataKey.data[j2] = Object.assign({}, docDataKey.data[j2]);
      }
    }
    const docDataJson = JSON.stringify(docData);
    form2.setPara("exportDocData", docDataJson);
  }
  const docDataStyle = form2.getComponent(exportGrid).getMetaObj().rows;
  if (docDataStyle) {
    const docDataStyleJson = JSON.stringify(docDataStyle);
    form2.setPara("exportDocDataStyle", docDataStyleJson);
  }
  const document2 = form2.getDocument();
  const doc = DataUtil.toJSONDoc(document2);
  const parameters = form2 != null ? form2.getParas() : null;
  const filterMap = form2.getFilterMap();
  filterMap.setType(DocumentType.DATAOBJECT);
  const paras = {};
  paras.service = "ExportFile";
  paras.cmd = "ExportExcel";
  paras.formKey = form2.formKey;
  paras.document = JSON.stringify(doc);
  paras.parameters = parameters.toJSON();
  paras.exportTables = exportTables;
  paras.filterMap = JSON.stringify(filterMap);
  paras.condition = JSON.stringify(form2.getCondParas());
  paras.onlyCurrentPage = exportCurPage;
  paras.exportServiceName = exportServiceName;
  paras.postExportServiceName = postExportServiceName;
  paras.exportFileName = exportFileName;
  paras.needDownload = needDownload;
  paras.mode = 1;
  await FileUtil.downLoadFile(paras);
};
const CellDimensionReport = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  DimensionExportExcel,
  OpenBillDocClearCache,
  Rpt_AddColumn,
  Rpt_ClearCellInfo,
  Rpt_DeleteCellData,
  Rpt_DeleteCellStyleInfo,
  Rpt_DeleteColumn,
  Rpt_MergeCell,
  Rpt_RenderCellCaption,
  Rpt_SaveReport,
  Rpt_SetCellAlignment,
  Rpt_SetCellBorder,
  Rpt_SetCellFontName,
  Rpt_SetCellFontSize,
  Rpt_SetCellFontStyle,
  Rpt_SetCellInfo,
  Rpt_ShowCellBackColor,
  Rpt_ShowCellForeColor,
  Rpt_ShowCellInfo,
  Rpt_SplitCell,
  Rpt_setFixedGridCellFontByJSON,
  SetMetaFormVersion
}, Symbol.toStringTag, { value: "Module" }));
const Sin = async (evl, name2, cxt, args) => {
  const v = TypeConvertor.toDecimal(args[0]);
  return Math.sin(v);
};
const Cos = async (evl, name2, cxt, args) => {
  const v = TypeConvertor.toDecimal(args[0]);
  return Math.cos(v);
};
const Tan = async (evl, name2, cxt, args) => {
  const v = TypeConvertor.toDecimal(args[0]);
  return Math.tan(v);
};
const Sqrt = async (evl, name2, cxt, args) => {
  const v = TypeConvertor.toDecimal(args[0]);
  return Math.sqrt(v);
};
const MathFun = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Cos,
  Sin,
  Sqrt,
  Tan
}, Symbol.toStringTag, { value: "Module" }));
let OpenDicByID = FuncMap.getFun("OpenDicByID");
const Cancel = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  if (form2.getOperationState() == OperationState.NEW) {
    const parentForm2 = form2.getParentForm();
    let selectOID;
    let dictView;
    let itemData;
    if (parentForm2) {
      dictView = parentForm2.getComponent("DictView");
      if (dictView) {
        itemData = dictView.getSelectedItemData();
        selectOID = itemData && itemData.oid > 0 ? itemData.oid : 0;
      }
    }
    const formType = form2.type;
    if (formType == FormType.DICT || formType == FormType.CHAINDICT) {
      form2.setOperationState(OperationState.DEFAULT);
      const container = form2.getDefContainer();
      if (container && container.form) {
        container.form.setOperationState(OperationState.DEFAULT);
      }
      if (parentForm2 && parentForm2.getDataObject() && parentForm2.getDataObject().secondaryType == SecondaryType.COMPDICT) {
        const pctx = new ViewContext(parentForm2);
        let selectItemKey = form2.dataObjectKey;
        if (dictView) {
          const tmpValue = itemData ? itemData.itemKey : void 0;
          selectItemKey = tmpValue ? tmpValue : selectItemKey;
        }
        const dictKey = await parentForm2.asyncEval("GetRelationFormKey('" + parentForm2.formKey + "','" + selectItemKey + "')", pctx);
        if (dictKey) {
          await parentForm2.asyncEval("OpenDict('" + dictKey + "'," + selectOID + ")", pctx);
        }
      } else {
        await OpenDicByID(evl, "OpenDicByID", cxt, [selectOID]);
      }
    } else {
      const doc = form2.getDocument();
      await ERPBusinessLock.UnLock(form2, doc);
      if (dictView) {
        await OpenDicByID(evl, "OpenDicByID", cxt, [selectOID]);
      } else {
        await form2.close();
      }
    }
  } else if (form2.getOperationState() == OperationState.EDIT) {
    let dicForm = form2;
    const oldDoc = form2.getDocument();
    const container = form2.getDefContainer();
    let oldDicDoc;
    if (container && container.form) {
      dicForm = container.form;
      oldDicDoc = container.form.getDocument();
    }
    const oid = dicForm.getDocument().oid;
    if (dicForm.getFilterMap().OID != oid) {
      dicForm.getFilterMap().setOID(oid);
    }
    const doc = await new DocService(form2).loadFormData(dicForm, oid, dicForm.getFilterMap(), dicForm.getCondParas());
    dicForm.setDocument(doc);
    dicForm.setOperationState(OperationState.DEFAULT);
    if (container && container.form) {
      form2.setOperationState(OperationState.DEFAULT);
    }
    if (form2.type == FormType.ENTITY || form2.type == FormType.DICT) {
      await ERPBusinessLock.UnLock(form2, oldDoc);
    }
    if (container && container.form && container.form.type == FormType.DICT) {
      oldDicDoc = DataUtil.toJSONDoc(oldDicDoc);
      await ERPBusinessLock.UnLock(dicForm, oldDicDoc);
    }
    await dicForm.showDocument();
  }
};
const OptFunExt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Cancel
}, Symbol.toStringTag, { value: "Module" }));
const tabList = ["RowSettingInfoGridLayoutPanel", "ColumnSettingInfoGridLayoutPanel", "CellSettingInfoGridLayoutPanel"];
const tableKeys = { "RowSettingInfoGridLayoutPanel": "BK_Report_RowInfo", "ColumnSettingInfoGridLayoutPanel": "BK_Report_TitleInfo", "CellSettingInfoGridLayoutPanel": "BK_Report_FieldInfo", "StyleSettingInfoGridLayoutPanel": "BK_Report_StyleInfo" };
const gridKeys = { "RowSettingInfoGridLayoutPanel": "RowInfoGrid", "ColumnSettingInfoGridLayoutPanel": "TitleInfoGrid", "CellSettingInfoGridLayoutPanel": "FieldInfoGrid", "StyleSettingInfoGridLayoutPanel": "StyleInfoGrid" };
const gridColumnMap = {};
const D0_COLUMN_KEY = "DT_D0";
const setCellDimension = (form2, key2, rowIndex, columnIndex, value2) => {
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.dimension) {
    cellData.dimension = {};
  }
  if (value2 && value2 instanceof ItemData) {
    value2 = value2.getOID();
  }
  cellData.dimension[key2] = value2;
};
const getCellDimension = (form2, key2, rowIndex, columnIndex, defaultValue) => {
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  if (!grid || !grid.rendered) {
    return defaultValue;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return defaultValue;
  }
  if (!cellData.dimension) {
    return defaultValue;
  }
  const value2 = cellData.dimension[key2];
  if (!value2 && cellData.dimension.hasOwnProperty(key2)) {
    const com = form2.getComponent(key2);
    if (com.type == ControlType.NUMBEREDITOR) {
      defaultValue = 0;
    }
  }
  return value2 != null ? value2 : defaultValue;
};
const setCellStyle = (form2, key2, rowIndex, columnIndex, value2) => {
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.style) {
    cellData.style = {};
  }
  cellData.style[key2] = value2;
};
const getCellStyle = (form2, key2, rowIndex, columnIndex, defaultValue) => {
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  if (!grid || !grid.rendered) {
    return defaultValue;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return defaultValue;
  }
  if (!cellData.style) {
    return defaultValue;
  }
  const value2 = cellData.style[key2];
  return value2 ? value2 : defaultValue;
};
const deleteCellDimension = (form2, rowIndex, columnIndex, key2) => {
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.dimension) {
    return;
  }
  if (key2) {
    delete cellData.dimension[key2];
  } else {
    delete cellData.dimension;
  }
};
const deleteCellStyle = (form2, rowIndex, columnIndex, key2) => {
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  if (!grid || !grid.rendered) {
    return;
  }
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (!cellData) {
    return;
  }
  if (!cellData.style) {
    return;
  }
  if (key2) {
    delete cellData.style[key2];
  } else {
    delete cellData.style;
  }
};
const getGridByColumnKey = (form2, columnKey) => {
  const loc = form2.getCellLocation(columnKey);
  const gridKey = loc.key;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  return grid;
};
const getGridSelectedRange = (grid) => {
  const focusRowIndex = grid.getFocusRowIndex();
  if (focusRowIndex < 0) {
    const msg = "未选择单元格";
    throw new Error(msg);
  }
  const model = grid.el[0].p.selectModel;
  return {
    startCol: model.focusCol,
    startRow: model.focusRow,
    width: model.right - model.left + 1,
    height: model.bottom - model.top + 1
  };
};
const gridSetCellStyle = (grid, rowIndex, colIndex, style, value2) => {
  if (!grid.rendered) {
    return;
  }
  const $t = grid.el[0];
  const pos = $t.getColPos(colIndex);
  const cell = $($t).getGridCellAt(rowIndex + 1, pos);
  if (!cell)
    return;
  if (value2 == "") {
    delete cell.style[style];
  } else {
    cell.style[style] = value2;
  }
};
const gridSetFontStyle = (grid, rowIndex, colIndex, style, value2) => {
  if ("Bold" == style) {
    gridSetCellStyle(grid, rowIndex, colIndex, "fontWeight", value2 == 1 ? "bold" : "normal");
  } else if ("Italic" == style) {
    gridSetCellStyle(grid, rowIndex, colIndex, "fontStyle", value2 == 1 ? "italic" : "normal");
  } else if ("Underline" == style) {
    gridSetCellStyle(grid, rowIndex, colIndex, "textDecoration", value2 == 1 ? "underline" : "none");
  }
};
const gridSetAlignment = (grid, rowIndex, colIndex, direction, alignment) => {
  if ("Horizontal" == direction) {
    gridSetCellStyle(grid, rowIndex, colIndex, "textAlign", alignment);
  }
};
const gridSplitCell = (grid, rowIndex, colIndex) => {
  if (!grid.rendered) {
    return;
  }
  const $t = grid.el[0];
  let pos = $t.getColPos(colIndex);
  let cell = $($t).getGridCellAt(rowIndex + 1, pos);
  if (!cell)
    return;
  if (cell.colSpan <= 1 && cell.rowSpan <= 1) {
    return;
  }
  const rowSpan = cell.rowSpan, colSpan = cell.colSpan;
  cell.colSpan = 1;
  cell.rowSpan = 1;
  for (let j2 = 0; j2 < rowSpan; j2++) {
    for (let i2 = 0; i2 < colSpan; i2++) {
      if (i2 == 0 && j2 == 0) {
        continue;
      }
      pos = $t.getColPos(colIndex + i2);
      cell = $($t).getGridCellAt(rowIndex + j2 + 1, pos);
      $(cell).removeClass("ui-hidden");
    }
  }
};
const gridMergeCell = (grid, rowIndex, colIndex, colSpan, rowSpan) => {
  if (!grid.rendered) {
    return;
  }
  const $t = grid.el[0];
  let pos = $t.getColPos(colIndex);
  let cell = $($t).getGridCellAt(rowIndex + 1, pos);
  if (!cell)
    return;
  if (colSpan > 1) {
    cell.colSpan = colSpan;
  }
  if (rowSpan > 1) {
    cell.rowSpan = rowSpan;
  }
  console.log("MergeCell(${rowIndex},${colIndex},${colSpan},${rowSpan})");
  colSpan = colSpan > 1 ? colSpan : 1;
  rowSpan = rowSpan > 1 ? rowSpan : 1;
  for (let j2 = 0; j2 < rowSpan; j2++) {
    for (let i2 = 0; i2 < colSpan; i2++) {
      if (i2 == 0 && j2 == 0) {
        continue;
      }
      pos = $t.getColPos(colIndex + i2);
      cell = $($t).getGridCellAt(rowIndex + j2 + 1, pos);
      $(cell).addClass("ui-hidden");
    }
  }
};
const showCellDimensionInfo = async (form2, settingTabKey, rowIndex, columnIndex) => {
  const tab = form2.getComponent(settingTabKey);
  if (tab != null) {
    const items2 = tab.items;
    await form2.setPara("_IsShow", true);
    await showCellDimensionInfoEx(form2, items2, rowIndex, columnIndex);
    await form2.setPara("_IsShow", false);
  }
};
const showCellDimensionInfoEx = async (form2, items2, rowIndex, columnIndex) => {
  const cxt = new ViewContext(form2);
  if (items2) {
    for (let i2 = 0; i2 < items2.length; i2++) {
      const item = items2[i2];
      if (item.type == ControlType.GRIDLAYOUTPANEL) {
        await showCellDimensionInfoEx(form2, item.items, rowIndex, columnIndex);
      } else if (item.type != ControlType.LABEL) {
        const value2 = getCellDimension(form2, item.key, rowIndex, columnIndex, null);
        if (value2 != null) {
          await form2.setComponentValue(item.key, value2, true);
        } else if (item.key != "RowType") {
          if (item.metaObj) {
            const dataBinding = item.metaObj.dataBinding;
            if (dataBinding) {
              if (dataBinding.defaultFormulaValue) {
                await form2.setComponentValue(item.key, await form2.asyncEval(dataBinding.defaultFormulaValue, cxt), false);
              } else {
                console.log(item.key, dataBinding.defaultValue);
                await form2.setComponentValue(item.key, dataBinding.defaultValue, false);
              }
            }
          }
        }
      }
    }
  }
};
const showCellStyleInfo = (form2, rowIndex, columnIndex) => {
  let value2 = getCellStyle(form2, "FontName", rowIndex, columnIndex, "");
  form2.setComponentValue("FontNameList", value2, false);
  value2 = getCellStyle(form2, "FontSize", rowIndex, columnIndex, "");
  form2.setComponentValue("FontSizeList", value2, false);
};
const LoadReportEx = async (evl, name2, cxt, args) => {
  const form2 = cxt.form, doc = form2.getDocument(), loc = form2.getCellLocation("DT_A");
  initTableColumnMap(form2);
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  tabList.forEach((tabKey) => {
    const dimensionTable = doc.getByKey(tableKeys[tabKey]);
    dimensionTable.beforeFirst();
    const cellKey = gridColumnMap[gridKeys[tabKey]]["CellIndex"];
    while (dimensionTable.next()) {
      const rowIndex = TypeConvertor.toInt(dimensionTable.getByKey("RowIndex")) - 1;
      const columnIndex = cellKey ? TypeConvertor.toInt(dimensionTable.getByKey("CellIndex")) - 2 : -2;
      for (let i2 = 0, count = dimensionTable.getColumnCount(); i2 < count; i2++) {
        const colKey = dimensionTable.getCol(i2).getKey();
        if (SystemField.isSystemField(colKey)) {
          continue;
        }
        const value2 = dimensionTable.getByKey(colKey);
        setCellDimension(form2, colKey, rowIndex, cellKey ? columnIndex + 3 : 0, value2);
        grid.setCellBackColor(rowIndex, cellKey ? columnIndex + 3 : 0, "#e0f3fb");
      }
    }
  });
  const styleTable = doc.getByKey("BK_Report_StyleInfo");
  styleTable.beforeFirst();
  while (styleTable.next()) {
    const rowIndex = TypeConvertor.toInt(styleTable.getByKey("RowIndex")) - 1;
    const columnIndex = TypeConvertor.toInt(styleTable.getByKey("CellIndex")) - 1;
    let xSpan = 0, ySpan = 0;
    for (let i2 = 0, count = styleTable.getColumnCount(); i2 < count; i2++) {
      const colKey = styleTable.getCol(i2).getKey();
      if (SystemField.isSystemField(colKey)) {
        continue;
      }
      const value2 = styleTable.getByKey(colKey);
      if (!value2) {
        continue;
      }
      setCellStyle(form2, colKey, rowIndex, columnIndex + 2, value2);
      if ("ForeColor" == colKey) {
        grid.setCellForeColor(rowIndex, loc.column + columnIndex, value2);
      }
      if ("BackColor" == colKey) {
        grid.setCellBackColor(rowIndex, loc.column + columnIndex, value2);
      }
      if ("XSpan" == colKey) {
        xSpan = TypeConvertor.toInt(value2);
      }
      if ("YSpan" == colKey) {
        ySpan = TypeConvertor.toInt(value2);
      }
      if ("Horizontal" == colKey || "Vertical" == colKey) {
        gridSetAlignment(grid, rowIndex, loc.column + columnIndex, colKey, value2);
      }
      if (("Bold" == colKey || "Italic" == colKey) && value2 == 1) {
        gridSetFontStyle(grid, rowIndex, loc.column + columnIndex, colKey, value2);
      }
      if ("FontName" == colKey && value2 != "") {
        gridSetCellStyle(grid, rowIndex, loc.column + columnIndex, "fontFamily", value2);
      }
      if ("FontSize" == colKey && value2 > 0) {
        gridSetCellStyle(grid, rowIndex, loc.column + columnIndex, "fontSize", value2 + "px");
      }
      if ("LeftBorder" == colKey && value2 == "true") {
        gridSetCellStyle(grid, rowIndex, loc.column + columnIndex, "borderLeft", "1px solid #000000");
      }
      if ("TopBorder" == colKey && value2 == "true") {
        gridSetCellStyle(grid, rowIndex, loc.column + columnIndex, "borderTop", "1px solid #000000");
      }
      if ("RightBorder" == colKey && value2 == "true") {
        gridSetCellStyle(grid, rowIndex, loc.column + columnIndex, "borderRight", "1px solid #000000");
      }
      if ("BottomBorder" == colKey && value2 == "true") {
        gridSetCellStyle(grid, rowIndex, loc.column + columnIndex, "borderBottom", "1px solid #000000");
      }
    }
    if (xSpan > 0 || ySpan > 0) {
      gridMergeCell(grid, rowIndex, loc.column + columnIndex, xSpan, ySpan);
    }
  }
};
const getColChar = (colIndex) => {
  const preIndex = Math.floor(colIndex / 26);
  let result = "";
  if (preIndex > 0) {
    result += String.fromCharCode(65 + preIndex - 1);
  }
  const subIndex = colIndex % 26;
  result += String.fromCharCode(65 + subIndex);
  return result;
};
const ShowCellInfoEx = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  const rowIndex = grid.getFocusRowIndex();
  const columnIndex = grid.getFocusColIndex();
  if (rowIndex >= 0 && columnIndex >= 0) {
    if (columnIndex > 0) {
      await form2.setComponentValue("COL", getColChar(columnIndex - 2), false);
    } else {
      await form2.setComponentValue("COL", "行类型", false);
    }
    await form2.setComponentValue("Row", rowIndex + 1, false);
  }
  if (rowIndex >= 0) {
    const rowType = TypeConvertor.toInt(grid.getValueAt(rowIndex, 0));
    if (columnIndex == 0) {
      if (rowType != 5) {
        await form2.setPara("_IsShow", true);
        await form2.setComponentValue("RowType", rowType, true);
        await form2.setPara("_IsShow", false);
        await showCellDimensionInfo(form2, "RowSetting", rowIndex, columnIndex);
        setTabVisible(form2, "RowSetting");
      } else {
        setTabVisible(form2, "");
      }
    } else {
      if (rowType == 5) {
        await showCellDimensionInfo(form2, "ColumnSetting", rowIndex, columnIndex);
        setTabVisible(form2, "ColumnSetting");
      } else {
        await showCellDimensionInfo(form2, "CellSetting", rowIndex, columnIndex);
        setTabVisible(form2, "CellSetting");
      }
    }
  }
  if (columnIndex >= 2) {
    showCellStyleInfo(form2, rowIndex, columnIndex);
  }
};
const initTableColumnMap = (form2) => {
  if (Object.keys(gridColumnMap).length != 0) {
    return;
  }
  const cellMap = form2.formAdapt.cellMap;
  for (const tabKey in tableKeys) {
    const gridKey = gridKeys[tabKey];
    const grid = form2.getComponent(gridKey);
    gridColumnMap[gridKey] = {};
    const columns = grid.dataModel.columns;
    columns.forEach((column) => {
      gridColumnMap[gridKey][cellMap[column.key].columnKey] = column.key;
    });
  }
};
const setTabVisible = (form2, tabKey) => {
  tabList.forEach(function(curTabKey) {
    const comp2 = form2.getComponent(curTabKey);
    if (comp2) {
      if (tabKey != curTabKey) {
        comp2.setVisible(false);
      } else {
        comp2.setVisible(true);
        const ownerCt = comp2.ownerCt;
        if (!ownerCt || ownerCt.type !== ControlType.TABPANEL) {
          return;
        }
        ownerCt.setTabSel2(comp2);
      }
    }
  });
};
const SetCellInfoEx = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  form2.getCellLocation(D0_COLUMN_KEY);
  const isShow = TypeConvertor.toBoolean(form2.getPara("_IsShow"));
  if (isShow) {
    return;
  }
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  const rowIndex = grid.getFocusRowIndex();
  const columnIndex = grid.getFocusColIndex();
  if (rowIndex >= 0) {
    const rowType = grid.getValueAt(rowIndex, 0);
    if (columnIndex == 0) {
      if (rowType != 5) {
        await setDimensions(form2, "RowSetting", rowIndex, columnIndex);
      }
    } else {
      if (rowType == 5) {
        await setDimensions(form2, "ColumnSetting", rowIndex, columnIndex);
      } else {
        await setDimensions(form2, "CellSetting", rowIndex, columnIndex);
      }
      await setStyle2Table(form2, grid, rowIndex, columnIndex);
    }
  }
  grid.setCellBackColor(rowIndex, columnIndex, "#e0f3fb");
};
const setDimensions = async (form2, settingTabKey, rowIndex, columnIndex) => {
  const tab = form2.getComponent(settingTabKey);
  if (tab != null) {
    initTableColumnMap(form2);
    const bookmark = await getBookMark(form2, settingTabKey, rowIndex, columnIndex);
    const items2 = tab.items;
    await setDimensionsEX(form2, settingTabKey, bookmark, rowIndex, columnIndex, items2);
  }
};
const setDimensionsEX = async (form2, settingTabKey, bookmark, rowIndex, columnIndex, items2) => {
  if (items2) {
    items2.forEach(await async function(item) {
      if (item.type == ControlType.GRIDLAYOUTPANEL) {
        await setDimensionsEX(form2, settingTabKey, bookmark, rowIndex, columnIndex, item.items);
      } else if (item.type != ControlType.LABEL) {
        const value2 = form2.getValue(item.key);
        setCellDimension(form2, item.key, rowIndex, columnIndex, value2);
        await setSettingData2Table(form2, settingTabKey, bookmark, item.key, value2);
      }
    });
  }
};
const setSettingData2Table = async (form2, settingTabKey, bookmark, cellKey, value2) => {
  const gridKey = gridKeys[settingTabKey];
  const grid = form2.getComponent(gridKey);
  const celKey = gridColumnMap[gridKey][cellKey];
  if (celKey) {
    const cell = form2.getCellLocation(celKey);
    await grid.setValueAt(bookmark, cell.column, value2, true, true, false);
  }
};
const setStyle2Table = async (form2, grid, rowIndex, columnIndex) => {
  const tabKey = "StyleSetting";
  const cellData = grid.getCellDataAt(rowIndex, columnIndex);
  if (cellData.style) {
    const bookmark = await getBookMark(form2, tabKey, rowIndex, columnIndex);
    const gridKey = gridKeys[tabKey];
    for (const key2 in gridColumnMap[gridKey]) {
      if (SystemField.isSystemField(key2)) {
        continue;
      }
      if (key2 == "RowIndex" || key2 == "CellIndex") {
        continue;
      }
      let value2 = null;
      if (cellData.style.hasOwnProperty(key2)) {
        value2 = cellData.style[key2];
      }
      await setSettingData2Table(form2, tabKey, bookmark, key2, value2);
    }
  }
};
const getBookMark = async (form2, settingTabKey, rowIndex, columnIndex) => {
  const gridKey = gridKeys[settingTabKey];
  const grid = form2.getComponent(gridKey);
  const rkey = gridColumnMap[gridKey]["RowIndex"];
  const cKey = gridColumnMap[gridKey]["CellIndex"];
  const size = grid.getRowCount();
  let found = false;
  let bookmark = -1;
  for (let i2 = 0; i2 < size; i2++) {
    const rCell = form2.getCellLocation(rkey);
    const curRowIndex = TypeConvertor.toInt(grid.getValueAt(i2, rCell.column));
    if (rowIndex == curRowIndex - 1) {
      if (cKey != null) {
        const cCell = form2.getCellLocation(cKey);
        const curCellIndex = TypeConvertor.toInt(grid.getValueAt(i2, cCell.column));
        if (curCellIndex + 1 == columnIndex) {
          found = true;
          bookmark = i2;
          break;
        }
      } else {
        found = true;
        bookmark = i2;
        break;
      }
    }
  }
  if (!found) {
    await grid.insertRow(size, true);
    bookmark = size;
    await setSettingData2Table(form2, settingTabKey, bookmark, "RowIndex", rowIndex + 1);
    if (cKey != null) {
      await setSettingData2Table(form2, settingTabKey, bookmark, "CellIndex", columnIndex - 1);
    }
  }
  return bookmark;
};
const DeleteCellInfoEx = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const rowIndex = TypeConvertor.toInt(args[0]) - 1;
  const columnIndex = TypeConvertor.toInt(args[1]) + 1;
  let isStyle = false;
  if (args.length > 2) {
    isStyle = TypeConvertor.toBoolean(args[2]);
  }
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  if (isStyle) {
    deleteCellStyle(form2, rowIndex, columnIndex, "");
  } else {
    await grid.setValueAt(rowIndex, columnIndex, "", true, false, false);
    deleteCellDimension(form2, rowIndex, columnIndex, "");
    grid.setCellBackColor(rowIndex, columnIndex, "#fff");
  }
};
const SplitCellEx = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  const selectedRange = getGridSelectedRange(grid);
  setCellStyle(form2, "XSpan", selectedRange.startRow, selectedRange.startCol, 1);
  setCellStyle(form2, "YSpan", selectedRange.startRow, selectedRange.startCol, 1);
  gridSplitCell(grid, selectedRange.startRow, selectedRange.startCol);
};
const SetRowHeight = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  const grid = getGridByColumnKey(form2, D0_COLUMN_KEY);
  const focusRowIndex = grid.getFocusRowIndex();
  if (focusRowIndex >= 0) {
    const height = form2.getValue("RowHeight");
    if (grid.el) {
      const $table = grid.el[0];
      const $row = $table.rows[1 + focusRowIndex];
      $row.style.height = height + "px";
    }
    const rowData = grid.getRowDataAt(focusRowIndex);
    rowData.rowHeight = height;
  }
};
const ReportModelFunExt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  DeleteCellInfoEx,
  LoadReportEx,
  SetCellInfoEx,
  SetRowHeight,
  ShowCellInfoEx,
  SplitCellEx
}, Symbol.toStringTag, { value: "Module" }));
const docCache$1 = new DocCache();
const metaCache = new MetaCache();
const isUserAdvancedQuery = async (evl, name2, cxt, args) => {
  let key2;
  if (args.length > 1) {
    key2 = "GetQueryValue_" + args[0] + "_" + args[1];
  } else {
    key2 = "GetQueryValue_" + args[0] + "_";
  }
  if (cxt.form.advancedQueryValueCache && cxt.form.getFormKey() == args[0]) {
    let value2 = await cxt.form.advancedQueryValueCache.get(key2);
    if (!value2 || Utils.isEmptyObject(value2)) {
      return false;
    } else {
      return true;
    }
  } else {
    return false;
  }
};
const setAdvancedQueryFieldKeyValue = async (evl, name2, cxt, args) => {
  var form2 = FormStack.getForm(cxt.form.pFormID);
  if (cxt.form.isBetweenComponent) {
    let componentFrom = form2.getComponent(cxt.form.betweenFromComponentKey);
    var betweenFromComponentKey = componentFrom.getValue();
    let componentTo = form2.getComponent(cxt.form.betweenToComponentKey);
    var betweenToComponentKey = componentTo.getValue();
    let IncludeScope = cxt.form.getDocument().getByKey("IncludeScope");
    let Include = cxt.form.getDocument().getByKey("Include");
    let OID = await NewOIDCache.applyNewOID();
    let SOID = await NewOIDCache.applyNewOID();
    if (!componentFrom.handler.isNullValue(betweenFromComponentKey) && componentTo.handler.isNullValue(betweenToComponentKey)) {
      if (Include.size() <= 0) {
        Include.addRow(true);
        Include.setByKey("OID", OID);
        Include.setByKey("Condition", "=");
        Include.setByKey("SOID", SOID);
        if (betweenFromComponentKey instanceof ItemData) {
          Include.setByKey("Value", betweenFromComponentKey.oid);
        } else {
          Include.setByKey("Value", betweenFromComponentKey);
        }
      }
    } else if (IncludeScope.size() <= 0 && (!componentFrom.handler.isNullValue(betweenFromComponentKey) || !componentTo.handler.isNullValue(betweenToComponentKey))) {
      IncludeScope.addRow(true);
      IncludeScope.setByKey("OID", OID);
      IncludeScope.setByKey("Condition", "in");
      IncludeScope.setByKey("SOID", SOID);
      if (!componentFrom.handler.isNullValue(betweenFromComponentKey) && !componentTo.handler.isNullValue(betweenToComponentKey)) {
        if (betweenFromComponentKey instanceof ItemData) {
          IncludeScope.setByKey("LoValue", betweenFromComponentKey.oid);
          IncludeScope.setByKey("LoCodeValue", betweenFromComponentKey.code);
          IncludeScope.setByKey("LoNameValue", betweenFromComponentKey.name);
        } else {
          IncludeScope.setByKey("LoValue", betweenFromComponentKey);
        }
        if (betweenToComponentKey instanceof ItemData) {
          IncludeScope.setByKey("UpValue", betweenToComponentKey.oid);
          IncludeScope.setByKey("UpCodeValue", betweenToComponentKey.code);
          IncludeScope.setByKey("UpNameValue", betweenToComponentKey.name);
        } else {
          IncludeScope.setByKey("UpValue", betweenToComponentKey);
        }
      } else if (!componentTo.handler.isNullValue(betweenToComponentKey) && componentFrom.handler.isNullValue(betweenFromComponentKey)) {
        if (betweenToComponentKey instanceof ItemData) {
          IncludeScope.setByKey("UpValue", betweenToComponentKey.oid);
          IncludeScope.setByKey("UpCodeValue", betweenToComponentKey.code);
          IncludeScope.setByKey("UpNameValue", betweenToComponentKey.name);
        } else {
          IncludeScope.setByKey("UpValue", betweenToComponentKey);
        }
      }
    }
  } else {
    let component = form2.getComponent(cxt.form.AdvancedQueriesFieldKey);
    var advancedQueriesFieldKey = component.getValue();
    let Include = cxt.form.getDocument().getByKey("Include");
    let OID = await NewOIDCache.applyNewOID();
    let SOID = await NewOIDCache.applyNewOID();
    if (Include.size() <= 0 && !component.handler.isNullValue(advancedQueriesFieldKey)) {
      Include.addRow(true);
      Include.setByKey("OID", OID);
      Include.setByKey("Condition", "=");
      Include.setByKey("SOID", SOID);
      if (advancedQueriesFieldKey instanceof ItemData) {
        Include.setByKey("Value", advancedQueriesFieldKey.oid);
      } else {
        if (advancedQueriesFieldKey instanceof Array && component.type == 206) {
          Include.setByKey("Value", advancedQueriesFieldKey[0].oid);
        } else {
          Include.setByKey("Value", advancedQueriesFieldKey);
        }
      }
    }
  }
};
const showMultipleOptions = async (evl, name2, cxt, args) => {
  OperationState.NEW;
  const target = FormTarget.MODAL;
  const container = cxt.form.getContainer();
  const form2 = cxt.form;
  let srcFormKey = form2.formKey;
  if (form2.formKey == "DynamicFieldForm") {
    srcFormKey = form2.formKey + "_" + form2.srcFormKey;
  }
  const component = form2.getComponent(args[0]);
  let itemKey = "", dictFilter;
  if (component.type == ControlType.DICT || component.type == ControlType.COMPDICT || component.type == ControlType.DYNAMICDICT) {
    itemKey = component.itemKey;
    if (component.type == ControlType.DYNAMICDICT) {
      if (component.refDataElementKey) {
        var dataElementKey = await form2.asyncEval(component.refDataElementKey, cxt, null);
        itemKey = await DictHandler.getItemKeyByDataElementKeyService(form2, dataElementKey);
      } else {
        itemKey = await form2.asyncEval(component.refKey, cxt, null);
      }
    }
    if (component.meta.properties && component.meta.properties.itemFilters) {
      const filter = await component.handler.getDictFilter(form2, component.meta, itemKey, component.typeDefKey, cxt);
      dictFilter = JSON.stringify(filter);
    }
  }
  const advancedQueriesFieldKey = args[0];
  let cumstomFormKey = component.getCustomPara("AdvancedQueryCustom");
  let meta, cacheKey, formulaScope, betweenFromComponentKey, betweenToComponentKey, isBetweenComponent;
  if (cumstomFormKey) {
    meta = await new MetaService().getMetaForm(cumstomFormKey, "");
  } else {
    const metaService = new MetaService(form2);
    const data = await metaService.getAdvancedQueryMetaForm(srcFormKey, advancedQueriesFieldKey, itemKey);
    meta = data.meta;
    cacheKey = data.cacheKey;
    formulaScope = data.formulaScope;
    betweenFromComponentKey = data.betweenFromComponentKey;
    betweenToComponentKey = data.betweenToComponentKey;
    isBetweenComponent = data.isBetweenComponent;
  }
  const _appEnv = form2.getAppEnv();
  const metaForm = new MetaForm(meta);
  const emptyForm = FormFactory.create(metaForm, _appEnv);
  emptyForm.isOKClose = true;
  emptyForm.AdvancedQueriesFieldKey = advancedQueriesFieldKey;
  emptyForm.betweenFromComponentKey = betweenFromComponentKey;
  emptyForm.betweenToComponentKey = betweenToComponentKey;
  emptyForm.isBetweenComponent = isBetweenComponent;
  FormParasUtil.processCallParas(form2, emptyForm);
  const builder = new FormBuilder("MultipleOptions");
  builder.setContainer(container);
  builder.setTarget(target);
  builder.setParentForm(form2);
  let newDoc;
  if (cacheKey) {
    let newDocDef;
    if (component.advancedQueryJsonValue) {
      newDocDef = component.advancedQueryJsonValue.document;
      docCache$1.put(cacheKey, newDocDef);
    } else if (component.condition.loadHistoryInput) {
      newDocDef = await docCache$1.get(cacheKey);
    }
    newDoc = newDocDef && DataUtil.fromJSONDoc(newDocDef);
  }
  if (formulaScope && formulaScope.fieldKey2Scope) {
    var result = {};
    for (let i2 = 0; i2 < formulaScope.fieldKey2Scope.length; i2++) {
      const fieldKey = formulaScope.fieldKey2Scope[i2].fieldKey;
      const scope = formulaScope.fieldKey2Scope[i2].scope;
      result[fieldKey] = scope;
    }
    UIScopeTrees.scopeTrees[meta.key] = result;
    emptyForm.formulaScope = void 0;
    emptyForm.setFormulaScope(void 0);
  }
  await builder.build(emptyForm, newDoc);
  if (dictFilter) {
    emptyForm.setPara("DictFilter", dictFilter);
  }
};
const AdvancedQueriesProcessing = async (evl, name2, cxt, args) => {
  var _a;
  const form2 = cxt.form;
  const pform = form2.getParentForm();
  var advancedQueryValueCache = new LRUCache(30);
  if (!form2.advancedQueryValueCache) {
    pform.advancedQueryValueCache = advancedQueryValueCache;
  } else {
    advancedQueryValueCache = pform.advancedQueryValueCache;
  }
  let pformKey = pform.getFormKey();
  var dirtyAdvancedQueriesValue = true;
  var itemKey = "";
  let parse = {};
  if (!pform.document.expData.advancedqueryvalue) {
    dirtyAdvancedQueriesValue = false;
  }
  let component = pform.getComponent(form2.AdvancedQueriesFieldKey);
  if (args[0]) {
    async function CleanAll(comp22) {
      if (comp22.type == ControlType.GRID) {
        var grid = comp22, gotEmpty = false;
        var datas = grid.getDatas();
        for (var i2 = datas.length - 1; i2 >= 0; i2--) {
          var rowData = datas[i2];
          if (rowData.rowType != "Detail") {
            continue;
          }
          if (!gotEmpty && rowData.bkmkRow == null) {
            gotEmpty = true;
            continue;
          }
          await grid.deleteRow(i2, false);
        }
        await grid.getHandler().rowDelete(grid, 0);
        grid.refreshGrid();
      }
    }
    component.advancedQueryObj.impl.queryBtn.$removeClass("useradvancedquerybutton");
    component.advancedQueryJsonValue = void 0;
    component.condition.useAdvancedQuery = "false";
    if (dirtyAdvancedQueriesValue && parse[form2.AdvancedQueriesFieldKey]) {
      parse[form2.AdvancedQueriesFieldKey].fieldObjects = "{}";
    }
    if (component.type == ControlType.DICT || component.type == ControlType.COMPDICT || component.type == ControlType.DYNAMICDICT) {
      itemKey = component.itemKey;
      if (component.refDataElementKey) {
        var dataElementKey = await form2.eval(component.refDataElementKey, cxt, null);
        itemKey = await DictHandler.getItemKeyByDataElementKeyService(form2, dataElementKey);
      } else {
        itemKey = await form2.eval(component.refKey, cxt, null);
      }
    }
    var comp2 = form2.getComponent("IncludeGrid");
    await CleanAll(comp2);
    comp2 = form2.getComponent("IncludeScopeGrid");
    await CleanAll(comp2);
    comp2 = form2.getComponent("ExcludeGrid");
    await CleanAll(comp2);
    comp2 = form2.getComponent("ExcludeScopeGrid");
    await CleanAll(comp2);
    docCache$1.put("GetMultipleOptions_" + pformKey + "_" + form2.AdvancedQueriesFieldKey + itemKey + form2.entryPath, void 0);
    return false;
  }
  const document2 = form2.getDocument();
  const fieldKey = form2.AdvancedQueriesFieldKey;
  const component1 = pform.getComponent(fieldKey);
  if (component1.type == ControlType.DICT || component1.type == ControlType.COMPDICT || component1.type == ControlType.DYNAMICDICT) {
    itemKey = component1.itemKey;
    if (component1.type == ControlType.DYNAMICDICT) {
      if (component1.refDataElementKey) {
        var dataElementKey = await pform.asyncEval(component1.refDataElementKey);
        itemKey = await DictHandler.getItemKeyByDataElementKeyService(pform, dataElementKey);
      } else {
        itemKey = await pform.asyncEval(component1.refKey);
      }
    }
  }
  let formScope = form2.formScope;
  if (!formScope) {
    formScope = await UIScopeTrees.get(form2);
    form2.formScope = formScope;
  }
  const srcFormKey = pformKey;
  const newDocDef = await new RichDocService(form2).advancedQueryProcessing(cxt.form.formKey, srcFormKey, document2, form2.AdvancedQueriesFieldKey, itemKey, true);
  var json = "{}";
  if (newDocDef) {
    component.advancedQueryJsonValue = newDocDef;
    json = JSON.stringify(newDocDef);
  }
  if (newDocDef.isBetweenComponent) {
    let toComponent = pform.getComponent(form2.betweenToComponentKey);
    let fromComponent = pform.getComponent(form2.betweenFromComponentKey);
    if (newDocDef) {
      toComponent.advancedQueryJsonValue = newDocDef;
      fromComponent.advancedQueryJsonValue = newDocDef;
    }
    if (dirtyAdvancedQueriesValue) {
      if (!parse[form2.betweenFromComponentKey]) {
        parse[form2.betweenFromComponentKey] = {};
      }
      parse[form2.betweenFromComponentKey].fieldObjects = json;
      if (!parse[form2.betweenToComponentKey]) {
        parse[form2.betweenToComponentKey] = {};
      }
      parse[form2.betweenToComponentKey].fieldObjects = json;
    }
    if (newDocDef.clean) {
      toComponent.advancedQueryJsonValue = void 0;
      fromComponent.advancedQueryJsonValue = void 0;
      fromComponent.clean = true;
      toComponent.clean = true;
      if (dirtyAdvancedQueriesValue) {
        parse[form2.betweenToComponentKey] = void 0;
        parse[form2.betweenFromComponentKey] = void 0;
      }
    } else {
      toComponent.clean = false;
      fromComponent.clean = false;
      if (dirtyAdvancedQueriesValue) {
        parse[form2.betweenToComponentKey].isUse = true;
        parse[form2.betweenFromComponentKey].isUse = true;
      }
    }
    if (dirtyAdvancedQueriesValue) {
      pform.document.expData.advancedqueryvalue = JSON.stringify(parse);
    }
    toComponent.impl && toComponent.advancedQueryObj.setHasAdvancedQueryData(!newDocDef.clean);
    if (newDocDef.clean && toComponent.condition) {
      toComponent.condition.useAdvancedQuery = "false";
      toComponent.hasData = false;
    }
    fromComponent.impl && ((_a = fromComponent.advancedQueryObj) == null ? void 0 : _a.setHasAdvancedQueryData(!newDocDef.clean));
    if (newDocDef.clean && fromComponent.condition) {
      fromComponent.condition.useAdvancedQuery = "false";
      fromComponent.hasData = false;
    }
    let appKey = "undefined";
    const appEnv = pform.getAppEnv();
    if (appEnv) {
      appKey = appEnv.getAppKey();
    }
    const key2 = appKey + "_getMetaForm_" + pformKey + "_";
    metaCache.put(key2, void 0);
    docCache$1.put("GetMultipleOptions_" + srcFormKey + "_" + form2.betweenFromComponentKey + itemKey + form2.entryPath, newDocDef.document);
    docCache$1.put("GetMultipleOptions_" + srcFormKey + "_" + form2.betweenToComponentKey + itemKey + form2.entryPath, newDocDef.document);
    advancedQueryValueCache.put("GetQueryValue_" + srcFormKey + "_" + form2.betweenFromComponentKey, newDocDef.zh);
    advancedQueryValueCache.put("GetQueryValue_" + srcFormKey + "_" + form2.betweenToComponentKey, newDocDef.zh);
    let include = document2.getByKey("Include");
    let includeScope = document2.getByKey("IncludeScope");
    include.setPos(0);
    includeScope.setPos(0);
    let valueAt = "";
    let valueFrom = "";
    let valueTo = "";
    let condition;
    if (includeScope.size() > 0) {
      valueFrom = includeScope.getByKey("LoValue") || "";
      valueTo = includeScope.getByKey("UpValue") || "";
      let convertValueFrom = BaseHandler.convertValue(fromComponent.getValue(), includeScope.getColByKey("LoValue").type);
      if (valueFrom instanceof ItemData) {
        if (fromComponent.isEditValue) {
          valueFrom = valueFrom.editValue;
        } else {
          valueFrom = valueFrom.oid;
        }
      }
      if (convertValueFrom instanceof ItemData) {
        if (fromComponent.isEditValue) {
          convertValueFrom = convertValueFrom.editValue;
        } else {
          convertValueFrom = convertValueFrom.oid;
        }
      }
      let convertValueTo = BaseHandler.convertValue(toComponent.getValue(), includeScope.getColByKey("UpValue").type);
      if (valueTo instanceof ItemData) {
        if (toComponent.isEditValue) {
          valueTo = valueTo.editValue;
        } else {
          valueTo = valueTo.oid;
        }
      }
      if (convertValueTo instanceof ItemData) {
        if (toComponent.isEditValue) {
          convertValueTo = convertValueTo.editValue;
        } else {
          convertValueTo = convertValueTo.oid;
        }
      }
      fromComponent.editAdvancedQueryValue = true;
      toComponent.editAdvancedQueryValue = true;
      await pform.setValue(form2.betweenFromComponentKey, valueFrom, cxt, true);
      await pform.setValue(form2.betweenToComponentKey, valueTo, cxt, true);
      fromComponent.editAdvancedQueryValue = false;
      toComponent.editAdvancedQueryValue = false;
    } else {
      fromComponent.editAdvancedQueryValue = true;
      toComponent.editAdvancedQueryValue = true;
      await pform.setValue(form2.betweenFromComponentKey, null, cxt, true);
      await pform.setValue(form2.betweenToComponentKey, null, cxt, true);
      fromComponent.editAdvancedQueryValue = false;
      toComponent.editAdvancedQueryValue = false;
      if (include.size() > 0) {
        condition = include.getByKey("Type");
        if (condition === "REGEXP") {
          valueAt = include.getByKey("RegexpValue") || "";
          if (fromComponent.integerValue) {
            valueAt = fromComponent.value;
          }
        } else {
          valueAt = include.getByKey("Value") || "";
        }
      }
      let convertValue = BaseHandler.convertValue(fromComponent.getValue(), include.getColByKey("Value").type);
      if (valueAt instanceof ItemData) {
        if (fromComponent.isEditValue) {
          valueAt = valueAt.editValue;
        } else {
          valueAt = valueAt.oid;
        }
      }
      if (convertValue instanceof ItemData) {
        if (fromComponent.isEditValue) {
          convertValue = convertValue.editValue;
        } else {
          convertValue = convertValue.oid;
        }
      }
      if (condition !== "REGEXP") {
        fromComponent.editAdvancedQueryValue = true;
        toComponent.editAdvancedQueryValue = true;
        await pform.setValue(form2.betweenFromComponentKey, valueAt, cxt, true);
        await pform.setValue(form2.betweenToComponentKey, null, cxt, true);
        fromComponent.editAdvancedQueryValue = false;
        toComponent.editAdvancedQueryValue = false;
      }
    }
  } else {
    if (dirtyAdvancedQueriesValue) {
      if (!parse[form2.AdvancedQueriesFieldKey]) {
        parse[form2.AdvancedQueriesFieldKey] = {};
      }
      parse[form2.AdvancedQueriesFieldKey].fieldObjects = json;
    }
    if (newDocDef.clean) {
      component.advancedQueryJsonValue = void 0;
      component.clean = true;
      if (dirtyAdvancedQueriesValue) {
        parse[form2.AdvancedQueriesFieldKey] = void 0;
      }
    } else {
      component.clean = false;
      if (dirtyAdvancedQueriesValue) {
        parse[form2.AdvancedQueriesFieldKey].isUse = true;
      }
    }
    if (dirtyAdvancedQueriesValue) {
      pform.document.expData.advancedqueryvalue = JSON.stringify(parse);
    }
    component.impl && component.advancedQueryObj.setHasAdvancedQueryData(!newDocDef.clean);
    if (newDocDef.clean && component.condition) {
      component.condition.useAdvancedQuery = "false";
      component.hasData = false;
    }
    let appKey = "undefined";
    const appEnv = pform.getAppEnv();
    if (appEnv) {
      appKey = appEnv.getAppKey();
    }
    const key2 = appKey + "_getMetaForm_" + pformKey + "_";
    metaCache.put(key2, void 0);
    docCache$1.put("GetMultipleOptions_" + srcFormKey + "_" + form2.AdvancedQueriesFieldKey + itemKey + form2.entryPath, newDocDef.document);
    advancedQueryValueCache.put("GetQueryValue_" + srcFormKey + "_" + form2.AdvancedQueriesFieldKey, newDocDef.zh);
    let include = document2.getByKey("Include");
    include.setPos(0);
    let valueAt = "";
    let condition;
    if (include.size() > 0) {
      condition = include.getByKey("Type");
      if (condition === "REGEXP") {
        valueAt = include.getByKey("RegexpValue") || "";
        if (component.integerValue) {
          valueAt = component.value;
        }
      } else {
        valueAt = include.getByKey("Value") || "";
      }
    }
    let convertValue = BaseHandler.convertValue(component.getValue(), include.getColByKey("Value").type);
    if (valueAt instanceof ItemData) {
      if (component.isEditValue) {
        valueAt = valueAt.editValue;
      } else {
        valueAt = valueAt.oid;
      }
    }
    if (convertValue instanceof ItemData) {
      if (component.isEditValue) {
        convertValue = convertValue.editValue;
      } else {
        convertValue = convertValue.oid;
      }
    }
    if (condition !== "REGEXP") {
      component.editAdvancedQueryValue = true;
      await pform.setValue(form2.AdvancedQueriesFieldKey, valueAt, cxt, true);
      component.editAdvancedQueryValue = false;
    }
  }
};
const AdvancedQueryFun = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  AdvancedQueriesProcessing,
  isUserAdvancedQuery,
  setAdvancedQueryFieldKeyValue,
  showMultipleOptions
}, Symbol.toStringTag, { value: "Module" }));
const docCache = new DocCache();
const TraceEnable = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  if (form2.pFormID) {
    let pForm = FormStack.getForm(form2.pFormID);
    if (pForm) {
      return pForm.formKey !== "PopupDictProcess";
    }
  }
  return true;
};
const OpenDictTraceNewDocument = async function(form2) {
  const formKey = form2.getFormKey();
  form2.getParas();
  let formScope = form2.formScope;
  if (!formScope) {
    formScope = await UIScopeTrees.get(form2);
    form2.formScope = formScope;
  }
  const data = await new RichDocService(form2).defaultRichDocument(formKey, form2.entryPath);
  if (!data) {
    return {};
  }
  return data;
};
const OpenDictTraceBuilder = async function(cxt, form2, formKey, _pForm, _container, _state, formulaScope) {
  let newDocDef = await docCache.get("DictTrace_" + formKey);
  if (!newDocDef) {
    newDocDef = await OpenDictTraceNewDocument(form2);
    docCache.put("DictTrace_" + formKey, newDocDef);
  }
  newDocDef = DataUtil.fromJSONDoc(newDocDef);
  const builder = new FormBuilder(formKey);
  builder.setContainer(_container);
  builder.setParentForm(_pForm);
  builder.setOperationState(OperationState.DEFAULT);
  if (formulaScope && formulaScope.fieldKey2Scope) {
    if (!UIScopeTrees.scopeTrees[form2.formKey]) {
      var result = {};
      for (let i2 = 0; i2 < formulaScope.fieldKey2Scope.length; i2++) {
        const fieldKey = formulaScope.fieldKey2Scope[i2].fieldKey;
        const scope = formulaScope.fieldKey2Scope[i2].scope;
        result[fieldKey] = scope;
      }
      UIScopeTrees.scopeTrees[form2.formKey] = result;
      form2.formulaScope = void 0;
      form2.setFormulaScope(void 0);
    }
  }
  await builder.build(form2, newDocDef);
};
const OpenDictTrace = async (evl, name2, cxt, args) => {
  LoadingUtil.show();
  const form2 = cxt.form;
  const itemKey = args[0];
  const OID = TypeConvertor.toLong(args[1]);
  const target = FormTarget.MODAL;
  const container = form2.getContainer();
  const doc = DataUtil.toJSONDoc(form2.getDocument());
  const metaService = new MetaService(form2);
  const containerMeta = await metaService.getPopupDictForm(itemKey, args[2], doc, OID);
  const formKey = containerMeta.formKey;
  const containerBuilder = new FormBuilder(formKey);
  containerBuilder._adjust = true;
  containerBuilder.setContainer(container);
  containerBuilder.setTarget(target);
  containerBuilder.setParentForm(form2);
  containerBuilder.setOperationState(OperationState.DEFAULT);
  if (containerBuilder._appEnv == null && containerBuilder._pForm) {
    containerBuilder._appEnv = containerBuilder._pForm.getAppEnv();
  }
  if (containerBuilder._appEnv == null) {
    console.log("appenv is null");
  }
  const containerMetaForm = new MetaForm(containerMeta.PopupContainerForm);
  const containerEmptyForm = FormFactory.create(containerMetaForm, containerBuilder._appEnv);
  containerEmptyForm.entryParas = containerMeta.parame;
  containerEmptyForm.confirmClose = false;
  if (containerMeta.popHeight) {
    containerEmptyForm.popHeight = containerMeta.popHeight;
    containerEmptyForm.popWidth = containerMeta.popWidth;
  } else {
    if (containerMeta.isPopupDictProcess || itemKey.lastIndexOf("__Dic") > 0) {
      const mainTabEl = MainContainer.getEL();
      const width = parseInt(CssUtil.getWidth(mainTabEl), 10);
      const height = parseInt(CssUtil.getHeight(mainTabEl), 10);
      containerEmptyForm.popHeight = height;
      containerEmptyForm.popWidth = parseInt(width * 0.84, 10);
    }
  }
  FormParasUtil.processCallParas(form2, containerEmptyForm);
  if (containerMeta.PopupContainerFormFormulaScope && containerMeta.PopupContainerFormFormulaScope.fieldKey2Scope) {
    var result = {}, formulaScope = containerMeta.PopupContainerFormFormulaScope;
    for (let i2 = 0; i2 < formulaScope.fieldKey2Scope.length; i2++) {
      const fieldKey = formulaScope.fieldKey2Scope[i2].fieldKey;
      const scope = formulaScope.fieldKey2Scope[i2].scope;
      result[fieldKey] = scope;
    }
    UIScopeTrees.scopeTrees[containerEmptyForm.formKey] = result;
    form2.formulaScope = void 0;
    form2.setFormulaScope(void 0);
  }
  await containerBuilder.build(containerEmptyForm);
  const _container = containerEmptyForm.getComponent("DictTraceContainer");
  const _pForm = containerEmptyForm;
  const _state = OperationState.DEFAULT;
  const _appEnv = containerEmptyForm.getAppEnv();
  const metaForm = new MetaForm(containerMeta.PopupDictForm);
  const emptyForm = FormFactory.create(metaForm, _appEnv);
  emptyForm.entryParas = containerMeta.parame;
  const OnLoad = containerMeta.OrgDictOnload || "";
  const filterMap = emptyForm.getFilterMap();
  filterMap.setOID(OID);
  emptyForm.setPara("DictOID", OID);
  emptyForm.setOptQueue(new OptQueue(new LoadOpt(emptyForm)));
  const oldPostShow = emptyForm.postShow;
  if (OnLoad != "") {
    emptyForm.postShow = oldPostShow == null ? OnLoad : oldPostShow + OnLoad;
  }
  FormParasUtil.processCallParas(containerEmptyForm, emptyForm);
  await OpenDictTraceBuilder(cxt, emptyForm, itemKey + OID, _pForm, _container, _state, containerMeta.PopupDictFormFormulaScope);
  emptyForm.postShow = oldPostShow;
  if (OnLoad != "") {
    await emptyForm.asyncEval("Macro_DictView_RowClick()");
  }
  LoadingUtil.hide();
  return true;
};
const DictTraceFun = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  OpenDictTrace,
  TraceEnable
}, Symbol.toStringTag, { value: "Module" }));
class VariantUtils {
  static async saveVariant(form2, variantPrefix, variantName, vairantContent, initVariantData) {
    const formKey = form2.getFormKey();
    return new RichDocService(form2).saveVariant(formKey, variantPrefix, variantName, vairantContent, initVariantData);
  }
  static async getVariantContent(form2, variantPrefix, initVariantData, variantName = "") {
    return await new RichDocService(form2).getVariantContent(variantPrefix, initVariantData, variantName);
  }
  static async getDefaultVariantName(form2, variantPrefix) {
    return await new RichDocService(form2).getDefaultVariantName(variantPrefix);
  }
}
VariantUtils.D_DEFAULT = "Default";
class GridSettingVariant {
  constructor(grid) {
    this.grid = grid;
    this.initVariant = this.prepareInitGridSettingVariant();
  }
  /**
   * 应用表格变式
   * @param grid 
   * @param gridVariant 
   */
  async loadGridSettingVariant(bNeedLoadFromServer) {
    let variantData = this.getGridVariantCache(this.grid);
    if (!variantData || bNeedLoadFromServer) {
      variantData = await this.getGridSettingVariantOnServer(this.grid);
      this.cacheGridVariantCache(this.grid, variantData);
    }
    variantData && this.applyGridSettingVariant(variantData);
  }
  cacheGridVariantCache(grid, variant) {
    const formID = grid.ofFormID;
    const form2 = FormStack.getForm(formID);
    const doc = form2.getDocument();
    doc.gridSettingVariants = doc.gridSettingVariants || {};
    doc.gridSettingVariants[grid.key] = variant;
  }
  getGridVariantCache(grid) {
    const formID = grid.ofFormID;
    const form2 = FormStack.getForm(formID);
    const doc = form2.getDocument();
    if (doc.gridSettingVariants) {
      return doc.gridSettingVariants[grid.key];
    }
    return void 0;
  }
  /**
   * 保存表格变式
   */
  async saveGridSettingVariant() {
    const gridSetting = this.parseGridSettingVariant();
    const formID = this.grid.ofFormID;
    const form2 = FormStack.getForm(formID);
    if (!form2)
      return;
    const variantPrefix = GridSettingVariant.getGridSettingPrefix(form2.getFormKey(), this.grid.key);
    const jsonData = JSON.stringify(gridSetting);
    await VariantUtils.saveVariant(form2, variantPrefix, this.grid.variantName, jsonData, JSON.stringify(this.initVariant));
  }
  async resetGridSettingVariant(variantName) {
    const formID = this.grid.ofFormID;
    const form2 = FormStack.getForm(formID);
    if (!form2)
      return;
    const variantPrefix = GridSettingVariant.getGridSettingPrefix(form2.getFormKey(), this.grid.key);
    if (this.initVariant) {
      const initVariant = JSON.stringify(this.initVariant);
      await VariantUtils.saveVariant(form2, variantPrefix, variantName, initVariant, initVariant);
    }
  }
  getInitVariant() {
    return this.initVariant;
  }
  /**
   * 应用表格变式设置表格
   * @param gridVariant 
   */
  applyGridSettingVariant(gridVariant) {
    if (Utils.isEmptyObject(gridVariant))
      return;
    if (this.initVariant) {
      let changed = false;
      for (let initColumnVariant of this.initVariant.columns) {
        let columnInfo = this.getGridColumnInfo(initColumnVariant.columnkey, this.grid.getColumns());
        if (columnInfo) {
          const columnVariant = this.getColumnVariant(columnInfo.key, gridVariant);
          if (this.configGridColumnByVariant(columnInfo, columnVariant, initColumnVariant)) {
            changed = true;
          }
        }
      }
      this.grid.variantName = gridVariant.name;
      if (this.grid.impl && changed) {
        this.grid.needRefresh = changed;
      }
    }
  }
  configGridColumnByVariant(gridColumn, columnVariant, initColumnVariant) {
    if (columnVariant) {
      const visible = TypeConvertor.toBoolean(initColumnVariant.visible) && TypeConvertor.toBoolean(columnVariant.visible);
      const width = parseInt(columnVariant.width, 10);
      const changed = gridColumn.visible != visible || gridColumn.width != width;
      if (changed) {
        gridColumn.visible = visible;
        gridColumn.width = width;
      }
      return changed;
    }
    return false;
  }
  /**
   * 将当前表格状态转化成变式
   */
  parseGridSettingVariant() {
    const columns = [];
    const gridSetting = { columns };
    !this.initVariant && this.prepareInitGridSettingVariant();
    if (this.initVariant) {
      for (let initColumnVariant of this.initVariant.columns) {
        const columnInfo = this.getGridColumnInfo(initColumnVariant.columnkey, this.grid.dataModel.columns);
        if (columnInfo) {
          const column = this.parseViewColumnVariant(columnInfo);
          columns.push(column);
        }
      }
    }
    return gridSetting;
  }
  getGridColumnInfo(columnKey, columns) {
    for (let i2 = 0; i2 < columns.length; i2++) {
      if (columnKey == columns[i2].key) {
        return columns[i2];
      }
    }
    return null;
  }
  prepareInitGridSettingVariant() {
    const columns = [];
    const gridSetting = { columns };
    const modelColumns = this.grid.dataModel.colModel ? this.grid.dataModel.colModel.columns : this.grid.dataModel.columns;
    for (let i2 = 0; i2 < modelColumns.length; i2++) {
      if (modelColumns[i2].visible) {
        const column = this.parseModelColumnVariant(modelColumns[i2]);
        columns.push(column);
      }
    }
    return gridSetting;
  }
  parseModelColumnVariant(viewColumnInfo) {
    const columnVariant = {
      index: viewColumnInfo.index,
      columnkey: viewColumnInfo.key,
      caption: viewColumnInfo.label || viewColumnInfo.caption,
      visible: viewColumnInfo.visible ? 1 : 0,
      width: SizeUtil.getSize(viewColumnInfo.width),
      orgcaption: viewColumnInfo.label || viewColumnInfo.caption
    };
    return columnVariant;
  }
  parseViewColumnVariant(viewColumnInfo) {
    const columnVariant = {
      index: viewColumnInfo.index,
      columnkey: viewColumnInfo.key,
      caption: viewColumnInfo.label || viewColumnInfo.caption,
      visible: viewColumnInfo.visible ? 1 : 0,
      width: SizeUtil.getSize(viewColumnInfo.width),
      orgcaption: viewColumnInfo.label || viewColumnInfo.caption
    };
    return columnVariant;
  }
  getColumnVariant(columnKey, gridVariant) {
    if (gridVariant.columns) {
      for (let column of gridVariant.columns) {
        if (column.columnkey == columnKey) {
          return column;
        }
      }
    }
    return null;
  }
  async getGridSettingVariantOnServer(grid) {
    if (!this.initVariant)
      return null;
    const formID = grid.ofFormID;
    const form2 = FormStack.getForm(formID);
    if (!form2)
      return null;
    const variantPrefix = GridSettingVariant.getGridSettingPrefix(form2.getFormKey(), this.grid.key);
    return await VariantUtils.getVariantContent(form2, variantPrefix, JSON.stringify(this.initVariant));
  }
  static getGridSettingPrefix(formKey, gridKey) {
    return `GridSetting.${formKey}.${gridKey}`;
  }
  static newInstance(grid) {
    return new GridSettingVariant(grid);
  }
}
class WebPlugin {
  static loadGridSettingVariant(grid) {
    !grid.variant && WebPlugin.installGridSettingVariant(grid);
    return grid.variant.loadGridSettingVariant(false);
  }
  static saveGridSettingVariant(grid) {
    !grid.variant && WebPlugin.installGridSettingVariant(grid);
    return grid.variant.saveGridSettingVariant();
  }
  static installGridSettingVariant(grid) {
    var variant = GridSettingVariant.newInstance(grid);
    grid.variant = variant;
  }
  static renderPropertyPanel(arg1, arg2) {
  }
  static renderCollapsiblePanel(panel) {
    webpluginx && webpluginx.renderCollapsiblePanel(panel);
  }
}
const ParseGridSettingVariant = (evaluator, name2, ctx, args) => {
  checkParamNum(name2, args, 1);
  const form2 = ctx.form;
  let gridKey = TypeConvertor.toString(args[0]);
  let grid = form2.getComponent(gridKey);
  if (grid == null) {
    return COMPONENT_NOT_EXISTS(gridKey);
  }
  const variant = grid.variant;
  if (!variant)
    return "";
  return variant.parseGridSettingVariant();
};
const LoadGridSettingVariant = async (evaluator, name2, ctx, args) => {
  checkParamNum(name2, args, 1);
  const form2 = ctx.form;
  const gridKey = TypeConvertor.toString(args[0]);
  const grid = form2.getComponent(gridKey);
  if (grid == null) {
    return COMPONENT_NOT_EXISTS(gridKey);
  }
  const variant = grid.variant;
  if (!variant)
    return "";
  await variant.loadGridSettingVariant(true);
  grid.needReloadVariant = true;
};
const ConvertControlToJSON = (evaluator, name2, ctx, args) => {
  const form2 = ctx.form;
  const setting = {};
  for (let componentKey of args) {
    const comp2 = form2.getComponent(componentKey);
    if (comp2.type == ControlType.GRID) {
      const grid = comp2;
      const columnCount = grid.getColumnCount();
      const rowCount = grid.getRowCount();
      const rowJson = [];
      for (let row2 = 0; row2 < rowCount; row2++) {
        const columnsJson = {};
        for (let col2 = 0; col2 < columnCount; col2++) {
          const column = grid.getColumnAt(col2);
          const columnKey = column.key;
          if (!columnKey.startsWith("_")) {
            const value2 = grid.getValueAt(row2, col2);
            columnsJson[columnKey] = `${value2}`;
          }
        }
        if (!Utils.isEmptyObject(columnsJson)) {
          rowJson.push(columnsJson);
        }
      }
      if (rowJson.length > 0) {
        setting[componentKey] = rowJson;
      }
    } else {
      const value2 = comp2.getValue();
      setting[componentKey] = `${value2}`;
    }
  }
  return Utils.isEmptyObject(setting) ? "" : JSON.stringify(setting);
};
const jsonColumnKeyMap = {
  caption: "caption",
  visible: "visible",
  columnkey: "columnkey",
  width: "width",
  name: "name",
  orgcolcaption: "orgcaption",
  index: "index"
};
const GetVariantSettingJSON = (evaluator, name2, ctx, args) => {
  checkParamNum(name2, args, 1);
  const form2 = ctx.form;
  const setting = {};
  const gridKey = args[0];
  const grid = form2.getComponent(gridKey);
  if (grid.type != ControlType.GRID) {
    return "";
  }
  const columnCount = grid.getColumnCount();
  const rowCount = grid.getRowCount();
  const rowJson = [];
  for (let row2 = 0; row2 < rowCount; row2++) {
    const columnsJson = {};
    for (let col2 = 0; col2 < columnCount; col2++) {
      const column = grid.getColumnAt(col2);
      const gridColumnKey = column.key;
      if (!gridColumnKey.startsWith("_")) {
        const value2 = grid.getValueAt(row2, col2);
        const jsonKey = jsonColumnKeyMap[gridColumnKey.toLowerCase()];
        columnsJson[jsonKey] = `${value2}`;
      }
    }
    if (!Utils.isEmptyObject(columnsJson)) {
      rowJson.push(columnsJson);
    }
  }
  if (rowJson.length > 0) {
    setting["columns"] = rowJson;
  }
  return Utils.isEmptyObject(setting) ? "" : JSON.stringify(setting);
};
const SaveGridSettingVariant = async (evl, name2, cxt, args) => {
  checkParamNum(name2, args, 1);
  const gridKey = TypeConvertor.toString(args[0]);
  const form2 = cxt.form;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  return WebPlugin.saveGridSettingVariant(grid);
};
const ShowVariantSetting = async (evl, name2, cxt, args) => {
  checkParamNum(name2, args, 1);
  const gridKey = TypeConvertor.toString(args[0]);
  const form2 = cxt.form;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  const variantName = grid.variantName ? grid.variantName : "";
  return form2.asyncEval("ShowModal('GridSettingVariantDialog', {FormKey:{'" + form2.formKey + "'},GridKey:{'" + gridKey + "'},orgVariantName:{'" + variantName + "'},variantName:{'" + variantName + "'},initData:{GetInitGridSettingVariant('" + gridKey + "')},jsonData:{ParseGridSettingVariant('" + gridKey + "')}})", cxt);
};
const GetInitGridSettingVariant = (evaluator, name2, ctx, args) => {
  checkParamNum(name2, args, 1);
  const gridKey = TypeConvertor.toString(args[0]);
  const form2 = ctx.form;
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  if (!grid.variant)
    return "";
  return grid.variant.getInitVariant();
};
const GetGridSettingDefaultVariantName = (evaluator, name2, ctx, args) => {
  checkParamNum(name2, args, 2);
  const formKey = args[0];
  const gridKey = args[1];
  const variantPrefix = GridSettingVariant.getGridSettingPrefix(formKey, gridKey);
  return VariantUtils.getDefaultVariantName(ctx.form, variantPrefix);
};
const ResetGridSettingVariant = async (evaluator, name2, ctx, args) => {
  checkParamNum(name2, args, 2);
  const form2 = ctx.form;
  const gridKey = args[0];
  const variantName = args[1];
  const grid = form2.getComponent(gridKey);
  if (!grid) {
    throw COMPONENT_NOT_EXISTS(gridKey);
  }
  if (!grid.variant)
    return;
  await grid.variant.resetGridSettingVariant(variantName);
  grid.needReloadVariant = true;
};
const GridSettingVariantFun = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  ConvertControlToJSON,
  GetGridSettingDefaultVariantName,
  GetInitGridSettingVariant,
  GetVariantSettingJSON,
  LoadGridSettingVariant,
  ParseGridSettingVariant,
  ResetGridSettingVariant,
  SaveGridSettingVariant,
  ShowVariantSetting
}, Symbol.toStringTag, { value: "Module" }));
FuncMap.regCluster(FI_ReportModeFun);
FuncMap.regCluster(CellDimensionReport);
FuncMap.regCluster(ERPBaseFun);
FuncMap.regCluster(MathFun);
FuncMap.regCluster(OptFunExt);
FuncMap.regCluster(ReportModelFunExt);
FuncMap.regCluster(UIFunExt);
FuncMap.regCluster(AdvancedQueryFun);
FuncMap.regCluster(DictTraceFun);
FuncMap.regCluster(GridSettingVariantFun);
const SetEntryTree = async (evl, name2, cxt, args) => {
  let nodes = $.fn.zTree.getZTreeObj(args[0] + "RoleOIDTree").getNodes();
  let data = await new RichDocService(cxt.form).setEntryTree(cxt.form.formKey, args[0], nodes);
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  const parentForm2 = cxt.form.getParentForm();
  if (dirtyDataTables) {
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var tableKey = dirtyDataTables[i2].tableKey;
      var dataTable = dirtyDataTables[i2].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = parentForm2.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var isGrid = dirtyDataTables[i2].isGrid;
      if (!isGrid) {
        dirtyDataTables[i2].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i2].gridKey;
        var grid = parentForm2.getComponent(gridKey);
        var doc = parentForm2.getDocument();
        var tableKey = dirtyDataTables[i2].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
      }
    }
  }
  UIScopeTrees.processUICommands4Paras(parentForm2, data.formDirtyDatas[0].dirtyData);
};
const ShowEntryChildTree = async (evl, name2, cxt, args) => {
  let treeObj = $.fn.zTree.getZTreeObj(args[0] + "RoleOIDTree");
  function filter(node) {
    return node.Type == "SonEntryItemKey";
  }
  var nodes = treeObj.getNodesByFilter(filter);
  if (args[1]) {
    for (let i2 = 0; i2 < nodes.length; i2++) {
      nodes[i2].ShowNode = true;
      treeObj.showNode(nodes[i2]);
    }
  } else {
    for (let i2 = 0; i2 < nodes.length; i2++) {
      nodes[i2].ShowNode = false;
      treeObj.hideNode(nodes[i2]);
    }
  }
};
const SetAuthorityTree = async (evl, name2, cxt, args) => {
  var form2 = cxt.form;
  var doc = cxt.form.getDocument();
  let data = await new RichDocService(form2).setAuthorityTree(form2.formKey, doc, args[0]);
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  if (dirtyDataTables) {
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var tableKey = dirtyDataTables[i2].tableKey;
      var dataTable = dirtyDataTables[i2].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = parentForm.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var isGrid = dirtyDataTables[i2].isGrid;
      if (!isGrid) {
        dirtyDataTables[i2].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i2].gridKey;
        var grid = parentForm.getComponent(gridKey);
        var doc = parentForm.getDocument();
        var tableKey = dirtyDataTables[i2].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
      }
    }
  }
};
const SetAuthorityOrgVariableValue = async (evl, name2, cxt, args) => {
  var form2 = cxt.form;
  var parentForm2 = form2.getParentForm();
  let data = await new RichDocService(form2).setAuthorityOrgVariableValue(form2.formKey, form2.getDocument());
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  if (dirtyDataTables) {
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var tableKey = dirtyDataTables[i2].tableKey;
      var dataTable = dirtyDataTables[i2].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = parentForm2.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var isGrid = dirtyDataTables[i2].isGrid;
      if (!isGrid) {
        dirtyDataTables[i2].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i2].gridKey;
        var grid = parentForm2.getComponent(gridKey);
        var doc = parentForm2.getDocument();
        var tableKey = dirtyDataTables[i2].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
      }
    }
  }
};
const FullDelegationRights = async (evl, name2, cxt, args) => {
  const form2 = cxt.form;
  let data = await new RichDocService(form2).fullDelegationRights(form2.formKey, form2.getDocument());
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  if (dirtyDataTables) {
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var tableKey = dirtyDataTables[i2].tableKey;
      var dataTable = dirtyDataTables[i2].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = form2.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var isGrid = dirtyDataTables[i2].isGrid;
      if (!isGrid) {
        dirtyDataTables[i2].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i2].gridKey;
        var grid = form2.getComponent(gridKey);
        var doc = form2.getDocument();
        var tableKey = dirtyDataTables[i2].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
      }
    }
  }
};
const CloseEntryTree = async (evl, name2, cxt, args) => {
  $.fn.zTree.destroy(args[0] + "RoleOIDTree");
};
const SetAuthorityOidFieldValue = async (evl, name2, cxt, args) => {
  if (args[1] == -1) {
    let column = cxt.locationMap.FieldValue.getColumn();
    let row2 = cxt.locationMap.FieldValue.getRow();
    let cellDataAt = cxt.form.getComponent("FieldValue").getCellDataAt(row2, column);
    if (cellDataAt.value && cellDataAt.value) {
      if (cellDataAt.value.oid == -1 && !cellDataAt.value.editValue.includes("*")) {
        if (cellDataAt.value.editValue == "") {
          args[1] = "";
        } else {
          args[1] = -1;
        }
      } else if (cellDataAt.value.editValue.includes("*") && args[0] != "TOCode") {
        args[1] = cellDataAt.value.editValue;
      } else {
        args[1] = cellDataAt.value.code;
      }
    }
  }
  await SetValue(evl, name2, cxt, args);
};
const SetAuthorityFieldValue = async (evl, name2, cxt, args) => {
  let dataTable = cxt.form.getDocument().getByKey("EAuthorityFieldValue");
  let rows = dataTable.rows;
  var values = [];
  var valuesOID = [];
  for (let i2 = 0; i2 < rows.length; i2++) {
    dataTable.setPos(i2);
    if (dataTable.getState() == DataDef.R_Deleted) {
      continue;
    }
    let toValue = dataTable.getByKey("TO");
    let toValueOID = dataTable.getByKey("TOCode");
    let formValue = dataTable.getByKey("From");
    if (formValue === "*") {
      values = [];
      values.push(formValue);
      break;
    }
    let formValueOID = dataTable.getByKey("FromCode");
    if (toValue) {
      values.push(formValue + "~" + toValue);
      if (formValueOID == -1) {
        formValueOID = "*";
      }
      if (toValueOID == -1) {
        toValueOID = "*";
      }
      valuesOID.push(formValueOID + "~" + toValueOID);
    } else {
      values.push(formValue);
      if (formValueOID == -1) {
        formValueOID = "*";
      }
      valuesOID.push(formValueOID);
    }
  }
  let pForm = FormStack.getForm(cxt.form.pFormID);
  let context = new ViewContext(pForm);
  await pForm.setValue("AuthorityFieldValue", values.toString(), context);
  await pForm.setValue("AuthorityFieldValueOID", valuesOID.toString(), context);
  if (pForm.getValue("ObjectStatus", context) == "U") {
    pForm.setValue("ObjectStatus", "G", context);
  } else {
    pForm.setValue("ObjectStatus", "M", context);
  }
};
const DeleteEmptyRow = async (evl, name2, cxt, args) => {
  async function CleanAllAndSetValue(comp22) {
    if (comp22.type == ControlType.GRID) {
      var grid = comp22, gotEmpty = false;
      var datas = grid.getDatas();
      for (var i2 = datas.length - 1; i2 >= 0; i2--) {
        var rowData = datas[i2];
        if (rowData.rowType != "Detail") {
          continue;
        }
        rowData.isAutoRow = false;
        if (!gotEmpty && rowData.bkmkRow == null) {
          gotEmpty = true;
          await grid.deleteRow(i2, false);
        }
      }
      grid.rowCountChanged();
      await grid.getHandler().rowDelete(grid, 0);
      grid.refreshGrid();
    }
  }
  var comp2 = cxt.form.getComponent("FieldValue");
  await CleanAllAndSetValue(comp2);
  return false;
};
const SetAuthorityOrgVariableAllValue = async (evl, name2, cxt, args) => {
  async function CleanAllAndSetValue(comp22) {
    if (comp22.type == ControlType.GRID) {
      var grid = comp22, gotEmpty = false;
      var datas = grid.getDatas();
      for (var i2 = datas.length - 1; i2 >= 0; i2--) {
        var rowData = datas[i2];
        if (rowData.rowType != "Detail") {
          continue;
        }
        if (!gotEmpty && rowData.bkmkRow == null) {
          gotEmpty = true;
          continue;
        }
        if (rowData.data[0].value == true || args[0]) {
          rowData.data[2].value = "*";
          rowData.data[2].caption = "*";
        }
      }
      grid.refreshGrid();
    }
  }
  var comp2 = cxt.form.getComponent("FieldValue");
  let document2 = cxt.form.getDocument();
  let table = document2.getByKey(comp2.tableKey);
  let rows = table.rows;
  for (let i2 = 0; i2 < rows.length; i2++) {
    table.setPos(i2);
    let selectField = table.getByKey("SelectField");
    if (selectField == 1 || args[0]) {
      table.setByKey("AuthorityFieldValue", "*");
      table.setByKey("AuthorityFieldValueOID", "*");
    }
  }
  await CleanAllAndSetValue(comp2);
  return false;
};
const ShowAuthorityFieldForm = async (evl, name2, cxt, args) => {
  var args1 = [args[0]];
  args1.push("SetPara('AuthorityFieldDataElementKey','" + cxt.form.getValue("AuthFieldValueDataElementKey", cxt) + "');SetPara('AuthorityFieldOIDValue','" + cxt.form.getValue("AuthorityFieldValueOID", cxt) + "');SetPara('AuthorityFieldValue','" + cxt.form.getValue("AuthorityFieldValue", cxt) + "');LoadData();");
  args1.push("modal");
  args1.push("New");
  await ERPShowModal(null, name2, cxt, args1);
};
const ModifyAuthorityObject = async (evl, name2, cxt, args) => {
  var form2 = cxt.form;
  var doc = form2.getDocument();
  let data = await new RichDocService(form2).modifyAuthorityObject(form2.formKey, doc, args[0], args[1]);
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  if (dirtyDataTables) {
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var tableKey = dirtyDataTables[i2].tableKey;
      var dataTable = dirtyDataTables[i2].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = form2.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var isGrid = dirtyDataTables[i2].isGrid;
      if (!isGrid) {
        dirtyDataTables[i2].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i2].gridKey;
        var grid = form2.getComponent(gridKey);
        var doc = form2.getDocument();
        var tableKey = dirtyDataTables[i2].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
      }
    }
  }
};
const selectAllChildrens = async (evl, name2, cxt, args) => {
  let component = cxt.form.getComponent("Grid1");
  let focusRowIndex = component.getFocusRowIndex() + 1;
  component.getFocusColIndex();
  let tableKey = component.getTableKey();
  let data = cxt.form.document.getByKey(tableKey);
  let rows = data.rows;
  data.setPos(focusRowIndex);
  var newvalue = data.getByKey(args[0]);
  var fieldKey = data.getByKey("FieldKey");
  for (let i2 = focusRowIndex; i2 < rows.length; i2++) {
    data.setPos(i2);
    let parentKey = data.getByKey("ParentKey");
    if (fieldKey == parentKey) {
      data.setByKey(args[0], newvalue);
    }
  }
  component.refreshSelect();
};
const RoleInheritanceProcessing = async (evl, name2, cxt, args) => {
  var form2 = cxt.form;
  var parentForm2 = form2.getParentForm();
  let data = await new RichDocService(form2).roleInheritanceProcessing(form2.formKey, args[0], args[1], args[2]);
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  if (dirtyDataTables) {
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var tableKey = dirtyDataTables[i2].tableKey;
      var dataTable = dirtyDataTables[i2].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = parentForm2.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var isGrid = dirtyDataTables[i2].isGrid;
      if (!isGrid) {
        dirtyDataTables[i2].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i2].gridKey;
        var grid = parentForm2.getComponent(gridKey);
        var doc = parentForm2.getDocument();
        var tableKey = dirtyDataTables[i2].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
      }
    }
  }
};
const RolePermissionParameterProcessing = async (evl, name2, cxt, args) => {
  var form2 = cxt.form;
  let data = await new RichDocService(cxt.form).rolePermissionParameterProcessing(form2.formKey, form2.getDocument(), args[0], args[1], args[2]);
  let dirtyDataTables = data.formDirtyDatas[0].dirtyData.dirtyDataTables;
  if (dirtyDataTables) {
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var tableKey = dirtyDataTables[i2].tableKey;
      var dataTable = dirtyDataTables[i2].dataTable;
      dataTable = DataUtil.fromJSONDataTable(dataTable);
      var doc = form2.getDocument();
      doc.setByKey(tableKey, dataTable);
    }
    for (var i2 = 0; i2 < dirtyDataTables.length; i2++) {
      var isGrid = dirtyDataTables[i2].isGrid;
      if (!isGrid) {
        dirtyDataTables[i2].oneTableFieldDirtyData;
      } else {
        var gridKey = dirtyDataTables[i2].gridKey;
        var grid = form2.getComponent(gridKey);
        var doc = form2.getDocument();
        var tableKey = dirtyDataTables[i2].tableKey;
        var dataTable = doc.getByKey(tableKey);
        dataTable.beforeFirst();
        grid.rootGroupBkmk = [];
        grid.pageInfo.currentPage = 1;
        await grid.load(true);
      }
    }
  }
};
const CheckDataAuthority = async (evl, name2, cxt, args) => {
  let form2 = cxt.form;
  if (args.length == 0 && !form2.Activity) {
    checkParamNum(name2, args, 1);
  }
  let activity = form2.Activity;
  if (args.length == 1) {
    activity = args[0];
  }
  await form2.checkDataAuthority(activity);
};
const GetEntryTCode = async (evl, name2, cxt, args) => {
  let form2 = cxt.form;
  let entryKey = GetFormEntryKey(evl, "GetFormEntryKey", cxt);
  if (entryKey) {
    return await form2.getEntryTCode(entryKey);
  } else {
    return form2.TCode;
  }
};
const RightsFuns = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  CheckDataAuthority,
  CloseEntryTree,
  DeleteEmptyRow,
  FullDelegationRights,
  GetEntryTCode,
  ModifyAuthorityObject,
  RoleInheritanceProcessing,
  RolePermissionParameterProcessing,
  SetAuthorityFieldValue,
  SetAuthorityOidFieldValue,
  SetAuthorityOrgVariableAllValue,
  SetAuthorityOrgVariableValue,
  SetAuthorityTree,
  SetEntryTree,
  ShowAuthorityFieldForm,
  ShowEntryChildTree,
  selectAllChildrens
}, Symbol.toStringTag, { value: "Module" }));
FuncMap.regCluster(FI_ReportModeFun);
FuncMap.regCluster(ERPBaseFun);
FuncMap.regCluster(MathFun);
FuncMap.regCluster(OptFunExt);
FuncMap.regCluster(ReportModelFunExt);
FuncMap.regCluster(UIFunExt);
FuncMap.regCluster(AdvancedQueryFun);
FuncMap.regCluster(DictTraceFun);
FuncMap.regCluster(GridSettingVariantFun);
FuncMap.regCluster(RightsFuns);
const columnKeyMap = {
  "Name": "AttachName",
  "UploadOperator": "UploadOperatorID"
};
class AttachmentMgr {
  static getImpl(form2, grid, tableKey) {
    const operatorIDField = form2.getCellByDataBinding(tableKey, AttachField.UPLOAD_OPERATOR_ID);
    const operatorField = form2.getCellByDataBinding(tableKey, AttachField.UploadOperator);
    return !operatorField && operatorIDField ? this : null;
  }
  static refreshGrid(form2, grid, data, tableKey, rowIndex, field) {
    if (field === AttachField.UPLOAD_OPERATOR_ID) {
      return;
    }
    const cellKey = this.getCellColumnKey(field);
    let cell = form2.getCellByDataBinding(tableKey, cellKey);
    if (cell == null) {
      cell = form2.getLvColumnByDataBinding(tableKey, cellKey);
    }
    if (cell) {
      return grid.setValueByKey(rowIndex, cell.key, data[field], true, true, true);
    }
  }
  static getCellColumnKey(field) {
    const columnKey = columnKeyMap[field];
    return columnKey || field;
  }
}
AttachmentHandler.setRefreshGridMgr(AttachmentMgr);
LocalMenuFavoriteSetting.LocalMenuFavorite = false;
var language = CookiesUtil.get("locale");
if (language && language !== "zh-CN") {
  __variableDynamicImportRuntimeHelper(/* @__PURE__ */ Object.assign({}), `../../../erppublic/home/js/language/${language}/i18N.js`).catch((e) => {
  });
}
GridUIProcess.setLoadGridSettingVariant(WebPlugin.loadGridSettingVariant);
export {
  AutoRecord as A,
  DOMUtil as D,
  ERPBusinessLock as E,
  FormExt as F,
  HistorySetting as H,
  Polling as P,
  RecordCase as R,
  ShowHelpTxt as S
};
//# sourceMappingURL=erp-yes-core-25f33c37.js.map
