/**
 * YIGO ERP首页图表js
 */
var $ = $ || parent.$;
$(function () {
    var getUrlParam = function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) {
            return unescape(r[2]);
        }
        return null;
    }
    var formId = getUrlParam('formID');
    var form = parent.YIUI.FormStack.getForm(parseInt(formId));
    //现金流状况默认数据
    var defaultLineData = {
        id: 'grid0',
        legendData: ['流入', '流出'],
        xAxisData: [201605, 201606, 201607, 201608, 201609, 201610],
        seriesData: [
            {
                name: '流入',
                type: 'line',
                stack: '数量',
                data: [6000, 4455, 7500, 5566, 6978, 8000]
            },
            {
                name: '流出',
                type: 'line',
                stack: '数量',
                data: [3000, 2800, 4000, 3300, 4600, 4200]
            }
        ]
    }

    //资产负债默认数据
    var defaultGaugeData = {
        id: 'grid3',
        data: [{ value: 36, name: '负债率' }]
    }

    //采购价值走势
    var defaultAreaLineData = {
        id: 'grid1',
        legendData: ['采购额'],
        xAxisData: [201605, 201606, 201607, 201608, 201609, 201610],
        seriesData: [
            {
                name: '采购额',
                type: 'line',
                stack: '总量',
                itemStyle: { normal: { areaStyle: { type: 'default' } } },
                data: [3000, 6000, 2000, 4000, 3500, 6500]
            }
        ]
    }
    //销售额走势
    var defaultBarData = {
        id: 'grid2',
        legendData: ['销售额'],
        xAxisData: [201605, 201606, 201607, 201608, 201609, 201610],
        seriesData: [
            {
                name: '销售额',
                type: 'bar',
                barMaxWidth: 40,
                data: [50000, 90000, 45000, 60000, 80000, 70000]
            }
        ]
    }
    var defaultBestSite = '上海';

    //全国销售分布图
    var defaultMapData = {
        id: 'grid5',
        seriesData: [{ name: '上海', value: 999 },
        { name: '江苏', value: Math.round(Math.random() * 1000) },
        { name: '广东', value: Math.round(Math.random() * 1000) },
        { name: '河北', value: Math.round(Math.random() * 1000) },
        { name: '浙江', value: Math.round(Math.random() * 1000) },
        { name: '北京', value: Math.round(Math.random() * 1000) },
        { name: '四川', value: Math.round(Math.random() * 1000) },
        { name: '陕西', value: Math.round(Math.random() * 1000) },
        { name: '福建', value: Math.round(Math.random() * 1000) },
        { name: '重庆', value: Math.round(Math.random() * 1000) },
        { name: '安徽', value: Math.round(Math.random() * 1000) },
        { name: '湖北', value: Math.round(Math.random() * 1000) },
        { name: '江西', value: Math.round(Math.random() * 1000) },
        { name: '河南', value: Math.round(Math.random() * 1000) },
        { name: '湖南', value: Math.round(Math.random() * 1000) },
        { name: '辽宁', value: Math.round(Math.random() * 1000) },
        { name: '云南', value: Math.round(Math.random() * 1000) },
        { name: '新疆', value: Math.round(Math.random() * 1000) },
        { name: '吉林', value: Math.round(Math.random() * 1000) },
        { name: '贵州', value: Math.round(Math.random() * 1000) },
        { name: '黑龙江', value: Math.round(Math.random() * 1000) },
        { name: '青海', value: Math.round(Math.random() * 1000) },
        { name: '海南', value: Math.round(Math.random() * 1000) },
        { name: '西藏', value: Math.round(Math.random() * 1000) },
        { name: '香港', value: Math.round(Math.random() * 1000) },
        { name: '宁夏', value: Math.round(Math.random() * 1000) },
        { name: '台湾', value: Math.round(Math.random() * 1000) },
        { name: '甘肃', value: Math.round(Math.random() * 1000) },
        { name: '山西', value: Math.round(Math.random() * 1000) },
        { name: '山东', value: Math.round(Math.random() * 1000) },
        { name: '内蒙古', value: Math.round(Math.random() * 1000) },
        { name: '广西', value: Math.round(Math.random() * 1000) },
        { name: '天津', value: Math.round(Math.random() * 1000) },
        { name: '澳门', value: Math.round(Math.random() * 1000) },
        { name: '南海诸岛', value: Math.round(Math.random() * 1000) },
        ]
    }

    //画折线图
    var renderLine = function (datas) {
        option = {
            lineStyle: { width: 3 },
            tooltip: {
                trigger: 'axis'
            },
            legend: {
                data: datas.legendData
            },
            toolbox: {
                show: false
            },
            calculable: true,
            xAxis: [
                {
                    type: 'category',
                    boundaryGap: false,
                    axisTick: { show: false },
                    axisLine: { show: false },
                    axisLabel: {
                        rotate: 0,
                        textStyle: {
                            color: '#888888',
                            fontSize: 12
                        }
                    },
                    splitLine: { show: false },
                    data: datas.xAxisData
                }
            ],
            yAxis: [
                {
                    type: 'value',
                    splitNumber: 4,
                    axisTick: { show: false },
                    axisLine: { show: false },
                    axisLabel: {
                        rotate: 0,
                        textStyle: {
                            color: '#888888',
                            fontSize: 12
                        }
                    },
                    splitLine: {
                        show: true,
                        lineStyle: { color: '#f2f2f2' }
                    },
                    splitArea: { show: false }
                }
            ],
            grid: { x: 60, y: 25, x2: 29, y2: 40, borderWidth: 0 },
            color: [
                '#56aafb', '#1cd0c3'
            ],
            series: datas.seriesData
        };
        var myChart = echarts.init(document.getElementById(datas.id));
        myChart.setOption(option, true);
    }

    //画罗盘
    var renderGauge = function (datas) {
        option = {
            tooltip: {
                formatter: "{a} <br/>{b} : {c}%"
            },
            toolbox: {
                show: false
            },
            series: [
                {
                    type: 'gauge',
                    startAngle: 180,
                    endAngle: 0,
                    center: ['50%', '80%'],
                    radius: ['60%', '120%'],
                    axisLine: {
                        lineStyle: {
                            color: [
                                [0.2, '#00c6ee'],
                                [0.8, '#009de3'],
                                [1, '#007bac']
                            ],
                            width: '50%'
                        }
                    },
                    axisTick: {
                        show: false,
                    },
                    splitLine: {
                        show: false,
                        length: '5%',		//这个值用来决定axisLabel的位置
                    },
                    axisLabel: {           // 坐标轴文本标签，详见axis.axisLabel
                        formatter: function (v) {
                            switch (v + '') {
                                case '10': return '低';
                                case '50': return '中';
                                case '90': return '高';
                                default: return '';
                            }
                        },
                        textStyle: {
                            color: '#fff',
                            fontSize: 12,
                            fontFamily: "Microsoft YaHei",
                        }
                    },
                    pointer: {
                        width: '10%',
                        length: '90%',
                        color: 'rgba(228,255,254, 0.5)'
                    },
                    title: {
                        show: true,
                        offsetCenter: [0, '-60%'],
                        textStyle: {
                            color: '#fff',
                            fontSize: 16,
                            fontFamily: "Microsoft YaHei",
                        }
                    },
                    detail: {
                        show: true,
                        backgroundColor: 'rgba(0,0,0,0)',
                        borderWidth: 0,
                        borderColor: '#ccc',
                        width: 100,
                        height: 30,
                        offsetCenter: [0, -30],
                        formatter: '{value}%',
                        textStyle: {
                            fontSize: 20,
                            color: '#0fa7e6',
                        }
                    },
                    data: datas.data
                }
            ]
        };
        var myChart = echarts.init(document.getElementById(datas.id));
        myChart.setOption(option, true);
    }

    //画面积折线图
    var renderAreaLine = function (datas) {
        option = {
            tooltip: {
                trigger: 'axis'
            },
            legend: {
                data: datas.legendData
            },
            toolbox: {
                show: false
            },
            lineStyle: { width: 2, color: '#56aafb' },
            legendStyle: {
                show: false
            },
            calculable: true,
            xAxis: [
                {
                    type: 'category',
                    boundaryGap: false,
                    axisTick: { show: false },
                    axisLine: { show: false },
                    axisLabel: {
                        rotate: 0,
                        textStyle: {
                            color: '#888888',
                            fontSize: 12
                        }
                    },
                    splitLine: { show: false },
                    data: datas.xAxisData
                }
            ],
            yAxis: [
                {
                    type: 'value',
                    splitNumber: 4,
                    axisTick: { show: false },
                    axisLine: { show: false },
                    axisLabel: {
                        rotate: 0,
                        textStyle: {
                            color: '#888888',
                            fontSize: 12
                        }
                    },
                    splitLine: {
                        show: true,
                        lineStyle: { color: '#f2f2f2' }
                    },
                    splitArea: { show: false },
                }
            ],
            grid: { x: 80, y: 25, x2: 29, y2: 40, borderWidth: 0 },
            color: [
                '#33bbff'
            ],
            series: datas.seriesData
        };
        var myChart = echarts.init(document.getElementById(datas.id));
        myChart.setOption(option, true);
    }

    //画柱状图
    var renderBar = function (datas) {
        option = {
            tooltip: {
                trigger: 'axis'
            },
            legend: {
                data: datas.legendData
            },
            toolbox: {
                show: false
            },
            calculable: true,
            legendStyle: {
                show: false
            },
            xAxis: [{
                type: 'category',
                axisTick: { show: false },
                axisLine: { show: false },
                axisLabel: {
                    rotate: 0,
                    textStyle: {
                        color: '#888888',
                        fontSize: 12
                    }
                },
                data: datas.xAxisData,
                splitLine: { show: false },
            }],
            yAxis: [
                {
                    type: 'value',
                    splitNumber: 5,
                    axisTick: { show: false },
                    axisLine: { show: false },
                    axisLabel: {
                        rotate: 0,
                        textStyle: {
                            color: '#888888',
                            fontSize: 12
                        }
                    },
                    splitLine: {
                        show: true,
                        lineStyle: { color: '#f2f2f2' }
                    },
                    splitArea: {
                        show: true,
                        areaStyle: {
                            color: [
                                '#fff', '#fcfbfb'
                            ]
                        }
                    },
                }
            ],
            grid: { x: 80, y: 25, x2: 29, y2: 40, borderWidth: 0 },
            color: [
                '#43baf5', '#1cd0c3'
            ],
            series: datas.seriesData
        };
        var myChart = echarts.init(document.getElementById(datas.id));
        myChart.setOption(option, true);
    }

    //画地图数据
    var renderMap = function (datas) {
        var option = {
            tooltip: {
                trigger: 'item'
            },
            dataRange: {
                x: '-500',
                y: '-500',
                splitList: [
                    { start: 1200, end: 1500 },
                    { start: 900, end: 1200 },
                    { start: 600, end: 1000 },
                    { start: 200, end: 600 },
                    { start: 10, end: 200 },
                    { start: 0, end: 10 }
                ],
                color: ['#B0E2FF', '#cef4fc', '#7dbff0', '#51a3e9', '#007bac']
            },
            //配置属性
            series: [{
                name: '销量',
                type: 'map',
                mapType: 'china',
                roam: false,
                itemStyle: {
                    normal: {
                        default: '#CAE1FF',
                        borderWidth: .5,//区域边框宽度
                        borderColor: '#fff',//区域边框颜色
                        label: { show: true },
                        areaStyle: { color: "#B0E2FF" }
                    },
                    emphasis: {
                        borderColor: '#fff',
                        areaStyle: { color: '#C2C2C2' },
                        borderWidth: .5,
                        label: { show: true }
                    }
                },
                data: datas.seriesData
            }]
        };
        var myChart = echarts.init(document.getElementById(datas.id));
        myChart.setOption(option, true);
    }

    //公司指示与代办切换
    $('.index_tab_header li').mouseover(function () {
        var $this = $(this);
        var $t = $this.index();
        $('.index_tab_header li').removeClass();
        $this.addClass('current');
        $('.index_tab_content').css('display', 'none');
        $('.index_tab_content').eq($t).css('display', 'block');
    });


    // 当前Grid4 Data
    var saleMonthData;

    //构建请求
    var getData = function (params) {
        return new parent.Svr.Request(form).getData(params);
    }

    //格式化地区简称
    var simpleSite = function (site) {
        if(!site){
            return '';
        }
        var sim = site.substr(0, 3);
        if (sim == '内蒙古' || sim == '黑龙江') {
            return sim;
        }
        return site.substr(0, 2);
    }

    //数据渲染
    var renderData = function (data) {
        //现金流状况
        if (typeof data.grid0 != 'undefined' && data.grid0.length > 0) {
            var grid0 = JSON.parse(JSON.stringify(defaultLineData));
            var months = [];
            var inValue = [];
            var outValue = [];
            $.each(data.grid0, (i, val) => {
                months[i] = val.periodid;
                inValue[i] = val.invalue;
                outValue[i] = val.outvalue;
            });
            grid0.xAxisData = months;
            grid0.seriesData[0].data = inValue;
            grid0.seriesData[1].data = outValue;
            renderLine(grid0);
        } else {
            renderLine(defaultLineData);
        }


        //负债率
        if (typeof data.grid1 != 'undefined' && data.grid1.length > 0) {
            var grid1 = JSON.parse(JSON.stringify(defaultGaugeData));
            $.each(data.grid1, function (i, val) {
                grid1.data.value = parseInt(val.fzvalue / val.zcvalue * 100);
            });
            renderGauge(grid1);
        } else {
            renderGauge(defaultGaugeData);
        }


        //采购价值走势
        if (typeof data.grid2 != 'undefined' && data.grid2.length > 0) {
            var grid2 = JSON.parse(JSON.stringify(defaultAreaLineData));
            var months = [];
            var amount = [];
            $.each(data.grid2, function (i, val) {
                months[i] = val.months;
                amount[i] = val.amount;
            });
            grid2.xAxisData = months;
            grid2.seriesData.data = amount;
            renderAreaLine(grid2);
        } else {
            renderAreaLine(defaultAreaLineData);
        }

        //销售额走势
        if (typeof data.grid3 != 'undefined' && data.grid3.length > 0) {
            var grid3 = JSON.parse(JSON.stringify(defaultBarData));
            var months = [];
            var amount = [];
            $.each(data.grid3, function (i, val) {
                months[i] = val.months;
                amount[i] = val.amount;
            });
            grid3.xAxisData = months;
            grid3.seriesData.data = amount;
            renderBar(grid3);
        } else {
            renderBar(defaultBarData);
        }

        //月销量产品组
        $('#month').empty();
        $('#grid4Ul').empty();
        saleMonthData = '';
        if (typeof data.grid4 != 'undefined' && data.grid4.length > 0) {
            $.each(data.grid4, function (i, val) {
                $('#month').append('<option value="' + val.months + '">' + val.months + '</option>');
            });
            saleMonthData = data.grid4;
        }

        //全国销售分布图
        if (typeof data.grid5 != 'undefined' && data.grid5.length > 0) {
            var grid5 = JSON.parse(JSON.stringify(defaultMapData));
            var Quantity = [];
            var name = [];
            $.each(data.grid5, function (i, val) {
                Quantity[i] = val.quantity;
                name[i] = simpleSite(val.name);
            });
            $.each(grid5.seriesData, function (i, val) {
                var flag = true;
                $.each(name, function (j, val1) {
                    if (val.name == val1) {
                        val.value = Quantity[j];
                        flag = false;
                        return false;
                    }
                });
                if (flag) {
                    val.value = 0;
                }
            });
            renderMap(grid5);
        } else {
            renderMap(defaultMapData);
        }
        //销售冠军
        if (typeof data.bestSite != 'undefined') {
            $('#maxprovince').html(simpleSite(data.bestSite));
        } else {
            $('#maxprovince').html(defaultBestSite);
        }
    }

    //公司选择
    $('#company').change(function () {
        var company = $(this).val();
        var result = [];
        result.push({ 'value': company, 'dataType': 2 });
        getData({
            service: "InvokeService",
            extSvrName: "ERPIndexService",
            paras: JSON.stringify(result)
        }).then(function (data) {
            if (typeof data == 'undefined') {
                renderLine(defaultLineData);
                renderGauge(defaultGaugeData);
                renderAreaLine(defaultAreaLineData);
                renderBar(defaultBarData);
                renderMap(defaultMapData);
                return;
            }
            renderData(data);
            if (typeof saleMonthData != 'undefined' && saleMonthData.length > 0) {
                renderGrid4(saleMonthData[0].months);
            }
        });
    });

    //月份选择
    $('#month').change(function () {
        renderGrid4($(this).val());
    });

    //渲染月销售产品组
    var renderGrid4 = function (month) {
        var val;
        $('#grid4Ul').empty();
        if (typeof saleMonthData != 'undefined' && saleMonthData.length > 0) {
            $.each(saleMonthData, function (i, v) {
                if (v.months == month) {
                    val = v;
                    return false;
                }
            });
        }
        if (typeof val == 'undefined') {
            return;
        }
        var num = parseInt(val.rate * 100);
        $('#grid4Ul').append('<li>' +
            '<span class="sp1">' + val.divisionName + '</span>' +
            '<div class="progress">' +
            '<div class="progress-bar progress-bar-success" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width:' + num + '%;"></div>' +
            '<span class="sp2">' + num + '%</span>' +
            '</div>' +
            '</li>');
    }

    //行点击事件
    $('#gridData').delegate('tr', 'click', async function () {
        var wid = $(this).find('td:eq(0)').attr('id');
        var cxt = new parent.View.Context(form);
        var result = await form.eval('OpenWorkitem("' + wid + '")', cxt);
    });

    getData({
        service: "InvokeService",
        extSvrName: "ERPIndexService",
        paras: {}
    }).then(function (data) {
        if (typeof data == 'undefined') {
            renderLine(defaultLineData);
            renderGauge(defaultGaugeData);
            renderAreaLine(defaultAreaLineData);
            renderBar(defaultBarData);
            renderMap(defaultMapData);
            return;
        }
        //公司代码
        if (typeof data.CompanyCodes != 'undefined') {
            $('#company').empty();
            $.each(data.CompanyCodes, function (i, val) {
                $('#company').append('<option value="' + val.oid + '">' + val.name + '</option>');
            });
        }
        //待办事项
        if (typeof data.toDoList != 'undefined') {
            $.each(data.toDoList, function (i, val) {
                $('#gridData').append('<tr>' +
                    '<td id="' + val.workitemid + '">' + i + '</td>' +
                    '<td>' + val.workitemname + '</td>' +
                    '<td>' + val.creattime + '</td>' +
                    '<td>' + val.formname + '</td>' +
                    '<td>' + val.documentnumber + '</td>' +
                    '</tr>'
                );
            });
        }
        renderData(data);
    });
});