  // 从其他报表复制来的取URL参数函数
  var getRequestParameters = function(){
  //返回当前 URL 的查询部分（问号 ? 之后的部分）。
      var urlParameters = location.search;
      //声明并初始化接收请求参数的对象
      var requestParameters = new Object();
      //如果该求青中有请求的参数，则获取请求的参数，否则打印提示此请求没有请求的参数
      if (urlParameters.indexOf('?') != -1){
          //获取请求参数的字符串
          var parameters = decodeURI(urlParameters.substr(1));
          //将请求的参数以&分割中字符串数组
          parameterArray = parameters.split('&');
          //循环遍历，将请求的参数封装到请求参数的对象之中
          for (var i = 0; i < parameterArray.length; i++) {
              requestParameters[parameterArray[i].split('=')[0]] = (parameterArray[i].split('=')[1]);
          }
      }
      return requestParameters;
    };

    //获取屏幕宽度和当前节点计算比例：res为调整占比，counter为物料个数
    function fontSize(fixedSize, counter){
        let clientWidth = document.documentElement.clientWidth||document.body.clientWidth;
        if (!clientWidth) return fixedSize;
        let rate = Math.sqrt(clientWidth); 
        let newSize = fixedSize;
        if (counter<rate){
          return newSize;
        }
        else {
          let reCount = counter / rate;
          newSize = fixedSize/2;
          return fontSize(newSize, reCount);
        }
        return newSize;
    };

    //构建请求
    var getData = function (params) {
        return new parent.Svr.Request(form).getData(params)
        .then(function (result) {
             if (result) {
              renderGraph(result);
              var currentNodeData = result.headInfo["currentNode"];
              return currentNodeData;
             };
        });
    };
    // 画布展示
    var renderGraph = function (retData) {
      if (typeof retData.headInfo === "object") {
      // dom 初始化
      var dom = document.getElementById('container');
      var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
      });
      // 返回的节点集合
      var optionDatas = [];
      // 返回的线集合
      var optionLinks = [];
      var nodeColumns = new Object();;
      // 取总节点数
      let nodeCounter = new Number(retData.headInfo["nodeCounter"]);
      // 取线总条数
      let linkCounter = new Number(retData.headInfo["linkCounter"]);
      // 取当前节点，用做高亮显示
      var currentNodeData = retData.headInfo["currentNode"];
      // 取标题
      var titleInfo = retData.headInfo["titleInfo"];
      // 取初始节点大小（单个节点内可自定义大小）
      var nodeFixedSize = retData.headInfo["nodeFontSize"];
      // 取边的标签字体大小
      var labelFontSize = retData.headInfo["labelFontSize"];
      // 每个节点内包含的各种信息
      nodeColumns[currentNodeData["id"]] = currentNodeData["columns"];
      optionDatas.push(
        {id: currentNodeData["id"],
         name: currentNodeData["name"],
         draggable: true, 
         x: currentNodeData["x"],
         y: currentNodeData["y"],
         value: currentNodeData["value"],
         label: {
          normal:{
            fontSize:fontSize(labelFontSize, nodeCounter),
          }
         }
        }
      );
      if (nodeCounter > 1) {
        // 解析处理多个节点设置内容
        for (let i=1;i<=nodeCounter;i++) {
          var nodeData = retData.datas["nodeData"+i];
          if (typeof nodeData === "object") {
            nodeColumns[nodeData["id"]] = nodeData["columns"];
            optionDatas.push(
              {id: nodeData["id"],
               name: nodeData["name"],
               draggable: true, 
               x: nodeData["x"],
               y: nodeData["y"],
               value: nodeData["value"],
               label: {
                normal:{
                  fontSize:fontSize(labelFontSize, nodeCounter),
                }
               }
              }
            );
          }
        };
      };

      // 解析线内容
      if (linkCounter > 0) {
        for (let j=1;j<=linkCounter;j++) {
          var linkData = retData.links["link"+j];
          var curvenessData = linkData["curvenessData"];
          var lineColor = linkData["lineStyleColor"];
          optionLinks.push(
              {
                source: linkData["source"],
                target: linkData["target"],
                lineStyle: {
                    curveness: curvenessData,
                    color: lineColor
                },//设置弧度，循环图直线可能会重叠
                value: linkData["lineValue"],
                label: {
                  normal: {
                    show: true,
                    fontSize: fontSize(labelFontSize, linkCounter),
                    formatter:linkData["lineLabel"]
                  }
                }
              }
          );
        };
      }
      // 设置内容
      var option;
      option = {
        title: {
          text: titleInfo
        },
        name,tooltip: {
          formatter:function (params){
              var dataValueStr = params.data.value;
              var retNameStr = "";
              if (typeof(dataValueStr) == "string") {
                var dataNameArr =  dataValueStr.split("\r\n");
                retNameStr = dataNameArr[0];
                for (let i=1; i<dataNameArr.length; i++) {
                  retNameStr = retNameStr + '<br/>' +dataNameArr[i];
                }
                return retNameStr;
              }
              return retNameStr;
          }
        },
        series: [
          {
            type: 'graph',
            layout: 'none',
            symbolSize: fontSize(nodeFixedSize, nodeCounter),
            roam: true,
            label: {
              show: true
            },
            edgeSymbol: ['circle', 'arrow'],
            // edgeSymbolSize: [4, 10],
            // edgeLabel: {
            //   fontSize: 20
            // },
            // 节点
            data: optionDatas,
            // 边
            links: optionLinks,
            // 选择的当前节点设置高亮
            itemStyle: {
              normal: {
                color: function (params) {
                  if (params.dataIndex == 0) {
                    return 'LightSkyBlue';
                  }
                  else {
                    return 'LightSteelBlue';
                  }
                }
              }
            },
            textStyle:{
              normal:{
                fontSize:function (params) {
                  return 50;
                }
              }
            },
            // 设置线格式
            lineStyle: {
              opacity: 0.9,
              width: 2,
              curveness: 0
            }
          }
        ]};

        if (option && typeof option === 'object') {
          myChart.setOption(option);
        }

        // 双击事件
        myChart.on('dblclick', function(params){
          var cxt = new parent.YIUI.ViewContext(form);
          var tempPara = nodeColumns[params.data["id"]];
          if (typeof tempPara == "string") {
            form.asyncEval("Macro_Analys_ShowEvent("+tempPara+")", cxt);
          }
        });

        //单击事件
        myChart.on('click', function(params){
          var cxt = new parent.YIUI.ViewContext(form);
          var tempPara = nodeColumns[params.data["id"]];
          if (typeof tempPara == "string") {
            form.asyncEval("Macro_Show_NodeDiscribe("+nodeColumns[params.data["id"]]+")", cxt);
          }
        });
      };
    };

    // 取参数 转换 以下是主程序调用入口
    var paras = getRequestParameters();
    // 当前Form
    var form = parent.YIUI.FormStack.getForm(paras.formID);
    var parasData = [];

    parasData.push({ 'value': paras.PlantCode, 'dataType': 2 });
    parasData.push({ 'value': paras.MaterialCode, 'dataType': 2 });
    parasData.push({ 'value': paras.ValuationTypeCode, 'dataType': 2 });
    parasData.push({ 'value': paras.WBSElementCode, 'dataType': 2 });
    parasData.push({ 'value': paras.SaleOrderBillCode, 'dataType': 2 });
    parasData.push({ 'value': paras.SalesOrderItemNumber, 'dataType': 2 });
    parasData.push({ 'value': paras.FiscalYear, 'dataType': 2 }); 
    parasData.push({ 'value': paras.FiscalPeriod, 'dataType': 2 });
    parasData.push({ 'value': paras.IsOnlyReceiveMaterial, 'dataType': 2 });
    parasData.push({ 'value': window.innerWidth, 'dataType': 2 });
    parasData.push({ 'value': window.innerHeight, 'dataType': 2 });
    parasData.push({ 'value': paras.formID, 'dataType': 2 });
    var params = {
        cmd: "InvokeExtServiceCmd",
        service: "InvokeService",
        extSvrName: "GraphPrintService",
        paras: JSON.stringify(parasData)
    };
    getData(params).then(function(currentNodeData){
        var cxt = new parent.YIUI.ViewContext(form);
        form.asyncEval("Macro_Show_NodeDiscribe("+currentNodeData["columns"]+")", cxt);
    });