/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    public static String File2String(String srcPath, String encoding) throws Throwable {
        String content = null;
        byte[] bytes = null;
        File srcFile = null;
        try (FileInputStream fin = null;){
            srcFile = new File(srcPath);
            if (!srcFile.exists()) {
                throw new Exception("file not exists:" + srcPath);
            }
            bytes = new byte[(int)srcFile.length()];
            if (srcFile.canRead()) {
                fin = new FileInputStream(srcFile);
                fin.read(bytes);
                content = encoding != null ? new String(bytes, encoding) : new String(bytes);
            }
        }
        return content;
    }

    public static File String2File(String str, String filePath, String charset) throws IOException {
        if (filePath == null || filePath.equals("") || filePath.length() == 0) {
            return null;
        }
        File destFile = new File(filePath);
        return FileUtil.String2File(str, destFile, charset, false);
    }

    public static File String2File(String str, String filePath, String charset, boolean bAppend) throws IOException {
        if (filePath == null || filePath.equals("") || filePath.length() == 0) {
            return null;
        }
        File destFile = new File(filePath);
        return FileUtil.String2File(str, destFile, charset, bAppend);
    }

    public static File String2File(String str, File destFile, String charset, boolean append) throws IOException {
        byte[] bytes = null;
        if (destFile == null) {
            return null;
        }
        try (OutputStream out = null;){
            File parentFile;
            if (!destFile.exists() && !(parentFile = destFile.getParentFile()).exists()) {
                parentFile.mkdirs();
            }
            out = new FileOutputStream(destFile, append);
            bytes = charset != null ? str.getBytes(charset) : str.getBytes();
            out.write(bytes);
            out.flush();
        }
        return destFile;
    }

    public static File String2File(String str, File destFile, String charset) throws IOException {
        return FileUtil.String2File(str, destFile, charset, false);
    }

    static boolean isURLPath(String fileName) {
        return fileName != null && (fileName.startsWith("http:") || fileName.startsWith("rmi:"));
    }

    public static File String2File(String str, String fileName) throws IOException {
        return FileUtil.String2File(str, fileName, null);
    }

    public static void deleteFile(File fd) {
        File[] fs = fd.listFiles();
        if (fs != null) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FileUtil.deleteFile(f);
                }
                if (f.canWrite()) {
                    f.delete();
                }
                ++n2;
            }
        }
        if (fd.canWrite()) {
            fd.delete();
        }
    }

    public static String getPostFix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return null;
    }
}

