/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ClassNameThreadFactoryBuilder {
    public static ThreadFactory build(Class classz) {
        return ClassNameThreadFactoryBuilder.build(classz, true);
    }

    public static ThreadFactory build(Class classz, boolean simpleName) {
        String className = simpleName ? classz.getSimpleName() : classz.getName();
        String format = String.valueOf(className) + "-pool-thread-%d";
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(format).build();
        return threadFactory;
    }

    private static final class ThreadFactoryBuilder {
        private String nameFormat = null;

        public ThreadFactoryBuilder setNameFormat(String nameFormat) {
            String.format(nameFormat, 0);
            this.nameFormat = nameFormat;
            return this;
        }

        public ThreadFactory build() {
            return ThreadFactoryBuilder.build(this);
        }

        private static ThreadFactory build(ThreadFactoryBuilder builder) {
            String nameFormat = builder.nameFormat;
            ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
            AtomicLong count = nameFormat != null ? new AtomicLong(0L) : null;
            return runnable -> {
                Thread thread = backingThreadFactory.newThread(runnable);
                if (nameFormat != null) {
                    thread.setName(String.format(nameFormat, count.getAndIncrement()));
                }
                return thread;
            };
        }
    }
}

