/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.performance;

import com.bokesoft.erp.performance.ActionRecorder;
import com.bokesoft.erp.performance.trace.ITraceObject;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Performance {
    public static boolean RUN_IN_DEBUG = true;
    private static ThreadLocal<ActionRecorder> t = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(Performance.class);
    public static boolean isDebug = logger.isInfoEnabled();
    private static boolean isPrintCompleteSql = false;

    public static void setPrintCompleteSql(boolean isPrintCompleteSql) {
        Performance.isPrintCompleteSql = isPrintCompleteSql;
    }

    public static boolean isIsPrintCompleteSql() {
        return isPrintCompleteSql;
    }

    public static int startFirstAction(Object ... objects) {
        if (!isDebug) {
            return -1;
        }
        ActionRecorder recorder = t.get();
        if (recorder != null) {
            logger.warn("startFirstRecord()\u65b9\u6cd5\u8c03\u7528\u9519\u8bef\uff0c\u4e4b\u524d\u8c03\u7528\u8fc7\u8fd9\u4e2a\u65b9\u6cd5\u3002");
        } else {
            recorder = new ActionRecorder();
            t.set(recorder);
        }
        return Performance.startAction(objects);
    }

    public static int startAction(Object ... objects) {
        if (!isDebug) {
            return -1;
        }
        ActionRecorder recorder = t.get();
        Object actionName = objects == null ? "" : (objects.length == 1 ? objects[0] : Performance.getActionName(objects));
        if (recorder == null) {
            logger.info(actionName == null ? "null" : actionName.toString());
            return -1;
        }
        return recorder.startAction(actionName);
    }

    public static Object getActionName(Object[] objects) {
        StringBuilder sb = new StringBuilder(1024);
        int i = 0;
        int len = objects.length;
        while (i < len) {
            Object tmp = objects[i];
            if (tmp != null) {
                if (tmp instanceof QueryArguments) {
                    Performance.getQueryArgumentsString((QueryArguments)tmp, sb);
                } else if (tmp instanceof List) {
                    Performance.getListString((List)tmp, sb);
                } else {
                    if (tmp instanceof String && ((String)tmp).contains("?")) {
                        sb.append("\n");
                    }
                    sb.append(tmp);
                }
            }
            ++i;
        }
        String actionName = sb.toString();
        return actionName;
    }

    public static String getPrintCompleteSql(Object[] objects) {
        if (!Performance.isIsPrintCompleteSql()) {
            return "";
        }
        QueryArguments curArguments = null;
        ArrayList list = null;
        String[] sql = null;
        int i = 0;
        int len = objects.length;
        while (i < len) {
            Object tmp = objects[i];
            if (tmp != null) {
                if (tmp instanceof QueryArguments) {
                    curArguments = (QueryArguments)tmp;
                } else if (tmp instanceof List) {
                    list = (ArrayList)tmp;
                } else if (tmp instanceof String && ((String)tmp).contains("?")) {
                    sql = ((String)tmp).split("\\?");
                }
            }
            ++i;
        }
        StringBuilder sbags = new StringBuilder(1024);
        if (curArguments != null) {
            Performance.getQueryArgumentsString(curArguments, sbags);
        } else {
            Performance.getListString(list, sbags);
        }
        StringBuilder sb = new StringBuilder(1024);
        Performance.getPrintCompleteSql(sb, curArguments, list, sql);
        if (sbags.length() > 0 && sb.length() > 0) {
            return "\nSQL\u53c2\u6570:[" + sbags + "]" + "\n" + "\u5b8c\u6574SQL:[" + sb + "]";
        }
        if (sbags.length() > 0 && sb.length() == 0) {
            return "\nSQL\u53c2\u6570:[" + sbags + "]";
        }
        if (sbags.length() == 0 && sb.length() > 0) {
            return "\n\u5b8c\u6574SQL:[" + sb + "]";
        }
        return sb.toString();
    }

    private static void getPrintCompleteSql(StringBuilder sb, QueryArguments curArguments, ArrayList list, String[] sql) {
        if (sql != null && sql.length > 0) {
            ArrayList<SqlString> sqlStrings = new ArrayList<SqlString>();
            if (curArguments != null) {
                SqlString completeSql = new SqlString();
                sqlStrings.add(completeSql);
                int i1 = 0;
                while (i1 < sql.length) {
                    completeSql.append(new Object[]{sql[i1]});
                    if (i1 < curArguments.size()) {
                        if (curArguments.get(i1) instanceof String) {
                            completeSql.appendPara((Object)("'" + curArguments.get(i1) + "'"));
                        } else {
                            completeSql.appendPara(curArguments.get(i1));
                        }
                    }
                    ++i1;
                }
            } else if (list != null && list.size() > 0) {
                int i = 0;
                while (i < list.size()) {
                    if (list.get(i) instanceof QueryArguments && sqlStrings.size() < 100) {
                        QueryArguments psArgs = (QueryArguments)list.get(i);
                        SqlString completeSql = new SqlString();
                        sqlStrings.add(completeSql);
                        int i1 = 0;
                        while (i1 < sql.length) {
                            completeSql.append(new Object[]{sql[i1]});
                            if (i1 < psArgs.size()) {
                                if (psArgs.get(i1) instanceof String) {
                                    completeSql.appendPara((Object)("'" + psArgs.get(i1) + "'"));
                                } else {
                                    completeSql.appendPara(psArgs.get(i1));
                                }
                            }
                            ++i1;
                        }
                    }
                    ++i;
                }
            }
            if (sqlStrings.size() > 0) {
                int i = 0;
                while (i < sqlStrings.size()) {
                    SqlString sqlString = (SqlString)sqlStrings.get(i);
                    if (i > 0) {
                        sb.append("\n");
                    }
                    sb.append(sqlString.getCompleteSql());
                    ++i;
                }
            }
        }
    }

    public static void subAction(int action, String info) {
        if (action == -1 || !isDebug) {
            return;
        }
        ActionRecorder recorder = t.get();
        recorder.startSubAction(action, info);
    }

    public static void endActive(int action, Object ... objects) {
        if (action == -1 || !isDebug) {
            Object actionName = objects == null ? "" : (objects.length == 1 ? objects[0] : Performance.getActionName(objects));
            logger.info(String.valueOf(actionName.toString()) + " endActive action=" + action);
            return;
        }
        ActionRecorder recorder = t.get();
        if (recorder != null) {
            recorder.endActive(action);
        }
    }

    public static String getString() {
        if (!isDebug) {
            return null;
        }
        ActionRecorder recorder = t.get();
        return recorder == null ? "NULL" : recorder.getString();
    }

    public static void printLog() {
        Performance.printLog(-1);
    }

    public static void printLog(int action) {
        if (!isDebug) {
            return;
        }
        ActionRecorder recorder = t.get();
        if (recorder != null) {
            recorder.printLog(action);
            if (action == -1) {
                t.set(null);
            }
        }
    }

    private static void getQueryArgumentsString(QueryArguments args, StringBuilder sb) {
        if (args != null) {
            int i = 0;
            int length = args.size();
            while (i < length) {
                if (i < 10) {
                    sb.append("#");
                    sb.append(i);
                    sb.append(":");
                }
                sb.append(args.get(i));
                if (i != length - 1) {
                    sb.append(" ");
                }
                if (sb.length() >= 8182) {
                    sb.append("......");
                    return;
                }
                ++i;
            }
        }
    }

    private static void getListString(List<?> list, StringBuilder sb) {
        if (list != null) {
            sb.append("[");
            int i = 0;
            int length = list.size();
            while (i < length) {
                Object tmp = list.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                if (tmp instanceof QueryArguments) {
                    Performance.getQueryArgumentsString((QueryArguments)tmp, sb);
                } else {
                    sb.append(tmp);
                }
                if (sb.length() >= 8182) {
                    sb.append("......");
                    return;
                }
                ++i;
            }
            sb.append("]");
        }
    }

    public static String getStackTraceString(ITraceObject formula) {
        ActionRecorder recorder = t.get();
        if (recorder == null) {
            return "";
        }
        return recorder.getStackTraceString(formula);
    }
}

