/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.utils;

import com.bokesoft.erp.billentity.EFI_IntegrationRelation;
import com.bokesoft.erp.billentity.EFI_VoucherDtl_Entry;
import com.bokesoft.erp.billentity.EFM_PostLedgerPeriod;
import com.bokesoft.erp.billentity.FI_Voucher;
import com.bokesoft.erp.billentity.FM_CommitmentItem;
import com.bokesoft.erp.billentity.FM_FinancialManagementArea;
import com.bokesoft.erp.billentity.FM_FundCenter;
import com.bokesoft.erp.billentity.FM_FundVoucher;
import com.bokesoft.erp.billentity.IntegrationRelation;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;

public class FMVoucherCheckUtil
extends EntityContextAction {
    public FMVoucherCheckUtil(RichDocumentContext _context) {
        super(_context);
    }

    public void checkTimeOpen(Long fmAreaID, FI_Voucher fi_Voucher, EFI_VoucherDtl_Entry dtlEntry, String valueType) throws Throwable {
        this.checkFundVoucher(fmAreaID, valueType, dtlEntry.getFundCenterID(), fi_Voucher.getFiscalYear(), fi_Voucher.getFiscalPeriod());
        this.checkFundVoucherCommit(fmAreaID, valueType, dtlEntry.getCommitmentItemID(), fi_Voucher.getFiscalYear(), fi_Voucher.getFiscalPeriod());
    }

    private void checkFundVoucher(Long FinancialManagementAreaID, String valType, Long fundCenterID, int FiscalYear, int period) throws Throwable {
        EFM_PostLedgerPeriod efmOpenTimeInter = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(FinancialManagementAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(FiscalYear).SubjectSetting("02").FundCenterID(fundCenterID).load();
        if (efmOpenTimeInter != null) {
            int periodFrom = efmOpenTimeInter.getFromFiscalPeriod();
            int periodTo = efmOpenTimeInter.getToFiscalPeriod();
            if (period < periodFrom || period > periodTo) {
                MessageFacade.throwException((String)"FMVOUCHERCHECKUTIL000", (Object[])new Object[]{this.getFMAreaName(FinancialManagementAreaID), FiscalYear, this.getFundCenterName(fundCenterID), period});
            }
        } else {
            efmOpenTimeInter = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(FinancialManagementAreaID).ValueType(valType).FiscalYear(FiscalYear).SubjectSetting("02").FundCenterID(fundCenterID).load();
            if (efmOpenTimeInter != null) {
                int periodFrom = efmOpenTimeInter.getFromFiscalPeriod();
                int periodTo = efmOpenTimeInter.getToFiscalPeriod();
                if (period < periodFrom || period > periodTo) {
                    MessageFacade.throwException((String)"FMVOUCHERCHECKUTIL000", (Object[])new Object[]{this.getFMAreaName(FinancialManagementAreaID), FiscalYear, this.getFundCenterName(fundCenterID), period});
                }
            } else {
                this.getErrMsg(FinancialManagementAreaID, valType, FiscalYear, period);
            }
        }
    }

    private void checkFundVoucherCommit(Long FinancialManagementAreaID, String valType, Long commitItemID, int FiscalYear, int period) throws Throwable {
        EFM_PostLedgerPeriod efmOpenTimeInter = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(FinancialManagementAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(FiscalYear).SubjectSetting("02").CommitmentItemID(commitItemID).load();
        if (efmOpenTimeInter != null) {
            int periodFrom = efmOpenTimeInter.getFromFiscalPeriod();
            int periodTo = efmOpenTimeInter.getToFiscalPeriod();
            if (period < periodFrom || period > periodTo) {
                MessageFacade.throwException((String)"FMVOUCHERCHECKUTIL002", (Object[])new Object[]{this.getFMAreaName(FinancialManagementAreaID), FiscalYear, this.getCommitItemName(commitItemID), period});
            }
        } else {
            efmOpenTimeInter = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(FinancialManagementAreaID).ValueType(valType).FiscalYear(FiscalYear).SubjectSetting("02").CommitmentItemID(commitItemID).load();
            if (efmOpenTimeInter != null) {
                int periodFrom = efmOpenTimeInter.getFromFiscalPeriod();
                int periodTo = efmOpenTimeInter.getToFiscalPeriod();
                if (period < periodFrom || period > periodTo) {
                    MessageFacade.throwException((String)"FMVOUCHERCHECKUTIL002", (Object[])new Object[]{this.getFMAreaName(FinancialManagementAreaID), FiscalYear, this.getCommitItemName(commitItemID), period});
                }
            } else {
                this.getErrMsg(FinancialManagementAreaID, valType, FiscalYear, period);
            }
        }
    }

    public String getFMAreaName(Long FinancialManagementAreaID) throws Throwable {
        FM_FinancialManagementArea finManagementArea = FM_FinancialManagementArea.load((RichDocumentContext)this.getMidContext(), (Long)FinancialManagementAreaID);
        return finManagementArea.getCodeName();
    }

    public String getFundCenterName(Long FundCenterID) throws Throwable {
        FM_FundCenter fmFundCenter = FM_FundCenter.load((RichDocumentContext)this.getMidContext(), (Long)FundCenterID);
        return fmFundCenter.getCodeName();
    }

    public String getCommitItemName(Long CommitmentItemID) throws Throwable {
        FM_CommitmentItem commitmentItem = FM_CommitmentItem.load((RichDocumentContext)this.getMidContext(), (Long)CommitmentItemID);
        return commitmentItem.getCodeName();
    }

    private void getErrMsg(Long FinancialManagementAreaID, String valType, int FiscalYear, int period) throws Throwable {
        EFM_PostLedgerPeriod efmOpenTimeInter = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(FinancialManagementAreaID).ValueType(valType).FiscalYear(FiscalYear).SubjectSetting("00").load();
        if (efmOpenTimeInter != null) {
            int periodFrom = efmOpenTimeInter.getFromFiscalPeriod();
            int periodTo = efmOpenTimeInter.getToFiscalPeriod();
            if (period < periodFrom || period > periodTo) {
                MessageFacade.throwException((String)"FMVOUCHERCHECKUTIL001", (Object[])new Object[]{this.getFMAreaName(FinancialManagementAreaID), FiscalYear, period});
            }
        } else {
            efmOpenTimeInter = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(FinancialManagementAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(FiscalYear).SubjectSetting("00").load();
            if (efmOpenTimeInter != null) {
                int periodFrom = efmOpenTimeInter.getFromFiscalPeriod();
                int periodTo = efmOpenTimeInter.getToFiscalPeriod();
                if (period < periodFrom || period > periodTo) {
                    MessageFacade.throwException((String)"FMVOUCHERCHECKUTIL001", (Object[])new Object[]{this.getFMAreaName(FinancialManagementAreaID), FiscalYear, period});
                }
            } else {
                MessageFacade.throwException((String)"FMVOUCHERCHECKUTIL001", (Object[])new Object[]{this.getFMAreaName(FinancialManagementAreaID), FiscalYear, period});
            }
        }
    }

    public void saveIntegrationRelation(FI_Voucher voucher, FM_FundVoucher fm_fundVoucher) throws Throwable {
        IntegrationRelation ir = (IntegrationRelation)this.newBillEntity(IntegrationRelation.class);
        EFI_IntegrationRelation efi_ir = ir.newEFI_IntegrationRelation();
        efi_ir.setClientID(voucher.getClientID());
        efi_ir.setSrcFormKey(voucher.getMetaFormKey());
        efi_ir.setSrcSOID(voucher.getOID());
        efi_ir.setSrcDocumentNumber(voucher.getDocumentNumber());
        efi_ir.setTargetFormKey("FM_FundVoucher");
        efi_ir.setTargetSOID(fm_fundVoucher.getOID());
        efi_ir.setTargetDocumentNumber(fm_fundVoucher.getDocumentNumber());
        this.save((AbstractBillEntity)ir);
    }
}

