/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.substiuation;

import com.bokesoft.erp.basis.enhancement.substitution.IBillEnhancementSubstitution;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_AllotParaFile;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EGS_EnhancementPoint;
import com.bokesoft.erp.billentity.EnhancementPoint;
import com.bokesoft.erp.billentity.FM_ControlAddressResult;
import com.bokesoft.erp.billentity.FM_PostAddressResult;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class FM_AddressEnhancementSubstitution
implements IBillEnhancementSubstitution {
    public List<String> getSourceKey() {
        return Arrays.asList("FM_PostAddressResult", "FM_ControlAddressResult");
    }

    public List<EnhancementPoint> getEnhancementPointList(RichDocument richDocument) throws Throwable {
        String formKey = richDocument.getMetaForm().getKey();
        List<EnhancementPoint> enhancePointList = new ArrayList<EnhancementPoint>();
        if (formKey.equals("FM_PostAddressResult")) {
            enhancePointList = FM_AddressEnhancementSubstitution.getPostEnhancementPoints(richDocument, enhancePointList);
        } else if (formKey.equals("FM_ControlAddressResult")) {
            enhancePointList = FM_AddressEnhancementSubstitution.getControlEnhancementPoints(richDocument, enhancePointList);
        }
        return enhancePointList;
    }

    private static List<EnhancementPoint> getPostEnhancementPoints(RichDocument richDocument, List<EnhancementPoint> enhancePointList) throws Throwable {
        Integer fiscalYear = TypeConvertor.toInteger((Object)richDocument.getValue("HeadFiscalYear", Long.valueOf(richDocument.getOID())));
        Long fmAreaID = TypeConvertor.toLong((Object)richDocument.getValue("HeadFinancialManagementAreaID", Long.valueOf(richDocument.getOID())));
        EFM_BSDistribution bsDistribution = EFM_BSDistribution.loader((RichDocumentContext)richDocument.getContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear.intValue()).load();
        if (bsDistribution != null) {
            Long enhancementPointID = bsDistribution.getBudgetAddressStrategyID();
            if (enhancementPointID == 0L) {
                return enhancePointList;
            }
            EnhancementPoint enhancePoint = EnhancementPoint.load((RichDocumentContext)richDocument.getContext(), (Long)enhancementPointID);
            if (enhancePoint != null) {
                EGS_EnhancementPoint enhancementPoint = EGS_EnhancementPoint.loader((RichDocumentContext)richDocument.getContext()).SOID(enhancementPointID).Enable(1).load();
                if (enhancementPoint == null) {
                    return null;
                }
                enhancePointList.add(enhancePoint);
            }
        }
        return enhancePointList;
    }

    private static List<EnhancementPoint> getControlEnhancementPoints(RichDocument richDocument, List<EnhancementPoint> enhancePointList) throws Throwable {
        Integer fiscalYear = TypeConvertor.toInteger((Object)richDocument.getValue("HeadFiscalYear", Long.valueOf(richDocument.getOID())));
        Long fmAreaID = TypeConvertor.toLong((Object)richDocument.getValue("HeadFinancialManagementAreaID", Long.valueOf(richDocument.getOID())));
        Long controlLedgerID = TypeConvertor.toLong((Object)richDocument.getValue("HeadLedgerID", Long.valueOf(richDocument.getOID())));
        List allotParaFiles = EFM_AllotParaFile.loader((RichDocumentContext)richDocument.getContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear.intValue()).LedgerID(controlLedgerID).orderBy("FromFiscalYear").desc().loadList();
        if (allotParaFiles != null && !CollectionUtils.isEmpty((Collection)allotParaFiles)) {
            Long enhancementPointID = ((EFM_AllotParaFile)allotParaFiles.get(0)).getControlStrategyID();
            if (enhancementPointID == 0L) {
                return enhancePointList;
            }
            EnhancementPoint enhancePoint = EnhancementPoint.load((RichDocumentContext)richDocument.getContext(), (Long)enhancementPointID);
            if (enhancePoint != null) {
                EGS_EnhancementPoint enhancementPoint = EGS_EnhancementPoint.loader((RichDocumentContext)richDocument.getContext()).SOID(enhancementPointID).Enable(1).load();
                if (enhancementPoint == null) {
                    return null;
                }
                enhancePointList.add(enhancePoint);
            }
        }
        return enhancePointList;
    }

    public void afterSubstitution(Object result, RichDocument richDocument, EnhancementPoint enhancePoint, String tableKey) throws Throwable {
        String formKey = richDocument.getMetaForm().getKey();
        List addressIndexs = null;
        if (formKey.equals("FM_PostAddressResult")) {
            FM_PostAddressResult postAddressResult = FM_PostAddressResult.parseDocument((RichDocument)richDocument);
            addressIndexs = postAddressResult.efm_addressIndexs();
        } else if (formKey.equals("FM_ControlAddressResult")) {
            FM_ControlAddressResult controlAddressResult = FM_ControlAddressResult.parseDocument((RichDocument)richDocument);
            addressIndexs = controlAddressResult.efm_addressIndexs();
        }
        if (CollectionUtils.isEmpty((Collection)addressIndexs)) {
            return;
        }
        for (EFM_AddressIndex addressIndex : addressIndexs) {
            Long tFundID = addressIndex.getToFundID();
            Long tFundCenterID = addressIndex.getToFundCenterID();
            Long tCommitItemID = addressIndex.getToCommitmentItemID();
            Long tFunctionAreaID = addressIndex.getToFunctionalAreaID();
            Long tFundProgramID = addressIndex.getToFundProgramID();
            AddressUtils addressUtils = new AddressUtils(richDocument.getContext());
            String objectNumber = addressUtils.genAddress(tFundID, tFundCenterID, tCommitItemID, tFunctionAreaID, tFundProgramID);
            addressIndex.setToObjectNumber(objectNumber);
        }
    }
}

