/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.settlement;

import com.bokesoft.erp.billentity.EFM_CommitSettlementResult;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl_Loader;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherHead;
import com.bokesoft.erp.billentity.EFM_FMAreaToCompanyCode;
import com.bokesoft.erp.billentity.EMM_IncomingInvoiceHead;
import com.bokesoft.erp.billentity.EMM_PurchaseOrderDtl;
import com.bokesoft.erp.billentity.EMM_PurchaseRequisitionDtl;
import com.bokesoft.erp.billentity.FM_CommitSettlement;
import com.bokesoft.erp.billentity.FM_CommitSettlementResult;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_EarmarkedFundVoucher;
import com.bokesoft.erp.billentity.MM_IncomingInvoice;
import com.bokesoft.erp.billentity.MM_PurchaseOrder;
import com.bokesoft.erp.billentity.MM_PurchaseRequisition;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.enums.AmountTypeEnum;
import com.bokesoft.erp.fm.enums.ReferDocTypeEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CommitSettlement
extends EntityContextAction {
    private boolean isTestRun = true;

    public CommitSettlement(RichDocumentContext _context) {
        super(_context);
    }

    public void commitSettlement() throws Throwable {
        List areaToCompanyCodes;
        Long referDocOID;
        List<FM_CommitVoucher> fm_commitVouchers;
        FM_CommitSettlement fmCommitSettlement = FM_CommitSettlement.parseDocument((RichDocument)this.getDocument());
        Long fmAreaID = fmCommitSettlement.getFinancialManagementAreaID();
        int fiscalYear = fmCommitSettlement.getFiscalYear();
        Long fmPostingDate = fmCommitSettlement.getFMPostingDate();
        int period = fmCommitSettlement.getPeriod();
        int isPurchaseRequisition = fmCommitSettlement.getIsPurchaseRequisition();
        int isPurchaseOrder = fmCommitSettlement.getIsPurchaseOrder();
        int isSpecialFund = fmCommitSettlement.getIsSpecialFund();
        int isPremadeInvoice = fmCommitSettlement.getIsPremadeInvoice();
        int isTest = fmCommitSettlement.getIsTest();
        if (isTest == 0) {
            this.isTestRun = false;
        }
        int isShowDetail = fmCommitSettlement.getIsShowDetail();
        FM_CommitSettlementResult commitSettlementResult = (FM_CommitSettlementResult)this.newBillEntity(FM_CommitSettlementResult.class);
        commitSettlementResult.setHeadFinancialManagementAreaID(fmAreaID);
        commitSettlementResult.setHeadFiscalYear(fiscalYear);
        commitSettlementResult.setHeadPeriod(period);
        commitSettlementResult.setHeadFMPostingDate(fmPostingDate);
        commitSettlementResult.setIsTest(isTest);
        commitSettlementResult.setIsShowDetail(isShowDetail);
        commitSettlementResult.setIsFundActive(fmCommitSettlement.getIsFundActive());
        commitSettlementResult.setIsFunctionAreaActive(fmCommitSettlement.getIsFunctionAreaActive());
        commitSettlementResult.setIsFundProgramActive(fmCommitSettlement.getIsFundProgramActive());
        if (isPurchaseRequisition > 0 && (fm_commitVouchers = this.getCommitVouchers(fmCommitSettlement, ReferDocTypeEnum.PurchaseApplication.getKey())) != null && !fm_commitVouchers.isEmpty()) {
            for (FM_CommitVoucher fmCommitVoucher : fm_commitVouchers) {
                referDocOID = fmCommitVoucher.getReferDocSOID();
                if (!this.isTestRun) {
                    MM_PurchaseRequisition purchaseRequisition = MM_PurchaseRequisition.load((RichDocumentContext)this.getMidContext(), (Long)referDocOID);
                    List requisitionDtls = purchaseRequisition.emm_purchaseRequisitionDtls();
                    for (EMM_PurchaseRequisitionDtl requisitionDtl : requisitionDtls) {
                        if (!requisitionDtl.getFinancialManagementAreaID().equals(fmAreaID)) continue;
                        requisitionDtl.setIsSettlement(1);
                    }
                    this.directSave((AbstractBillEntity)purchaseRequisition);
                }
                this.genResultDtlAndCommitVoucher(fmAreaID, fiscalYear, fmPostingDate, period, AmountTypeEnum.AmountType_0500.getKey(), fmCommitVoucher, commitSettlementResult);
            }
        }
        if (isPurchaseOrder > 0 && (fm_commitVouchers = this.getCommitVouchers(fmCommitSettlement, ReferDocTypeEnum.PurchaseOrder.getKey())) != null && !fm_commitVouchers.isEmpty()) {
            for (FM_CommitVoucher fmCommitVoucher : fm_commitVouchers) {
                referDocOID = fmCommitVoucher.getReferDocSOID();
                if (!this.isTestRun) {
                    MM_PurchaseOrder purchaseOrder = MM_PurchaseOrder.load((RichDocumentContext)this.getMidContext(), (Long)referDocOID);
                    List orderDtls = purchaseOrder.emm_purchaseOrderDtls();
                    for (EMM_PurchaseOrderDtl orderDtl : orderDtls) {
                        if (!orderDtl.getFinancialManagementAreaID().equals(fmAreaID)) continue;
                        orderDtl.setIsDeliveryCompleted(1);
                        orderDtl.setIsFinalInvoice(1);
                    }
                    this.directSave((AbstractBillEntity)purchaseOrder);
                }
                this.genResultDtlAndCommitVoucher(fmAreaID, fiscalYear, fmPostingDate, period, AmountTypeEnum.AmountType_0500.getKey(), fmCommitVoucher, commitSettlementResult);
            }
        }
        if (isSpecialFund > 0 && (fm_commitVouchers = this.getCommitVouchers(fmCommitSettlement, ReferDocTypeEnum.EarmarkedFund.getKey())) != null && !fm_commitVouchers.isEmpty()) {
            for (FM_CommitVoucher fmCommitVoucher : fm_commitVouchers) {
                referDocOID = fmCommitVoucher.getReferDocSOID();
                if (!this.isTestRun) {
                    FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.load((RichDocumentContext)this.getMidContext(), (Long)referDocOID);
                    EFM_EarmarkedFundVoucherHead earmarkedFundVoucherHead = earmarkedFundVoucher.efm_earmarkedFundVoucherHead();
                    List earmarkedFundVoucherDtls = earmarkedFundVoucher.efm_earmarkedFundVoucherDtls();
                    for (EFM_EarmarkedFundVoucherDtl voucherDtl : earmarkedFundVoucherDtls) {
                        if (!earmarkedFundVoucherHead.getFinancialManagementAreaID().equals(fmAreaID)) continue;
                        earmarkedFundVoucherHead.setIsVoucherCompleted(1);
                        voucherDtl.setUnclearMoney(BigDecimal.ZERO);
                        voucherDtl.setIsProjectCompleted(1);
                        voucherDtl.setCompletionDate(fmPostingDate);
                    }
                    this.directSave((AbstractBillEntity)earmarkedFundVoucher);
                }
                this.genResultDtlAndCommitVoucher(fmAreaID, fiscalYear, fmPostingDate, period, AmountTypeEnum.AmountType_0500.getKey(), fmCommitVoucher, commitSettlementResult);
            }
        }
        if (isPremadeInvoice > 0 && (areaToCompanyCodes = EFM_FMAreaToCompanyCode.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).loadList()) != null && !areaToCompanyCodes.isEmpty()) {
            for (EFM_FMAreaToCompanyCode areaToCompanyCode : areaToCompanyCodes) {
                List emm_incomingInvoiceHeads = EMM_IncomingInvoiceHead.loader((RichDocumentContext)this.getMidContext()).CompanyCodeID(areaToCompanyCode.getCompanyCodeID()).FiscalYear(fiscalYear).IsParkInvoice(1).loadList();
                if (emm_incomingInvoiceHeads == null || emm_incomingInvoiceHeads.isEmpty()) continue;
                for (EMM_IncomingInvoiceHead emm_incomingInvoiceHead : emm_incomingInvoiceHeads) {
                    EFM_CommitSettlementResult efm_commitSettlementResult = commitSettlementResult.newEFM_CommitSettlementResult();
                    efm_commitSettlementResult.setReferDocNo(emm_incomingInvoiceHead.getDocumentNumber());
                    efm_commitSettlementResult.setFinancialManagementAreaID(fmAreaID);
                    efm_commitSettlementResult.setCompanyCodeID(areaToCompanyCode.getCompanyCodeID());
                    efm_commitSettlementResult.setFiscalYear(fiscalYear);
                    efm_commitSettlementResult.setReferDocSOID(emm_incomingInvoiceHead.getOID());
                    efm_commitSettlementResult.setPostingDate(fmPostingDate);
                    efm_commitSettlementResult.setFiscalPeriod(period);
                    efm_commitSettlementResult.setValueType(ValueTypeEnum.ValueType_54.getKey());
                    if (this.isTestRun) continue;
                    MM_IncomingInvoice deleteInvoice = MM_IncomingInvoice.load((RichDocumentContext)this.getMidContext(), (Long)emm_incomingInvoiceHead.getOID());
                    deleteInvoice.document.evaluate("Macro_MidDelete()", "\u5220\u9664\u9884\u5236\u53d1\u7968");
                }
            }
        }
        SortCriteria[] vCriteria = new SortCriteria[]{new SortCriteria("ReferDocType", true), new SortCriteria("ReferDocNo", true)};
        commitSettlementResult.getDataTable("EFM_CommitSettlementResult").setSort(vCriteria);
        commitSettlementResult.getDataTable("EFM_CommitSettlementResult").sort();
        new AddressUtils(this.getMidContext()).transOneNewTab("FM_CommitSettlementResult", commitSettlementResult.document.toJSON());
        if (!this.isTestRun && commitSettlementResult.efm_commitSettlementResults().size() > 0) {
            this.save((AbstractBillEntity)commitSettlementResult);
        }
    }

    private void genResultDtlAndCommitVoucher(Long fmAreaID, int fiscalYear, Long fmPostingDate, int period, String amountType, FM_CommitVoucher fmCommitVoucher, FM_CommitSettlementResult commitSettlementResult) throws Throwable {
        List commitVouchers = fmCommitVoucher.efm_commitVoucherDtls();
        Map<Long, List<EFM_CommitVoucherDtl>> ledgerGroup = commitVouchers.stream().collect(Collectors.groupingBy(efm_commitVoucher -> {
            try {
                return efm_commitVoucher.getLedgerID();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }));
        for (Map.Entry<Long, List<EFM_CommitVoucherDtl>> listEntry : ledgerGroup.entrySet()) {
            List<EFM_CommitVoucherDtl> ledgerVouchers = listEntry.getValue();
            EFM_CommitVoucherDtl latestVoucher = null;
            EFM_CommitSettlementResult efm_commitSettlementResult = commitSettlementResult.newEFM_CommitSettlementResult();
            BigDecimal settleMoney = BigDecimal.ZERO;
            for (EFM_CommitVoucherDtl commitVoucher : ledgerVouchers) {
                settleMoney = settleMoney.add(commitVoucher.getFMAreaCurrencyMoney());
                commitVoucher.setFinishFlag("X");
                if (commitVoucher.getIsLatest() != 1) continue;
                latestVoucher = commitVoucher;
                efm_commitSettlementResult.setLedgerID(commitVoucher.getLedgerID());
                efm_commitSettlementResult.setReferCommitVoucherSOID(commitVoucher.getOID());
                efm_commitSettlementResult.setReferDocNo(commitVoucher.getReferDocNo());
                efm_commitSettlementResult.setFinancialManagementAreaID(fmAreaID);
                efm_commitSettlementResult.setCompanyCodeID(commitVoucher.getCompanyCodeID());
                efm_commitSettlementResult.setFiscalYear(fiscalYear);
                efm_commitSettlementResult.setReferDocType(commitVoucher.getReferDocType());
                efm_commitSettlementResult.setReferDocSOID(commitVoucher.getReferDocSOID());
                efm_commitSettlementResult.setReferDocItemOID(commitVoucher.getReferItemOID());
                efm_commitSettlementResult.setReferDocAccountItemOID(commitVoucher.getReferAccountAssignItemOID());
                efm_commitSettlementResult.setPostingDate(fmPostingDate);
                efm_commitSettlementResult.setFiscalPeriod(period);
                efm_commitSettlementResult.setCommitmentItemID(commitVoucher.getCommitmentItemID());
                efm_commitSettlementResult.setFundCenterID(commitVoucher.getFundCenterID());
                efm_commitSettlementResult.setFundID(commitVoucher.getFundID());
                efm_commitSettlementResult.setFunctionalAreaID(commitVoucher.getFunctionalAreaID());
                efm_commitSettlementResult.setStatisticalIdentifier(commitVoucher.getStatisticalIdentifier());
                efm_commitSettlementResult.setValueType(commitVoucher.getValueType());
                efm_commitSettlementResult.setCurrencyID(commitVoucher.getCurrencyID());
            }
            efm_commitSettlementResult.setFMAreaCurrencyMoney(settleMoney);
            efm_commitSettlementResult.setTransactionCurrencyMoney(settleMoney);
            if (this.isTestRun || settleMoney.compareTo(BigDecimal.ZERO) == 0) continue;
            this.genCommitVoucherFromVoucher(fmCommitVoucher, amountType, latestVoucher, fmPostingDate, period, settleMoney.negate());
        }
        SortCriteria[] vCriteria = new SortCriteria[]{new SortCriteria("ReferDocNo", true), new SortCriteria("FundCode", true), new SortCriteria("FundCenterCode", true), new SortCriteria("CommitmentItemCode", true), new SortCriteria("FunctionalAreaCode", true), new SortCriteria("FundProgramCode", true)};
        commitSettlementResult.getDataTable("EFM_CommitSettlementResult").setSort(vCriteria);
        commitSettlementResult.getDataTable("EFM_CommitSettlementResult").sort();
        if (!this.isTestRun) {
            this.save((AbstractBillEntity)fmCommitVoucher);
        }
    }

    private List<FM_CommitVoucher> getCommitVouchers(FM_CommitSettlement fmCommitSettlement, String referDocType) throws Throwable {
        Long fmAreaID = fmCommitSettlement.getFinancialManagementAreaID();
        int fiscalYear = fmCommitSettlement.getFiscalYear();
        EFM_CommitVoucherDtl_Loader commitVoucherLoader = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).ReferDocType(referDocType).IsLatest(1).FinishFlag("!=", "X");
        if (referDocType.equals(ReferDocTypeEnum.PurchaseApplication.getKey())) {
            if (!fmCommitSettlement.getPurReqNumberFrom().equals("") && !fmCommitSettlement.getPurReqNumberTo().equals("")) {
                commitVoucherLoader.ReferDocNo(">=", fmCommitSettlement.getPurReqNumberFrom());
            } else if (!fmCommitSettlement.getPurReqNumberFrom().equals("")) {
                commitVoucherLoader.ReferDocNo(fmCommitSettlement.getPurReqNumberFrom());
            }
            if (!fmCommitSettlement.getPurReqNumberTo().equals("")) {
                commitVoucherLoader.ReferDocNo("<=", fmCommitSettlement.getPurReqNumberFrom());
            }
        }
        if (referDocType.equals(ReferDocTypeEnum.PurchaseOrder.getKey())) {
            if (!fmCommitSettlement.getPurOrderNumberFrom().equals("") && !fmCommitSettlement.getPurOrderNumberTo().equals("")) {
                commitVoucherLoader.ReferDocNo(">=", fmCommitSettlement.getPurOrderNumberFrom());
            } else if (!fmCommitSettlement.getPurOrderNumberFrom().equals("")) {
                commitVoucherLoader.ReferDocNo(fmCommitSettlement.getPurOrderNumberFrom());
            }
            if (!fmCommitSettlement.getPurOrderNumberTo().equals("")) {
                commitVoucherLoader.ReferDocNo("<=", fmCommitSettlement.getPurOrderNumberTo());
            }
        }
        if (referDocType.equals(ReferDocTypeEnum.EarmarkedFund.getKey())) {
            if (!fmCommitSettlement.getEarFundNumberFrom().equals("") && !fmCommitSettlement.getEarFundNumberTo().equals("")) {
                commitVoucherLoader.ReferDocNo(">=", fmCommitSettlement.getEarFundNumberFrom());
            } else if (!fmCommitSettlement.getEarFundNumberFrom().equals("")) {
                commitVoucherLoader.ReferDocNo(fmCommitSettlement.getEarFundNumberFrom());
            }
            if (!fmCommitSettlement.getEarFundNumberTo().equals("")) {
                commitVoucherLoader.ReferDocNo("<=", fmCommitSettlement.getEarFundNumberTo());
            }
        }
        if (fmCommitSettlement.getFromFundID().compareTo(0L) > 0 && fmCommitSettlement.getToFundID().compareTo(0L) > 0) {
            commitVoucherLoader.FundCode(">=", fmCommitSettlement.getFromFundCode());
        } else if (fmCommitSettlement.getFromFundID().compareTo(0L) > 0) {
            commitVoucherLoader.FundCode(fmCommitSettlement.getFromFundCode());
        }
        if (fmCommitSettlement.getToFundID().compareTo(0L) > 0) {
            commitVoucherLoader.FundCode("<=", fmCommitSettlement.getToFundCode());
        }
        if (fmCommitSettlement.getFromFundCenterID().compareTo(0L) > 0 && fmCommitSettlement.getToFundCenterID().compareTo(0L) > 0) {
            commitVoucherLoader.FundCenterCode(">=", fmCommitSettlement.getFromFundCenterCode());
        } else if (fmCommitSettlement.getFromFundCenterID().compareTo(0L) > 0) {
            commitVoucherLoader.FundCenterCode(fmCommitSettlement.getFromFundCenterCode());
        }
        if (fmCommitSettlement.getToFundCenterID().compareTo(0L) > 0) {
            commitVoucherLoader.FundCenterCode("<=", fmCommitSettlement.getToFundCenterCode());
        }
        if (fmCommitSettlement.getFromCommitmentItemID().compareTo(0L) > 0 && fmCommitSettlement.getToCommitmentItemID().compareTo(0L) > 0) {
            commitVoucherLoader.CommitmentItemCode(">=", fmCommitSettlement.getFromCommitItemCode());
        } else if (fmCommitSettlement.getFromCommitmentItemID().compareTo(0L) > 0) {
            commitVoucherLoader.CommitmentItemCode(fmCommitSettlement.getFromCommitItemCode());
        }
        if (fmCommitSettlement.getToCommitmentItemID().compareTo(0L) > 0) {
            commitVoucherLoader.CommitmentItemCode("<=", fmCommitSettlement.getToCommitItemCode());
        }
        if (fmCommitSettlement.getFromFunctionalAreaID().compareTo(0L) > 0 && fmCommitSettlement.getToFunctionalAreaID().compareTo(0L) > 0) {
            commitVoucherLoader.FunctionalAreaCode(">=", fmCommitSettlement.getFromFunctionAreaCode());
        } else if (fmCommitSettlement.getFromFunctionalAreaID().compareTo(0L) > 0) {
            commitVoucherLoader.FunctionalAreaCode(fmCommitSettlement.getFromFunctionAreaCode());
        }
        if (fmCommitSettlement.getToFunctionalAreaID().compareTo(0L) > 0) {
            commitVoucherLoader.FunctionalAreaCode("<=", fmCommitSettlement.getToFunctionAreaCode());
        }
        List efm_commitVoucherDtls = commitVoucherLoader.loadList();
        ArrayList<FM_CommitVoucher> resultVouchers = new ArrayList<FM_CommitVoucher>();
        ArrayList<Long> resultIDs = new ArrayList<Long>();
        if (efm_commitVoucherDtls != null && !efm_commitVoucherDtls.isEmpty()) {
            for (EFM_CommitVoucherDtl commitVoucher : efm_commitVoucherDtls) {
                if (resultIDs.contains(commitVoucher.getSOID())) continue;
                FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.load((RichDocumentContext)this.getMidContext(), (Long)commitVoucher.getSOID());
                resultVouchers.add(fmCommitVoucher);
                resultIDs.add(commitVoucher.getSOID());
            }
        }
        return resultVouchers;
    }

    private void genCommitVoucherFromVoucher(FM_CommitVoucher fm_commitVoucher, String amountType, EFM_CommitVoucherDtl fromCommitVoucher, Long fmPostingDate, int period, BigDecimal amount) throws Throwable {
        EFM_CommitVoucherDtl commitVoucher = fm_commitVoucher.newEFM_CommitVoucherDtl();
        commitVoucher.setReferDocType(fromCommitVoucher.getReferDocType());
        commitVoucher.setReferDocSOID(fromCommitVoucher.getReferDocSOID());
        commitVoucher.setReferDocNo(fromCommitVoucher.getReferDocNo());
        commitVoucher.setReferItemOID(fromCommitVoucher.getReferItemOID());
        commitVoucher.setReferAccountAssignItemOID(fromCommitVoucher.getReferAccountAssignItemOID());
        commitVoucher.setReferTrade(fromCommitVoucher.getReferTrade());
        commitVoucher.setMoneyType(amountType);
        commitVoucher.setSrcSOID(fromCommitVoucher.getSrcSOID());
        commitVoucher.setSrcOID(fromCommitVoucher.getSrcOID());
        commitVoucher.setSrcFormKey(fromCommitVoucher.getSrcFormKey());
        commitVoucher.setPostingDate(fmPostingDate);
        commitVoucher.setFiscalYear(fromCommitVoucher.getFiscalYear());
        commitVoucher.setFiscalPeriod(period);
        commitVoucher.setVersionID(fromCommitVoucher.getVersionID());
        commitVoucher.setLedgerID(fromCommitVoucher.getLedgerID());
        commitVoucher.setCommitVoucherCarryoverStatus(fromCommitVoucher.getCommitVoucherCarryoverStatus());
        commitVoucher.setTransactionCurrencyMoney(amount);
        commitVoucher.setFMAreaCurrencyMoney(amount);
        commitVoucher.setCommitmentItemID(fromCommitVoucher.getCommitmentItemID());
        commitVoucher.setFundCenterID(fromCommitVoucher.getFundCenterID());
        commitVoucher.setFundID(fromCommitVoucher.getFundID());
        commitVoucher.setFunctionalAreaID(fromCommitVoucher.getFunctionalAreaID());
        commitVoucher.setPostAddress(fromCommitVoucher.getPostAddress());
        commitVoucher.setValueType(fromCommitVoucher.getValueType());
        commitVoucher.setBusinessTransactionID(fromCommitVoucher.getBusinessTransactionID());
        commitVoucher.setCompanyCodeID(fromCommitVoucher.getCompanyCodeID());
        commitVoucher.setCurrencyID(fromCommitVoucher.getCurrencyID());
        commitVoucher.setMaterialID(fromCommitVoucher.getMaterialID());
        commitVoucher.setShortText(fromCommitVoucher.getShortText());
        commitVoucher.setGLAccountID(fromCommitVoucher.getGLAccountID());
        commitVoucher.setFinancialManagementAreaID(fromCommitVoucher.getFinancialManagementAreaID());
        commitVoucher.setVendorID(fromCommitVoucher.getVendorID());
        commitVoucher.setQuantity(fromCommitVoucher.getQuantity());
        commitVoucher.setStatisticalIdentifier(fromCommitVoucher.getStatisticalIdentifier());
        commitVoucher.setFinishFlag("X");
    }
}

