/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.settlement;

import com.bokesoft.erp.billentity.EFM_BCSLedgerList;
import com.bokesoft.erp.billentity.EFM_BudgetBalance;
import com.bokesoft.erp.billentity.EFM_BudgetCarryoverResult;
import com.bokesoft.erp.billentity.EFM_BudgetUsed;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherDtl;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherHead;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherPeriod;
import com.bokesoft.erp.billentity.EFM_SettlementConfig;
import com.bokesoft.erp.billentity.EFM_StatisticalIndexBudgetDtl;
import com.bokesoft.erp.billentity.EFM_StatisticalIndexPostDtl;
import com.bokesoft.erp.billentity.FM_BudgetCarryover;
import com.bokesoft.erp.billentity.FM_BudgetCarryoverResult;
import com.bokesoft.erp.billentity.FM_BudgetVoucher;
import com.bokesoft.erp.billentity.FM_StatisticalIndex;
import com.bokesoft.erp.documentNumber.DocumentNumberUtil;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.enums.BudgetProcessEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BudgetCarryover
extends EntityContextAction {
    public BudgetCarryover(RichDocumentContext _context) {
        super(_context);
    }

    public void budgetCarryover() throws Throwable {
        FM_BudgetCarryover fm_budgetCarryover = FM_BudgetCarryover.parseDocument((RichDocument)this.getDocument());
        EFM_SettlementConfig settlementConfig = EFM_SettlementConfig.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fm_budgetCarryover.getFinancialManagementAreaID()).load();
        if (settlementConfig == null || settlementConfig.getIsBudgetCarryAllow() == 0) {
            MessageFacade.throwException((String)"BUDGETCARRYOVER001");
        }
        FM_BudgetCarryoverResult fmBudgetCarryoverResult = (FM_BudgetCarryoverResult)this.newBillEntity(FM_BudgetCarryoverResult.class);
        fmBudgetCarryoverResult.setHeadFinancialManagementAreaID(fm_budgetCarryover.getFinancialManagementAreaID());
        fmBudgetCarryoverResult.setHeadFiscalYear(fm_budgetCarryover.getFiscalYear());
        fmBudgetCarryoverResult.setHeadSendFiscalYear(fm_budgetCarryover.getFiscalYear());
        fmBudgetCarryoverResult.setHeadLedgerID(fm_budgetCarryover.getFromBudgetLedgerID());
        fmBudgetCarryoverResult.setHeadToFiscalYear(fm_budgetCarryover.getFiscalYear() + 1);
        fmBudgetCarryoverResult.setHeadSendPeriod(fm_budgetCarryover.getSendPeriod());
        fmBudgetCarryoverResult.setHeadToPeriod(fm_budgetCarryover.getToPeriod());
        fmBudgetCarryoverResult.setHeadVersionID(fm_budgetCarryover.getVersionID());
        fmBudgetCarryoverResult.setIsTest(fm_budgetCarryover.getIsTest());
        fmBudgetCarryoverResult.setIsFundActive(fm_budgetCarryover.getIsFundActive());
        fmBudgetCarryoverResult.setIsFunctionAreaActive(fm_budgetCarryover.getIsFunctionAreaActive());
        fmBudgetCarryoverResult.setIsFundProgramActive(fm_budgetCarryover.getIsFundProgramActive());
        SqlString sqlString = this.getBudgetSqlString(fm_budgetCarryover);
        Long statisticalIndex = TypeConvertor.toLong((Object)fm_budgetCarryover.getStatisticalIndexID());
        FM_StatisticalIndex fmStatisticalIndex = FM_StatisticalIndex.load((RichDocumentContext)this.getMidContext(), (Long)statisticalIndex);
        List budgetIndexDtls = fmStatisticalIndex.efm_statisticalIndexBudgetDtls();
        List postDtls = fmStatisticalIndex.efm_statisticalIndexPostDtls();
        DataTable resultSet = this.getResultSet(sqlString);
        List efm_budgetBalances = EFM_BudgetBalance.parseRowset((RichDocumentContext)this.getMidContext(), (DataTable)resultSet);
        Map resultMap = efm_budgetBalances.stream().collect(Collectors.groupingBy(b -> {
            try {
                return b.getFinancialManagementAreaID() + "|" + b.getFiscalYear() + "|" + b.getLedgerID() + "|" + b.getVersionID() + b.getBudgetAddress();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry listEntry : resultMap.entrySet()) {
            BigDecimal carryoverAmount;
            List budgetBalances = (List)listEntry.getValue();
            EFM_BudgetBalance flagEntity = (EFM_BudgetBalance)budgetBalances.get(0);
            BigDecimal b1Amount = BigDecimal.ZERO;
            for (EFM_BudgetBalance budgetBalance : budgetBalances) {
                if (budgetIndexDtls == null || budgetIndexDtls.isEmpty()) continue;
                for (EFM_StatisticalIndexBudgetDtl budgetDtl : budgetIndexDtls) {
                    BigDecimal direction = new BigDecimal(budgetDtl.getDirection());
                    String bcsValType = budgetDtl.getBCSValType();
                    String budgetProcess = budgetDtl.getBudgetProcess();
                    Long budgetTypeID = budgetDtl.getBudgetTypeID();
                    String workFlowStatus = budgetDtl.getWorkFlowStatus();
                    if (!budgetBalance.getBCSValType().equals(bcsValType) || !budgetProcess.isEmpty() && !budgetProcess.equals(BudgetProcessEnum.All.getKey()) && !budgetProcess.equals(budgetBalance.getBudgetProcess()) || budgetTypeID.compareTo(0L) != 0 && !budgetTypeID.equals(budgetBalance.getBudgetTypeID()) || !workFlowStatus.isEmpty() && !workFlowStatus.equals(budgetBalance.getWorkFlowStatus())) continue;
                    BigDecimal balance = budgetBalance.getTSLMoney1().add(budgetBalance.getTSLMoney2()).add(budgetBalance.getTSLMoney3()).add(budgetBalance.getTSLMoney4()).add(budgetBalance.getTSLMoney5()).add(budgetBalance.getTSLMoney6()).add(budgetBalance.getTSLMoney7()).add(budgetBalance.getTSLMoney8()).add(budgetBalance.getTSLMoney9()).add(budgetBalance.getTSLMoney10()).add(budgetBalance.getTSLMoney11()).add(budgetBalance.getTSLMoney12());
                    b1Amount = b1Amount.add(balance.multiply(direction));
                }
            }
            if (b1Amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetExpend = BigDecimal.ZERO;
            if (postDtls != null && !postDtls.isEmpty()) {
                EFM_StatisticalIndexBudgetDtl budgetDtl;
                budgetDtl = postDtls.iterator();
                while (budgetDtl.hasNext()) {
                    DataTable postResult;
                    EFM_StatisticalIndexPostDtl postDtl = (EFM_StatisticalIndexPostDtl)budgetDtl.next();
                    BigDecimal direction = new BigDecimal(postDtl.getDirection());
                    String amountType = postDtl.getMoneyType();
                    Long ledgerID = postDtl.getLedgerID();
                    String valueType = postDtl.getValueType();
                    String statisticalIdentifier = postDtl.getStatisticalIdentifier();
                    SqlString postSql = new SqlString().append(new Object[]{"select * from "}).append(new Object[]{"EFM_BudgetUsed"}).append(new Object[]{" where "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)flagEntity.getFinancialManagementAreaID()).append(new Object[]{" and "}).append(new Object[]{"VersionID"}).append(new Object[]{" = "}).appendPara((Object)flagEntity.getVersionID()).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)flagEntity.getFiscalYear());
                    List bcsLedgerLists = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).BudgetLedgerID(flagEntity.getLedgerID()).loadList();
                    if (bcsLedgerLists == null || bcsLedgerLists.isEmpty()) {
                        MessageFacade.throwException((String)"BUDGETCARRYOVER002");
                    }
                    String postLedgerCodes = "";
                    for (EFM_BCSLedgerList bcsLedgerList : bcsLedgerLists) {
                        if (ledgerID.compareTo(0L) > 0 && !bcsLedgerList.getPostLedgerID().equals(ledgerID)) {
                            MessageFacade.throwException((String)"BUDGETCARRYOVER003", (Object[])new Object[]{bcsLedgerList.getPostLedgerCode()});
                        }
                        postLedgerCodes = postLedgerCodes.equals("") ? bcsLedgerList.getPostLedgerCode() : String.valueOf(postLedgerCodes) + "," + bcsLedgerList.getPostLedgerCode();
                    }
                    postSql.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" in( "}).appendPara((Object)postLedgerCodes).append(new Object[]{" ) "});
                    if (!amountType.isEmpty()) {
                        postSql.append(new Object[]{" and "}).append(new Object[]{"MoneyType"}).append(new Object[]{" = "}).appendPara((Object)amountType);
                    }
                    if (!valueType.isEmpty()) {
                        postSql.append(new Object[]{" and "}).append(new Object[]{"ValueType"}).append(new Object[]{" = "}).appendPara((Object)valueType);
                    }
                    if (!statisticalIdentifier.isEmpty()) {
                        postSql.append(new Object[]{" and "}).append(new Object[]{"StatisticalIdentifier"}).append(new Object[]{" = "}).appendPara((Object)statisticalIdentifier);
                    }
                    if ((postResult = this.getResultSet(postSql)).isEmpty()) continue;
                    List efm_budgetUseds = EFM_BudgetUsed.parseRowset((RichDocumentContext)this.getMidContext(), (DataTable)postResult);
                    BigDecimal usedBalance = BigDecimal.ZERO;
                    for (EFM_BudgetUsed budgetUsed : efm_budgetUseds) {
                        BigDecimal sumAmount = budgetUsed.getTSLMoney1().add(budgetUsed.getTSLMoney2()).add(budgetUsed.getTSLMoney3()).add(budgetUsed.getTSLMoney4()).add(budgetUsed.getTSLMoney5()).add(budgetUsed.getTSLMoney6()).add(budgetUsed.getTSLMoney7()).add(budgetUsed.getTSLMoney8()).add(budgetUsed.getTSLMoney9()).add(budgetUsed.getTSLMoney10()).add(budgetUsed.getTSLMoney11()).add(budgetUsed.getTSLMoney12());
                        usedBalance = usedBalance.add(sumAmount);
                    }
                    budgetExpend = budgetExpend.add(usedBalance.multiply(direction));
                }
            }
            if ((carryoverAmount = b1Amount.add(budgetExpend)).compareTo(BigDecimal.ZERO) == 0) continue;
            FM_BudgetVoucher fm_budgetVoucher = this.genBudgetVoucher(fm_budgetCarryover, flagEntity, carryoverAmount.abs());
            DataTable dataTable = fm_budgetVoucher.document.getDataTable("EFM_BudgetVoucherDtl");
            List efm_budgetVoucherDtls = EFM_BudgetVoucherDtl.parseRowset((RichDocumentContext)this.getMidContext(), (DataTable)dataTable);
            for (EFM_BudgetVoucherDtl voucherDetail : efm_budgetVoucherDtls) {
                EFM_BudgetCarryoverResult efm_budgetCarryoverResult = fmBudgetCarryoverResult.newEFM_BudgetCarryoverResult();
                efm_budgetCarryoverResult.setBudgetVoucherSOID(voucherDetail.getSOID());
                efm_budgetCarryoverResult.setBudgetVoucherDetailOID(voucherDetail.getOID());
                efm_budgetCarryoverResult.setFinancialManagementAreaID(fm_budgetCarryover.getFinancialManagementAreaID());
                if (fm_budgetVoucher.getDocumentNumber().isEmpty()) {
                    DocumentNumberUtil.genDocNumber((RichDocumentContext)fm_budgetVoucher.document.getContext());
                }
                efm_budgetCarryoverResult.setBudgetVoucherNumber(fm_budgetVoucher.getDocumentNumber());
                efm_budgetCarryoverResult.setCommitmentItemID(voucherDetail.getCommitmentItemID());
                efm_budgetCarryoverResult.setFundCenterID(voucherDetail.getFundCenterID());
                efm_budgetCarryoverResult.setFundID(voucherDetail.getFundID());
                efm_budgetCarryoverResult.setFunctionalAreaID(voucherDetail.getFunctionalAreaID());
                efm_budgetCarryoverResult.setFundProgramID(voucherDetail.getFundProgramID());
                efm_budgetCarryoverResult.setBudgetProcess(voucherDetail.getBudgetProcess());
                efm_budgetCarryoverResult.setBudgetTypeID(voucherDetail.getBudgetTypeID());
                efm_budgetCarryoverResult.setLedgerID(fm_budgetVoucher.getBudgetLedgerID());
                efm_budgetCarryoverResult.setMoney(voucherDetail.getMoney());
                efm_budgetCarryoverResult.setAdditionalLine(voucherDetail.getAdditionalLine());
            }
        }
        SortCriteria[] vCriteria = new SortCriteria[]{new SortCriteria("FundCode", true), new SortCriteria("FundCenterCode", true), new SortCriteria("CommitmentItemCode", true), new SortCriteria("FunctionalAreaCode", true), new SortCriteria("FundProgramCode", true)};
        fmBudgetCarryoverResult.getDataTable("EFM_BudgetCarryoverResult").setSort(vCriteria);
        fmBudgetCarryoverResult.getDataTable("EFM_BudgetCarryoverResult").sort();
        new AddressUtils(this.getMidContext()).transOneNewTab("FM_BudgetCarryoverResult", fmBudgetCarryoverResult.document.toJSON());
        if (fm_budgetCarryover.getIsTest() == 0 && !fmBudgetCarryoverResult.efm_budgetCarryoverResults().isEmpty()) {
            this.save((AbstractBillEntity)fmBudgetCarryoverResult);
        }
    }

    private FM_BudgetVoucher genBudgetVoucher(FM_BudgetCarryover fm_budgetCarryover, EFM_BudgetBalance budgetBalance, BigDecimal carryoverAmount) throws Throwable {
        String toPeriodType_1 = fm_budgetCarryover.getToPeriodType_Period();
        FM_BudgetVoucher fm_budgetVoucher = (FM_BudgetVoucher)this.newBillEntity(FM_BudgetVoucher.class);
        EFM_BudgetVoucherHead efm_budgetVoucherHead = fm_budgetVoucher.efm_budgetVoucherHead();
        efm_budgetVoucherHead.setBudgetLedgerID(fm_budgetCarryover.getFromBudgetLedgerID());
        efm_budgetVoucherHead.setDocumentTypeID(fm_budgetCarryover.getDocumentTypeID());
        efm_budgetVoucherHead.setDocumentDate(fm_budgetCarryover.getDcoumentDate());
        efm_budgetVoucherHead.setBudgetTypeID(fm_budgetCarryover.getSendBudgetTypeID());
        efm_budgetVoucherHead.setFinancialManagementAreaID(fm_budgetCarryover.getFinancialManagementAreaID());
        efm_budgetVoucherHead.setFiscalYear(fm_budgetCarryover.getFiscalYear() + 1);
        efm_budgetVoucherHead.setSendFiscalYear(fm_budgetCarryover.getFiscalYear());
        efm_budgetVoucherHead.setStatus(1);
        efm_budgetVoucherHead.setBCSValType("B1");
        efm_budgetVoucherHead.setBudgetProcess(BudgetProcessEnum.CORV.getKey());
        efm_budgetVoucherHead.setVersionID(fm_budgetCarryover.getVersionID());
        if (toPeriodType_1.equals("2")) {
            efm_budgetVoucherHead.setFiscalPeriod(0);
        } else {
            efm_budgetVoucherHead.setFiscalPeriod(fm_budgetCarryover.getToPeriod());
        }
        EFM_BudgetVoucherDtl sendDetail = fm_budgetVoucher.newEFM_BudgetVoucherDtl();
        sendDetail.setBudgetTypeID(fm_budgetCarryover.getSendBudgetTypeID());
        sendDetail.setCommitmentItemID(budgetBalance.getCommitmentItemID());
        sendDetail.setFundCenterID(budgetBalance.getFundCenterID());
        sendDetail.setFundID(budgetBalance.getFundID());
        sendDetail.setFunctionalAreaID(budgetBalance.getFunctionalAreaID());
        sendDetail.setFundProgramID(budgetBalance.getFundProgramID());
        sendDetail.setFiscalYear(fm_budgetCarryover.getFiscalYear());
        sendDetail.setBCSValType("B1");
        sendDetail.setBudgetProcess(BudgetProcessEnum.COSD.getKey());
        sendDetail.setDistributionCode(Integer.parseInt("0"));
        sendDetail.setFiscalPeriod(fm_budgetCarryover.getSendPeriod());
        sendDetail.setIsCarryVoucher(1);
        EFM_BudgetVoucherPeriod sendPeriodDtl = fm_budgetVoucher.newEFM_BudgetVoucherPeriod();
        sendPeriodDtl.setPOID(sendDetail.getOID());
        sendPeriodDtl.setFiscalPeriod(fm_budgetCarryover.getSendPeriod());
        sendPeriodDtl.setBudgetMoney(carryoverAmount);
        sendPeriodDtl.setLVALMoney(carryoverAmount);
        EFM_BudgetVoucherDtl acceptDetail = fm_budgetVoucher.newEFM_BudgetVoucherDtl();
        acceptDetail.setBudgetTypeID(fm_budgetCarryover.getAcceptBudgetTypeID());
        acceptDetail.setCommitmentItemID(budgetBalance.getCommitmentItemID());
        acceptDetail.setFundCenterID(budgetBalance.getFundCenterID());
        acceptDetail.setFundID(budgetBalance.getFundID());
        acceptDetail.setFunctionalAreaID(budgetBalance.getFunctionalAreaID());
        acceptDetail.setFundProgramID(budgetBalance.getFundProgramID());
        acceptDetail.setFiscalYear(fm_budgetCarryover.getFiscalYear() + 1);
        acceptDetail.setMoney(carryoverAmount);
        acceptDetail.setBCSValType("B1");
        acceptDetail.setBudgetProcess(BudgetProcessEnum.CORV.getKey());
        acceptDetail.setIsCarryVoucher(1);
        if (toPeriodType_1.equals("2")) {
            acceptDetail.setDistributionCode(Integer.parseInt(fm_budgetCarryover.getDistributionCode()));
        } else {
            acceptDetail.setDistributionCode(Integer.parseInt("0"));
            acceptDetail.setFiscalPeriod(fm_budgetCarryover.getToPeriod());
        }
        if (fm_budgetCarryover.getIsTest() == 0) {
            fm_budgetVoucher.document.getContext().setPara("IsTest", (Object)0);
            this.save((AbstractBillEntity)fm_budgetVoucher);
        } else {
            fm_budgetVoucher.document.getContext().setPara("IsTest", (Object)1);
            fm_budgetVoucher.document.evaluate("Macro_MidSave_PreTriggers()", "\u9884\u7b97\u51ed\u8bc1\u68c0\u67e5");
        }
        return fm_budgetVoucher;
    }

    private SqlString getBudgetSqlString(FM_BudgetCarryover fm_budgetCarryover) throws Throwable {
        int fiscalYear = fm_budgetCarryover.getFiscalYear();
        Long fmAreaID = fm_budgetCarryover.getFinancialManagementAreaID();
        Long fromBudgetLedgerID = fm_budgetCarryover.getFromBudgetLedgerID();
        String fromBudgetLedgerCode = fm_budgetCarryover.getFromBudgetLedgerCode();
        String toBudgetLedgerCode = fm_budgetCarryover.getToBudgetLedgerCode();
        Long versionID = fm_budgetCarryover.getVersionID();
        String accountType_1 = fm_budgetCarryover.getAccountType_BudgetAddress();
        String fromFundCode = fm_budgetCarryover.getFromFundCode();
        String toFundCode = fm_budgetCarryover.getToFundCode();
        String fromFundCenterCode = fm_budgetCarryover.getFromFundCenterCode();
        String toFundCenterCode = fm_budgetCarryover.getToFundCenterCode();
        String fromCommitItemCode = fm_budgetCarryover.getFromCommitItemCode();
        String toCommitItemCode = fm_budgetCarryover.getToCommitItemCode();
        String fromFunctionAreaCode = fm_budgetCarryover.getFromFunctionAreaCode();
        String toFunctionAreaCode = fm_budgetCarryover.getToFunctionAreaCode();
        String fromFundProgramCode = fm_budgetCarryover.getFromFundProgramCode();
        String toFundProgramCode = fm_budgetCarryover.getToFundProgramCode();
        SqlString sqlString = new SqlString().append(new Object[]{"select * from "}).append(new Object[]{"EFM_BudgetBalance"}).append(new Object[]{" where "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"VersionID"}).append(new Object[]{" = "}).appendPara((Object)versionID).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear);
        if (accountType_1.equals("2")) {
            if (!toBudgetLedgerCode.isEmpty()) {
                MessageFacade.throwException((String)"BUDGETCARRYOVER004");
            }
            Long controlLedgerID = fm_budgetCarryover.getControlLedgerID();
            EFM_BCSLedgerList bcsLedgerList = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).ControlLedgerID(controlLedgerID).load();
            if (!bcsLedgerList.getBudgetLedgerID().equals(fromBudgetLedgerID)) {
                MessageFacade.throwException((String)"BUDGETCARRYOVER005");
            }
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" = "}).appendPara((Object)fromBudgetLedgerCode);
        }
        if (!toBudgetLedgerCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" >= "}).appendPara((Object)fromBudgetLedgerCode);
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" <= "}).appendPara((Object)toBudgetLedgerCode);
        } else {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" = "}).appendPara((Object)fromBudgetLedgerCode);
        }
        if (!fromFundCode.isEmpty() && !toFundCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" >= "}).appendPara((Object)fromFundCode);
        } else if (!fromFundCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" = "}).appendPara((Object)fromFundCode);
        }
        if (!toFundCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" <= "}).appendPara((Object)toFundCode);
        }
        if (!fromFundCenterCode.isEmpty() && !toFundCenterCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" >= "}).appendPara((Object)fromFundCenterCode);
        } else if (!fromFundCenterCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" = "}).appendPara((Object)fromFundCenterCode);
        }
        if (!toFundCenterCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" <= "}).appendPara((Object)toFundCenterCode);
        }
        if (!fromCommitItemCode.isEmpty() && !toCommitItemCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" >= "}).appendPara((Object)fromCommitItemCode);
        } else if (!fromCommitItemCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" = "}).appendPara((Object)fromCommitItemCode);
        }
        if (!toCommitItemCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" <= "}).appendPara((Object)toCommitItemCode);
        }
        if (!fromFunctionAreaCode.isEmpty() && !toFunctionAreaCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" >= "}).appendPara((Object)fromFunctionAreaCode);
        } else if (!fromFunctionAreaCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" = "}).appendPara((Object)fromFunctionAreaCode);
        }
        if (!toFunctionAreaCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" <= "}).appendPara((Object)toFunctionAreaCode);
        }
        if (!fromFundProgramCode.isEmpty() && !toFundProgramCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" >= "}).appendPara((Object)fromFundProgramCode);
        } else if (!fromFundProgramCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" = "}).appendPara((Object)fromFundProgramCode);
        }
        if (!toFundProgramCode.isEmpty()) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" <= "}).appendPara((Object)toFundProgramCode);
        }
        return sqlString.append(new Object[]{" order by "}).append(new Object[]{"FundCode"}).append(new Object[]{", "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{", "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{", "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{", "}).append(new Object[]{"FundProgramCode"});
    }
}

