/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.report;

import com.bokesoft.erp.billentity.ECS_ExpenseReimbursement;
import com.bokesoft.erp.billentity.ECS_ExpenseRequisition;
import com.bokesoft.erp.billentity.EFM_AVControl;
import com.bokesoft.erp.billentity.EFM_AddressObject;
import com.bokesoft.erp.billentity.EFM_BCSLedgerList;
import com.bokesoft.erp.billentity.EFM_BudgetImplement_Rpt;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitVoucher_Rpt;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_FundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_FundVoucher_Rpt;
import com.bokesoft.erp.billentity.FM_BudgetImplement_Rpt;
import com.bokesoft.erp.billentity.FM_CommitVoucher_Rpt;
import com.bokesoft.erp.billentity.FM_FundVoucher_Rpt;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.enums.BudgetProcessEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.cmd.richdocument.strut.UICommand;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.util.ERPDataTableUtil;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.util.List;
import org.json.JSONObject;

public class BudgetImplementReport
extends EntityContextAction {
    public BudgetImplementReport(RichDocumentContext _context) {
        super(_context);
    }

    public void getBudgetImplementOfDtl(Long dtlOID) throws Throwable {
        if ("ECS_ExpenseReimbursement".equals(this.getRichDocument().getMetaForm().getKey())) {
            ECS_ExpenseReimbursement ecsExpenseReimbursement = ECS_ExpenseReimbursement.parseDocument((RichDocument)this.getRichDocument());
            this.getBudgetImplement(ecsExpenseReimbursement.getFinancialManagementAreaID(), ERPDateUtil.getYear((Object)ecsExpenseReimbursement.getDocumentDate()), ecsExpenseReimbursement.getFundCenterID(dtlOID), ecsExpenseReimbursement.getCommitmentItemID(dtlOID), 0L, 0L, 0L);
        } else if ("ECS_ExpenseRequisition".equals(this.getRichDocument().getMetaForm().getKey())) {
            ECS_ExpenseRequisition ecsExpenseRequisition = ECS_ExpenseRequisition.parseDocument((RichDocument)this.getRichDocument());
            this.getBudgetImplement(ecsExpenseRequisition.getFinancialManagementAreaID(), ERPDateUtil.getYear((Object)ecsExpenseRequisition.getDocumentDate()), ecsExpenseRequisition.getFundCenterID(dtlOID), ecsExpenseRequisition.getCommitmentItemID(dtlOID), 0L, 0L, 0L);
        }
    }

    private void getBudgetImplement(Long fmAreaID, int fiscalYear, Long fundCenterID, Long commitItemID, Long fundID, Long functionAreaID, Long fundProgramID) throws Throwable {
        FM_BudgetImplement_Rpt fmBudgetImplementReport = (FM_BudgetImplement_Rpt)this.newBillEntity(FM_BudgetImplement_Rpt.class);
        fmBudgetImplementReport.setHeadFinancialManagementAreaID(fmAreaID);
        fmBudgetImplementReport.setHeadFiscalYear(fiscalYear);
        EFM_BCSLedgerList bcsLedgerList = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).ControlLedgerCode("9H").load();
        Long controlLedgerID = bcsLedgerList.getControlLedgerID();
        fmBudgetImplementReport.setHeadLedgerID(controlLedgerID);
        List efmAvControls = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).LedgerID(controlLedgerID).FundCenterID(fundCenterID).CommitmentItemID(commitItemID).FundID(fundID).FunctionalAreaID(functionAreaID).FundProgramID(fundProgramID).loadList();
        if (efmAvControls == null) {
            return;
        }
        for (EFM_AVControl avControl : efmAvControls) {
            EFM_AddressObject addressObject = EFM_AddressObject.loader((RichDocumentContext)this.getMidContext()).FundID(avControl.getFundID()).FundCenterID(avControl.getFundCenterID()).CommitmentItemID(avControl.getCommitmentItemID()).FundProgramID(avControl.getFundProgramID()).FunctionalAreaID(avControl.getFunctionalAreaID()).load();
            List implementReports = fmBudgetImplementReport.efm_budgetImplement_Rpts("ControlAddress", (Object)addressObject.getObjectNumber());
            EFM_BudgetImplement_Rpt efmBudgetImplementReport = implementReports == null || implementReports.isEmpty() ? fmBudgetImplementReport.newEFM_BudgetImplement_Rpt() : (EFM_BudgetImplement_Rpt)implementReports.get(0);
            efmBudgetImplementReport.setFiscalYear(fiscalYear);
            efmBudgetImplementReport.setLedgerID(controlLedgerID);
            efmBudgetImplementReport.setCommitmentItemID(avControl.getCommitmentItemID());
            efmBudgetImplementReport.setFundCenterID(avControl.getFundCenterID());
            efmBudgetImplementReport.setFundID(avControl.getFundID());
            efmBudgetImplementReport.setFundProgramID(avControl.getFundProgramID());
            efmBudgetImplementReport.setFunctionalAreaID(avControl.getFunctionalAreaID());
            efmBudgetImplementReport.setControlAddress(addressObject.getObjectNumber());
            BigDecimal budgetAmount = avControl.getHSLMoneyTotal().abs();
            if (avControl.getRecordType() == 0) {
                budgetAmount = efmBudgetImplementReport.getBudgetMoney();
            }
            List carryVoucherDetails = EFM_BudgetVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).BudgetLedgerID(bcsLedgerList.getBudgetLedgerID()).FundID(avControl.getFundID()).FundCenterID(avControl.getFundCenterID()).CommitmentItemID(avControl.getCommitmentItemID()).FunctionalAreaID(avControl.getFunctionalAreaID()).FundProgramID(avControl.getFundProgramID()).IsCarryVoucher(1).HasUpdatedAVC(1).loadList();
            BigDecimal carryAmount = BigDecimal.ZERO;
            if (carryVoucherDetails != null && carryVoucherDetails.size() > 0) {
                for (EFM_BudgetVoucherDtl voucherDetail : carryVoucherDetails) {
                    String bcsValType = voucherDetail.getBCSValType();
                    String budgetProcess = voucherDetail.getBudgetProcess();
                    if ((!"B1".equals(bcsValType) || !BudgetProcessEnum.CORV.getKey().equals(budgetProcess)) && (!"R1".equals(bcsValType) || !BudgetProcessEnum.SUPL.getKey().equals(budgetProcess))) continue;
                    carryAmount = carryAmount.add(voucherDetail.getMoney());
                }
            }
            efmBudgetImplementReport.setLastCarryoverBudgetMoney(carryAmount);
            efmBudgetImplementReport.setBudgetMoney(budgetAmount.subtract(carryAmount));
            BigDecimal commitAmount = BigDecimal.ZERO;
            List commitVouchers = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).LedgerID(bcsLedgerList.getPostLedgerID()).ToFundID(avControl.getFundID()).ToFundCenterID(avControl.getFundCenterID()).ToCommitmentItemID(avControl.getCommitmentItemID()).ToFunctionalAreaID(avControl.getFunctionalAreaID()).ControlFundProgramID(avControl.getFundProgramID()).IsUpdate(1).loadList();
            if (commitVouchers != null && commitVouchers.size() > 0) {
                for (EFM_CommitVoucherDtl voucherDetail : commitVouchers) {
                    BigDecimal fmacAmount = voucherDetail.getFMAreaCurrencyMoney();
                    if (voucherDetail.getValueType().equals(ValueTypeEnum.ValueType_83.getKey())) {
                        fmacAmount = fmacAmount.negate();
                    }
                    commitAmount = commitAmount.add(fmacAmount);
                }
            }
            efmBudgetImplementReport.setCommitMoney(commitAmount);
            BigDecimal actualAmount = BigDecimal.ZERO;
            List fundVoucherDtls = EFM_FundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).LedgerID(bcsLedgerList.getPostLedgerID()).ToFundID(avControl.getFundID()).ToFundCenterID(avControl.getFundCenterID()).ToCommitmentItemID(avControl.getCommitmentItemID()).ToFunctionalAreaID(avControl.getFunctionalAreaID()).ToFundProgramID(avControl.getFundProgramID()).IsUpdate(1).loadList();
            if (fundVoucherDtls != null && fundVoucherDtls.size() > 0) {
                for (EFM_FundVoucherDtl fundVoucherDtl : fundVoucherDtls) {
                    BigDecimal fmacAmount = fundVoucherDtl.getFMAreaCurrencyMoney();
                    if (fundVoucherDtl.getValueType().equals(ValueTypeEnum.ValueType_54.getKey()) && fundVoucherDtl.getReferTransaction().equals("VBRK")) {
                        fmacAmount = fmacAmount.negate();
                    }
                    actualAmount = actualAmount.add(fmacAmount);
                }
            }
            efmBudgetImplementReport.setActualMoney(actualAmount);
            efmBudgetImplementReport.setTotalOccupyMoney(commitAmount.add(actualAmount));
            efmBudgetImplementReport.setResidualMoney(budgetAmount.subtract(commitAmount).subtract(actualAmount));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("formKey", (Object)"FM_BudgetImplement_Rpt");
        jsonObject.put("doc", (Object)fmBudgetImplementReport.document.toJSON());
        jsonObject.put("target", (Object)"newtab");
        this.getMidContext().getRichDocument().appendUICommand(new UICommand("NewFormShow", (Object)jsonObject, new Object[0]));
    }

    public void commitVoucherQuery(int rowIndex) throws Throwable {
        FM_BudgetImplement_Rpt implementReport = FM_BudgetImplement_Rpt.parseDocument((RichDocument)this.getDocument());
        List implementReports = implementReport.efm_budgetImplement_Rpts();
        EFM_BudgetImplement_Rpt selectReport = (EFM_BudgetImplement_Rpt)implementReports.get(rowIndex);
        if (selectReport == null) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA002");
        }
        Long fundID = selectReport.getFundID();
        Long fundCenterID = selectReport.getFundCenterID();
        Long commitItemID = selectReport.getCommitmentItemID();
        Long functionAreaID = selectReport.getFunctionalAreaID();
        Long fundProgramID = selectReport.getFundProgramID();
        int fiscalYear = selectReport.getFiscalYear();
        Long ledgerID = selectReport.getLedgerID();
        Long headFinancialManagementAreaID = implementReport.getHeadFinancialManagementAreaID();
        EFM_BCSLedgerList bcsLedgerList = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).ControlLedgerID(ledgerID).load();
        if (bcsLedgerList == null) {
            MessageFacade.throwException((String)"BUDGETIMPLEMENTREPORT002", (Object[])new Object[]{selectReport.getLedger().getCode()});
        }
        Long postLedgerID = bcsLedgerList.getPostLedgerID();
        FM_CommitVoucher_Rpt commitVoucherReport = (FM_CommitVoucher_Rpt)this.newBillEntity(FM_CommitVoucher_Rpt.class);
        commitVoucherReport.setHeadFinancialManagementAreaID(headFinancialManagementAreaID);
        SqlString sqlString = new SqlString();
        sqlString.append(new Object[]{"select b.Creator as Creator,b.DocumentDate as DocumentDate,a.* from EFM_CommitVoucherDtl a left join EFM_CommitVoucherHead b on a.SOID=b.OID "});
        sqlString.append(new Object[]{"where a."}).append(new Object[]{"ToFundID"}).append(new Object[]{" = "}).appendPara((Object)fundID).append(new Object[]{" and a."}).append(new Object[]{"ToFundCenterID"}).append(new Object[]{" = "}).appendPara((Object)fundCenterID).append(new Object[]{" and a."}).append(new Object[]{"ToCommitmentItemID"}).append(new Object[]{" = "}).appendPara((Object)commitItemID).append(new Object[]{" and a."}).append(new Object[]{"ToFunctionalAreaID"}).append(new Object[]{" = "}).appendPara((Object)functionAreaID).append(new Object[]{" and a."}).append(new Object[]{"ControlFundProgramID"}).append(new Object[]{" = "}).appendPara((Object)fundProgramID).append(new Object[]{" and a."}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear).append(new Object[]{" and a."}).append(new Object[]{"LedgerID"}).append(new Object[]{" = "}).appendPara((Object)postLedgerID).append(new Object[]{" and a."}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)headFinancialManagementAreaID).append(new Object[]{" and a."}).append(new Object[]{"IsUpdate"}).append(new Object[]{" = "}).appendPara((Object)1);
        DataTable resultSet = this.getResultSet(sqlString);
        ERPDataTableUtil.appendAllWithoutError((DataTable)resultSet, (DataTable)commitVoucherReport.getDataTable("EFM_CommitVoucher_Rpt"), (String)"");
        for (EFM_CommitVoucher_Rpt reportDtl : commitVoucherReport.efm_commitVoucher_Rpts()) {
            EFM_CommitmentItemHead commitItem = reportDtl.getCommitmentItem();
            reportDtl.setCommitmentItemType_NODB(TypeConvertor.toString((Object)commitItem.getCommitmentItemType()));
            reportDtl.setFinancialBusiness_NODB(TypeConvertor.toString((Object)commitItem.getFinancialBusiness()));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("formKey", (Object)"FM_CommitVoucher_Rpt");
        jsonObject.put("doc", (Object)commitVoucherReport.document.toJSON());
        jsonObject.put("target", (Object)"newtab");
        this.getMidContext().getRichDocument().appendUICommand(new UICommand("NewFormShow", (Object)jsonObject, new Object[0]));
    }

    public void fundVoucherQuery(int rowIndex) throws Throwable {
        FM_BudgetImplement_Rpt implementReport = FM_BudgetImplement_Rpt.parseDocument((RichDocument)this.getDocument());
        List implementReports = implementReport.efm_budgetImplement_Rpts();
        EFM_BudgetImplement_Rpt selectReport = (EFM_BudgetImplement_Rpt)implementReports.get(rowIndex);
        if (selectReport == null) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA002");
        }
        Long fundID = selectReport.getFundID();
        Long fundCenterID = selectReport.getFundCenterID();
        Long commitItemID = selectReport.getCommitmentItemID();
        Long functionAreaID = selectReport.getFunctionalAreaID();
        Long fundProgramID = selectReport.getFundProgramID();
        int fiscalYear = selectReport.getFiscalYear();
        Long ledgerID = selectReport.getLedgerID();
        Long headFinancialManagementAreaID = implementReport.getHeadFinancialManagementAreaID();
        EFM_BCSLedgerList bcsLedgerList = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).ControlLedgerID(ledgerID).load();
        if (bcsLedgerList == null) {
            MessageFacade.throwException((String)"BUDGETIMPLEMENTREPORT002", (Object[])new Object[]{selectReport.getLedger().getCode()});
        }
        Long postLedgerID = bcsLedgerList.getPostLedgerID();
        FM_FundVoucher_Rpt fundVoucherReport = (FM_FundVoucher_Rpt)this.newBillEntity(FM_FundVoucher_Rpt.class);
        fundVoucherReport.setHeadFinancialManagementAreaID(headFinancialManagementAreaID);
        SqlString sqlString = new SqlString();
        sqlString.append(new Object[]{"select b.DocumentNumber as DocumentNumber,b.DocumentDate as DocumentDate,b.Creator as Creator,a.* from EFM_FundVoucherDtl a left join EFM_FundVoucherHead b on a.SOID=b.OID "});
        sqlString.append(new Object[]{" where a."}).append(new Object[]{"ToFundID"}).append(new Object[]{" = "}).appendPara((Object)fundID).append(new Object[]{" and a."}).append(new Object[]{"ToFundCenterID"}).append(new Object[]{" = "}).appendPara((Object)fundCenterID).append(new Object[]{" and a."}).append(new Object[]{"ToCommitmentItemID"}).append(new Object[]{" = "}).appendPara((Object)commitItemID).append(new Object[]{" and a."}).append(new Object[]{"ToFunctionalAreaID"}).append(new Object[]{" = "}).appendPara((Object)functionAreaID).append(new Object[]{" and a."}).append(new Object[]{"ToFundProgramID"}).append(new Object[]{" = "}).appendPara((Object)fundProgramID).append(new Object[]{" and a."}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear).append(new Object[]{" and a."}).append(new Object[]{"LedgerID"}).append(new Object[]{" = "}).appendPara((Object)postLedgerID).append(new Object[]{" and a."}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)headFinancialManagementAreaID).append(new Object[]{" and a."}).append(new Object[]{"IsUpdate"}).append(new Object[]{" = "}).appendPara((Object)1);
        DataTable resultSet = this.getResultSet(sqlString);
        ERPDataTableUtil.appendAllWithoutError((DataTable)resultSet, (DataTable)fundVoucherReport.getDataTable("EFM_FundVoucher_Rpt"), (String)"");
        for (EFM_FundVoucher_Rpt reportDtl : fundVoucherReport.efm_fundVoucher_Rpts()) {
            EFM_CommitmentItemHead commitItem = reportDtl.getCommitmentItem();
            reportDtl.setCommitmentItemType_NODB(TypeConvertor.toString((Object)commitItem.getCommitmentItemType()));
            reportDtl.setFinancialBusiness_NODB(TypeConvertor.toString((Object)commitItem.getFinancialBusiness()));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("formKey", (Object)"FM_FundVoucher_Rpt");
        jsonObject.put("doc", (Object)fundVoucherReport.document.toJSON());
        jsonObject.put("target", (Object)"newtab");
        this.getMidContext().getRichDocument().appendUICommand(new UICommand("NewFormShow", (Object)jsonObject, new Object[0]));
    }
}

