/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.masterdata;

import com.bokesoft.erp.billentity.BK_Account;
import com.bokesoft.erp.billentity.BK_CompanyCode;
import com.bokesoft.erp.billentity.EFI_Account_CpyCodeDtl;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_CommitmentItemMask;
import com.bokesoft.erp.billentity.EFM_FMAreaToCompanyCode;
import com.bokesoft.erp.billentity.EFM_FundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_MaskSpecialCharacter;
import com.bokesoft.erp.billentity.FM_CommitmentItem;
import com.bokesoft.erp.billentity.FM_CommitmentItemMask;
import com.bokesoft.erp.billentity.FM_CommitmentItemVariant;
import com.bokesoft.erp.billentity.FM_CommitmentItem_DictList;
import com.bokesoft.erp.billentity.FM_MaskSpecialCharacter;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.exception.ERPException;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.util.ERPDataTableUtil;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.HashMap;
import java.util.List;

public class FMCommitItemFormula
extends EntityContextAction {
    HashMap<String, Long> useCodeMap = new HashMap();

    public FMCommitItemFormula(RichDocumentContext _context) {
        super(_context);
    }

    public void generateFromAccount(Long fmAreaID) throws Throwable {
        List areaToCompanyCodes = EFM_FMAreaToCompanyCode.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).loadList();
        if (areaToCompanyCodes == null || areaToCompanyCodes.isEmpty()) {
            MessageFacade.throwException((String)"FMCOMMITITEMFORMULA010");
        }
        int size = 0;
        for (EFM_FMAreaToCompanyCode areaToCompanyCode : areaToCompanyCodes) {
            BK_CompanyCode bkCompanyCode = areaToCompanyCode.getCompanyCode();
            Long accountChartID = bkCompanyCode.getAccountChartID();
            List bk_accounts = BK_Account.loader((RichDocumentContext)this.getMidContext()).AccountChartID(accountChartID).orderBy("TLeft").loadList();
            if (bk_accounts == null || bk_accounts.isEmpty()) {
                MessageFacade.throwException((String)"FMCOMMITITEMFORMULA011");
            }
            for (BK_Account account : bk_accounts) {
                EFI_Account_CpyCodeDtl cpyCodeDtl = EFI_Account_CpyCodeDtl.loader((RichDocumentContext)this.getMidContext()).SOID(account.getOID()).CompanyCodeID(bkCompanyCode.getOID()).load();
                if (cpyCodeDtl != null && cpyCodeDtl.getCommitmentItemID().compareTo(0L) > 0) continue;
                String useCode = account.getUseCode();
                EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).UseCode(useCode).load();
                if (commitmentItem != null) continue;
                String name = account.getName();
                FM_CommitmentItem fm_commitmentItem = (FM_CommitmentItem)this.newBillEntity(FM_CommitmentItem.class);
                fm_commitmentItem.setFinancialManagementAreaID(fmAreaID);
                fm_commitmentItem.setUseCode(useCode);
                fm_commitmentItem.setName(name);
                this.save((AbstractBillEntity)fm_commitmentItem);
                ++size;
                if (cpyCodeDtl == null) continue;
                cpyCodeDtl.setCommitmentItemID(fm_commitmentItem.getOID());
                this.save((AbstractTableEntity)cpyCodeDtl, "V_Account");
            }
        }
        MessageFacade.push((String)"FMCOMMITITEMFORMULA012", (Object[])new Object[]{size});
    }

    public void deleteCommitItemVariantCheck() throws Throwable {
        FM_CommitmentItemVariant fmCommitItemVariant = FM_CommitmentItemVariant.parseDocument((RichDocument)this.getDocument());
        String useCode = fmCommitItemVariant.getUseCode();
        if (useCode.equals("000")) {
            MessageFacade.throwException((String)"FMCOMMITITEMFORMULA000");
        }
    }

    public void judgeFinancialBusinessAndCommitmentItemType() throws Throwable {
        FM_CommitmentItem fmCommitmentItem = FM_CommitmentItem.parseDocument((RichDocument)this.getDocument());
        int financialBusiness = fmCommitmentItem.getFinancialBusiness();
        int commitItemType = fmCommitmentItem.getCommitmentItemType();
        if (commitItemType == 4) {
            MessageFacade.throwException((String)"FMCOMMITITEMFORMULA001");
        }
        if (financialBusiness == 90) {
            if (commitItemType == 2 || commitItemType == 3) {
                MessageFacade.throwException((String)"FMCOMMITITEMFORMULA002");
            }
        } else if (commitItemType == 1 || commitItemType == 5) {
            MessageFacade.throwException((String)"FMCOMMITITEMFORMULA003");
        }
    }

    public boolean checkCommitItem(Long commitmentItemOID) throws Throwable {
        List commitVouchers = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).CommitmentItemID(commitmentItemOID).loadList();
        List fundVoucherDtls = EFM_FundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).CommitmentItemID(commitmentItemOID).loadList();
        return !(commitVouchers != null && commitVouchers.size() != 0 || fundVoucherDtls != null && fundVoucherDtls.size() != 0);
    }

    public void highestLevelCommitmentItemsUpdate() throws Throwable {
        FM_CommitmentItem fmCommitmentItem = FM_CommitmentItem.parseDocument((RichDocument)this.getDocument());
        Long parentId = fmCommitmentItem.getParentID();
        if (parentId == 0L) {
            int tLeft = fmCommitmentItem.efm_commitmentItemHead().getTLeft();
            int tRight = fmCommitmentItem.efm_commitmentItemHead().getTRight();
            List efmCommitmentItems = EFM_CommitmentItemHead.loader((RichDocumentContext)this.getMidContext()).TLeft(">", tLeft).TRight("<", tRight).loadList();
            if (efmCommitmentItems != null) {
                for (EFM_CommitmentItemHead commitmentItem : efmCommitmentItems) {
                    commitmentItem.setFinancialBusiness(fmCommitmentItem.getFinancialBusiness());
                    commitmentItem.setCommitmentItemType(fmCommitmentItem.getCommitmentItemType());
                    commitmentItem.setIsStatisticalCommit(fmCommitmentItem.getIsStatisticalCommit());
                }
                this.save(efmCommitmentItems);
            }
        } else {
            EFM_CommitmentItemHead efmCommitmentItem = EFM_CommitmentItemHead.loader((RichDocumentContext)this.getMidContext()).SOID(parentId).load();
            if (efmCommitmentItem != null) {
                if (efmCommitmentItem.getIsPostOpen() == 1 && fmCommitmentItem.efm_commitmentItemHead().getIsPostOpen() != 1) {
                    MessageFacade.throwException((String)"FMCOMMITITEMFORMULA004");
                }
                if (efmCommitmentItem.getCommitmentItemType() != fmCommitmentItem.getCommitmentItemType()) {
                    MessageFacade.throwException((String)"FMCOMMITITEMFORMULA005", (Object[])new Object[]{fmCommitmentItem.getCommitmentItemType(), efmCommitmentItem.getCommitmentItemType()});
                }
                if (efmCommitmentItem.getFinancialBusiness() != fmCommitmentItem.getFinancialBusiness()) {
                    MessageFacade.throwException((String)"FMCOMMITITEMFORMULA006", (Object[])new Object[]{fmCommitmentItem.getFinancialBusiness(), efmCommitmentItem.getFinancialBusiness()});
                }
                if (efmCommitmentItem.getIsStatisticalCommit() != fmCommitmentItem.getIsStatisticalCommit()) {
                    MessageFacade.throwException((String)"FMCOMMITITEMFORMULA007", (Object[])new Object[]{fmCommitmentItem.getUseCode(), efmCommitmentItem.getUseCode()});
                }
            }
        }
    }

    public void combSpecial() throws Throwable {
        DataTable dataTable = this.getDocument().getDataTable("EFM_MaskSpecialCharacter");
        StringBuilder allSpecial = new StringBuilder();
        if (dataTable == null || dataTable.size() == 0) {
            return;
        }
        int i = 1;
        while (i <= 3) {
            String specialChar = dataTable.getString(0, "SpecialCharacter" + i);
            if (!StringUtil.isBlankOrNull((String)specialChar)) {
                if (".".equals(specialChar)) {
                    allSpecial.append("\\").append(specialChar).append("|");
                } else {
                    allSpecial.append(specialChar).append("|");
                }
            }
            ++i;
        }
        if (allSpecial.length() == 0) {
            return;
        }
        dataTable.setString("AllSpecial", allSpecial.substring(0, allSpecial.length() - 1));
    }

    public void checkBeforeSave() throws Throwable {
        EFM_MaskSpecialCharacter maskSpecialCharacter = EFM_MaskSpecialCharacter.loader((RichDocumentContext)this.getMidContext()).load();
        if (maskSpecialCharacter == null) {
            MessageFacade.throwException((String)"FMCOMMITITEMFORMULA008");
        }
        FM_CommitmentItemMask fmCommitmentItemMask = FM_CommitmentItemMask.parseDocument((RichDocument)this.getDocument());
        EFM_CommitmentItemMask efmCommitmentItemMask = fmCommitmentItemMask.efm_commitmentItemMask();
        String allSpecial = maskSpecialCharacter.getAllSpecial();
        if (efmCommitmentItemMask.isAddnew() || efmCommitmentItemMask.isUpdated()) {
            String maskDisk = efmCommitmentItemMask.getMaskDisk();
            String[] split = maskDisk.split(allSpecial);
            int i = 1;
            while (i < split.length) {
                String mask = split[i];
                char[] cArray = mask.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char cm = cArray[n2];
                    if (cm != 'X') {
                        throw new ERPException(this.getEnv(), "\u5b57\u7b26{1}\u65e0\u6548\uff01", new Object[]{Character.valueOf(cm)});
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }

    public void dealProjectCode() throws Throwable {
        FM_CommitmentItem fmCommitmentItem = FM_CommitmentItem.parseDocument((RichDocument)this.getDocument());
        EFM_MaskSpecialCharacter maskSpecialCharacter = EFM_MaskSpecialCharacter.loader((RichDocumentContext)this.getMidContext()).load();
        EFM_CommitmentItemMask commitmentItemMask = EFM_CommitmentItemMask.loader((RichDocumentContext)this.getMidContext()).load();
        String useCode = fmCommitmentItem.getUseCode();
        if (commitmentItemMask == null || commitmentItemMask.getMaskDisk().isEmpty() || maskSpecialCharacter == null) {
            return;
        }
        String resultCode = this.getResultCode(useCode, maskSpecialCharacter, commitmentItemMask);
        fmCommitmentItem.setUseCode(resultCode);
    }

    private String getResultCode(String code, EFM_MaskSpecialCharacter maskSpecialCharacter, EFM_CommitmentItemMask commitmentItemMask) throws Throwable {
        StringBuilder resultCode = new StringBuilder();
        String maskDisk = commitmentItemMask.getMaskDisk();
        int maskLength = 0;
        char[] cArray = maskDisk.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char a = cArray[n2];
            if (a == 'X') {
                ++maskLength;
            }
            ++n2;
        }
        String allSpecial = maskSpecialCharacter.getAllSpecial();
        String[] everyMask = maskDisk.split(allSpecial);
        if (maskLength < code.length()) {
            return code;
        }
        int lengthFlag = 0;
        String[] stringArray = everyMask;
        int n3 = everyMask.length;
        int n4 = 0;
        while (n4 < n3) {
            String mask = stringArray[n4];
            int length = mask.length();
            if (length != 0) {
                String codeFlag;
                String specialMask = "";
                if ((lengthFlag += length) < maskDisk.length()) {
                    specialMask = maskDisk.substring(lengthFlag, lengthFlag + 1);
                }
                if (length >= code.length()) {
                    codeFlag = code;
                    int i = 1;
                    while (i <= 3) {
                        String specialChar = maskSpecialCharacter.getDataTable().getString(0, "SpecialCharacter" + i);
                        if (specialChar != null && !specialChar.isEmpty() && codeFlag.contains(specialChar)) {
                            codeFlag = codeFlag.replace(specialChar, "");
                        }
                        ++i;
                    }
                    if (!mask.contains("X")) break;
                    resultCode.append(codeFlag);
                    break;
                }
                int j = 0;
                codeFlag = code.substring(j, length);
                boolean spFlag = false;
                int i = 1;
                while (i <= 3) {
                    String specialChar = maskSpecialCharacter.getDataTable().getString(0, "SpecialCharacter" + i);
                    if (specialChar != null && !specialChar.isEmpty() && codeFlag.contains(specialChar)) {
                        if (length < code.length()) {
                            codeFlag = code.substring(++j, ++length);
                            i = 1;
                        } else {
                            codeFlag = codeFlag.replace(specialChar, "");
                            spFlag = true;
                        }
                    }
                    ++i;
                }
                if (mask.contains("X")) {
                    resultCode.append(codeFlag);
                }
                if (spFlag) break;
                if (!"".equals(code = code.substring(length))) {
                    resultCode.append(specialMask);
                }
                ++lengthFlag;
            }
            ++n4;
        }
        return resultCode.toString();
    }

    public void getCommitmentByFinancialManagementAreaID(Long FinancialManagementAreaID) throws Throwable {
        if (FinancialManagementAreaID <= 0L) {
            return;
        }
        SqlString sqlString = new SqlString().append(new Object[]{"select "}).append(new Object[]{"EFM_CommitmentItemHead"}).append(new Object[]{".*,"}).append(new Object[]{MetaTableCache.getMultilLangCol((IDBManager)this.getMidContext().getDBManager(), (String)"EFM_CommitmentItemHead", (String)"Name")}).append(new Object[]{"Name_NODB"}).append(new Object[]{" from "}).append(new Object[]{"EFM_CommitmentItemHead"}).append(new Object[]{" where "}).append(new Object[]{"FinancialManagementAreaID="}).appendPara((Object)FinancialManagementAreaID).append(new Object[]{" and "}).append(new Object[]{"IsStandardHy = "}).appendPara((Object)1);
        DataTable commitmentitems = this.getResultSet(sqlString);
        DataTable docDataTable = this.getDocument().getDataTable("EFM_CommitmentItemHead");
        docDataTable.clear();
        if (commitmentitems != null && !commitmentitems.isEmpty()) {
            String ignoreColKeys = StringUtil.join((String)",", (String[])new String[]{"SelectField", "Enable", "MapCount", "Slock"});
            ERPDataTableUtil.appendAllWithoutError((DataTable)commitmentitems, (DataTable)docDataTable, (String)ignoreColKeys);
            docDataTable.setSort("TLeft", true);
            docDataTable.sort();
            int i = 0;
            while (i < docDataTable.size()) {
                docDataTable.setPos(i);
                docDataTable.setState(0);
                ++i;
            }
        }
        this.getDocument().addDirtyTableFlag("EFM_CommitmentItemHead");
    }

    public void deleteCommitItemConstruct4CommitItemList() throws Throwable {
        FM_CommitmentItem_DictList commitItemDictList = FM_CommitmentItem_DictList.parseDocument((RichDocument)this.getDocument());
        DataTable commitItemList = commitItemDictList.getDataTable("EFM_CommitmentItemHead");
        commitItemList.setShowDeleted(true);
        commitItemList.beforeFirst();
        while (commitItemList.next()) {
            if (commitItemList.getState() != 3) continue;
            String code = commitItemList.getString("Code");
            EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.loader((RichDocumentContext)this.getMidContext()).Code(code).load();
            if (commitmentItem == null) continue;
            this.delete((AbstractTableEntity)commitmentItem);
        }
        commitItemList.setShowDeleted(false);
    }

    public void checkMaskSpecialCharacterRow() throws Throwable {
        FM_MaskSpecialCharacter maskSpecialCharacter = FM_MaskSpecialCharacter.parseDocument((RichDocument)this.getDocument());
        List efmMaskSpecialCharacters = maskSpecialCharacter.efm_maskSpecialCharacters();
        if (efmMaskSpecialCharacters != null && efmMaskSpecialCharacters.size() > 1) {
            MessageFacade.throwException((String)"FMCOMMITITEMFORMULA009");
        }
    }
}

