/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.function;

import com.bokesoft.erp.billentity.ECO_Version;
import com.bokesoft.erp.billentity.EFI_Ledger;
import com.bokesoft.erp.billentity.EFI_LedgerDtl;
import com.bokesoft.erp.billentity.EFM_AVCPostLedger;
import com.bokesoft.erp.billentity.EFM_ActiveBdCategory;
import com.bokesoft.erp.billentity.EFM_AllotParaFile;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_BStatusAllot;
import com.bokesoft.erp.billentity.EFM_BudgetTypeDtl;
import com.bokesoft.erp.billentity.EFM_BudgetTypeHead;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_DocumentTypeDtl;
import com.bokesoft.erp.billentity.EFM_FMAreaToCompanyCode;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_PostLedgerPeriod;
import com.bokesoft.erp.billentity.EFM_SCApprovalSettings;
import com.bokesoft.erp.billentity.EFM_SCBudgetSettings;
import com.bokesoft.erp.billentity.FM_AVCPostLedger;
import com.bokesoft.erp.billentity.FM_ActiveBdCategory;
import com.bokesoft.erp.billentity.FM_AllotParaFile;
import com.bokesoft.erp.billentity.FM_BSDistribution;
import com.bokesoft.erp.billentity.FM_BStatusAllot;
import com.bokesoft.erp.billentity.FM_BudgetRelease;
import com.bokesoft.erp.billentity.FM_BudgetStatus;
import com.bokesoft.erp.billentity.FM_BudgetStructure;
import com.bokesoft.erp.billentity.FM_BudgetType;
import com.bokesoft.erp.billentity.FM_CommitmentItemVariant;
import com.bokesoft.erp.billentity.FM_DocumentType;
import com.bokesoft.erp.billentity.FM_FinancialManagementArea;
import com.bokesoft.erp.billentity.FM_FundCenter;
import com.bokesoft.erp.billentity.FM_PostLedgerPeriod;
import com.bokesoft.erp.billentity.FM_ToleranceParaFile;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.exception.ERPException;
import com.bokesoft.erp.fm.enums.BudgetProcessEnum;
import com.bokesoft.erp.fm.enums.ReferDocTypeEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import java.util.List;

public class FMAreaFormula
extends EntityContextAction {
    public FMAreaFormula(RichDocumentContext _context) {
        super(_context);
    }

    public boolean checkFundCenterCompanyCode(Long fundCenterID, Long companyCode) throws Throwable {
        if (fundCenterID <= 0L) {
            return false;
        }
        FM_FundCenter fm_fundCenter = FM_FundCenter.load((RichDocumentContext)this.getMidContext(), (Long)fundCenterID);
        Long companyCodeID = fm_fundCenter.getCompanyCodeID();
        return companyCodeID > 0L && !companyCodeID.equals(companyCode);
    }

    public void genDefaultAllocation() throws Throwable {
        FM_FinancialManagementArea finManagementArea = FM_FinancialManagementArea.parseDocument((RichDocument)this.getRichDocument());
        if (!Boolean.parseBoolean(finManagementArea.getIsNew())) {
            return;
        }
        Long finManagementAreaOID = finManagementArea.getOID();
        FM_BudgetStructure fmBudgetStructure = (FM_BudgetStructure)this.newBillEntity(FM_BudgetStructure.class);
        fmBudgetStructure.setFinancialManagementAreaID(finManagementAreaOID);
        fmBudgetStructure.setUseCode("000");
        fmBudgetStructure.setName("\u9884\u7b97\u7ed3\u6784000");
        this.save((AbstractBillEntity)fmBudgetStructure);
        FM_BSDistribution fmBsDistribution = (FM_BSDistribution)this.newBillEntity(FM_BSDistribution.class);
        EFM_BSDistribution efmBsDistribution = fmBsDistribution.newEFM_BSDistribution();
        efmBsDistribution.setFinancialManagementAreaID(finManagementAreaOID);
        efmBsDistribution.setFiscalYear(ERPDateUtil.getYear((Object)ERPDateUtil.getNowDate()));
        efmBsDistribution.setBudgetStructureID(fmBudgetStructure.getOID());
        this.save((AbstractBillEntity)fmBsDistribution);
        FM_ActiveBdCategory fmActiveBdCategory = (FM_ActiveBdCategory)this.newBillEntity(FM_ActiveBdCategory.class);
        EFM_ActiveBdCategory efmActiveBdCategory = fmActiveBdCategory.newEFM_ActiveBdCategory();
        efmActiveBdCategory.setFinancialManagementAreaID(finManagementAreaOID);
        EFM_Ledger efmLedgerOf9F = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9F").load();
        efmActiveBdCategory.setBudgetLedgerID(efmLedgerOf9F.getOID());
        this.save((AbstractBillEntity)fmActiveBdCategory);
        FM_BudgetRelease fmBudgetRelease = FM_BudgetRelease.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaSOID(finManagementAreaOID).load();
        EFM_FinancialManagementArea efmFinManagementArea = (EFM_FinancialManagementArea)fmBudgetRelease.efm_financialManagementAreas().get(0);
        efmFinManagementArea.setManagementPlan("RELEASE");
        efmFinManagementArea.setIsReleaseIncome(1);
        efmFinManagementArea.setBCSActiveYear(ERPDateUtil.getYear((Object)ERPDateUtil.getNowDate()));
        this.save((AbstractBillEntity)fmBudgetRelease);
        FM_BudgetType fmBudgetTypeOfB1 = (FM_BudgetType)this.newBillEntity(FM_BudgetType.class);
        fmBudgetTypeOfB1.setFinancialManagementAreaID(finManagementAreaOID);
        fmBudgetTypeOfB1.setUseCode("C001");
        fmBudgetTypeOfB1.setName("\u9884\u7b97\u7c7b\u578bC001");
        fmBudgetTypeOfB1.setBCSValType("B1");
        EFM_BudgetTypeDtl efmBudgetTypeDtl1 = fmBudgetTypeOfB1.newEFM_BudgetTypeDtl();
        efmBudgetTypeDtl1.setProcessCode(BudgetProcessEnum.All.getKey());
        this.save((AbstractBillEntity)fmBudgetTypeOfB1);
        FM_BudgetType fmBudgetTypeOfR1 = (FM_BudgetType)this.newBillEntity(FM_BudgetType.class);
        fmBudgetTypeOfR1.setFinancialManagementAreaID(finManagementAreaOID);
        fmBudgetTypeOfR1.setUseCode("C002");
        fmBudgetTypeOfR1.setName("\u9884\u7b97\u7c7b\u578bC002");
        fmBudgetTypeOfR1.setBCSValType("R1");
        EFM_BudgetTypeDtl efmBudgetTypeDtl2 = fmBudgetTypeOfR1.newEFM_BudgetTypeDtl();
        efmBudgetTypeDtl2.setProcessCode(BudgetProcessEnum.All.getKey());
        this.save((AbstractBillEntity)fmBudgetTypeOfR1);
        FM_BudgetStatus fmBudgetStatus = (FM_BudgetStatus)this.newBillEntity(FM_BudgetStatus.class);
        fmBudgetStatus.setFinancialManagementAreaID(finManagementAreaOID);
        fmBudgetStatus.setUseCode("STAT00");
        fmBudgetStatus.setName("\u5141\u8bb8\u9884\u7b97");
        EFM_SCBudgetSettings efmScBudgetSettings = fmBudgetStatus.newEFM_SCBudgetSettings();
        efmScBudgetSettings.setBudgetLedgerID(efmLedgerOf9F.getOID());
        efmScBudgetSettings.setBudgetTypeID(fmBudgetTypeOfB1.getOID());
        efmScBudgetSettings.setBudgetProcess(BudgetProcessEnum.All.getKey());
        EFM_SCApprovalSettings efmScApprovalSettings = fmBudgetStatus.newEFM_SCApprovalSettings();
        efmScApprovalSettings.setBudgetLedgerID(efmLedgerOf9F.getOID());
        efmScApprovalSettings.setBudgetTypeID(fmBudgetTypeOfR1.getOID());
        efmScApprovalSettings.setBudgetProcess(BudgetProcessEnum.All.getKey());
        this.save((AbstractBillEntity)fmBudgetStatus);
        FM_BStatusAllot fmBStatusAllot = (FM_BStatusAllot)this.newBillEntity(FM_BStatusAllot.class);
        EFM_BStatusAllot bStatusAllot = fmBStatusAllot.newEFM_BStatusAllot();
        bStatusAllot.setFinancialManagementAreaID(finManagementAreaOID);
        bStatusAllot.setFiscalYear(ERPDateUtil.getYear((Object)ERPDateUtil.getNowDate()));
        ECO_Version ecoVersion = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load();
        bStatusAllot.setVersionID(ecoVersion.getOID());
        bStatusAllot.setBudgetStatusID(fmBudgetStatus.getOID());
        bStatusAllot.setIsCheckBudgetAddress(1);
        this.save((AbstractBillEntity)fmBStatusAllot);
        FM_DocumentType fmDocumentType = FM_DocumentType.loader((RichDocumentContext)this.getMidContext()).Code("000").load();
        if (fmDocumentType == null) {
            fmDocumentType = (FM_DocumentType)this.newBillEntity(FM_DocumentType.class);
            fmDocumentType.setNotRunValueChanged();
            fmDocumentType.setCode("000");
            fmDocumentType.setName("\u81ea\u52a8\u53d1\u5e03\u7684\u9884\u7b97");
            fmDocumentType.setValueTypeScheme("A1");
            EFM_DocumentTypeDtl efmDocumentTypeDtl = fmDocumentType.newEFM_DocumentTypeDtl();
            efmDocumentTypeDtl.setProcessCode(BudgetProcessEnum.All.getKey());
            this.save((AbstractBillEntity)fmDocumentType);
        }
        FM_PostLedgerPeriod fmPostLedgerPeriod = (FM_PostLedgerPeriod)this.newBillEntity(FM_PostLedgerPeriod.class);
        EFM_PostLedgerPeriod efmPostLedgerPeriod = fmPostLedgerPeriod.newEFM_PostLedgerPeriod();
        efmPostLedgerPeriod.setFinancialManagementAreaID(finManagementAreaOID);
        EFM_Ledger efmLedgerOf9A = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
        efmPostLedgerPeriod.setLedgerID(efmLedgerOf9A.getOID());
        efmPostLedgerPeriod.setFiscalYear(ERPDateUtil.getYear((Object)ERPDateUtil.getNowDate()));
        efmPostLedgerPeriod.setValueType(ValueTypeEnum.ValueType_ALL.getKey());
        efmPostLedgerPeriod.setFromFiscalPeriod(1);
        efmPostLedgerPeriod.setToFiscalPeriod(16);
        this.save((AbstractBillEntity)fmPostLedgerPeriod);
        FM_AVCPostLedger fmAvcPostLedger = (FM_AVCPostLedger)this.newBillEntity(FM_AVCPostLedger.class);
        EFM_AVCPostLedger efmAvcPostLedger = fmAvcPostLedger.newEFM_AVCPostLedger();
        efmAvcPostLedger.setFinancialManagementAreaID(finManagementAreaOID);
        EFM_Ledger efmLedgerOf9H = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9H").load();
        efmAvcPostLedger.setLedgerID(efmLedgerOf9H.getOID());
        efmAvcPostLedger.setFromFiscalYear(ERPDateUtil.getYear((Object)ERPDateUtil.getNowDate()));
        efmAvcPostLedger.setAVCStatus("F");
        this.save((AbstractBillEntity)fmAvcPostLedger);
        FM_CommitmentItemVariant itemVariant = (FM_CommitmentItemVariant)this.newBillEntity(FM_CommitmentItemVariant.class);
        itemVariant.setFinancialManagementAreaID(finManagementAreaOID);
        itemVariant.setUseCode("000");
        itemVariant.setName("000");
        itemVariant.setFiscalYear(0);
        this.save((AbstractBillEntity)itemVariant);
        FM_AllotParaFile allotParaFile = (FM_AllotParaFile)this.newBillEntity(FM_AllotParaFile.class);
        EFM_AllotParaFile efmAllotParaFile = allotParaFile.newEFM_AllotParaFile();
        efmAllotParaFile.setFinancialManagementAreaID(finManagementAreaOID);
        efmAllotParaFile.setLedgerID(efmLedgerOf9H.getOID());
        efmAllotParaFile.setFromFiscalYear(ERPDateUtil.getYear((Object)ERPDateUtil.getNowDate()));
        FM_ToleranceParaFile fmToleranceParaFile = FM_ToleranceParaFile.loader((RichDocumentContext)this.getMidContext()).Code("1000").load();
        efmAllotParaFile.setToleranceParaFileID(fmToleranceParaFile.getOID());
        this.save((AbstractBillEntity)allotParaFile);
    }

    public String getAllBudgetProcess() {
        BudgetProcessEnum[] processEnums;
        StringBuilder result = new StringBuilder();
        BudgetProcessEnum[] budgetProcessEnumArray = processEnums = BudgetProcessEnum.values();
        int n = processEnums.length;
        int n2 = 0;
        while (n2 < n) {
            BudgetProcessEnum processEnum = budgetProcessEnumArray[n2];
            result.append((Object)processEnum);
            ++n2;
        }
        return result.toString();
    }

    public String getBudgetProcessNotAll() {
        BudgetProcessEnum[] processEnums;
        StringBuilder result = new StringBuilder();
        BudgetProcessEnum[] budgetProcessEnumArray = processEnums = BudgetProcessEnum.values();
        int n = processEnums.length;
        int n2 = 0;
        while (n2 < n) {
            BudgetProcessEnum processEnum = budgetProcessEnumArray[n2];
            if (!processEnum.getKey().equals(BudgetProcessEnum.All.getKey())) {
                result.append((Object)processEnum);
            }
            ++n2;
        }
        return result.toString();
    }

    public String getBudgetProcessByBudgetTypeId(Long budgetTypeID, int flag) throws Throwable {
        if (budgetTypeID.equals(0L)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        FM_BudgetType fmBudgetType = FM_BudgetType.loader((RichDocumentContext)this.getMidContext()).OID(budgetTypeID).load();
        List efmBudgetTypeDtls = fmBudgetType.efm_budgetTypeDtls();
        if (efmBudgetTypeDtls == null || efmBudgetTypeDtls.isEmpty()) {
            return MessageFacade.getMsgContent((String)"FMAREAFORMULA001", (Object[])new Object[0]);
        }
        for (EFM_BudgetTypeDtl budgetTypeDtl : efmBudgetTypeDtls) {
            if (budgetTypeDtl.getProcessCode().equals(BudgetProcessEnum.All.getKey())) {
                if (flag == 1) {
                    result = new StringBuilder(this.getBudgetProcessNotAll());
                    break;
                }
                if (flag == 2) {
                    result = new StringBuilder(this.getAllBudgetProcess());
                    break;
                }
                return MessageFacade.getMsgContent((String)"FMAREAFORMULA002", (Object[])new Object[0]);
            }
            result.append(BudgetProcessEnum.getComboxByKey(budgetTypeDtl.getProcessCode()));
        }
        return result.toString();
    }

    public boolean checkCompanyCode(Long companyCodeID) throws Throwable {
        if (companyCodeID.compareTo(0L) <= 0) {
            return true;
        }
        List fmCommitVouchers = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).CompanyCodeID(companyCodeID).loadList();
        return fmCommitVouchers == null || fmCommitVouchers.size() == 0;
    }

    public void checkCurrencyIsConsistent(Long companyCodeID, Long FinancialManagementAreaID) throws Throwable {
        if (companyCodeID.compareTo(0L) > 0 && FinancialManagementAreaID.compareTo(0L) > 0) {
            EFI_Ledger mainLedger = EFI_Ledger.loader((RichDocumentContext)this.getMidContext()).IsLeadingLedger(1).load();
            EFI_LedgerDtl ledgerOfCompanyCode = EFI_LedgerDtl.loader((RichDocumentContext)this.getMidContext()).SOID(mainLedger.getOID()).CompanyCodeID(companyCodeID).load();
            EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.loader((RichDocumentContext)this.getMidContext()).OID(FinancialManagementAreaID).load();
            if (ledgerOfCompanyCode != null && finManagementArea != null) {
                Long finManagementAreaCurrencyID = finManagementArea.getCurrencyID();
                if (!(ledgerOfCompanyCode.getFirstCurrencyID().equals(finManagementAreaCurrencyID) || ledgerOfCompanyCode.getSecondCurrencyID().equals(finManagementAreaCurrencyID) || ledgerOfCompanyCode.getThirdCurrencyID().equals(finManagementAreaCurrencyID))) {
                    MessageFacade.throwException((String)"FMAREAFORMULA003");
                }
            }
        }
    }

    public void checkBudgetType() throws Throwable {
        FM_BudgetType fmBudgetType = FM_BudgetType.parseDocument((RichDocument)this.getDocument());
        this.checkManagementPlanOfR1(fmBudgetType);
        this.checkProcess(fmBudgetType);
    }

    private void checkProcess(FM_BudgetType fmBudgetType) throws Throwable {
        List efmBudgetTypeDtls = fmBudgetType.efm_budgetTypeDtls();
        for (EFM_BudgetTypeDtl budgetTypeDtl : efmBudgetTypeDtls) {
            if (!budgetTypeDtl.getProcessCode().equals(BudgetProcessEnum.All.getKey()) || efmBudgetTypeDtls.size() <= 1) continue;
            for (EFM_BudgetTypeDtl typeDtl : efmBudgetTypeDtls) {
                fmBudgetType.deleteEFM_BudgetTypeDtl(typeDtl);
            }
            EFM_BudgetTypeDtl efmBudgetTypeDtl = fmBudgetType.newEFM_BudgetTypeDtl();
            efmBudgetTypeDtl.setBCSValType(fmBudgetType.getBCSValType());
            efmBudgetTypeDtl.setFinancialManagementAreaID(fmBudgetType.getFinancialManagementAreaID());
            efmBudgetTypeDtl.setProcessCode(BudgetProcessEnum.All.getKey());
            break;
        }
    }

    private void checkManagementPlanOfR1(FM_BudgetType fmBudgetType) throws Throwable {
        String bcsValType = fmBudgetType.getBCSValType();
        if ("R1".equals(bcsValType)) {
            Long fmAreaID = fmBudgetType.getFinancialManagementAreaID();
            EFM_FinancialManagementArea efmFinManagementArea = EFM_FinancialManagementArea.loader((RichDocumentContext)this.getMidContext()).OID(fmAreaID).load();
            if (efmFinManagementArea == null) {
                MessageFacade.throwException((String)"FMAREAFORMULA004", (Object[])new Object[]{fmBudgetType.efm_budgetTypeHead().getFinancialManagementAreaCode(), fmBudgetType.efm_budgetTypeHead().getFinancialManagementArea().getName()});
                throw new ERPException(this.getEnv(), "\u8d22\u52a1\u7ba1\u7406\u8303\u56f4{1} {2}\u4e0d\u5b58\u5728", new Object[]{fmBudgetType.efm_budgetTypeHead().getFinancialManagementAreaCode(), fmBudgetType.efm_budgetTypeHead().getFinancialManagementArea().getName()});
            }
            String managementPlan = efmFinManagementArea.getManagementPlan();
            if (StringUtil.isBlankOrNull((String)managementPlan)) {
                MessageFacade.throwException((String)"FMAREAFORMULA005", (Object[])new Object[]{fmBudgetType.efm_budgetTypeHead().getFinancialManagementAreaCode(), fmBudgetType.efm_budgetTypeHead().getFinancialManagementArea().getName()});
            }
        }
    }

    public void checkDocumentType() throws Throwable {
        FM_DocumentType fmDocumentType = FM_DocumentType.parseDocument((RichDocument)this.getDocument());
        List efmDocumentTypeDtls = fmDocumentType.efm_documentTypeDtls();
        if (fmDocumentType.getValueTypeScheme().equals("A1")) {
            for (EFM_DocumentTypeDtl documentTypeDtl : efmDocumentTypeDtls) {
                if (!documentTypeDtl.getProcessCode().equals(BudgetProcessEnum.All.getKey()) || efmDocumentTypeDtls.size() <= 1) continue;
                for (EFM_DocumentTypeDtl typeDtl : efmDocumentTypeDtls) {
                    fmDocumentType.deleteEFM_DocumentTypeDtl(typeDtl);
                }
                EFM_DocumentTypeDtl efmDocumentTypeDtl = fmDocumentType.newEFM_DocumentTypeDtl();
                efmDocumentTypeDtl.setProcessCode(BudgetProcessEnum.All.getKey());
                break;
            }
        } else {
            for (EFM_DocumentTypeDtl documentTypeDtl : efmDocumentTypeDtls) {
                fmDocumentType.deleteEFM_DocumentTypeDtl(documentTypeDtl);
            }
        }
    }

    public void checkBudgetStatus() throws Throwable {
        FM_BudgetStatus budgetStatus = FM_BudgetStatus.parseEntity((RichDocumentContext)this.getMidContext());
        boolean deleteFlag = false;
        Long budgetLedger = 0L;
        String bcsValType = "";
        Long budgetType = 0L;
        List efmScBudgetSettings = budgetStatus.efm_sCBudgetSettingss();
        for (EFM_SCBudgetSettings scBudgetSettings : efmScBudgetSettings) {
            if (!scBudgetSettings.getBudgetProcess().equals(BudgetProcessEnum.All.getKey()) || efmScBudgetSettings.size() <= 1) continue;
            budgetLedger = scBudgetSettings.getBudgetLedgerID();
            bcsValType = scBudgetSettings.getBCSValType();
            budgetType = scBudgetSettings.getBudgetTypeID();
            deleteFlag = true;
        }
        if (deleteFlag) {
            EFM_SCBudgetSettings budgetSettings2;
            for (EFM_SCBudgetSettings budgetSettings2 : efmScBudgetSettings) {
                if (!budgetLedger.equals(budgetSettings2.getBudgetLedgerID()) || !budgetType.equals(budgetSettings2.getBudgetTypeID())) continue;
                budgetStatus.deleteEFM_SCBudgetSettings(budgetSettings2);
            }
            budgetSettings2 = budgetStatus.newEFM_SCBudgetSettings();
            budgetSettings2.setBCSValType(bcsValType);
            budgetSettings2.setBudgetLedgerID(budgetLedger);
            budgetSettings2.setBudgetProcess(BudgetProcessEnum.All.getKey());
            budgetSettings2.setBudgetTypeID(budgetType);
        }
        deleteFlag = false;
        List efmScApprovalSettings = budgetStatus.efm_sCApprovalSettingss();
        for (EFM_SCApprovalSettings scApprovalSetting : efmScApprovalSettings) {
            if (!scApprovalSetting.getBudgetProcess().equals(BudgetProcessEnum.All.getKey()) || efmScApprovalSettings.size() <= 1) continue;
            budgetLedger = scApprovalSetting.getBudgetLedgerID();
            bcsValType = scApprovalSetting.getBCSValType();
            budgetType = scApprovalSetting.getBudgetTypeID();
            deleteFlag = true;
        }
        if (deleteFlag) {
            for (EFM_SCApprovalSettings approvalSetting : efmScApprovalSettings) {
                if (!budgetLedger.equals(approvalSetting.getBudgetLedgerID()) || !budgetType.equals(approvalSetting.getBudgetTypeID())) continue;
                budgetStatus.deleteEFM_SCApprovalSettings(approvalSetting);
            }
            EFM_SCApprovalSettings approvalSettings = budgetStatus.newEFM_SCApprovalSettings();
            approvalSettings.setBCSValType(bcsValType);
            approvalSettings.setBudgetLedgerID(budgetLedger);
            approvalSettings.setBudgetProcess(BudgetProcessEnum.All.getKey());
            approvalSettings.setBudgetTypeID(budgetType);
        }
    }

    public Long getFMAreaByCompanyCode(Long companyCodeID) throws Throwable {
        if (companyCodeID.compareTo(0L) <= 0) {
            return 0L;
        }
        EFM_FMAreaToCompanyCode fmAreaToCompanyCode = EFM_FMAreaToCompanyCode.loader((RichDocumentContext)this.getMidContext()).CompanyCodeID(companyCodeID).load();
        if (fmAreaToCompanyCode == null) {
            return 0L;
        }
        return fmAreaToCompanyCode.getFinancialManagementAreaID();
    }

    public void checkBudgetTypeOfR1IsUnique() throws Throwable {
        EFM_BudgetTypeHead efmBudgetTypeResult;
        FM_BudgetType fmBudgetType = FM_BudgetType.parseDocument((RichDocument)this.getDocument());
        EFM_BudgetTypeHead efmBudgetType = fmBudgetType.efm_budgetTypeHead();
        if ("R1".equals(efmBudgetType.getBCSValType()) && (efmBudgetTypeResult = EFM_BudgetTypeHead.loader((RichDocumentContext)this.getMidContext()).BCSValType("R1").FinancialManagementAreaID(efmBudgetType.getFinancialManagementAreaID()).IsUnqualifiedType(efmBudgetType.getIsUnqualifiedType()).load()) != null && !efmBudgetType.getOID().equals(efmBudgetTypeResult.getOID())) {
            MessageFacade.throwException((String)"FMAREAFORMULA006", (Object[])new Object[]{efmBudgetType.getFinancialManagementArea().getName()});
        }
    }

    public String getReferFormKey(String referDocType) {
        ReferDocTypeEnum[] values;
        ReferDocTypeEnum[] referDocTypeEnumArray = values = ReferDocTypeEnum.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ReferDocTypeEnum referDocTypeEnum = referDocTypeEnumArray[n2];
            if (referDocTypeEnum.getKey().equals(referDocType)) {
                return referDocTypeEnum.getFormKey();
            }
            ++n2;
        }
        return "";
    }
}

