/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.earmarkfund;

import com.bokesoft.erp.billentity.BusinessTransaction;
import com.bokesoft.erp.billentity.EFI_VoucherDtl_Entry;
import com.bokesoft.erp.billentity.EFM_EFGlobalSetting;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherHead;
import com.bokesoft.erp.billentity.EFM_ManualReduction;
import com.bokesoft.erp.billentity.EFM_ValueAdjustment;
import com.bokesoft.erp.billentity.EMM_PO_AccountAssignDtl;
import com.bokesoft.erp.billentity.EMM_PO_LimitAssignDtl;
import com.bokesoft.erp.billentity.EMM_PO_ServicesDtl_AssignDtl;
import com.bokesoft.erp.billentity.EMM_PR_AccountAssignDtl;
import com.bokesoft.erp.billentity.EMM_PR_LimitAssignDtl;
import com.bokesoft.erp.billentity.EMM_PR_ServicesDtl_AssignDtl;
import com.bokesoft.erp.billentity.FI_Voucher;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_EarmarkedFundVoucher;
import com.bokesoft.erp.billentity.FM_ManualReduction;
import com.bokesoft.erp.billentity.FM_ValueAdjustment;
import com.bokesoft.erp.billentity.MM_PurchaseOrder;
import com.bokesoft.erp.billentity.MM_PurchaseRequisition;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.math.BigDecimal;
import java.util.List;

public class EarmarkedFundFormula
extends EntityContextAction {
    public EarmarkedFundFormula(RichDocumentContext _context) {
        super(_context);
    }

    private Long getItemBusinessTransactionID(int voucherCategory) throws Throwable {
        Long itemBusinessTransactionID = null;
        if (voucherCategory == Integer.parseInt("2")) {
            BusinessTransaction progress_KBLZ = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KBLZ").load();
            itemBusinessTransactionID = progress_KBLZ.getOID();
        } else if (voucherCategory == Integer.parseInt("20")) {
            BusinessTransaction progress_KBLO = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KBLO").load();
            itemBusinessTransactionID = progress_KBLO.getOID();
        } else if (voucherCategory == Integer.parseInt("30")) {
            BusinessTransaction progress_KRES = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KRES").load();
            itemBusinessTransactionID = progress_KRES.getOID();
        } else if (voucherCategory == Integer.parseInt("40")) {
            BusinessTransaction progress_KPRE = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KPRE").load();
            itemBusinessTransactionID = progress_KPRE.getOID();
        } else if (voucherCategory == Integer.parseInt("50")) {
            BusinessTransaction progress_KCOM = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KCOM").load();
            itemBusinessTransactionID = progress_KCOM.getOID();
        } else if (voucherCategory == Integer.parseInt("60")) {
            BusinessTransaction progress_KFOR = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KFOR").load();
            itemBusinessTransactionID = progress_KFOR.getOID();
        }
        return itemBusinessTransactionID;
    }

    public void checkBeforeSave() throws Throwable {
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.parseDocument((RichDocument)this.getDocument());
        EFM_EarmarkedFundVoucherHead earmarkedFundVoucherHead = earmarkedFundVoucher.efm_earmarkedFundVoucherHead();
        List earmarkedFundVoucherDtls = earmarkedFundVoucher.efm_earmarkedFundVoucherDtls();
        earmarkedFundVoucherHead.setBusinessTransactionID(this.getItemBusinessTransactionID(earmarkedFundVoucher.getVoucherCategory()));
        earmarkedFundVoucherHead.setExchangeRateDate(earmarkedFundVoucherHead.getPostingDate());
        EFM_EFGlobalSetting efGlobalSetting = EFM_EFGlobalSetting.loader((RichDocumentContext)this.getMidContext()).load();
        if (efGlobalSetting != null && efGlobalSetting.getIsRequiredValueAdjustment() == 1) {
            earmarkedFundVoucherHead.setIsRequiredValueAdjustment(1);
        }
        int voucherCategory = earmarkedFundVoucherHead.getVoucherCategory();
        BigDecimal voucherTotalAmount = BigDecimal.ZERO;
        BigDecimal recipientAmont = BigDecimal.ZERO;
        BigDecimal sendAmont = BigDecimal.ZERO;
        for (EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl : earmarkedFundVoucherDtls) {
            EFM_EarmarkedFundVoucherDtl voucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtl.getOID()).load();
            if (voucherCategory == Integer.parseInt("2")) {
                BigDecimal totalAmount = earmarkedFundVoucherDtl.getTotalMoney();
                if (earmarkedFundVoucherDtl.getIsSender() == 1) {
                    sendAmont = sendAmont.add(totalAmount);
                    voucherTotalAmount = voucherTotalAmount.add(totalAmount);
                    continue;
                }
                recipientAmont = recipientAmont.add(totalAmount);
                continue;
            }
            BigDecimal originalAmount = earmarkedFundVoucherDtl.getOriginalMoney();
            if (voucherDtl == null) {
                earmarkedFundVoucherDtl.setUnclearMoney(originalAmount);
            } else {
                BigDecimal oldUnClearMoney = voucherDtl.getUnclearMoney();
                BigDecimal diffAmount = BigDecimal.ZERO;
                if (oldUnClearMoney.compareTo(BigDecimal.ZERO) == 0) {
                    diffAmount = originalAmount.subtract(voucherDtl.getReducedMoney());
                    if (diffAmount.compareTo(BigDecimal.ZERO) < 0) {
                        diffAmount = BigDecimal.ZERO;
                    }
                } else if (oldUnClearMoney.compareTo(BigDecimal.ZERO) != 0) {
                    diffAmount = originalAmount.subtract(voucherDtl.getOriginalMoney());
                    if (originalAmount.abs().compareTo(voucherDtl.getReducedMoney()) < 0) {
                        diffAmount = oldUnClearMoney.negate();
                    }
                }
                if (earmarkedFundVoucherDtl.getIsProjectCompleted() == 0) {
                    earmarkedFundVoucherDtl.setUnclearMoney(oldUnClearMoney.add(diffAmount));
                }
            }
            earmarkedFundVoucherDtl.setTotalMoney(originalAmount);
            voucherTotalAmount = voucherTotalAmount.add(originalAmount);
        }
        if (sendAmont.compareTo(recipientAmont) != 0) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA001", (Object[])new Object[]{recipientAmont.subtract(sendAmont) + earmarkedFundVoucherHead.getCurrencyCode()});
        }
        earmarkedFundVoucherHead.setVoucherTotalMoney(voucherTotalAmount);
    }

    public Boolean checkGlobalSetting() throws Throwable {
        EFM_EFGlobalSetting efGlobalSetting = EFM_EFGlobalSetting.loader((RichDocumentContext)this.getMidContext()).load();
        if (efGlobalSetting != null && efGlobalSetting.getIsRequiredValueAdjustment() == 1) {
            return true;
        }
        return false;
    }

    public Boolean checkRequiredValueAdjustment(String dtlDocumentNumber) throws Throwable {
        if ("".equals(dtlDocumentNumber)) {
            return true;
        }
        EFM_EarmarkedFundVoucherDtl efmEarmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).DetailNumber(dtlDocumentNumber).load();
        if (efmEarmarkedFundVoucherDtl == null) {
            return true;
        }
        if (efmEarmarkedFundVoucherDtl.getIsRequiredValueAdjustment() != 1) {
            return true;
        }
        return false;
    }

    public Boolean haveFollowVoucher() throws Throwable {
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.parseDocument((RichDocument)this.getDocument());
        List earmarkedFundVoucherDtls = earmarkedFundVoucher.efm_earmarkedFundVoucherDtls();
        List efmEarmarkedFundVoucherDtl = null;
        for (EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl : earmarkedFundVoucherDtls) {
            if (earmarkedFundVoucher.getVoucherCategory() == Integer.parseInt("30")) {
                efmEarmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FundsReservationSOID(earmarkedFundVoucherDtl.getSOID()).loadList();
            } else if (earmarkedFundVoucher.getVoucherCategory() == Integer.parseInt("40")) {
                efmEarmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FundsPrecommitmentSOID(earmarkedFundVoucherDtl.getSOID()).loadList();
            }
            if (earmarkedFundVoucherDtl.getReducedMoney().compareTo(BigDecimal.ZERO) != 0) {
                return false;
            }
            if (efmEarmarkedFundVoucherDtl == null) continue;
            return false;
        }
        return true;
    }

    public Long getSOIDByReferDocument() throws Throwable {
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.parseDocument((RichDocument)this.getDocument());
        List earmarkedFundVoucherDtls = earmarkedFundVoucher.efm_earmarkedFundVoucherDtls("SelectField", (Object)1);
        if (earmarkedFundVoucherDtls == null || earmarkedFundVoucherDtls.isEmpty()) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA002");
        }
        EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = (EFM_EarmarkedFundVoucherDtl)earmarkedFundVoucherDtls.get(0);
        FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).Dtl_ReferDocSOID(earmarkedFundVoucher.getOID()).Dtl_ReferItemOID(earmarkedFundVoucherDtl.getOID()).load();
        if (fmCommitVoucher == null || fmCommitVoucher.efm_commitVoucherHead() == null) {
            return 0L;
        }
        return fmCommitVoucher.efm_commitVoucherHead().getSOID();
    }

    public void checkIsRequiredValueAdjustment(Long oid, Long dtlOID) throws Throwable {
        EFM_EarmarkedFundVoucherHead earmarkedFundVoucherHead = EFM_EarmarkedFundVoucherHead.loader((RichDocumentContext)this.getMidContext()).OID(oid).load();
        EFM_EarmarkedFundVoucherDtl voucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(dtlOID).load();
        if (earmarkedFundVoucherHead == null || voucherDtl == null) {
            return;
        }
        if (voucherDtl.getIsRequiredValueAdjustment() == 0) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA003", (Object[])new Object[]{voucherDtl.getDetailNumber()});
        }
        if (voucherDtl.getIsProjectCompleted() == 1) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA004", (Object[])new Object[]{voucherDtl.getDetailNumber()});
        }
    }

    public void checkIsCompletedOrFreezed(Long oid, Long dtlOID) throws Throwable {
        EFM_EarmarkedFundVoucherHead earmarkedFundVoucherHead = EFM_EarmarkedFundVoucherHead.loader((RichDocumentContext)this.getMidContext()).OID(oid).load();
        EFM_EarmarkedFundVoucherDtl voucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(dtlOID).load();
        if (earmarkedFundVoucherHead == null || voucherDtl == null) {
            return;
        }
        if (voucherDtl.getIsProjectCompleted() == 1) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA005", (Object[])new Object[]{voucherDtl.getDetailNumber()});
        }
        if (voucherDtl.getIsProjectFreezed() == 1) {
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA006", (Object[])new Object[]{voucherDtl.getDetailNumber()});
        }
    }

    public Boolean setValueAdjustVisible(String type) throws Throwable {
        Integer isAddValue = TypeConvertor.toInteger((Object)this.getMidContext().getParentDocument().getContext().getPara("VA_IsAddValue"));
        Long valueAdjustmentVoucherID = TypeConvertor.toLong((Object)this.getMidContext().getParentDocument().getContext().getPara("VA_OID"));
        EFM_ValueAdjustment valueAdjustmentVoucher = null;
        if (valueAdjustmentVoucherID != 0L) {
            valueAdjustmentVoucher = EFM_ValueAdjustment.loader((RichDocumentContext)this.getMidContext()).OID(valueAdjustmentVoucherID).load();
        }
        if (type.equals("IsAddValue")) {
            if (isAddValue != 1 && (valueAdjustmentVoucher != null ? valueAdjustmentVoucher.getIsAddValue() : 0) != 1) {
                return false;
            }
            return true;
        }
        if (type.equals("IsReduceValue")) {
            if (isAddValue != 2 && (valueAdjustmentVoucher != null ? valueAdjustmentVoucher.getIsReduceValue() : 0) != 1) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void setFIAccountAssignment4EarFund(Long billDtlID) throws Throwable {
        FI_Voucher fiVoucher = FI_Voucher.parseDocument((RichDocument)this.getDocument());
        EFI_VoucherDtl_Entry voucherDtlEntry = fiVoucher.efi_voucherDtl_Entry(billDtlID);
        if (voucherDtlEntry == null) {
            return;
        }
        Long earmarkedFundVoucherID = voucherDtlEntry.getEarmarkedFundVoucherSOID();
        Long earmarkedFundVoucherDtlID = voucherDtlEntry.getEarmarkedFundVoucherDtlOID();
        if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) {
            return;
        }
        EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
        if (earmarkedFundVoucherDtl != null) {
            voucherDtlEntry.setCommitmentItemID(earmarkedFundVoucherDtl.getCommitmentItemID());
            voucherDtlEntry.setFundCenterID(earmarkedFundVoucherDtl.getFundCenterID());
            voucherDtlEntry.setFundID(earmarkedFundVoucherDtl.getFundID());
            voucherDtlEntry.setFunctionalAreaID(earmarkedFundVoucherDtl.getFunctionalAreaID());
        }
    }

    public void setPRAccountAssignment4EarFund(Long assignDtlOID, String type) throws Throwable {
        MM_PurchaseRequisition purchaseRequisition = MM_PurchaseRequisition.parseDocument((RichDocument)this.getDocument());
        switch (type) {
            case "AccountAssignment": {
                EMM_PR_AccountAssignDtl accountAssignDtl = purchaseRequisition.emm_pR_AccountAssignDtl(assignDtlOID);
                if (accountAssignDtl == null) {
                    return;
                }
                Long earmarkedFundVoucherID = accountAssignDtl.getEarmarkedFundVoucherSOID();
                Long earmarkedFundVoucherDtlID = accountAssignDtl.getEarmarkedFundVoucherDtlOID();
                if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) {
                    return;
                }
                EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
                if (earmarkedFundVoucherDtl == null) break;
                accountAssignDtl.setCommitmentItemID(earmarkedFundVoucherDtl.getCommitmentItemID());
                accountAssignDtl.setFundCenterID(earmarkedFundVoucherDtl.getFundCenterID());
                accountAssignDtl.setFundID(earmarkedFundVoucherDtl.getFundID());
                accountAssignDtl.setFunctionalAreaID(earmarkedFundVoucherDtl.getFunctionalAreaID());
                break;
            }
            case "ServicesAssignment": {
                EMM_PR_ServicesDtl_AssignDtl servicesAssignDtl = purchaseRequisition.emm_pR_ServicesDtl_AssignDtl(assignDtlOID);
                if (servicesAssignDtl == null) {
                    return;
                }
                Long earmarkedFundVoucherID = servicesAssignDtl.getEarmarkedFundVoucherSOID();
                Long earmarkedFundVoucherDtlID = servicesAssignDtl.getEarmarkedFundVoucherDtlOID();
                if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) {
                    return;
                }
                EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
                if (earmarkedFundVoucherDtl == null) break;
                servicesAssignDtl.setCommitmentItemID(earmarkedFundVoucherDtl.getCommitmentItemID());
                servicesAssignDtl.setFundCenterID(earmarkedFundVoucherDtl.getFundCenterID());
                servicesAssignDtl.setFundID(earmarkedFundVoucherDtl.getFundID());
                servicesAssignDtl.setFunctionalAreaID(earmarkedFundVoucherDtl.getFunctionalAreaID());
                break;
            }
            case "LimitAssignment": {
                EMM_PR_LimitAssignDtl limitAssignDtl = purchaseRequisition.emm_pR_LimitAssignDtl(assignDtlOID);
                if (limitAssignDtl == null) {
                    return;
                }
                Long earmarkedFundVoucherID = limitAssignDtl.getEarmarkedFundVoucherSOID();
                Long earmarkedFundVoucherDtlID = limitAssignDtl.getEarmarkedFundVoucherDtlOID();
                if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) {
                    return;
                }
                EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
                if (earmarkedFundVoucherDtl == null) break;
                limitAssignDtl.setCommitmentItemID(earmarkedFundVoucherDtl.getCommitmentItemID());
                limitAssignDtl.setFundCenterID(earmarkedFundVoucherDtl.getFundCenterID());
                limitAssignDtl.setFundID(earmarkedFundVoucherDtl.getFundID());
                limitAssignDtl.setFunctionalAreaID(earmarkedFundVoucherDtl.getFunctionalAreaID());
            }
        }
    }

    public void setPOAccountAssignment4EarFund(Long assignDtlOID, String type) throws Throwable {
        MM_PurchaseOrder purchaseOrder = MM_PurchaseOrder.parseDocument((RichDocument)this.getDocument());
        switch (type) {
            case "AccountAssignment": {
                EMM_PO_AccountAssignDtl accountAssignDtl = purchaseOrder.emm_pO_AccountAssignDtl(assignDtlOID);
                if (accountAssignDtl == null) {
                    return;
                }
                Long earmarkedFundVoucherID = accountAssignDtl.getEarmarkedFundVoucherSOID();
                Long earmarkedFundVoucherDtlID = accountAssignDtl.getEarmarkedFundVoucherDtlOID();
                if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) {
                    return;
                }
                EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
                if (earmarkedFundVoucherDtl == null) break;
                accountAssignDtl.setCommitmentItemID(earmarkedFundVoucherDtl.getCommitmentItemID());
                accountAssignDtl.setFundCenterID(earmarkedFundVoucherDtl.getFundCenterID());
                accountAssignDtl.setFundID(earmarkedFundVoucherDtl.getFundID());
                accountAssignDtl.setFunctionalAreaID(earmarkedFundVoucherDtl.getFunctionalAreaID());
                break;
            }
            case "ServicesAssignment": {
                EMM_PO_ServicesDtl_AssignDtl servicesAssignDtl = purchaseOrder.emm_pO_ServicesDtl_AssignDtl(assignDtlOID);
                if (servicesAssignDtl == null) {
                    return;
                }
                Long earmarkedFundVoucherID = servicesAssignDtl.getEarmarkedFundVoucherSOID();
                Long earmarkedFundVoucherDtlID = servicesAssignDtl.getEarmarkedFundVoucherDtlOID();
                if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) {
                    return;
                }
                EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
                if (earmarkedFundVoucherDtl == null) break;
                servicesAssignDtl.setCommitmentItemID(earmarkedFundVoucherDtl.getCommitmentItemID());
                servicesAssignDtl.setFundCenterID(earmarkedFundVoucherDtl.getFundCenterID());
                servicesAssignDtl.setFundID(earmarkedFundVoucherDtl.getFundID());
                servicesAssignDtl.setFunctionalAreaID(earmarkedFundVoucherDtl.getFunctionalAreaID());
                break;
            }
            case "LimitAssignment": {
                EMM_PO_LimitAssignDtl limitAssignDtl = purchaseOrder.emm_pO_LimitAssignDtl(assignDtlOID);
                if (limitAssignDtl == null) {
                    return;
                }
                Long earmarkedFundVoucherID = limitAssignDtl.getEarmarkedFundVoucherSOID();
                Long earmarkedFundVoucherDtlID = limitAssignDtl.getEarmarkedFundVoucherDtlOID();
                if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) {
                    return;
                }
                EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
                if (earmarkedFundVoucherDtl == null) break;
                limitAssignDtl.setCommitmentItemID(earmarkedFundVoucherDtl.getCommitmentItemID());
                limitAssignDtl.setFundCenterID(earmarkedFundVoucherDtl.getFundCenterID());
                limitAssignDtl.setFundID(earmarkedFundVoucherDtl.getFundID());
                limitAssignDtl.setFunctionalAreaID(earmarkedFundVoucherDtl.getFunctionalAreaID());
            }
        }
    }

    public void checkIsChangeAccountAssignFromFI() throws Throwable {
        FI_Voucher fiVoucher = FI_Voucher.parseDocument((RichDocument)this.getDocument());
        AddressUtils addressUtils = new AddressUtils(this.getMidContext());
        List voucherDtlEntries = fiVoucher.efi_voucherDtl_Entrys();
        for (EFI_VoucherDtl_Entry voucherDtlEntry : voucherDtlEntries) {
            int isAccountAssign;
            String efPostAddress;
            Long earmarkedFundVoucherID = voucherDtlEntry.getEarmarkedFundVoucherSOID();
            Long earmarkedFundVoucherDtlID = voucherDtlEntry.getEarmarkedFundVoucherDtlOID();
            if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) continue;
            String fiPostAddress = addressUtils.genAddress(voucherDtlEntry.getFundID(), voucherDtlEntry.getFundCenterID(), voucherDtlEntry.getCommitmentItemID(), voucherDtlEntry.getFunctionalAreaID(), 0L);
            EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
            if (earmarkedFundVoucherDtl == null || fiPostAddress.equals(efPostAddress = addressUtils.genAddress(earmarkedFundVoucherDtl.getFundID(), earmarkedFundVoucherDtl.getFundCenterID(), earmarkedFundVoucherDtl.getCommitmentItemID(), earmarkedFundVoucherDtl.getFunctionalAreaID(), 0L)) || (isAccountAssign = earmarkedFundVoucherDtl.getIsChangeAccountAssign()) != 0) continue;
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA007", (Object[])new Object[]{earmarkedFundVoucherDtl.getDetailNumber()});
        }
    }

    public void checkIsChangeAccountAssignFromPR() throws Throwable {
        MM_PurchaseRequisition purchaseRequisition = MM_PurchaseRequisition.parseDocument((RichDocument)this.getDocument());
        AddressUtils addressUtils = new AddressUtils(this.getMidContext());
        List prAccountAssignDtls = purchaseRequisition.emm_pR_AccountAssignDtls("SOID", (Object)purchaseRequisition.getOID());
        if (prAccountAssignDtls == null) {
            return;
        }
        for (EMM_PR_AccountAssignDtl accountAssignDtl : prAccountAssignDtls) {
            int isAccountAssign;
            String efPostAddress;
            Long earmarkedFundVoucherID = accountAssignDtl.getEarmarkedFundVoucherSOID();
            Long earmarkedFundVoucherDtlID = accountAssignDtl.getEarmarkedFundVoucherDtlOID();
            if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) continue;
            String prPostAddress = addressUtils.genAddress(accountAssignDtl.getFundID(), accountAssignDtl.getFundCenterID(), accountAssignDtl.getCommitmentItemID(), accountAssignDtl.getFunctionalAreaID(), 0L);
            EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
            if (earmarkedFundVoucherDtl == null || prPostAddress.equals(efPostAddress = addressUtils.genAddress(earmarkedFundVoucherDtl.getFundID(), earmarkedFundVoucherDtl.getFundCenterID(), earmarkedFundVoucherDtl.getCommitmentItemID(), earmarkedFundVoucherDtl.getFunctionalAreaID(), 0L)) || (isAccountAssign = earmarkedFundVoucherDtl.getIsChangeAccountAssign()) != 0) continue;
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA007", (Object[])new Object[]{earmarkedFundVoucherDtl.getDetailNumber()});
        }
    }

    public void checkIsChangeAccountAssignFromPO() throws Throwable {
        MM_PurchaseOrder purchaseOrder = MM_PurchaseOrder.parseDocument((RichDocument)this.getDocument());
        AddressUtils addressUtils = new AddressUtils(this.getMidContext());
        List poAccountAssignDtls = purchaseOrder.emm_pO_AccountAssignDtls("SOID", (Object)purchaseOrder.getOID());
        if (poAccountAssignDtls == null) {
            return;
        }
        for (EMM_PO_AccountAssignDtl accountAssignDtl : poAccountAssignDtls) {
            int isAccountAssign;
            String efPostAddress;
            Long earmarkedFundVoucherID = accountAssignDtl.getEarmarkedFundVoucherSOID();
            Long earmarkedFundVoucherDtlID = accountAssignDtl.getEarmarkedFundVoucherDtlOID();
            if (earmarkedFundVoucherID == 0L || earmarkedFundVoucherDtlID == 0L) continue;
            if (this.getDocument().isNew()) {
                accountAssignDtl.setIsRealNew(1);
            } else {
                accountAssignDtl.setIsRealNew(0);
            }
            String poPostAddress = addressUtils.genAddress(accountAssignDtl.getFundID(), accountAssignDtl.getFundCenterID(), accountAssignDtl.getCommitmentItemID(), accountAssignDtl.getFunctionalAreaID(), 0L);
            EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
            if (earmarkedFundVoucherDtl == null || poPostAddress.equals(efPostAddress = addressUtils.genAddress(earmarkedFundVoucherDtl.getFundID(), earmarkedFundVoucherDtl.getFundCenterID(), earmarkedFundVoucherDtl.getCommitmentItemID(), earmarkedFundVoucherDtl.getFunctionalAreaID(), 0L)) || (isAccountAssign = earmarkedFundVoucherDtl.getIsChangeAccountAssign()) != 0) continue;
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA007", (Object[])new Object[]{earmarkedFundVoucherDtl.getDetailNumber()});
        }
    }

    public void isNagetiveValiueAllowed4EarFund() throws Throwable {
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.parseDocument((RichDocument)this.getDocument());
        List earmarkedFundVoucherDtls = earmarkedFundVoucher.efm_earmarkedFundVoucherDtls();
        int isNagetiveValiueAllowed = earmarkedFundVoucher.getIsNagetiveValiueAllowed();
        for (EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl : earmarkedFundVoucherDtls) {
            if (earmarkedFundVoucherDtl.getOriginalMoney().compareTo(BigDecimal.ZERO) < 0 && isNagetiveValiueAllowed == 0) {
                MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA008");
            }
            if (earmarkedFundVoucherDtl.getOriginalMoney().compareTo(BigDecimal.ZERO) <= 0 || isNagetiveValiueAllowed <= 0) continue;
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA009");
        }
    }

    public void isNagetiveValiueAllowed4ValueAdjust() throws Throwable {
        FM_ValueAdjustment fmValueAdjustment = FM_ValueAdjustment.parseDocument((RichDocument)this.getDocument());
        List efm_valueAdjustments = fmValueAdjustment.efm_valueAdjustments("SOID", (Object)fmValueAdjustment.getOID());
        int isNagetiveValiueAllowed = fmValueAdjustment.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed();
        for (EFM_ValueAdjustment valueAdjustment : efm_valueAdjustments) {
            if (valueAdjustment.getValueAdjustMoney().compareTo(BigDecimal.ZERO) < 0 && isNagetiveValiueAllowed == 0) {
                MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA008");
            }
            if (valueAdjustment.getValueAdjustMoney().compareTo(BigDecimal.ZERO) <= 0 || isNagetiveValiueAllowed <= 0) continue;
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA009");
        }
    }

    public void isNagetiveValiueAllowed4ManualReduction() throws Throwable {
        FM_ManualReduction fmManualReduction = FM_ManualReduction.parseDocument((RichDocument)this.getDocument());
        List manualReductions = fmManualReduction.efm_manualReductions("SOID", (Object)fmManualReduction.getOID());
        int isNagetiveValiueAllowed = fmManualReduction.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed();
        for (EFM_ManualReduction manualReduction : manualReductions) {
            if (manualReduction.getReducedMoney().compareTo(BigDecimal.ZERO) < 0 && isNagetiveValiueAllowed == 0) {
                MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA008");
            }
            if (manualReduction.getReducedMoney().compareTo(BigDecimal.ZERO) <= 0 || isNagetiveValiueAllowed <= 0) continue;
            MessageFacade.throwException((String)"EARMARKEDFUNDFORMULA009");
        }
    }
}

