/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.earmarkfund;

import com.bokesoft.erp.basis.date.PeriodFormula;
import com.bokesoft.erp.billentity.BusinessTransaction;
import com.bokesoft.erp.billentity.ECO_Version;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_CoverUpdateProfile;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherHead;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherType;
import com.bokesoft.erp.billentity.EFM_FMAreaToCompanyCode;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Fund;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_ManualReduction;
import com.bokesoft.erp.billentity.EFM_PostLedgerPeriod;
import com.bokesoft.erp.billentity.EFM_ToleranceControl;
import com.bokesoft.erp.billentity.EFM_UpdateProfileDtl;
import com.bokesoft.erp.billentity.EFM_UpdateProfileHead;
import com.bokesoft.erp.billentity.EFM_ValueAdjustment;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_EarmarkedFundVoucher;
import com.bokesoft.erp.billentity.FM_Ledger;
import com.bokesoft.erp.billentity.FM_ManualReduction;
import com.bokesoft.erp.billentity.FM_ValueAdjustment;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.FMComboxConstant;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.enums.AmountTypeEnum;
import com.bokesoft.erp.fm.enums.FYCStatusEnum;
import com.bokesoft.erp.fm.enums.ReferDocTypeEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EFCommitVoucherFormula
extends EntityContextAction {
    private String postAddress = "";
    private Long versionID = 0L;
    private final AddressUtils addressUtils = new AddressUtils(this.getMidContext());
    private HashMap<Long, FM_CommitVoucher> accountVoucher = new HashMap();
    private int updateProfileTimes = 0;
    private BigDecimal fmacAmount = BigDecimal.ZERO;
    private Long fmAreaID;
    private int isPeriodOrYear;
    private Long companyCodeID;
    String valueType;
    private int voucherCategory;
    private int isAddValue = -1;
    private boolean isStatisticsUpdate;
    private int paymentBudgetValue = 0;
    private int commitBudgetValue = 0;

    public EFCommitVoucherFormula(RichDocumentContext _context) {
        super(_context);
    }

    public void genCommitVoucher4EarFund() throws Throwable {
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.parseDocument((RichDocument)this.getDocument());
        this.genCommitVoucher4EarFund(earmarkedFundVoucher);
    }

    private void genCommitVoucher4EarFund(FM_EarmarkedFundVoucher earmarkedFundVoucher) throws Throwable {
        List earmarkedFundVoucherDtls = earmarkedFundVoucher.efm_earmarkedFundVoucherDtls();
        PeriodFormula periodFormula = new PeriodFormula(this.getMidContext());
        EFM_UpdateProfileDtl updateProfileDtl = this.checkUpdateProfile(earmarkedFundVoucher);
        if (updateProfileDtl == null) {
            return;
        }
        EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.load((RichDocumentContext)this.getMidContext(), (Long)this.fmAreaID);
        int bcsActiveYear = finManagementArea.getBCSActiveYear();
        for (EFM_EarmarkedFundVoucherDtl eFM_EarmarkedFundVoucherDtl : earmarkedFundVoucherDtls) {
            Long fmLedgerID;
            int fiscalPeriod;
            int fiscalYear;
            Long fmPostDate;
            Long fundID = eFM_EarmarkedFundVoucherDtl.getFundID();
            Long fundCenterID = eFM_EarmarkedFundVoucherDtl.getFundCenterID();
            Long commitItemID = eFM_EarmarkedFundVoucherDtl.getCommitmentItemID();
            Long functionScopeID = eFM_EarmarkedFundVoucherDtl.getFunctionalAreaID();
            Long fundProgramID = eFM_EarmarkedFundVoucherDtl.getFundProgramID();
            BigDecimal totalAmount = eFM_EarmarkedFundVoucherDtl.getTotalMoney();
            if (this.voucherCategory == Integer.parseInt("60")) {
                totalAmount = totalAmount.negate();
            }
            this.postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionScopeID, fundProgramID);
            EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID);
            if (commitmentItem.getIsStatisticalCommit() > 0 || eFM_EarmarkedFundVoucherDtl.getIsStatistical() > 0) {
                this.isStatisticsUpdate = true;
            }
            if (updateProfileDtl.getIsPBActive() > 0 && updateProfileDtl.getIsPBReduce() > 0) {
                fmPostDate = updateProfileDtl.getPBDate().equals("B") ? earmarkedFundVoucher.getPostingDate() : eFM_EarmarkedFundVoucherDtl.getDueDate();
                if (this.paymentBudgetValue != 0) {
                    fmPostDate = this.paymentBudgetValue == 1 ? earmarkedFundVoucher.getPostingDate() : eFM_EarmarkedFundVoucherDtl.getDueDate();
                }
                fiscalYear = periodFormula.getYearByCompanyCodeDate(this.companyCodeID, fmPostDate);
                fiscalPeriod = periodFormula.getPeriodByCompanyCodeDate(this.companyCodeID, fmPostDate);
                if (bcsActiveYear > fiscalYear) continue;
                fmLedgerID = this.checkPostLedger(eFM_EarmarkedFundVoucherDtl, fundID, fmPostDate, fiscalYear, fiscalPeriod, "9F", "9A");
                this.dealCommitVoucher(earmarkedFundVoucher, eFM_EarmarkedFundVoucherDtl, this.fmAreaID, this.isPeriodOrYear, this.isStatisticsUpdate, totalAmount, commitmentItem, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, this.isAddValue);
            }
            if (updateProfileDtl.getIsCBActive() <= 0 || updateProfileDtl.getIsCBReduce() <= 0) continue;
            fmPostDate = updateProfileDtl.getCBDate().equals("B") ? earmarkedFundVoucher.getPostingDate() : eFM_EarmarkedFundVoucherDtl.getDueDate();
            if (this.commitBudgetValue != 0) {
                fmPostDate = this.commitBudgetValue == 1 ? earmarkedFundVoucher.getPostingDate() : eFM_EarmarkedFundVoucherDtl.getDueDate();
            }
            fiscalYear = periodFormula.getYearByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fiscalPeriod = periodFormula.getPeriodByCompanyCodeDate(this.companyCodeID, fmPostDate);
            if (bcsActiveYear > fiscalYear) continue;
            fmLedgerID = this.checkPostLedger(eFM_EarmarkedFundVoucherDtl, fundID, fmPostDate, fiscalYear, fiscalPeriod, "9G", "9B");
            this.dealCommitVoucher(earmarkedFundVoucher, eFM_EarmarkedFundVoucherDtl, this.fmAreaID, this.isPeriodOrYear, this.isStatisticsUpdate, totalAmount, commitmentItem, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, this.isAddValue);
        }
        if (!this.accountVoucher.isEmpty()) {
            for (Map.Entry entry : this.accountVoucher.entrySet()) {
                this.save((AbstractBillEntity)entry.getValue());
            }
        }
    }

    private Long checkPostLedger(EFM_EarmarkedFundVoucherDtl voucherDtl, Long fundID, Long fmPostDate, int fiscalYear, int fiscalPeriod, String budgetLedgerCode, String postLedgerCode) throws Throwable {
        EFM_AddressIndex addressIndex;
        EFM_BSDistribution bsDistribution;
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code(postLedgerCode).load();
        Long fmLedgerID = payLedger.getOID();
        EFM_PostLedgerPeriod postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).ValueType(this.valueType).FiscalYear(fiscalYear).FromFiscalPeriod("<=", fiscalPeriod).ToFiscalPeriod(">=", fiscalPeriod).LedgerID(fmLedgerID).load();
        if (postLedgerPeriod == null) {
            postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(fiscalYear).FromFiscalPeriod("<=", fiscalPeriod).ToFiscalPeriod(">=", fiscalPeriod).LedgerID(fmLedgerID).load();
        }
        if (postLedgerPeriod == null) {
            MessageFacade.throwException((String)"POCOMMITVOUCHERFORMULA002", (Object[])new Object[]{postLedgerCode});
        }
        if (fundID.compareTo(0L) > 0) {
            EFM_Fund fundDict = EFM_Fund.load((RichDocumentContext)this.getMidContext(), (Long)voucherDtl.getFundID());
            Long termValidityFromDate = fundDict.getValidStartDate();
            Long termValidityToDate = fundDict.getValidEndDate();
            if (ERPDateUtil.isBefore((Object)(fmPostDate + 1L), (Object)termValidityFromDate) || ERPDateUtil.isBefore((Object)termValidityToDate, (Object)fmPostDate)) {
                MessageFacade.throwException((String)"PRCOMMITVOUCHERFORMULA002", (Object[])new Object[]{fundDict.getCode()});
            }
        }
        if ((bsDistribution = EFM_BSDistribution.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FiscalYear(fiscalYear).load()) != null && bsDistribution.getIsCheckPost() > 0 && (addressIndex = EFM_AddressIndex.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FromFiscalYear(fiscalYear).FromLedgerID(fmLedgerID).FromObjectNumber(this.postAddress).ToLedgerCode(budgetLedgerCode).load()) == null) {
            MessageFacade.throwException((String)"PRCOMMITVOUCHERFORMULA003", (Object[])new Object[]{fiscalYear, postLedgerPeriod.getLedgerCode(), voucherDtl.getFundCode(), voucherDtl.getFundCenterCode(), voucherDtl.getCommitmentItemCode(), voucherDtl.getFunctionalAreaCode()});
        }
        return fmLedgerID;
    }

    private EFM_UpdateProfileDtl checkUpdateProfile(FM_EarmarkedFundVoucher earmarkedFundVoucher) throws Throwable {
        int bcsActiveYear;
        ECO_Version actualVersion = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load();
        this.versionID = actualVersion.getOID();
        this.voucherCategory = earmarkedFundVoucher.getVoucherCategory();
        this.valueType = this.getValueType(this.voucherCategory);
        this.companyCodeID = earmarkedFundVoucher.getCompanyCodeID();
        EFM_FMAreaToCompanyCode areaToCompanyCode = EFM_FMAreaToCompanyCode.loader((RichDocumentContext)this.getMidContext()).CompanyCodeID(this.companyCodeID).load();
        if (areaToCompanyCode == null || areaToCompanyCode.getIsUpdate() == 0) {
            return null;
        }
        this.fmAreaID = areaToCompanyCode.getFinancialManagementAreaID();
        EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.load((RichDocumentContext)this.getMidContext(), (Long)this.fmAreaID);
        Long updateProfileID = finManagementArea.getUpdateProfileID();
        if (updateProfileID.compareTo(0L) <= 0) {
            MessageFacade.throwException((String)"FI2FUNDVOUCHER001", (Object[])new Object[]{finManagementArea.getCode()});
        }
        if ((bcsActiveYear = finManagementArea.getBCSActiveYear()) <= 0) {
            MessageFacade.throwException((String)"COMMONCOMMITVOUCHER4OTHER003");
        }
        EFM_UpdateProfileHead updateProfile = EFM_UpdateProfileHead.load((RichDocumentContext)this.getMidContext(), (Long)updateProfileID);
        this.isPeriodOrYear = updateProfile.getIsPeriodOrYear();
        EFM_UpdateProfileDtl updateProfileDtl = EFM_UpdateProfileDtl.loader((RichDocumentContext)this.getMidContext()).SOID(updateProfileID).ValueType(this.valueType).load();
        if (updateProfileDtl == null) {
            MessageFacade.throwException((String)"FUNDVOUCHERFORMULA004", (Object[])new Object[]{areaToCompanyCode.getFinancialManagementAreaCode(), this.valueType});
        }
        if (updateProfileDtl.getIsBudgetAllocation() == 0) {
            return null;
        }
        this.isStatisticsUpdate = updateProfileDtl.getIsStatisticsUpdate() > 0;
        EFM_CoverUpdateProfile coverUpdateProfile = EFM_CoverUpdateProfile.loader((RichDocumentContext)this.getMidContext()).UpdateProfileID(updateProfile.getOID()).ValueType(this.valueType).load();
        if (coverUpdateProfile != null) {
            this.isStatisticsUpdate = coverUpdateProfile.getIsStaticUpdate() > 0;
            this.isPeriodOrYear = coverUpdateProfile.getIsPeriodOrYear();
            this.paymentBudgetValue = coverUpdateProfile.getPaymentBudgetValue();
            this.commitBudgetValue = coverUpdateProfile.getCommitBudgetValue();
        }
        if (updateProfileDtl.getIsPBActive() > 0 && updateProfileDtl.getIsPBReduce() > 0) {
            ++this.updateProfileTimes;
        }
        if (updateProfileDtl.getIsCBActive() > 0 && updateProfileDtl.getIsCBReduce() > 0) {
            ++this.updateProfileTimes;
        }
        return updateProfileDtl;
    }

    private void completedCommitVoucher4Year(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, boolean isStatisticsUpdate, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, int isPeriodOrYear, FM_CommitVoucher fmCommitVoucher) throws Throwable {
        block12: {
            block11: {
                if (fmCommitVoucher != null) break block11;
                if (voucherDtl.getIsProjectCompleted() != 1) break block12;
                this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, voucherDtl.getUnclearMoney().negate(), isStatisticsUpdate, isPeriodOrYear);
                voucherDtl.setUnclearMoney(BigDecimal.ZERO);
                this.directSave((AbstractBillEntity)earmarkedFundVoucher);
                break block12;
            }
            if (voucherDtl.getIsProjectCompleted() == 1) {
                if (voucherDtl.getUnclearMoney().compareTo(BigDecimal.ZERO) > 0) {
                    List commitVouchers0500 = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0500.getKey());
                    if (commitVouchers0500.isEmpty()) {
                        this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, voucherDtl.getUnclearMoney().negate(), isStatisticsUpdate, isPeriodOrYear);
                    } else {
                        EFM_CommitVoucherDtl lastCommitVoucher0500 = (EFM_CommitVoucherDtl)commitVouchers0500.get(commitVouchers0500.size() - 1);
                        lastCommitVoucher0500.setFMAreaCurrencyMoney(voucherDtl.getUnclearMoney().negate());
                        lastCommitVoucher0500.setTransactionCurrencyMoney(voucherDtl.getUnclearMoney().negate());
                    }
                    voucherDtl.setUnclearMoney(BigDecimal.ZERO);
                    this.directSave((AbstractBillEntity)earmarkedFundVoucher);
                }
                for (EFM_CommitVoucherDtl efmCommitVoucher : fmCommitVoucher.efm_commitVoucherDtls()) {
                    efmCommitVoucher.setFinishFlag("X");
                }
            } else {
                List commitVouchers0500 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0500.getKey()).FinishFlag("X").loadList();
                if (commitVouchers0500 != null && !commitVouchers0500.isEmpty()) {
                    BigDecimal hasAmount = BigDecimal.ZERO;
                    for (EFM_CommitVoucherDtl commitVoucher : commitVouchers0500) {
                        hasAmount = hasAmount.add(commitVoucher.getFMAreaCurrencyMoney());
                    }
                    if (hasAmount.compareTo(BigDecimal.ZERO) < 0) {
                        EFM_CommitVoucherDtl lastCommitVoucher0500 = (EFM_CommitVoucherDtl)commitVouchers0500.get(commitVouchers0500.size() - 1);
                        voucherDtl.setUnclearMoney(lastCommitVoucher0500.getFMAreaCurrencyMoney().negate());
                        this.directSave((AbstractBillEntity)earmarkedFundVoucher);
                        lastCommitVoucher0500.setFMAreaCurrencyMoney(BigDecimal.ZERO);
                        lastCommitVoucher0500.setTransactionCurrencyMoney(BigDecimal.ZERO);
                        this.save((AbstractTableEntity)lastCommitVoucher0500, "FM_CommitVoucher");
                    }
                    for (EFM_CommitVoucherDtl efmCommitVoucher : fmCommitVoucher.efm_commitVoucherDtls()) {
                        if (!voucherDtl.getReducedMoney().equals(BigDecimal.ZERO)) {
                            efmCommitVoucher.setFinishFlag("F");
                            continue;
                        }
                        efmCommitVoucher.setFinishFlag("Empty");
                    }
                }
            }
        }
    }

    private void completedCommitVoucher4Period(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, boolean isStatisticsUpdate, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, int isPeriodOrYear, FM_CommitVoucher fmCommitVoucher) throws Throwable {
        block8: {
            block7: {
                if (fmCommitVoucher != null) break block7;
                if (voucherDtl.getIsProjectCompleted() != 1) break block8;
                this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, voucherDtl.getUnclearMoney().negate(), isStatisticsUpdate, isPeriodOrYear);
                voucherDtl.setUnclearMoney(BigDecimal.ZERO);
                this.directSave((AbstractBillEntity)earmarkedFundVoucher);
                break block8;
            }
            if (voucherDtl.getIsProjectCompleted() == 1) {
                if (voucherDtl.getUnclearMoney().compareTo(BigDecimal.ZERO) > 0) {
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, voucherDtl.getUnclearMoney().negate(), isStatisticsUpdate, isPeriodOrYear);
                    voucherDtl.setUnclearMoney(BigDecimal.ZERO);
                    this.directSave((AbstractBillEntity)earmarkedFundVoucher);
                }
                for (EFM_CommitVoucherDtl efmCommitVoucher : fmCommitVoucher.efm_commitVoucherDtls()) {
                    efmCommitVoucher.setFinishFlag("X");
                }
            } else {
                List commitVouchers0500 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0500.getKey()).FinishFlag("X").loadList();
                if (commitVouchers0500 != null && !commitVouchers0500.isEmpty()) {
                    EFM_CommitVoucherDtl lastCommitVoucher0500 = (EFM_CommitVoucherDtl)commitVouchers0500.get(commitVouchers0500.size() - 1);
                    voucherDtl.setUnclearMoney(lastCommitVoucher0500.getFMAreaCurrencyMoney().negate());
                    this.directSave((AbstractBillEntity)earmarkedFundVoucher);
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, lastCommitVoucher0500.getFMAreaCurrencyMoney().negate(), isStatisticsUpdate, isPeriodOrYear);
                    for (EFM_CommitVoucherDtl efmCommitVoucher : fmCommitVoucher.efm_commitVoucherDtls()) {
                        if (!voucherDtl.getReducedMoney().equals(BigDecimal.ZERO)) {
                            efmCommitVoucher.setFinishFlag("F");
                            continue;
                        }
                        efmCommitVoucher.setFinishFlag("Empty");
                    }
                }
            }
        }
    }

    public String getValueType(int voucherCategory) {
        String valueType = null;
        if (voucherCategory == Integer.parseInt("2")) {
            valueType = ValueTypeEnum.ValueType_64.getKey();
        } else if (voucherCategory == Integer.parseInt("20")) {
            valueType = ValueTypeEnum.ValueType_80.getKey();
        } else if (voucherCategory == Integer.parseInt("30")) {
            valueType = ValueTypeEnum.ValueType_81.getKey();
        } else if (voucherCategory == Integer.parseInt("40")) {
            valueType = ValueTypeEnum.ValueType_82.getKey();
        } else if (voucherCategory == Integer.parseInt("50")) {
            valueType = ValueTypeEnum.ValueType_65.getKey();
        } else if (voucherCategory == Integer.parseInt("60")) {
            valueType = ValueTypeEnum.ValueType_83.getKey();
        }
        return valueType;
    }

    private Long getBussMaterCode(int voucherCategory) throws Throwable {
        Long bussMaterCode = null;
        if (voucherCategory == Integer.parseInt("2")) {
            BusinessTransaction progress_KBLZ = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KBLZ").load();
            bussMaterCode = progress_KBLZ.getOID();
        } else if (voucherCategory == Integer.parseInt("20")) {
            BusinessTransaction progress_KBLO = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KBLO").load();
            bussMaterCode = progress_KBLO.getOID();
        } else if (voucherCategory == Integer.parseInt("30")) {
            BusinessTransaction progress_KRES = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KRES").load();
            bussMaterCode = progress_KRES.getOID();
        } else if (voucherCategory == Integer.parseInt("40")) {
            BusinessTransaction progress_KPRE = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KPRE").load();
            bussMaterCode = progress_KPRE.getOID();
        } else if (voucherCategory == Integer.parseInt("50")) {
            BusinessTransaction progress_KCOM = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KCOM").load();
            bussMaterCode = progress_KCOM.getOID();
        } else if (voucherCategory == Integer.parseInt("60")) {
            BusinessTransaction progress_KFOR = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("KFOR").load();
            bussMaterCode = progress_KFOR.getOID();
        }
        return bussMaterCode;
    }

    private void dealCommitVoucher(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, int isPeriodOrYear, boolean isStatisticsUpdate, BigDecimal amount, EFM_CommitmentItemHead commitmentItem, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, int isAddValue) throws Throwable {
        FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).load();
        if (fmCommitVoucher != null) {
            List commitVouchers = fmCommitVoucher.efm_commitVoucherDtls("IsLatest", (Object)1);
            for (EFM_CommitVoucherDtl commitVoucher : commitVouchers) {
                BigDecimal amount0150;
                if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                this.accountVoucher.put(voucherDtl.getOID(), fmCommitVoucher);
                this.fmacAmount = fmCommitVoucher.getTotalFMAreaCurrencyMoney();
                if (isPeriodOrYear == Integer.parseInt("1")) {
                    if (isAddValue == 1) {
                        amount = this.fmacAmount.add(amount);
                    } else if (isAddValue == 0) {
                        amount = this.fmacAmount.subtract(amount);
                    }
                    fmCommitVoucher.deleteEFM_CommitVoucherDtl(commitVoucher);
                    if (commitmentItem.getFinancialBusiness() != 30) {
                        return;
                    }
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0100.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, amount, isStatisticsUpdate, isPeriodOrYear);
                    this.dealPushedVoucher4Year(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear);
                    this.dealPushedOriginalVoucher4Year(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear);
                    this.completedCommitVoucher4Year(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear, fmCommitVoucher);
                    continue;
                }
                if (isAddValue == -1) {
                    amount0150 = amount.subtract(this.fmacAmount);
                } else {
                    BigDecimal bigDecimal = amount0150 = isAddValue > 0 ? amount : amount.negate();
                }
                if (amount0150.compareTo(BigDecimal.ZERO) != 0) {
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0150.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, amount0150, isStatisticsUpdate, isPeriodOrYear);
                }
                BigDecimal sendAmount = this.getSendAmount(earmarkedFundVoucher.getOID(), voucherDtl.getOID(), fmLedgerID, commitVoucher.getPostAddress());
                if (commitmentItem.getFinancialBusiness() != 30) {
                    this.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0150.getKey(), commitVoucher, voucherDtl, sendAmount.negate(), isPeriodOrYear);
                    return;
                }
                String oldPostAddress = commitVoucher.getPostAddress();
                if (!oldPostAddress.equals(this.postAddress)) {
                    this.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0600.getKey(), commitVoucher, voucherDtl, sendAmount.negate(), isPeriodOrYear);
                    for (EFM_CommitVoucherDtl voucher : fmCommitVoucher.efm_commitVoucherDtls()) {
                        voucher.setIsLatest(0);
                    }
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0650.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, sendAmount, isStatisticsUpdate, isPeriodOrYear);
                }
                for (EFM_CommitVoucherDtl voucher : fmCommitVoucher.efm_commitVoucherDtls()) {
                    voucher.setPostingDate(fmPostDate);
                }
                this.dealPushedVoucher4Period(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear, commitVoucher);
                this.dealPushedOriginalVoucher4Period(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear);
                this.completedCommitVoucher4Period(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear, fmCommitVoucher);
            }
        } else {
            if (commitmentItem.getFinancialBusiness() != 30) {
                return;
            }
            if (voucherDtl.getIsSender() == 1) {
                amount = amount.negate();
            }
            this.genEFCommitVoucher(AmountTypeEnum.AmountType_0100.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, amount, isStatisticsUpdate, isPeriodOrYear);
            if (isPeriodOrYear == Integer.parseInt("1")) {
                this.dealPushedVoucher4Year(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear);
                this.completedCommitVoucher4Year(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear, null);
            } else {
                this.dealPushedVoucher4Period(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear, null);
                this.completedCommitVoucher4Period(earmarkedFundVoucher, voucherDtl, fmAreaID, isStatisticsUpdate, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, isPeriodOrYear, null);
            }
        }
    }

    private FM_CommitVoucher getCommitVoucherForm(String docNumber, Long documentID, Long dtlID) throws Throwable {
        FM_CommitVoucher commitVoucher = this.accountVoucher.get(dtlID);
        if (commitVoucher == null) {
            commitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(documentID).ReferItemOID(dtlID).load();
            if (commitVoucher == null) {
                commitVoucher = (FM_CommitVoucher)this.newBillEntity(FM_CommitVoucher.class);
                commitVoucher.setReferDocType(ReferDocTypeEnum.EarmarkedFund.getKey());
                commitVoucher.setReferDocSOID(documentID);
                commitVoucher.setReferItemOID(dtlID);
                commitVoucher.setReferAccountAssignItemOID(Long.valueOf(0L));
                commitVoucher.setReferDocNo(docNumber);
            }
            this.accountVoucher.put(dtlID, commitVoucher);
        }
        return commitVoucher;
    }

    private BigDecimal getSendAmount(Long docOID, Long dtlOID, Long fmLedgerID, String postAddress) throws Throwable {
        BigDecimal sendAmount = BigDecimal.ZERO;
        List commitVouchers = fmLedgerID.compareTo(0L) > 0 ? EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(docOID).ReferItemOID(dtlOID).PostAddress(postAddress).loadList() : EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(docOID).ReferItemOID(dtlOID).PostAddress(postAddress).loadList();
        if (commitVouchers != null) {
            for (EFM_CommitVoucherDtl commitVoucher : commitVouchers) {
                sendAmount = sendAmount.add(commitVoucher.getFMAreaCurrencyMoney());
            }
        }
        return sendAmount;
    }

    public void genEFCommitVoucher(String amountType, EFM_EarmarkedFundVoucherHead earmarkedFundVoucherHead, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, Long postLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, BigDecimal amount, boolean isStatisticUpdate, int isPeriodOrYear) throws Throwable {
        Long preItemOID;
        FM_CommitVoucher fmCommitVoucher = this.getCommitVoucherForm(earmarkedFundVoucherHead.getDocumentNumber(), earmarkedFundVoucherHead.getOID(), voucherDtl.getOID());
        EFM_CommitVoucherDtl commitVoucher = fmCommitVoucher.newEFM_CommitVoucherDtl();
        Long companyCodeID = earmarkedFundVoucherHead.getCompanyCodeID();
        int voucherCategory = earmarkedFundVoucherHead.getVoucherCategory();
        Long fundID = voucherDtl.getFundID();
        Long fundCenterID = voucherDtl.getFundCenterID();
        Long commitItemID = voucherDtl.getCommitmentItemID();
        Long functionScopeID = voucherDtl.getFunctionalAreaID();
        commitVoucher.setReferDocType(ReferDocTypeEnum.EarmarkedFund.getKey());
        commitVoucher.setReferDocSOID(earmarkedFundVoucherHead.getOID());
        commitVoucher.setReferDocNo(earmarkedFundVoucherHead.getDocumentNumber());
        commitVoucher.setReferItemOID(voucherDtl.getOID());
        commitVoucher.setReferTrade("FMRES");
        commitVoucher.setMoneyType(amountType);
        commitVoucher.setSrcSOID(earmarkedFundVoucherHead.getOID());
        commitVoucher.setSrcOID(voucherDtl.getOID());
        commitVoucher.setSrcFormKey("FM_EarmarkedFundVoucher");
        commitVoucher.setPostingDate(fmPostDate);
        commitVoucher.setFiscalYear(fiscalYear);
        commitVoucher.setFiscalPeriod(fiscalPeriod);
        commitVoucher.setVersionID(this.versionID);
        commitVoucher.setLedgerID(postLedgerID);
        if (voucherDtl.getIsNoCommitCarryover() == 1) {
            commitVoucher.setCommitVoucherCarryoverStatus(FYCStatusEnum.FYCStatus_99.getKey());
        } else {
            commitVoucher.setCommitVoucherCarryoverStatus(FYCStatusEnum.FYCStatus_00.getKey());
        }
        commitVoucher.setTransactionCurrencyMoney(amount);
        commitVoucher.setFMAreaCurrencyMoney(amount);
        commitVoucher.setCommitmentItemID(commitItemID);
        commitVoucher.setFundCenterID(fundCenterID);
        commitVoucher.setFundID(fundID);
        commitVoucher.setFunctionalAreaID(functionScopeID);
        commitVoucher.setPostAddress(this.postAddress);
        commitVoucher.setValueType(this.getValueType(voucherCategory));
        commitVoucher.setBusinessTransactionID(this.getBussMaterCode(voucherCategory));
        commitVoucher.setCompanyCodeID(companyCodeID);
        commitVoucher.setCurrencyID(earmarkedFundVoucherHead.getCurrencyID());
        commitVoucher.setMaterialID(voucherDtl.getMaterialID());
        commitVoucher.setShortText(voucherDtl.getNotes());
        commitVoucher.setGLAccountID(voucherDtl.getGLAccountID());
        commitVoucher.setFinancialManagementAreaID(fmAreaID);
        commitVoucher.setVendorID(voucherDtl.getVenderID());
        commitVoucher.setStatisticalIdentifier("Empty");
        Long preDocOID = voucherDtl.getFundsReservationSOID() != 0L ? voucherDtl.getFundsReservationSOID() : voucherDtl.getFundsPrecommitmentSOID();
        Long l = preItemOID = voucherDtl.getFundsReservationDtlOID() != 0L ? voucherDtl.getFundsReservationDtlOID() : voucherDtl.getFundsPrecommitmentDtlOID();
        if (preDocOID != 0L && preItemOID != 0L) {
            commitVoucher.setPreDocType(ReferDocTypeEnum.EarmarkedFund.getKey());
            commitVoucher.setPreReferTrade("FMRES");
            commitVoucher.setPreDocSOID(preDocOID);
            commitVoucher.setPreItemOID(preItemOID);
        }
        if (amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0100.getKey()) || amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0650.getKey())) {
            commitVoucher.setIsLatest(1);
        }
        if (amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0100.getKey()) || amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0150.getKey())) {
            if (this.updateProfileTimes > 1) {
                FM_Ledger fmLedger = FM_Ledger.load((RichDocumentContext)this.getMidContext(), (Long)postLedgerID);
                if (fmLedger.getCode().equals("9B")) {
                    if (isPeriodOrYear == Integer.parseInt("1")) {
                        fmCommitVoucher.setTotalFMAreaCurrencyMoney(amount);
                        fmCommitVoucher.setTotalTransactionCurrencyMoney(amount);
                    } else {
                        fmCommitVoucher.setTotalFMAreaCurrencyMoney(fmCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount));
                        fmCommitVoucher.setTotalTransactionCurrencyMoney(fmCommitVoucher.getTotalTransactionCurrencyMoney().add(amount));
                    }
                }
            } else if (isPeriodOrYear == Integer.parseInt("1")) {
                fmCommitVoucher.setTotalFMAreaCurrencyMoney(amount);
                fmCommitVoucher.setTotalTransactionCurrencyMoney(amount);
            } else {
                fmCommitVoucher.setTotalFMAreaCurrencyMoney(fmCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount));
                fmCommitVoucher.setTotalTransactionCurrencyMoney(fmCommitVoucher.getTotalTransactionCurrencyMoney().add(amount));
            }
        }
        if (voucherDtl.getIsProjectCompleted() == 1) {
            commitVoucher.setFinishFlag("X");
        } else {
            commitVoucher.setFinishFlag("Empty");
        }
        if (isStatisticUpdate) {
            commitVoucher.setStatisticalIdentifier("X");
        }
    }

    public void genEFCommitVoucherFromVoucher(String amountType, EFM_CommitVoucherDtl fromCommitVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, BigDecimal amount, int isPeriodOrYear) throws Throwable {
        FM_CommitVoucher fmCommitVoucher = this.getCommitVoucherForm(fromCommitVoucher.getReferDocNo(), fromCommitVoucher.getReferDocSOID(), fromCommitVoucher.getReferItemOID());
        EFM_CommitVoucherDtl commitVoucher = fmCommitVoucher.newEFM_CommitVoucherDtl();
        commitVoucher.setReferDocType(fromCommitVoucher.getReferDocType());
        commitVoucher.setReferDocSOID(fromCommitVoucher.getReferDocSOID());
        commitVoucher.setReferDocNo(fromCommitVoucher.getReferDocNo());
        commitVoucher.setReferItemOID(fromCommitVoucher.getReferItemOID());
        commitVoucher.setReferTrade(fromCommitVoucher.getReferTrade());
        commitVoucher.setMoneyType(amountType);
        commitVoucher.setSrcSOID(fromCommitVoucher.getSrcSOID());
        commitVoucher.setSrcOID(fromCommitVoucher.getSrcOID());
        commitVoucher.setSrcFormKey(fromCommitVoucher.getSrcFormKey());
        commitVoucher.setPostingDate(fromCommitVoucher.getPostingDate());
        commitVoucher.setFiscalYear(fromCommitVoucher.getFiscalYear());
        commitVoucher.setFiscalPeriod(fromCommitVoucher.getFiscalPeriod());
        commitVoucher.setVersionID(fromCommitVoucher.getVersionID());
        commitVoucher.setLedgerID(fromCommitVoucher.getLedgerID());
        commitVoucher.setCommitVoucherCarryoverStatus(fromCommitVoucher.getCommitVoucherCarryoverStatus());
        commitVoucher.setTransactionCurrencyMoney(amount);
        commitVoucher.setFMAreaCurrencyMoney(amount);
        commitVoucher.setCommitmentItemID(fromCommitVoucher.getCommitmentItemID());
        commitVoucher.setFundCenterID(fromCommitVoucher.getFundCenterID());
        commitVoucher.setFundID(fromCommitVoucher.getFundID());
        commitVoucher.setFunctionalAreaID(fromCommitVoucher.getFunctionalAreaID());
        commitVoucher.setPostAddress(fromCommitVoucher.getPostAddress());
        commitVoucher.setValueType(fromCommitVoucher.getValueType());
        commitVoucher.setBusinessTransactionID(fromCommitVoucher.getBusinessTransactionID());
        commitVoucher.setCompanyCodeID(fromCommitVoucher.getCompanyCodeID());
        commitVoucher.setCurrencyID(fromCommitVoucher.getCurrencyID());
        commitVoucher.setMaterialID(fromCommitVoucher.getMaterialID());
        commitVoucher.setShortText(fromCommitVoucher.getShortText());
        commitVoucher.setGLAccountID(fromCommitVoucher.getGLAccountID());
        commitVoucher.setFinancialManagementAreaID(fromCommitVoucher.getFinancialManagementAreaID());
        commitVoucher.setVendorID(fromCommitVoucher.getVendorID());
        commitVoucher.setQuantity(fromCommitVoucher.getQuantity());
        commitVoucher.setStatisticalIdentifier("Empty");
        if (fromCommitVoucher.getPreDocSOID().compareTo(0L) > 0) {
            commitVoucher.setPreDocType(ReferDocTypeEnum.EarmarkedFund.getKey());
            commitVoucher.setPreReferTrade("FMRES");
            commitVoucher.setPreDocSOID(fromCommitVoucher.getPreDocSOID());
            commitVoucher.setPreItemOID(fromCommitVoucher.getPreItemOID());
        }
        if (amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0100.getKey()) || amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0650.getKey())) {
            commitVoucher.setIsLatest(1);
        }
        if (amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0100.getKey()) || amountType.equalsIgnoreCase(AmountTypeEnum.AmountType_0150.getKey())) {
            if (this.updateProfileTimes > 1) {
                FM_Ledger fmLedger = FM_Ledger.load((RichDocumentContext)this.getMidContext(), (Long)fromCommitVoucher.getLedgerID());
                if (fmLedger.getCode().equals("9B")) {
                    if (isPeriodOrYear == Integer.parseInt("1")) {
                        fmCommitVoucher.setTotalFMAreaCurrencyMoney(amount);
                        fmCommitVoucher.setTotalTransactionCurrencyMoney(amount);
                    } else {
                        fmCommitVoucher.setTotalFMAreaCurrencyMoney(fmCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount));
                        fmCommitVoucher.setTotalTransactionCurrencyMoney(fmCommitVoucher.getTotalTransactionCurrencyMoney().add(amount));
                    }
                }
            } else if (isPeriodOrYear == Integer.parseInt("1")) {
                fmCommitVoucher.setTotalFMAreaCurrencyMoney(amount);
                fmCommitVoucher.setTotalTransactionCurrencyMoney(amount);
            } else {
                fmCommitVoucher.setTotalFMAreaCurrencyMoney(fmCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount));
                fmCommitVoucher.setTotalTransactionCurrencyMoney(fmCommitVoucher.getTotalTransactionCurrencyMoney().add(amount));
            }
        }
        commitVoucher.setFinishFlag("Empty");
        if (!fromCommitVoucher.getStatisticalIdentifier().equals("Empty")) {
            commitVoucher.setStatisticalIdentifier(fromCommitVoucher.getStatisticalIdentifier());
        }
    }

    public void judgeTolerance(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl pushedEFDtl, EFM_EarmarkedFundVoucherDtl voucherDtl, BigDecimal subtractAmount, BigDecimal totalAmount) throws Throwable {
        if (pushedEFDtl.getIsUnlimited() == 1) {
            return;
        }
        double minTolerance = Double.MAX_VALUE;
        int isOverstepGlobalTolerance = pushedEFDtl.getIsOverstepGlobalTolerance();
        BigDecimal overstepTolerance = pushedEFDtl.getOverstepTolerance();
        BigDecimal dltOverAmount = overstepTolerance.multiply(BigDecimal.valueOf(0.01)).multiply(totalAmount);
        if (overstepTolerance.compareTo(BigDecimal.ZERO) > 0 && dltOverAmount.compareTo(subtractAmount.abs()) < 0) {
            minTolerance = Math.min(minTolerance, overstepTolerance.doubleValue());
        }
        Long voucherTypeID = earmarkedFundVoucher.getEarmarkedFundVoucherTypeID();
        boolean isOpenToleranceControl = false;
        EFM_EarmarkedFundVoucherType earmarkedFundVoucherType = EFM_EarmarkedFundVoucherType.load((RichDocumentContext)this.getMidContext(), (Long)voucherTypeID);
        EFM_ToleranceControl toleranceControl = EFM_ToleranceControl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherType.getToleranceControlID()).load();
        if (toleranceControl != null) {
            if (toleranceControl.getIsCheckAbsoluteMoney() == 1) {
                BigDecimal absoluteAmount = toleranceControl.getAbsoluteMoney();
                isOpenToleranceControl = true;
                if (absoluteAmount.compareTo(BigDecimal.ZERO) > 0 && absoluteAmount.compareTo(subtractAmount.abs()) < 0) {
                    minTolerance = Math.min(minTolerance, absoluteAmount.multiply(BigDecimal.valueOf(100L).divide(totalAmount, 2, RoundingMode.HALF_UP)).doubleValue());
                }
            }
            if (isOverstepGlobalTolerance == 0 && toleranceControl.getIsCheckPercentageMoney() == 1) {
                BigDecimal percentageAmount = toleranceControl.getPercentageMoney();
                isOpenToleranceControl = true;
                if (percentageAmount.multiply(BigDecimal.valueOf(0.01)).multiply(totalAmount).compareTo(subtractAmount.abs()) < 0) {
                    minTolerance = Math.min(minTolerance, percentageAmount.doubleValue());
                }
            }
        }
        if (minTolerance != Double.MAX_VALUE) {
            MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA000", (Object[])new Object[]{voucherDtl.getDetailNumber(), minTolerance});
        }
        if (overstepTolerance.compareTo(BigDecimal.ZERO) == 0 && !isOpenToleranceControl) {
            MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA000", (Object[])new Object[]{voucherDtl.getDetailNumber(), minTolerance});
        }
    }

    private void dealPushedVoucher4Year(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, boolean isStatisticsUpdate, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, int isPeriodOrYear) throws Throwable {
        FM_EarmarkedFundVoucher fmEarmarkedFundVoucher;
        EFM_EarmarkedFundVoucherDtl pushedEFDtl = null;
        EFM_EarmarkedFundVoucherHead earmarkedFundVoucherHead = null;
        Long fundsReservationID = voucherDtl.getFundsReservationSOID();
        Long fundsPrecommitmentID = voucherDtl.getFundsPrecommitmentSOID();
        EFM_CommitVoucherDtl efmCommitVoucher = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).IsLatest(1).load();
        if (fundsReservationID != 0L) {
            fmEarmarkedFundVoucher = FM_EarmarkedFundVoucher.loader((RichDocumentContext)this.getMidContext()).OID(fundsReservationID).load();
            earmarkedFundVoucherHead = fmEarmarkedFundVoucher.efm_earmarkedFundVoucherHead();
            pushedEFDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(voucherDtl.getFundsReservationDtlOID()).load();
        } else if (fundsPrecommitmentID != 0L) {
            fmEarmarkedFundVoucher = FM_EarmarkedFundVoucher.loader((RichDocumentContext)this.getMidContext()).OID(fundsPrecommitmentID).load();
            earmarkedFundVoucherHead = fmEarmarkedFundVoucher.efm_earmarkedFundVoucherHead();
            pushedEFDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(voucherDtl.getFundsPrecommitmentDtlOID()).load();
        }
        if (pushedEFDtl != null) {
            BigDecimal subtractAmount;
            FM_Ledger fmLedger;
            List pushedCommitVouchers0500;
            FM_CommitVoucher pushedVoucher;
            List pushedCommitVouchers0200;
            if (pushedEFDtl.getIsProjectFreezed() == 1) {
                MessageFacade.throwException((String)"FUNDVOUCHERFORMULA001", (Object[])new Object[]{voucherDtl.getDetailNumber()});
            }
            if (pushedEFDtl.getIsProjectCompleted() == 1) {
                MessageFacade.throwException((String)"FUNDVOUCHERFORMULA002", (Object[])new Object[]{voucherDtl.getDetailNumber()});
            }
            if ((pushedCommitVouchers0200 = (pushedVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).Dtl_ReferDocSOID(earmarkedFundVoucherHead.getOID()).Dtl_ReferItemOID(pushedEFDtl.getOID()).load()).efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey())) != null && !pushedCommitVouchers0200.isEmpty()) {
                for (EFM_CommitVoucherDtl commitVoucher : pushedCommitVouchers0200) {
                    if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                    pushedVoucher.deleteEFM_CommitVoucherDtl(commitVoucher);
                }
            }
            if ((pushedCommitVouchers0500 = pushedVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0500.getKey())) != null && !pushedCommitVouchers0500.isEmpty()) {
                for (EFM_CommitVoucherDtl commitVoucher : pushedCommitVouchers0500) {
                    if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                    pushedVoucher.deleteEFM_CommitVoucherDtl(commitVoucher);
                }
            }
            BigDecimal totalAmount = pushedEFDtl.getTotalMoney();
            BigDecimal reducedAmount = pushedEFDtl.getReducedMoney();
            BigDecimal voucherDtlTotalAmount = voucherDtl.getTotalMoney();
            BigDecimal allReduceAmount = reducedAmount.add(voucherDtlTotalAmount.subtract(this.fmacAmount));
            if (efmCommitVoucher != null && efmCommitVoucher.getPreDocSOID() == 0L && efmCommitVoucher.getPreItemOID() == 0L) {
                allReduceAmount = reducedAmount.add(voucherDtlTotalAmount);
            }
            if (this.updateProfileTimes > 1 && (fmLedger = FM_Ledger.load((RichDocumentContext)this.getMidContext(), (Long)fmLedgerID)).getCode().equals("9B")) {
                allReduceAmount = reducedAmount;
            }
            this.genEFCommitVoucher(AmountTypeEnum.AmountType_0200.getKey(), earmarkedFundVoucherHead, pushedEFDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, allReduceAmount.negate(), isStatisticsUpdate, isPeriodOrYear);
            int isNagetive = earmarkedFundVoucherHead.getIsNagetiveValiueAllowed();
            BigDecimal bigDecimal = subtractAmount = isNagetive == 0 ? totalAmount.subtract(allReduceAmount) : totalAmount.subtract(allReduceAmount).negate();
            if (subtractAmount.compareTo(BigDecimal.ZERO) >= 0) {
                pushedEFDtl.setUnclearMoney(subtractAmount);
            } else {
                this.judgeTolerance(earmarkedFundVoucher, pushedEFDtl, voucherDtl, subtractAmount, totalAmount);
                this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucherHead, pushedEFDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, subtractAmount.negate(), isStatisticsUpdate, isPeriodOrYear);
                pushedEFDtl.setUnclearMoney(BigDecimal.ZERO);
            }
            pushedEFDtl.setReducedMoney(allReduceAmount);
            this.save((AbstractTableEntity)pushedEFDtl, "FM_EarmarkedFundVoucher");
        } else {
            if (efmCommitVoucher == null) {
                return;
            }
            if (efmCommitVoucher.getPreDocSOID() != 0L && efmCommitVoucher.getPreItemOID() != 0L) {
                FM_Ledger fmLedger;
                FM_CommitVoucher pushedVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).Dtl_ReferDocSOID(efmCommitVoucher.getPreDocSOID()).Dtl_ReferItemOID(efmCommitVoucher.getPreItemOID()).load();
                BigDecimal hasAmount0200 = BigDecimal.ZERO;
                List pushedCommitVouchers0200 = pushedVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
                if (pushedCommitVouchers0200 != null && !pushedCommitVouchers0200.isEmpty()) {
                    for (EFM_CommitVoucherDtl commitVoucher : pushedCommitVouchers0200) {
                        if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                        hasAmount0200 = hasAmount0200.add(commitVoucher.getFMAreaCurrencyMoney());
                        pushedVoucher.deleteEFM_CommitVoucherDtl(commitVoucher);
                    }
                }
                List pushedCommitVouchers0500 = pushedVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0500.getKey());
                BigDecimal hasAmount0500 = BigDecimal.ZERO;
                if (pushedCommitVouchers0500 != null && !pushedCommitVouchers0500.isEmpty()) {
                    for (EFM_CommitVoucherDtl commitVoucher : pushedCommitVouchers0500) {
                        if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                        hasAmount0500 = hasAmount0500.add(commitVoucher.getFMAreaCurrencyMoney());
                        pushedVoucher.deleteEFM_CommitVoucherDtl(commitVoucher);
                    }
                }
                pushedEFDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(efmCommitVoucher.getPreItemOID()).load();
                BigDecimal oldUnClearMoney = pushedEFDtl.getUnclearMoney();
                BigDecimal oldReducedAmount = pushedEFDtl.getReducedMoney();
                BigDecimal nowUnClearMoney = oldUnClearMoney.add(hasAmount0200.add(hasAmount0500).negate());
                BigDecimal nowReduceAmount = oldReducedAmount.add(hasAmount0200);
                if (this.updateProfileTimes > 1 && (fmLedger = FM_Ledger.load((RichDocumentContext)this.getMidContext(), (Long)fmLedgerID)).getCode().equals("9B")) {
                    nowUnClearMoney = oldUnClearMoney;
                    nowReduceAmount = oldReducedAmount;
                }
                pushedEFDtl.setUnclearMoney(nowUnClearMoney);
                pushedEFDtl.setReducedMoney(nowReduceAmount);
                this.save((AbstractTableEntity)pushedEFDtl, "FM_EarmarkedFundVoucher");
                this.save((AbstractBillEntity)pushedVoucher);
            }
        }
    }

    private void dealPushedOriginalVoucher4Year(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, boolean isStatisticsUpdate, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, int isPeriodOrYear) throws Throwable {
        if (voucherDtl.getReducedMoney().compareTo(BigDecimal.ZERO) != 0) {
            List commitVouchers0200 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(voucherDtl.getSOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0200.getKey()).loadList();
            BigDecimal hasAmount0200 = BigDecimal.ZERO;
            if (commitVouchers0200 != null && !commitVouchers0200.isEmpty()) {
                for (EFM_CommitVoucherDtl efmCommitVoucher : commitVouchers0200) {
                    hasAmount0200 = hasAmount0200.add(efmCommitVoucher.getFMAreaCurrencyMoney());
                }
            }
            if (hasAmount0200.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal subtractAmount;
                EFM_CommitVoucherDtl commitVoucher500 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(voucherDtl.getSOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0500.getKey()).load();
                int isNagetive = earmarkedFundVoucher.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed();
                BigDecimal bigDecimal = subtractAmount = isNagetive == 0 ? hasAmount0200.abs().subtract(voucherDtl.getTotalMoney()) : hasAmount0200.abs().subtract(voucherDtl.getTotalMoney()).negate();
                if (commitVoucher500 != null) {
                    if (subtractAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        commitVoucher500.setFMAreaCurrencyMoney(BigDecimal.ZERO);
                        commitVoucher500.setTransactionCurrencyMoney(BigDecimal.ZERO);
                    } else {
                        this.judgeTolerance(earmarkedFundVoucher, voucherDtl, voucherDtl, subtractAmount, voucherDtl.getTotalMoney());
                        commitVoucher500.setFMAreaCurrencyMoney(subtractAmount);
                        commitVoucher500.setTransactionCurrencyMoney(subtractAmount);
                    }
                    this.save((AbstractTableEntity)commitVoucher500, "FM_CommitVoucher");
                } else if (subtractAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    this.judgeTolerance(earmarkedFundVoucher, voucherDtl, voucherDtl, subtractAmount, voucherDtl.getTotalMoney());
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, subtractAmount, isStatisticsUpdate, isPeriodOrYear);
                }
            }
        }
    }

    private void dealPushedVoucher4Period(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, boolean isStatisticsUpdate, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, int isPeriodOrYear, EFM_CommitVoucherDtl efmCommitVoucher) throws Throwable {
        FM_EarmarkedFundVoucher fmEarmarkedFundVoucher;
        EFM_EarmarkedFundVoucherDtl pushedEFDtl = null;
        EFM_EarmarkedFundVoucherHead earmarkedFundVoucherHead = null;
        Long fundsReservationID = voucherDtl.getFundsReservationSOID();
        Long fundsPrecommitmentID = voucherDtl.getFundsPrecommitmentSOID();
        if (fundsReservationID != 0L) {
            fmEarmarkedFundVoucher = FM_EarmarkedFundVoucher.loader((RichDocumentContext)this.getMidContext()).OID(fundsReservationID).load();
            earmarkedFundVoucherHead = fmEarmarkedFundVoucher.efm_earmarkedFundVoucherHead();
            pushedEFDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(voucherDtl.getFundsReservationDtlOID()).load();
        } else if (fundsPrecommitmentID != 0L) {
            fmEarmarkedFundVoucher = FM_EarmarkedFundVoucher.loader((RichDocumentContext)this.getMidContext()).OID(fundsPrecommitmentID).load();
            earmarkedFundVoucherHead = fmEarmarkedFundVoucher.efm_earmarkedFundVoucherHead();
            pushedEFDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(voucherDtl.getFundsPrecommitmentDtlOID()).load();
        }
        if (pushedEFDtl != null) {
            int isNagetive;
            FM_Ledger fmLedger;
            if (pushedEFDtl.getIsProjectFreezed() == 1) {
                MessageFacade.throwException((String)"FUNDVOUCHERFORMULA001", (Object[])new Object[]{voucherDtl.getDetailNumber()});
            }
            if (pushedEFDtl.getIsProjectCompleted() == 1) {
                MessageFacade.throwException((String)"FUNDVOUCHERFORMULA002", (Object[])new Object[]{voucherDtl.getDetailNumber()});
            }
            List pushedCommitVouchers0500 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(earmarkedFundVoucherHead.getOID()).ReferItemOID(pushedEFDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0500.getKey()).loadList();
            BigDecimal hasPushedAmount0500 = BigDecimal.ZERO;
            if (pushedCommitVouchers0500 != null && !pushedCommitVouchers0500.isEmpty()) {
                for (EFM_CommitVoucherDtl commitVoucher : pushedCommitVouchers0500) {
                    hasPushedAmount0500 = hasPushedAmount0500.add(commitVoucher.getFMAreaCurrencyMoney());
                }
            }
            BigDecimal totalAmount = pushedEFDtl.getTotalMoney();
            BigDecimal reducedAmount = pushedEFDtl.getReducedMoney();
            BigDecimal voucherDtlTotalAmount = voucherDtl.getTotalMoney();
            BigDecimal nowReduceAmount = voucherDtlTotalAmount.subtract(this.fmacAmount);
            if (efmCommitVoucher != null && efmCommitVoucher.getPreDocSOID() == 0L && efmCommitVoucher.getPreItemOID() == 0L) {
                nowReduceAmount = voucherDtlTotalAmount;
                efmCommitVoucher.setPreDocSOID(pushedEFDtl.getSOID());
                efmCommitVoucher.setPreItemOID(pushedEFDtl.getOID());
            }
            BigDecimal allReduceAmount = reducedAmount.add(nowReduceAmount);
            if (this.updateProfileTimes > 1 && (fmLedger = FM_Ledger.load((RichDocumentContext)this.getMidContext(), (Long)fmLedgerID)).getCode().equals("9B")) {
                allReduceAmount = reducedAmount;
            }
            BigDecimal subtractAmount = (isNagetive = earmarkedFundVoucher.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed()) == 0 ? totalAmount.subtract(allReduceAmount) : totalAmount.subtract(allReduceAmount).negate();
            this.genEFCommitVoucher(AmountTypeEnum.AmountType_0200.getKey(), earmarkedFundVoucherHead, pushedEFDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, nowReduceAmount.negate(), isStatisticsUpdate, isPeriodOrYear);
            if (subtractAmount.compareTo(BigDecimal.ZERO) >= 0) {
                pushedEFDtl.setUnclearMoney(subtractAmount);
                if (hasPushedAmount0500.compareTo(BigDecimal.ZERO) != 0) {
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucherHead, pushedEFDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, hasPushedAmount0500.negate(), isStatisticsUpdate, isPeriodOrYear);
                }
            } else {
                this.judgeTolerance(earmarkedFundVoucher, pushedEFDtl, voucherDtl, subtractAmount, totalAmount);
                this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucherHead, pushedEFDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, subtractAmount.negate().subtract(hasPushedAmount0500), isStatisticsUpdate, isPeriodOrYear);
                pushedEFDtl.setUnclearMoney(BigDecimal.ZERO);
            }
            pushedEFDtl.setReducedMoney(allReduceAmount);
            this.save((AbstractTableEntity)pushedEFDtl, "FM_EarmarkedFundVoucher");
        } else {
            if (efmCommitVoucher == null) {
                return;
            }
            if (efmCommitVoucher.getPreDocSOID() != 0L && efmCommitVoucher.getPreItemOID() != 0L) {
                FM_Ledger fmLedger;
                FM_CommitVoucher pushedVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).Dtl_ReferDocSOID(efmCommitVoucher.getPreDocSOID()).Dtl_ReferItemOID(efmCommitVoucher.getPreItemOID()).load();
                List pushedCommitVouchers0200 = pushedVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
                BigDecimal hasAmount0200 = BigDecimal.ZERO;
                if (pushedCommitVouchers0200 != null && !pushedCommitVouchers0200.isEmpty()) {
                    for (EFM_CommitVoucherDtl commitVoucher : pushedCommitVouchers0200) {
                        if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                        hasAmount0200 = hasAmount0200.add(commitVoucher.getFMAreaCurrencyMoney());
                    }
                    this.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0200.getKey(), (EFM_CommitVoucherDtl)pushedCommitVouchers0200.get(0), voucherDtl, efmCommitVoucher.getFMAreaCurrencyMoney(), isPeriodOrYear);
                }
                List pushedCommitVouchers0500 = pushedVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0500.getKey());
                BigDecimal hasAmount0500 = BigDecimal.ZERO;
                if (pushedCommitVouchers0500 != null && !pushedCommitVouchers0500.isEmpty()) {
                    for (EFM_CommitVoucherDtl commitVoucher : pushedCommitVouchers0500) {
                        if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                        hasAmount0500 = hasAmount0500.add(commitVoucher.getFMAreaCurrencyMoney());
                    }
                    BigDecimal nowAmount0500 = hasAmount0500.compareTo(efmCommitVoucher.getFMAreaCurrencyMoney()) > 0 ? efmCommitVoucher.getFMAreaCurrencyMoney().negate() : hasAmount0500.negate();
                    this.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0500.getKey(), (EFM_CommitVoucherDtl)pushedCommitVouchers0500.get(0), voucherDtl, nowAmount0500, isPeriodOrYear);
                }
                pushedEFDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(efmCommitVoucher.getPreItemOID()).load();
                BigDecimal oldUnClearMoney = pushedEFDtl.getUnclearMoney();
                BigDecimal oldReducedAmount = pushedEFDtl.getReducedMoney();
                BigDecimal nowUnClearMoney = oldUnClearMoney.add(hasAmount0200.add(hasAmount0500).negate());
                BigDecimal nowReduceAmount = oldReducedAmount.add(hasAmount0200);
                efmCommitVoucher.setPreDocSOID(Long.valueOf(0L));
                efmCommitVoucher.setPreItemOID(Long.valueOf(0L));
                if (this.updateProfileTimes > 1 && (fmLedger = FM_Ledger.load((RichDocumentContext)this.getMidContext(), (Long)fmLedgerID)).getCode().equals("9B")) {
                    nowUnClearMoney = oldUnClearMoney;
                    nowReduceAmount = oldReducedAmount;
                }
                pushedEFDtl.setUnclearMoney(nowUnClearMoney);
                pushedEFDtl.setReducedMoney(nowReduceAmount);
                this.save((AbstractTableEntity)pushedEFDtl, "FM_EarmarkedFundVoucher");
            }
        }
    }

    private void dealPushedOriginalVoucher4Period(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, Long fmAreaID, boolean isStatisticsUpdate, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod, int isPeriodOrYear) throws Throwable {
        BigDecimal reducedAmount = voucherDtl.getReducedMoney();
        if (reducedAmount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal subtractAmount;
            List commitVouchers0500 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(voucherDtl.getSOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0500.getKey()).loadList();
            BigDecimal hasAmount0500 = BigDecimal.ZERO;
            if (commitVouchers0500 != null && !commitVouchers0500.isEmpty()) {
                for (EFM_CommitVoucherDtl efmCommitVoucher : commitVouchers0500) {
                    hasAmount0500 = hasAmount0500.add(efmCommitVoucher.getFMAreaCurrencyMoney());
                }
            }
            BigDecimal totalAmount = voucherDtl.getTotalMoney();
            int isNagetive = earmarkedFundVoucher.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed();
            BigDecimal bigDecimal = subtractAmount = isNagetive == 0 ? totalAmount.subtract(reducedAmount) : totalAmount.subtract(reducedAmount).negate();
            if (subtractAmount.compareTo(BigDecimal.ZERO) < 0) {
                this.judgeTolerance(earmarkedFundVoucher, voucherDtl, voucherDtl, subtractAmount, totalAmount);
                this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, subtractAmount.negate().subtract(hasAmount0500), isStatisticsUpdate, isPeriodOrYear);
            }
        }
    }

    public void genCommitVoucher4ValueAdjust(Long earmarkedFundVoucherID, Long valueAdjustOID) throws Throwable {
        EFM_ValueAdjustment efmValueAdjustmentVoucher;
        FM_ValueAdjustment valueAdjustmentVoucher = FM_ValueAdjustment.parseDocument((RichDocument)this.getDocument());
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherID).load();
        List efmvalueAdjustmentVouchers = valueAdjustmentVoucher.efm_valueAdjustments("IsLatest", (Object)1);
        if (valueAdjustOID == 0L) {
            if (efmvalueAdjustmentVouchers == null || efmvalueAdjustmentVouchers.size() == 0) {
                return;
            }
            if (efmvalueAdjustmentVouchers.size() > 1) {
                MessageFacade.throwException((String)"FM_VALUEADJUSTMENT001");
            }
            efmValueAdjustmentVoucher = (EFM_ValueAdjustment)efmvalueAdjustmentVouchers.get(0);
            efmValueAdjustmentVoucher.setIsLatest(0);
        } else {
            efmValueAdjustmentVoucher = valueAdjustmentVoucher.efm_valueAdjustment(valueAdjustOID);
        }
        EFM_EarmarkedFundVoucherDtl voucherDtl = valueAdjustmentVoucher.efm_earmarkedFundVoucherDtl(efmValueAdjustmentVoucher.getPOID());
        this.genCommitVoucher4ValueAdjust(earmarkedFundVoucher, valueAdjustmentVoucher, voucherDtl, efmValueAdjustmentVoucher);
    }

    public void genCommitVoucher4ValueAdjust(FM_EarmarkedFundVoucher earmarkedFundVoucher, FM_ValueAdjustment valueAdjustmentVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, EFM_ValueAdjustment efmValueAdjustmentVoucher) throws Throwable {
        Long fmLedgerID;
        int fiscalPeriod;
        int fiscalYear;
        Long fmPostDate;
        PeriodFormula periodFormula = new PeriodFormula(this.getMidContext());
        EFM_UpdateProfileDtl updateProfileDtl = this.checkUpdateProfile(earmarkedFundVoucher);
        if (updateProfileDtl == null) {
            return;
        }
        Long fundID = voucherDtl.getFundID();
        Long fundCenterID = voucherDtl.getFundCenterID();
        Long commitItemID = voucherDtl.getCommitmentItemID();
        Long functionScopeID = voucherDtl.getFunctionalAreaID();
        Long fundProgramID = voucherDtl.getFundProgramID();
        this.postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionScopeID, fundProgramID);
        EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID);
        if (commitmentItem.getIsStatisticalCommit() > 0 || voucherDtl.getIsStatistical() > 0) {
            this.isStatisticsUpdate = true;
        }
        this.isAddValue = efmValueAdjustmentVoucher.getIsAddValue();
        BigDecimal diffValueAdjustAmount = this.getDiffValueAdjustAmount(earmarkedFundVoucher, valueAdjustmentVoucher, voucherDtl, efmValueAdjustmentVoucher);
        if (updateProfileDtl.getIsPBActive() > 0 && updateProfileDtl.getIsPBReduce() > 0) {
            fmPostDate = updateProfileDtl.getPBDate().equals("B") ? earmarkedFundVoucher.getPostingDate() : voucherDtl.getDueDate();
            if (this.paymentBudgetValue != 0) {
                fmPostDate = this.paymentBudgetValue == 1 ? earmarkedFundVoucher.getPostingDate() : voucherDtl.getDueDate();
            }
            fiscalYear = periodFormula.getYearByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fiscalPeriod = periodFormula.getPeriodByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fmLedgerID = this.checkPostLedger(voucherDtl, fundID, fmPostDate, fiscalYear, fiscalPeriod, "9F", "9A");
            this.dealCommitVoucher(earmarkedFundVoucher, voucherDtl, this.fmAreaID, this.isPeriodOrYear, this.isStatisticsUpdate, diffValueAdjustAmount, commitmentItem, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, this.isAddValue);
        }
        if (updateProfileDtl.getIsCBActive() > 0 && updateProfileDtl.getIsCBReduce() > 0) {
            fmPostDate = 0L;
            if (updateProfileDtl.getIsCBReduce() > 0) {
                fmPostDate = updateProfileDtl.getCBDate().equals("B") ? earmarkedFundVoucher.getPostingDate() : voucherDtl.getDueDate();
            }
            if (this.commitBudgetValue != 0) {
                fmPostDate = this.commitBudgetValue == 1 ? earmarkedFundVoucher.getPostingDate() : voucherDtl.getDueDate();
            }
            fiscalYear = periodFormula.getYearByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fiscalPeriod = periodFormula.getPeriodByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fmLedgerID = this.checkPostLedger(voucherDtl, fundID, fmPostDate, fiscalYear, fiscalPeriod, "9G", "9B");
            this.dealCommitVoucher(earmarkedFundVoucher, voucherDtl, this.fmAreaID, this.isPeriodOrYear, this.isStatisticsUpdate, diffValueAdjustAmount, commitmentItem, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, this.isAddValue);
        }
        if (!this.accountVoucher.isEmpty()) {
            for (Map.Entry<Long, FM_CommitVoucher> commitVoucherEntry : this.accountVoucher.entrySet()) {
                this.save((AbstractBillEntity)commitVoucherEntry.getValue());
            }
        }
    }

    private BigDecimal getDiffValueAdjustAmount(FM_EarmarkedFundVoucher earmarkedFundVoucher, FM_ValueAdjustment valueAdjustmentVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, EFM_ValueAdjustment efmValueAdjustmentVoucher) throws Throwable {
        BigDecimal afterVoucherTotalAmount;
        BigDecimal afterAmount;
        BigDecimal totalAmount = voucherDtl.getTotalMoney().abs();
        BigDecimal reducedAmount = voucherDtl.getReducedMoney().abs();
        BigDecimal valueAdjustAmount = efmValueAdjustmentVoucher.getValueAdjustMoney().abs();
        BigDecimal voucherTotalAmount = earmarkedFundVoucher.getVoucherTotalMoney().abs();
        BigDecimal diffValueAdjustAmount = valueAdjustAmount;
        EFM_ValueAdjustment ifExistValueAdjustmentVoucher = EFM_ValueAdjustment.loader((RichDocumentContext)this.getMidContext()).OID(efmValueAdjustmentVoucher.getOID()).load();
        int isNagetive = earmarkedFundVoucher.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed();
        if (ifExistValueAdjustmentVoucher == null) {
            if (this.isAddValue > 0) {
                afterAmount = totalAmount.add(valueAdjustAmount);
                afterVoucherTotalAmount = voucherTotalAmount.add(valueAdjustAmount);
            } else {
                afterAmount = totalAmount.subtract(valueAdjustAmount);
                afterVoucherTotalAmount = voucherTotalAmount.subtract(valueAdjustAmount);
            }
        } else {
            BigDecimal oldValueAdjustAmount = ifExistValueAdjustmentVoucher.getValueAdjustMoney().abs();
            diffValueAdjustAmount = valueAdjustAmount.subtract(oldValueAdjustAmount);
            if (this.isAddValue == 0) {
                diffValueAdjustAmount = diffValueAdjustAmount.negate();
            }
            afterAmount = totalAmount.add(diffValueAdjustAmount);
            afterVoucherTotalAmount = voucherTotalAmount.add(diffValueAdjustAmount);
        }
        BigDecimal afterUnClearMoney = afterAmount.subtract(reducedAmount);
        if (afterUnClearMoney.compareTo(BigDecimal.ZERO) > 0) {
            afterUnClearMoney = isNagetive == 0 ? afterUnClearMoney : afterUnClearMoney.negate();
            voucherDtl.setUnclearMoney(afterUnClearMoney);
        } else {
            this.judgeTolerance(earmarkedFundVoucher, voucherDtl, voucherDtl, afterUnClearMoney, afterAmount);
            voucherDtl.setUnclearMoney(BigDecimal.ZERO);
        }
        afterAmount = isNagetive == 0 ? afterAmount : afterAmount.negate();
        afterVoucherTotalAmount = isNagetive == 0 ? afterVoucherTotalAmount : afterVoucherTotalAmount.negate();
        voucherDtl.setTotalMoney(afterAmount);
        valueAdjustmentVoucher.efm_earmarkedFundVoucherHead().setVoucherTotalMoney(afterVoucherTotalAmount);
        return diffValueAdjustAmount;
    }

    public void genCommitVoucher4ManualReduction(Long earmarkedFundVoucherDtlID) throws Throwable {
        FM_ManualReduction manualReduction = FM_ManualReduction.parseDocument((RichDocument)this.getDocument());
        EFM_EarmarkedFundVoucherDtl voucherDtl = manualReduction.efm_earmarkedFundVoucherDtl(earmarkedFundVoucherDtlID);
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.loader((RichDocumentContext)this.getMidContext()).OID(voucherDtl.getSOID()).load();
        List efmManualReductions = manualReduction.efm_manualReductions("IsLatest", (Object)1);
        if (efmManualReductions == null || efmManualReductions.size() == 0) {
            return;
        }
        if (efmManualReductions.size() > 1) {
            MessageFacade.throwException((String)"FM_MANUALREDUCTION004");
        }
        EFM_ManualReduction efmManualReduction = (EFM_ManualReduction)efmManualReductions.get(0);
        efmManualReduction.setIsLatest(0);
        this.genCommitVoucher4ManualReduction(earmarkedFundVoucher, voucherDtl, efmManualReduction);
    }

    public void genCommitVoucher4ManualReduction(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, EFM_ManualReduction efmManualReduction) throws Throwable {
        Long fmLedgerID;
        int fiscalPeriod;
        int fiscalYear;
        Long fmPostDate;
        PeriodFormula periodFormula = new PeriodFormula(this.getMidContext());
        EFM_UpdateProfileDtl updateProfileDtl = this.checkUpdateProfile(earmarkedFundVoucher);
        if (updateProfileDtl == null) {
            return;
        }
        Long fundID = voucherDtl.getFundID();
        Long fundCenterID = voucherDtl.getFundCenterID();
        Long commitItemID = voucherDtl.getCommitmentItemID();
        Long functionScopeID = voucherDtl.getFunctionalAreaID();
        Long fundProgramID = voucherDtl.getFundProgramID();
        this.postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionScopeID, fundProgramID);
        EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID);
        if (commitmentItem.getIsStatisticalCommit() > 0 || voucherDtl.getIsStatistical() > 0) {
            this.isStatisticsUpdate = true;
        }
        if (updateProfileDtl.getIsPBActive() > 0 && updateProfileDtl.getIsPBReduce() > 0) {
            fmPostDate = efmManualReduction.getReducedDate();
            fiscalYear = periodFormula.getYearByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fiscalPeriod = periodFormula.getPeriodByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fmLedgerID = this.checkPostLedger(voucherDtl, fundID, fmPostDate, fiscalYear, fiscalPeriod, "9F", "9A");
            this.dealManualReductionPush(earmarkedFundVoucher, voucherDtl, efmManualReduction, this.fmAreaID, this.isPeriodOrYear, this.isStatisticsUpdate, commitmentItem, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod);
        }
        if (updateProfileDtl.getIsCBActive() > 0 && updateProfileDtl.getIsCBReduce() > 0) {
            fmPostDate = efmManualReduction.getReducedDate();
            fiscalYear = periodFormula.getYearByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fiscalPeriod = periodFormula.getPeriodByCompanyCodeDate(this.companyCodeID, fmPostDate);
            fmLedgerID = this.checkPostLedger(voucherDtl, fundID, fmPostDate, fiscalYear, fiscalPeriod, "9G", "9B");
            this.dealManualReductionPush(earmarkedFundVoucher, voucherDtl, efmManualReduction, this.fmAreaID, this.isPeriodOrYear, this.isStatisticsUpdate, commitmentItem, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod);
        }
        if (!this.accountVoucher.isEmpty()) {
            for (Map.Entry<Long, FM_CommitVoucher> commitVoucherEntry : this.accountVoucher.entrySet()) {
                this.save((AbstractBillEntity)commitVoucherEntry.getValue());
            }
        }
    }

    private void dealManualReductionPush(FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl voucherDtl, EFM_ManualReduction efmManualReduction, Long fmAreaID, int isPeriodOrYear, boolean isStatisticsUpdate, EFM_CommitmentItemHead commitmentItem, Long fmLedgerID, Long fmPostDate, int fiscalYear, int fiscalPeriod) throws Throwable {
        FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).load();
        if (fmCommitVoucher != null) {
            List commitVouchers = fmCommitVoucher.efm_commitVoucherDtls("IsLatest", (Object)1);
            for (EFM_CommitVoucherDtl commitVoucher : commitVouchers) {
                int isNagetive;
                BigDecimal subtractAmount;
                FM_Ledger fmLedger;
                if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
                this.accountVoucher.put(voucherDtl.getOID(), fmCommitVoucher);
                BigDecimal totalAmount = voucherDtl.getTotalMoney();
                BigDecimal reducedAmount = voucherDtl.getReducedMoney();
                BigDecimal manualReducedAmount = efmManualReduction.getReducedMoney();
                EFM_ManualReduction ifExistManualReduction = EFM_ManualReduction.loader((RichDocumentContext)this.getMidContext()).OID(efmManualReduction.getOID()).load();
                BigDecimal diffAmount = ifExistManualReduction != null ? manualReducedAmount.subtract(ifExistManualReduction.getReducedMoney()) : manualReducedAmount;
                BigDecimal allReduceAmount = diffAmount.add(reducedAmount);
                if (this.updateProfileTimes > 1 && (fmLedger = FM_Ledger.load((RichDocumentContext)this.getMidContext(), (Long)fmLedgerID)).getCode().equals("9B")) {
                    allReduceAmount = reducedAmount;
                }
                BigDecimal bigDecimal = subtractAmount = (isNagetive = earmarkedFundVoucher.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed()) == 0 ? totalAmount.subtract(allReduceAmount) : totalAmount.subtract(allReduceAmount).negate();
                if (diffAmount.compareTo(BigDecimal.ZERO) != 0) {
                    if (subtractAmount.compareTo(BigDecimal.ZERO) >= 0) {
                        voucherDtl.setUnclearMoney(subtractAmount);
                    } else {
                        voucherDtl.setUnclearMoney(BigDecimal.ZERO);
                    }
                    voucherDtl.setReducedMoney(allReduceAmount);
                }
                if (isPeriodOrYear == Integer.parseInt("1")) {
                    List efmCommitVouchers0500;
                    if (commitmentItem.getFinancialBusiness() != 30) {
                        return;
                    }
                    List efmCommitVouchers0200 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0200.getKey()).loadList();
                    if (efmCommitVouchers0200 != null && !efmCommitVouchers0200.isEmpty()) {
                        for (EFM_CommitVoucherDtl efmCommitVoucher : efmCommitVouchers0200) {
                            fmCommitVoucher.deleteEFM_CommitVoucherDtl(efmCommitVoucher);
                        }
                    }
                    if ((efmCommitVouchers0500 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0500.getKey()).loadList()) != null) {
                        for (EFM_CommitVoucherDtl efmCommitVoucher : efmCommitVouchers0500) {
                            fmCommitVoucher.deleteEFM_CommitVoucherDtl(efmCommitVoucher);
                        }
                    }
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0200.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, allReduceAmount.negate(), isStatisticsUpdate, isPeriodOrYear);
                    if (subtractAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                    this.judgeTolerance(earmarkedFundVoucher, voucherDtl, voucherDtl, subtractAmount, totalAmount);
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, subtractAmount.negate(), isStatisticsUpdate, isPeriodOrYear);
                    continue;
                }
                BigDecimal sendAmount = this.getSendAmount(earmarkedFundVoucher.getOID(), voucherDtl.getOID(), fmLedgerID, commitVoucher.getPostAddress());
                if (commitmentItem.getFinancialBusiness() != 30) {
                    this.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0150.getKey(), commitVoucher, voucherDtl, sendAmount.negate(), isPeriodOrYear);
                    return;
                }
                BigDecimal hasAmount0500 = BigDecimal.ZERO;
                List efmCommitVouchers0500 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(voucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0500.getKey()).loadList();
                if (efmCommitVouchers0500 != null) {
                    for (EFM_CommitVoucherDtl efmCommitVoucher : efmCommitVouchers0500) {
                        hasAmount0500 = hasAmount0500.add(efmCommitVoucher.getFMAreaCurrencyMoney());
                    }
                }
                for (EFM_CommitVoucherDtl voucher : fmCommitVoucher.efm_commitVoucherDtls()) {
                    voucher.setPostingDate(fmPostDate);
                }
                if (diffAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                this.genEFCommitVoucher(AmountTypeEnum.AmountType_0200.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, diffAmount.negate(), isStatisticsUpdate, isPeriodOrYear);
                if (subtractAmount.compareTo(BigDecimal.ZERO) < 0) {
                    this.judgeTolerance(earmarkedFundVoucher, voucherDtl, voucherDtl, subtractAmount, totalAmount);
                    this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, subtractAmount.negate().subtract(hasAmount0500), isStatisticsUpdate, isPeriodOrYear);
                    continue;
                }
                if (subtractAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.genEFCommitVoucher(AmountTypeEnum.AmountType_0500.getKey(), earmarkedFundVoucher.efm_earmarkedFundVoucherHead(), voucherDtl, fmAreaID, fmLedgerID, fmPostDate, fiscalYear, fiscalPeriod, hasAmount0500.negate(), isStatisticsUpdate, isPeriodOrYear);
            }
        }
    }

    public void deleteFMCommitVoucher4EarFund() throws Throwable {
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.parseDocument((RichDocument)this.getDocument());
        List earmarkedFundVoucherDtls = earmarkedFundVoucher.efm_earmarkedFundVoucherDtls();
        if (earmarkedFundVoucherDtls != null && earmarkedFundVoucherDtls.size() > 0) {
            for (EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl : earmarkedFundVoucherDtls) {
                FM_CommitVoucher fmCommitVoucher;
                BigDecimal reducedAmount = earmarkedFundVoucherDtl.getReducedMoney();
                String documentNumber = earmarkedFundVoucher.getDocumentNumber();
                if (reducedAmount.compareTo(BigDecimal.ZERO) != 0) {
                    MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA001", (Object[])new Object[]{documentNumber});
                }
                if (earmarkedFundVoucherDtl.getFundsReservationDtlOID() != 0L) {
                    MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA002", (Object[])new Object[]{documentNumber});
                }
                if (earmarkedFundVoucherDtl.getFundsPrecommitmentDtlOID() != 0L) {
                    MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA003", (Object[])new Object[]{documentNumber});
                }
                if ((fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(earmarkedFundVoucherDtl.getSOID()).ReferItemOID(earmarkedFundVoucherDtl.getOID()).load()) == null) continue;
                fmCommitVoucher.document.evaluate("Macro_MidDelete()", "\u5220\u9664\u627f\u8bfa\u8868\u5355");
            }
        }
    }

    public void deleteFMCommitVoucher4EarFundDtl() throws Throwable {
        if (this.getDocument().isNew()) {
            return;
        }
        FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.parseDocument((RichDocument)this.getDocument());
        DataTable earmarkedFundVoucherDtl = earmarkedFundVoucher.getDataTable("EFM_EarmarkedFundVoucherDtl");
        earmarkedFundVoucherDtl.setShowDeleted(true);
        earmarkedFundVoucherDtl.beforeFirst();
        while (earmarkedFundVoucherDtl.next()) {
            FM_CommitVoucher fmCommitVoucher;
            if (earmarkedFundVoucherDtl.getState() != 3) continue;
            Long dtlOID = earmarkedFundVoucherDtl.getLong("OID");
            BigDecimal reducedAmount = earmarkedFundVoucherDtl.getNumeric("ReducedMoney");
            String dtlDocumentNumber = earmarkedFundVoucherDtl.getString("DetailNumber");
            Long fundsReservationDtlID = earmarkedFundVoucherDtl.getLong("FundsReservationDtlOID");
            Long fundsPrecommitmentDtlID = earmarkedFundVoucherDtl.getLong("FundsPrecommitmentDtlOID");
            if (reducedAmount.compareTo(BigDecimal.ZERO) != 0) {
                MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA001", (Object[])new Object[]{dtlDocumentNumber});
            }
            if (fundsReservationDtlID != 0L) {
                MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA002", (Object[])new Object[]{dtlDocumentNumber});
            }
            if (fundsPrecommitmentDtlID != 0L) {
                MessageFacade.throwException((String)"EFCOMMITVOUCHERFORMULA003", (Object[])new Object[]{dtlDocumentNumber});
            }
            if ((fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(dtlOID).load()) == null) continue;
            fmCommitVoucher.document.evaluate("Macro_MidDelete()", "\u5220\u9664\u627f\u8bfa\u8868\u5355");
        }
        earmarkedFundVoucherDtl.setShowDeleted(false);
    }

    public String getComboxItems4VoucherCategory(String valueList) {
        String[] valueLists;
        if (valueList.isEmpty()) {
            return this.getComboxItems4VoucherCategory();
        }
        StringBuilder str = new StringBuilder();
        String[] stringArray = valueLists = valueList.split(";");
        int n = valueLists.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (str.length() > 0) {
                str.append(";");
            }
            str.append(String.format("%s,%s", value, FMComboxConstant.VoucherCategory_Map.get(value)));
            ++n2;
        }
        return str.toString();
    }

    private String getComboxItems4VoucherCategory() {
        String str = "";
        str = "2,\u57fa\u91d1\u8f6c\u8d26";
        str = String.valueOf(str) + ";20,\u57fa\u91d1\u51bb\u7ed3";
        str = String.valueOf(str) + ";30,\u57fa\u91d1\u50a8\u5907";
        str = String.valueOf(str) + ";40,\u9884\u627f\u8bfa\u57fa\u91d1";
        str = String.valueOf(str) + ";50,\u627f\u8bfa\u57fa\u91d1";
        str = String.valueOf(str) + ";60,\u6536\u5165\u9884\u6d4b";
        return str;
    }
}

