/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.bcs;

import com.bokesoft.erp.billentity.ECO_Version;
import com.bokesoft.erp.billentity.EFM_AVCPostLedger;
import com.bokesoft.erp.billentity.EFM_AVControl;
import com.bokesoft.erp.billentity.EFM_AVControl_Loader;
import com.bokesoft.erp.billentity.EFM_ActualFilter;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_AddressObject;
import com.bokesoft.erp.billentity.EFM_BCSLedgerList;
import com.bokesoft.erp.billentity.EFM_BCSLedgerList_Loader;
import com.bokesoft.erp.billentity.EFM_BudgetFilter;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherDtl;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherDtl_Loader;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherPeriod;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl_Loader;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_FundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_FundVoucherDtl_Loader;
import com.bokesoft.erp.billentity.FM_AVControl;
import com.bokesoft.erp.billentity.FM_RebuildControl;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.avc.AvcPostLedgerFormula;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.bcs.ControlAddressFormula;
import com.bokesoft.erp.fm.enums.BudgetStatusEnum;
import com.bokesoft.erp.fm.enums.ReferDocTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentDefaultCmd;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.parameterizedsql.SqlStringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;

public class RebuildBudgetControl
extends EntityContextAction {
    Map<Long, List<Map<String, Object>>> threadLocalData = null;

    public RebuildBudgetControl(RichDocumentContext _context) {
        super(_context);
    }

    public void rebuildBudgetControl() throws Throwable {
        List bcsLedgerLists;
        FM_RebuildControl rebuildControl = FM_RebuildControl.parseDocument((RichDocument)this.getDocument());
        Long fmAreaID = rebuildControl.getFinancialManagementAreaID();
        int fiscalYear = rebuildControl.getFiscalYear();
        String fromFundCode = rebuildControl.getFromFundCode();
        String toFundCode = rebuildControl.getToFundCode();
        String fromControlLedgerCode = rebuildControl.getFromControlLedgerCode();
        String toControlLedgerCode = rebuildControl.getToControlLedgerCode();
        String recordType = rebuildControl.getRecordType2();
        int rebuildIndex = rebuildControl.getIsRebuildIndex();
        int isTest = rebuildControl.getIsTest();
        EFM_BCSLedgerList_Loader ledgerListLoader = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext());
        if (!fromControlLedgerCode.equals("") && !toControlLedgerCode.equals("")) {
            ledgerListLoader.ControlLedgerCode(">=", fromControlLedgerCode);
        } else if (!fromControlLedgerCode.equals("")) {
            ledgerListLoader.ControlLedgerCode(fromControlLedgerCode);
        }
        if (!toControlLedgerCode.equals("")) {
            ledgerListLoader.ControlLedgerCode("<=", toControlLedgerCode);
        }
        if ((bcsLedgerLists = ledgerListLoader.loadList()) == null || bcsLedgerLists.isEmpty()) {
            MessageFacade.throwException((String)"REBUILDBUDGETCONTROL004");
        }
        this.threadLocalData = new HashedMap();
        if (recordType.equals("2") || recordType.equals("1")) {
            this.rebuildRecordType1(fmAreaID, fiscalYear, fromFundCode, toFundCode, rebuildIndex, isTest, bcsLedgerLists);
        }
        if (recordType.equals("2") || recordType.equals("0")) {
            this.rebuildRecordType0(fmAreaID, fiscalYear, fromFundCode, toFundCode, rebuildIndex, isTest, bcsLedgerLists);
        }
        if (isTest == 0 && !this.threadLocalData.isEmpty()) {
            RichDocumentDefaultCmd.setThreadLocalData((String)"NeedFMCheck", this.threadLocalData);
        }
        MessageFacade.push((String)"REBUILDBUDGETCONTROL005");
    }

    private void rebuildRecordType0(Long fmAreaID, int fiscalYear, String fromFundCode, String toFundCode, int rebuildIndex, int isTest, List<EFM_BCSLedgerList> bcsLedgerLists) throws Throwable {
        ArrayList<Long> deleteLedgerID = new ArrayList<Long>();
        HashMap<String, EFM_AVControl> voucher2AVC = new HashMap<String, EFM_AVControl>();
        ECO_Version version = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load();
        Long versionID = version.getOID();
        String budgetLedgerIDs = "";
        String postLedgerIDs = "";
        for (EFM_BCSLedgerList eFM_BCSLedgerList : bcsLedgerLists) {
            EFM_AVCPostLedger avcPostLedger;
            Long controlLedgerID = eFM_BCSLedgerList.getControlLedgerID();
            Long budgetLedgerID = eFM_BCSLedgerList.getBudgetLedgerID();
            Long postLedgerID = eFM_BCSLedgerList.getPostLedgerID();
            List<Map<String, Object>> postLedger2ControlAddress = this.threadLocalData.get(postLedgerID);
            if (postLedger2ControlAddress == null) {
                postLedger2ControlAddress = new ArrayList<Map<String, Object>>();
            }
            if ((avcPostLedger = EFM_AVCPostLedger.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).load()) == null || avcPostLedger.getAVCStatus().equals("N")) {
                deleteLedgerID.add(controlLedgerID);
                budgetLedgerIDs = "".equals(budgetLedgerIDs) ? budgetLedgerID.toString() : String.valueOf(budgetLedgerIDs) + "," + budgetLedgerID;
                if ("".equals(postLedgerIDs)) {
                    postLedgerIDs = postLedgerID.toString();
                    continue;
                }
                postLedgerIDs = String.valueOf(postLedgerIDs) + "," + postLedgerID;
                continue;
            }
            List actualFilters = EFM_ActualFilter.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).loadList();
            if (actualFilters != null && !actualFilters.isEmpty()) {
                for (EFM_ActualFilter actualFilter : actualFilters) {
                    String valueType = actualFilter.getValueType();
                    this.dealFilterVouchers(postLedger2ControlAddress, postLedgerID, fmAreaID, fiscalYear, fromFundCode, toFundCode, isTest, voucher2AVC, controlLedgerID, valueType);
                    this.dealUnFilterVouchers(postLedger2ControlAddress, postLedgerID, fmAreaID, fiscalYear, fromFundCode, toFundCode, rebuildIndex, isTest, voucher2AVC, versionID, controlLedgerID, budgetLedgerID, valueType);
                }
            } else {
                this.dealUnFilterVouchers(postLedger2ControlAddress, postLedgerID, fmAreaID, fiscalYear, fromFundCode, toFundCode, rebuildIndex, isTest, voucher2AVC, versionID, controlLedgerID, budgetLedgerID, "");
            }
            this.threadLocalData.put(postLedgerID, postLedger2ControlAddress);
        }
        if (isTest == 0) {
            if (!deleteLedgerID.isEmpty()) {
                for (Long l : deleteLedgerID) {
                    EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(l).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).RecordType(0).delete();
                    this.updateVoucherFlag(fmAreaID, fiscalYear, budgetLedgerIDs, postLedgerIDs);
                }
            }
            if (!voucher2AVC.isEmpty()) {
                for (Map.Entry entry : voucher2AVC.entrySet()) {
                    EFM_AVControl avControl = (EFM_AVControl)entry.getValue();
                    FM_AVControl fM_avControl = avControl.fM_AVControl;
                    if (fM_avControl != null) {
                        this.save((AbstractBillEntity)fM_avControl);
                        continue;
                    }
                    this.save((AbstractTableEntity)avControl, "FM_AVControl");
                }
            }
        }
    }

    private void dealUnFilterVouchers(List<Map<String, Object>> postLedger2ControlAddress, Long postLedgerID, Long fmAreaID, int fiscalYear, String fromFundCode, String toFundCode, int rebuildIndex, int isTest, Map<String, EFM_AVControl> voucher2AVC, Long versionID, Long controlLedgerID, Long budgetLedgerID, String valueType) throws Throwable {
        EFM_CommitVoucherDtl_Loader commitVoucherLoader = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).LedgerID(postLedgerID).IsUpdate(0);
        if (!valueType.equals("")) {
            commitVoucherLoader.ValueType("!=", valueType);
        }
        this.commitVoucherLoaderSpliceFund(fromFundCode, toFundCode, commitVoucherLoader);
        List commitVouchers = commitVoucherLoader.loadList();
        if (commitVouchers != null && !commitVouchers.isEmpty()) {
            for (EFM_CommitVoucherDtl commitVoucher : commitVouchers) {
                BigDecimal amount;
                int period;
                EFM_AddressIndex controlAddressIndex;
                if (commitVoucher.getStatisticalIdentifier().equals("X")) continue;
                Long fundID = commitVoucher.getToFundID();
                Long fundCenterID = commitVoucher.getToFundCenterID();
                Long commitItemID = commitVoucher.getToCommitmentItemID();
                Long functionAreaID = commitVoucher.getToFunctionalAreaID();
                Long fundProgramID = commitVoucher.getControlFundProgramID();
                Long currencyID = commitVoucher.getCurrencyID();
                String controlAddress = commitVoucher.getControlAddress();
                if (rebuildIndex == 1 && !(controlAddressIndex = new AvcPostLedgerFormula(this.getMidContext()).getControlAddressIndex(commitVoucher.getPostAddress(), fmAreaID, commitVoucher.getLedgerID(), fiscalYear, controlLedgerID, budgetLedgerID)).getToObjectNumber().equals(commitVoucher.getControlAddress())) {
                    EFM_AVControl oldAVC = voucher2AVC.get(controlAddress);
                    if (oldAVC == null) {
                        oldAVC = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(fundID).FundCenterID(fundCenterID).CommitmentItemID(commitItemID).FunctionalAreaID(functionAreaID).FundProgramID(fundProgramID).RecordType(0).load();
                    }
                    if (oldAVC != null) {
                        period = commitVoucher.getFiscalPeriod();
                        amount = commitVoucher.getFMAreaCurrencyMoney();
                        this.changeAvcAmout(amount, period, oldAVC, false);
                        voucher2AVC.put(controlAddress, oldAVC);
                    }
                    fundID = controlAddressIndex.getToFundID();
                    fundCenterID = controlAddressIndex.getToFundCenterID();
                    commitItemID = controlAddressIndex.getToCommitmentItemID();
                    functionAreaID = controlAddressIndex.getToFunctionalAreaID();
                    fundProgramID = controlAddressIndex.getToFundProgramID();
                    controlAddress = controlAddressIndex.getToObjectNumber();
                    commitVoucher.setToFundID(fundID);
                    commitVoucher.setToFundCenterID(fundCenterID);
                    commitVoucher.setToCommitmentItemID(commitItemID);
                    commitVoucher.setToFunctionalAreaID(functionAreaID);
                    commitVoucher.setControlFundProgramID(fundProgramID);
                    commitVoucher.setControlAddress(controlAddress);
                }
                this.setThreadLocal2CommitVoucher(postLedger2ControlAddress, fmAreaID, fiscalYear, commitVoucher);
                EFM_AVControl avControl = voucher2AVC.get(controlAddress);
                if (avControl == null) {
                    avControl = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(fundID).FundCenterID(fundCenterID).CommitmentItemID(commitItemID).FunctionalAreaID(functionAreaID).FundProgramID(fundProgramID).RecordType(0).load();
                }
                if (avControl != null) {
                    int period2 = commitVoucher.getFiscalPeriod();
                    BigDecimal amount2 = commitVoucher.getFMAreaCurrencyMoney();
                    this.changeAvcAmout(amount2, period2, avControl, true);
                } else {
                    FM_AVControl fm_avControl = (FM_AVControl)this.newBillEntity(FM_AVControl.class);
                    avControl = fm_avControl.newEFM_AVControl();
                    avControl.setRecordType(0);
                    avControl.setVersionID(versionID);
                    avControl.setLedgerID(controlLedgerID);
                    avControl.setFiscalYear(fiscalYear);
                    avControl.setFinancialManagementAreaID(fmAreaID);
                    avControl.setCurrencyID(currencyID);
                    avControl.setCommitmentItemID(commitItemID);
                    avControl.setFundCenterID(fundCenterID);
                    avControl.setFundID(fundID);
                    avControl.setFunctionalAreaID(functionAreaID);
                    avControl.setFundProgramID(fundProgramID);
                    avControl.setFiscalPeriod(16);
                    avControl.setWorkFlowStatus("P");
                    avControl.setMoneyType("KBFC");
                    period = commitVoucher.getFiscalPeriod();
                    amount = commitVoucher.getFMAreaCurrencyMoney();
                    this.changeAvcAmout(amount, period, avControl, true);
                }
                commitVoucher.setIsUpdate(1);
                voucher2AVC.put(controlAddress, avControl);
            }
            if (isTest == 0) {
                this.save(commitVouchers);
            }
        }
        EFM_FundVoucherDtl_Loader fundVoucherDtlLoader = EFM_FundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).LedgerID(postLedgerID).ValueType("!=", valueType).IsUpdate(0);
        this.fundVoucherDtlLoaderSpliceFund(fromFundCode, toFundCode, fundVoucherDtlLoader);
        List fundVoucherDtls = fundVoucherDtlLoader.loadList();
        if (fundVoucherDtls != null && !fundVoucherDtls.isEmpty()) {
            for (EFM_FundVoucherDtl fundVoucherDtl : fundVoucherDtls) {
                BigDecimal amount;
                int period;
                EFM_AddressIndex controlAddressIndex;
                if (fundVoucherDtl.getStatisticalIdentifier().equals("X")) continue;
                Long fundID = fundVoucherDtl.getToFundID();
                Long fundCenterID = fundVoucherDtl.getToFundCenterID();
                Long commitItemID = fundVoucherDtl.getToCommitmentItemID();
                Long functionAreaID = fundVoucherDtl.getToFunctionalAreaID();
                Long fundProgramID = fundVoucherDtl.getToFundProgramID();
                Long currencyID = fundVoucherDtl.getCurrencyID();
                String controlAddress = fundVoucherDtl.getControlAddress();
                if (rebuildIndex == 1 && !(controlAddressIndex = new AvcPostLedgerFormula(this.getMidContext()).getControlAddressIndex(fundVoucherDtl.getPostAddress(), fmAreaID, fundVoucherDtl.getLedgerID(), fiscalYear, controlLedgerID, budgetLedgerID)).getToObjectNumber().equals(fundVoucherDtl.getControlAddress())) {
                    EFM_AVControl oldAVC = voucher2AVC.get(controlAddress);
                    if (oldAVC == null) {
                        oldAVC = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(fundID).FundCenterID(fundCenterID).CommitmentItemID(commitItemID).FunctionalAreaID(functionAreaID).FundProgramID(fundProgramID).RecordType(0).load();
                    }
                    if (oldAVC != null) {
                        period = fundVoucherDtl.getFiscalPeriod();
                        amount = fundVoucherDtl.getFMAreaCurrencyMoney();
                        this.changeAvcAmout(amount, period, oldAVC, false);
                        voucher2AVC.put(controlAddress, oldAVC);
                    }
                    fundID = controlAddressIndex.getToFundID();
                    fundCenterID = controlAddressIndex.getToFundCenterID();
                    commitItemID = controlAddressIndex.getToCommitmentItemID();
                    functionAreaID = controlAddressIndex.getToFunctionalAreaID();
                    fundProgramID = controlAddressIndex.getToFundProgramID();
                    controlAddress = controlAddressIndex.getToObjectNumber();
                    fundVoucherDtl.setToFundID(fundID);
                    fundVoucherDtl.setToFundCenterID(fundCenterID);
                    fundVoucherDtl.setToCommitmentItemID(commitItemID);
                    fundVoucherDtl.setToFunctionalAreaID(functionAreaID);
                    fundVoucherDtl.setToFundProgramID(fundProgramID);
                    fundVoucherDtl.setControlAddress(controlAddress);
                }
                this.setThreadLocal2FundVoucher(postLedger2ControlAddress, fmAreaID, fiscalYear, fundVoucherDtl);
                EFM_AVControl avControl = voucher2AVC.get(controlAddress);
                if (avControl == null) {
                    avControl = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(fundID).FundCenterID(fundCenterID).CommitmentItemID(commitItemID).FunctionalAreaID(functionAreaID).FundProgramID(fundProgramID).RecordType(0).load();
                }
                if (avControl != null) {
                    int period3 = fundVoucherDtl.getFiscalPeriod();
                    BigDecimal amount3 = fundVoucherDtl.getFMAreaCurrencyMoney();
                    this.changeAvcAmout(amount3, period3, avControl, true);
                } else {
                    FM_AVControl fm_avControl = (FM_AVControl)this.newBillEntity(FM_AVControl.class);
                    avControl = fm_avControl.newEFM_AVControl();
                    avControl.setRecordType(0);
                    avControl.setVersionID(versionID);
                    avControl.setLedgerID(controlLedgerID);
                    avControl.setFiscalYear(fiscalYear);
                    avControl.setFinancialManagementAreaID(fmAreaID);
                    avControl.setCurrencyID(currencyID);
                    avControl.setCommitmentItemID(commitItemID);
                    avControl.setFundCenterID(fundCenterID);
                    avControl.setFundID(fundID);
                    avControl.setFunctionalAreaID(functionAreaID);
                    avControl.setFundProgramID(fundProgramID);
                    avControl.setFiscalPeriod(16);
                    avControl.setWorkFlowStatus("P");
                    avControl.setMoneyType("KBFC");
                    period = fundVoucherDtl.getFiscalPeriod();
                    amount = fundVoucherDtl.getFMAreaCurrencyMoney();
                    this.changeAvcAmout(amount, period, avControl, true);
                }
                fundVoucherDtl.setIsUpdate(1);
                voucher2AVC.put(controlAddress, avControl);
            }
            if (isTest == 0) {
                this.save(fundVoucherDtls);
            }
        }
    }

    private void setThreadLocal2FundVoucher(List<Map<String, Object>> postLedger2ControlAddress, Long fmAreaID, int fiscalYear, EFM_FundVoucherDtl fundVoucherDtl) throws Throwable {
        String highType = "";
        EFM_CommitmentItemHead commitmentItem = fundVoucherDtl.getCommitmentItem();
        highType = commitmentItem.getCommitmentItemType() == 2 ? "I" : "S";
        HashMap<String, Object> objectHashMap = new HashMap<String, Object>();
        objectHashMap.put("ControlAddress", fundVoucherDtl.getControlAddress());
        objectHashMap.put("ActivityGroupID", "40");
        objectHashMap.put("HighType", highType);
        objectHashMap.put("FinancialManagementAreaID", fmAreaID);
        objectHashMap.put("FiscalYear", fiscalYear);
        postLedger2ControlAddress.add(objectHashMap);
    }

    private void setThreadLocal2CommitVoucher(List<Map<String, Object>> postLedger2ControlAddress, Long fmAreaID, int fiscalYear, EFM_CommitVoucherDtl commitVoucher) throws Throwable {
        String referDocType = commitVoucher.getReferDocType();
        String activeGroupCode = "";
        String highType = "S";
        if (referDocType.equals(ReferDocTypeEnum.PurchaseApplication.getKey())) {
            activeGroupCode = "20";
        } else if (referDocType.equals(ReferDocTypeEnum.PurchaseOrder.getKey())) {
            activeGroupCode = "30";
        } else if (referDocType.equals(ReferDocTypeEnum.SaleOrder.getKey())) {
            activeGroupCode = "15";
            highType = "I";
        } else if (referDocType.equals(ReferDocTypeEnum.EarmarkedFund.getKey())) {
            activeGroupCode = "10";
        } else {
            MessageFacade.throwException((String)"REBUILDBUDGETCONTROL001");
        }
        HashMap<String, Object> objectHashMap = new HashMap<String, Object>();
        objectHashMap.put("ControlAddress", commitVoucher.getControlAddress());
        objectHashMap.put("ActivityGroupID", activeGroupCode);
        objectHashMap.put("HighType", highType);
        objectHashMap.put("FinancialManagementAreaID", fmAreaID);
        objectHashMap.put("FiscalYear", fiscalYear);
        postLedger2ControlAddress.add(objectHashMap);
    }

    private void dealFilterVouchers(List<Map<String, Object>> postLedger2ControlAddress, Long postLedgerID, Long fmAreaID, int fiscalYear, String fromFundCode, String toFundCode, int isTest, Map<String, EFM_AVControl> voucher2AVC, Long controlLedgerID, String valueType) throws Throwable {
        EFM_CommitVoucherDtl_Loader commitVoucherLoader = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(postLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).ValueType(valueType).IsUpdate(1);
        this.commitVoucherLoaderSpliceFund(fromFundCode, toFundCode, commitVoucherLoader);
        List commitVouchers = commitVoucherLoader.loadList();
        if (commitVouchers != null && !commitVouchers.isEmpty()) {
            for (EFM_CommitVoucherDtl commitVoucher : commitVouchers) {
                if (commitVoucher.getStatisticalIdentifier().equals("X")) continue;
                this.setThreadLocal2CommitVoucher(postLedger2ControlAddress, fmAreaID, fiscalYear, commitVoucher);
                EFM_AVControl avControl = voucher2AVC.get(commitVoucher.getControlAddress());
                if (avControl == null) {
                    avControl = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(commitVoucher.getToFundID()).FundCenterID(commitVoucher.getToFundCenterID()).CommitmentItemID(commitVoucher.getToCommitmentItemID()).FunctionalAreaID(commitVoucher.getToFunctionalAreaID()).FundProgramID(commitVoucher.getControlFundProgramID()).RecordType(0).load();
                }
                if (avControl != null) {
                    int period = commitVoucher.getFiscalPeriod();
                    BigDecimal amount = commitVoucher.getFMAreaCurrencyMoney();
                    this.changeAvcAmout(amount, period, avControl, false);
                    commitVoucher.setIsUpdate(0);
                    voucher2AVC.put(commitVoucher.getControlAddress(), avControl);
                    continue;
                }
                MessageFacade.throwException((String)"REBUILDBUDGETCONTROL002");
            }
            if (isTest == 0) {
                this.save(commitVouchers);
            }
        }
        EFM_FundVoucherDtl_Loader fundVoucherDtlLoader = EFM_FundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).LedgerID(postLedgerID).ValueType(valueType).IsUpdate(1);
        this.fundVoucherDtlLoaderSpliceFund(fromFundCode, toFundCode, fundVoucherDtlLoader);
        List fundVoucherDtls = fundVoucherDtlLoader.loadList();
        if (fundVoucherDtls != null && !fundVoucherDtls.isEmpty()) {
            for (EFM_FundVoucherDtl fundVoucherDtl : fundVoucherDtls) {
                if (fundVoucherDtl.getStatisticalIdentifier().equals("X")) continue;
                this.setThreadLocal2FundVoucher(postLedger2ControlAddress, fmAreaID, fiscalYear, fundVoucherDtl);
                EFM_AVControl avControl = voucher2AVC.get(fundVoucherDtl.getControlAddress());
                if (avControl == null) {
                    avControl = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(fundVoucherDtl.getToFundID()).FundCenterID(fundVoucherDtl.getToFundCenterID()).CommitmentItemID(fundVoucherDtl.getToCommitmentItemID()).FunctionalAreaID(fundVoucherDtl.getToFunctionalAreaID()).FundProgramID(fundVoucherDtl.getToFundProgramID()).RecordType(0).load();
                }
                if (avControl != null) {
                    int period = fundVoucherDtl.getFiscalPeriod();
                    BigDecimal amount = fundVoucherDtl.getFMAreaCurrencyMoney();
                    this.changeAvcAmout(amount, period, avControl, false);
                    fundVoucherDtl.setIsUpdate(0);
                    voucher2AVC.put(fundVoucherDtl.getControlAddress(), avControl);
                    continue;
                }
                MessageFacade.throwException((String)"REBUILDBUDGETCONTROL002");
            }
            if (isTest == 0) {
                this.save(fundVoucherDtls);
            }
        }
    }

    private void rebuildRecordType1(Long fmAreaID, int fiscalYear, String fromFundCode, String toFundCode, int rebuildIndex, int isTest, List<EFM_BCSLedgerList> bcsLedgerLists) throws Throwable {
        ArrayList<Long> deleteLedgerID = new ArrayList<Long>();
        HashMap<String, EFM_AVControl> avControlMap = new HashMap<String, EFM_AVControl>();
        ECO_Version version = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load();
        Long versionID = version.getOID();
        String budgetLedgerIDs = "";
        String postLedgerIDs = "";
        for (EFM_BCSLedgerList eFM_BCSLedgerList : bcsLedgerLists) {
            Long controlLedgerID = eFM_BCSLedgerList.getControlLedgerID();
            Long postLedgerID = eFM_BCSLedgerList.getPostLedgerID();
            Long budgetLedgerID = eFM_BCSLedgerList.getBudgetLedgerID();
            EFM_AVCPostLedger avcPostLedger = EFM_AVCPostLedger.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).load();
            if (avcPostLedger == null || avcPostLedger.getAVCStatus().equals("N")) {
                deleteLedgerID.add(controlLedgerID);
                budgetLedgerIDs = "".equals(budgetLedgerIDs) ? budgetLedgerID.toString() : String.valueOf(budgetLedgerIDs) + "," + budgetLedgerID;
                if ("".equals(postLedgerIDs)) {
                    postLedgerIDs = postLedgerID.toString();
                    continue;
                }
                postLedgerIDs = String.valueOf(postLedgerIDs) + "," + postLedgerID;
                continue;
            }
            List<Map<String, Object>> postLedger2ControlAddress = this.threadLocalData.get(postLedgerID);
            if (postLedger2ControlAddress == null) {
                postLedger2ControlAddress = new ArrayList<Map<String, Object>>();
            }
            String workFlowStatus = "P";
            String bcsValType = "R1";
            EFM_BudgetFilter budgetFilter = EFM_BudgetFilter.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).LedgerID(controlLedgerID).load();
            if (budgetFilter != null) {
                workFlowStatus = budgetFilter.getWorkFlowStatus();
                versionID = budgetFilter.getVersionID() == 0L ? versionID : budgetFilter.getVersionID();
                bcsValType = budgetFilter.getBCSValType();
            }
            this.dealHasUpdatedAVC(fmAreaID, fiscalYear, fromFundCode, toFundCode, rebuildIndex, isTest, avControlMap, versionID, controlLedgerID, budgetLedgerID, postLedger2ControlAddress, workFlowStatus, bcsValType);
            this.dealNotHadUpdateAVC(fmAreaID, fiscalYear, fromFundCode, toFundCode, rebuildIndex, isTest, avControlMap, versionID, controlLedgerID, budgetLedgerID, postLedger2ControlAddress, workFlowStatus, bcsValType);
            this.threadLocalData.put(postLedgerID, postLedger2ControlAddress);
        }
        if (isTest == 0) {
            if (!deleteLedgerID.isEmpty()) {
                for (Long l : deleteLedgerID) {
                    EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(l).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).RecordType(1).delete();
                    this.updateVoucherFlag(fmAreaID, fiscalYear, budgetLedgerIDs, postLedgerIDs);
                }
            }
            if (!avControlMap.isEmpty()) {
                for (Map.Entry entry : avControlMap.entrySet()) {
                    EFM_AVControl avControl = (EFM_AVControl)entry.getValue();
                    FM_AVControl fMAvControl = avControl.fM_AVControl;
                    if (fMAvControl != null) {
                        this.save((AbstractBillEntity)fMAvControl);
                        continue;
                    }
                    this.save((AbstractTableEntity)avControl, "FM_AVControl");
                }
            }
        }
    }

    private void dealHasUpdatedAVC(Long fmAreaID, int fiscalYear, String fromFundCode, String toFundCode, int rebuildIndex, int isTest, Map<String, EFM_AVControl> avControlMap, Long versionID, Long controlLedgerID, Long budgetLedgerID, List<Map<String, Object>> postLedger2ControlAddress, String workFlowStatus, String bcsValType) throws Throwable {
        EFM_BudgetVoucherDtl_Loader detailLoaderUpdatedAvc = EFM_BudgetVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FiscalYear(fiscalYear).HasUpdatedAVC(1).BudgetLedgerID(budgetLedgerID);
        this.budgetVoucherDetailLoaderSpliceFund(toFundCode, fromFundCode, detailLoaderUpdatedAvc);
        List updateAvcVoucherDetails = detailLoaderUpdatedAvc.loadList();
        if (updateAvcVoucherDetails != null && !updateAvcVoucherDetails.isEmpty()) {
            for (EFM_BudgetVoucherDtl voucherDetail : updateAvcVoucherDetails) {
                this.setThreadLocalMap(fmAreaID, fiscalYear, rebuildIndex, isTest, controlLedgerID, budgetLedgerID, postLedger2ControlAddress, voucherDetail);
                String controlAddress = !postLedger2ControlAddress.isEmpty() ? String.valueOf(postLedger2ControlAddress.get(0).get("ControlAddress")) : voucherDetail.getBudgetAddress();
                List voucherPeriods = EFM_BudgetVoucherPeriod.loader((RichDocumentContext)this.getMidContext()).POID(voucherDetail.getOID()).loadList();
                EFM_AVControl avControl = avControlMap.get(String.valueOf(voucherDetail.getBudgetAddress()) + voucherDetail.getDtl_Status());
                if (avControl == null) {
                    EFM_AVControl_Loader efmAvControlLoader = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(voucherDetail.getControlFundID()).FundCenterID(voucherDetail.getControlFundCenterID()).CommitmentItemID(voucherDetail.getControlCommitmentItemID()).FunctionalAreaID(voucherDetail.getControlFunctionalAreaID()).FundProgramID(voucherDetail.getControlFundProgramID()).RecordType(1);
                    avControl = voucherDetail.getDtl_Status() == BudgetStatusEnum.Status_01.getKey() ? efmAvControlLoader.WorkFlowStatus("P").load() : efmAvControlLoader.WorkFlowStatus("!=", "P").load();
                }
                if (avControl != null) {
                    boolean isStatusEligible;
                    String avControlAddress = new AddressUtils(this.getMidContext()).genAddress(avControl.getFundID(), avControl.getFundCenterID(), avControl.getCommitmentItemID(), avControl.getFunctionalAreaID(), avControl.getFundProgramID());
                    boolean bl = isStatusEligible = workFlowStatus.equals("ALL") || workFlowStatus.equals("P") && voucherDetail.getDtl_Status() == BudgetStatusEnum.Status_01.getKey();
                    if (voucherDetail.getBCSValType().equals(bcsValType) && voucherDetail.getVersionID().compareTo(versionID) == 0 && isStatusEligible && avControlAddress.equals(controlAddress)) continue;
                    voucherDetail.setHasUpdatedAVC(0);
                    for (EFM_BudgetVoucherPeriod voucherPeriod : voucherPeriods) {
                        int period = voucherPeriod.getFiscalPeriod();
                        BigDecimal amount = voucherPeriod.getBudgetMoney().multiply(new BigDecimal(voucherPeriod.getDirection()));
                        this.changeAvcAmout(amount, period, avControl, false);
                    }
                } else {
                    MessageFacade.throwException((String)"REBUILDBUDGETCONTROL003");
                }
                avControlMap.put(String.valueOf(voucherDetail.getBudgetAddress()) + voucherDetail.getDtl_Status(), avControl);
            }
            if (isTest == 0) {
                this.save(updateAvcVoucherDetails);
            }
        }
    }

    private void dealNotHadUpdateAVC(Long fmAreaID, int fiscalYear, String fromFundCode, String toFundCode, int rebuildIndex, int isTest, Map<String, EFM_AVControl> avControlMap, Long versionID, Long controlLedgerID, Long budgetLedgerID, List<Map<String, Object>> postLedger2ControlAddress, String workFlowStatus, String bcsValType) throws Throwable {
        EFM_BudgetVoucherDtl_Loader detailLoaderNotAvc = EFM_BudgetVoucherDtl.loader((RichDocumentContext)this.getMidContext()).FiscalYear(fiscalYear).BudgetLedgerID(budgetLedgerID).HasUpdatedAVC(0).BCSValType(bcsValType).VersionID(versionID);
        if (workFlowStatus.equals("P")) {
            detailLoaderNotAvc.Dtl_Status(1);
        }
        this.budgetVoucherDetailLoaderSpliceFund(toFundCode, fromFundCode, detailLoaderNotAvc);
        List notAvcVoucherDetails = detailLoaderNotAvc.loadList();
        if (notAvcVoucherDetails != null && !notAvcVoucherDetails.isEmpty()) {
            for (EFM_BudgetVoucherDtl voucherDetail : notAvcVoucherDetails) {
                this.setThreadLocalMap(fmAreaID, fiscalYear, rebuildIndex, isTest, controlLedgerID, budgetLedgerID, postLedger2ControlAddress, voucherDetail);
                voucherDetail.setHasUpdatedAVC(1);
                List voucherPeriods = EFM_BudgetVoucherPeriod.loader((RichDocumentContext)this.getMidContext()).POID(voucherDetail.getOID()).loadList();
                String controlAddress = !postLedger2ControlAddress.isEmpty() ? String.valueOf(postLedger2ControlAddress.get(0).get("ControlAddress")) : String.valueOf(voucherDetail.getBudgetAddress()) + voucherDetail.getDtl_Status();
                EFM_AVControl avControl = avControlMap.get(String.valueOf(controlAddress) + voucherDetail.getDtl_Status());
                EFM_AddressObject addressObject = EFM_AddressObject.loader((RichDocumentContext)this.getMidContext()).ObjectNumber(controlAddress).load();
                if (avControl == null) {
                    EFM_AVControl_Loader efmAvControlLoader = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(addressObject.getFundID()).FundCenterID(addressObject.getFundCenterID()).CommitmentItemID(addressObject.getCommitmentItemID()).FunctionalAreaID(addressObject.getFunctionalAreaID()).FundProgramID(addressObject.getFundProgramID()).RecordType(1);
                    avControl = voucherDetail.getDtl_Status() == BudgetStatusEnum.Status_01.getKey() ? efmAvControlLoader.WorkFlowStatus("P").load() : efmAvControlLoader.WorkFlowStatus("!=", "P").load();
                }
                if (avControl != null) {
                    for (EFM_BudgetVoucherPeriod voucherPeriod : voucherPeriods) {
                        int period = voucherPeriod.getFiscalPeriod();
                        BigDecimal amount = voucherPeriod.getBudgetMoney().multiply(new BigDecimal(voucherPeriod.getDirection()));
                        this.changeAvcAmout(amount, period, avControl, true);
                    }
                } else {
                    FM_AVControl fm_avControl = (FM_AVControl)this.newBillEntity(FM_AVControl.class);
                    avControl = fm_avControl.newEFM_AVControl();
                    avControl.setRecordType(1);
                    avControl.setVersionID(versionID);
                    avControl.setLedgerID(controlLedgerID);
                    avControl.setFiscalYear(fiscalYear);
                    avControl.setFinancialManagementAreaID(fmAreaID);
                    avControl.setCurrencyID(voucherDetail.getTVCurrencyID());
                    avControl.setCommitmentItemID(addressObject.getCommitmentItemID());
                    avControl.setFundCenterID(addressObject.getFundCenterID());
                    avControl.setFundID(addressObject.getFundID());
                    avControl.setFunctionalAreaID(addressObject.getFunctionalAreaID());
                    avControl.setFundProgramID(addressObject.getFundProgramID());
                    avControl.setFiscalPeriod(16);
                    avControl.setWorkFlowStatus("P");
                    avControl.setMoneyType("KBFC");
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    for (EFM_BudgetVoucherPeriod voucherPeriod : voucherPeriods) {
                        int period = voucherPeriod.getFiscalPeriod();
                        BigDecimal amount = voucherPeriod.getBudgetMoney().multiply(new BigDecimal(voucherPeriod.getDirection()));
                        BigDecimal tslAmountPeriod = TypeConvertor.toBigDecimal((Object)avControl.valueByColumnName("TSLMoney" + period)).add(amount);
                        BigDecimal hslAmountPeriod = TypeConvertor.toBigDecimal((Object)avControl.valueByColumnName("HSLMoney" + period)).add(amount);
                        avControl.valueByColumnName("TSLMoney" + period, tslAmountPeriod, 2, RoundingMode.HALF_UP);
                        avControl.valueByColumnName("HSLMoney" + period, hslAmountPeriod, 2, RoundingMode.HALF_UP);
                        totalAmount = totalAmount.add(tslAmountPeriod);
                    }
                    avControl.setTSLMoneyTotal(totalAmount);
                    avControl.setHSLMoneyTotal(totalAmount);
                }
                voucherDetail.setControlFundID(addressObject.getFundID());
                voucherDetail.setControlFundCenterID(addressObject.getFundCenterID());
                voucherDetail.setControlCommitmentItemID(addressObject.getCommitmentItemID());
                voucherDetail.setControlFunctionalAreaID(addressObject.getFunctionalAreaID());
                voucherDetail.setControlFundProgramID(addressObject.getFundProgramID());
                avControlMap.put(String.valueOf(controlAddress) + voucherDetail.getDtl_Status(), avControl);
            }
            if (isTest == 0) {
                this.save(notAvcVoucherDetails);
            }
        }
    }

    private void budgetVoucherDetailLoaderSpliceFund(String toFundCode, String fromFundCode, EFM_BudgetVoucherDtl_Loader detailLoader) throws Throwable {
        if (!"".equals(fromFundCode) && !"".equals(toFundCode)) {
            detailLoader.FundCode(">=", fromFundCode);
        } else if (!"".equals(fromFundCode)) {
            detailLoader.FundCode(fromFundCode);
        }
        if (!"".equals(toFundCode)) {
            detailLoader.FundCode(">=", fromFundCode).FundCode("<=", toFundCode);
        }
    }

    private void fundVoucherDtlLoaderSpliceFund(String fromFundCode, String toFundCode, EFM_FundVoucherDtl_Loader fundVoucherDtlLoader) throws Throwable {
        if (!"".equals(fromFundCode) && !"".equals(toFundCode)) {
            fundVoucherDtlLoader.FundCode(">=", fromFundCode);
        } else if (!"".equals(fromFundCode)) {
            fundVoucherDtlLoader.FundCode(fromFundCode);
        }
        if (!"".equals(toFundCode)) {
            fundVoucherDtlLoader.FundCode(">=", fromFundCode).FundCode("<=", toFundCode);
        }
    }

    private void commitVoucherLoaderSpliceFund(String fromFundCode, String toFundCode, EFM_CommitVoucherDtl_Loader commitVoucherLoader) throws Throwable {
        if (!"".equals(fromFundCode) && !"".equals(toFundCode)) {
            commitVoucherLoader.FundCode(">=", fromFundCode);
        } else if (!"".equals(fromFundCode)) {
            commitVoucherLoader.FundCode(fromFundCode);
        }
        if (!"".equals(toFundCode)) {
            commitVoucherLoader.FundCode(">=", fromFundCode).FundCode("<=", toFundCode);
        }
    }

    private void changeAvcAmout(BigDecimal amount, int period, EFM_AVControl avControl, boolean isAdd) throws Throwable {
        BigDecimal hslAmountPeriod;
        BigDecimal tslAmountPeriod;
        if (isAdd) {
            tslAmountPeriod = TypeConvertor.toBigDecimal((Object)avControl.valueByColumnName("TSLMoney" + period)).add(amount);
            hslAmountPeriod = TypeConvertor.toBigDecimal((Object)avControl.valueByColumnName("HSLMoney" + period)).add(amount);
            avControl.setTSLMoneyTotal(avControl.getTSLMoneyTotal().add(amount));
            avControl.setHSLMoneyTotal(avControl.getHSLMoneyTotal().add(amount));
        } else {
            tslAmountPeriod = TypeConvertor.toBigDecimal((Object)avControl.valueByColumnName("TSLMoney" + period)).subtract(amount);
            hslAmountPeriod = TypeConvertor.toBigDecimal((Object)avControl.valueByColumnName("HSLMoney" + period)).subtract(amount);
            avControl.setTSLMoneyTotal(avControl.getTSLMoneyTotal().subtract(amount));
            avControl.setHSLMoneyTotal(avControl.getHSLMoneyTotal().subtract(amount));
        }
        avControl.valueByColumnName("TSLMoney" + period, tslAmountPeriod, 2, RoundingMode.HALF_UP);
        avControl.valueByColumnName("HSLMoney" + period, hslAmountPeriod, 2, RoundingMode.HALF_UP);
    }

    private void updateVoucherFlag(Long fmAreaID, int fiscalYear, String budgetLedgerIDs, String postLedgerIDs) throws Throwable {
        if (!budgetLedgerIDs.equals("")) {
            SqlString updateBudgetVoucher = new SqlString();
            updateBudgetVoucher.append(new Object[]{"update "}).append(new Object[]{"EFM_BudgetVoucherDtl"}).append(new Object[]{" set "}).append(new Object[]{"HasUpdatedAVC"}).append(new Object[]{" = "}).appendPara((Object)"0").append(new Object[]{" where "}).append(new Object[]{"BudgetLedgerID"}).append(new Object[]{" in ("}).append(new Object[]{SqlStringUtil.genMultiParameters((String)budgetLedgerIDs)}).append(new Object[]{")"}).append(new Object[]{" and "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear);
            this.executeSQL(updateBudgetVoucher);
        }
        if (!postLedgerIDs.equals("")) {
            SqlString updateCommitVoucher = new SqlString();
            updateCommitVoucher.append(new Object[]{"update "}).append(new Object[]{"EFM_CommitVoucherDtl"}).append(new Object[]{" set "}).append(new Object[]{"IsUpdate"}).append(new Object[]{" = "}).appendPara((Object)"0").append(new Object[]{" where "}).append(new Object[]{"LedgerID"}).append(new Object[]{" in ("}).append(new Object[]{SqlStringUtil.genMultiParameters((String)postLedgerIDs)}).append(new Object[]{")"}).append(new Object[]{" and "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear);
            this.executeSQL(updateCommitVoucher);
            SqlString updateFundVoucher = new SqlString();
            updateFundVoucher.append(new Object[]{"update "}).append(new Object[]{"EFM_FundVoucherDtl"}).append(new Object[]{" set "}).append(new Object[]{"IsUpdate"}).append(new Object[]{" = "}).appendPara((Object)"0").append(new Object[]{" where "}).append(new Object[]{"LedgerID"}).append(new Object[]{" in ("}).append(new Object[]{SqlStringUtil.genMultiParameters((String)postLedgerIDs)}).append(new Object[]{")"}).append(new Object[]{" and "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear);
            this.executeSQL(updateFundVoucher);
        }
    }

    private void setThreadLocalMap(Long fmAreaID, int fiscalYear, int rebuildIndex, int isTest, Long controlLedgerID, Long budgetLedgerID, List<Map<String, Object>> postLedger2ControlAddress, EFM_BudgetVoucherDtl voucherDetail) throws Throwable {
        HashMap<String, Object> objectHashMap = new HashMap<String, Object>();
        EFM_AddressIndex addressIndex = EFM_AddressIndex.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear(fiscalYear).FromLedgerID(budgetLedgerID).FromObjectNumber(voucherDetail.getBudgetAddress()).ToLedgerID(controlLedgerID).ToFiscalYear(fiscalYear).load();
        String controlAddress = "";
        controlAddress = addressIndex == null ? new ControlAddressFormula(this.getMidContext()).genBudgetAddress2ControlAddress(fmAreaID, budgetLedgerID, fiscalYear, voucherDetail.getFundID(), voucherDetail.getFundCenterID(), voucherDetail.getCommitmentItemID(), voucherDetail.getFunctionalAreaID(), voucherDetail.getFundProgramID(), voucherDetail.getBudgetAddress(), controlLedgerID) : addressIndex.getToObjectNumber();
        if (rebuildIndex == 1 && isTest == 0) {
            controlAddress = new ControlAddressFormula(this.getMidContext()).genBudgetAddress2ControlAddress(fmAreaID, budgetLedgerID, fiscalYear, voucherDetail.getFundID(), voucherDetail.getFundCenterID(), voucherDetail.getCommitmentItemID(), voucherDetail.getFunctionalAreaID(), voucherDetail.getFundProgramID(), voucherDetail.getBudgetAddress(), controlLedgerID);
        }
        String highType = "";
        highType = voucherDetail.getCommitmentItemType() == 3 ? "S" : "I";
        objectHashMap.put("ControlAddress", controlAddress);
        objectHashMap.put("ActivityGroupID", "++");
        objectHashMap.put("HighType", highType);
        objectHashMap.put("FinancialManagementAreaID", fmAreaID);
        objectHashMap.put("FiscalYear", fiscalYear);
        postLedger2ControlAddress.add(objectHashMap);
    }
}

