/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.bcs;

import com.bokesoft.erp.basis.date.PeriodFormula;
import com.bokesoft.erp.billentity.ECO_Version;
import com.bokesoft.erp.billentity.EFM_AVCPostLedger;
import com.bokesoft.erp.billentity.EFM_AVControl;
import com.bokesoft.erp.billentity.EFM_ActivePeriodControl;
import com.bokesoft.erp.billentity.EFM_AddressObject;
import com.bokesoft.erp.billentity.EFM_BCSLedgerList;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_BStatusAllot;
import com.bokesoft.erp.billentity.EFM_BudgetAddress;
import com.bokesoft.erp.billentity.EFM_BudgetAsPostFilter;
import com.bokesoft.erp.billentity.EFM_BudgetBalance;
import com.bokesoft.erp.billentity.EFM_BudgetFilter;
import com.bokesoft.erp.billentity.EFM_BudgetPeriod;
import com.bokesoft.erp.billentity.EFM_BudgetTypeHead;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherDtl;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherHead;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherHead_Loader;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherPeriod;
import com.bokesoft.erp.billentity.EFM_DocumentTypeDtl;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_ReverseBudgetVoucherResult;
import com.bokesoft.erp.billentity.FM_AVControl;
import com.bokesoft.erp.billentity.FM_BudgetVoucher;
import com.bokesoft.erp.billentity.FM_DocumentType;
import com.bokesoft.erp.billentity.FM_FinancialManagementArea;
import com.bokesoft.erp.billentity.FM_ReverseBudgetVoucher;
import com.bokesoft.erp.billentity.FM_ReverseBudgetVoucherResult;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.FMComboxConstant;
import com.bokesoft.erp.fm.avc.AvcPostLedgerFormula;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.bcs.ControlAddressFormula;
import com.bokesoft.erp.fm.enums.BudgetProcessEnum;
import com.bokesoft.erp.fm.enums.BudgetStatusEnum;
import com.bokesoft.erp.fm.enums.WriteOffStatusEnum;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.parameterizedsql.SqlStringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BudgetVoucherFormula
extends EntityContextAction {
    private final PeriodFormula periodFormula = new PeriodFormula(this.getMidContext());
    private final AvcPostLedgerFormula avcPostLedgerFormula = new AvcPostLedgerFormula(this.getMidContext());
    private final AddressUtils addressUtils = new AddressUtils(this.getMidContext());

    public BudgetVoucherFormula(RichDocumentContext _context) {
        super(_context);
    }

    public boolean checkBCSEnable() throws Throwable {
        FM_BudgetVoucher fmBudgetVoucher = FM_BudgetVoucher.parseEntity((RichDocumentContext)this.getMidContext());
        return this.isAllotManagementPlan(fmBudgetVoucher);
    }

    private boolean isAllotManagementPlan(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        Long fmAreaID = fmBudgetVoucher.getFinancialManagementAreaID();
        if (fmAreaID == 0L) {
            return false;
        }
        EFM_FinancialManagementArea efmFinManagementArea = EFM_FinancialManagementArea.loader((RichDocumentContext)this.getMidContext()).OID(fmAreaID).load();
        if (efmFinManagementArea == null) {
            return false;
        }
        String plan = efmFinManagementArea.getManagementPlan();
        return !StringUtil.isBlankOrNull((String)plan);
    }

    public void getTotalAmount() throws Throwable {
        FM_BudgetVoucher fmBudgetVoucher = FM_BudgetVoucher.parseEntity((RichDocumentContext)this.getMidContext());
        List efmBudgetVoucherDetails = fmBudgetVoucher.efm_budgetVoucherDtls();
        if (!efmBudgetVoucherDetails.isEmpty()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (EFM_BudgetVoucherDtl efmBudgetVoucherDetail : efmBudgetVoucherDetails) {
                if ("R".equals(efmBudgetVoucherDetail.getAdditionalLine())) continue;
                totalAmount = totalAmount.add(efmBudgetVoucherDetail.getMoney());
            }
            fmBudgetVoucher.setTotalMoney(totalAmount);
        }
    }

    public void checkBeforeSave(int status) throws Throwable {
        FM_BudgetVoucher fmBudgetVoucher = FM_BudgetVoucher.parseEntity((RichDocumentContext)this.getMidContext());
        if (fmBudgetVoucher.getStatus() == BudgetStatusEnum.Status_02.getKey()) {
            this.prePostSave(fmBudgetVoucher, status);
        } else {
            this.checkBudgetStatus(fmBudgetVoucher);
            if ("R1".equals(fmBudgetVoucher.getBCSValType()) && !this.isAllotManagementPlan(fmBudgetVoucher)) {
                MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA001");
            }
            this.checkBudgetPeriod(fmBudgetVoucher);
            this.checkBudgetProcess(fmBudgetVoucher);
            this.checkCommitItemType(fmBudgetVoucher);
            this.checkBudgetAddress(fmBudgetVoucher);
            this.setDirectionOfAmount(fmBudgetVoucher);
            if (!"9J".equals(fmBudgetVoucher.efm_budgetVoucherHead().getBudgetLedgerCode()) && this.isAllotManagementPlan(fmBudgetVoucher) && this.isConsistentOfProcess(fmBudgetVoucher)) {
                this.addVoucherDetailOfA1(fmBudgetVoucher);
            }
            this.checkIsOverBudgetAmount(fmBudgetVoucher);
        }
        if (fmBudgetVoucher.getBudgetProcess().equals(BudgetProcessEnum.CORV.getKey()) && TypeConvertor.toInteger((Object)this.getMidContext().getPara("IsTest")) == 1) {
            return;
        }
        this.genControlAddressAndUpdateAVC(fmBudgetVoucher, status);
        if (fmBudgetVoucher.getStatus() == BudgetStatusEnum.Status_07.getKey()) {
            return;
        }
        fmBudgetVoucher.setStatus(status);
    }

    private void checkBudgetProcess(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        EFM_BudgetVoucherDtl budgetVoucherDetail;
        List budgetVoucherDetails;
        if (BudgetProcessEnum.RECV.getKey().equals(fmBudgetVoucher.getBudgetProcess()) || BudgetProcessEnum.SEND.getKey().equals(fmBudgetVoucher.getBudgetProcess())) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA002");
        }
        if ((budgetVoucherDetails = fmBudgetVoucher.efm_budgetVoucherDtls()) == null || budgetVoucherDetails.isEmpty()) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA003");
        }
        if ((budgetVoucherDetail = (EFM_BudgetVoucherDtl)budgetVoucherDetails.get(0)).getIsCarryVoucher() != 1 && (BudgetProcessEnum.CORV.getKey().equals(fmBudgetVoucher.getBudgetProcess()) || BudgetProcessEnum.COSD.getKey().equals(fmBudgetVoucher.getBudgetProcess()))) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA004");
        }
    }

    private void checkCommitItemType(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        String bcsValType = fmBudgetVoucher.getBCSValType();
        if (this.isConsistentOfProcess(fmBudgetVoucher) || "R1".equals(bcsValType)) {
            EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.load((RichDocumentContext)this.getMidContext(), (Long)fmBudgetVoucher.getFinancialManagementAreaID());
            int releaseIncome = finManagementArea.getIsReleaseIncome();
            List efmBudgetVoucherDetails = fmBudgetVoucher.efm_budgetVoucherDtls();
            for (EFM_BudgetVoucherDtl efmBudgetVoucherDetail : efmBudgetVoucherDetails) {
                int commitItemType = efmBudgetVoucherDetail.getCommitmentItemType();
                if (commitItemType != 2 || releaseIncome != 0) continue;
                MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA005");
            }
        }
    }

    private void checkBudgetStatus(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        Long fmAreaID = fmBudgetVoucher.getFinancialManagementAreaID();
        int fiscalYear = fmBudgetVoucher.getFiscalYear();
        Long versionID = fmBudgetVoucher.getVersionID();
        EFM_BudgetVoucherHead efmBudgetVoucherHead = fmBudgetVoucher.efm_budgetVoucherHead();
        EFM_BStatusAllot bStatusAllot = EFM_BStatusAllot.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).VersionID(versionID).load();
        if (bStatusAllot == null || bStatusAllot.getBudgetStatusID() == 0L) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA006", (Object[])new Object[]{efmBudgetVoucherHead.getFinancialManagementAreaCode(), efmBudgetVoucherHead.getFinancialManagementArea().getName(), fiscalYear, efmBudgetVoucherHead.getVersionCode(), efmBudgetVoucherHead.getVersion().getName()});
        }
        Long budgetTypeID = fmBudgetVoucher.getBudgetTypeID();
        Long ledgerID = fmBudgetVoucher.getBudgetLedgerID();
        String budgetProcess = fmBudgetVoucher.getBudgetProcess();
        String bcsValType = fmBudgetVoucher.getBCSValType();
        SqlString sqlString = new SqlString();
        if ("B1".equals(bcsValType)) {
            sqlString.append(new Object[]{"select * from "}).append(new Object[]{"EFM_SCBudgetSettings"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)bStatusAllot.getBudgetStatusID()).append(new Object[]{" and "}).append(new Object[]{"BudgetTypeID"}).append(new Object[]{" = "}).appendPara((Object)budgetTypeID).append(new Object[]{" and "}).append(new Object[]{"BudgetLedgerID"}).append(new Object[]{" = "}).appendPara((Object)ledgerID).append(new Object[]{" and "}).append(new Object[]{"BudgetProcess"}).append(new Object[]{" in( "}).append(new Object[]{SqlStringUtil.genMultiParameters((String)(String.valueOf(budgetProcess) + "," + BudgetProcessEnum.All.getKey()))}).append(new Object[]{")"});
        } else {
            sqlString.append(new Object[]{"select * from "}).append(new Object[]{"EFM_SCApprovalSettings"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)bStatusAllot.getBudgetStatusID()).append(new Object[]{" and "}).append(new Object[]{"BudgetTypeID"}).append(new Object[]{" = "}).appendPara((Object)budgetTypeID).append(new Object[]{" and "}).append(new Object[]{"BudgetLedgerID"}).append(new Object[]{" = "}).appendPara((Object)ledgerID).append(new Object[]{" and "}).append(new Object[]{"BudgetProcess"}).append(new Object[]{" in( "}).append(new Object[]{SqlStringUtil.genMultiParameters((String)(String.valueOf(budgetProcess) + "," + BudgetProcessEnum.All.getKey()))}).append(new Object[]{")"});
        }
        DataTable resultSet = this.getMidContext().getResultSet(sqlString);
        if (resultSet.isEmpty()) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA007", (Object[])new Object[]{bStatusAllot.getBudgetStatusCode(), bStatusAllot.getBudgetStatus().getName(), efmBudgetVoucherHead.getBudgetLedgerCode(), efmBudgetVoucherHead.getBudgetLedger().getName(), efmBudgetVoucherHead.getBudgetTypeCode(), efmBudgetVoucherHead.getBudgetType().getName(), budgetProcess});
        }
    }

    private void checkBudgetPeriod(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        EFM_ActivePeriodControl fmActivePeriodControl;
        Long fmAreaID = fmBudgetVoucher.getFinancialManagementAreaID();
        Long versionID = fmBudgetVoucher.getVersionID();
        if (fmAreaID == 0L) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA008");
        }
        if (versionID == 0L) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA009");
        }
        if ((fmActivePeriodControl = EFM_ActivePeriodControl.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).VersionID(versionID).load()) == null || fmActivePeriodControl.getIsPeriodControl() != 1) {
            return;
        }
        Long budgetLedger = fmBudgetVoucher.getBudgetLedgerID();
        if (budgetLedger == 0L) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA010");
        }
        int fiscalYear = fmBudgetVoucher.getFiscalYear();
        EFM_BudgetVoucherHead efmBudgetVoucherHead = fmBudgetVoucher.efm_budgetVoucherHead();
        EFM_BudgetPeriod efmBudgetPeriod = EFM_BudgetPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).BudgetLedgerID(budgetLedger).VersionID(versionID).FiscalYear(fiscalYear).load();
        if (efmBudgetPeriod == null) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA011", (Object[])new Object[]{efmBudgetVoucherHead.getFinancialManagementAreaCode(), efmBudgetVoucherHead.getFinancialManagementAreaCode(), efmBudgetVoucherHead.getVersionCode(), efmBudgetVoucherHead.getVersionCode(), efmBudgetVoucherHead.getBudgetLedgerCode(), efmBudgetVoucherHead.getBudgetLedger().getName(), fiscalYear});
        }
        int fromMonth = efmBudgetPeriod.getFromMonth();
        int toMonth = efmBudgetPeriod.getToMonth();
        int period = fmBudgetVoucher.getFiscalPeriod();
        if (period == 0) {
            if (fromMonth >= 1 && toMonth < 12) {
                MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA012", (Object[])new Object[]{efmBudgetVoucherHead.getFinancialManagementAreaCode(), efmBudgetVoucherHead.getFinancialManagementAreaCode(), fromMonth, toMonth});
            }
        } else if (period < fromMonth || period > toMonth) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA013", (Object[])new Object[]{period});
        }
    }

    private void checkIsOverBudgetAmount(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        Long fmAreaID = fmBudgetVoucher.getFinancialManagementAreaID();
        Long budgetLedgerID = fmBudgetVoucher.getBudgetLedgerID();
        Long versionID = fmBudgetVoucher.getVersionID();
        List efmBudgetVoucherDetails = fmBudgetVoucher.efm_budgetVoucherDtls();
        Map<String, List<EFM_BudgetVoucherDtl>> resultMap = efmBudgetVoucherDetails.stream().collect(Collectors.groupingBy(b -> {
            try {
                return String.valueOf(b.getBudgetAddress()) + "|" + b.getFiscalYear();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }));
        for (Map.Entry<String, List<EFM_BudgetVoucherDtl>> budgetVoucherDetailEntry : resultMap.entrySet()) {
            List<EFM_BudgetVoucherDtl> efm_budgetVoucherDtls = budgetVoucherDetailEntry.getValue();
            BigDecimal totalAmonutOfB1 = BigDecimal.ZERO;
            BigDecimal totalAmonutOfR1 = BigDecimal.ZERO;
            int fiscalYear = 0;
            for (EFM_BudgetVoucherDtl efmBudgetVoucherDetail : efm_budgetVoucherDtls) {
                fiscalYear = efmBudgetVoucherDetail.getFiscalYear();
                int direction = efmBudgetVoucherDetail.getDirection();
                BigDecimal amountOfDatabase = efmBudgetVoucherDetail.getMoney().multiply(new BigDecimal(direction));
                if ("B1".equals(efmBudgetVoucherDetail.getBCSValType())) {
                    totalAmonutOfB1 = totalAmonutOfB1.add(amountOfDatabase);
                } else {
                    totalAmonutOfR1 = totalAmonutOfR1.add(amountOfDatabase);
                }
                if ("R".equals(efmBudgetVoucherDetail.getAdditionalLine())) continue;
                SqlString sqlString = new SqlString();
                sqlString.append(new Object[]{"select * from "}).append(new Object[]{"EFM_BudgetBalance"}).append(new Object[]{" where "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear).append(new Object[]{" and "}).append(new Object[]{"LedgerID"}).append(new Object[]{" = "}).appendPara((Object)budgetLedgerID).append(new Object[]{" and "}).append(new Object[]{"VersionID"}).append(new Object[]{" = "}).appendPara((Object)versionID).append(new Object[]{" and "}).append(new Object[]{"BudgetAddress"}).append(new Object[]{" = "}).appendPara((Object)efmBudgetVoucherDetail.getBudgetAddress());
                DataTable resultSet = this.getMidContext().getResultSet(sqlString);
                List efmBudgetBalances = EFM_BudgetBalance.parseRowset((RichDocumentContext)this._context, (DataTable)resultSet);
                for (EFM_BudgetBalance efmBudgetBalance : efmBudgetBalances) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    int i = 1;
                    while (i <= 16) {
                        totalAmount = totalAmount.add((BigDecimal)efmBudgetBalance.valueByColumnName("HSLMoney" + i));
                        ++i;
                    }
                    if ("B1".equals(efmBudgetBalance.getBCSValType())) {
                        totalAmonutOfB1 = totalAmonutOfB1.add(totalAmount);
                        continue;
                    }
                    totalAmonutOfR1 = totalAmonutOfR1.add(totalAmount);
                }
            }
            if ("R1".equals(fmBudgetVoucher.getBCSValType()) && totalAmonutOfB1.signum() * totalAmonutOfR1.signum() < 0) {
                MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA014", (Object[])new Object[]{fiscalYear, totalAmonutOfR1.abs(), totalAmonutOfB1.abs()});
            }
            if (totalAmonutOfR1.abs().compareTo(totalAmonutOfB1.abs()) <= 0) continue;
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA014", (Object[])new Object[]{fiscalYear, totalAmonutOfR1.abs(), totalAmonutOfB1.abs()});
        }
    }

    private void addVoucherDetailOfA1(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        List efmBudgetVoucherDetails = fmBudgetVoucher.efm_budgetVoucherDtls("SOID", (Object)fmBudgetVoucher.getOID());
        for (EFM_BudgetVoucherDtl efmBudgetVoucherDetail : efmBudgetVoucherDetails) {
            if (efmBudgetVoucherDetail.isUpdated()) continue;
            EFM_BudgetVoucherDtl budgetVoucherDetailOfR = fmBudgetVoucher.newEFM_BudgetVoucherDtl();
            Long budgetTypeID = efmBudgetVoucherDetail.getBudgetTypeID();
            EFM_BudgetTypeHead preparedBudgetType = EFM_BudgetTypeHead.loader((RichDocumentContext)this.getMidContext()).OID(budgetTypeID).load();
            if (preparedBudgetType == null) {
                MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA015");
            }
            int isUnqualifiedType = preparedBudgetType.getIsUnqualifiedType();
            EFM_BudgetTypeHead approvedBudgetType = EFM_BudgetTypeHead.loader((RichDocumentContext)this.getMidContext()).BCSValType("R1").FinancialManagementAreaID(efmBudgetVoucherDetail.getFinancialManagementAreaID()).IsUnqualifiedType(isUnqualifiedType).load();
            if (approvedBudgetType == null) {
                MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA016", (Object[])new Object[]{fmBudgetVoucher.efm_budgetVoucherHead().getFinancialManagementAreaCode(), fmBudgetVoucher.efm_budgetVoucherHead().getFinancialManagementAreaCode()});
            }
            budgetVoucherDetailOfR.setBudgetTypeID(approvedBudgetType.getOID());
            budgetVoucherDetailOfR.setBCSValType("R1");
            budgetVoucherDetailOfR.setAdditionalLine("R");
            if (efmBudgetVoucherDetail.getBudgetProcess().equals(BudgetProcessEnum.CORV.getKey())) {
                budgetVoucherDetailOfR.setBudgetProcess(BudgetProcessEnum.SUPL.getKey());
                budgetVoucherDetailOfR.setIsCarryVoucher(1);
            } else if (efmBudgetVoucherDetail.getBudgetProcess().equals(BudgetProcessEnum.COSD.getKey())) {
                budgetVoucherDetailOfR.setBudgetProcess(BudgetProcessEnum.RETN.getKey());
                budgetVoucherDetailOfR.setIsCarryVoucher(1);
            }
            budgetVoucherDetailOfR.setNotes("\u884c\u88ab\u81ea\u52a8\u53d1\u5e03\u521b\u5efa");
            budgetVoucherDetailOfR.setSOID(efmBudgetVoucherDetail.getSOID());
            budgetVoucherDetailOfR.setFinancialManagementAreaID(efmBudgetVoucherDetail.getFinancialManagementAreaID());
            budgetVoucherDetailOfR.setFiscalYear(efmBudgetVoucherDetail.getFiscalYear());
            budgetVoucherDetailOfR.setFiscalPeriod(efmBudgetVoucherDetail.getFiscalPeriod());
            budgetVoucherDetailOfR.setCommitmentItemType(efmBudgetVoucherDetail.getCommitmentItemType());
            budgetVoucherDetailOfR.setDistributionCode(efmBudgetVoucherDetail.getDistributionCode());
            budgetVoucherDetailOfR.setMoney(efmBudgetVoucherDetail.getMoney());
            budgetVoucherDetailOfR.setCommitmentItemID(efmBudgetVoucherDetail.getCommitmentItemID());
            budgetVoucherDetailOfR.setFundCenterID(efmBudgetVoucherDetail.getFundCenterID());
            budgetVoucherDetailOfR.setFundID(efmBudgetVoucherDetail.getFundID());
            budgetVoucherDetailOfR.setFunctionalAreaID(efmBudgetVoucherDetail.getFunctionalAreaID());
            budgetVoucherDetailOfR.setFundProgramID(efmBudgetVoucherDetail.getFundProgramID());
            budgetVoucherDetailOfR.setDirection(efmBudgetVoucherDetail.getDirection());
            budgetVoucherDetailOfR.setBudgetAddress(efmBudgetVoucherDetail.getBudgetAddress());
        }
    }

    private boolean isConsistentOfProcess(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        FM_DocumentType fmDocumentType;
        Long documentTypeID = fmBudgetVoucher.getDocumentTypeID();
        if (documentTypeID.equals(0L)) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA017");
        }
        if (!(fmDocumentType = FM_DocumentType.load((RichDocumentContext)this.getMidContext(), (Long)documentTypeID)).getValueTypeScheme().equals("A1")) {
            return false;
        }
        List efmDocumentTypeDtls = fmDocumentType.efm_documentTypeDtls();
        if (efmDocumentTypeDtls == null || efmDocumentTypeDtls.isEmpty()) {
            return false;
        }
        String budgetProcess = fmBudgetVoucher.getBudgetProcess();
        for (EFM_DocumentTypeDtl efmDocumentTypeDtl : efmDocumentTypeDtls) {
            String processCode = efmDocumentTypeDtl.getProcessCode();
            if (processCode.equals(BudgetProcessEnum.All.getKey())) {
                return true;
            }
            if (StringUtil.isBlankOrNull((String)budgetProcess) || !budgetProcess.equals(processCode)) continue;
            return true;
        }
        return false;
    }

    private void setDirectionOfAmount(FM_BudgetVoucher fmBudgetVoucher) throws Throwable {
        List efmBudgetVoucherDetails = fmBudgetVoucher.efm_budgetVoucherDtls();
        for (EFM_BudgetVoucherDtl efmBudgetVoucherDetail : efmBudgetVoucherDetails) {
            String budgetProcess = efmBudgetVoucherDetail.getBudgetProcess();
            int commitItemType = efmBudgetVoucherDetail.getCommitmentItemType();
            int direction = BudgetProcessEnum.ENTR.getKey().equals(budgetProcess) || BudgetProcessEnum.SUPL.getKey().equals(budgetProcess) || BudgetProcessEnum.CORV.getKey().equals(budgetProcess) ? (commitItemType == 2 ? -1 : 1) : (commitItemType == 2 ? 1 : -1);
            efmBudgetVoucherDetail.setDirection(direction);
        }
    }

    public void changePeriod() throws Throwable {
        FM_BudgetVoucher fmBudgetVoucher = FM_BudgetVoucher.parseEntity((RichDocumentContext)this.getMidContext());
        if (fmBudgetVoucher.getBudgetProcess().equals(BudgetProcessEnum.CORV.getKey())) {
            return;
        }
        List efmBudgetVoucherPeriods = fmBudgetVoucher.efm_budgetVoucherPeriods("SOID", (Object)fmBudgetVoucher.getOID());
        for (EFM_BudgetVoucherPeriod budgetVoucherPeriod : efmBudgetVoucherPeriods) {
            fmBudgetVoucher.deleteEFM_BudgetVoucherPeriod(budgetVoucherPeriod);
        }
        this.getDocument().getDataTable("EFM_BudgetVoucherPeriod").impl_SetBookmarkSeed(0);
        Long fmAreaID = fmBudgetVoucher.getFinancialManagementAreaID();
        if (fmAreaID == 0L) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA008");
        }
        FM_FinancialManagementArea fmFinManagementArea = FM_FinancialManagementArea.loader((RichDocumentContext)this.getMidContext()).OID(fmAreaID).load();
        int periodCount = this.periodFormula.getPeriodCount(fmFinManagementArea.getPeriodTypeID());
        int specialPeriodCount = this.periodFormula.getSpecialPeriodCount(fmFinManagementArea.getPeriodTypeID());
        int totalPeriod = periodCount + specialPeriodCount;
        int period = fmBudgetVoucher.getFiscalPeriod();
        List efmBudgetVoucherDetails = fmBudgetVoucher.efm_budgetVoucherDtls();
        if (period != 0) {
            for (EFM_BudgetVoucherDtl budgetVoucherDetail : efmBudgetVoucherDetails) {
                EFM_BudgetVoucherPeriod budgetVoucherPeriod = fmBudgetVoucher.newEFM_BudgetVoucherPeriod();
                budgetVoucherPeriod.setPOID(budgetVoucherDetail.getOID());
                budgetVoucherPeriod.setFiscalPeriod(period);
                budgetVoucherPeriod.setBudgetMoney(budgetVoucherDetail.getMoney());
                budgetVoucherPeriod.setLVALMoney(budgetVoucherDetail.getMoney());
                budgetVoucherPeriod.setDirection(budgetVoucherDetail.getDirection());
            }
        } else {
            for (EFM_BudgetVoucherDtl budgetVoucherDetail : efmBudgetVoucherDetails) {
                budgetVoucherDetail.setFiscalPeriod(totalPeriod);
                this.allocatAmount(budgetVoucherDetail.getOID(), fmBudgetVoucher, periodCount, totalPeriod, budgetVoucherDetail.getMoney(), budgetVoucherDetail.getDirection());
            }
        }
    }

    public void changePeriodFromBudgetVoucherDetail(Long budgetVoucherDetailOID) throws Throwable {
        FM_BudgetVoucher fmBudgetVoucher = FM_BudgetVoucher.parseEntity((RichDocumentContext)this.getMidContext());
        EFM_BudgetVoucherDtl efmBudgetVoucherDetail = fmBudgetVoucher.efm_budgetVoucherDtl(budgetVoucherDetailOID);
        if (efmBudgetVoucherDetail.getBudgetProcess().equals(BudgetProcessEnum.COSD.getKey()) || efmBudgetVoucherDetail.getDistributionCode() == -1 && !"R".equals(efmBudgetVoucherDetail.getAdditionalLine())) {
            return;
        }
        List efmBudgetVoucherPeriods = fmBudgetVoucher.efm_budgetVoucherPeriods("POID", (Object)budgetVoucherDetailOID);
        for (EFM_BudgetVoucherPeriod budgetVoucherPeriod : efmBudgetVoucherPeriods) {
            fmBudgetVoucher.deleteEFM_BudgetVoucherPeriod(budgetVoucherPeriod);
        }
        Long fmAreaID = fmBudgetVoucher.getFinancialManagementAreaID();
        if (fmAreaID == 0L) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA008");
        }
        FM_FinancialManagementArea fmFinManagementArea = FM_FinancialManagementArea.loader((RichDocumentContext)this.getMidContext()).OID(fmAreaID).load();
        int periodCount = this.periodFormula.getPeriodCount(fmFinManagementArea.getPeriodTypeID());
        int specialPeriodCount = this.periodFormula.getSpecialPeriodCount(fmFinManagementArea.getPeriodTypeID());
        int totalPeriod = periodCount + specialPeriodCount;
        int period = efmBudgetVoucherDetail.getFiscalPeriod();
        BigDecimal amount = efmBudgetVoucherDetail.getMoney();
        int direction = efmBudgetVoucherDetail.getDirection();
        if (period != 0) {
            EFM_BudgetVoucherPeriod budgetVoucherPeriod = fmBudgetVoucher.newEFM_BudgetVoucherPeriod();
            budgetVoucherPeriod.setPOID(budgetVoucherDetailOID);
            budgetVoucherPeriod.setFiscalPeriod(period);
            budgetVoucherPeriod.setBudgetMoney(amount);
            budgetVoucherPeriod.setLVALMoney(amount);
            budgetVoucherPeriod.setDirection(direction);
        } else {
            this.allocatAmount(budgetVoucherDetailOID, fmBudgetVoucher, periodCount, totalPeriod, amount, direction);
        }
    }

    public void allocatAmount(Long budgetVoucherDetailOID, FM_BudgetVoucher fmBudgetVoucher, int periodCount, int totalPeriod, BigDecimal amount, int direction) throws Throwable {
        BigDecimal isNegative = amount.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ONE : new BigDecimal("-1");
        BigDecimal periodCountBigDecimal = new BigDecimal(periodCount);
        BigDecimal perAmount = amount.divide(periodCountBigDecimal, 2, RoundingMode.DOWN);
        BigDecimal remainAmount = amount.subtract(perAmount.multiply(periodCountBigDecimal));
        BigDecimal excessNumber = new BigDecimal("0.01").multiply(isNegative);
        int i = 1;
        while (i <= totalPeriod) {
            EFM_BudgetVoucherPeriod budgetVoucherPeriod = fmBudgetVoucher.newEFM_BudgetVoucherPeriod();
            budgetVoucherPeriod.setPOID(budgetVoucherDetailOID);
            budgetVoucherPeriod.setFiscalPeriod(i);
            budgetVoucherPeriod.setDirection(direction);
            if (i <= periodCount) {
                if (remainAmount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal addNumber = perAmount.add(excessNumber);
                    budgetVoucherPeriod.setBudgetMoney(addNumber);
                    budgetVoucherPeriod.setLVALMoney(addNumber);
                    remainAmount = remainAmount.subtract(excessNumber);
                } else {
                    budgetVoucherPeriod.setBudgetMoney(perAmount);
                    budgetVoucherPeriod.setLVALMoney(perAmount);
                }
            } else {
                budgetVoucherPeriod.setBudgetMoney(BigDecimal.ZERO);
                budgetVoucherPeriod.setLVALMoney(BigDecimal.ZERO);
            }
            ++i;
        }
    }

    private void checkBudgetAddress(FM_BudgetVoucher budgetVoucher) throws Throwable {
        EFM_BStatusAllot bStatusAllot;
        Long fmAreaID = budgetVoucher.getFinancialManagementAreaID();
        int fiscalYear = budgetVoucher.getFiscalYear();
        List efm_budgetVoucherDtls = budgetVoucher.efm_budgetVoucherDtls();
        if (efm_budgetVoucherDtls == null || efm_budgetVoucherDtls.isEmpty()) {
            MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA018");
        }
        if ((bStatusAllot = EFM_BStatusAllot.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).VersionID(budgetVoucher.efm_budgetVoucherHead().getVersionID()).load()).getIsCheckBudgetAddress() == 1) {
            for (EFM_BudgetVoucherDtl budgetVoucherDetail : efm_budgetVoucherDtls) {
                EFM_BudgetAddress budgetAddress;
                EFM_BSDistribution budgetStrConfig = EFM_BSDistribution.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(budgetVoucherDetail.getFiscalYear()).load();
                if (budgetStrConfig == null || budgetStrConfig.getBudgetStructureID() <= 0L) {
                    MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA019", (Object[])new Object[]{budgetVoucherDetail.getFiscalYear()});
                }
                if ((budgetAddress = EFM_BudgetAddress.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FiscalYear(budgetVoucherDetail.getFiscalYear()).BudgetStructureID(budgetStrConfig.getBudgetStructureID()).LedgerID(budgetVoucher.getBudgetLedgerID()).FundID(budgetVoucherDetail.getFundID()).FundCenterID(budgetVoucherDetail.getFundCenterID()).CommitmentItemID(budgetVoucherDetail.getCommitmentItemID()).FunctionalAreaID(budgetVoucherDetail.getFunctionalAreaID()).FundProgramID(budgetVoucherDetail.getFundProgramID()).load()) == null) {
                    MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA020", (Object[])new Object[]{budgetVoucherDetail.getFundCode(), budgetVoucherDetail.getFundCenterCode(), budgetVoucherDetail.getCommitmentItemCode(), budgetVoucherDetail.getFunctionalAreaCode(), budgetVoucherDetail.getFiscalYear(), budgetStrConfig.getBudgetStructureCode()});
                }
                budgetVoucherDetail.setBudgetAddress(budgetAddress.getObjectNumber());
            }
        } else {
            for (EFM_BudgetVoucherDtl budgetVoucherDetail : efm_budgetVoucherDtls) {
                String address = this.addressUtils.genAddress(budgetVoucherDetail.getFundID(), budgetVoucherDetail.getFundCenterID(), budgetVoucherDetail.getCommitmentItemID(), budgetVoucherDetail.getFunctionalAreaID(), budgetVoucherDetail.getFundProgramID());
                budgetVoucherDetail.setBudgetAddress(address);
            }
        }
    }

    private int judgeBudgetFilterSettings(FM_BudgetVoucher budgetVoucher, Long budgetVoucherDetailOID, Long controlLedgerID, int workFlowStatus) throws Throwable {
        int migrateState = 0;
        Long voucherVersionID = budgetVoucher.efm_budgetVoucherHead().getVersionID();
        String versionCode = budgetVoucher.efm_budgetVoucherHead().getVersionCode();
        String voucherBCSValType = budgetVoucher.efm_budgetVoucherDtl(budgetVoucherDetailOID).getBCSValType();
        List budgetFilters = EFM_BudgetFilter.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(budgetVoucher.getFinancialManagementAreaID()).LedgerID(controlLedgerID).FromFiscalYear("<=", budgetVoucher.getFiscalYear()).orderBy("FromFiscalYear").desc().loadList();
        if ((budgetFilters == null || budgetFilters.isEmpty()) && voucherBCSValType.equals("R1") && versionCode.equals("0")) {
            return 3;
        }
        if (budgetFilters != null && !budgetFilters.isEmpty()) {
            EFM_BudgetFilter budgetFilter = (EFM_BudgetFilter)budgetFilters.get(0);
            Long filterVersionID = budgetFilter.getVersionID();
            String filterBCSValType = budgetFilter.getBCSValType();
            String filterBudgetStatus = budgetFilter.getWorkFlowStatus();
            if (filterVersionID == 0L && versionCode.equals("0") || voucherVersionID.equals(filterVersionID)) {
                ++migrateState;
            }
            if (filterBCSValType.equals(voucherBCSValType)) {
                ++migrateState;
            }
            if (filterBudgetStatus.equals("ALL") || "P".equals(filterBudgetStatus) && workFlowStatus == 1) {
                ++migrateState;
            }
        }
        return migrateState;
    }

    private int judgeBudgetAsPostFilterSettings(FM_BudgetVoucher budgetVoucher, Long budgetVoucherDetailOID, Long controlLedgerID, int workFlowStatus) throws Throwable {
        int migrateState = 0;
        Long voucherVersionID = budgetVoucher.efm_budgetVoucherHead().getVersionID();
        String versionCode = budgetVoucher.efm_budgetVoucherHead().getVersionCode();
        String voucherBCSValType = budgetVoucher.efm_budgetVoucherDtl(budgetVoucherDetailOID).getBCSValType();
        List budgetAsPostFilters = EFM_BudgetAsPostFilter.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(budgetVoucher.getFinancialManagementAreaID()).LedgerID(controlLedgerID).FromFiscalYear("<=", budgetVoucher.getFiscalYear()).orderBy("FromFiscalYear").desc().loadList();
        if ((budgetAsPostFilters == null || budgetAsPostFilters.isEmpty()) && voucherBCSValType.equals("R1") && versionCode.equals("0")) {
            return 3;
        }
        if (budgetAsPostFilters != null && !budgetAsPostFilters.isEmpty()) {
            EFM_BudgetAsPostFilter budgetAsPostFilter = (EFM_BudgetAsPostFilter)budgetAsPostFilters.get(0);
            Long filterVersionID = budgetAsPostFilter.getVersionID();
            String filterBCSValType = budgetAsPostFilter.getBCSValType();
            String filterBudgetStatus = budgetAsPostFilter.getWorkFlowStatus();
            if (filterVersionID == 0L && versionCode.equals("0") || voucherVersionID.equals(filterVersionID)) {
                ++migrateState;
            }
            if (filterBCSValType.equals(voucherBCSValType)) {
                ++migrateState;
            }
            if (filterBudgetStatus.equals("ALL") || "P".equals(filterBudgetStatus) && workFlowStatus == 1) {
                ++migrateState;
            }
        }
        return migrateState;
    }

    private void genControlAddressAndUpdateAVC(FM_BudgetVoucher budgetVoucher, int status) throws Throwable {
        Long fmAreaID = budgetVoucher.getFinancialManagementAreaID();
        Long budgetLedgerID = budgetVoucher.getBudgetLedgerID();
        FM_FinancialManagementArea fmFinManagementArea = FM_FinancialManagementArea.loader((RichDocumentContext)this.getMidContext()).OID(fmAreaID).load();
        int periodCount = this.periodFormula.getPeriodCount(fmFinManagementArea.getPeriodTypeID());
        int specialPeriodCount = this.periodFormula.getSpecialPeriodCount(fmFinManagementArea.getPeriodTypeID());
        int totalPeriod = periodCount + specialPeriodCount;
        List efmBudgetVoucherDetails = budgetVoucher.efm_budgetVoucherDtls();
        for (EFM_BudgetVoucherDtl budgetVoucherDetail : efmBudgetVoucherDetails) {
            int fiscalYear = budgetVoucherDetail.getFiscalYear();
            Long fundID = budgetVoucherDetail.getFundID();
            Long fundCenterID = budgetVoucherDetail.getFundCenterID();
            Long commitItemID = budgetVoucherDetail.getCommitmentItemID();
            Long functionAreaID = budgetVoucherDetail.getFunctionalAreaID();
            Long fundProgramID = budgetVoucherDetail.getFundProgramID();
            int commitItemType = budgetVoucherDetail.getCommitmentItemType();
            int budgetVoucherPeriod = budgetVoucherDetail.getFiscalPeriod();
            String objectNumber = budgetVoucherDetail.getBudgetAddress();
            String workFlowStatus = status == 1 ? "P" : (budgetVoucherDetail.getDirection() == 1 ? "E" : "R");
            List efmBudgetVoucherPeriods = budgetVoucher.efm_budgetVoucherPeriods("POID", (Object)budgetVoucherDetail.getOID());
            this.budgetLedgerIsBudgetDataSource(budgetVoucher, status, fmAreaID, budgetLedgerID, totalPeriod, budgetVoucherDetail, fiscalYear, fundID, fundCenterID, commitItemID, functionAreaID, fundProgramID, budgetVoucherPeriod, objectNumber, workFlowStatus, efmBudgetVoucherPeriods);
            this.budgetLedgerIsPostDataSource(budgetVoucher, status, fmAreaID, budgetLedgerID, budgetVoucherDetail, fiscalYear, fundID, fundCenterID, commitItemID, functionAreaID, fundProgramID, commitItemType, budgetVoucherPeriod, objectNumber, workFlowStatus, efmBudgetVoucherPeriods);
        }
    }

    private void budgetLedgerIsPostDataSource(FM_BudgetVoucher budgetVoucher, int status, Long fmAreaID, Long budgetLedgerID, EFM_BudgetVoucherDtl budgetVoucherDetail, int fiscalYear, Long fundID, Long fundCenterID, Long commitItemID, Long functionAreaID, Long fundProgramID, int commitItemType, int budgetVoucherPeriod, String objectNumber, String workFlowStatus, List<EFM_BudgetVoucherPeriod> efmBudgetVoucherPeriods) throws Throwable {
        List bcsPostLedgerLists = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).PostLedgerID(budgetLedgerID).loadList();
        if (bcsPostLedgerLists != null) {
            for (EFM_BCSLedgerList bcsLedger : bcsPostLedgerLists) {
                int budgetAsPostFilterSettings;
                Long controlLedgerID = bcsLedger.getControlLedgerID();
                EFM_AVCPostLedger avcPostLedger = EFM_AVCPostLedger.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).LedgerID(controlLedgerID).load();
                if (avcPostLedger == null) {
                    MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA021", (Object[])new Object[]{bcsLedger.getControlLedgerCode()});
                }
                if (avcPostLedger.getAVCStatus().equals("N") || (budgetAsPostFilterSettings = this.judgeBudgetAsPostFilterSettings(budgetVoucher, budgetVoucherDetail.getOID(), controlLedgerID, status)) < 3) continue;
                budgetVoucherDetail.setHasUpdatedAVC(1);
                String controlAddress = new ControlAddressFormula(this.getMidContext()).genBudgetAddress2ControlAddress(fmAreaID, budgetLedgerID, fiscalYear, fundID, fundCenterID, commitItemID, functionAreaID, fundProgramID, objectNumber, controlLedgerID);
                EFM_AddressObject addressObject = EFM_AddressObject.loader((RichDocumentContext)this.getMidContext()).ObjectNumber(controlAddress).load();
                budgetVoucherDetail.setControlFundID(addressObject.getFundID());
                budgetVoucherDetail.setControlFundCenterID(addressObject.getFundCenterID());
                budgetVoucherDetail.setControlCommitmentItemID(addressObject.getCommitmentItemID());
                budgetVoucherDetail.setControlFunctionalAreaID(addressObject.getFunctionalAreaID());
                budgetVoucherDetail.setControlFundProgramID(addressObject.getFundProgramID());
                String highType = commitItemType == 3 ? "S" : "I";
                if (budgetVoucherPeriod != 0) {
                    BigDecimal amount = efmBudgetVoucherPeriods.get(0).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                    this.avcPostLedgerFormula.budgetBalanceUpdate("++", highType, objectNumber, budgetVoucher.getVersionID(), fmAreaID, bcsLedger.getPostLedgerID(), fiscalYear, budgetVoucherPeriod, amount, budgetVoucherDetail.getTVCurrencyID(), workFlowStatus);
                    continue;
                }
                int fiscalPeriod = 0;
                while (fiscalPeriod < efmBudgetVoucherPeriods.size()) {
                    BigDecimal amount = efmBudgetVoucherPeriods.get(fiscalPeriod).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                    this.avcPostLedgerFormula.budgetBalanceUpdate("++", highType, objectNumber, budgetVoucher.getVersionID(), fmAreaID, bcsLedger.getPostLedgerID(), fiscalYear, fiscalPeriod + 1, amount, budgetVoucherDetail.getTVCurrencyID(), workFlowStatus);
                    ++fiscalPeriod;
                }
            }
        }
    }

    private void budgetLedgerIsBudgetDataSource(FM_BudgetVoucher budgetVoucher, int status, Long fmAreaID, Long budgetLedgerID, int totalPeriod, EFM_BudgetVoucherDtl budgetVoucherDetail, int fiscalYear, Long fundID, Long fundCenterID, Long commitItemID, Long functionAreaID, Long fundProgramID, int budgetVoucherPeriod, String objectNumber, String workFlowStatus, List<EFM_BudgetVoucherPeriod> efmBudgetVoucherPeriods) throws Throwable {
        List bcsBudgetLedgerLists = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).BudgetLedgerID(budgetLedgerID).loadList();
        if (bcsBudgetLedgerLists != null) {
            for (EFM_BCSLedgerList bcsLedger : bcsBudgetLedgerLists) {
                int filterSettings;
                Long controlLedgerID = bcsLedger.getControlLedgerID();
                EFM_AVCPostLedger avcPostLedger = EFM_AVCPostLedger.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).LedgerID(controlLedgerID).load();
                if (avcPostLedger == null) {
                    MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA021", (Object[])new Object[]{bcsLedger.getControlLedgerCode()});
                }
                if (avcPostLedger.getAVCStatus().equals("N") || (filterSettings = this.judgeBudgetFilterSettings(budgetVoucher, budgetVoucherDetail.getOID(), controlLedgerID, status)) < 3) continue;
                budgetVoucherDetail.setHasUpdatedAVC(1);
                String controlAddress = new ControlAddressFormula(this.getMidContext()).genBudgetAddress2ControlAddress(fmAreaID, budgetLedgerID, fiscalYear, fundID, fundCenterID, commitItemID, functionAreaID, fundProgramID, objectNumber, controlLedgerID);
                EFM_AddressObject addressObject = EFM_AddressObject.loader((RichDocumentContext)this.getMidContext()).ObjectNumber(controlAddress).load();
                budgetVoucherDetail.setControlFundID(addressObject.getFundID());
                budgetVoucherDetail.setControlFundCenterID(addressObject.getFundCenterID());
                budgetVoucherDetail.setControlCommitmentItemID(addressObject.getCommitmentItemID());
                budgetVoucherDetail.setControlFunctionalAreaID(addressObject.getFunctionalAreaID());
                budgetVoucherDetail.setControlFundProgramID(addressObject.getFundProgramID());
                EFM_AVControl ifExistAvControl = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(addressObject.getFundID()).FundCenterID(addressObject.getFundCenterID()).CommitmentItemID(addressObject.getCommitmentItemID()).FunctionalAreaID(addressObject.getFunctionalAreaID()).FundProgramID(addressObject.getFundProgramID()).WorkFlowStatus(workFlowStatus).RecordType(1).load();
                if (ifExistAvControl != null) {
                    if (budgetVoucherPeriod != 0) {
                        BigDecimal amount = efmBudgetVoucherPeriods.get(0).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                        BigDecimal tslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("TSLMoney" + budgetVoucherPeriod)).add(amount);
                        BigDecimal hslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("HSLMoney" + budgetVoucherPeriod)).add(amount);
                        ifExistAvControl.valueByColumnName("TSLMoney" + budgetVoucherPeriod, tslAmountPeriod, 2, RoundingMode.HALF_UP);
                        ifExistAvControl.valueByColumnName("HSLMoney" + budgetVoucherPeriod, hslAmountPeriod, 2, RoundingMode.HALF_UP);
                    } else {
                        int fiscalPeriod = 1;
                        while (fiscalPeriod < efmBudgetVoucherPeriods.size() + 1) {
                            BigDecimal amount = efmBudgetVoucherPeriods.get(fiscalPeriod - 1).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                            BigDecimal tslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("TSLMoney" + fiscalPeriod)).add(amount);
                            BigDecimal hslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("HSLMoney" + fiscalPeriod)).add(amount);
                            ifExistAvControl.valueByColumnName("TSLMoney" + fiscalPeriod, tslAmountPeriod, 2, RoundingMode.HALF_UP);
                            ifExistAvControl.valueByColumnName("HSLMoney" + fiscalPeriod, hslAmountPeriod, 2, RoundingMode.HALF_UP);
                            ++fiscalPeriod;
                        }
                    }
                    BigDecimal totalAmount = budgetVoucherDetail.getMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                    ifExistAvControl.setTSLMoneyTotal(ifExistAvControl.getTSLMoneyTotal().add(totalAmount));
                    ifExistAvControl.setHSLMoneyTotal(ifExistAvControl.getHSLMoneyTotal().add(totalAmount));
                    this.save((AbstractTableEntity)ifExistAvControl, "FM_AVControl");
                    continue;
                }
                FM_AVControl fm_avControl = (FM_AVControl)this.newBillEntity(FM_AVControl.class);
                Long versionID = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load().getOID();
                EFM_AVControl efm_avControl = fm_avControl.newEFM_AVControl();
                efm_avControl.setRecordType(1);
                efm_avControl.setVersionID(versionID);
                efm_avControl.setLedgerID(controlLedgerID);
                efm_avControl.setFiscalYear(fiscalYear);
                efm_avControl.setFinancialManagementAreaID(fmAreaID);
                efm_avControl.setCurrencyID(budgetVoucherDetail.getTVCurrencyID());
                efm_avControl.setCommitmentItemID(addressObject.getCommitmentItemID());
                efm_avControl.setFundCenterID(addressObject.getFundCenterID());
                efm_avControl.setFundID(addressObject.getFundID());
                efm_avControl.setFunctionalAreaID(addressObject.getFunctionalAreaID());
                efm_avControl.setFundProgramID(addressObject.getFundProgramID());
                efm_avControl.setFiscalPeriod(totalPeriod);
                efm_avControl.setWorkFlowStatus(workFlowStatus);
                efm_avControl.setMoneyType("KBFC");
                if (budgetVoucherPeriod != 0) {
                    BigDecimal amount = efmBudgetVoucherPeriods.get(0).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                    efm_avControl.valueByColumnName("TSLMoney" + budgetVoucherPeriod, amount, 2, RoundingMode.HALF_UP);
                    efm_avControl.valueByColumnName("HSLMoney" + budgetVoucherPeriod, amount, 2, RoundingMode.HALF_UP);
                } else {
                    int fiscalPeriod = 1;
                    while (fiscalPeriod < efmBudgetVoucherPeriods.size()) {
                        BigDecimal amount = efmBudgetVoucherPeriods.get(fiscalPeriod - 1).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                        efm_avControl.valueByColumnName("TSLMoney" + fiscalPeriod, amount, 2, RoundingMode.HALF_UP);
                        efm_avControl.valueByColumnName("HSLMoney" + fiscalPeriod, amount, 2, RoundingMode.HALF_UP);
                        ++fiscalPeriod;
                    }
                }
                BigDecimal totalAmount = budgetVoucherDetail.getMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                efm_avControl.setTSLMoneyTotal(totalAmount);
                efm_avControl.setHSLMoneyTotal(totalAmount);
                this.save((AbstractBillEntity)fm_avControl);
            }
        }
    }

    private void prePostSave(FM_BudgetVoucher budgetVoucher, int status) throws Throwable {
        Long fmAreaID = budgetVoucher.getFinancialManagementAreaID();
        int fiscalYear = budgetVoucher.getFiscalYear();
        Long budgetLedgerID = budgetVoucher.getBudgetLedgerID();
        int budgetVoucherPeriod = budgetVoucher.getFiscalPeriod();
        List efm_budgetVoucherDtls = budgetVoucher.efm_budgetVoucherDtls();
        for (EFM_BudgetVoucherDtl budgetVoucherDetail : efm_budgetVoucherDtls) {
            Long fundID = budgetVoucherDetail.getFundID();
            Long fundCenterID = budgetVoucherDetail.getFundCenterID();
            Long commitItemID = budgetVoucherDetail.getCommitmentItemID();
            Long functionAreaID = budgetVoucherDetail.getFunctionalAreaID();
            Long fundProgramID = budgetVoucherDetail.getFundProgramID();
            String workFlowStatus = budgetVoucherDetail.getDirection() == 1 ? "E" : "R";
            List bcsBudgetLedgerLists = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).BudgetLedgerID(budgetLedgerID).loadList();
            if (bcsBudgetLedgerLists == null) continue;
            for (EFM_BCSLedgerList bcsLedger : bcsBudgetLedgerLists) {
                int filterSettings;
                Long controlLedgerID = bcsLedger.getControlLedgerID();
                EFM_AVCPostLedger avcPostLedger = EFM_AVCPostLedger.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).LedgerID(controlLedgerID).load();
                if (avcPostLedger == null) {
                    MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA021", (Object[])new Object[]{bcsLedger.getControlLedgerCode()});
                }
                if (avcPostLedger.getAVCStatus().equals("N") || (filterSettings = this.judgeBudgetFilterSettings(budgetVoucher, budgetVoucherDetail.getOID(), controlLedgerID, status)) < 3) continue;
                this.dealPrePostAVControl(budgetVoucher, fmAreaID, fiscalYear, budgetVoucherPeriod, budgetVoucherDetail, fundID, fundCenterID, commitItemID, functionAreaID, fundProgramID, workFlowStatus, controlLedgerID, 1);
            }
            List bcsPostLedgerLists = EFM_BCSLedgerList.loader((RichDocumentContext)this.getMidContext()).PostLedgerID(budgetLedgerID).loadList();
            if (bcsPostLedgerLists == null) continue;
            for (EFM_BCSLedgerList bcsLedger : bcsPostLedgerLists) {
                int budgetAsPostFilterSettings;
                Long controlLedgerID = bcsLedger.getControlLedgerID();
                EFM_AVCPostLedger avcPostLedger = EFM_AVCPostLedger.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).FromFiscalYear("<=", fiscalYear).LedgerID(controlLedgerID).load();
                if (avcPostLedger == null) {
                    MessageFacade.throwException((String)"BUDGETVOUCHERFORMULA021", (Object[])new Object[]{bcsLedger.getControlLedgerCode()});
                }
                if (avcPostLedger.getAVCStatus().equals("N") || (budgetAsPostFilterSettings = this.judgeBudgetAsPostFilterSettings(budgetVoucher, budgetVoucherDetail.getOID(), controlLedgerID, status)) < 3) continue;
                this.dealPrePostAVControl(budgetVoucher, fmAreaID, fiscalYear, budgetVoucherPeriod, budgetVoucherDetail, fundID, fundCenterID, commitItemID, functionAreaID, fundProgramID, workFlowStatus, controlLedgerID, 0);
            }
        }
    }

    private void dealPrePostAVControl(FM_BudgetVoucher budgetVoucher, Long fmAreaID, int fiscalYear, int budgetVoucherPeriod, EFM_BudgetVoucherDtl budgetVoucherDetail, Long fundID, Long fundCenterID, Long commitItemID, Long functionAreaID, Long fundProgramID, String workFlowStatus, Long controlLedgerID, int recordType) throws Throwable {
        EFM_AVControl ifExistAvControl = EFM_AVControl.loader((RichDocumentContext)this.getMidContext()).LedgerID(controlLedgerID).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).FundID(fundID).FundCenterID(fundCenterID).CommitmentItemID(commitItemID).FunctionalAreaID(functionAreaID).FundProgramID(fundProgramID).WorkFlowStatus(workFlowStatus).RecordType(recordType).load();
        if (ifExistAvControl != null && ifExistAvControl.getTSLMoneyTotal().abs().compareTo(BigDecimal.ZERO) > 0) {
            List budgetVoucherPeriods = budgetVoucher.efm_budgetVoucherPeriods("POID", (Object)budgetVoucherDetail.getOID());
            if (budgetVoucherPeriod != 0) {
                BigDecimal amount = ((EFM_BudgetVoucherPeriod)budgetVoucherPeriods.get(0)).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                BigDecimal tslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("TSLMoney" + budgetVoucherPeriod)).subtract(amount);
                BigDecimal hslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("HSLMoney" + budgetVoucherPeriod)).subtract(amount);
                ifExistAvControl.valueByColumnName("TSLMoney" + budgetVoucherPeriod, tslAmountPeriod, 2, RoundingMode.HALF_UP);
                ifExistAvControl.valueByColumnName("HSLMoney" + budgetVoucherPeriod, hslAmountPeriod, 2, RoundingMode.HALF_UP);
            } else {
                int fiscalPeriod = 1;
                while (fiscalPeriod < budgetVoucherPeriods.size() + 1) {
                    BigDecimal amount = ((EFM_BudgetVoucherPeriod)budgetVoucherPeriods.get(fiscalPeriod - 1)).getBudgetMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection()));
                    BigDecimal tslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("TSLMoney" + fiscalPeriod)).subtract(amount);
                    BigDecimal hslAmountPeriod = TypeConvertor.toBigDecimal((Object)ifExistAvControl.valueByColumnName("HSLMoney" + fiscalPeriod)).subtract(amount);
                    ifExistAvControl.valueByColumnName("TSLMoney" + fiscalPeriod, tslAmountPeriod, 2, RoundingMode.HALF_UP);
                    ifExistAvControl.valueByColumnName("HSLMoney" + fiscalPeriod, hslAmountPeriod, 2, RoundingMode.HALF_UP);
                    ++fiscalPeriod;
                }
            }
            BigDecimal deducteTotalamount = ifExistAvControl.getTSLMoneyTotal().subtract(budgetVoucherDetail.getMoney().multiply(BigDecimal.valueOf(budgetVoucherDetail.getDirection())));
            ifExistAvControl.setTSLMoneyTotal(deducteTotalamount);
            ifExistAvControl.setHSLMoneyTotal(deducteTotalamount);
            this.save((AbstractTableEntity)ifExistAvControl, "FM_AVControl");
        }
    }

    public void reverseBudgetVocuher() throws Throwable {
        FM_ReverseBudgetVoucher reverseBudgetVoucher = FM_ReverseBudgetVoucher.parseDocument((RichDocument)this.getDocument());
        int isTest = reverseBudgetVoucher.getIsTest();
        Long fmAreaID = reverseBudgetVoucher.getFinancialManagementAreaID();
        int fiscalYear = reverseBudgetVoucher.getFiscalYear();
        int isShowDetail = reverseBudgetVoucher.getIsShowDetail();
        FM_ReverseBudgetVoucherResult reverseBudgetVoucherResult = (FM_ReverseBudgetVoucherResult)this.newBillEntity(FM_ReverseBudgetVoucherResult.class);
        reverseBudgetVoucherResult.setHeadFinancialManagementAreaID(fmAreaID);
        reverseBudgetVoucherResult.setHeadFiscalYear(fiscalYear);
        reverseBudgetVoucherResult.setIsTest(isTest);
        reverseBudgetVoucherResult.setIsShowDetail(isShowDetail);
        List<FM_BudgetVoucher> budgetVoucherList = this.getBudgetVoucher(reverseBudgetVoucher);
        for (FM_BudgetVoucher budgetVoucher : budgetVoucherList) {
            EFM_BudgetVoucherHead fromBudgetVoucherHead = budgetVoucher.efm_budgetVoucherHead();
            List<Integer> filterStatus = Arrays.asList(BudgetStatusEnum.Status_02.getKey(), BudgetStatusEnum.Status_06.getKey(), BudgetStatusEnum.Status_07.getKey());
            if (filterStatus.contains(fromBudgetVoucherHead.getStatus())) continue;
            FM_BudgetVoucher writeOffBudgetVoucher = this.genReverseBudgetVoucher(reverseBudgetVoucher, budgetVoucher, fromBudgetVoucherHead);
            EFM_ReverseBudgetVoucherResult efmReverseBudgetVoucherResult = reverseBudgetVoucherResult.newEFM_ReverseBudgetVoucherResult();
            efmReverseBudgetVoucherResult.setVoucherID(fromBudgetVoucherHead.getOID());
            efmReverseBudgetVoucherResult.setDocumentNumber(fromBudgetVoucherHead.getDocumentNumber());
            efmReverseBudgetVoucherResult.setFiscalYear(fromBudgetVoucherHead.getFiscalYear());
            efmReverseBudgetVoucherResult.setDtl_Status(fromBudgetVoucherHead.getStatus());
            if (isTest != 0) continue;
            this.save((AbstractBillEntity)writeOffBudgetVoucher);
            fromBudgetVoucherHead.setStatus(BudgetStatusEnum.Status_06.getKey());
            fromBudgetVoucherHead.setReversalStatus(WriteOffStatusEnum.Status_01.getKey());
            fromBudgetVoucherHead.setReversalDocNo(writeOffBudgetVoucher.getDocumentNumber());
            fromBudgetVoucherHead.setReversalDocSOID(writeOffBudgetVoucher.getOID());
            this.directSave((AbstractBillEntity)budgetVoucher);
            efmReverseBudgetVoucherResult.setReversalVoucherID(writeOffBudgetVoucher.getOID());
            efmReverseBudgetVoucherResult.setReversalDocNo(writeOffBudgetVoucher.getDocumentNumber());
            efmReverseBudgetVoucherResult.setReversalStatus(WriteOffStatusEnum.Status_01.getKey());
        }
        new AddressUtils(this.getMidContext()).transOneNewTab("FM_ReverseBudgetVoucherResult", reverseBudgetVoucherResult.document.toJSON());
        if (isTest == 0 && reverseBudgetVoucherResult.efm_reverseBudgetVoucherResults().size() > 0) {
            this.save((AbstractBillEntity)reverseBudgetVoucherResult);
        }
    }

    private FM_BudgetVoucher genReverseBudgetVoucher(FM_ReverseBudgetVoucher reverseBudgetVoucher, FM_BudgetVoucher budgetVoucher, EFM_BudgetVoucherHead fromBudgetVoucherHead) throws Throwable {
        FM_BudgetVoucher writeOffBudgetVoucher = (FM_BudgetVoucher)this.newBillEntity(FM_BudgetVoucher.class);
        EFM_BudgetVoucherHead writeOffBudgetVoucherHead = writeOffBudgetVoucher.efm_budgetVoucherHead();
        writeOffBudgetVoucherHead.setStatus(BudgetStatusEnum.Status_07.getKey());
        writeOffBudgetVoucherHead.setReversalStatus(WriteOffStatusEnum.Status_02.getKey());
        writeOffBudgetVoucherHead.setReversalDocSOID(fromBudgetVoucherHead.getOID());
        writeOffBudgetVoucherHead.setReversalDocNo(fromBudgetVoucherHead.getDocumentNumber());
        writeOffBudgetVoucherHead.setNotes(reverseBudgetVoucher.getTitleText());
        writeOffBudgetVoucherHead.setFinancialManagementAreaID(fromBudgetVoucherHead.getFinancialManagementAreaID());
        writeOffBudgetVoucherHead.setBudgetLedgerID(fromBudgetVoucherHead.getBudgetLedgerID());
        writeOffBudgetVoucherHead.setDocumentTypeID(fromBudgetVoucherHead.getDocumentTypeID());
        writeOffBudgetVoucherHead.setSendFiscalYear(fromBudgetVoucherHead.getSendFiscalYear());
        writeOffBudgetVoucherHead.setFiscalYear(fromBudgetVoucherHead.getFiscalYear());
        writeOffBudgetVoucherHead.setBudgetTypeID(fromBudgetVoucherHead.getBudgetTypeID());
        writeOffBudgetVoucherHead.setFiscalPeriod(fromBudgetVoucherHead.getFiscalPeriod());
        writeOffBudgetVoucherHead.setBudgetProcess(fromBudgetVoucherHead.getBudgetProcess());
        writeOffBudgetVoucherHead.setDocumentDate(reverseBudgetVoucher.getReversalDocumentDate());
        writeOffBudgetVoucherHead.setVersionID(fromBudgetVoucherHead.getVersionID());
        writeOffBudgetVoucherHead.setBCSValType(fromBudgetVoucherHead.getBCSValType());
        writeOffBudgetVoucherHead.setTotalMoney(fromBudgetVoucherHead.getTotalMoney().negate());
        List efmBudgetVoucherDetails = budgetVoucher.efm_budgetVoucherDtls("AdditionalLine", (Object)"");
        for (EFM_BudgetVoucherDtl fromDtl : efmBudgetVoucherDetails) {
            EFM_BudgetVoucherDtl reverseDtl = writeOffBudgetVoucher.newEFM_BudgetVoucherDtl();
            reverseDtl.setBudgetTypeID(fromDtl.getBudgetTypeID());
            reverseDtl.setCommitmentItemID(fromDtl.getCommitmentItemID());
            reverseDtl.setFundCenterID(fromDtl.getFundCenterID());
            reverseDtl.setFundID(fromDtl.getFundID());
            reverseDtl.setFunctionalAreaID(fromDtl.getFunctionalAreaID());
            reverseDtl.setFundProgramID(fromDtl.getFundProgramID());
            reverseDtl.setFiscalYear(fromDtl.getFiscalYear());
            reverseDtl.setMoney(fromDtl.getMoney().negate());
            reverseDtl.setTVCurrencyID(fromDtl.getTVCurrencyID());
            reverseDtl.setNotes(fromDtl.getNotes());
            reverseDtl.setDistributionCode(fromDtl.getDistributionCode());
            reverseDtl.setDirection(fromDtl.getDirection());
            reverseDtl.setBCSValType(fromDtl.getBCSValType());
            reverseDtl.setBudgetProcess(fromDtl.getBudgetProcess());
        }
        return writeOffBudgetVoucher;
    }

    private List<FM_BudgetVoucher> getBudgetVoucher(FM_ReverseBudgetVoucher reverseBudgetVoucher) throws Throwable {
        EFM_BudgetVoucherHead_Loader budgetVoucherHeadLoader = EFM_BudgetVoucherHead.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(reverseBudgetVoucher.getFinancialManagementAreaID()).FiscalYear(reverseBudgetVoucher.getFiscalYear());
        if (!reverseBudgetVoucher.getBudgetProcess().equals("")) {
            budgetVoucherHeadLoader.BudgetProcess(reverseBudgetVoucher.getBudgetProcess());
        }
        if (reverseBudgetVoucher.getVersionID() != 0L) {
            budgetVoucherHeadLoader.VersionID(reverseBudgetVoucher.getVersionID());
        }
        if (reverseBudgetVoucher.getDocumentTypeID() != 0L) {
            budgetVoucherHeadLoader.DocumentTypeID(reverseBudgetVoucher.getDocumentTypeID());
        }
        if (!reverseBudgetVoucher.getDocumentStatus().equals("")) {
            budgetVoucherHeadLoader.Status(Integer.parseInt(reverseBudgetVoucher.getDocumentStatus()));
        }
        if (reverseBudgetVoucher.getCreatorID() != 0L) {
            budgetVoucherHeadLoader.Creator(reverseBudgetVoucher.getCreatorID());
        }
        if (!reverseBudgetVoucher.getReversalStatus().equals("")) {
            budgetVoucherHeadLoader.ReversalStatus(Integer.parseInt(reverseBudgetVoucher.getReversalStatus()));
        }
        if (reverseBudgetVoucher.getDocumentFromDate() != 0L && reverseBudgetVoucher.getDocumentToDate() != 0L) {
            budgetVoucherHeadLoader.DocumentDate(">=", reverseBudgetVoucher.getDocumentFromDate());
        } else if (reverseBudgetVoucher.getDocumentFromDate() != 0L) {
            budgetVoucherHeadLoader.DocumentDate(reverseBudgetVoucher.getDocumentFromDate());
        }
        if (reverseBudgetVoucher.getDocumentToDate() != 0L) {
            budgetVoucherHeadLoader.DocumentDate("<=", reverseBudgetVoucher.getDocumentToDate());
        }
        if (!reverseBudgetVoucher.getDocumentNumberFrom().equals("") && !reverseBudgetVoucher.getDocumentNumberTo().equals("")) {
            budgetVoucherHeadLoader.DocumentNumber(">=", reverseBudgetVoucher.getDocumentNumberFrom());
        } else if (!reverseBudgetVoucher.getDocumentNumberFrom().equals("")) {
            budgetVoucherHeadLoader.DocumentNumber(reverseBudgetVoucher.getDocumentNumberFrom());
        }
        if (!reverseBudgetVoucher.getDocumentNumberTo().equals("")) {
            budgetVoucherHeadLoader.DocumentNumber("<=", reverseBudgetVoucher.getDocumentNumberTo());
        }
        if (!reverseBudgetVoucher.getReversalDocumentNumberFrom().equals("") && !reverseBudgetVoucher.getReversalDocumentNumberTo().equals("")) {
            budgetVoucherHeadLoader.ReversalDocNo(">=", reverseBudgetVoucher.getReversalDocumentNumberFrom());
        } else if (!reverseBudgetVoucher.getReversalDocumentNumberFrom().equals("")) {
            budgetVoucherHeadLoader.ReversalDocNo(reverseBudgetVoucher.getReversalDocumentNumberFrom());
        }
        if (!reverseBudgetVoucher.getReversalDocumentNumberTo().equals("")) {
            budgetVoucherHeadLoader.ReversalDocNo("<=", reverseBudgetVoucher.getReversalDocumentNumberTo());
        }
        List budgetVoucherHeads = budgetVoucherHeadLoader.loadList();
        ArrayList<FM_BudgetVoucher> resultVouchers = new ArrayList<FM_BudgetVoucher>();
        if (budgetVoucherHeads != null && !budgetVoucherHeads.isEmpty()) {
            for (EFM_BudgetVoucherHead budgetVoucherHead : budgetVoucherHeads) {
                FM_BudgetVoucher fmCommitVoucher = FM_BudgetVoucher.load((RichDocumentContext)this.getMidContext(), (Long)budgetVoucherHead.getSOID());
                resultVouchers.add(fmCommitVoucher);
            }
        }
        return resultVouchers;
    }

    public String getComboxItems4DistributionCode(String valueList) {
        String[] valueLists;
        if (valueList.isEmpty()) {
            return this.getComboxItems4DistributionCode();
        }
        StringBuilder str = new StringBuilder();
        String[] stringArray = valueLists = valueList.split(";");
        int n = valueLists.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (str.length() > 0) {
                str.append(";");
            }
            str.append(String.format("%s,%s", value, FMComboxConstant.DistributionCode_Map.get(value)));
            ++n2;
        }
        return str.toString();
    }

    public String getComboxItems4DistributionCode() {
        String str = "";
        str = "-1,\u65e0";
        str = String.valueOf(str) + ";0,\u4eba\u5de5\u5206\u914d";
        str = String.valueOf(str) + ";1,\u5e73\u5747\u5206\u914d";
        return str;
    }

    public String getComboxItems4ValueType(String valueList) {
        String[] valueLists;
        if (valueList.isEmpty()) {
            return this.getComboxItems4ValueType();
        }
        StringBuilder str = new StringBuilder();
        String[] stringArray = valueLists = valueList.split(";");
        int n = valueLists.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (str.length() > 0) {
                str.append(";");
            }
            str.append(String.format("%s,%s", value, FMComboxConstant.ValueType_Map.get(value)));
            ++n2;
        }
        return str.toString();
    }

    public String getComboxItems4ValueType() {
        String str = "";
        str = "B1,\u9884\u7b97";
        str = String.valueOf(str) + ";R1,\u53d1\u5e03";
        str = String.valueOf(str) + ";A1,\u81ea\u52a8\u53d1\u5e03\u7684\u9884\u7b97";
        str = String.valueOf(str) + ";S1,\u7edf\u8ba1";
        return str;
    }
}

