/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.bcs;

import com.bokesoft.erp.billentity.EFM_BudgetBalance;
import com.bokesoft.erp.billentity.EFM_BudgetFreeze;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherDtl;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherHead;
import com.bokesoft.erp.billentity.EFM_BudgetVoucherPeriod;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_Ledger_Loader;
import com.bokesoft.erp.billentity.FM_BudgetFreeze;
import com.bokesoft.erp.billentity.FM_BudgetVoucher;
import com.bokesoft.erp.billentity.FM_FreezeBudgetData;
import com.bokesoft.erp.billentity.FM_FreezeBudgetDataResult;
import com.bokesoft.erp.billentity.FM_FreezeBudgetDataResultFreezeBudgetDataResultGrid_NODB;
import com.bokesoft.erp.billentity.FM_GenerateBudgetData;
import com.bokesoft.erp.billentity.FM_GenerateBudgetDataGenerateBudgetDataGrid_NODB;
import com.bokesoft.erp.billentity.FM_GenerateBudgetDataResult;
import com.bokesoft.erp.billentity.FM_GenerateBudgetDataResultGenerateBudgetDataResultGrid_NODB;
import com.bokesoft.erp.documentNumber.DocumentNumberUtil;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.bcs.BudgetVoucherFormula;
import com.bokesoft.erp.fm.enums.BudgetProcessEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;

public class BudgetDataFormula
extends EntityContextAction {
    public BudgetDataFormula(RichDocumentContext _context) {
        super(_context);
    }

    public void freezeBudgetData() throws Throwable {
        FM_FreezeBudgetData freezeBudgetData = FM_FreezeBudgetData.parseDocument((RichDocument)this.getDocument());
        Long fmAreaID = freezeBudgetData.getFinancialManagementAreaID();
        Long fromBudgetLedgerID = freezeBudgetData.getFromBudgetLedgerID();
        String fromBudgetLedgerCode = freezeBudgetData.getFromBudgetLedgerCode();
        Long toBudgetLedgerID = freezeBudgetData.getToBudgetLedgerID();
        String toBudgetLedgerCode = freezeBudgetData.getToBudgetLedgerCode();
        int fiscalYear = freezeBudgetData.getFiscalYear();
        int isBudget = freezeBudgetData.getIsBudget();
        int isRelease = freezeBudgetData.getIsRelease();
        Long fVersionID = freezeBudgetData.getFVersionID();
        Long tVersionID = freezeBudgetData.getTVersionID();
        int isTest = freezeBudgetData.getIsTest();
        if (isBudget == 0 && isRelease == 0) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA001");
        }
        if (isRelease == 1) {
            this.checkBudgetLedgerAndValueType(fromBudgetLedgerID, fromBudgetLedgerCode, toBudgetLedgerID, toBudgetLedgerCode);
        }
        this.checkFMAccount(freezeBudgetData);
        FM_FreezeBudgetDataResult freezeBudgetDataResult = (FM_FreezeBudgetDataResult)this.newBillEntity(FM_FreezeBudgetDataResult.class);
        freezeBudgetDataResult.setHeadFinancialManagementAreaID(fmAreaID);
        freezeBudgetDataResult.setFVersionID(fVersionID);
        freezeBudgetDataResult.setTVersionID(tVersionID);
        freezeBudgetDataResult.setHeadFiscalYear(fiscalYear);
        freezeBudgetDataResult.setIsTest(isTest);
        this.setHeadBudgetLedgerAndHeadBCSValType(fromBudgetLedgerID, fromBudgetLedgerCode, toBudgetLedgerID, toBudgetLedgerCode, isBudget, isRelease, freezeBudgetDataResult);
        AddressUtils addressUtils = new AddressUtils(this.getMidContext());
        List<EFM_BudgetBalance> fBudgetDatas = this.getBudgetDataForFreezeBudgetData(freezeBudgetData, fmAreaID, fiscalYear, isBudget, isRelease, fVersionID);
        if (fBudgetDatas == null || fBudgetDatas.size() == 0) {
            addressUtils.transOneNewTab("FM_FreezeBudgetDataResult", freezeBudgetDataResult.document.toJSON());
            return;
        }
        FM_BudgetFreeze fmBudgetFreeze = (FM_BudgetFreeze)this.newBillEntity(FM_BudgetFreeze.class);
        List<EFM_BudgetBalance> tBudgetDatas = this.getBudgetDataForFreezeBudgetData(freezeBudgetData, fmAreaID, fiscalYear, isBudget, isRelease, tVersionID);
        if (tBudgetDatas == null || tBudgetDatas.size() == 0) {
            for (EFM_BudgetBalance fBudgetData : fBudgetDatas) {
                this.createBudgetFreeze(fmBudgetFreeze, fBudgetData, tVersionID, null);
                this.cerateResult(freezeBudgetDataResult, fBudgetData);
            }
        } else {
            for (EFM_BudgetBalance fBudgetData : fBudgetDatas) {
                boolean isFrozen = false;
                for (EFM_BudgetBalance tBudgetData : tBudgetDatas) {
                    if (!this.isSameBudgetBlances(fBudgetData, tBudgetData)) continue;
                    BigDecimal fTotalAmount = BigDecimal.ZERO;
                    BigDecimal tTotalAmount = BigDecimal.ZERO;
                    int fiscalPeriod = 1;
                    while (fiscalPeriod <= 16) {
                        fTotalAmount = fTotalAmount.add(TypeConvertor.toBigDecimal((Object)fBudgetData.valueByColumnName("TSLMoney" + fiscalPeriod)));
                        tTotalAmount = tTotalAmount.add(TypeConvertor.toBigDecimal((Object)tBudgetData.valueByColumnName("TSLMoney" + fiscalPeriod)));
                        ++fiscalPeriod;
                    }
                    if (fTotalAmount.abs().compareTo(tTotalAmount.abs()) > 0) {
                        this.createBudgetFreeze(fmBudgetFreeze, fBudgetData, tVersionID, tBudgetData);
                        this.cerateResult(freezeBudgetDataResult, fBudgetData);
                    }
                    isFrozen = true;
                    break;
                }
                if (isFrozen) continue;
                this.createBudgetFreeze(fmBudgetFreeze, fBudgetData, tVersionID, null);
                this.cerateResult(freezeBudgetDataResult, fBudgetData);
            }
        }
        addressUtils.transOneNewTab("FM_FreezeBudgetDataResult", freezeBudgetDataResult.document.toJSON());
        List efmBudgetFreezes = fmBudgetFreeze.efm_budgetFreezes();
        if (!efmBudgetFreezes.isEmpty() && isTest == 0) {
            this.save((AbstractBillEntity)fmBudgetFreeze);
        }
    }

    private void checkFMAccount(FM_FreezeBudgetData freezeBudgetData) throws Throwable {
        if ((freezeBudgetData.getFromCommitmentItemID() > 0L || freezeBudgetData.getToCommitmentItemID() > 0L) && freezeBudgetData.getCommitmentItemGroupID() > 0L) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA002");
        }
        if ((freezeBudgetData.getFromFundCenterID() > 0L || freezeBudgetData.getToFundCenterID() > 0L) && freezeBudgetData.getFundCenterGroupID() > 0L) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA002");
        }
        if ((freezeBudgetData.getFromFundID() > 0L || freezeBudgetData.getToFundID() > 0L) && freezeBudgetData.getFundGroupID() > 0L) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA002");
        }
        if ((freezeBudgetData.getFromFundProgramID() > 0L || freezeBudgetData.getToFundProgramID() > 0L) && freezeBudgetData.getFundProgramGroupID() > 0L) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA002");
        }
    }

    private void cerateResult(FM_FreezeBudgetDataResult freezeBudgetDataResult, EFM_BudgetBalance fBudgetData) throws Throwable {
        FM_FreezeBudgetDataResultFreezeBudgetDataResultGrid_NODB fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb = freezeBudgetDataResult.newFM_FreezeBudgetDataResultFreezeBudgetDataResultGrid_NODB();
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setCommitmentItemID(fBudgetData.getCommitmentItemID());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setFundCenterID(fBudgetData.getFundCenterID());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setFundID(fBudgetData.getFundID());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setFundProgramID(fBudgetData.getFundProgramID());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setFunctionalAreaID(fBudgetData.getFunctionalAreaID());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setBudgetProcess(fBudgetData.getBudgetProcess());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setBudgetLedgerID(fBudgetData.getLedgerID());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setWorkFlowStatus(fBudgetData.getWorkFlowStatus());
        fmFreezeBudgetDataResultFreezeBudgetDataResultGridNodb.setBudgetTypeID(fBudgetData.getBudgetTypeID());
    }

    private void setHeadBudgetLedgerAndHeadBCSValType(Long fromBudgetLedgerID, String fromBudgetLedgerCode, Long toBudgetLedgerID, String toBudgetLedgerCode, int isBudget, int isRelease, FM_FreezeBudgetDataResult freezeBudgetDataResult) throws Throwable {
        EFM_Ledger_Loader ledgerLoader = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).LedgerType(1);
        if (fromBudgetLedgerID.compareTo(0L) > 0 && toBudgetLedgerID.compareTo(0L) > 0) {
            ledgerLoader.Code(">=", fromBudgetLedgerCode);
        } else if (fromBudgetLedgerID.compareTo(0L) > 0) {
            ledgerLoader.Code(fromBudgetLedgerCode);
        }
        if (toBudgetLedgerID.compareTo(0L) > 0) {
            ledgerLoader.Code("<=", toBudgetLedgerCode);
        }
        List efmLedgers = ledgerLoader.loadList();
        StringBuilder headBudgetLedgerID = new StringBuilder();
        if (efmLedgers != null) {
            for (EFM_Ledger efmLedger : efmLedgers) {
                headBudgetLedgerID.append(efmLedger.getOID()).append(",");
            }
        }
        freezeBudgetDataResult.setHeadBudgetLedgerID(headBudgetLedgerID.toString());
        StringBuilder valueType = new StringBuilder();
        if (isBudget == 1) {
            valueType.append("\u9884\u7b97,");
        }
        if (isRelease == 1) {
            valueType.append("\u53d1\u5e03");
        }
        freezeBudgetDataResult.setHeadBCSValType(valueType.toString());
    }

    private boolean isSameBudgetBlances(EFM_BudgetBalance fBudgetData, EFM_BudgetBalance tBudgetData) throws Throwable {
        return fBudgetData.getFinancialManagementAreaID().equals(tBudgetData.getFinancialManagementAreaID()) && fBudgetData.getLedgerID().equals(tBudgetData.getLedgerID()) && fBudgetData.getFiscalYear() == tBudgetData.getFiscalYear() && fBudgetData.getFundID().equals(tBudgetData.getFundID()) && fBudgetData.getFundCenterID().equals(tBudgetData.getFundCenterID()) && fBudgetData.getCommitmentItemID().equals(tBudgetData.getCommitmentItemID()) && fBudgetData.getFunctionalAreaID().equals(tBudgetData.getFunctionalAreaID()) && fBudgetData.getBCSValType().equals(tBudgetData.getBCSValType()) && fBudgetData.getWorkFlowStatus().equals(tBudgetData.getWorkFlowStatus()) && fBudgetData.getBudgetProcess().equals(tBudgetData.getBudgetProcess()) && fBudgetData.getBudgetTypeID().equals(tBudgetData.getBudgetTypeID());
    }

    private void createBudgetFreeze(FM_BudgetFreeze fmBudgetFreeze, EFM_BudgetBalance fBudgetData, Long tVersionID, EFM_BudgetBalance tBudgetData) throws Throwable {
        EFM_BudgetFreeze efmBudgetFreeze = fmBudgetFreeze.newEFM_BudgetFreeze();
        efmBudgetFreeze.setLedgerID(fBudgetData.getLedgerID());
        efmBudgetFreeze.setRecordType(fBudgetData.getRecordType());
        efmBudgetFreeze.setVersionID(tVersionID);
        efmBudgetFreeze.setFiscalYear(fBudgetData.getFiscalYear());
        efmBudgetFreeze.setCurrencyID(fBudgetData.getCurrencyID());
        efmBudgetFreeze.setFinancialManagementAreaID(fBudgetData.getFinancialManagementAreaID());
        efmBudgetFreeze.setFundID(fBudgetData.getFundID());
        efmBudgetFreeze.setFundCenterID(fBudgetData.getFundCenterID());
        efmBudgetFreeze.setCommitmentItemID(fBudgetData.getCommitmentItemID());
        efmBudgetFreeze.setFunctionalAreaID(fBudgetData.getFunctionalAreaID());
        efmBudgetFreeze.setFundProgramID(fBudgetData.getFundProgramID());
        efmBudgetFreeze.setBCSValType(fBudgetData.getBCSValType());
        efmBudgetFreeze.setWorkFlowStatus(fBudgetData.getWorkFlowStatus());
        efmBudgetFreeze.setBudgetProcess(fBudgetData.getBudgetProcess());
        efmBudgetFreeze.setBudgetTypeID(fBudgetData.getBudgetTypeID());
        efmBudgetFreeze.setCommitmentItemType(fBudgetData.getCommitmentItemType());
        efmBudgetFreeze.setBudgetAddress(fBudgetData.getBudgetAddress());
        if (tBudgetData == null) {
            int fiscalPeriod = 1;
            while (fiscalPeriod <= 16) {
                efmBudgetFreeze.valueByColumnName("TSLMoney" + fiscalPeriod, (Object)TypeConvertor.toBigDecimal((Object)fBudgetData.valueByColumnName("TSLMoney" + fiscalPeriod)));
                efmBudgetFreeze.valueByColumnName("HSLMoney" + fiscalPeriod, (Object)TypeConvertor.toBigDecimal((Object)fBudgetData.valueByColumnName("HSLMoney" + fiscalPeriod)));
                ++fiscalPeriod;
            }
        } else {
            int fiscalPeriod = 1;
            while (fiscalPeriod <= 16) {
                BigDecimal tSLAmountAmount = TypeConvertor.toBigDecimal((Object)fBudgetData.valueByColumnName("TSLMoney" + fiscalPeriod)).subtract(TypeConvertor.toBigDecimal((Object)tBudgetData.valueByColumnName("TSLMoney" + fiscalPeriod)));
                efmBudgetFreeze.valueByColumnName("TSLMoney" + fiscalPeriod, (Object)tSLAmountAmount);
                BigDecimal hSLAmountAmount = TypeConvertor.toBigDecimal((Object)fBudgetData.valueByColumnName("HSLMoney" + fiscalPeriod)).subtract(TypeConvertor.toBigDecimal((Object)tBudgetData.valueByColumnName("HSLMoney" + fiscalPeriod)));
                efmBudgetFreeze.valueByColumnName("HSLMoney" + fiscalPeriod, (Object)hSLAmountAmount);
                ++fiscalPeriod;
            }
        }
    }

    private List<EFM_BudgetBalance> getBudgetDataForFreezeBudgetData(FM_FreezeBudgetData freezeBudgetData, Long fmAreaID, int fiscalYear, int isBudget, int isRelease, Long versionID) throws Throwable {
        SqlString sqlString = new SqlString();
        sqlString.append(new Object[]{"select * from "}).append(new Object[]{"EFM_BudgetBalance"}).append(new Object[]{" where "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"VersionID"}).append(new Object[]{" = "}).appendPara((Object)versionID);
        if (fiscalYear > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)fiscalYear);
        }
        if (isBudget == 1 && isRelease != 1) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"BCSValType"}).append(new Object[]{" = "}).appendPara((Object)"B1");
        } else if (isBudget != 1 && isRelease == 1) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"BCSValType"}).append(new Object[]{" = "}).appendPara((Object)"R1");
        }
        if (freezeBudgetData.getFromBudgetLedgerID().compareTo(0L) > 0 && freezeBudgetData.getToBudgetLedgerID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" >= "}).appendPara((Object)freezeBudgetData.getFromBudgetLedgerCode());
        } else if (freezeBudgetData.getFromBudgetLedgerID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFromBudgetLedgerCode());
        }
        if (freezeBudgetData.getToBudgetLedgerID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" <= "}).appendPara((Object)freezeBudgetData.getToBudgetLedgerCode());
        }
        if (freezeBudgetData.getFromCommitmentItemID().compareTo(0L) > 0 && freezeBudgetData.getToCommitmentItemID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" >= "}).appendPara((Object)freezeBudgetData.getFromCommitItemCode());
        } else if (freezeBudgetData.getFromCommitmentItemID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFromCommitItemCode());
        }
        if (freezeBudgetData.getToCommitmentItemID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" <= "}).appendPara((Object)freezeBudgetData.getToCommitItemCode());
        }
        if (freezeBudgetData.getCommitmentItemGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemID"}).append(new Object[]{" in( select "}).append(new Object[]{"CommitmentItemID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_CommitmentItemGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getCommitmentItemGroupID()).append(new Object[]{")"});
        }
        if (freezeBudgetData.getFromFundCenterID().compareTo(0L) > 0 && freezeBudgetData.getToFundCenterID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" >= "}).appendPara((Object)freezeBudgetData.getFromFundCenterCode());
        } else if (freezeBudgetData.getFromFundCenterID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFromFundCenterCode());
        }
        if (freezeBudgetData.getToFundCenterID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" <= "}).appendPara((Object)freezeBudgetData.getToFundCenterCode());
        }
        if (freezeBudgetData.getFundCenterGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterID"}).append(new Object[]{" in( select "}).append(new Object[]{"FundCenterID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_FundCenterGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFundCenterGroupID()).append(new Object[]{")"});
        }
        if (freezeBudgetData.getFromFundID().compareTo(0L) > 0 && freezeBudgetData.getToFundID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" >= "}).appendPara((Object)freezeBudgetData.getFromFundCode());
        } else if (freezeBudgetData.getFromFundID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFromFundCode());
        }
        if (freezeBudgetData.getToFundID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" <= "}).appendPara((Object)freezeBudgetData.getToFundCode());
        }
        if (freezeBudgetData.getFundGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundID"}).append(new Object[]{" in( select "}).append(new Object[]{"FundID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_FundGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFundGroupID()).append(new Object[]{")"});
        }
        if (freezeBudgetData.getFromFunctionalAreaID().compareTo(0L) > 0 && freezeBudgetData.getToFunctionalAreaID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" >= "}).appendPara((Object)freezeBudgetData.getFromFunctionAreaCode());
        } else if (freezeBudgetData.getFromFunctionalAreaID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFromFunctionAreaCode());
        }
        if (freezeBudgetData.getToFunctionalAreaID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" <= "}).appendPara((Object)freezeBudgetData.getToFunctionAreaCode());
        }
        if (freezeBudgetData.getFromFundProgramID().compareTo(0L) > 0 && freezeBudgetData.getToFundProgramID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" >= "}).appendPara((Object)freezeBudgetData.getFromFundProgramCode());
        } else if (freezeBudgetData.getFromFundProgramID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFromFundProgramCode());
        }
        if (freezeBudgetData.getToFundProgramID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" <= "}).appendPara((Object)freezeBudgetData.getToFundProgramCode());
        }
        if (freezeBudgetData.getFundProgramGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramID"}).append(new Object[]{" in( select "}).append(new Object[]{"FundProgramID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_FundProgramGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)freezeBudgetData.getFundProgramGroupID()).append(new Object[]{")"});
        }
        return EFM_BudgetBalance.parseRowset((RichDocumentContext)this._context, (DataTable)this.getMidContext().getResultSet(sqlString));
    }

    private void checkBudgetLedgerAndValueType(Long fromBudgetLedgerID, String fromBudgetLedgerCode, Long toBudgetLedgerID, String toBudgetLedgerCode) throws Throwable {
        if (fromBudgetLedgerID.compareTo(0L) == 0 && toBudgetLedgerID.compareTo(0L) == 0) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA000");
        }
        if ("9J".equals(fromBudgetLedgerCode) || "9J".equals(toBudgetLedgerCode)) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA000");
        }
    }

    public void generateBudgetData() throws Throwable {
        FM_GenerateBudgetData generateBudgetData = FM_GenerateBudgetData.parseDocument((RichDocument)this.getDocument());
        Long fmAreaID = generateBudgetData.getFinancialManagementAreaID();
        Long srcVersionID = generateBudgetData.getSrcVersionID();
        int srcFiscalYear = generateBudgetData.getSrcFiscalYear();
        int srcFromPeriod = generateBudgetData.getSrcFromPeriod();
        int srcToPeriod = generateBudgetData.getSrcToPeriod();
        String valType = generateBudgetData.getValType();
        String allProcessAndBudgetTypes = generateBudgetData.getAllProcessAndBudgetTypes();
        Long reassessment = generateBudgetData.getReassessment();
        Long objectVersionID = generateBudgetData.getObjectVersionID();
        int objectFiscalYear = generateBudgetData.getObjectFiscalYear();
        String objectPeriod = generateBudgetData.getObjectPeriod();
        int objectFromPeriod = generateBudgetData.getObjectFromPeriod();
        int objectToPeriod = generateBudgetData.getObjectToPeriod();
        String copyBudgetType = generateBudgetData.getCopyBudgetType();
        Long budgetTypeID = generateBudgetData.getBudgetTypeID();
        String updateMode = generateBudgetData.getUpdateMode();
        int isTest = generateBudgetData.getIsTest();
        if ("0".equals(objectPeriod) && srcToPeriod - srcFromPeriod != objectToPeriod - objectFromPeriod) {
            MessageFacade.throwException((String)"BUDGETDATAFORMULA003");
        }
        if ("R1".equals(valType)) {
            if ("0".equals(allProcessAndBudgetTypes)) {
                MessageFacade.throwException((String)"BUDGETDATAFORMULA004");
            }
            if ("0".equals(copyBudgetType)) {
                MessageFacade.throwException((String)"BUDGETDATAFORMULA005");
            }
        }
        FM_GenerateBudgetDataResult generateBudgetDataResult = (FM_GenerateBudgetDataResult)this.newBillEntity(FM_GenerateBudgetDataResult.class);
        generateBudgetDataResult.setFinancialManagementAreaID(fmAreaID);
        generateBudgetDataResult.setSrcFiscalYear(srcFiscalYear);
        generateBudgetDataResult.setObjectFiscalYear(objectFiscalYear);
        generateBudgetDataResult.setSrcVersionID(srcVersionID);
        generateBudgetDataResult.setObjectVersionID(objectVersionID);
        generateBudgetDataResult.setSrcFromPeriod(srcFromPeriod);
        generateBudgetDataResult.setSrcToPeriod(srcToPeriod);
        generateBudgetDataResult.setObjectFromPeriod(objectFromPeriod);
        generateBudgetDataResult.setObjectToPeriod(objectToPeriod);
        generateBudgetDataResult.setDistributionCode(generateBudgetData.getDistributionPlan());
        generateBudgetDataResult.setValueType(valType);
        generateBudgetDataResult.setReassessment(reassessment);
        generateBudgetDataResult.setIsTest(isTest);
        AddressUtils addressUtils = new AddressUtils(this.getMidContext());
        List<EFM_BudgetBalance> fBudgetDatas = this.getSrcBudgetData(generateBudgetData, fmAreaID, srcVersionID, srcFiscalYear);
        this.cardinalityCalculation(generateBudgetData, fBudgetDatas);
        if (fBudgetDatas == null || fBudgetDatas.size() == 0) {
            addressUtils.transOneNewTab("FM_GenerateBudgetDataResult", generateBudgetDataResult.document.toJSON());
            return;
        }
        List<EFM_BudgetBalance> tBudgetDatas = this.getObjectBudgetData(fmAreaID, objectVersionID, objectFiscalYear, copyBudgetType, budgetTypeID, updateMode, fBudgetDatas);
        Map<String, List<EFM_BudgetBalance>> resultMap = fBudgetDatas.stream().collect(Collectors.groupingBy(b -> {
            try {
                if (generateBudgetData.getIsGroupCommitment() > 0) {
                    return b.getFundID() + "|" + b.getCommitmentItemID();
                }
                if (generateBudgetData.getIsGroupFundCenter() > 0) {
                    return b.getFundID() + "|" + b.getFundCenterID();
                }
                return b.getFundID().toString();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }));
        ArrayList<FM_BudgetVoucher> budgetVoucherList = new ArrayList<FM_BudgetVoucher>();
        int temporaryDocumentNumber = 1;
        for (List<EFM_BudgetBalance> budgetBalances : resultMap.values()) {
            FM_BudgetVoucher fmBudgetVoucher = (FM_BudgetVoucher)this.newBillEntity(FM_BudgetVoucher.class);
            EFM_BudgetVoucherHead budgetVoucherHead = fmBudgetVoucher.efm_budgetVoucherHead();
            if (isTest == 0) {
                budgetVoucherHead.setDocumentNumber(DocumentNumberUtil.getDocNumber((RichDocumentContext)this.getMidContext(), (RichDocument)fmBudgetVoucher.document, (String)"DocumentNumber"));
            }
            budgetVoucherHead.setFinancialManagementAreaID(fmAreaID);
            budgetVoucherHead.setBCSValType("B1");
            budgetVoucherHead.setDocumentDate(generateBudgetData.getDocumentDate());
            budgetVoucherHead.setVersionID(objectVersionID);
            budgetVoucherHead.setFiscalYear(objectFiscalYear);
            budgetVoucherHead.setDocumentTypeID(generateBudgetData.getDocumentTypeID());
            if ("0".equals(copyBudgetType)) {
                budgetVoucherHead.setBudgetTypeID(budgetBalances.get(0).getBudgetTypeID());
            } else {
                budgetVoucherHead.setBudgetTypeID(budgetTypeID);
            }
            budgetVoucherHead.setBudgetLedgerID(budgetBalances.get(0).getLedgerID());
            budgetVoucherHead.setBudgetProcess(BudgetProcessEnum.ENTR.getKey());
            int itemRowNo = 1;
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (EFM_BudgetBalance budgetBalance : budgetBalances) {
                boolean isExist = false;
                if ("2".equals(updateMode) && tBudgetDatas != null && tBudgetDatas.size() > 0) {
                    for (EFM_BudgetBalance tBudgetData : tBudgetDatas) {
                        if (!tBudgetData.getBudgetAddress().equals(budgetBalance.getBudgetAddress())) continue;
                        isExist = true;
                        break;
                    }
                }
                if (isExist) continue;
                EFM_BudgetVoucherDtl budgetVoucherDetail = fmBudgetVoucher.newEFM_BudgetVoucherDtl();
                budgetVoucherDetail.setCommitmentItemID(budgetBalance.getCommitmentItemID());
                budgetVoucherDetail.setFundCenterID(budgetBalance.getFundCenterID());
                budgetVoucherDetail.setFundID(budgetBalance.getFundID());
                budgetVoucherDetail.setFunctionalAreaID(budgetBalance.getFunctionalAreaID());
                budgetVoucherDetail.setFundProgramID(budgetBalance.getFundProgramID());
                budgetVoucherDetail.setDistributionCode(-1);
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal reassessmentValue = BigDecimal.valueOf(reassessment / 100L);
                int beginPeriod = srcFromPeriod;
                while (beginPeriod <= Math.min(srcToPeriod, 16)) {
                    amount = amount.add(TypeConvertor.toBigDecimal((Object)budgetBalance.valueByColumnName("TSLMoney" + beginPeriod)));
                    ++beginPeriod;
                }
                amount = amount.abs();
                if (BudgetProcessEnum.RETN.getKey().equals(budgetBalance.getBudgetProcess()) || BudgetProcessEnum.COSD.getKey().equals(budgetBalance.getBudgetProcess())) {
                    amount = amount.negate();
                }
                EFM_BudgetBalance dataResetAndOverwritten = null;
                if ("0".equals(updateMode) && tBudgetDatas != null && tBudgetDatas.size() > 0) {
                    for (EFM_BudgetBalance tBudgetData : tBudgetDatas) {
                        if (!tBudgetData.getBudgetAddress().equals(budgetBalance.getBudgetAddress())) continue;
                        BigDecimal tAmount = BigDecimal.ZERO;
                        int beginPeriod2 = 1;
                        int endPeriod = 16;
                        if ("0".equals(objectPeriod)) {
                            beginPeriod2 = objectFromPeriod;
                            endPeriod = objectToPeriod;
                        }
                        while (beginPeriod2 <= endPeriod) {
                            tAmount = tAmount.add(TypeConvertor.toBigDecimal((Object)tBudgetData.valueByColumnName("TSLMoney" + beginPeriod2)));
                            ++beginPeriod2;
                        }
                        amount = amount.multiply(reassessmentValue).subtract(tAmount);
                        dataResetAndOverwritten = tBudgetData;
                        break;
                    }
                }
                if (amount.compareTo(BigDecimal.ZERO) == 0) {
                    fmBudgetVoucher.deleteEFM_BudgetVoucherDtl(budgetVoucherDetail);
                    break;
                }
                budgetVoucherDetail.setMoney(amount);
                this.generateBudgetVourcherPeriod(srcFromPeriod, srcToPeriod, objectPeriod, objectFromPeriod, fmBudgetVoucher, budgetBalance, budgetVoucherDetail, amount, reassessmentValue, dataResetAndOverwritten);
                totalAmount = totalAmount.add(budgetVoucherDetail.getMoney());
                FM_GenerateBudgetDataResultGenerateBudgetDataResultGrid_NODB generateBudgetDataResultGenerateBudgetDataResultGridNodb = generateBudgetDataResult.newFM_GenerateBudgetDataResultGenerateBudgetDataResultGrid_NODB();
                if (isTest == 1) {
                    generateBudgetDataResultGenerateBudgetDataResultGridNodb.setDocumentNumber(String.valueOf(temporaryDocumentNumber));
                } else {
                    generateBudgetDataResultGenerateBudgetDataResultGridNodb.setVourcherOID(String.valueOf(fmBudgetVoucher.getOID()));
                    generateBudgetDataResultGenerateBudgetDataResultGridNodb.setDocumentNumber(budgetVoucherHead.getDocumentNumber());
                }
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setItemRowNo(itemRowNo++);
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setCommitmentItemID(budgetBalance.getCommitmentItemID());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setFundCenterID(budgetBalance.getFundCenterID());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setFundID(budgetBalance.getFundID());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setFunctionalAreaID(budgetBalance.getFunctionalAreaID());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setFundProgramID(budgetBalance.getFundProgramID());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setBudgetLedgerID(budgetBalance.getLedgerID());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setBudgetProcess(BudgetProcessEnum.ENTR.getKey());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setBudgetTypeID(budgetVoucherDetail.getBudgetTypeID());
                generateBudgetDataResultGenerateBudgetDataResultGridNodb.setAmount(budgetVoucherDetail.getMoney());
            }
            if (fmBudgetVoucher.efm_budgetVoucherDtls() == null || fmBudgetVoucher.efm_budgetVoucherDtls().size() <= 0) continue;
            budgetVoucherHead.setTotalMoney(totalAmount);
            budgetVoucherList.add(fmBudgetVoucher);
            ++temporaryDocumentNumber;
        }
        addressUtils.transOneNewTab("FM_GenerateBudgetDataResult", generateBudgetDataResult.document.toJSON());
        if (!budgetVoucherList.isEmpty() && isTest == 0) {
            for (FM_BudgetVoucher budgetVoucher : budgetVoucherList) {
                this.save((AbstractBillEntity)budgetVoucher);
            }
        }
    }

    private void generateBudgetVourcherPeriod(int srcFromPeriod, int srcToPeriod, String objectPeriod, int objectFromPeriod, FM_BudgetVoucher fmBudgetVoucher, EFM_BudgetBalance budgetBalance, EFM_BudgetVoucherDtl budgetVoucherDetail, BigDecimal amount, BigDecimal reassessmentValue, EFM_BudgetBalance dataResetAndOverwritten) throws Throwable {
        if ("0".equals(objectPeriod)) {
            int periodInterval = srcFromPeriod - objectFromPeriod;
            int beginPeriod = srcFromPeriod;
            while (beginPeriod <= srcToPeriod) {
                EFM_BudgetVoucherPeriod budgetVoucherPeriod = fmBudgetVoucher.newEFM_BudgetVoucherPeriod();
                budgetVoucherPeriod.setPOID(budgetVoucherDetail.getOID());
                budgetVoucherPeriod.setFiscalPeriod(beginPeriod - periodInterval);
                BigDecimal periodTSLAmount = TypeConvertor.toBigDecimal((Object)budgetBalance.valueByColumnName("TSLMoney" + beginPeriod)).multiply(reassessmentValue);
                BigDecimal periodHSLAmount = TypeConvertor.toBigDecimal((Object)budgetBalance.valueByColumnName("HSLMoney" + beginPeriod)).multiply(reassessmentValue);
                if (dataResetAndOverwritten != null) {
                    BigDecimal amountSymbol = "3".equals(budgetBalance.getCommitmentItemType()) ? BigDecimal.ONE : new BigDecimal("-1");
                    budgetVoucherPeriod.setBudgetMoney(periodTSLAmount.subtract(TypeConvertor.toBigDecimal((Object)dataResetAndOverwritten.valueByColumnName("TSLMoney" + (beginPeriod - periodInterval)))).multiply(amountSymbol));
                    budgetVoucherPeriod.setLVALMoney(periodHSLAmount.subtract(TypeConvertor.toBigDecimal((Object)dataResetAndOverwritten.valueByColumnName("HSLMoney" + (beginPeriod - periodInterval)))).multiply(amountSymbol));
                } else {
                    budgetVoucherPeriod.setBudgetMoney(periodTSLAmount.abs().multiply(BigDecimal.valueOf(amount.signum())));
                    budgetVoucherPeriod.setLVALMoney(periodHSLAmount.abs().multiply(BigDecimal.valueOf(amount.signum())));
                }
                budgetVoucherPeriod.setDistributionCode(-1);
                ++beginPeriod;
            }
        } else {
            BudgetVoucherFormula budgetVoucherFormula = new BudgetVoucherFormula(this.getMidContext());
            budgetVoucherFormula.allocatAmount(budgetVoucherDetail.getOID(), fmBudgetVoucher, 12, 16, amount, budgetVoucherDetail.getDirection());
        }
    }

    private List<EFM_BudgetBalance> getObjectBudgetData(Long fmAreaID, Long objectVersionID, int objectFiscalYear, String copyBudgetType, Long budgetTypeID, String updateMode, List<EFM_BudgetBalance> fBudgetDatas) throws Throwable {
        if ("0".equals(updateMode) || "2".equals(updateMode)) {
            SqlString sqlString = new SqlString();
            sqlString.append(new Object[]{"select * from "}).append(new Object[]{"EFM_BudgetBalance"}).append(new Object[]{" where "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"VersionID"}).append(new Object[]{" = "}).appendPara((Object)objectVersionID).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)objectFiscalYear);
            if ("0".equals(copyBudgetType)) {
                sqlString.append(new Object[]{" and "}).append(new Object[]{"BudgetTypeID"}).append(new Object[]{" = "}).appendPara((Object)fBudgetDatas.get(0).getBudgetTypeID());
            } else {
                sqlString.append(new Object[]{" and "}).append(new Object[]{"BudgetTypeID"}).append(new Object[]{" = "}).appendPara((Object)budgetTypeID);
            }
            return EFM_BudgetBalance.parseRowset((RichDocumentContext)this._context, (DataTable)this.getMidContext().getResultSet(sqlString));
        }
        return null;
    }

    private void cardinalityCalculation(FM_GenerateBudgetData generateBudgetData, List<EFM_BudgetBalance> fBudgetDatas) throws Throwable {
        if (fBudgetDatas != null && fBudgetDatas.size() > 0) {
            ListIterator<EFM_BudgetBalance> listIterator = fBudgetDatas.listIterator();
            while (listIterator.hasNext()) {
                EFM_BudgetBalance budgetBalance = listIterator.next();
                if (!budgetBalance.getBCSValType().equals(generateBudgetData.getValType())) {
                    listIterator.remove();
                }
                if (!"2".equals(generateBudgetData.getAllProcessAndBudgetTypes())) continue;
                List generateBudgetDataGenerateBudgetDataGridNodbs = generateBudgetData.fm_generateBudgetDataGenerateBudgetDataGrid_NODBs();
                boolean isExist = false;
                for (FM_GenerateBudgetDataGenerateBudgetDataGrid_NODB generateBudgetDataGenerateBudgetDataGridNodb : generateBudgetDataGenerateBudgetDataGridNodbs) {
                    if (!budgetBalance.getBudgetTypeID().equals(generateBudgetDataGenerateBudgetDataGridNodb.getMergeBudgetTypeID()) || !budgetBalance.getBudgetProcess().equals(generateBudgetDataGenerateBudgetDataGridNodb.getMergeBudgetProcess())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                listIterator.remove();
            }
        }
    }

    private List<EFM_BudgetBalance> getSrcBudgetData(FM_GenerateBudgetData generateBudgetData, Long fmAreaID, Long srcVersionID, int srcFiscalYear) throws Throwable {
        SqlString sqlString = new SqlString();
        sqlString.append(new Object[]{"select * from "}).append(new Object[]{"EFM_BudgetBalance"}).append(new Object[]{" where "}).append(new Object[]{"FinancialManagementAreaID"}).append(new Object[]{" = "}).appendPara((Object)fmAreaID).append(new Object[]{" and "}).append(new Object[]{"VersionID"}).append(new Object[]{" = "}).appendPara((Object)srcVersionID).append(new Object[]{" and "}).append(new Object[]{"FiscalYear"}).append(new Object[]{" = "}).appendPara((Object)srcFiscalYear);
        if (generateBudgetData.getSrcFromBudgetLedgerID().compareTo(0L) > 0 && generateBudgetData.getSrcToBudgetLedgerID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" >= "}).appendPara((Object)generateBudgetData.getSrcFromBudgetLedgerCode());
        } else if (generateBudgetData.getSrcFromBudgetLedgerID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getSrcFromBudgetLedgerCode());
        }
        if (generateBudgetData.getSrcToBudgetLedgerID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"LedgerCode"}).append(new Object[]{" <= "}).appendPara((Object)generateBudgetData.getSrcToBudgetLedgerCode());
        }
        if (generateBudgetData.getFromCommitmentItemID().compareTo(0L) > 0 && generateBudgetData.getToCommitmentItemID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" >= "}).appendPara((Object)generateBudgetData.getFromCommitItemCode());
        } else if (generateBudgetData.getFromCommitmentItemID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFromCommitItemCode());
        }
        if (generateBudgetData.getToCommitmentItemID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemCode"}).append(new Object[]{" <= "}).appendPara((Object)generateBudgetData.getToCommitItemCode());
        }
        if (generateBudgetData.getCommitmentItemGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"CommitmentItemID"}).append(new Object[]{" in( select "}).append(new Object[]{"CommitmentItemID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_CommitmentItemGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getCommitmentItemGroupID()).append(new Object[]{")"});
        }
        if (generateBudgetData.getFromFundCenterID().compareTo(0L) > 0 && generateBudgetData.getToFundCenterID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" >= "}).appendPara((Object)generateBudgetData.getFromFundCenterCode());
        } else if (generateBudgetData.getFromFundCenterID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFromFundCenterCode());
        }
        if (generateBudgetData.getToFundCenterID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterCode"}).append(new Object[]{" <= "}).appendPara((Object)generateBudgetData.getToFundCenterCode());
        }
        if (generateBudgetData.getFundCenterGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCenterID"}).append(new Object[]{" in( select "}).append(new Object[]{"FundCenterID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_FundCenterGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFundCenterGroupID()).append(new Object[]{")"});
        }
        if (generateBudgetData.getFromFundID().compareTo(0L) > 0 && generateBudgetData.getToFundID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" >= "}).appendPara((Object)generateBudgetData.getFromFundCode());
        } else if (generateBudgetData.getFromFundID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFromFundCode());
        }
        if (generateBudgetData.getToFundID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundCode"}).append(new Object[]{" <= "}).appendPara((Object)generateBudgetData.getToFundCode());
        }
        if (generateBudgetData.getFundGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundID"}).append(new Object[]{" in( select "}).append(new Object[]{"FundID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_FundGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFundGroupID()).append(new Object[]{")"});
        }
        if (generateBudgetData.getFromFunctionalAreaID().compareTo(0L) > 0 && generateBudgetData.getToFunctionalAreaID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" >= "}).appendPara((Object)generateBudgetData.getFromFunctionAreaCode());
        } else if (generateBudgetData.getFromFunctionalAreaID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFromFunctionAreaCode());
        }
        if (generateBudgetData.getToFunctionalAreaID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FunctionAreaCode"}).append(new Object[]{" <= "}).appendPara((Object)generateBudgetData.getToFunctionAreaCode());
        }
        if (generateBudgetData.getFromFundProgramID().compareTo(0L) > 0 && generateBudgetData.getToFundProgramID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" >= "}).appendPara((Object)generateBudgetData.getFromFundProgramCode());
        } else if (generateBudgetData.getFromFundProgramID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFromFundProgramCode());
        }
        if (generateBudgetData.getToFundProgramID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramCode"}).append(new Object[]{" <= "}).appendPara((Object)generateBudgetData.getToFundProgramCode());
        }
        if (generateBudgetData.getFundProgramGroupID().compareTo(0L) > 0) {
            sqlString.append(new Object[]{" and "}).append(new Object[]{"FundProgramID"}).append(new Object[]{" in( select "}).append(new Object[]{"FundProgramID"}).append(new Object[]{" from "}).append(new Object[]{"EFM_FundProgramGroupDtl"}).append(new Object[]{" where "}).append(new Object[]{"SOID"}).append(new Object[]{" = "}).appendPara((Object)generateBudgetData.getFundProgramGroupID()).append(new Object[]{")"});
        }
        return EFM_BudgetBalance.parseRowset((RichDocumentContext)this._context, (DataTable)this.getMidContext().getResultSet(sqlString));
    }
}

