/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.avc.integration;

import com.bokesoft.erp.billentity.BusinessTransaction;
import com.bokesoft.erp.billentity.EAM_TransactionType;
import com.bokesoft.erp.billentity.EFI_IntegrationRelation;
import com.bokesoft.erp.billentity.EFI_VoucherDtl_Entry;
import com.bokesoft.erp.billentity.EFI_VoucherHead;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_FMAreaToCompanyCode;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Fund;
import com.bokesoft.erp.billentity.EFM_FundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_FundVoucherHead;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_PostLedgerPeriod;
import com.bokesoft.erp.billentity.EFM_UpdateProfileDtl;
import com.bokesoft.erp.billentity.EFM_UpdateProfileHead;
import com.bokesoft.erp.billentity.EGS_MaterialValuationArea;
import com.bokesoft.erp.billentity.EMM_PO_AccountAssignDtl;
import com.bokesoft.erp.billentity.ESD_SaleOrderDtl;
import com.bokesoft.erp.billentity.FI_Voucher;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_EarmarkedFundVoucher;
import com.bokesoft.erp.billentity.FM_FundVoucher;
import com.bokesoft.erp.billentity.IntegrationRelation;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.earmarkfund.EFCommitVoucherFormula;
import com.bokesoft.erp.fm.enums.AmountTypeEnum;
import com.bokesoft.erp.fm.enums.ReferDocTypeEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.erp.fm.masterdata.AccountAssignmentFormula;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yes.util.ERPStringUtil;
import java.math.BigDecimal;
import java.util.List;

public class FundVoucherFormula
extends EntityContextAction {
    boolean functionAreaActive;
    EFM_FinancialManagementArea finManagementArea;
    AddressUtils addressUtils = new AddressUtils(this.getMidContext());
    Long versionID = 0L;
    Long fmAreaID;
    int isPeriodOrYear;
    int grirUpdate;
    Long postingDate;
    int fiscalYear;
    int fiscalPeriod;
    EFM_UpdateProfileDtl updateProfileDtl;
    String businessTransaction = "";
    private int updateProfileTimes = 0;

    public FundVoucherFormula(RichDocumentContext _context) {
        super(_context);
    }

    public FundVoucherFormula(RichDocumentContext _context, EFM_FinancialManagementArea finManagementArea, Long versionID, int isPeriodOrYear, Long postingDate, int fiscalYear, int fiscalPeriod, EFM_UpdateProfileDtl updateProfileDtl) throws Throwable {
        super(_context);
        this.versionID = versionID;
        this.fmAreaID = finManagementArea.getOID();
        this.isPeriodOrYear = isPeriodOrYear;
        this.grirUpdate = finManagementArea.getGRIRUpdate();
        this.postingDate = postingDate;
        this.fiscalYear = fiscalYear;
        this.fiscalPeriod = fiscalPeriod;
        this.updateProfileDtl = updateProfileDtl;
        this.finManagementArea = finManagementArea;
        this.functionAreaActive = new AccountAssignmentFormula(_context).isFunctionAreaActive();
    }

    public void genFundVoucher(FI_Voucher fiVoucher) throws Throwable {
        this.businessTransaction = fiVoucher.getBusinessTransaction().getCode();
        FM_FundVoucher fundVoucher = this.genFundVoucher(this.getFundVoucher(fiVoucher), fiVoucher.efi_voucherDtl_Entrys());
        if (fundVoucher.efm_fundVoucherDtls() != null && !fundVoucher.efm_fundVoucherDtls().isEmpty()) {
            this.save((AbstractBillEntity)fundVoucher);
            this.saveIntegrationRelation(fiVoucher, fundVoucher);
        }
    }

    public void feedBack(FI_Voucher fiVoucher) throws Throwable {
        int bcsActiveYear;
        Long companyCodeID = fiVoucher.getCompanyCodeID();
        EFM_FMAreaToCompanyCode areaToCompanyCode = EFM_FMAreaToCompanyCode.loader((RichDocumentContext)this.getMidContext()).CompanyCodeID(companyCodeID).load();
        if (areaToCompanyCode == null || areaToCompanyCode.getFinancialManagementAreaID().compareTo(0L) <= 0) {
            return;
        }
        if (areaToCompanyCode.getIsUpdate() == 0) {
            return;
        }
        Long fmAreaID = areaToCompanyCode.getFinancialManagementAreaID();
        EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.load((RichDocumentContext)this.getMidContext(), (Long)fmAreaID);
        Long updateProfileID = finManagementArea.getUpdateProfileID();
        if (updateProfileID.compareTo(0L) <= 0) {
            MessageFacade.throwException((String)"FI2FUNDVOUCHER001", (Object[])new Object[]{finManagementArea.getCode()});
        }
        if ((bcsActiveYear = finManagementArea.getBCSActiveYear()) <= 0) {
            MessageFacade.throwException((String)"FI2FUNDVOUCHER002");
        }
        if (bcsActiveYear > fiVoucher.getFiscalYear()) {
            return;
        }
        EFM_UpdateProfileHead updateProfile = EFM_UpdateProfileHead.load((RichDocumentContext)this.getMidContext(), (Long)updateProfileID);
        int isPeriodOrYear = updateProfile.getIsPeriodOrYear();
        List voucherDtlEntries = fiVoucher.efi_voucherDtl_Entrys();
        for (EFI_VoucherDtl_Entry voucherDtlEntry : voucherDtlEntries) {
            Long earmarkedFundVoucherID = voucherDtlEntry.getEarmarkedFundVoucherSOID();
            Long earmarkedFundVoucherDtlID = voucherDtlEntry.getEarmarkedFundVoucherDtlOID();
            if (earmarkedFundVoucherID.compareTo(0L) <= 0 || earmarkedFundVoucherDtlID.compareTo(0L) <= 0) continue;
            EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl = EFM_EarmarkedFundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherDtlID).load();
            if (earmarkedFundVoucherDtl.getIsProjectFreezed() == 1) {
                MessageFacade.throwException((String)"FUNDVOUCHERFORMULA001", (Object[])new Object[]{earmarkedFundVoucherDtl.getDetailNumber()});
            }
            if (earmarkedFundVoucherDtl.getIsProjectCompleted() == 1) {
                MessageFacade.throwException((String)"FUNDVOUCHERFORMULA002", (Object[])new Object[]{earmarkedFundVoucherDtl.getDetailNumber()});
            }
            FM_EarmarkedFundVoucher earmarkedFundVoucher = FM_EarmarkedFundVoucher.loader((RichDocumentContext)this.getMidContext()).OID(earmarkedFundVoucherID).load();
            int voucherCategory = earmarkedFundVoucher.getVoucherCategory();
            String valueType = new EFCommitVoucherFormula(this.getMidContext()).getValueType(voucherCategory);
            FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(earmarkedFundVoucherID).ReferItemOID(earmarkedFundVoucherDtl.getOID()).load();
            String currPostAddress = this.addressUtils.genAddress(voucherDtlEntry.getFundID(), voucherDtlEntry.getFundCenterID(), voucherDtlEntry.getCommitmentItemID(), voucherDtlEntry.getFunctionalAreaID(), 0L);
            int isPosting = fiVoucher.getStatus() == 3 ? 1 : -1;
            EFM_UpdateProfileDtl updateProfileDtl = EFM_UpdateProfileDtl.loader((RichDocumentContext)this.getMidContext()).SOID(updateProfileID).ValueType(valueType).load();
            if (updateProfileDtl == null) {
                MessageFacade.throwException((String)"FUNDVOUCHERFORMULA004", (Object[])new Object[]{areaToCompanyCode.getFinancialManagementAreaCode(), valueType});
            }
            if (updateProfileDtl.getIsBudgetAllocation() == 0) continue;
            int fiscalYear = fiVoucher.getFiscalYear();
            int fiscalPeriod = fiVoucher.getFiscalPeriod();
            if (updateProfileDtl.getIsPBActive() > 0 && updateProfileDtl.getIsPBReduce() > 0) {
                this.feedBackByPostLedger("9A", isPosting * voucherDtlEntry.getDirection(), currPostAddress, voucherDtlEntry, fmAreaID, fmCommitVoucher, earmarkedFundVoucher, earmarkedFundVoucherDtl, valueType, fiscalYear, fiscalPeriod, isPeriodOrYear);
            }
            if (updateProfileDtl.getIsCBActive() > 0 && updateProfileDtl.getIsCBActive() > 0) {
                this.feedBackByPostLedger("9B", isPosting * voucherDtlEntry.getDirection(), currPostAddress, voucherDtlEntry, fmAreaID, fmCommitVoucher, earmarkedFundVoucher, earmarkedFundVoucherDtl, valueType, fiscalYear, fiscalPeriod, isPeriodOrYear);
            }
            this.save((AbstractBillEntity)fmCommitVoucher);
            this.save((AbstractTableEntity)earmarkedFundVoucherDtl, "FM_EarmarkedFundVoucher");
        }
    }

    private void feedBackByPostLedger(String postLedgerCode, int direction, String postAddress, EFI_VoucherDtl_Entry dtlEntry, Long fmAreaID, FM_CommitVoucher fmCommitVoucher, FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl, String valueType, int fiscalYear, int fiscalPeriod, int isPeriodOrYear) throws Throwable {
        int isNagetive;
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code(postLedgerCode).load();
        Long fmLedgerID = payLedger.getOID();
        EFM_PostLedgerPeriod postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).ValueType(valueType).FiscalYear(fiscalYear).FromFiscalPeriod("<=", fiscalPeriod).ToFiscalPeriod(">=", fiscalPeriod).LedgerID(fmLedgerID).load();
        if (postLedgerPeriod == null) {
            postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(fmAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(fiscalYear).FromFiscalPeriod("<=", fiscalPeriod).ToFiscalPeriod(">=", fiscalPeriod).LedgerID(fmLedgerID).load();
        }
        if (postLedgerPeriod == null) {
            MessageFacade.throwException((String)"FUNDVOUCHERFORMULA005", (Object[])new Object[]{postLedgerCode});
        }
        BigDecimal amount = dtlEntry.getMoney().multiply(BigDecimal.valueOf(direction));
        BigDecimal totalAmount = earmarkedFundVoucherDtl.getTotalMoney();
        BigDecimal reducedAmount = earmarkedFundVoucherDtl.getReducedMoney();
        BigDecimal allReduceAmount = reducedAmount.add(amount);
        if (this.updateProfileTimes > 0) {
            allReduceAmount = reducedAmount;
        }
        BigDecimal subtractAmount = (isNagetive = earmarkedFundVoucher.efm_earmarkedFundVoucherHead().getIsNagetiveValiueAllowed()) == 0 ? totalAmount.subtract(allReduceAmount) : totalAmount.subtract(allReduceAmount).negate();
        earmarkedFundVoucherDtl.setReducedMoney(allReduceAmount);
        earmarkedFundVoucherDtl.setUnclearMoney(subtractAmount);
        List commitVouchers = fmCommitVoucher.efm_commitVoucherDtls("IsLatest", (Object)1);
        for (EFM_CommitVoucherDtl commitVoucher : commitVouchers) {
            if (!commitVoucher.getLedgerID().equals(fmLedgerID)) continue;
            EFCommitVoucherFormula efCommitVoucherFormula = new EFCommitVoucherFormula(this.getMidContext());
            if (isPeriodOrYear == Integer.parseInt("1")) {
                List efm_commitVouchers0500;
                List efm_commitVouchers0200 = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
                if (efm_commitVouchers0200 != null && !efm_commitVouchers0200.isEmpty()) {
                    for (EFM_CommitVoucherDtl deleteVoucher : efm_commitVouchers0200) {
                        fmCommitVoucher.deleteEFM_CommitVoucherDtl(deleteVoucher);
                    }
                }
                if ((efm_commitVouchers0500 = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0500.getKey())) != null && !efm_commitVouchers0500.isEmpty()) {
                    for (EFM_CommitVoucherDtl deleteVoucher : efm_commitVouchers0500) {
                        fmCommitVoucher.deleteEFM_CommitVoucherDtl(deleteVoucher);
                    }
                }
                efCommitVoucherFormula.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, earmarkedFundVoucherDtl, allReduceAmount.negate(), isPeriodOrYear);
                if (subtractAmount.compareTo(BigDecimal.ZERO) < 0) {
                    efCommitVoucherFormula.judgeTolerance(earmarkedFundVoucher, earmarkedFundVoucherDtl, earmarkedFundVoucherDtl, subtractAmount, totalAmount);
                    efCommitVoucherFormula.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, earmarkedFundVoucherDtl, subtractAmount.negate(), isPeriodOrYear);
                    earmarkedFundVoucherDtl.setUnclearMoney(BigDecimal.ZERO);
                }
            } else {
                List efm_commitVouchers0500 = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0500.getKey());
                BigDecimal hasAmount0500 = BigDecimal.ZERO;
                if (efm_commitVouchers0500 != null && !efm_commitVouchers0500.isEmpty()) {
                    for (EFM_CommitVoucherDtl efm_commitVoucher : efm_commitVouchers0500) {
                        if (!efm_commitVoucher.getPostAddress().equals(postAddress)) continue;
                        hasAmount0500 = hasAmount0500.add(efm_commitVoucher.getFMAreaCurrencyMoney());
                    }
                }
                efCommitVoucherFormula.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, earmarkedFundVoucherDtl, amount.negate(), isPeriodOrYear);
                if (subtractAmount.compareTo(BigDecimal.ZERO) < 0) {
                    efCommitVoucherFormula.judgeTolerance(earmarkedFundVoucher, earmarkedFundVoucherDtl, earmarkedFundVoucherDtl, subtractAmount, totalAmount);
                    efCommitVoucherFormula.genEFCommitVoucherFromVoucher(AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, earmarkedFundVoucherDtl, subtractAmount.negate().subtract(hasAmount0500), isPeriodOrYear);
                    earmarkedFundVoucherDtl.setUnclearMoney(BigDecimal.ZERO);
                }
            }
            ++this.updateProfileTimes;
        }
    }

    public FM_FundVoucher genFundVoucher(FM_FundVoucher fm_fundVoucher, List<EFI_VoucherDtl_Entry> efi_voucherDtl_entries) throws Throwable {
        for (EFI_VoucherDtl_Entry dtlEntry : efi_voucherDtl_entries) {
            EAM_TransactionType transactionType;
            boolean isStatisticsUpdate = this.updateProfileDtl.getIsStatisticsUpdate() > 0;
            Long fundID = dtlEntry.getFundID();
            Long fundCenterID = dtlEntry.getFundCenterID();
            Long commitItemID = dtlEntry.getCommitmentItemID();
            Long functionScopeID = dtlEntry.getFunctionalAreaID();
            Long transactionTypeID = dtlEntry.getTransactionTypeID();
            if (fundCenterID.compareTo(0L) == 0 || commitItemID.compareTo(0L) == 0) continue;
            if (!this.functionAreaActive) {
                functionScopeID = 0L;
            }
            String postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionScopeID, 0L);
            EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID);
            if (commitmentItem.getIsStatisticalCommit() > 0) {
                isStatisticsUpdate = true;
            }
            if (transactionTypeID > 0L && (transactionType = EAM_TransactionType.loader((RichDocumentContext)this.getMidContext()).SOID(transactionTypeID).load()).getIsRelatedBudget() != 1) {
                isStatisticsUpdate = true;
            }
            if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
                this.genVoucherByPostLedger("9A", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
            }
            if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0) continue;
            this.genVoucherByPostLedger("9B", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
        }
        return fm_fundVoucher;
    }

    public void genFundVoucherDtlFromDtl(String amountType, FM_FundVoucher msegFundVoucher, EFM_FundVoucherDtl msegVoucherDtl0100, BigDecimal amount) throws Throwable {
        EFM_FundVoucherDtl efm_fundVoucherDtl = msegFundVoucher.newEFM_FundVoucherDtl();
        efm_fundVoucherDtl.setFinancialManagementAreaID(msegVoucherDtl0100.getFinancialManagementAreaID());
        efm_fundVoucherDtl.setMoneyType(amountType);
        efm_fundVoucherDtl.setLedgerID(msegVoucherDtl0100.getLedgerID());
        efm_fundVoucherDtl.setFiscalYear(msegVoucherDtl0100.getFiscalYear());
        efm_fundVoucherDtl.setPostingDate(msegVoucherDtl0100.getPostingDate());
        efm_fundVoucherDtl.setFiscalPeriod(msegVoucherDtl0100.getFiscalPeriod());
        efm_fundVoucherDtl.setTransactionCurrencyMoney(amount);
        efm_fundVoucherDtl.setFMAreaCurrencyMoney(amount);
        efm_fundVoucherDtl.setCommitmentItemID(msegVoucherDtl0100.getCommitmentItemID());
        efm_fundVoucherDtl.setFundCenterID(msegVoucherDtl0100.getFundCenterID());
        efm_fundVoucherDtl.setFundID(msegVoucherDtl0100.getFundID());
        efm_fundVoucherDtl.setFunctionalAreaID(msegVoucherDtl0100.getFunctionalAreaID());
        efm_fundVoucherDtl.setBusinessAreaID(msegVoucherDtl0100.getBusinessAreaID());
        efm_fundVoucherDtl.setProfitCenterID(msegVoucherDtl0100.getProfitCenterID());
        efm_fundVoucherDtl.setValueType(ValueTypeEnum.ValueType_54.getKey());
        efm_fundVoucherDtl.setBusinessTransactionID(msegVoucherDtl0100.getBusinessTransactionID());
        efm_fundVoucherDtl.setCurrencyID(msegVoucherDtl0100.getCurrencyID());
        efm_fundVoucherDtl.setGLAccountID(msegVoucherDtl0100.getGLAccountID());
        efm_fundVoucherDtl.setReferDocSOID(msegVoucherDtl0100.getReferDocSOID());
        efm_fundVoucherDtl.setReferDocDtlOID(msegVoucherDtl0100.getReferDocDtlOID());
        efm_fundVoucherDtl.setReferFIDocSOID(msegVoucherDtl0100.getReferFIDocOID());
        efm_fundVoucherDtl.setReferFIDocDtlOID(msegVoucherDtl0100.getReferFIDocDtlOID());
        efm_fundVoucherDtl.setPostAddress(msegVoucherDtl0100.getPostAddress());
        efm_fundVoucherDtl.setIsUpdate(0);
        efm_fundVoucherDtl.setVersionID(msegVoucherDtl0100.getVersionID());
        efm_fundVoucherDtl.setQuantity(msegVoucherDtl0100.getQuantity());
        efm_fundVoucherDtl.setUnitID(msegVoucherDtl0100.getUnitID());
        efm_fundVoucherDtl.setStatisticalIdentifier(msegVoucherDtl0100.getStatisticalIdentifier());
        efm_fundVoucherDtl.setPreDocType(msegVoucherDtl0100.getPreDocType());
        efm_fundVoucherDtl.setPreDocSOID(msegVoucherDtl0100.getPreDocSOID());
        efm_fundVoucherDtl.setPreItemSOID(msegVoucherDtl0100.getPreItemOID());
        efm_fundVoucherDtl.setPreAccountAssignItemOID(msegVoucherDtl0100.getPreAccountAssignItemOID());
        efm_fundVoucherDtl.setPreReferTrade(msegVoucherDtl0100.getPreReferTrade());
    }

    FM_FundVoucher getFundVoucher(FI_Voucher fiVoucher) throws Throwable {
        FM_FundVoucher fm_fundVoucher = FM_FundVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(fiVoucher.getSrcSOID()).ReferFIDocSOID(fiVoucher.getOID()).load();
        if (fm_fundVoucher == null) {
            fm_fundVoucher = (FM_FundVoucher)this.newBillEntity(FM_FundVoucher.class);
        }
        EFM_FundVoucherHead efm_fundVoucherHead = fm_fundVoucher.efm_fundVoucherHead();
        efm_fundVoucherHead.setDocumentDate(ERPDateUtil.getNowDateLong());
        efm_fundVoucherHead.setPostingDate(this.postingDate);
        efm_fundVoucherHead.setFinancialManagementAreaID(this.fmAreaID);
        efm_fundVoucherHead.setCompanyCodeID(fiVoucher.getCompanyCodeID());
        efm_fundVoucherHead.setVoucherTypeID(fiVoucher.getVoucherTypeID());
        efm_fundVoucherHead.setBusinessTransactionID(fiVoucher.getBusinessTransactionID());
        efm_fundVoucherHead.setReferTransaction(fiVoucher.getReferTransaction());
        efm_fundVoucherHead.setReferDocOID(fiVoucher.getSrcSOID());
        if (fiVoucher.getSrcSOID() == 0L) {
            efm_fundVoucherHead.setReferTransaction("BKPF");
            efm_fundVoucherHead.setReferDocOID(fiVoucher.getOID());
        }
        efm_fundVoucherHead.setReferFIDocOID(fiVoucher.getOID());
        efm_fundVoucherHead.setReferFIDocNumber(fiVoucher.getDocumentNumber());
        efm_fundVoucherHead.setReferCompanyCode(fiVoucher.getCompanyCodeID());
        efm_fundVoucherHead.setReferFiscalYear(fiVoucher.getFiscalYear());
        efm_fundVoucherHead.setVersionID(this.versionID);
        efm_fundVoucherHead.setReferFormKey(fiVoucher.getSrcFormKey());
        efm_fundVoucherHead.setDocHeadText(fiVoucher.getNotes());
        return fm_fundVoucher;
    }

    public EFM_FundVoucherDtl genVoucherByPostLedger(String postLedgerCode, Long fundID, String postAddress, EFI_VoucherDtl_Entry dtlEntry, FM_FundVoucher fm_fundVoucher, boolean isStatisticsUpdate) throws Throwable {
        EFM_AddressIndex addressIndex;
        EFM_BSDistribution bsDistribution;
        String budgetLedgerCode = "";
        if (postLedgerCode.equals("9A")) {
            budgetLedgerCode = "9F";
        } else if (postLedgerCode.equals("9B")) {
            budgetLedgerCode = "9G";
        } else {
            MessageFacade.throwException((String)"FUNDVOUCHERFORMULA006", (Object[])new Object[]{postLedgerCode});
        }
        EFM_FundVoucherDtl fundVoucherDtl = null;
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code(postLedgerCode).load();
        Long fmLedgerID = payLedger.getOID();
        EFM_PostLedgerPeriod postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).ValueType(ValueTypeEnum.ValueType_54.getKey()).FiscalYear(this.fiscalYear).FromFiscalPeriod("<=", this.fiscalPeriod).ToFiscalPeriod(">=", this.fiscalPeriod).LedgerID(fmLedgerID).load();
        if (postLedgerPeriod == null) {
            postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(this.fiscalYear).FromFiscalPeriod("<=", this.fiscalPeriod).ToFiscalPeriod(">=", this.fiscalPeriod).LedgerID(fmLedgerID).load();
        }
        if (postLedgerPeriod == null) {
            MessageFacade.throwException((String)"FUNDVOUCHERFORMULA005", (Object[])new Object[]{postLedgerCode});
        }
        if (fundID.compareTo(0L) > 0) {
            EFM_Fund fundDict = EFM_Fund.load((RichDocumentContext)this.getMidContext(), (Long)fundID);
            Long termValidityFromDate = fundDict.getValidStartDate();
            Long termValidityToDate = fundDict.getValidEndDate();
            if (ERPDateUtil.isBefore((Object)(this.postingDate + 1L), (Object)termValidityFromDate) || ERPDateUtil.isBefore((Object)termValidityToDate, (Object)this.postingDate)) {
                MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE004", (Object[])new Object[]{fundDict.getCode()});
            }
        }
        if ((bsDistribution = EFM_BSDistribution.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FiscalYear(this.fiscalYear).load()) != null && bsDistribution.getIsCheckPost() > 0 && (addressIndex = EFM_AddressIndex.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FromFiscalYear(this.fiscalYear).FromLedgerID(fmLedgerID).FromObjectNumber(postAddress).ToLedgerCode(budgetLedgerCode).load()) == null) {
            MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE005", (Object[])new Object[]{this.fiscalYear, postLedgerCode, dtlEntry.getFundCode(), dtlEntry.getFundCenterCode(), dtlEntry.getCommitmentItemCode(), dtlEntry.getFunctionalAreaCode()});
        }
        fundVoucherDtl = this.genFundVoucherDtl(fm_fundVoucher, this.fmAreaID, this.postingDate, this.fiscalYear, this.fiscalPeriod, dtlEntry, isStatisticsUpdate, postAddress, fmLedgerID);
        return fundVoucherDtl;
    }

    private EFM_FundVoucherDtl genFundVoucherDtl(FM_FundVoucher fm_fundVoucher, Long fmAreaID, Long postingDate, int fiscalYear, int fiscalPeriod, EFI_VoucherDtl_Entry dtlEntry, boolean isStatisticsUpdate, String postAddress, Long fmLedgerID) throws Throwable {
        EFM_FundVoucherDtl efm_fundVoucherDtl = fm_fundVoucher.newEFM_FundVoucherDtl();
        int direction = dtlEntry.getDirection();
        if (dtlEntry.getPurchaseOrderDtlOID().compareTo(0L) > 0) {
            efm_fundVoucherDtl.setReferTransaction("PORD");
            efm_fundVoucherDtl.setReferDocNo(dtlEntry.getPurchaseOrderDocNo());
            efm_fundVoucherDtl.setPreDocType(ReferDocTypeEnum.PurchaseOrder.getKey());
            efm_fundVoucherDtl.setPreDocSOID(dtlEntry.getPurchaseOrderSOID());
            efm_fundVoucherDtl.setPreItemSOID(dtlEntry.getPurchaseOrderDtlOID());
            if (dtlEntry.getPurchaseOrderAccountDtlOID().compareTo(0L) > 0) {
                efm_fundVoucherDtl.setPreAccountAssignItemOID(dtlEntry.getPurchaseOrderAccountDtlOID());
            } else {
                List emm_po_accountAssignDtls = EMM_PO_AccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).POID(dtlEntry.getPurchaseOrderDtlOID()).loadList();
                if (emm_po_accountAssignDtls.size() > 1) {
                    MessageFacade.throwException((String)"FUNDVOUCHER4STOCKINVOICE002");
                }
                efm_fundVoucherDtl.setPreAccountAssignItemOID(((EMM_PO_AccountAssignDtl)emm_po_accountAssignDtls.get(0)).getOID());
            }
            efm_fundVoucherDtl.setPreReferTrade("PORD");
        } else if (dtlEntry.getSaleOrderDtlOID().compareTo(0L) > 0) {
            efm_fundVoucherDtl.setReferTransaction("VBRK");
            efm_fundVoucherDtl.setReferDocNo(dtlEntry.getSaleOrderDocNo());
            efm_fundVoucherDtl.setPreDocType(ReferDocTypeEnum.SaleOrder.getKey());
            efm_fundVoucherDtl.setPreDocSOID(dtlEntry.getSaleOrderSOID());
            efm_fundVoucherDtl.setPreItemSOID(dtlEntry.getSaleOrderDtlOID());
            efm_fundVoucherDtl.setPreAccountAssignItemOID(dtlEntry.getSaleOrderDtlOID());
            efm_fundVoucherDtl.setPreReferTrade("VBRK");
        } else if (dtlEntry.getEarmarkedFundVoucherDtlOID() > 0L) {
            efm_fundVoucherDtl.setReferTransaction("FMRES");
            efm_fundVoucherDtl.setReferDocNo(dtlEntry.getEarmarkedFundVoucherDocNo());
            efm_fundVoucherDtl.setPreDocType(ReferDocTypeEnum.EarmarkedFund.getKey());
            efm_fundVoucherDtl.setPreDocSOID(dtlEntry.getEarmarkedFundVoucherSOID());
            efm_fundVoucherDtl.setPreItemSOID(dtlEntry.getEarmarkedFundVoucherDtlOID());
            efm_fundVoucherDtl.setPreReferTrade("FMRES");
        }
        Long functionalAreaID = dtlEntry.getFunctionalAreaID();
        if (!this.functionAreaActive) {
            functionalAreaID = 0L;
        }
        efm_fundVoucherDtl.setFinancialManagementAreaID(fmAreaID);
        efm_fundVoucherDtl.setMoneyType(AmountTypeEnum.AmountType_0100.getKey());
        efm_fundVoucherDtl.setLedgerID(fmLedgerID);
        efm_fundVoucherDtl.setFiscalYear(fiscalYear);
        efm_fundVoucherDtl.setPostingDate(postingDate);
        efm_fundVoucherDtl.setFiscalPeriod(fiscalPeriod);
        efm_fundVoucherDtl.setTransactionCurrencyMoney(dtlEntry.getMoney().multiply(new BigDecimal(direction)));
        efm_fundVoucherDtl.setFMAreaCurrencyMoney(dtlEntry.getMoney().multiply(new BigDecimal(direction)));
        efm_fundVoucherDtl.setCommitmentItemID(dtlEntry.getCommitmentItemID());
        efm_fundVoucherDtl.setFundCenterID(dtlEntry.getFundCenterID());
        efm_fundVoucherDtl.setFundID(dtlEntry.getFundID());
        efm_fundVoucherDtl.setFunctionalAreaID(functionalAreaID);
        efm_fundVoucherDtl.setBusinessAreaID(dtlEntry.getBusinessAreaID());
        efm_fundVoucherDtl.setProfitCenterID(dtlEntry.getProfitCenterID());
        EFI_VoucherHead efiVoucherHead = EFI_VoucherHead.load((RichDocumentContext)this.getMidContext(), (Long)dtlEntry.getSOID());
        if ("WA".equals(efiVoucherHead.getVoucherTypeCode()) || "WE".equals(efiVoucherHead.getVoucherTypeCode()) && dtlEntry.getSaleOrderDtlOID().compareTo(0L) > 0) {
            efm_fundVoucherDtl.setValueType(ValueTypeEnum.ValueType_66.getKey());
        } else {
            efm_fundVoucherDtl.setValueType(ValueTypeEnum.ValueType_54.getKey());
        }
        if (ERPStringUtil.isBlankOrNull((Object)this.businessTransaction)) {
            this.businessTransaction = "RFBU";
        }
        BusinessTransaction progress = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code(this.businessTransaction).load();
        efm_fundVoucherDtl.setBusinessTransactionID(progress.getOID());
        efm_fundVoucherDtl.setCurrencyID(dtlEntry.getCurrencyID());
        efm_fundVoucherDtl.setGLAccountID(dtlEntry.getAccountID());
        efm_fundVoucherDtl.setReferDocSOID(dtlEntry.getSrcSOID());
        efm_fundVoucherDtl.setReferDocDtlOID(dtlEntry.getSrcOID());
        efm_fundVoucherDtl.setReferFIDocSOID(dtlEntry.getSOID());
        efm_fundVoucherDtl.setReferFIDocDtlOID(dtlEntry.getOID());
        efm_fundVoucherDtl.setSrcOID(dtlEntry.getOID());
        efm_fundVoucherDtl.setSrcSOID(dtlEntry.getSOID());
        efm_fundVoucherDtl.setSrcFormKey("FI_Voucher");
        efm_fundVoucherDtl.setPostAddress(postAddress);
        efm_fundVoucherDtl.setIsUpdate(0);
        efm_fundVoucherDtl.setVersionID(this.versionID);
        efm_fundVoucherDtl.setQuantity(dtlEntry.getBaseQuantity());
        efm_fundVoucherDtl.setUnitID(dtlEntry.getBaseUnitID());
        efm_fundVoucherDtl.setStatisticalIdentifier("Empty");
        if (dtlEntry.getTransactionKeyCode().equals("PRD")) {
            efm_fundVoucherDtl.setQuantity(BigDecimal.ZERO);
            efm_fundVoucherDtl.setFMTransaction("PD01");
        }
        if (isStatisticsUpdate) {
            efm_fundVoucherDtl.setStatisticalIdentifier("X");
        }
        return efm_fundVoucherDtl;
    }

    public EFM_CommitVoucherDtl getCommitVoucher(Long fmLedgerID, EMM_PO_AccountAssignDtl accountAssignDtl) throws Throwable {
        String postAddress = this.addressUtils.genAddress(accountAssignDtl.getFundID(), accountAssignDtl.getFundCenterID(), accountAssignDtl.getCommitmentItemID(), accountAssignDtl.getFunctionalAreaID(), 0L);
        EFM_CommitVoucherDtl commitVoucher = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(accountAssignDtl.getSOID()).ReferItemOID(accountAssignDtl.getPOID()).ReferAccountAssignItemOID(accountAssignDtl.getOID()).PostAddress(postAddress).IsLatest(1).load();
        if (commitVoucher == null) {
            MessageFacade.throwException((String)"FUNDVOUCHERFORMULA003");
        }
        return commitVoucher;
    }

    public EFM_CommitVoucherDtl getCommitVoucher(Long fmLedgerID, ESD_SaleOrderDtl saleOrderDtl) throws Throwable {
        String postAddress = this.addressUtils.genAddress(saleOrderDtl.getFundID(), saleOrderDtl.getFundCenterID(), saleOrderDtl.getCommitmentItemID(), saleOrderDtl.getFunctionalAreaID(), 0L);
        EFM_CommitVoucherDtl commitVoucher = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(saleOrderDtl.getSOID()).ReferItemOID(saleOrderDtl.getOID()).PostAddress(postAddress).IsLatest(1).load();
        if (commitVoucher == null) {
            MessageFacade.throwException((String)"FUNDVOUCHERFORMULA003");
        }
        return commitVoucher;
    }

    public BigDecimal getSendAmount(Long docOID, Long itemOID, Long accountDtlOID, Long fmLedgerID, String postAddress) throws Throwable {
        BigDecimal sendAmount = BigDecimal.ZERO;
        List efm_commitVoucherDtls = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(docOID).ReferItemOID(itemOID).ReferAccountAssignItemOID(accountDtlOID).PostAddress(postAddress).loadList();
        if ("".equals(postAddress)) {
            efm_commitVoucherDtls = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(docOID).ReferItemOID(itemOID).ReferAccountAssignItemOID(accountDtlOID).loadList();
        }
        if (efm_commitVoucherDtls != null) {
            for (EFM_CommitVoucherDtl efm_commitVoucher : efm_commitVoucherDtls) {
                sendAmount = sendAmount.add(efm_commitVoucher.getFMAreaCurrencyMoney());
            }
        }
        return sendAmount;
    }

    public BigDecimal getSendAmount4FundVoucher(Long docOID, Long docDtlOID, Long fiDocID, Long fiDocDtlID, Long fmLedgerID, String postAddress) throws Throwable {
        BigDecimal sendAmount = BigDecimal.ZERO;
        List efm_fundVoucherDtlList = EFM_FundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(docOID).ReferDocDtlOID(docDtlOID).ReferFIDocSOID(fiDocID).ReferFIDocDtlOID(fiDocDtlID).PostAddress(postAddress).loadList();
        if (postAddress.equals("")) {
            efm_fundVoucherDtlList = EFM_FundVoucherDtl.loader((RichDocumentContext)this.getMidContext()).LedgerID(fmLedgerID).ReferDocSOID(docOID).ReferDocDtlOID(docDtlOID).ReferFIDocOID(fiDocID).ReferFIDocDtlOID(fiDocDtlID).loadList();
        }
        if (efm_fundVoucherDtlList != null) {
            for (EFM_FundVoucherDtl fundVoucherDtl : efm_fundVoucherDtlList) {
                sendAmount = sendAmount.add(fundVoucherDtl.getFMAreaCurrencyMoney());
            }
        }
        return sendAmount;
    }

    public EFM_CommitVoucherDtl genCommitVoucherFromVoucher(FM_CommitVoucher fm_commitVoucher, String amountType, EFM_CommitVoucherDtl fromCommitVoucher, BigDecimal amount) throws Throwable {
        EFM_CommitVoucherDtl commitVoucher = fm_commitVoucher.newEFM_CommitVoucherDtl();
        commitVoucher.setReferDocType(fromCommitVoucher.getReferDocType());
        commitVoucher.setReferDocSOID(fromCommitVoucher.getReferDocSOID());
        commitVoucher.setReferDocNo(fromCommitVoucher.getReferDocNo());
        commitVoucher.setReferItemOID(fromCommitVoucher.getReferItemOID());
        commitVoucher.setReferAccountAssignItemOID(fromCommitVoucher.getReferAccountAssignItemOID());
        commitVoucher.setReferTrade(fromCommitVoucher.getReferTrade());
        commitVoucher.setMoneyType(amountType);
        commitVoucher.setSrcSOID(fromCommitVoucher.getSrcSOID());
        commitVoucher.setSrcOID(fromCommitVoucher.getSrcOID());
        commitVoucher.setSrcFormKey(fromCommitVoucher.getSrcFormKey());
        commitVoucher.setPostingDate(fromCommitVoucher.getPostingDate());
        commitVoucher.setFiscalYear(fromCommitVoucher.getFiscalYear());
        commitVoucher.setFiscalPeriod(fromCommitVoucher.getFiscalPeriod());
        commitVoucher.setVersionID(fromCommitVoucher.getVersionID());
        commitVoucher.setLedgerID(fromCommitVoucher.getLedgerID());
        commitVoucher.setCommitVoucherCarryoverStatus(fromCommitVoucher.getCommitVoucherCarryoverStatus());
        commitVoucher.setTransactionCurrencyMoney(amount);
        commitVoucher.setFMAreaCurrencyMoney(amount);
        commitVoucher.setCommitmentItemID(fromCommitVoucher.getCommitmentItemID());
        commitVoucher.setFundCenterID(fromCommitVoucher.getFundCenterID());
        commitVoucher.setFundID(fromCommitVoucher.getFundID());
        commitVoucher.setFunctionalAreaID(fromCommitVoucher.getFunctionalAreaID());
        commitVoucher.setPostAddress(fromCommitVoucher.getPostAddress());
        if (!fromCommitVoucher.getReferDocType().equals(ReferDocTypeEnum.SaleOrder.getKey())) {
            commitVoucher.setValueType(ValueTypeEnum.ValueType_51.getKey());
            if (fromCommitVoucher.getPreDocSOID().compareTo(0L) > 0) {
                commitVoucher.setPreDocType(ReferDocTypeEnum.PurchaseApplication.getKey());
                commitVoucher.setPreReferTrade("PREQ");
                commitVoucher.setPreDocSOID(fromCommitVoucher.getPreDocSOID());
                commitVoucher.setPreItemOID(fromCommitVoucher.getPreItemOID());
                commitVoucher.setPreAccountAssignItemOID(fromCommitVoucher.getPreAccountAssignItemOID());
            }
        } else {
            commitVoucher.setValueType(ValueTypeEnum.ValueType_83.getKey());
        }
        commitVoucher.setBusinessTransactionID(fromCommitVoucher.getBusinessTransactionID());
        commitVoucher.setCompanyCodeID(fromCommitVoucher.getCompanyCodeID());
        commitVoucher.setCurrencyID(fromCommitVoucher.getCurrencyID());
        commitVoucher.setMaterialID(fromCommitVoucher.getMaterialID());
        commitVoucher.setShortText(fromCommitVoucher.getShortText());
        commitVoucher.setGLAccountID(fromCommitVoucher.getGLAccountID());
        commitVoucher.setFinancialManagementAreaID(fromCommitVoucher.getFinancialManagementAreaID());
        commitVoucher.setVendorID(fromCommitVoucher.getVendorID());
        commitVoucher.setQuantity(fromCommitVoucher.getQuantity());
        commitVoucher.setStatisticalIdentifier("Empty");
        commitVoucher.setFinishFlag("X");
        if (!fromCommitVoucher.getStatisticalIdentifier().equals("Empty")) {
            commitVoucher.setStatisticalIdentifier(fromCommitVoucher.getStatisticalIdentifier());
        }
        return commitVoucher;
    }

    private void saveIntegrationRelation(FI_Voucher fiVoucher, FM_FundVoucher fundVoucher) throws Throwable {
        IntegrationRelation ir = (IntegrationRelation)this.newBillEntity(IntegrationRelation.class);
        EFI_IntegrationRelation efi_ir = ir.newEFI_IntegrationRelation();
        efi_ir.setClientID(this.getClientID());
        efi_ir.setSrcFormKey("FI_Voucher");
        efi_ir.setSrcSOID(fiVoucher.getOID());
        efi_ir.setSrcDocumentNumber(fiVoucher.getDocumentNumber());
        efi_ir.setTargetFormKey("FM_FundVoucher");
        efi_ir.setTargetSOID(fundVoucher.getOID());
        efi_ir.setTargetDocumentNumber(fundVoucher.getDocumentNumber());
        this.save((AbstractBillEntity)ir);
    }

    public String getMaterialPriceType(Long plantID, Long materialID, Long valuationTypeID) throws Throwable {
        EGS_MaterialValuationArea materialValuationArea = EGS_MaterialValuationArea.loader((RichDocumentContext)this.getMidContext()).SOID(materialID).ValuationAreaID(plantID).GlobalValuationTypeID(valuationTypeID).load();
        if (materialValuationArea == null) {
            return "";
        }
        return materialValuationArea.getPriceType();
    }

    public boolean checkTransactionKeyCodeGR1(EFI_VoucherDtl_Entry dtlEntry) throws Throwable {
        return dtlEntry.getTransactionKeyCode().equals("PRD") || dtlEntry.getTransactionKeyCode().equals("KDM") || dtlEntry.getTransactionKeyCode().equals("UMB") || dtlEntry.getTransactionKeyCode().equals("AUM") || dtlEntry.getTransactionKeyCode().equals("AKO");
    }

    public void deleteFundVoucher(FI_Voucher fiVoucher) throws Throwable {
        FM_FundVoucher fundVoucher = FM_FundVoucher.loader((RichDocumentContext)this.getMidContext()).ReferFIDocOID(fiVoucher.getOID()).load();
        if (fundVoucher != null) {
            fundVoucher.document.evaluate("Macro_MidDelete()", "\u5220\u9664\u57fa\u91d1\u51ed\u8bc1");
        }
    }
}

