/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.avc.integration;

import com.bokesoft.erp.billentity.EFI_VoucherDtl_Entry;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Fund;
import com.bokesoft.erp.billentity.EFM_FundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_UpdateProfileDtl;
import com.bokesoft.erp.billentity.EMM_IncomingInvoiceDtl;
import com.bokesoft.erp.billentity.EMM_IncomingInvoiceHead;
import com.bokesoft.erp.billentity.EMM_IncomingInvoiceTax;
import com.bokesoft.erp.billentity.EMM_InvoiceAccountAssignDtl;
import com.bokesoft.erp.billentity.EMM_MaterialDocument;
import com.bokesoft.erp.billentity.EMM_MoveType;
import com.bokesoft.erp.billentity.EMM_PO_AccountAssignDtl;
import com.bokesoft.erp.billentity.EMM_PurchaseOrderDtl;
import com.bokesoft.erp.billentity.EMM_PurchaseOrderHead;
import com.bokesoft.erp.billentity.FI_Voucher;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_FundVoucher;
import com.bokesoft.erp.billentity.MM_IncomingInvoice;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.fm.avc.integration.FundVoucherFormula;
import com.bokesoft.erp.fm.enums.AmountTypeEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.erp.mm.invoice.InvoiceVerificationFormula;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class FundVoucher4StockInvoice
extends FundVoucherFormula {
    public FundVoucher4StockInvoice(RichDocumentContext _context) {
        super(_context);
    }

    public FundVoucher4StockInvoice(RichDocumentContext _context, EFM_FinancialManagementArea finManagementArea, Long versionID, int isPeriodOrYear, Long postingDate, int fiscalYear, int fiscalPeriod, EFM_UpdateProfileDtl updateProfileDtl) throws Throwable {
        super(_context, finManagementArea, versionID, isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
    }

    @Override
    public FM_FundVoucher genFundVoucher(FM_FundVoucher fm_fundVoucher, List<EFI_VoucherDtl_Entry> efi_voucherDtl_entries) throws Throwable {
        this.businessTransaction = "RMRP";
        for (EFI_VoucherDtl_Entry dtlEntry : efi_voucherDtl_entries) {
            if (dtlEntry.getAccountType().equals("K") || dtlEntry.getAccountType().equals("D") || dtlEntry.getAccountType().equals("L") || dtlEntry.getTransactionKeyCode().equals("VST")) continue;
            boolean isStatisticsUpdate = this.updateProfileDtl.getIsStatisticsUpdate() > 0;
            Long fundID = dtlEntry.getFundID();
            Long fundCenterID = dtlEntry.getFundCenterID();
            Long commitItemID = dtlEntry.getCommitmentItemID();
            Long functionScopeID = dtlEntry.getFunctionalAreaID();
            if (commitItemID.compareTo(0L) == 0) {
                MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE001", (Object[])new Object[]{dtlEntry.getAccountCode(), dtlEntry.getAccount().getName()});
            }
            if (!this.functionAreaActive) {
                functionScopeID = 0L;
            }
            String postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionScopeID, 0L);
            EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID);
            if (commitmentItem.getIsStatisticalCommit() > 0) {
                isStatisticsUpdate = true;
            }
            Long purchaseOrderDtlOID = dtlEntry.getPurchaseOrderDtlOID();
            EMM_PurchaseOrderDtl purchaseOrderDtl = EMM_PurchaseOrderDtl.load((RichDocumentContext)this.getMidContext(), (Long)purchaseOrderDtlOID);
            int isEstimatedPrice = purchaseOrderDtl.getIsEstimatedPrice();
            if (this.grirUpdate == 1) {
                if (isEstimatedPrice > 0) {
                    if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
                        this.genVoucherByPostLedger("9A", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
                    }
                    if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0) continue;
                    this.genVoucherByPostLedger("9B", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
                    continue;
                }
                if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0 && !this.checkTransactionKeyCodeGR1(dtlEntry)) {
                    this.genVoucherByPostLedger("9A", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
                }
                if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0 || this.checkTransactionKeyCodeGR1(dtlEntry)) continue;
                this.genVoucherByPostLedger("9B", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
                continue;
            }
            if (this.grirUpdate == 2) {
                if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
                    this.genVoucherByPostLedger("9A", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
                }
                if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0) continue;
                this.genVoucherByPostLedger("9B", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
                continue;
            }
            if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
                this.genVoucherByPostLedger("9A", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
            }
            if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0) continue;
            this.genVoucherByPostLedger("9B", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
        }
        this.dealWithTaxDtl(fm_fundVoucher, efi_voucherDtl_entries);
        return fm_fundVoucher;
    }

    private void dealWithTaxDtl(FM_FundVoucher fm_fundVoucher, List<EFI_VoucherDtl_Entry> efi_voucherDtl_entries) throws Throwable {
        int taxType = this.finManagementArea.getTaxType();
        boolean isStatisticsUpdate = taxType == Integer.parseInt("0");
        for (EFI_VoucherDtl_Entry taxDtl : efi_voucherDtl_entries) {
            if (!taxDtl.getTransactionKeyCode().equals("VST")) continue;
            Long srcOID = taxDtl.getSrcOID();
            EMM_IncomingInvoiceTax emmIncomingInvoiceTax = EMM_IncomingInvoiceTax.load((RichDocumentContext)this.getMidContext(), (Long)srcOID);
            if (emmIncomingInvoiceTax.getTaxMoney().equals(BigDecimal.ZERO)) continue;
            Long taxCodeID = emmIncomingInvoiceTax.getTaxCodeID();
            BigDecimal taxAmount = emmIncomingInvoiceTax.getTaxVoucherCurrency().multiply(new BigDecimal(emmIncomingInvoiceTax.getDebitCredit()));
            Long srcSOID = taxDtl.getSrcSOID();
            List emm_incomingInvoiceDtls = EMM_IncomingInvoiceDtl.loader((RichDocumentContext)this.getMidContext()).SOID(srcSOID).TaxCodeID(taxCodeID).loadList();
            EMM_IncomingInvoiceHead mm_incomingInvoice = EMM_IncomingInvoiceHead.load((RichDocumentContext)this.getMidContext(), (Long)srcSOID);
            int isCalculateTax = mm_incomingInvoice.getIsCalculateTax();
            BigDecimal totalQuantity = BigDecimal.ZERO;
            if (isCalculateTax == 0) {
                for (EMM_IncomingInvoiceDtl dtl : emm_incomingInvoiceDtls) {
                    totalQuantity = totalQuantity.add(dtl.getQuantity());
                }
            }
            if (totalQuantity.compareTo(BigDecimal.ZERO) == 0) {
                totalQuantity = BigDecimal.ONE;
            }
            for (EMM_IncomingInvoiceDtl incomingInvoiceDtl : emm_incomingInvoiceDtls) {
                BigDecimal incomingInvoiceDtlQuantity;
                List emm_invoiceAccountAssignDtls = EMM_InvoiceAccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).POID(incomingInvoiceDtl.getOID()).loadList();
                if (emm_invoiceAccountAssignDtls == null || emm_invoiceAccountAssignDtls.isEmpty()) {
                    MessageFacade.throwException((String)"FUNDVOUCHER4STOCKINVOICE001");
                }
                BigDecimal dtlTaxAmount = incomingInvoiceDtl.getTaxMoney().multiply(new BigDecimal(incomingInvoiceDtl.getDebitCreditIdentify()));
                BigDecimal bigDecimal = incomingInvoiceDtlQuantity = incomingInvoiceDtl.getQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : incomingInvoiceDtl.getQuantity();
                if (isCalculateTax == 0) {
                    dtlTaxAmount = taxAmount.multiply(incomingInvoiceDtlQuantity.divide(totalQuantity));
                }
                for (EMM_InvoiceAccountAssignDtl accountAssignDtl : emm_invoiceAccountAssignDtls) {
                    EFM_CommitmentItemHead commitmentItem;
                    Long fundID = accountAssignDtl.getFundID();
                    Long fundCenterID = accountAssignDtl.getFundCenterID();
                    Long commitItemID = taxDtl.getCommitmentItemID();
                    String commitItemCode = taxDtl.getCommitmentItemCode();
                    Long functionalAreaID = taxDtl.getFunctionalAreaID();
                    BigDecimal accountAssignDtlQuantity = accountAssignDtl.getQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : accountAssignDtl.getQuantity();
                    BigDecimal percent = accountAssignDtlQuantity.divide(incomingInvoiceDtlQuantity);
                    if (taxType == Integer.parseInt("1")) {
                        commitItemID = accountAssignDtl.getCommitmentItemID();
                        commitItemCode = accountAssignDtl.getCommitmentItemCode();
                    } else if (taxType == Integer.parseInt("2") && commitItemID.equals(0L)) {
                        MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE002", (Object[])new Object[]{taxDtl.getAccountCode(), taxDtl.getAccount().getName()});
                    }
                    if (commitItemID.compareTo(0L) <= 0) {
                        MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE003", (Object[])new Object[]{taxDtl.getAccountCode(), taxDtl.getAccount().getName()});
                    }
                    if ((commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID)).getIsStatisticalCommit() > 0) {
                        isStatisticsUpdate = true;
                    }
                    if (!this.functionAreaActive) {
                        functionalAreaID = 0L;
                    }
                    String postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionalAreaID, 0L);
                    BigDecimal accountTaxAmount = dtlTaxAmount.multiply(percent);
                    if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
                        this.genTaxVoucherDtl("9A", fm_fundVoucher, taxDtl, isStatisticsUpdate, accountAssignDtl, fundID, fundCenterID, commitItemID, commitItemCode, postAddress, accountTaxAmount);
                    }
                    if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0) continue;
                    this.genTaxVoucherDtl("9B", fm_fundVoucher, taxDtl, isStatisticsUpdate, accountAssignDtl, fundID, fundCenterID, commitItemID, commitItemCode, postAddress, accountTaxAmount);
                }
            }
        }
    }

    private void genTaxVoucherDtl(String postLedgerCode, FM_FundVoucher fm_fundVoucher, EFI_VoucherDtl_Entry taxDtl, boolean isStatisticsUpdate, EMM_InvoiceAccountAssignDtl accountAssignDtl, Long fundID, Long fundCenterID, Long commitItemID, String commitItemCode, String postAddress, BigDecimal accountTaxAmount) throws Throwable {
        EFM_AddressIndex addressIndex;
        EFM_BSDistribution bsDistribution;
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code(postLedgerCode).load();
        Long fmLedgerID = payLedger.getOID();
        String budgetLedgerCode = "9F";
        if (postLedgerCode.equals("9B")) {
            budgetLedgerCode = "9G";
        }
        if (fundID.compareTo(0L) > 0) {
            EFM_Fund fundDict = EFM_Fund.load((RichDocumentContext)this.getMidContext(), (Long)fundID);
            Long termValidityFromDate = fundDict.getValidStartDate();
            Long termValidityToDate = fundDict.getValidEndDate();
            if (ERPDateUtil.isBefore((Object)(this.postingDate + 1L), (Object)termValidityFromDate) || ERPDateUtil.isBefore((Object)termValidityToDate, (Object)this.postingDate)) {
                MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE004", (Object[])new Object[]{fundDict.getCode()});
            }
        }
        Long functionalAreaID = taxDtl.getFunctionalAreaID();
        String functionalAreaCode = taxDtl.getFunctionalAreaCode();
        if (!this.functionAreaActive) {
            functionalAreaID = 0L;
            functionalAreaCode = "";
        }
        if ((bsDistribution = EFM_BSDistribution.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FiscalYear(this.fiscalYear).load()) != null && bsDistribution.getIsCheckPost() > 0 && (addressIndex = EFM_AddressIndex.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FromFiscalYear(this.fiscalYear).FromLedgerID(fmLedgerID).FromObjectNumber(postAddress).ToLedgerCode(budgetLedgerCode).load()) == null) {
            MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE005", (Object[])new Object[]{this.fiscalYear, postLedgerCode, accountAssignDtl.getFundCode(), accountAssignDtl.getFundCenterCode(), commitItemCode, functionalAreaCode});
        }
        EFM_FundVoucherDtl efm_fundVoucherDtl = fm_fundVoucher.newEFM_FundVoucherDtl();
        efm_fundVoucherDtl.setFinancialManagementAreaID(this.fmAreaID);
        efm_fundVoucherDtl.setMoneyType(AmountTypeEnum.AmountType_0100.getKey());
        efm_fundVoucherDtl.setLedgerID(fmLedgerID);
        efm_fundVoucherDtl.setFiscalYear(this.fiscalYear);
        efm_fundVoucherDtl.setPostingDate(this.postingDate);
        efm_fundVoucherDtl.setFiscalPeriod(this.fiscalPeriod);
        efm_fundVoucherDtl.setTransactionCurrencyMoney(accountTaxAmount);
        efm_fundVoucherDtl.setFMAreaCurrencyMoney(accountTaxAmount);
        efm_fundVoucherDtl.setCommitmentItemID(commitItemID);
        efm_fundVoucherDtl.setFundCenterID(fundCenterID);
        efm_fundVoucherDtl.setFundID(fundID);
        efm_fundVoucherDtl.setFunctionalAreaID(functionalAreaID);
        efm_fundVoucherDtl.setBusinessAreaID(taxDtl.getBusinessAreaID());
        efm_fundVoucherDtl.setProfitCenterID(taxDtl.getProfitCenterID());
        efm_fundVoucherDtl.setValueType(ValueTypeEnum.ValueType_54.getKey());
        efm_fundVoucherDtl.setCurrencyID(taxDtl.getCurrencyID());
        efm_fundVoucherDtl.setGLAccountID(taxDtl.getAccountID());
        efm_fundVoucherDtl.setReferDocSOID(taxDtl.getSrcSOID());
        efm_fundVoucherDtl.setReferDocDtlOID(taxDtl.getSrcOID());
        efm_fundVoucherDtl.setReferFIDocSOID(taxDtl.getSOID());
        efm_fundVoucherDtl.setReferFIDocDtlOID(taxDtl.getOID());
        efm_fundVoucherDtl.setPostAddress(postAddress);
        efm_fundVoucherDtl.setIsUpdate(0);
        efm_fundVoucherDtl.setVersionID(this.versionID);
        efm_fundVoucherDtl.setQuantity(taxDtl.getBaseQuantity());
        efm_fundVoucherDtl.setUnitID(taxDtl.getBaseUnitID());
        efm_fundVoucherDtl.setStatisticalIdentifier("Empty");
        if (isStatisticsUpdate) {
            efm_fundVoucherDtl.setStatisticalIdentifier("X");
        }
    }

    private void feedBackPOVoucher(Long fmLedgerID, BigDecimal amount, Long purchaseOrderID, Long srcPOBillDtlID, EMM_PO_AccountAssignDtl accountAssignDtl, FM_CommitVoucher fmCommitVoucher) throws Throwable {
        String currPostAddress = this.addressUtils.genAddress(accountAssignDtl.getFundID(), accountAssignDtl.getFundCenterID(), accountAssignDtl.getCommitmentItemID(), accountAssignDtl.getFunctionalAreaID(), 0L);
        EFM_CommitVoucherDtl commitVoucher = this.getCommitVoucher(fmLedgerID, accountAssignDtl);
        if (commitVoucher == null) {
            return;
        }
        if (this.isPeriodOrYear == Integer.parseInt("1")) {
            BigDecimal sendAmount;
            List efm_commitVoucherDtls = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
            if (efm_commitVoucherDtls != null) {
                for (EFM_CommitVoucherDtl deleteVoucher : efm_commitVoucherDtls) {
                    if (!deleteVoucher.getPostAddress().equals(currPostAddress)) continue;
                    amount = amount.add(deleteVoucher.getFMAreaCurrencyMoney());
                    fmCommitVoucher.deleteEFM_CommitVoucherDtl(deleteVoucher);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, amount.negate());
            }
            if ((sendAmount = this.getSendAmount(purchaseOrderID, srcPOBillDtlID, accountAssignDtl.getOID(), fmLedgerID, currPostAddress).add(amount.negate())).compareTo(BigDecimal.ZERO) < 0) {
                this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, sendAmount.negate());
            }
        } else {
            this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, amount.negate());
            BigDecimal sendAmount = this.getSendAmount(purchaseOrderID, srcPOBillDtlID, accountAssignDtl.getOID(), fmLedgerID, currPostAddress).add(amount.negate());
            if (sendAmount.compareTo(BigDecimal.ZERO) < 0) {
                this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, sendAmount.negate());
            }
        }
    }

    @Override
    public void feedBack(FI_Voucher fiVoucher) throws Throwable {
        Long srcSOID = fiVoucher.getSrcSOID();
        MM_IncomingInvoice incomingInvoice = MM_IncomingInvoice.load((RichDocumentContext)this.getMidContext(), (Long)srcSOID);
        int transactionHandle_head = incomingInvoice.getTransactionHandle();
        BigDecimal direction = BigDecimal.ONE;
        if (transactionHandle_head != 1 && transactionHandle_head != 3) {
            direction = direction.negate();
        }
        List emm_incomingInvoiceDtls = incomingInvoice.emm_incomingInvoiceDtls();
        for (EMM_IncomingInvoiceDtl incomingInvoiceDtl : emm_incomingInvoiceDtls) {
            Long srcPOBillID = incomingInvoiceDtl.getSrcPurchaseOrderSOID();
            Long srcPOBillDtlID = incomingInvoiceDtl.getSrcPurchaseOrderDtlOID();
            Long srcMSEGBillID = incomingInvoiceDtl.getSrcMSEGSOID();
            Long srcMSEGBillDtlID = incomingInvoiceDtl.getSrcMaterialDocumentOID();
            EMM_PurchaseOrderDtl purchaseOrderDtl = EMM_PurchaseOrderDtl.load((RichDocumentContext)this.getMidContext(), (Long)srcPOBillDtlID);
            int isEstimatedPrice = purchaseOrderDtl.getIsEstimatedPrice();
            if (this.grirUpdate == 1) {
                if (isEstimatedPrice > 0) {
                    this.feedBackPOGRIR2(direction, incomingInvoiceDtl, srcPOBillID, srcPOBillDtlID, purchaseOrderDtl);
                    continue;
                }
                this.feedBackPOGRIR1(direction, incomingInvoiceDtl, srcPOBillID, srcPOBillDtlID, srcMSEGBillID, srcMSEGBillDtlID, purchaseOrderDtl);
                continue;
            }
            if (this.grirUpdate == 2) {
                this.feedBackPOGRIR2(direction, incomingInvoiceDtl, srcPOBillID, srcPOBillDtlID, purchaseOrderDtl);
                continue;
            }
            if (isEstimatedPrice > 0) {
                this.feedBackPOGRIR2(direction, incomingInvoiceDtl, srcPOBillID, srcPOBillDtlID, purchaseOrderDtl);
                continue;
            }
            this.feedBackPOGRIR1(direction, incomingInvoiceDtl, srcPOBillID, srcPOBillDtlID, srcMSEGBillID, srcMSEGBillDtlID, purchaseOrderDtl);
            this.feedBackMSEGGRIR3(direction, incomingInvoiceDtl, srcMSEGBillID, srcMSEGBillDtlID);
        }
    }

    private void feedBackMSEGGRIR3(BigDecimal direction, EMM_IncomingInvoiceDtl incomingInvoiceDtl, Long srcMSEGBillID, Long srcMSEGBillDtlID) throws Throwable {
        Long fmLedgerID;
        EFM_Ledger payLedger;
        if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
            fmLedgerID = payLedger.getOID();
            this.genMSEGVoucherDtl(direction, incomingInvoiceDtl, srcMSEGBillID, srcMSEGBillDtlID, fmLedgerID);
        }
        if (this.updateProfileDtl.getIsCBActive() > 0 && this.updateProfileDtl.getIsCBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9B").load();
            fmLedgerID = payLedger.getOID();
            this.genMSEGVoucherDtl(direction, incomingInvoiceDtl, srcMSEGBillID, srcMSEGBillDtlID, fmLedgerID);
        }
    }

    private void genMSEGVoucherDtl(BigDecimal direction, EMM_IncomingInvoiceDtl incomingInvoiceDtl, Long srcMSEGBillID, Long srcMSEGBillDtlID, Long fmLedgerID) throws Throwable {
        BigDecimal settled = new InvoiceVerificationFormula(this.getMidContext()).setSettled(incomingInvoiceDtl.getSrcPurchaseOrderSOID(), incomingInvoiceDtl.getSrcPurchaseOrderDtlOID(), srcMSEGBillID, srcMSEGBillDtlID);
        BigDecimal received = this.setReceived(incomingInvoiceDtl.getSrcPurchaseOrderDtlOID(), srcMSEGBillDtlID);
        BigDecimal quantity = incomingInvoiceDtl.getQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : incomingInvoiceDtl.getQuantity();
        FM_FundVoucher msegFundVoucher = FM_FundVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(srcMSEGBillID).load();
        if (msegFundVoucher == null) {
            MessageFacade.throwException((String)"FUNDVOUCHER4STOCKINVOICE004");
        }
        List efm_fundVoucherDtls = msegFundVoucher.efm_fundVoucherDtls("ReferDocDtlOID", (Object)srcMSEGBillDtlID);
        if (this.isPeriodOrYear == Integer.parseInt("1")) {
            for (EFM_FundVoucherDtl msegVoucherDtl : efm_fundVoucherDtls) {
                if (!msegVoucherDtl.getMoneyType().equals(AmountTypeEnum.AmountType_0200.getKey()) || !fmLedgerID.equals(msegVoucherDtl.getLedgerID())) continue;
                msegFundVoucher.deleteEFM_FundVoucherDtl(msegVoucherDtl);
            }
            efm_fundVoucherDtls = msegFundVoucher.efm_fundVoucherDtls("ReferDocDtlOID", (Object)srcMSEGBillDtlID);
            for (EFM_FundVoucherDtl msegVoucherDtl : efm_fundVoucherDtls) {
                EFM_FundVoucherDtl msegVoucherDtl0100 = null;
                if (msegVoucherDtl.getMoneyType().equals(AmountTypeEnum.AmountType_0100.getKey()) && fmLedgerID.equals(msegVoucherDtl.getLedgerID())) {
                    msegVoucherDtl0100 = msegVoucherDtl;
                }
                if (msegVoucherDtl0100 == null) continue;
                BigDecimal fmacAmount = msegVoucherDtl0100.getFMAreaCurrencyMoney();
                BigDecimal amount = settled.divide(received).multiply(fmacAmount).setScale(2, RoundingMode.HALF_UP).multiply(direction);
                this.genFundVoucherDtlFromDtl(AmountTypeEnum.AmountType_0200.getKey(), msegFundVoucher, msegVoucherDtl0100, amount.negate());
                BigDecimal sendAmount = this.getSendAmount4FundVoucher(msegVoucherDtl0100.getReferDocSOID(), msegVoucherDtl0100.getReferDocDtlOID(), msegVoucherDtl0100.getReferFIDocOID(), msegVoucherDtl0100.getReferFIDocDtlOID(), msegVoucherDtl0100.getLedgerID(), msegVoucherDtl0100.getPostAddress()).add(amount.negate());
                if (sendAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.genFundVoucherDtlFromDtl(AmountTypeEnum.AmountType_0500.getKey(), msegFundVoucher, msegVoucherDtl0100, sendAmount.negate());
            }
        } else {
            for (EFM_FundVoucherDtl msegVoucherDtl : efm_fundVoucherDtls) {
                if (!msegVoucherDtl.getMoneyType().equals(AmountTypeEnum.AmountType_0100.getKey()) || !fmLedgerID.equals(msegVoucherDtl.getLedgerID())) continue;
                EMM_MaterialDocument materialDocument = EMM_MaterialDocument.loader((RichDocumentContext)this.getMidContext()).OID(msegVoucherDtl.getReferDocDtlOID()).load();
                BigDecimal msegQuantity = materialDocument.getQuantity();
                BigDecimal fmacAmount = msegVoucherDtl.getFMAreaCurrencyMoney();
                BigDecimal amount = quantity.divide(msegQuantity).multiply(fmacAmount).setScale(2, RoundingMode.HALF_UP).multiply(direction);
                this.genFundVoucherDtlFromDtl(AmountTypeEnum.AmountType_0200.getKey(), msegFundVoucher, msegVoucherDtl, amount.negate());
                BigDecimal sendAmount = this.getSendAmount4FundVoucher(msegVoucherDtl.getReferDocSOID(), msegVoucherDtl.getReferDocDtlOID(), msegVoucherDtl.getReferFIDocOID(), msegVoucherDtl.getReferFIDocDtlOID(), msegVoucherDtl.getLedgerID(), msegVoucherDtl.getPostAddress()).add(amount.negate());
                if (sendAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.genFundVoucherDtlFromDtl(AmountTypeEnum.AmountType_0500.getKey(), msegFundVoucher, msegVoucherDtl, sendAmount.negate());
            }
        }
        this.save((AbstractBillEntity)msegFundVoucher);
    }

    private void feedBackPOGRIR1(BigDecimal direction, EMM_IncomingInvoiceDtl incomingInvoiceDtl, Long srcPOBillID, Long srcPOBillDtlID, Long srcMSEGBillID, Long srcMSEGBillDtlID, EMM_PurchaseOrderDtl purchaseOrderDtl) throws Throwable {
        FM_CommitVoucher fmCommitVoucher;
        EMM_PO_AccountAssignDtl accountAssignDtl;
        List emm_po_accountAssignDtls;
        BigDecimal diffAmount;
        BigDecimal price;
        BigDecimal totalSettled;
        BigDecimal quantity;
        BigDecimal received;
        BigDecimal settled;
        Long fmLedgerID;
        EFM_Ledger payLedger;
        if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
            fmLedgerID = payLedger.getOID();
            if (purchaseOrderDtl.getIsGRInvoiceVerification() == 0) {
                settled = new InvoiceVerificationFormula(this.getMidContext()).setSettled(srcPOBillID, srcPOBillDtlID, srcMSEGBillID, srcMSEGBillDtlID);
                received = this.setReceived(srcPOBillDtlID, srcMSEGBillDtlID);
                quantity = incomingInvoiceDtl.getQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : incomingInvoiceDtl.getQuantity();
                totalSettled = settled.add(quantity);
                if (totalSettled.compareTo(received) < 0) {
                    price = purchaseOrderDtl.getPrice();
                    diffAmount = quantity.multiply(price);
                    emm_po_accountAssignDtls = EMM_PO_AccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).POID(srcPOBillDtlID).loadList();
                    if (emm_po_accountAssignDtls == null || emm_po_accountAssignDtls.size() > 1) {
                        MessageFacade.throwException((String)"FUNDVOUCHER4STOCKINVOICE002");
                    }
                    accountAssignDtl = (EMM_PO_AccountAssignDtl)emm_po_accountAssignDtls.get(0);
                    fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(accountAssignDtl.getSOID()).ReferItemOID(accountAssignDtl.getPOID()).Dtl_ReferAccountAssignItemOID(accountAssignDtl.getOID()).load();
                    if (fmCommitVoucher == null) {
                        return;
                    }
                    this.feedBackPOVoucher(fmLedgerID, diffAmount.multiply(direction), srcPOBillID, srcPOBillDtlID, accountAssignDtl, fmCommitVoucher);
                }
            }
        }
        if (this.updateProfileDtl.getIsCBActive() > 0 && this.updateProfileDtl.getIsCBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9B").load();
            fmLedgerID = payLedger.getOID();
            if (purchaseOrderDtl.getIsGRInvoiceVerification() == 0) {
                settled = new InvoiceVerificationFormula(this.getMidContext()).setSettled(srcPOBillID, srcPOBillDtlID, srcMSEGBillID, srcMSEGBillDtlID);
                received = this.setReceived(srcPOBillDtlID, srcMSEGBillDtlID);
                quantity = incomingInvoiceDtl.getQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : incomingInvoiceDtl.getQuantity();
                totalSettled = settled.add(quantity);
                if (totalSettled.compareTo(received) < 0) {
                    price = purchaseOrderDtl.getPrice();
                    diffAmount = quantity.multiply(price);
                    emm_po_accountAssignDtls = EMM_PO_AccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).POID(srcPOBillDtlID).loadList();
                    if (emm_po_accountAssignDtls == null || emm_po_accountAssignDtls.size() > 1) {
                        MessageFacade.throwException((String)"FUNDVOUCHER4STOCKINVOICE002");
                    }
                    accountAssignDtl = (EMM_PO_AccountAssignDtl)emm_po_accountAssignDtls.get(0);
                    fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(accountAssignDtl.getSOID()).ReferItemOID(accountAssignDtl.getPOID()).Dtl_ReferAccountAssignItemOID(accountAssignDtl.getOID()).load();
                    if (fmCommitVoucher == null) {
                        return;
                    }
                    this.feedBackPOVoucher(fmLedgerID, diffAmount.multiply(direction), srcPOBillID, srcPOBillDtlID, accountAssignDtl, fmCommitVoucher);
                }
            }
        }
    }

    private void feedBackPOGRIR2(BigDecimal direction, EMM_IncomingInvoiceDtl incomingInvoiceDtl, Long srcPOBillID, Long srcPOBillDtlID, EMM_PurchaseOrderDtl purchaseOrderDtl) throws Throwable {
        BigDecimal price;
        BigDecimal quantity;
        FM_CommitVoucher fmCommitVoucher;
        EMM_PO_AccountAssignDtl accountAssignDtl;
        List emm_po_accountAssignDtls;
        Long fmLedgerID;
        EFM_Ledger payLedger;
        if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
            fmLedgerID = payLedger.getOID();
            emm_po_accountAssignDtls = EMM_PO_AccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).POID(srcPOBillDtlID).loadList();
            if (emm_po_accountAssignDtls == null || emm_po_accountAssignDtls.size() > 1) {
                MessageFacade.throwException((String)"FUNDVOUCHER4STOCKINVOICE003");
            }
            accountAssignDtl = (EMM_PO_AccountAssignDtl)emm_po_accountAssignDtls.get(0);
            fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(accountAssignDtl.getSOID()).ReferItemOID(accountAssignDtl.getPOID()).Dtl_ReferAccountAssignItemOID(accountAssignDtl.getOID()).load();
            if (fmCommitVoucher == null) {
                return;
            }
            quantity = incomingInvoiceDtl.getQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : incomingInvoiceDtl.getQuantity();
            price = purchaseOrderDtl.getPrice();
            this.feedBackPOVoucher(fmLedgerID, quantity.multiply(price).multiply(direction), srcPOBillID, srcPOBillDtlID, accountAssignDtl, fmCommitVoucher);
            this.save((AbstractBillEntity)fmCommitVoucher);
        }
        if (this.updateProfileDtl.getIsCBActive() > 0 && this.updateProfileDtl.getIsCBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9B").load();
            fmLedgerID = payLedger.getOID();
            emm_po_accountAssignDtls = EMM_PO_AccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).POID(srcPOBillDtlID).loadList();
            if (emm_po_accountAssignDtls == null || emm_po_accountAssignDtls.size() > 1) {
                MessageFacade.throwException((String)"FUNDVOUCHER4STOCKINVOICE002");
            }
            accountAssignDtl = (EMM_PO_AccountAssignDtl)emm_po_accountAssignDtls.get(0);
            fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(accountAssignDtl.getSOID()).ReferItemOID(accountAssignDtl.getPOID()).Dtl_ReferAccountAssignItemOID(accountAssignDtl.getOID()).load();
            if (fmCommitVoucher == null) {
                return;
            }
            quantity = incomingInvoiceDtl.getQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : incomingInvoiceDtl.getQuantity();
            price = purchaseOrderDtl.getPrice();
            this.feedBackPOVoucher(fmLedgerID, quantity.multiply(price).multiply(direction), srcPOBillID, srcPOBillDtlID, accountAssignDtl, fmCommitVoucher);
            this.save((AbstractBillEntity)fmCommitVoucher);
        }
    }

    private BigDecimal setReceived(Long srcOrderBillDtlID, Long srcGRBillDtlID) throws Throwable {
        BigDecimal sum = BigDecimal.ZERO;
        if (srcOrderBillDtlID > 0L) {
            EMM_PurchaseOrderDtl emmPurchaseOrderDtl = EMM_PurchaseOrderDtl.load((RichDocumentContext)this.getMidContext(), (Long)srcOrderBillDtlID);
            if (emmPurchaseOrderDtl.getIsGRInvoiceVerification() == 1) {
                if (srcGRBillDtlID > 0L) {
                    EMM_MaterialDocument dtl = EMM_MaterialDocument.load((RichDocumentContext)this.getMidContext(), (Long)srcGRBillDtlID);
                    EMM_MoveType emmMoveType = EMM_MoveType.load((RichDocumentContext)this.getMidContext(), (Long)dtl.getMoveTypeID());
                    sum = emmMoveType.getGRBlockedStock().equalsIgnoreCase("S") ? dtl.getPushedGRQuantity105() : dtl.getQuantity().subtract(dtl.getPushedGRQuantity102()).subtract(dtl.getPushedGRQuantity122());
                    return sum.abs();
                }
            } else {
                EMM_PurchaseOrderDtl dtl = EMM_PurchaseOrderDtl.load((RichDocumentContext)this.getMidContext(), (Long)srcOrderBillDtlID);
                EMM_PurchaseOrderHead emmPurchaseOrderHead = EMM_PurchaseOrderHead.load((RichDocumentContext)this.getMidContext(), (Long)dtl.getSOID());
                sum = emmPurchaseOrderHead.getSTOType() == 5 ? (emmPurchaseOrderHead.getSupplyingPlantID() > 0L ? dtl.getPushedGRQuantity() : dtl.getPushedSTOPostingQuantity()) : dtl.getPushedGRQuantity();
                return sum;
            }
        }
        return sum;
    }
}

