/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.avc.integration;

import com.bokesoft.erp.billentity.EFI_VoucherDtl_Entry;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Fund;
import com.bokesoft.erp.billentity.EFM_FundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_UpdateProfileDtl;
import com.bokesoft.erp.billentity.ESD_SaleOrderDtl;
import com.bokesoft.erp.billentity.FI_Voucher;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_FundVoucher;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.fm.avc.integration.FundVoucherFormula;
import com.bokesoft.erp.fm.enums.AmountTypeEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import java.math.BigDecimal;
import java.util.List;

public class FundVoucher4SaleInvoice
extends FundVoucherFormula {
    public FundVoucher4SaleInvoice(RichDocumentContext _context) {
        super(_context);
    }

    public FundVoucher4SaleInvoice(RichDocumentContext _context, EFM_FinancialManagementArea finManagementArea, Long versionID, int isPeriodOrYear, Long postingDate, int fiscalYear, int fiscalPeriod, EFM_UpdateProfileDtl updateProfileDtl) throws Throwable {
        super(_context, finManagementArea, versionID, isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
    }

    @Override
    FM_FundVoucher getFundVoucher(FI_Voucher fiVoucher) throws Throwable {
        return super.getFundVoucher(fiVoucher);
    }

    @Override
    public FM_FundVoucher genFundVoucher(FM_FundVoucher fm_fundVoucher, List<EFI_VoucherDtl_Entry> efi_voucherDtl_entries) throws Throwable {
        this.businessTransaction = "RMRP";
        for (EFI_VoucherDtl_Entry dtlEntry : efi_voucherDtl_entries) {
            if (dtlEntry.getAccountType().equals("K") || dtlEntry.getAccountType().equals("D") || dtlEntry.getAccountType().equals("L") || dtlEntry.getTransactionKeyCode().equals("MWS")) continue;
            boolean isStatisticsUpdate = this.updateProfileDtl.getIsStatisticsUpdate() > 0;
            Long fundID = dtlEntry.getFundID();
            Long fundCenterID = dtlEntry.getFundCenterID();
            Long commitItemID = dtlEntry.getCommitmentItemID();
            Long functionScopeID = dtlEntry.getFunctionalAreaID();
            if (commitItemID.compareTo(0L) == 0) {
                MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE001", (Object[])new Object[]{dtlEntry.getAccountCode(), dtlEntry.getAccount().getName()});
            }
            if (!this.functionAreaActive) {
                functionScopeID = 0L;
            }
            String postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionScopeID, 0L);
            EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID);
            if (commitmentItem.getIsStatisticalCommit() > 0) {
                isStatisticsUpdate = true;
            }
            if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
                this.genVoucherByPostLedger("9A", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
            }
            if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0) continue;
            this.genVoucherByPostLedger("9B", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
        }
        this.dealWithTaxDtl(fm_fundVoucher, efi_voucherDtl_entries);
        return fm_fundVoucher;
    }

    private void dealWithTaxDtl(FM_FundVoucher fm_fundVoucher, List<EFI_VoucherDtl_Entry> efi_voucherDtl_entries) throws Throwable {
        int taxType = this.finManagementArea.getTaxType();
        boolean isStatisticsUpdate = taxType == Integer.parseInt("0");
        for (EFI_VoucherDtl_Entry taxDtl : efi_voucherDtl_entries) {
            EFM_CommitmentItemHead commitmentItem;
            if (!taxDtl.getTransactionKeyCode().equals("MWS") || taxDtl.getMoney().equals(BigDecimal.ZERO)) continue;
            BigDecimal taxAmount = taxDtl.getMoney().multiply(new BigDecimal(taxDtl.getDirection()));
            Long fundID = taxDtl.getFundID();
            Long fundCenterID = taxDtl.getFundCenterID();
            Long commitItemID = taxDtl.getCommitmentItemID();
            Long functionalAreaID = taxDtl.getFunctionalAreaID();
            if (taxType == Integer.parseInt("2")) {
                if (commitItemID.equals(0L)) {
                    MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE002", (Object[])new Object[]{taxDtl.getAccountCode(), taxDtl.getAccount().getName()});
                }
                if ((commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID)).getIsStatisticalCommit() > 0) {
                    isStatisticsUpdate = true;
                }
            }
            if (commitItemID.compareTo(0L) <= 0) {
                MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE003", (Object[])new Object[]{taxDtl.getAccountCode(), taxDtl.getAccount().getName()});
            }
            if ((commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID)).getIsStatisticalCommit() > 0) {
                isStatisticsUpdate = true;
            }
            if (!this.functionAreaActive) {
                functionalAreaID = 0L;
            }
            String postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionalAreaID, 0L);
            if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
                this.genTaxVoucherDtl("9A", fm_fundVoucher, taxDtl, isStatisticsUpdate, fundID, fundCenterID, commitItemID, postAddress, taxAmount);
            }
            if (this.updateProfileDtl.getIsCBActive() <= 0 || this.updateProfileDtl.getIsCBReduce() <= 0) continue;
            this.genTaxVoucherDtl("9B", fm_fundVoucher, taxDtl, isStatisticsUpdate, fundID, fundCenterID, commitItemID, postAddress, taxAmount);
        }
    }

    private void genTaxVoucherDtl(String postLedgerCode, FM_FundVoucher fm_fundVoucher, EFI_VoucherDtl_Entry taxDtl, boolean isStatisticsUpdate, Long fundID, Long fundCenterID, Long commitItemID, String postAddress, BigDecimal taxAmount) throws Throwable {
        EFM_AddressIndex addressIndex;
        EFM_BSDistribution bsDistribution;
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code(postLedgerCode).load();
        Long fmLedgerID = payLedger.getOID();
        String budgetLedgerCode = "9F";
        if (postLedgerCode.equals("9B")) {
            budgetLedgerCode = "9G";
        }
        if (fundID.compareTo(0L) > 0) {
            EFM_Fund fundDict = EFM_Fund.load((RichDocumentContext)this.getMidContext(), (Long)fundID);
            Long termValidityFromDate = fundDict.getValidStartDate();
            Long termValidityToDate = fundDict.getValidEndDate();
            if (ERPDateUtil.isBefore((Object)(this.postingDate + 1L), (Object)termValidityFromDate) || ERPDateUtil.isBefore((Object)termValidityToDate, (Object)this.postingDate)) {
                MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE004", (Object[])new Object[]{fundDict.getCode()});
            }
        }
        Long functionalAreaID = taxDtl.getFunctionalAreaID();
        String functionalAreaCode = taxDtl.getFunctionalAreaCode();
        if (!this.functionAreaActive) {
            functionalAreaID = 0L;
            functionalAreaCode = "";
        }
        if ((bsDistribution = EFM_BSDistribution.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FiscalYear(this.fiscalYear).load()) != null && bsDistribution.getIsCheckPost() > 0 && (addressIndex = EFM_AddressIndex.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FromFiscalYear(this.fiscalYear).FromLedgerID(fmLedgerID).FromObjectNumber(postAddress).ToLedgerCode(budgetLedgerCode).load()) == null) {
            MessageFacade.throwException((String)"FUNDVOUCHER4SALEINVOICE005", (Object[])new Object[]{this.fiscalYear, postLedgerCode, taxDtl.getFundCode(), taxDtl.getFundCenterCode(), taxDtl.getCommitmentItemCode(), functionalAreaCode});
        }
        EFM_FundVoucherDtl efm_fundVoucherDtl = fm_fundVoucher.newEFM_FundVoucherDtl();
        efm_fundVoucherDtl.setFinancialManagementAreaID(this.fmAreaID);
        efm_fundVoucherDtl.setMoneyType(AmountTypeEnum.AmountType_0100.getKey());
        efm_fundVoucherDtl.setLedgerID(fmLedgerID);
        efm_fundVoucherDtl.setFiscalYear(this.fiscalYear);
        efm_fundVoucherDtl.setPostingDate(this.postingDate);
        efm_fundVoucherDtl.setFiscalPeriod(this.fiscalPeriod);
        efm_fundVoucherDtl.setTransactionCurrencyMoney(taxAmount);
        efm_fundVoucherDtl.setFMAreaCurrencyMoney(taxAmount);
        efm_fundVoucherDtl.setCommitmentItemID(commitItemID);
        efm_fundVoucherDtl.setFundCenterID(fundCenterID);
        efm_fundVoucherDtl.setFundID(fundID);
        efm_fundVoucherDtl.setFunctionalAreaID(functionalAreaID);
        efm_fundVoucherDtl.setBusinessAreaID(taxDtl.getBusinessAreaID());
        efm_fundVoucherDtl.setProfitCenterID(taxDtl.getProfitCenterID());
        efm_fundVoucherDtl.setValueType(ValueTypeEnum.ValueType_54.getKey());
        efm_fundVoucherDtl.setCurrencyID(taxDtl.getCurrencyID());
        efm_fundVoucherDtl.setGLAccountID(taxDtl.getAccountID());
        efm_fundVoucherDtl.setReferDocSOID(taxDtl.getSrcSOID());
        efm_fundVoucherDtl.setReferDocDtlOID(taxDtl.getSrcOID());
        efm_fundVoucherDtl.setReferFIDocSOID(taxDtl.getSOID());
        efm_fundVoucherDtl.setReferFIDocDtlOID(taxDtl.getOID());
        efm_fundVoucherDtl.setPostAddress(postAddress);
        efm_fundVoucherDtl.setIsUpdate(0);
        efm_fundVoucherDtl.setVersionID(this.versionID);
        efm_fundVoucherDtl.setQuantity(taxDtl.getBaseQuantity());
        efm_fundVoucherDtl.setUnitID(taxDtl.getBaseUnitID());
        efm_fundVoucherDtl.setStatisticalIdentifier("Empty");
        if (isStatisticsUpdate) {
            efm_fundVoucherDtl.setStatisticalIdentifier("X");
        }
    }

    @Override
    public void feedBack(FI_Voucher fiVoucher) throws Throwable {
        BigDecimal direction = new BigDecimal("-1");
        int isReversalDocument = fiVoucher.getIsReversalDocument();
        if (isReversalDocument == 1) {
            direction = direction.negate();
        }
        List efiVoucherDtlEntries = fiVoucher.efi_voucherDtl_Entrys();
        for (EFI_VoucherDtl_Entry efiVoucherDtlEntry : efiVoucherDtlEntries) {
            if ("YCUM".equals(efiVoucherDtlEntry.getTransactionKey().getCode()) || "MWS".equals(efiVoucherDtlEntry.getTransactionKey().getCode())) continue;
            ESD_SaleOrderDtl saleOrderDtl = ESD_SaleOrderDtl.load((RichDocumentContext)this.getMidContext(), (Long)efiVoucherDtlEntry.getSaleOrderDtlOID());
            BigDecimal amount = efiVoucherDtlEntry.getMoney().multiply(BigDecimal.valueOf(efiVoucherDtlEntry.getDirection() * -1)).multiply(direction);
            this.feedBackSO(amount, saleOrderDtl);
        }
    }

    private void feedBackSO(BigDecimal amount, ESD_SaleOrderDtl saleOrderDtl) throws Throwable {
        Long fmLedgerID;
        EFM_Ledger payLedger;
        FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(saleOrderDtl.getSOID()).ReferItemOID(saleOrderDtl.getOID()).load();
        if (fmCommitVoucher == null) {
            return;
        }
        if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
            fmLedgerID = payLedger.getOID();
            this.feedBackSOVoucher(fmLedgerID, amount, saleOrderDtl, fmCommitVoucher);
            this.save((AbstractBillEntity)fmCommitVoucher);
        }
        if (this.updateProfileDtl.getIsCBActive() > 0 && this.updateProfileDtl.getIsCBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9B").load();
            fmLedgerID = payLedger.getOID();
            this.feedBackSOVoucher(fmLedgerID, amount, saleOrderDtl, fmCommitVoucher);
            this.save((AbstractBillEntity)fmCommitVoucher);
        }
    }

    private void feedBackSOVoucher(Long fmLedgerID, BigDecimal amount, ESD_SaleOrderDtl saleOrderDtl, FM_CommitVoucher fmCommitVoucher) throws Throwable {
        String currPostAddress = this.addressUtils.genAddress(saleOrderDtl.getFundID(), saleOrderDtl.getFundCenterID(), saleOrderDtl.getCommitmentItemID(), saleOrderDtl.getFunctionalAreaID(), 0L);
        EFM_CommitVoucherDtl commitVoucher = this.getCommitVoucher(fmLedgerID, saleOrderDtl);
        if (commitVoucher == null) {
            return;
        }
        if (this.isPeriodOrYear == Integer.parseInt("1")) {
            List efm_commitVoucherDtls = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
            if (efm_commitVoucherDtls != null) {
                for (EFM_CommitVoucherDtl deleteVoucher : efm_commitVoucherDtls) {
                    if (fmLedgerID.compareTo(deleteVoucher.getLedgerID()) != 0 || !deleteVoucher.getPostAddress().equals(currPostAddress)) continue;
                    amount = amount.add(deleteVoucher.getFMAreaCurrencyMoney());
                    fmCommitVoucher.deleteEFM_CommitVoucherDtl(deleteVoucher);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, amount.negate());
            }
        } else {
            this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, amount.negate());
        }
    }
}

