/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.avc.integration;

import com.bokesoft.erp.billentity.EFI_VoucherDtl_Entry;
import com.bokesoft.erp.billentity.EFI_VoucherHead;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_UpdateProfileDtl;
import com.bokesoft.erp.billentity.EMM_MaterialDocument;
import com.bokesoft.erp.billentity.EMM_PO_AccountAssignDtl;
import com.bokesoft.erp.billentity.EMM_PurchaseOrderDtl;
import com.bokesoft.erp.billentity.EMM_ServiceAccountAssignDtl;
import com.bokesoft.erp.billentity.EMM_ServiceItemDtl;
import com.bokesoft.erp.billentity.FI_Voucher;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_FundVoucher;
import com.bokesoft.erp.billentity.MM_MSEG;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.fm.avc.integration.FundVoucherFormula;
import com.bokesoft.erp.fm.enums.AmountTypeEnum;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class FundVoucher4MSEG
extends FundVoucherFormula {
    public FundVoucher4MSEG(RichDocumentContext _context) {
        super(_context);
    }

    public FundVoucher4MSEG(RichDocumentContext _context, EFM_FinancialManagementArea finManagementArea, Long versionID, int isPeriodOrYear, Long postingDate, int fiscalYear, int fiscalPeriod, EFM_UpdateProfileDtl updateProfileDtl) throws Throwable {
        super(_context, finManagementArea, versionID, isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
    }

    @Override
    public FM_FundVoucher genFundVoucher(FM_FundVoucher fm_fundVoucher, List<EFI_VoucherDtl_Entry> efi_voucherDtl_entries) throws Throwable {
        EFI_VoucherHead efiVoucherHead = EFI_VoucherHead.load((RichDocumentContext)this.getMidContext(), (Long)efi_voucherDtl_entries.get(0).getSOID());
        this.businessTransaction = "WA".equals(efiVoucherHead.getVoucherTypeCode()) ? "RFBU" : "RMWE";
        for (EFI_VoucherDtl_Entry dtlEntry : efi_voucherDtl_entries) {
            if (dtlEntry.getTransactionKeyCode().equals("WRX") || !"WA".equals(efiVoucherHead.getVoucherTypeCode()) && this.grirUpdate == 2 && !this.checkTransactionKeyCodeGR1(dtlEntry)) continue;
            boolean isStatisticsUpdate = this.updateProfileDtl.getIsStatisticsUpdate() > 0;
            Long fundID = dtlEntry.getFundID();
            Long fundCenterID = dtlEntry.getFundCenterID();
            Long commitItemID = dtlEntry.getCommitmentItemID();
            Long functionScopeID = dtlEntry.getFunctionalAreaID();
            if (fundCenterID.compareTo(0L) == 0 || commitItemID.compareTo(0L) == 0) continue;
            if (!this.functionAreaActive) {
                functionScopeID = 0L;
            }
            String postAddress = this.addressUtils.genAddress(fundID, fundCenterID, commitItemID, functionScopeID, 0L);
            EFM_CommitmentItemHead commitmentItem = EFM_CommitmentItemHead.load((RichDocumentContext)this.getMidContext(), (Long)commitItemID);
            if (commitmentItem.getIsStatisticalCommit() > 0) {
                isStatisticsUpdate = true;
            }
            this.genFundVoucherDtl(fm_fundVoucher, dtlEntry, isStatisticsUpdate, fundID, postAddress);
        }
        return fm_fundVoucher;
    }

    private void genFundVoucherDtl(FM_FundVoucher fm_fundVoucher, EFI_VoucherDtl_Entry dtlEntry, boolean isStatisticsUpdate, Long fundID, String postAddress) throws Throwable {
        if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
            this.genVoucherByPostLedger("9A", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
        }
        if (this.updateProfileDtl.getIsCBActive() > 0 && this.updateProfileDtl.getIsCBReduce() > 0) {
            this.genVoucherByPostLedger("9B", fundID, postAddress, dtlEntry, fm_fundVoucher, isStatisticsUpdate);
        }
    }

    @Override
    public void feedBack(FI_Voucher fiVoucher) throws Throwable {
        Long fmLedgerID;
        EFM_Ledger payLedger;
        if (this.grirUpdate == 2) {
            return;
        }
        Long srcSOID = fiVoucher.getSrcSOID();
        MM_MSEG mmMseg = MM_MSEG.load((RichDocumentContext)this.getMidContext(), (Long)srcSOID);
        List emm_materialDocuments = mmMseg.emm_materialDocuments();
        if (this.updateProfileDtl.getIsPBActive() > 0 && this.updateProfileDtl.getIsPBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
            fmLedgerID = payLedger.getOID();
            this.feedBackPO4MSEG(emm_materialDocuments, fmLedgerID);
        }
        if (this.updateProfileDtl.getIsCBActive() > 0 && this.updateProfileDtl.getIsCBReduce() > 0) {
            payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9B").load();
            fmLedgerID = payLedger.getOID();
            this.feedBackPO4MSEG(emm_materialDocuments, fmLedgerID);
        }
    }

    private void feedBackPO4MSEG(List<EMM_MaterialDocument> emm_materialDocuments, Long fmLedgerID) throws Throwable {
        HashMap<Long, BigDecimal> po2Quantity = new HashMap<Long, BigDecimal>();
        for (EMM_MaterialDocument materialDocument : emm_materialDocuments) {
            BigDecimal direction = new BigDecimal(materialDocument.getDirection());
            Long srcPOBillID = materialDocument.getSrcPurchaseOrderSOID();
            if (srcPOBillID.compareTo(0L) <= 0) continue;
            Long srcPOBillDtlID = materialDocument.getSrcPurchaseOrderDtlOID();
            EMM_PO_AccountAssignDtl accountAssignDtl = EMM_PO_AccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).POID(srcPOBillDtlID).load();
            FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(srcPOBillID).ReferItemOID(srcPOBillDtlID).Dtl_ReferAccountAssignItemOID(accountAssignDtl.getOID()).load();
            if (fmCommitVoucher == null) continue;
            String currPostAddress = this.addressUtils.genAddress(accountAssignDtl.getFundID(), accountAssignDtl.getFundCenterID(), accountAssignDtl.getCommitmentItemID(), accountAssignDtl.getFunctionalAreaID(), 0L);
            EFM_CommitVoucherDtl commitVoucher = this.getCommitVoucher(fmLedgerID, accountAssignDtl);
            if (commitVoucher == null) {
                return;
            }
            EMM_PurchaseOrderDtl purchaseOrderDtl = EMM_PurchaseOrderDtl.load((RichDocumentContext)this.getMidContext(), (Long)srcPOBillDtlID);
            if (purchaseOrderDtl.getItemCategoryCode().equalsIgnoreCase("D")) {
                BigDecimal netValue = BigDecimal.ZERO;
                if (purchaseOrderDtl.getIsGRInvoiceVerification() == 1 && purchaseOrderDtl.getIsServiceInvoiceVerification() == 1) {
                    EMM_ServiceItemDtl serviceConfirmationDtls = EMM_ServiceItemDtl.loader((RichDocumentContext)this.getMidContext()).OID(materialDocument.getSrcServiceConfirmDtlOID()).load();
                    netValue = serviceConfirmationDtls.getNetMoney().multiply(direction);
                } else if (purchaseOrderDtl.getIsGRInvoiceVerification() == 1 && purchaseOrderDtl.getIsServiceInvoiceVerification() == 0) {
                    EMM_ServiceAccountAssignDtl serviceAccountAssignDtl = EMM_ServiceAccountAssignDtl.loader((RichDocumentContext)this.getMidContext()).OID(materialDocument.getSrcServiceAccountAssignOID()).load();
                    netValue = serviceAccountAssignDtl.getNetMoney().multiply(direction);
                }
                if (this.isPeriodOrYear == Integer.parseInt("1")) {
                    List efm_commitVoucherDtls = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
                    if (efm_commitVoucherDtls != null && !efm_commitVoucherDtls.isEmpty()) {
                        ((EFM_CommitVoucherDtl)efm_commitVoucherDtls.get(0)).setFMAreaCurrencyMoney(((EFM_CommitVoucherDtl)efm_commitVoucherDtls.get(0)).getFMAreaCurrencyMoney().add(netValue.negate()));
                        ((EFM_CommitVoucherDtl)efm_commitVoucherDtls.get(0)).setTransactionCurrencyMoney(((EFM_CommitVoucherDtl)efm_commitVoucherDtls.get(0)).getTransactionCurrencyMoney().add(netValue.negate()));
                    } else {
                        this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, netValue.negate());
                    }
                    BigDecimal sendAmount = this.getSendAmount(srcPOBillID, srcPOBillDtlID, accountAssignDtl.getOID(), fmLedgerID, currPostAddress).add(netValue.negate());
                    if (sendAmount.compareTo(BigDecimal.ZERO) < 0) {
                        this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, sendAmount.negate());
                    }
                } else {
                    this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, netValue.negate());
                    BigDecimal sendAmount = this.getSendAmount(srcPOBillID, srcPOBillDtlID, accountAssignDtl.getOID(), fmLedgerID, currPostAddress).add(netValue.negate());
                    if (sendAmount.compareTo(BigDecimal.ZERO) < 0) {
                        this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, sendAmount.negate());
                    }
                }
            } else {
                BigDecimal price = purchaseOrderDtl.getPrice();
                BigDecimal quantity = materialDocument.getQuantity().multiply(direction);
                if (this.isPeriodOrYear == Integer.parseInt("1")) {
                    List efm_commitVoucherDtls = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
                    if (efm_commitVoucherDtls != null) {
                        for (EFM_CommitVoucherDtl deleteVoucher : efm_commitVoucherDtls) {
                            if (!deleteVoucher.getPostAddress().equals(currPostAddress) || !deleteVoucher.getLedgerID().equals(fmLedgerID)) continue;
                            fmCommitVoucher.deleteEFM_CommitVoucherDtl(deleteVoucher);
                        }
                    }
                    BigDecimal poQuantity = BigDecimal.ZERO;
                    poQuantity = po2Quantity.get(purchaseOrderDtl.getOID()) == null ? purchaseOrderDtl.getPushedGRQuantity().add(purchaseOrderDtl.getPushedGRQuantity103()).add(purchaseOrderDtl.getPushedGRQuantity107()) : (BigDecimal)po2Quantity.get(purchaseOrderDtl.getOID());
                    BigDecimal hasPushedQuantity = poQuantity.add(quantity);
                    BigDecimal hasPushedAmount = hasPushedQuantity.multiply(price);
                    if (hasPushedAmount.compareTo(BigDecimal.ZERO) != 0) {
                        this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, hasPushedAmount.negate());
                    }
                    if (hasPushedQuantity.compareTo(purchaseOrderDtl.getQuantity()) > 0) {
                        BigDecimal diffQuantity = hasPushedQuantity.subtract(purchaseOrderDtl.getQuantity());
                        BigDecimal sendAmount = diffQuantity.multiply(price);
                        this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, sendAmount.negate());
                    }
                    po2Quantity.put(purchaseOrderDtl.getOID(), hasPushedQuantity);
                } else {
                    BigDecimal amount0200 = quantity.multiply(price).negate();
                    this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0200.getKey(), commitVoucher, amount0200);
                    BigDecimal sendAmount = this.getSendAmount(srcPOBillID, srcPOBillDtlID, accountAssignDtl.getOID(), fmLedgerID, currPostAddress).add(amount0200);
                    if (sendAmount.compareTo(BigDecimal.ZERO) < 0) {
                        this.genCommitVoucherFromVoucher(fmCommitVoucher, AmountTypeEnum.AmountType_0500.getKey(), commitVoucher, sendAmount.negate());
                    }
                }
            }
            this.save((AbstractBillEntity)fmCommitVoucher);
        }
    }
}

