/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.avc.integration;

import com.bokesoft.erp.billentity.ECO_Version;
import com.bokesoft.erp.billentity.EFI_IntegrationRelation;
import com.bokesoft.erp.billentity.EFI_VoucherDtl_Entry;
import com.bokesoft.erp.billentity.EFM_FMAreaToCompanyCode;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_UpdateProfileDtl;
import com.bokesoft.erp.billentity.EFM_UpdateProfileHead;
import com.bokesoft.erp.billentity.FI_Voucher;
import com.bokesoft.erp.billentity.FM_FundVoucher;
import com.bokesoft.erp.fm.avc.integration.FundVoucher4ExpenseReimbursement;
import com.bokesoft.erp.fm.avc.integration.FundVoucher4MSEG;
import com.bokesoft.erp.fm.avc.integration.FundVoucher4PaymentOrder;
import com.bokesoft.erp.fm.avc.integration.FundVoucher4SaleInvoice;
import com.bokesoft.erp.fm.avc.integration.FundVoucher4StockInvoice;
import com.bokesoft.erp.fm.avc.integration.FundVoucherFormula;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;

public class FI2FundVoucher {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void genFundVoucher4FI(RichDocumentContext context, RichDocument document) throws Throwable {
        int bcsActiveYear;
        FI_Voucher fiVoucher = FI_Voucher.parseDocument((RichDocument)document);
        FundVoucherFormula fundVoucherFormula = null;
        Long companyCodeID = fiVoucher.getCompanyCodeID();
        EFM_FMAreaToCompanyCode areaToCompanyCode = EFM_FMAreaToCompanyCode.loader((RichDocumentContext)context).CompanyCodeID(companyCodeID).load();
        if (areaToCompanyCode == null || areaToCompanyCode.getFinancialManagementAreaID().compareTo(0L) <= 0) {
            return;
        }
        if (areaToCompanyCode.getIsUpdate() == 0) {
            return;
        }
        Long fmAreaID = areaToCompanyCode.getFinancialManagementAreaID();
        EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.load((RichDocumentContext)context, (Long)fmAreaID);
        Long updateProfileID = finManagementArea.getUpdateProfileID();
        if (updateProfileID.compareTo(0L) <= 0) {
            MessageFacade.throwException((String)"FI2FUNDVOUCHER001", (Object[])new Object[]{finManagementArea.getCode()});
        }
        if ((bcsActiveYear = finManagementArea.getBCSActiveYear()) <= 0) {
            MessageFacade.throwException((String)"FI2FUNDVOUCHER002");
        }
        if (bcsActiveYear > fiVoucher.getFiscalYear()) {
            return;
        }
        EFM_UpdateProfileHead updateProfile = EFM_UpdateProfileHead.load((RichDocumentContext)context, (Long)updateProfileID);
        int isPeriodOrYear = updateProfile.getIsPeriodOrYear();
        EFM_UpdateProfileDtl updateProfileDtl = EFM_UpdateProfileDtl.loader((RichDocumentContext)context).SOID(updateProfileID).ValueType(ValueTypeEnum.ValueType_54.getKey()).load();
        if (updateProfileDtl.getIsBudgetAllocation() == 0) {
            return;
        }
        Long postingDate = fiVoucher.getPostingDate();
        int fiscalYear = fiVoucher.getFiscalYear();
        int fiscalPeriod = fiVoucher.getFiscalPeriod();
        ECO_Version actualVersion = ECO_Version.loader((RichDocumentContext)context).Code("0").load();
        if (fiVoucher.getIsGenByBusiness() > 0) {
            String SrcFormKey = fiVoucher.getSrcFormKey();
            if (SrcFormKey.equals("MM_MSEG")) {
                fundVoucherFormula = new FundVoucher4MSEG(context, finManagementArea, actualVersion.getOID(), isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
            } else if (SrcFormKey.equals("MM_IncomingInvoice")) {
                fundVoucherFormula = new FundVoucher4StockInvoice(context, finManagementArea, actualVersion.getOID(), isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
            } else if (SrcFormKey.equals("SD_SaleBilling")) {
                fundVoucherFormula = new FundVoucher4SaleInvoice(context, finManagementArea, actualVersion.getOID(), isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
                Long salesOrderID = ((EFI_VoucherDtl_Entry)fiVoucher.efi_voucherDtl_Entrys().get(0)).getSaleOrderSOID();
                if (salesOrderID.compareTo(0L) <= 0) {
                    return;
                }
            } else if (SrcFormKey.equals("AM_DepreciationPostingRun")) {
                fundVoucherFormula = new FundVoucherFormula(context, finManagementArea, actualVersion.getOID(), isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
            } else if (SrcFormKey.equals("ECS_ExpenseReimbursement")) {
                fundVoucherFormula = new FundVoucher4ExpenseReimbursement(context, finManagementArea, actualVersion.getOID(), isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
            } else {
                if (!SrcFormKey.equals("FI_PaymentOrder")) return;
                fundVoucherFormula = new FundVoucher4PaymentOrder(context, finManagementArea, actualVersion.getOID(), isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
            }
        } else {
            fundVoucherFormula = new FundVoucherFormula(context, finManagementArea, actualVersion.getOID(), isPeriodOrYear, postingDate, fiscalYear, fiscalPeriod, updateProfileDtl);
        }
        fundVoucherFormula.feedBack(fiVoucher);
        fundVoucherFormula.genFundVoucher(fiVoucher);
    }

    public static void deleteFundVoucher4FI(RichDocumentContext context, RichDocument document) throws Throwable {
        FI_Voucher fiVoucher = FI_Voucher.parseDocument((RichDocument)document);
        FundVoucherFormula fundVoucherFormula = new FundVoucherFormula(context);
        FM_FundVoucher fundVoucher = FM_FundVoucher.loader((RichDocumentContext)context).ReferFIDocOID(fiVoucher.getOID()).load();
        if (fundVoucher != null) {
            fundVoucherFormula.feedBack(fiVoucher);
        }
        fundVoucherFormula.deleteFundVoucher(fiVoucher);
        EFI_IntegrationRelation.loader((RichDocumentContext)context).SrcFormKey("FI_Voucher").SrcSOID(Long.valueOf(document.getOID())).TargetFormKey("FM_FundVoucher").delete();
    }
}

