/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.avc.integration;

import com.bokesoft.erp.billentity.BusinessTransaction;
import com.bokesoft.erp.billentity.ECO_Version;
import com.bokesoft.erp.billentity.EFM_ActiveFM;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_CommitVoucherDtl;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_EarmarkedFundVoucherDtl;
import com.bokesoft.erp.billentity.EFM_FMAreaToCompanyCode;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Fund;
import com.bokesoft.erp.billentity.EFM_Ledger;
import com.bokesoft.erp.billentity.EFM_PostLedgerPeriod;
import com.bokesoft.erp.billentity.FM_CommitVoucher;
import com.bokesoft.erp.billentity.FM_EarmarkedFundVoucher;
import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.bcs.AddressUtils;
import com.bokesoft.erp.fm.enums.AmountTypeEnum;
import com.bokesoft.erp.fm.enums.FYCStatusEnum;
import com.bokesoft.erp.fm.enums.ReferDocTypeEnum;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import java.math.BigDecimal;
import java.util.List;

public class CommonCommitVoucher4Other
extends EntityContextAction {
    private Long fundID;
    private Long fundCenterID;
    private Long commitItemID;
    private Long functionAreaID;

    public CommonCommitVoucher4Other(RichDocumentContext _context) {
        super(_context);
    }

    public CommonCommitVoucher4Other(RichDocumentContext _context, Long fundID, Long fundCenterID, Long commitItemID, Long functionAreaID) {
        super(_context);
        this.fundID = fundID;
        this.fundCenterID = fundCenterID;
        this.commitItemID = commitItemID;
        this.functionAreaID = functionAreaID;
    }

    public Long genCommitVoucher(Long dtlOID, String postAddress, Long fmPostDate, int fiscalYear, int fiscalPeriod, BigDecimal amount, boolean isStatisticUpdate, String bussMaterCode, Long companyCodeID, Long fmAreaID, String documentNumber, String srcFormKey, Long srcBillOID, Long srcBillDtlOID) throws Throwable {
        FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(Long.valueOf(this.getDocument().getOID())).ReferItemOID(dtlOID).load();
        if (fmCommitVoucher != null) {
            fmCommitVoucher.document.evaluate("Macro_MidDelete()", "\u5220\u9664\u627f\u8bfa\u8868\u5355");
        }
        FM_CommitVoucher newFmCommitVoucher = (FM_CommitVoucher)this.newBillEntity(FM_CommitVoucher.class);
        newFmCommitVoucher.setReferDocType(ReferDocTypeEnum.getByformKey(this.getMidContext().getFormKey()).getKey());
        newFmCommitVoucher.setReferDocSOID(Long.valueOf(this.getDocument().getOID()));
        newFmCommitVoucher.setReferDocNo(documentNumber);
        newFmCommitVoucher.setReferItemOID(dtlOID);
        newFmCommitVoucher.setReferAccountAssignItemOID(Long.valueOf(0L));
        EFM_CommitVoucherDtl commitVoucher = newFmCommitVoucher.newEFM_CommitVoucherDtl();
        commitVoucher.setReferDocType(ReferDocTypeEnum.getByformKey(this.getMidContext().getFormKey()).getKey());
        commitVoucher.setReferDocSOID(Long.valueOf(this.getDocument().getOID()));
        commitVoucher.setReferDocNo(documentNumber);
        commitVoucher.setReferItemOID(dtlOID);
        commitVoucher.setReferAccountAssignItemOID(Long.valueOf(0L));
        commitVoucher.setReferTrade("COMMON");
        commitVoucher.setMoneyType(AmountTypeEnum.AmountType_0100.getKey());
        commitVoucher.setSrcSOID(Long.valueOf(this.getDocument().getOID()));
        commitVoucher.setSrcOID(dtlOID);
        commitVoucher.setSrcFormKey(this.getDocument().getMetaForm().getKey());
        commitVoucher.setPostingDate(fmPostDate);
        commitVoucher.setFiscalYear(fiscalYear);
        commitVoucher.setFiscalPeriod(fiscalPeriod);
        Long versionID = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load().getOID();
        commitVoucher.setVersionID(versionID);
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
        Long fmLedgerID = payLedger.getOID();
        commitVoucher.setLedgerID(fmLedgerID);
        commitVoucher.setCommitVoucherCarryoverStatus(FYCStatusEnum.FYCStatus_00.getKey());
        commitVoucher.setTransactionCurrencyMoney(amount);
        commitVoucher.setFMAreaCurrencyMoney(amount);
        commitVoucher.setFundCenterID(this.fundCenterID);
        commitVoucher.setFundID(this.fundID);
        commitVoucher.setCommitmentItemID(this.commitItemID);
        commitVoucher.setFunctionalAreaID(this.functionAreaID);
        commitVoucher.setPostAddress(postAddress);
        commitVoucher.setValueType(ValueTypeEnum.getByformKey(this.getMidContext().getFormKey()).getKey());
        BusinessTransaction progress = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code(bussMaterCode).load();
        commitVoucher.setBusinessTransactionID(progress.getOID());
        commitVoucher.setCompanyCodeID(companyCodeID);
        commitVoucher.setCurrencyID(Long.valueOf(0L));
        commitVoucher.setMaterialID(Long.valueOf(0L));
        commitVoucher.setShortText("");
        commitVoucher.setGLAccountID(Long.valueOf(0L));
        commitVoucher.setFinancialManagementAreaID(fmAreaID);
        commitVoucher.setVendorID(Long.valueOf(0L));
        commitVoucher.setQuantity(BigDecimal.ZERO);
        commitVoucher.setStatisticalIdentifier("Empty");
        commitVoucher.setIsLatest(1);
        if (!"".equals(srcFormKey)) {
            commitVoucher.setPreDocType(ReferDocTypeEnum.getByformKey(srcFormKey).getKey());
        }
        commitVoucher.setPreDocSOID(srcBillOID);
        commitVoucher.setPreItemOID(srcBillDtlOID);
        newFmCommitVoucher.setTotalFMAreaCurrencyMoney(newFmCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount));
        newFmCommitVoucher.setTotalTransactionCurrencyMoney(newFmCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount));
        commitVoucher.setFinishFlag("Empty");
        if (isStatisticUpdate) {
            commitVoucher.setStatisticalIdentifier("X");
        }
        this.save((AbstractBillEntity)newFmCommitVoucher);
        return newFmCommitVoucher.getOID();
    }

    public Long feedBack(Long dtlOID, String postAddress, Long fmPostDate, int fiscalYear, int fiscalPeriod, BigDecimal amount, boolean isStatisticUpdate, String bussMaterCode, Long companyCodeID, Long fmAreaID, Long srcBillOID, Long srcBillDtlOID) throws Throwable {
        EFM_CommitVoucherDtl efmCommitVoucher;
        FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(srcBillOID).ReferItemOID(srcBillDtlOID).load();
        if (fmCommitVoucher == null) {
            return 0L;
        }
        if (fmCommitVoucher.getTotalFMAreaCurrencyMoney().equals(BigDecimal.ZERO)) {
            return 0L;
        }
        if (fmCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount).compareTo(BigDecimal.ZERO) < 0) {
            amount = fmCommitVoucher.getTotalFMAreaCurrencyMoney().negate();
        }
        if ((efmCommitVoucher = (EFM_CommitVoucherDtl)fmCommitVoucher.efm_commitVoucherDtls().get(0)) == null) {
            return 0L;
        }
        EFM_CommitVoucherDtl commitVoucher = fmCommitVoucher.newEFM_CommitVoucherDtl();
        commitVoucher.setReferDocType(efmCommitVoucher.getReferDocType());
        commitVoucher.setReferDocSOID(srcBillOID);
        commitVoucher.setReferDocNo(efmCommitVoucher.getReferDocNo());
        commitVoucher.setReferItemOID(srcBillDtlOID);
        commitVoucher.setReferAccountAssignItemOID(Long.valueOf(0L));
        commitVoucher.setReferTrade("COMMON");
        commitVoucher.setMoneyType(AmountTypeEnum.AmountType_0200.getKey());
        commitVoucher.setSrcSOID(srcBillOID);
        commitVoucher.setSrcOID(srcBillDtlOID);
        commitVoucher.setSrcFormKey(efmCommitVoucher.getSrcFormKey());
        commitVoucher.setPostingDate(fmPostDate);
        commitVoucher.setFiscalYear(fiscalYear);
        commitVoucher.setFiscalPeriod(fiscalPeriod);
        Long versionID = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load().getOID();
        commitVoucher.setVersionID(versionID);
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
        Long fmLedgerID = payLedger.getOID();
        commitVoucher.setLedgerID(fmLedgerID);
        commitVoucher.setCommitVoucherCarryoverStatus(FYCStatusEnum.FYCStatus_00.getKey());
        commitVoucher.setTransactionCurrencyMoney(amount);
        commitVoucher.setFMAreaCurrencyMoney(amount);
        commitVoucher.setFundCenterID(this.fundCenterID);
        commitVoucher.setFundID(this.fundID);
        commitVoucher.setCommitmentItemID(this.commitItemID);
        commitVoucher.setFunctionalAreaID(this.functionAreaID);
        commitVoucher.setPostAddress(postAddress);
        commitVoucher.setValueType(efmCommitVoucher.getValueType());
        BusinessTransaction progress = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code(bussMaterCode).load();
        commitVoucher.setBusinessTransactionID(progress.getOID());
        commitVoucher.setCompanyCodeID(companyCodeID);
        commitVoucher.setCurrencyID(Long.valueOf(0L));
        commitVoucher.setMaterialID(Long.valueOf(0L));
        commitVoucher.setShortText("");
        commitVoucher.setGLAccountID(Long.valueOf(0L));
        commitVoucher.setFinancialManagementAreaID(fmAreaID);
        commitVoucher.setVendorID(Long.valueOf(0L));
        commitVoucher.setQuantity(BigDecimal.ZERO);
        commitVoucher.setStatisticalIdentifier("Empty");
        commitVoucher.setPreDocType(efmCommitVoucher.getPreDocType());
        commitVoucher.setPreDocSOID(efmCommitVoucher.getPreDocSOID());
        commitVoucher.setPreItemOID(efmCommitVoucher.getPreItemOID());
        commitVoucher.setFromDocType(ReferDocTypeEnum.getByformKey(this.getMidContext().getFormKey()).getKey());
        commitVoucher.setFromDocSOID(Long.valueOf(this.getDocument().getOID()));
        commitVoucher.setFromItemOID(dtlOID);
        commitVoucher.setFinishFlag("F");
        if (isStatisticUpdate) {
            commitVoucher.setStatisticalIdentifier("X");
        }
        this.save((AbstractBillEntity)fmCommitVoucher);
        return fmCommitVoucher.getOID();
    }

    public boolean checkBeforeGenCommitVoucher(Long fmPostDate, BigDecimal amount, EFM_CommitmentItemHead commitmentItem, String postAddress, int fiscalYear, int fiscalPeriod, Long fmAreaID, EFM_FMAreaToCompanyCode areaToCompanyCode) throws Throwable {
        EFM_AddressIndex addressIndex;
        EFM_BSDistribution bsDistribution;
        if (this.fundCenterID.equals(0L) || this.commitItemID.equals(0L) || amount.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        EFM_ActiveFM activeFM = EFM_ActiveFM.loader((RichDocumentContext)this._context).load();
        if (activeFM == null || activeFM.getIsActive() == 0) {
            return false;
        }
        if (fmAreaID.equals(0L)) {
            MessageFacade.throwException((String)"COMMONCOMMITVOUCHER4OTHER002");
        }
        if (areaToCompanyCode.getIsUpdate() == 0) {
            return false;
        }
        EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.load((RichDocumentContext)this._context, (Long)fmAreaID);
        int bcsActiveYear = finManagementArea.getBCSActiveYear();
        if (bcsActiveYear <= 0) {
            MessageFacade.throwException((String)"COMMONCOMMITVOUCHER4OTHER003");
        }
        if (bcsActiveYear > fiscalYear) {
            return false;
        }
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this._context).Code("9A").load();
        Long fmLedgerID = payLedger.getOID();
        EFM_PostLedgerPeriod postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this._context).FinancialManagementAreaID(fmAreaID).ValueType(ValueTypeEnum.getByformKey(this._context.getFormKey()).getKey()).FiscalYear(fiscalYear).FromFiscalPeriod("<=", fiscalPeriod).ToFiscalPeriod(">=", fiscalPeriod).LedgerID(fmLedgerID).load();
        if (postLedgerPeriod == null) {
            postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this._context).FinancialManagementAreaID(fmAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(fiscalYear).FromFiscalPeriod("<=", fiscalPeriod).ToFiscalPeriod(">=", fiscalPeriod).LedgerID(fmLedgerID).load();
        }
        if (postLedgerPeriod == null) {
            MessageFacade.throwException((String)"COMMONCOMMITVOUCHER4OTHER004");
        }
        if (this.fundID.compareTo(0L) > 0) {
            EFM_Fund fundDict = EFM_Fund.load((RichDocumentContext)this._context, (Long)this.fundID);
            Long termValidityFromDate = fundDict.getValidStartDate();
            Long termValidityToDate = fundDict.getValidEndDate();
            if (ERPDateUtil.isBefore((Object)fmPostDate, (Object)termValidityFromDate) || ERPDateUtil.isBefore((Object)termValidityToDate, (Object)fmPostDate)) {
                MessageFacade.throwException((String)"COMMONCOMMITVOUCHER4OTHER005");
            }
        }
        if ((bsDistribution = EFM_BSDistribution.loader((RichDocumentContext)this._context).FinancialManagementAreaID(fmAreaID).FiscalYear(fiscalYear).load()) != null && bsDistribution.getIsCheckPost() > 0 && (addressIndex = EFM_AddressIndex.loader((RichDocumentContext)this._context).FinancialManagementAreaID(fmAreaID).FromFiscalYear(fiscalYear).FromLedgerID(fmLedgerID).FromObjectNumber(postAddress).ToLedgerCode("9F").load()) == null) {
            MessageFacade.throwException((String)"COMMONCOMMITVOUCHER4OTHER006");
        }
        return commitmentItem.getFinancialBusiness() == 30;
    }

    public void deleteFMCommitVoucherOfFeedBack(Long dtlOID, Long srcBillOID, Long srcBillDtlOID) throws Throwable {
        FM_CommitVoucher fmCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this._context).ReferDocSOID(srcBillOID).ReferItemOID(srcBillDtlOID).load();
        if (fmCommitVoucher != null) {
            EFM_CommitVoucherDtl commitVoucher = (EFM_CommitVoucherDtl)fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0100.getKey()).get(0);
            AddressUtils addressUtils = new AddressUtils(this._context);
            String currPostAddress = addressUtils.genAddress(commitVoucher.getFundID(), commitVoucher.getFundCenterID(), commitVoucher.getCommitmentItemID(), commitVoucher.getFunctionalAreaID(), 0L);
            List efmCommitVouchers = fmCommitVoucher.efm_commitVoucherDtls("MoneyType", (Object)AmountTypeEnum.AmountType_0200.getKey());
            if (efmCommitVouchers != null) {
                for (EFM_CommitVoucherDtl deleteVoucher : efmCommitVouchers) {
                    if (!deleteVoucher.getPostAddress().equals(currPostAddress) || !deleteVoucher.getFromDocSOID().equals(this.getDocument().getOID()) || !deleteVoucher.getFromItemOID().equals(dtlOID)) continue;
                    fmCommitVoucher.setTotalFMAreaCurrencyMoney(fmCommitVoucher.getTotalFMAreaCurrencyMoney().add(deleteVoucher.getFMAreaCurrencyMoney().negate()));
                    fmCommitVoucher.setTotalFMAreaCurrencyMoney(fmCommitVoucher.getTotalFMAreaCurrencyMoney().add(deleteVoucher.getTransactionCurrencyMoney().negate()));
                    fmCommitVoucher.deleteEFM_CommitVoucherDtl(deleteVoucher);
                }
            }
            this.save((AbstractBillEntity)fmCommitVoucher);
        }
    }

    public void genEFCommitVoucher(Long docDtlOID, String postAddress, Long fmPostDate, int fiscalYear, int fiscalPeriod, BigDecimal amount, boolean isStatisticsUpdate, Long companyCodeID, Long fmAreaID, FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl, Long srcBillOID, Long srcBillDtlOID) throws Throwable {
        FM_CommitVoucher nowFMCommitVoucher;
        FM_CommitVoucher srcFMCommitVoucher;
        List efm_commitVouchers0200;
        FM_CommitVoucher efCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(earmarkedFundVoucherDtl.getOID()).load();
        if (efCommitVoucher == null || efCommitVoucher.efm_commitVoucherDtls().get(0) == null) {
            return;
        }
        if (efCommitVoucher.getTotalFMAreaCurrencyMoney().add(amount).compareTo(BigDecimal.ZERO) < 0) {
            amount = efCommitVoucher.getTotalFMAreaCurrencyMoney().negate();
        }
        if ((efm_commitVouchers0200 = EFM_CommitVoucherDtl.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(earmarkedFundVoucherDtl.getOID()).MoneyType(AmountTypeEnum.AmountType_0200.getKey()).loadList()) != null && !efm_commitVouchers0200.isEmpty()) {
            for (EFM_CommitVoucherDtl commitVoucher : efm_commitVouchers0200) {
                efCommitVoucher.deleteEFM_CommitVoucherDtl(commitVoucher);
            }
        }
        BigDecimal srcFmacAmount = BigDecimal.ZERO;
        BigDecimal nowFmacAmount = BigDecimal.ZERO;
        if (srcBillOID != 0L && srcBillDtlOID != 0L && (srcFMCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(srcBillOID).ReferItemOID(srcBillDtlOID).load()) != null) {
            srcFmacAmount = srcFMCommitVoucher.getTotalFMAreaCurrencyMoney();
        }
        if (docDtlOID != 0L && (nowFMCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)this.getMidContext()).ReferDocSOID(Long.valueOf(this.getDocument().getOID())).ReferItemOID(docDtlOID).load()) != null) {
            nowFmacAmount = nowFMCommitVoucher.getTotalFMAreaCurrencyMoney();
        }
        if (amount.compareTo(srcFmacAmount) < 0) {
            return;
        }
        BigDecimal nowReduceAmount = nowFmacAmount.compareTo(srcFmacAmount) > 0 ? amount.subtract(nowFmacAmount) : amount.subtract(srcFmacAmount);
        BigDecimal totalAmount = earmarkedFundVoucherDtl.getTotalMoney();
        BigDecimal oldReducedAmount = earmarkedFundVoucherDtl.getReducedMoney();
        BigDecimal allReduceAmount = oldReducedAmount.add(nowReduceAmount);
        BigDecimal nowUnClearMoney = totalAmount.subtract(allReduceAmount);
        this.createEFCommitVoucher(postAddress, fmPostDate, fiscalYear, fiscalPeriod, allReduceAmount, companyCodeID, fmAreaID, earmarkedFundVoucher, earmarkedFundVoucherDtl, efCommitVoucher, (EFM_CommitVoucherDtl)efCommitVoucher.efm_commitVoucherDtls().get(0), isStatisticsUpdate);
        earmarkedFundVoucherDtl.setUnclearMoney(nowUnClearMoney);
        earmarkedFundVoucherDtl.setReducedMoney(allReduceAmount);
        this.directSave((AbstractBillEntity)earmarkedFundVoucher);
        this.save((AbstractBillEntity)efCommitVoucher);
    }

    private void createEFCommitVoucher(String postAddress, Long fmPostDate, int fiscalYear, int fiscalPeriod, BigDecimal amount, Long companyCodeID, Long fmAreaID, FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl, FM_CommitVoucher fmCommitVoucher, EFM_CommitVoucherDtl efmCommitVoucher, Boolean isStatisticUpdate) throws Throwable {
        EFM_CommitVoucherDtl commitVoucher = fmCommitVoucher.newEFM_CommitVoucherDtl();
        commitVoucher.setReferDocType(efmCommitVoucher.getReferDocType());
        commitVoucher.setReferDocSOID(earmarkedFundVoucher.getOID());
        commitVoucher.setReferDocNo(efmCommitVoucher.getReferDocNo());
        commitVoucher.setReferItemOID(earmarkedFundVoucherDtl.getOID());
        commitVoucher.setReferAccountAssignItemOID(Long.valueOf(0L));
        commitVoucher.setReferTrade("FMRES");
        commitVoucher.setMoneyType(AmountTypeEnum.AmountType_0200.getKey());
        commitVoucher.setSrcSOID(earmarkedFundVoucher.getOID());
        commitVoucher.setSrcOID(earmarkedFundVoucherDtl.getOID());
        commitVoucher.setSrcFormKey(efmCommitVoucher.getSrcFormKey());
        commitVoucher.setPostingDate(fmPostDate);
        commitVoucher.setFiscalYear(fiscalYear);
        commitVoucher.setFiscalPeriod(fiscalPeriod);
        Long versionID = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load().getOID();
        commitVoucher.setVersionID(versionID);
        EFM_Ledger payLedger = EFM_Ledger.loader((RichDocumentContext)this.getMidContext()).Code("9A").load();
        Long fmLedgerID = payLedger.getOID();
        commitVoucher.setLedgerID(fmLedgerID);
        commitVoucher.setCommitVoucherCarryoverStatus(FYCStatusEnum.FYCStatus_00.getKey());
        commitVoucher.setTransactionCurrencyMoney(amount.negate());
        commitVoucher.setFMAreaCurrencyMoney(amount.negate());
        commitVoucher.setFundCenterID(this.fundCenterID);
        commitVoucher.setFundID(this.fundID);
        commitVoucher.setCommitmentItemID(this.commitItemID);
        commitVoucher.setFunctionalAreaID(this.functionAreaID);
        commitVoucher.setPostAddress(postAddress);
        commitVoucher.setValueType(efmCommitVoucher.getValueType());
        BusinessTransaction progress_COMMON = BusinessTransaction.loader((RichDocumentContext)this.getMidContext()).Code("COMMON").load();
        commitVoucher.setBusinessTransactionID(progress_COMMON.getOID());
        commitVoucher.setReferTrade("FMRES");
        commitVoucher.setCompanyCodeID(companyCodeID);
        commitVoucher.setCurrencyID(Long.valueOf(0L));
        commitVoucher.setMaterialID(Long.valueOf(0L));
        commitVoucher.setShortText("");
        commitVoucher.setGLAccountID(Long.valueOf(0L));
        commitVoucher.setFinancialManagementAreaID(fmAreaID);
        commitVoucher.setVendorID(Long.valueOf(0L));
        commitVoucher.setQuantity(BigDecimal.ZERO);
        commitVoucher.setStatisticalIdentifier("Empty");
        commitVoucher.setPreDocType(efmCommitVoucher.getPreDocType());
        commitVoucher.setPreDocSOID(efmCommitVoucher.getPreDocSOID());
        commitVoucher.setPreItemOID(efmCommitVoucher.getPreItemOID());
        commitVoucher.setFinishFlag("Empty");
        if (isStatisticUpdate.booleanValue()) {
            commitVoucher.setStatisticalIdentifier("X");
        }
    }

    public void deleteEFCommitVoucher(RichDocumentContext context, FM_EarmarkedFundVoucher earmarkedFundVoucher, EFM_EarmarkedFundVoucherDtl earmarkedFundVoucherDtl, BigDecimal nowFmacAmount) throws Throwable {
        FM_CommitVoucher efCommitVoucher = FM_CommitVoucher.loader((RichDocumentContext)context).ReferDocSOID(earmarkedFundVoucher.getOID()).ReferItemOID(earmarkedFundVoucherDtl.getOID()).load();
        List efmCommitVouchers = efCommitVoucher.efm_commitVoucherDtls();
        if (efmCommitVouchers == null || efmCommitVouchers.size() == 0) {
            return;
        }
        for (EFM_CommitVoucherDtl commitVoucher : efmCommitVouchers) {
            if (!commitVoucher.getMoneyType().equals(AmountTypeEnum.AmountType_0200.getKey())) continue;
            BigDecimal restAmount = commitVoucher.getFMAreaCurrencyMoney().add(nowFmacAmount);
            if (restAmount.compareTo(BigDecimal.ZERO) == 0) {
                efCommitVoucher.deleteEFM_CommitVoucherDtl(commitVoucher);
                continue;
            }
            commitVoucher.setFMAreaCurrencyMoney(restAmount);
            commitVoucher.setTransactionCurrencyMoney(restAmount);
        }
        BigDecimal oldReducedAmount = earmarkedFundVoucherDtl.getReducedMoney();
        BigDecimal allReduceAmount = oldReducedAmount.subtract(nowFmacAmount);
        BigDecimal nowUnClearMoney = earmarkedFundVoucherDtl.getTotalMoney().subtract(allReduceAmount);
        earmarkedFundVoucherDtl.setUnclearMoney(nowUnClearMoney);
        earmarkedFundVoucherDtl.setReducedMoney(allReduceAmount);
        this.save((AbstractBillEntity)earmarkedFundVoucher);
    }
}

