/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.fm.avc.entity;

import com.bokesoft.erp.basis.date.PeriodFormula;
import com.bokesoft.erp.billentity.ECO_Version;
import com.bokesoft.erp.billentity.EFM_AddressIndex;
import com.bokesoft.erp.billentity.EFM_BSDistribution;
import com.bokesoft.erp.billentity.EFM_CommitmentItemHead;
import com.bokesoft.erp.billentity.EFM_CoverUpdateProfile;
import com.bokesoft.erp.billentity.EFM_FinancialManagementArea;
import com.bokesoft.erp.billentity.EFM_Fund;
import com.bokesoft.erp.billentity.EFM_PostLedgerPeriod;
import com.bokesoft.erp.billentity.EFM_UpdateProfileDtl;
import com.bokesoft.erp.billentity.EFM_UpdateProfileHead;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.fm.enums.ValueTypeEnum;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import java.math.BigDecimal;

public class AvcArgument
extends EntityContextAction {
    private Long companyCodeID;
    private Long fmAreaID;
    private int fiscalYear;
    private int fiscalPeriod;
    private Long fmPostDate;
    private String postAddress;
    private int isPeriodOrYear;
    private Long fmLedgerID;
    private boolean isStatisticsUpdate;
    private Long updateProfileID;
    private int paymentBudgetValue;
    private int commitBudgetValue;
    private boolean isPBUpdate = false;
    private boolean isCBUpdate = false;
    private String PBDateMethod;
    private String CBDateMethod;
    private boolean isBudgetAllocation = true;
    private PeriodFormula periodFormula = null;
    private int bcsActiveYear;
    private String valueType;
    private Long versionID;
    private BigDecimal totalAmount;
    private boolean hasUpdateTotalAmount = false;
    private boolean IsSDUpdate = true;

    public AvcArgument(RichDocumentContext _context) {
        super(_context);
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Long getVersionID() {
        return this.versionID;
    }

    public void setVersionID(Long versionID) {
        this.versionID = versionID;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public int getBcsActiveYear() {
        return this.bcsActiveYear;
    }

    public void setBcsActiveYear(int bcsActiveYear) {
        this.bcsActiveYear = bcsActiveYear;
    }

    public Long getCompanyCodeID() {
        return this.companyCodeID;
    }

    public void setCompanyCodeID(Long companyCodeID) {
        this.companyCodeID = companyCodeID;
    }

    public PeriodFormula getPeriodFormula() {
        return this.periodFormula;
    }

    public void setPeriodFormula(PeriodFormula periodFormula) {
        this.periodFormula = periodFormula;
    }

    public boolean isBudgetAllocation() {
        return this.isBudgetAllocation;
    }

    public void setBudgetAllocation(boolean budgetAllocation) {
        this.isBudgetAllocation = budgetAllocation;
    }

    public String getPBDateMethod() {
        return this.PBDateMethod;
    }

    public void setPBDateMethod(String PBDateMethod) {
        this.PBDateMethod = PBDateMethod;
    }

    public String getCBDateMethod() {
        return this.CBDateMethod;
    }

    public void setCBDateMethod(String CBDateMethod) {
        this.CBDateMethod = CBDateMethod;
    }

    public boolean isPBUpdate() {
        return this.isPBUpdate;
    }

    public void setPBUpdate(boolean PBUpdate) {
        this.isPBUpdate = PBUpdate;
    }

    public boolean isCBUpdate() {
        return this.isCBUpdate;
    }

    public void setCBUpdate(boolean CBUpdate) {
        this.isCBUpdate = CBUpdate;
    }

    public Long getFmAreaID() {
        return this.fmAreaID;
    }

    public void setFmAreaID(Long fmAreaID) {
        this.fmAreaID = fmAreaID;
    }

    public int getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(int fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public int getFiscalPeriod() {
        return this.fiscalPeriod;
    }

    public void setFiscalPeriod(int fiscalPeriod) {
        this.fiscalPeriod = fiscalPeriod;
    }

    public Long getFmPostDate() {
        return this.fmPostDate;
    }

    public void setFmPostDate(Long fmPostDate) throws Throwable {
        this.fmPostDate = fmPostDate;
        if (this.periodFormula == null) {
            this.periodFormula = new PeriodFormula(this.getMidContext());
        }
        int fiscalYear = this.periodFormula.getYearByCompanyCodeDate(this.companyCodeID, fmPostDate);
        int fiscalPeriod = this.periodFormula.getPeriodByCompanyCodeDate(this.companyCodeID, fmPostDate);
        this.setFiscalYear(fiscalYear);
        this.setFiscalPeriod(fiscalPeriod);
    }

    public String getPostAddress() {
        return this.postAddress;
    }

    public void setPostAddress(String postAddress) {
        this.postAddress = postAddress;
    }

    public int getIsPeriodOrYear() {
        return this.isPeriodOrYear;
    }

    public void setIsPeriodOrYear(int isPeriodOrYear) {
        this.isPeriodOrYear = isPeriodOrYear;
    }

    public Long getFmLedgerID() {
        return this.fmLedgerID;
    }

    public void setFmLedgerID(Long fmLedgerID) {
        this.fmLedgerID = fmLedgerID;
    }

    public boolean isStatisticsUpdate() {
        return this.isStatisticsUpdate;
    }

    public void setStatisticsUpdate(boolean statisticsUpdate) {
        this.isStatisticsUpdate = statisticsUpdate;
    }

    public void setStatisticsUpdate(Long commitItemID) throws Throwable {
        EFM_CommitmentItemHead commitmentItem;
        if (commitItemID.equals(0L)) {
            this.isStatisticsUpdate = false;
        }
        this.isStatisticsUpdate = (commitmentItem = EFM_CommitmentItemHead.loader((RichDocumentContext)this.getMidContext()).OID(commitItemID).load()).getIsStatisticalCommit() > 0;
    }

    public Long getUpdateProfileID() {
        return this.updateProfileID;
    }

    public void setUpdateProfileID(Long updateProfileID) {
        this.updateProfileID = updateProfileID;
    }

    public int getPaymentBudgetValue() {
        return this.paymentBudgetValue;
    }

    public void setPaymentBudgetValue(int paymentBudgetValue) {
        this.paymentBudgetValue = paymentBudgetValue;
    }

    public int getCommitBudgetValue() {
        return this.commitBudgetValue;
    }

    public void setCommitBudgetValue(int commitBudgetValue) {
        this.commitBudgetValue = commitBudgetValue;
    }

    public boolean isHasUpdateTotalAmount() {
        return this.hasUpdateTotalAmount;
    }

    public void setHasUpdateTotalAmount(boolean hasUpdateTotalAmount) {
        this.hasUpdateTotalAmount = hasUpdateTotalAmount;
    }

    public boolean isSDUpdate() {
        return this.IsSDUpdate;
    }

    public void setSDUpdate(boolean sdupdate) {
        this.IsSDUpdate = sdupdate;
    }

    public void init(Long fmAreaID, Long companyCodeID, String valueType) throws Throwable {
        Long versionID = ECO_Version.loader((RichDocumentContext)this.getMidContext()).Code("0").load().getOID();
        this.setVersionID(versionID);
        this.setValueType(valueType);
        this.setFmAreaID(fmAreaID);
        this.setCompanyCodeID(companyCodeID);
        EFM_FinancialManagementArea finManagementArea = EFM_FinancialManagementArea.load((RichDocumentContext)this.getMidContext(), (Long)fmAreaID);
        EFM_UpdateProfileHead updateProfile = finManagementArea.getUpdateProfile();
        this.setUpdateProfileID(updateProfile.getOID());
        EFM_UpdateProfileDtl updateProfileDtl = EFM_UpdateProfileDtl.loader((RichDocumentContext)this.getMidContext()).SOID(updateProfile.getOID()).ValueType(valueType).load();
        if (updateProfileDtl.getIsBudgetAllocation() == 0) {
            this.setBudgetAllocation(false);
            return;
        }
        EFM_CoverUpdateProfile efCoverUpdateProfile = EFM_CoverUpdateProfile.loader((RichDocumentContext)this.getMidContext()).UpdateProfileID(updateProfile.getOID()).ValueType(valueType).load();
        int bcsActiveYear = finManagementArea.getBCSActiveYear();
        if (bcsActiveYear <= 0) {
            MessageFacade.throwException((String)"COMMONCOMMITVOUCHER4OTHER003");
        }
        this.setBcsActiveYear(bcsActiveYear);
        boolean isStatisticsUpdate = updateProfileDtl.getIsStatisticsUpdate() > 0;
        int isPeriodOrYear = updateProfile.getIsPeriodOrYear();
        int paymentBudgetValue = 0;
        int commitBudgetValue = 0;
        if (efCoverUpdateProfile != null) {
            isStatisticsUpdate = efCoverUpdateProfile.getIsStaticUpdate() > 0;
            isPeriodOrYear = efCoverUpdateProfile.getIsPeriodOrYear();
            paymentBudgetValue = efCoverUpdateProfile.getPaymentBudgetValue();
            commitBudgetValue = efCoverUpdateProfile.getCommitBudgetValue();
        }
        this.setIsPeriodOrYear(isPeriodOrYear);
        this.setStatisticsUpdate(isStatisticsUpdate);
        this.setPaymentBudgetValue(paymentBudgetValue);
        this.setCommitBudgetValue(commitBudgetValue);
        if (updateProfileDtl.getIsPBActive() > 0 && updateProfileDtl.getIsPBReduce() > 0) {
            this.setPBUpdate(true);
            this.setPBDateMethod(updateProfileDtl.getPBDate());
        }
        if (updateProfileDtl.getIsCBActive() > 0 && updateProfileDtl.getIsCBReduce() > 0) {
            this.setCBUpdate(true);
            this.setCBDateMethod(updateProfileDtl.getCBDate());
        }
        this.setHasUpdateTotalAmount(false);
        this.setSDUpdate(finManagementArea.getIsSDUpdate() == 0);
    }

    public void checkConfig(Long fundID, String budgetLedgerCode, String postLedgerCode) throws Throwable {
        EFM_AddressIndex addressIndex;
        EFM_BSDistribution bsDistribution;
        EFM_PostLedgerPeriod postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).ValueType(this.valueType).FiscalYear(this.fiscalYear).FromFiscalPeriod("<=", this.fiscalPeriod).ToFiscalPeriod(">=", this.fiscalPeriod).LedgerID(this.fmLedgerID).load();
        if (postLedgerPeriod == null) {
            postLedgerPeriod = EFM_PostLedgerPeriod.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).ValueType(ValueTypeEnum.ValueType_ALL.getKey()).FiscalYear(this.fiscalYear).FromFiscalPeriod("<=", this.fiscalPeriod).ToFiscalPeriod(">=", this.fiscalPeriod).LedgerID(this.fmLedgerID).load();
        }
        if (postLedgerPeriod == null) {
            MessageFacade.throwException((String)"POCOMMITVOUCHERFORMULA002", (Object[])new Object[]{postLedgerCode});
        }
        if (fundID.compareTo(0L) > 0) {
            EFM_Fund fundDict = EFM_Fund.load((RichDocumentContext)this.getMidContext(), (Long)fundID);
            Long termValidityFromDate = fundDict.getValidStartDate();
            Long termValidityToDate = fundDict.getValidEndDate();
            if (ERPDateUtil.isBefore((Object)(this.fmPostDate + 1L), (Object)termValidityFromDate) || ERPDateUtil.isBefore((Object)termValidityToDate, (Object)this.fmPostDate)) {
                MessageFacade.throwException((String)"PRCOMMITVOUCHERFORMULA002", (Object[])new Object[]{fundDict.getCode()});
            }
        }
        if ((bsDistribution = EFM_BSDistribution.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FiscalYear(this.fiscalYear).load()) != null && bsDistribution.getIsCheckPost() > 0 && (addressIndex = EFM_AddressIndex.loader((RichDocumentContext)this.getMidContext()).FinancialManagementAreaID(this.fmAreaID).FromFiscalYear(this.fiscalYear).FromLedgerID(this.fmLedgerID).FromObjectNumber(this.postAddress).ToLedgerCode(budgetLedgerCode).load()) == null) {
            MessageFacade.throwException((String)"PRCOMMITVOUCHERFORMULA003", (Object[])new Object[]{this.fiscalYear, postLedgerCode, addressIndex.getFromFundCode(), addressIndex.getFromFundCenterCode(), addressIndex.getFromCommitmentItemCode(), addressIndex.getFromFunctionalAreaCode()});
        }
    }
}

