/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.safe.function;

import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.yes.common.i18n.StringTable;
import com.bokesoft.yes.erp.annotation.FunctionRunOnlyInServer;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.certificate.utils.MidPasswordRuleChecker;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichServiceFilterImpl;
import com.bokesoft.yes.mid.rights.OperatorRightsUtil;
import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfo;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yigo.common.rule.IStringRule;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.para.SysPara;
import com.bokesoft.yigo.mid.rsa.RSAMidUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.env.Env;
import java.util.Date;

public class SafeFunction
extends EntityContextAction {
    private static int PassWordExpiryReminders;

    public static void setPassWordExpiryReminders(int n) {
        PassWordExpiryReminders = n;
    }

    public SafeFunction(RichDocumentContext richDocumentContext) {
        super(richDocumentContext);
    }

    public boolean IsAdmin() {
        block3: {
            try {
                if (RichServiceFilterImpl.isCheckAdminRights()) break block3;
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return OperatorRightsUtil.isAdmin((DefaultContext)this.getMidContext());
    }

    @FunctionRunOnlyInServer
    public String decodePassWord(String string) throws Throwable {
        int n = TypeConvertor.toInteger((Object)this.getDocument().evaluate("GetPara('IOOPERATOR')", "\u53d6\u5bfc\u5165\u5bfc\u51fa\u64cd\u4f5c"));
        if (n != 1 && !this.IsAdmin()) {
            MessageFacade.throwException((String)"SAFEFUNCTION000", (Object[])new Object[0]);
        }
        if (string.isEmpty()) {
            MessageFacade.throwException((String)"SAFEFUNCTION001", (Object[])new Object[0]);
        }
        String string2 = SysPara.getInstance().get("PrivateKey");
        try {
            return RSAMidUtil.decryptByPrivate((String)string2, (String)string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @FunctionRunOnlyInServer
    public String DeCodePassWord(String string) throws Throwable {
        int n = TypeConvertor.toInteger((Object)this.getDocument().evaluate("GetPara('IOOPERATOR')", "\u53d6\u5bfc\u5165\u5bfc\u51fa\u64cd\u4f5c"));
        if (n != 1 && !this.IsAdmin()) {
            MessageFacade.throwException((String)"SAFEFUNCTION000", (Object[])new Object[0]);
        }
        if (string.isEmpty()) {
            MessageFacade.throwException((String)"SAFEFUNCTION001", (Object[])new Object[0]);
        }
        String string2 = SysPara.getInstance().get("PrivateKey");
        try {
            return RSAMidUtil.decryptByPrivate((String)string2, (String)string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public String EncryptPassWord(String string) {
        try {
            return (String)this.getMidContext().evalFormula("EncryptPassword('" + string + "')", "");
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public String EncryptDefaultPassWord(String string) {
        String string2 = SysPara.getInstance().get("PublicKey");
        try {
            return RSAMidUtil.encryptByPublic((String)string2, (String)string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public String GetDefaultPassWord() throws Throwable {
        String string = "select DefaultPassword from SYS_OperatorDefaultPassword where OperatorID = ?";
        DataTable dataTable = this.getMidContext().getDBManager().execPrepareQuery(string, new Object[]{21L});
        String string2 = dataTable.getString("DefaultPassword");
        return this.EncryptPassWord(this.DeCodePassWord(string2));
    }

    public boolean Locked(int n) {
        try {
            boolean bl = OperatorRightsUtil.isAdmin((DefaultContext)this.getMidContext());
            if (bl) {
                IAccountLockoutInfoMap iAccountLockoutInfoMap = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
                iAccountLockoutInfoMap.lock((DefaultContext)this.getMidContext(), (long)n);
            } else {
                MessageFacade.throwException((String)"SAFEFUNCTION002", (Object[])new Object[0]);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return true;
    }

    public boolean IsLocked(int n) {
        block3: {
            try {
                String string = String.valueOf(n);
                IAccountLockoutInfoMap iAccountLockoutInfoMap = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
                IAccountLockoutInfo iAccountLockoutInfo = iAccountLockoutInfoMap.get(string);
                if (iAccountLockoutInfo == null || !iAccountLockoutInfo.isLocked()) break block3;
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        DataTable dataTable = this.getMidContext().getDBManager().execPrepareQuery("select Locked from  SYS_Operator where OID = ?", new Object[]{n});
        Boolean bl = dataTable.getBoolean("Locked");
        return bl != null && bl != false;
    }

    public boolean UnLocked(int n) {
        try {
            boolean bl = OperatorRightsUtil.isAdmin((DefaultContext)this.getMidContext());
            if (bl) {
                IAccountLockoutInfoMap iAccountLockoutInfoMap = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
                iAccountLockoutInfoMap.unlock((DefaultContext)this.getMidContext(), (long)n);
            } else {
                MessageFacade.throwException((String)"SAFEFUNCTION002", (Object[])new Object[0]);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return true;
    }

    public String getPasswordRuleCheckerDes() throws Throwable {
        return this.a();
    }

    private String a() throws Throwable {
        if (MidPasswordRuleChecker.getInstance().getRuleList() == null) {
            return "";
        }
        int n = 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringTable.getString(null, (String)"", (String)"PassWordCheckRule"));
        stringBuilder.append("\n");
        for (IStringRule iStringRule : MidPasswordRuleChecker.getInstance().getRuleList()) {
            String string = iStringRule.getErrorDesc(this.getMidContext().getEnv().getLocale());
            String string2 = ERPStringUtil.formatMessage((Env)this.getEnv(), (String)string, (Object[])new Object[0]);
            stringBuilder.append(n).append(".").append(string2).append("\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    @FunctionRunOnlyInServer
    public Object ChangePassWord(Object object) throws Throwable {
        IDBManager iDBManager = this.getMidContext().getDBManager();
        DataTable dataTable = iDBManager.execPrepareQuery("select count(*) s from EGS_UserPassword where OperatorID = ?", new Object[]{object});
        dataTable.batchUpdate();
        if (dataTable.getInt("s") > 0) {
            int n;
            DataTable dataTable2 = iDBManager.execPrepareQuery("select MAX(ModifyTime) ModifyTime from EGS_UserPassword where OperatorID = ?", new Object[]{object});
            dataTable2.batchUpdate();
            Date date = dataTable2.getDateTime("ModifyTime");
            if (date == null) {
                return false;
            }
            long l = date.getTime();
            long l2 = ERPDateUtil.getNowTime().getTime();
            long l3 = (l2 - l) / 24L / 60L / 60L / 1000L;
            if (l3 <= (long)(n = ServerSetting.getInstance().getPasswordDuration()) && (long)n - l3 > (long)PassWordExpiryReminders) {
                return false;
            }
            return true;
        }
        return true;
    }

    @FunctionRunOnlyInServer
    public Object PassWordExpiryReminders(Object object) throws Throwable {
        long l;
        IDBManager iDBManager = this.getMidContext().getDBManager();
        DataTable dataTable = iDBManager.execPrepareQuery("select MAX(ModifyTime) ModifyTime from EGS_UserPassword where OperatorID = ?", new Object[]{object});
        dataTable.batchUpdate();
        Date date = dataTable.getDateTime("ModifyTime");
        if (date == null) {
            return false;
        }
        long l2 = date.getTime();
        long l3 = ERPDateUtil.getNowTime().getTime();
        int n = ServerSetting.getInstance().getPasswordDuration();
        if ((long)n - (l = (l3 - l2) / 24L / 60L / 60L / 1000L) <= 0L) {
            return false;
        }
        if (l <= (long)n && (long)n - l > (long)PassWordExpiryReminders) {
            return false;
        }
        return true;
    }

    @FunctionRunOnlyInServer
    public boolean IsFirstLogin(Object object) throws Throwable {
        IDBManager iDBManager = this.getMidContext().getDBManager();
        DataTable dataTable = iDBManager.execPrepareQuery("select count(*) s from EGS_UserPassword where OperatorID = ?", new Object[]{object});
        dataTable.batchUpdate();
        return dataTable.getInt("s") <= 0;
    }

    @FunctionRunOnlyInServer
    public String ChangePasswordTip(Object object) throws Throwable {
        long l;
        Boolean bl = this.IsFirstLogin(object);
        if (bl.booleanValue()) {
            return ERPStringUtil.formatMessage((Env)this.getEnv(), (String)"\u9996\u6b21\u767b\u5f55\u7cfb\u7edf\u8bf7\u4fee\u6539\u5bc6\u7801", (Object[])new Object[0]);
        }
        IDBManager iDBManager = this.getMidContext().getDBManager();
        DataTable dataTable = iDBManager.execPrepareQuery("select MAX(ModifyTime) ModifyTime from EGS_UserPassword where OperatorID = ?", new Object[]{object});
        dataTable.batchUpdate();
        Date date = dataTable.getDateTime("ModifyTime");
        if (date == null) {
            return ERPStringUtil.formatMessage((Env)this.getEnv(), (String)"\u8bf7\u4fee\u6539\u5bc6\u7801", (Object[])new Object[0]);
        }
        long l2 = date.getTime();
        long l3 = ERPDateUtil.getNowTime().getTime();
        int n = ServerSetting.getInstance().getPasswordDuration();
        if ((long)n - (l = (l3 - l2) / 24L / 60L / 60L / 1000L) <= (long)PassWordExpiryReminders) {
            if ((long)n - l <= 0L) {
                return ERPStringUtil.formatMessage((Env)this.getEnv(), (String)"\u5bc6\u7801\u5df2\u7ecf\u5230\u671f,\u8bf7\u4fee\u6539\u5bc6\u7801!", (Object[])new Object[0]);
            }
            return ERPStringUtil.formatMessage((Env)this.getEnv(), (String)"\u5bc6\u7801\u5269\u4f59{1}\u5929\u5230\u671f,\u8bf7\u4fee\u6539\u5bc6\u7801!", (Object[])new Object[]{(long)n - l});
        }
        return "";
    }

    public void SetDefaultPassWord(Long l, String string) throws Throwable {
        ERPDateUtil.getNowTime();
        String string2 = "select CreateTime from SYS_OperatorDefaultPassword where OperatorID = ?";
        IDBManager iDBManager = this.getMidContext().getDBManager();
        DataTable dataTable = iDBManager.execPrepareQuery(string2, new Object[]{l});
        if (dataTable.first()) {
            string2 = "update SYS_OperatorDefaultPassword set DefaultPassword = ? , ModifyTime  = ? where  OperatorID = ?";
            iDBManager.execPrepareUpdate(string2, new Object[]{this.EncryptDefaultPassWord(string), ERPDateUtil.getNowTime(), l});
        } else {
            string2 = "INSERT into SYS_OperatorDefaultPassword (OperatorID,CreateTime,DefaultPassword) values (?,?,?)";
            iDBManager.execPrepareUpdate(string2, new Object[]{l, ERPDateUtil.getNowTime(), this.EncryptDefaultPassWord(string)});
        }
    }

    public void SetOperatorDefaultPassWord(String string, Long l, Long l2) throws Throwable {
        IDBManager iDBManager = this.getMidContext().getDBManager();
        String string2 = "update SYS_Operator set Password = ? , ModifyTime  = ? , Modifier = ? where  OID = ?";
        iDBManager.execPrepareUpdate(string2, new Object[]{string, ERPDateUtil.getNowTime(), l, l2});
    }

    public void DeletePasswordLogging(Long l) throws Throwable {
        IDBManager iDBManager = this.getMidContext().getDBManager();
        String string = "DELETE FROM  EGS_UserPassword where OperatorID = ?";
        iDBManager.execPrepareUpdate(string, new Object[]{l});
    }

    public void saveOperatorPreTriggers() throws Throwable {
        RichDocument richDocument = this.getMidContext().getRichDocument();
        DataTable dataTable = richDocument.get("SYS_Operator");
        String string = dataTable.getString("Password");
        if (string.length() > 0) {
            return;
        }
        String string2 = "select DefaultPassword from SYS_OperatorDefaultPassword where OperatorID = ?";
        DataTable dataTable2 = this.getMidContext().getDBManager().execPrepareQuery(string2, new Object[]{21});
        if (dataTable2.isFirst()) {
            string = dataTable2.getString("DefaultPassword");
        }
        dataTable.setObject("Password", (Object)this.EncryptDefaultPassWord(this.DeCodePassWord(string)));
        richDocument.remove("SYS_Operator");
        richDocument.add("SYS_Operator", dataTable);
    }
}

