/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.io.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.message.MessageFacade;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.file.provider.IAttachmentProvider;
import com.bokesoft.yigo.mid.file.util.AttachmentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class ExcelUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Workbook getWorkbookFromAttachPath(DefaultContext defaultContext, String string) {
        Workbook workbook = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = ExcelUtil.readExcelFromAttachment(defaultContext, string);){
                if (inputStream == null) {
                    return null;
                }
                workbook = WorkbookFactory.create((InputStream)inputStream);
                return workbook;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            MessageFacade.throwException((String)"EXCELUTIL000", (Object[])new Object[0]);
        }
        return workbook;
    }

    public static void hideRow(Sheet sheet, int n) {
        Row row = sheet.getRow(n);
        if (row == null) {
            return;
        }
        row.setZeroHeight(true);
    }

    public static Sheet getSheet(SXSSFWorkbook sXSSFWorkbook, String string) {
        if (sXSSFWorkbook == null) {
            return null;
        }
        String string2 = WorkbookUtil.createSafeSheetName((String)string);
        SXSSFSheet sXSSFSheet = sXSSFWorkbook.getSheet(string2);
        if (sXSSFSheet == null) {
            sXSSFSheet = sXSSFWorkbook.createSheet(string2);
        }
        return sXSSFSheet;
    }

    public static Cell setCellValue(Sheet sheet, int n, int n2, CellType cellType, Object object) throws Exception {
        if (sheet == null) {
            MessageFacade.throwException((String)"EXCELUTIL001", (Object[])new Object[0]);
        }
        if (n < 0 || n2 < 0) {
            MessageFacade.throwException((String)"EXCELUTIL002", (Object[])new Object[0]);
        }
        Cell cell = ExcelUtil.a(sheet, n, n2);
        if (StringUtil.isBlankOrNull((Object)object) || "0".equalsIgnoreCase(object.toString())) {
            cell.setCellType(CellType.BLANK);
            return cell;
        }
        if (cellType == CellType.STRING) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(TypeConvertor.toString((Object)object));
        } else if (cellType == CellType.NUMERIC) {
            if (object instanceof Date) {
                cell.setCellValue((Date)object);
            } else {
                cell.setCellValue(TypeConvertor.toBigDecimal((Object)object).doubleValue());
            }
        } else if (cellType == CellType.BOOLEAN) {
            cell.setCellType(CellType.BOOLEAN);
            cell.setCellValue(TypeConvertor.toBoolean((Object)object).booleanValue());
        } else {
            MessageFacade.throwException((String)"EXCELUTIL002", (Object[])new Object[]{object.getClass().getName()});
        }
        return cell;
    }

    public static void setDateStyle(Cell cell, String string) {
        if (StringUtil.isBlankOrNull((String)string)) {
            return;
        }
        Workbook workbook = cell.getSheet().getWorkbook();
        CellStyle cellStyle = cell.getCellStyle();
        cellStyle = workbook.createCellStyle();
        DataFormat dataFormat = workbook.getCreationHelper().createDataFormat();
        short s = dataFormat.getFormat(ExcelUtil.a(string));
        cellStyle.setDataFormat(s);
        cell.setCellStyle(cellStyle);
    }

    private static String a(String string) {
        switch (string) {
            case "yyyy-MM-dd": {
                return "yyyy/mm/dd";
            }
            case "yyyy-MM-dd HH:mm:ss": {
                return "yyyy/mm/dd hh:mm:ss";
            }
        }
        MessageFacade.throwException((String)"EXCELUTIL004", (Object[])new Object[]{string});
        return null;
    }

    public static String getCellValue(Sheet sheet, int n, int n2, boolean bl) throws Exception {
        Row row;
        if (sheet == null) {
            MessageFacade.throwException((String)"EXCELUTIL001", (Object[])new Object[0]);
        }
        if (n < 0 || n2 < 0) {
            MessageFacade.throwException((String)"EXCELUTIL002", (Object[])new Object[0]);
        }
        if ((row = sheet.getRow(n)) == null) {
            return null;
        }
        Cell cell = row.getCell(n2);
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            if (cell.getCachedFormulaResultType() == CellType.NUMERIC) {
                return TypeConvertor.toString((Object)cell.getNumericCellValue());
            }
            if (cell.getCachedFormulaResultType() == CellType.STRING) {
                return TypeConvertor.toString((Object)cell.getRichStringCellValue());
            }
            MessageFacade.throwException((String)"EXCELUTIL005", (Object[])new Object[]{n, n2});
        } else {
            if (cellType == CellType.BLANK || cellType == CellType.STRING) {
                return cell.getStringCellValue();
            }
            if (bl) {
                String string = TypeConvertor.toBigDecimal((Object)cell.getNumericCellValue()).toPlainString();
                if (ERPDateUtil.isValidDateLong((Object)string)) {
                    return string;
                }
                Date date = cell.getDateCellValue();
                return ERPDateUtil.format((Object)date, (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (cellType == CellType.NUMERIC) {
                return ExcelUtil.a(cell);
            }
            if (cellType == CellType.BOOLEAN) {
                return TypeConvertor.toString((Object)cell.getBooleanCellValue());
            }
        }
        MessageFacade.throwException((String)"EXCELUTIL005", (Object[])new Object[]{n, n2});
        return null;
    }

    private static String a(Cell cell) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(cell.getNumericCellValue());
    }

    public static int getLastCellNum(Sheet sheet, int n) {
        Row row = sheet.getRow(n);
        if (row == null) {
            return -1;
        }
        return row.getLastCellNum();
    }

    private static Cell a(Sheet sheet, int n, int n2) {
        if (sheet == null) {
            return null;
        }
        Cell cell = null;
        Row row = sheet.getRow(n);
        if (row == null) {
            row = sheet.createRow(n);
        }
        if ((cell = row.getCell(n2)) == null) {
            cell = row.createCell(n2);
        }
        return cell;
    }

    public static void setCellRequiredStyle(Workbook workbook, Cell cell) {
        CellStyle cellStyle = workbook.createCellStyle();
        cell.setCellStyle(cellStyle);
        Font font = workbook.createFont();
        font.setColor((short)10);
        font.setBold(true);
        cellStyle.setFont(font);
    }

    public static void setCellBoldStyle(Workbook workbook, Cell cell) {
        CellStyle cellStyle = workbook.createCellStyle();
        cell.setCellStyle(cellStyle);
        Font font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFont(font);
    }

    public static void setCellComboboxValidation(Sheet sheet, int n, int n2, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        DataValidationHelper dataValidationHelper = sheet.getDataValidationHelper();
        int n3 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(n, n3, n2, n2);
        DataValidationConstraint dataValidationConstraint = dataValidationHelper.createExplicitListConstraint(stringArray);
        DataValidation dataValidation = dataValidationHelper.createValidation(dataValidationConstraint, cellRangeAddressList);
        sheet.addValidationData(dataValidation);
    }

    public static void mergeCells(Sheet sheet, int n, int n2, int n3, int n4) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(n, n2, n3, n4);
        if (cellRangeAddress.getNumberOfCells() > 1) {
            sheet.addMergedRegion(cellRangeAddress);
        }
    }

    private static byte[] a(Workbook workbook) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            workbook.write((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String writeExcel(DefaultContext defaultContext, Workbook workbook, String string) throws Throwable {
        byte[] byArray = ExcelUtil.a(workbook);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        String string2 = "Operator";
        IAttachmentProvider iAttachmentProvider = AttachmentUtil.newProvider((String)"", (VE)defaultContext.getVE());
        String string3 = iAttachmentProvider.upload(defaultContext, string, string2, -1L, "", "Excel", byArray, false);
        return string3;
    }

    public static InputStream readExcelFromAttachment(DefaultContext defaultContext, String string) throws Throwable {
        String string2 = "Operator";
        IAttachmentProvider iAttachmentProvider = AttachmentUtil.newProvider((String)"", (VE)defaultContext.getVE());
        byte[] byArray = (byte[])iAttachmentProvider.download(defaultContext, string2, string);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public static void copyRow(Workbook workbook, Row row, Row row2, boolean bl) {
        int n = row.getLastCellNum();
        int n2 = 0;
        while (n2 < n) {
            Cell cell = row.getCell(n2);
            if (cell != null) {
                Cell cell2 = row2.createCell(n2);
                ExcelUtil.copyCell(workbook, cell, cell2, bl);
            }
            ++n2;
        }
    }

    public static void copyCell(Workbook workbook, Cell cell, Cell cell2, boolean bl) {
        CellStyle cellStyle = workbook.createCellStyle();
        ExcelUtil.copyCellStyle(workbook, cell.getCellStyle(), cellStyle);
        cell2.setCellStyle(cellStyle);
        if (cell.getCellComment() != null) {
            cell2.setCellComment(cell.getCellComment());
        }
        CellType cellType = cell.getCellType();
        cell2.setCellType(cellType);
        if (bl) {
            if (cellType == CellType.NUMERIC) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cell2.setCellValue(cell.getDateCellValue());
                } else {
                    cell2.setCellValue(cell.getNumericCellValue());
                }
            } else if (cellType == CellType.STRING) {
                cell2.setCellValue(cell.getRichStringCellValue());
            } else if (cellType != CellType.BLANK) {
                if (cellType == CellType.BOOLEAN) {
                    cell2.setCellValue(cell.getBooleanCellValue());
                } else if (cellType == CellType.ERROR) {
                    cell2.setCellErrorValue(cell.getErrorCellValue());
                } else if (cellType == CellType.FORMULA) {
                    cell2.setCellFormula(cell.getCellFormula());
                }
            }
        }
    }

    public static void copyCellStyle(Workbook workbook, CellStyle cellStyle, CellStyle cellStyle2) {
        XSSFCellStyle xSSFCellStyle;
        cellStyle2.setAlignment(cellStyle.getAlignment());
        cellStyle2.setVerticalAlignment(cellStyle.getVerticalAlignment());
        cellStyle2.setBorderBottom(cellStyle.getBorderBottom());
        cellStyle2.setBorderLeft(cellStyle.getBorderLeft());
        cellStyle2.setBorderRight(cellStyle.getBorderRight());
        cellStyle2.setBorderTop(cellStyle.getBorderTop());
        cellStyle2.setTopBorderColor(cellStyle.getTopBorderColor());
        cellStyle2.setBottomBorderColor(cellStyle.getBottomBorderColor());
        cellStyle2.setRightBorderColor(cellStyle.getRightBorderColor());
        cellStyle2.setLeftBorderColor(cellStyle.getLeftBorderColor());
        if (cellStyle instanceof XSSFCellStyle) {
            xSSFCellStyle = (XSSFCellStyle)cellStyle2;
            if (((XSSFCellStyle)cellStyle).getFillBackgroundColorColor() != null) {
                xSSFCellStyle.setFillBackgroundColor(((XSSFCellStyle)cellStyle).getFillBackgroundColorColor());
            }
            if (((XSSFCellStyle)cellStyle).getFillForegroundColorColor() != null) {
                xSSFCellStyle.setFillForegroundColor(((XSSFCellStyle)cellStyle).getFillForegroundColorColor());
            }
        } else {
            cellStyle2.setFillBackgroundColor(cellStyle.getFillBackgroundColor());
            cellStyle2.setFillForegroundColor(cellStyle.getFillForegroundColor());
        }
        cellStyle2.setDataFormat(cellStyle.getDataFormat());
        cellStyle2.setFillPattern(cellStyle.getFillPattern());
        if (cellStyle instanceof HSSFCellStyle) {
            xSSFCellStyle = (HSSFCellStyle)cellStyle;
            cellStyle2.setFont((Font)xSSFCellStyle.getFont(workbook));
        } else if (cellStyle instanceof XSSFCellStyle) {
            xSSFCellStyle = (XSSFCellStyle)cellStyle;
            cellStyle2.setFont((Font)xSSFCellStyle.getFont());
        }
        cellStyle2.setHidden(cellStyle.getHidden());
        cellStyle2.setIndention(cellStyle.getIndention());
        cellStyle2.setLocked(cellStyle.getLocked());
        cellStyle2.setRotation(cellStyle.getRotation());
        cellStyle2.setWrapText(cellStyle.getWrapText());
    }

    public static void setColor(Workbook workbook, Workbook workbook2, Row row, Row row2) {
        int n = row.getLastCellNum();
        int n2 = 0;
        while (n2 < n) {
            Cell cell = row.getCell(n2);
            if (cell != null) {
                short s = workbook.getFontAt(cell.getCellStyle().getFontIndex()).getColor();
                Boolean bl = workbook.getFontAt(cell.getCellStyle().getFontIndex()).getBold();
                Font font = workbook2.createFont();
                font.setColor(s);
                font.setBold(bl.booleanValue());
                row2.getCell(n2).getCellStyle().setFont(font);
            }
            ++n2;
        }
    }
}

