/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.InitializeData;

import com.bokesoft.erp.InitializeData.INodeElement;
import com.bokesoft.erp.InitializeData.InitializeData;
import com.bokesoft.erp.InitializeData.Node;
import com.bokesoft.erp.InitializeData.TestFormula;
import com.bokesoft.yes.common.log.ILogSvr;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.log.NullLogSvr;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang3.function.FailableConsumer;

public class Graph {
    private ArrayList<Node> a = new ArrayList();
    private TreeMap<Object, Node> b = new TreeMap();

    public void addElement(INodeElement iNodeElement) {
        Node node = new Node(iNodeElement);
        this.a.add(node);
        this.b.put(iNodeElement.getKey(), node);
    }

    public <T extends INodeElement> void addElements(List<T> list) {
        for (INodeElement iNodeElement : list) {
            this.addElement(iNodeElement);
        }
    }

    public void createGraph() {
        Iterator<Node> iterator = this.a.iterator();
        Node node = null;
        Node node2 = null;
        while (iterator.hasNext()) {
            node = iterator.next();
            List<String> list = node.element.getInputKeys();
            if (list == null || list.isEmpty()) continue;
            for (String string : list) {
                node2 = this.b.get(string);
                if (node2 == null) continue;
                node2.addOutNode(node);
                node.addInNode(node2);
            }
        }
    }

    public boolean topoSort(LinkedList<INodeElement> linkedList, LinkedList<INodeElement> linkedList2) {
        int n = this.a.size();
        Stack<Node> stack = new Stack<Node>();
        Iterator<Node> iterator = this.a.iterator();
        Node node = null;
        while (iterator.hasNext()) {
            node = iterator.next();
            if (node.inNodes != null) continue;
            stack.add(node);
        }
        if (stack.isEmpty()) {
            return false;
        }
        ArrayList<Node> arrayList = null;
        if (linkedList2 != null) {
            arrayList = new ArrayList<Node>();
            arrayList.addAll(this.a);
        }
        int n2 = 0;
        Node node22 = null;
        while (!stack.isEmpty()) {
            node = (Node)stack.pop();
            linkedList.addLast(node.element);
            if (linkedList2 != null) {
                arrayList.remove(node);
            }
            ++n2;
            if (node.outNodes != null) {
                for (Node node22 : node.outNodes) {
                    node22.removeInNode(node);
                    if (node22.inNodes != null) continue;
                    stack.push(node22);
                }
            }
            node.removeAllOutNode();
        }
        if (n2 < n) {
            if (linkedList2 != null) {
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    linkedList2.add(((Node)iterator2.next()).element);
                }
            }
            return false;
        }
        return true;
    }

    public Graph erpResolveCycles() throws Throwable {
        return this.resolveCycles((FailableConsumer<List<Node>, Throwable>)((FailableConsumer)list -> {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Node node = (Node)listIterator.next();
                Node node2 = null;
                if (listIterator.hasNext()) {
                    node2 = (Node)listIterator.next();
                    listIterator.previous();
                }
                if (node2 == null) continue;
                String string = node.element.getKey();
                String string2 = node2.element.getKey();
                MetaForm metaForm = InitializeData.a().getMetaForm(string);
                String string3 = InitializeData.a().getMetaForm(string2).getDataSource().getDataObject().getKey();
                IDLookup iDLookup = IDLookup.getIDLookup((MetaForm)metaForm);
                List list2 = (List)iDLookup.getItemKey2AllDicFieldKey().get(string3);
                if (list2 == null) continue;
                for (String string4 : list2) {
                    MetaColumn metaColumn = iDLookup.getMetaColumnByFieldKey(string4);
                    if (!metaColumn.isPrimaryKey().booleanValue()) continue;
                    throw new RuntimeException(String.valueOf(string) + "\u4e0e" + string2 + "\u8868\u5355\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u5e76\u4e14\u662f\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5");
                }
            }
        }));
    }

    public Graph resolveCycles(FailableConsumer<List<Node>, Throwable> failableConsumer) throws Throwable {
        Graph graph = new Graph();
        this.a.forEach(node -> graph.addElement(node.element));
        List<List<Node>> list = this.a();
        for (List<Node> list2 : list) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            Node node2 = list2.get(0);
            Node node3 = list2.get(1);
            Node node4 = list2.get(list2.size() - 2);
            int n2 = node2.outNodes.size();
            if (n2 <= (n = node3.outNodes.size())) {
                node2.element.getInputKeys().remove(node4.element.getKey());
            } else {
                node3.element.getInputKeys().remove(node2.element.getKey());
            }
            for (Node node5 : list2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" -> ");
                }
                stringBuilder.append(node5.element.getKey()).append(" (").append(node5.outNodes.size()).append("\u5904\u5f15\u7528)");
            }
            LogSvr.getInstance().info("Detected cycle: " + stringBuilder);
            if (failableConsumer == null) continue;
            failableConsumer.accept(list2);
        }
        return graph;
    }

    public LinkedList<INodeElement> resolveCyclesAndTopoSort4ERP() throws Throwable {
        Graph graph = this.erpResolveCycles();
        graph.createGraph();
        return Graph.a(graph);
    }

    private static LinkedList<INodeElement> a(Graph graph) {
        LinkedList<INodeElement> linkedList = new LinkedList<INodeElement>();
        LinkedList<INodeElement> linkedList2 = new LinkedList<INodeElement>();
        boolean bl = graph.topoSort(linkedList, linkedList2);
        if (!bl) {
            throw new RuntimeException("\u4e0d\u5e94\u8be5\u51fa\u73b0\u8fd9\u6837\u7684\u60c5\u51b5");
        }
        return linkedList;
    }

    public LinkedList<INodeElement> resolveCyclesAndTopoSort() throws Throwable {
        Graph graph = this.resolveCycles(null);
        graph.createGraph();
        return Graph.a(graph);
    }

    protected List<List<Node>> a() {
        ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
        HashSet<Node> hashSet = new HashSet<Node>();
        Stack<Node> stack = new Stack<Node>();
        for (Node node : this.a) {
            if (hashSet.contains(node)) continue;
            this.a(node, hashSet, stack, arrayList);
        }
        return arrayList;
    }

    private void a(Node node, Set<Node> set, Stack<Node> stack, List<List<Node>> list) {
        set.add(node);
        stack.push(node);
        if (node.outNodes != null) {
            for (Node node2 : node.outNodes) {
                if (stack.contains(node2)) {
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    Iterator iterator = stack.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        Node node3 = (Node)iterator.next();
                        if (node3 == node2) {
                            bl = true;
                        }
                        if (!bl) continue;
                        arrayList.add(node3);
                    }
                    arrayList.add(node2);
                    list.add(arrayList);
                    continue;
                }
                if (set.contains(node2)) continue;
                this.a(node2, set, stack, list);
            }
        }
        stack.pop();
    }

    public static void main(String[] stringArray) throws Throwable {
        LogSvr.setInstance((ILogSvr)new NullLogSvr());
        Graph.standardTest();
        LogSvr.getInstance().info("-------------");
        Graph.resolveCycleTestcase1();
        LogSvr.getInstance().info("-------------");
        Graph.resolveCycleTestcase2();
        LogSvr.getInstance().info("-------------");
        Graph.resolveLongPathCycleTestcase1();
        LogSvr.getInstance().info("-------------");
        Graph.resolveLongPathCycleTestcase2();
    }

    public static void standardTest() throws Throwable {
        Graph graph = new Graph();
        graph.addElement(new TestFormula("C", "D,E", "C=D+E"));
        graph.addElement(new TestFormula("A", "B,C", "A=B+C"));
        graph.addElement(new TestFormula("E", "F,G", "E=F+G"));
        graph.addElement(new TestFormula("G", "H", "G=H"));
        graph.createGraph();
        LinkedList<INodeElement> linkedList = new LinkedList<INodeElement>();
        if (graph.topoSort(linkedList, null)) {
            Iterator iterator = linkedList.iterator();
            TestFormula testFormula = null;
            while (iterator.hasNext()) {
                testFormula = (TestFormula)iterator.next();
                testFormula.a();
            }
        } else {
            LogSvr.getInstance().info("has circle");
        }
    }

    public static void resolveCycleTestcase1() throws Throwable {
        Graph graph = new Graph();
        graph.addElement(new TestFormula("A", "B,C", "A=B+C"));
        graph.addElement(new TestFormula("P", "A,Z", "P=A+Z"));
        graph.addElement(new TestFormula("Z", "A,P", "Z=A+P"));
        graph.addElement(new TestFormula("O", "A,Z", "O=A+Z"));
        Graph.b(graph);
    }

    public static void resolveCycleTestcase2() throws Throwable {
        Graph graph = new Graph();
        graph.addElement(new TestFormula("A", "B,C", "A=B+C"));
        graph.addElement(new TestFormula("P", "A,Z", "P=A+Z"));
        graph.addElement(new TestFormula("Z", "A,P", "Z=A+P"));
        graph.addElement(new TestFormula("O", "A,P", "O=A+P"));
        Graph.b(graph);
    }

    public static void resolveLongPathCycleTestcase1() throws Throwable {
        Graph graph = new Graph();
        graph.addElement(new TestFormula("A", "B", "A=B"));
        graph.addElement(new TestFormula("B", "C", "B=C"));
        graph.addElement(new TestFormula("C", "D", "C=D"));
        graph.addElement(new TestFormula("D", "E", "D=E"));
        graph.addElement(new TestFormula("E", "A", "E=A"));
        graph.addElement(new TestFormula("O", "E", "O=E"));
        graph.addElement(new TestFormula("P", "E", "P=E"));
        Graph.b(graph);
    }

    public static void resolveLongPathCycleTestcase2() throws Throwable {
        Graph graph = new Graph();
        graph.addElement(new TestFormula("A", "B", "A=B"));
        graph.addElement(new TestFormula("B", "C", "B=C"));
        graph.addElement(new TestFormula("C", "D", "C=D"));
        graph.addElement(new TestFormula("D", "E", "D=E"));
        graph.addElement(new TestFormula("E", "A", "E=A"));
        graph.addElement(new TestFormula("O", "A", "O=A"));
        graph.addElement(new TestFormula("P", "A", "P=A"));
        Graph.b(graph);
    }

    private static void b(Graph graph) throws Throwable {
        graph.createGraph();
        LinkedList<INodeElement> linkedList = new LinkedList<INodeElement>();
        LinkedList<INodeElement> linkedList2 = new LinkedList<INodeElement>();
        boolean bl = graph.topoSort(linkedList, linkedList2);
        if (!bl) {
            linkedList = graph.resolveCyclesAndTopoSort();
        }
        Iterator iterator = linkedList.iterator();
        TestFormula testFormula = null;
        while (iterator.hasNext()) {
            testFormula = (TestFormula)iterator.next();
            testFormula.a();
        }
    }
}

