/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.yigo.cache.ICache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class CacheFactoryWrapUtil {
    private static final String METHOD_INSTANCE = "getInstance";
    private static final String METHOD_CREATE_CACHE = "createCache";
    private static final String CACHE_FACTORY_CLASS_NAME_2 = "com.bokesoft.yes.tools.cache.CacheFactory";
    private static final String CACHE_FACTORY_CLASS_NAME_3 = "com.bokesoft.yigo.cache.CacheFactory";
    private static final Map<String, ICache> CACHE_MAP = new ConcurrentHashMap<String, ICache>();
    private static final Class CACHE_FACTORY_CLASS = CacheFactoryWrapUtil.getCacheFactoryClass();

    public static <V> ICache<V> getCache(String cacheKey) {
        return CACHE_MAP.computeIfAbsent(cacheKey, val -> CacheFactoryWrapUtil.buildCache(cacheKey));
    }

    private static <V> ICache<V> buildCache(String cacheKey) {
        try {
            Object iCacheFactoryObj = MethodUtils.invokeStaticMethod((Class)CACHE_FACTORY_CLASS, (String)METHOD_INSTANCE, (Object[])new Object[0]);
            return (ICache)MethodUtils.invokeMethod((Object)iCacheFactoryObj, (String)METHOD_CREATE_CACHE, (Object[])new Object[]{cacheKey});
        }
        catch (Exception e) {
            return (ICache)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static Class<?> getCacheFactoryClass() {
        try {
            Class<?> factoryClass;
            try {
                factoryClass = Class.forName(CACHE_FACTORY_CLASS_NAME_3);
            }
            catch (ClassNotFoundException e) {
                factoryClass = Class.forName(CACHE_FACTORY_CLASS_NAME_2);
            }
            return factoryClass;
        }
        catch (ClassNotFoundException e) {
            return (Class)ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

