/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.exttools.sdk;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.extension.exception.GeneralUserException;
import com.bokesoft.distro.tech.yigosupport.extension.utils.codecs.AESUtils;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptImpl {
    private static final String SPLITTER_ENCRYPT_SEED = ",";
    public static final String ENCRYPT_PREFIX_AES = "=*";
    private static final Logger log = LoggerFactory.getLogger(EncryptImpl.class);
    private static Configer configer = null;
    private static List<String> AES_KEYS = null;

    public static void initConfiger(Configer configer) {
        EncryptImpl.configer = configer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> lazyloadAESKey() throws UnsupportedEncodingException {
        if (null != AES_KEYS) return AES_KEYS;
        Class<EncryptImpl> clazz = EncryptImpl.class;
        synchronized (EncryptImpl.class) {
            if (null != AES_KEYS) return AES_KEYS;
            AES_KEYS = new ArrayList<String>();
            String seeds = null;
            if (null != configer) {
                seeds = configer.getEncryptKeys();
            }
            if (null != seeds) {
                String[] list = StringUtils.split((String)seeds, (String)SPLITTER_ENCRYPT_SEED);
                for (int i = 0; i < list.length; ++i) {
                    String seed = list[i];
                    if (!StringUtils.isNotBlank((CharSequence)seed)) continue;
                    AES_KEYS.add(AESUtils.getSecretKey(seed.trim()));
                }
            }
            String defSeed = System.class.getName();
            AES_KEYS.add(AESUtils.getSecretKey(defSeed));
            // ** MonitorExit[var0] (shouldn't be in output)
            return AES_KEYS;
        }
    }

    public static String encrypt(String value, String prefix) {
        if (null == value) {
            return null;
        }
        if (ENCRYPT_PREFIX_AES.equals(prefix)) {
            try {
                return EncryptImpl.encryptAES(value);
            }
            catch (UnsupportedEncodingException e) {
                throw MiscUtil.toRuntimeException((Throwable)e);
            }
        }
        throw new GeneralUserException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u65b9\u5f0f");
    }

    public static String decrypt(String value) {
        if (null == value) {
            return null;
        }
        if (value.startsWith(ENCRYPT_PREFIX_AES)) {
            try {
                return EncryptImpl.decryptAES(value);
            }
            catch (UnsupportedEncodingException e) {
                throw MiscUtil.toRuntimeException((Throwable)e);
            }
        }
        throw new GeneralUserException("\u52a0\u5bc6\u6570\u636e\u683c\u5f0f\u9519\u8bef");
    }

    public static void encryptDocument(Document doc, String tableName, String fieldName, final String prefix) {
        EncryptImpl.processDocument(doc, tableName, fieldName, "\u5b57\u6bb5\u52a0\u5bc6", new Runner(){

            @Override
            public String process(String value) {
                return EncryptImpl.encrypt(value, prefix);
            }
        });
    }

    public static void decryptDocument(Document doc, String tableName, String fieldName) {
        EncryptImpl.processDocument(doc, tableName, fieldName, "\u5b57\u6bb5\u89e3\u5bc6", new Runner(){

            @Override
            public String process(String value) {
                try {
                    return EncryptImpl.decrypt(value);
                }
                catch (Exception e) {
                    return value;
                }
            }
        });
    }

    private static String encryptAES(String value) throws UnsupportedEncodingException {
        List<String> keys = EncryptImpl.lazyloadAESKey();
        String key = keys.get(0);
        try {
            String enVal = AESUtils.encrypt(value, key);
            return ENCRYPT_PREFIX_AES + enVal;
        }
        catch (Exception e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
    }

    private static String decryptAES(String value) throws UnsupportedEncodingException {
        String rawValue = value.substring(ENCRYPT_PREFIX_AES.length());
        List<String> keys = EncryptImpl.lazyloadAESKey();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            String key = keys.get(i);
            try {
                String deVal = AESUtils.decrypt(rawValue, key);
                return deVal;
            }
            catch (Exception e) {
                log.warn("\u4f7f\u7528\u7b2c " + i + "\u4e2a\u5bc6\u94a5\u89e3\u5bc6\u9519\u8bef: " + e.getMessage());
                continue;
            }
        }
        return value;
    }

    private static void processDocument(Document doc, String tableName, String fieldName, String descr, Runner runner) {
        DataTable tbl = doc.get(tableName);
        if (null == tbl) {
            throw new GeneralUserException("\u5f53\u524d\u4e0a\u4e0b\u6587\u4e2d\u627e\u4e0d\u5230\u6570\u636e\u8868 [" + tableName + "]");
        }
        int size = tbl.size();
        for (int i = 0; i < size; ++i) {
            String val = tbl.getString(i, fieldName);
            if (null == val) continue;
            log.info("\u6b63\u5728\u5904\u7406 '" + descr + "': " + tableName + "." + fieldName + " \u7684 \u7b2c [" + i + "] \u884c ...");
            val = runner.process(val);
            tbl.setString(i, fieldName, val);
        }
    }

    public static interface Configer {
        public String getEncryptKeys();
    }

    public static interface Runner {
        public String process(String var1);
    }
}

