/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.exttools;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.CacheFactoryWrapUtil;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;

public class MaskExp {
    private static final ICache<String> CACHE_SENSITIVE_FIELDS = CacheFactoryWrapUtil.getCache(MaskExp.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void FixedPos(DefaultContext context, String table, String field, String maskCharStr, Number start, Number end) throws Throwable {
        char maskChar = maskCharStr.charAt(0);
        Document document = context.getDocument();
        String oidFieldName = MaskExp.getOidFieldName(table, document);
        DataTable dataTable = document.get(table);
        for (int i = 0; i < dataTable.size(); ++i) {
            int state = dataTable.getState(i);
            try {
                String unmaskedFiledValue = dataTable.getString(i, field);
                if (unmaskedFiledValue == null) continue;
                String key = MaskExp.calculateCacheKey(dataTable, i, oidFieldName, field);
                MaskExp.cacheSensitiveField(key, unmaskedFiledValue);
                String maskFiledValue = MaskExp.mask(unmaskedFiledValue, maskChar, start.intValue(), end.intValue());
                dataTable.setString(i, field, maskFiledValue);
                continue;
            }
            finally {
                Class<?> clazz = dataTable.getClass();
                Field viewDataListFiled = clazz.getDeclaredField("viewDataList");
                viewDataListFiled.setAccessible(true);
                ArrayList viewDataList = (ArrayList)viewDataListFiled.get(dataTable);
                ((Row)viewDataList.get(i)).setState(state);
            }
        }
    }

    public static void Restore(DefaultContext context, String table, String field) {
        Document document = context.getDocument();
        String oidFieldName = MaskExp.getOidFieldName(table, document);
        boolean isMainTable = MaskExp.isMainTable(document, table);
        DataTable dataTable = document.get(table);
        for (int i = 0; i < dataTable.size(); ++i) {
            String originalValue = TypeConvertor.toString((Object)dataTable.getOriginalObject(i, field));
            String newValue = dataTable.getString(i, field);
            if ((!isMainTable || !MaskExp.isNormal(dataTable, i)) && !MaskExp.isModified(dataTable, i) || !Objects.equals(originalValue, newValue)) continue;
            String key = MaskExp.calculateCacheKey(dataTable, i, oidFieldName, field);
            dataTable.setString(i, field, MaskExp.findSensitiveField(key));
        }
    }

    private static boolean isMainTable(Document document, String table) {
        String mainTableKey = document.getMetaDataObject().getMainTableKey();
        return table.equals(mainTableKey);
    }

    private static boolean isModified(DataTable dataTable, int cloIndex) {
        return dataTable.getState(cloIndex) == 2;
    }

    private static boolean isNormal(DataTable dataTable, int cloIndex) {
        return dataTable.getState(cloIndex) == 0;
    }

    private static void cacheSensitiveField(String key, String fieldValue) {
        CACHE_SENSITIVE_FIELDS.put(key, (Object)fieldValue);
    }

    private static String findSensitiveField(String key) {
        return (String)CACHE_SENSITIVE_FIELDS.get(key);
    }

    private static String mask(String sourceStr, char maskChar, int start, int end) {
        if (sourceStr == null) {
            return null;
        }
        if (start < 0 || end > sourceStr.length() || start > end) {
            throw new IllegalArgumentException("Invalid start or end position.");
        }
        StringBuilder maskedString = new StringBuilder(sourceStr);
        for (int i = start; i < end; ++i) {
            maskedString.setCharAt(i, maskChar);
        }
        return maskedString.toString();
    }

    private static String calculateCacheKey(DataTable dataTable, int colIndex, String oidFieldName, String field) {
        String key = dataTable.getKey();
        Object oid = dataTable.getObject(colIndex, oidFieldName);
        return key + oid + field;
    }

    private static String getOidFieldName(String table, Document document) {
        MetaTable metaTable = document.getMetaDataObject().getMetaTable(table);
        return metaTable.getOIDColumn().getBindingDBColumnName();
    }
}

