/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.cache;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQueryCache {
    private static Logger log = LoggerFactory.getLogger(SqlQueryCache.class);
    private static RequestContext requestContext = null;
    private String cacheName;
    private Map<String, Object> localCache = new ConcurrentHashMap<String, Object>();
    private Map<String, Long> localQueryTimeMap = new ConcurrentHashMap<String, Long>();

    public static void setRequestContext(RequestContext requestContext) {
        SqlQueryCache.requestContext = requestContext;
    }

    public SqlQueryCache(String cacheName) {
        this.cacheName = cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T basicQuery(String sql, Object[] params, DataWrapper<T> wrapper, DataDecorator<T> decorator) {
        boolean needDBQuery;
        String sqlCacheKey = this.getSqlCahceKey(sql, params);
        String lastQueryTimeCacheKey = this.getLastQueryTimeKey(sqlCacheKey);
        Request request = null;
        if (null != requestContext) {
            request = requestContext.getRequest();
        }
        Long remoteTime = null;
        if (null != request) {
            remoteTime = (Long)request.getAttribute(sqlCacheKey);
        }
        ICache<Long> yigoCache = null;
        if (null == remoteTime) {
            yigoCache = this.getYigoCache();
            remoteTime = (Long)yigoCache.get(lastQueryTimeCacheKey);
            if (null != request) {
                request.setAttribute(sqlCacheKey, remoteTime);
            }
        }
        boolean needOverwriteCache = null == remoteTime;
        if (!this.localCache.containsKey(sqlCacheKey)) {
            needDBQuery = true;
        } else {
            Long localTime = this.localQueryTimeMap.get(sqlCacheKey);
            if (null == localTime) {
                needDBQuery = true;
                log.error("\u5e76\u53d1\u51b2\u7a81 - localCache \u548c localQueryTimeMap \u4e2d\u6839\u636e Key '{}' \u83b7\u53d6\u7684\u503c\u4e0d\u4e00\u81f4, \u5c06\u91cd\u65b0\u67e5\u8be2\u6570\u636e", (Object)sqlCacheKey);
            } else {
                needDBQuery = null == remoteTime ? true : !localTime.equals(remoteTime);
            }
        }
        if (needOverwriteCache) {
            remoteTime = System.currentTimeMillis();
        }
        Object cacheData = this.localCache.get(sqlCacheKey);
        if (needDBQuery || null == this.localCache) {
            SqlQueryCache sqlQueryCache = this;
            synchronized (sqlQueryCache) {
                Object tmp;
                cacheData = tmp = this.localCache.get(sqlCacheKey);
                if (needDBQuery || null == this.localCache) {
                    log.info("\u91cd\u65b0\u8bfb\u53d6 SqlQueryCache: {}, PARAMS={}, CacheKey={}", new Object[]{this.cacheName, StringUtils.join((Object[])params, (String)","), sqlCacheKey});
                    DataTable dbData = this.getQueryDataTable(sql, params);
                    cacheData = wrapper.build(dbData);
                    this.localQueryTimeMap.put(sqlCacheKey, remoteTime);
                    this.localCache.put(sqlCacheKey, cacheData);
                } else if (log.isDebugEnabled()) {
                    log.debug("\u547d\u4e2d SqlCacheCache: {}, PARAMS={}, CacheKey={} .", new Object[]{this.cacheName, StringUtils.join((Object[])params, (String)","), sqlCacheKey});
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("\u547d\u4e2d SqlCacheCache: {}, PARAMS={}, CacheKey={} .", new Object[]{this.cacheName, StringUtils.join((Object[])params, (String)","), sqlCacheKey});
        }
        if (needOverwriteCache) {
            log.info("\u66f4\u65b0\u65f6\u95f4\u6233\u6807\u8bb0 SqlQueryCache: {}, lastQueryTimeCacheKey={}", (Object)this.cacheName, (Object)lastQueryTimeCacheKey);
            if (yigoCache == null) {
                yigoCache = this.getYigoCache();
            }
            yigoCache.put(lastQueryTimeCacheKey, (Object)remoteTime);
            if (null != request) {
                request.setAttribute(sqlCacheKey, remoteTime);
            }
        }
        return (T)decorator.fetch(cacheData);
    }

    public <T> Map<String, T> queryMap(String sql, Object[] params, String keyField, String valueField, Class<T> typeClass) {
        return this.basicQuery(sql, params, data -> {
            FieldReader reader = SqlQueryCache.getFieldReader(typeClass);
            HashMap cacheData = new HashMap();
            data.beforeFirst();
            while (data.next()) {
                String key = data.getString(keyField);
                Object value = reader.get(data, valueField);
                if (null == value) continue;
                cacheData.put(key, value);
            }
            return cacheData;
        }, cachedData -> Collections.unmodifiableMap(cachedData));
    }

    private DataTable getQueryDataTable(String sql, Object[] params) {
        return SessionUtils.processWithContext(null, ctx -> {
            DataTable dt = ctx.getDBManager().execPrepareQuery(sql, params);
            return dt;
        });
    }

    private String getLastQueryTimeKey(String sqlCacheKey) {
        return "LastQueryTime:" + sqlCacheKey;
    }

    private String getSqlCahceKey(String sql, Object[] params) {
        return sql + ":" + StringUtils.join((Object[])params, (String)",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        log.info("\u6e05\u9664 SqlCacheCache: {}", (Object)this.cacheName);
        SqlQueryCache sqlQueryCache = this;
        synchronized (sqlQueryCache) {
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(this.localCache.keySet());
            ICache<Long> yigoCache = this.getYigoCache();
            keys.addAll(yigoCache.getKeys());
            int size = keys.size();
            if (size > 0) {
                log.debug("\u6e05\u9664 SqlCacheCache: {}, \u5171 {} \u9879 ...", (Object)this.cacheName, (Object)size);
                for (String key : keys) {
                    yigoCache.remove(key);
                }
                log.debug("\u6e05\u9664 SqlCacheCache \u5b8c\u6210: {}, \u5171 {} \u9879 .", (Object)this.cacheName, (Object)size);
            }
            this.localCache.clear();
            this.localQueryTimeMap.clear();
        }
    }

    private ICache<Long> getYigoCache() {
        String cacheKey = this.getClass().getName() + ":" + this.cacheName;
        ICache cache = CacheFactory.getInstance().createCache(cacheKey);
        return cache;
    }

    private static final <T> FieldReader<T> getFieldReader(Class<T> type) {
        if (type.isAssignableFrom(String.class)) {
            return new FieldReader(){

                public String get(DataTable data, String columnKey) {
                    return data.getString(columnKey);
                }
            };
        }
        if (type.isAssignableFrom(Integer.class)) {
            return new FieldReader(){

                public Integer get(DataTable data, String columnKey) {
                    return data.getInt(columnKey);
                }
            };
        }
        if (type.isAssignableFrom(Long.class)) {
            return new FieldReader(){

                public Long get(DataTable data, String columnKey) {
                    return data.getLong(columnKey);
                }
            };
        }
        if (type.isAssignableFrom(Number.class)) {
            return new FieldReader(){

                public Number get(DataTable data, String columnKey) {
                    return data.getNumeric(columnKey);
                }
            };
        }
        if (type.isAssignableFrom(Date.class)) {
            return new FieldReader(){

                public Date get(DataTable data, String columnKey) {
                    return data.getDateTime(columnKey);
                }
            };
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b: " + type.getName());
    }

    public static interface FieldReader<T> {
        public T get(DataTable var1, String var2);
    }

    public static interface DataDecorator<T> {
        public T fetch(T var1);
    }

    public static interface DataWrapper<T> {
        public T build(DataTable var1);
    }

    public static interface Request {
        public Object getAttribute(String var1);

        public void setAttribute(String var1, Object var2);
    }

    public static interface RequestContext {
        public Request getRequest();
    }
}

