/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.base.log.util;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class YigoSlf4jUtil {
    public static String MDC_KEY_SQL_EXECUTOR = "SQL_EXECUTOR";
    private static final Logger defLog = LoggerFactory.getLogger(YigoSlf4jUtil.class);
    private static final Map<String, Logger> logs = new HashMap<String, Logger>();
    private static String SQL_LOGGER_CLASS = GeneralDBManager.class.getName();
    private static String SQL_LOGGER_METHOD = "sqlLog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Logger getLogger(StackTraceElement[] stacks) {
        int stackLen = stacks.length;
        int index = 3;
        if (stackLen <= index) {
            return defLog;
        }
        String logger = stacks[index].getClassName();
        Logger log = logs.get(logger);
        if (null == log) {
            Class<YigoSlf4jUtil> clazz = YigoSlf4jUtil.class;
            // MONITORENTER : com.bokesoft.distro.tech.yigosupport.extension.base.log.util.YigoSlf4jUtil.class
            log = LoggerFactory.getLogger((String)logger);
            logs.put(logger, log);
            // MONITOREXIT : clazz
        }
        if (!log.isDebugEnabled()) return log;
        if (!SQL_LOGGER_CLASS.equals(logger)) return log;
        if (!SQL_LOGGER_METHOD.equals(stacks[index].getMethodName())) return log;
        int i = index + 1;
        while (i < stackLen) {
            String className = stacks[i].getClassName();
            if (!SQL_LOGGER_CLASS.equals(className)) {
                MDC.put((String)MDC_KEY_SQL_EXECUTOR, (String)(className + "#" + stacks[i].getMethodName()));
                return log;
            }
            ++i;
        }
        return log;
    }

    public static void callLogger(LogCallback callback) {
        Logger log = YigoSlf4jUtil.getLogger(Thread.currentThread().getStackTrace());
        try {
            callback.call(log);
        }
        finally {
            MDC.remove((String)MDC_KEY_SQL_EXECUTOR);
        }
    }

    public static interface LogCallback {
        public void call(Logger var1);
    }
}

