/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.struct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jodd.util.Wildcard;
import org.apache.commons.lang3.StringUtils;

public class ServiceIdParts {
    private static final String PART_BLANK_HOLDER = "-";
    private String service;
    private String cmd;
    private String project;
    private String object;
    private List<String> arguments = new ArrayList<String>();

    private ServiceIdParts() {
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public static ServiceIdParts build(String serviceId) {
        String args;
        String[] argArr;
        if (null == serviceId) {
            serviceId = "";
        }
        while (serviceId.startsWith("/")) {
            serviceId = serviceId.substring(1);
        }
        ServiceIdParts result = new ServiceIdParts();
        String[] parts = serviceId.split("\\/");
        if (parts.length > 0) {
            result.service = ServiceIdParts.read(parts[0]);
        }
        if (parts.length > 1) {
            result.cmd = ServiceIdParts.read(parts[1]);
        }
        if (parts.length > 2) {
            result.project = ServiceIdParts.read(parts[2]);
        }
        if (parts.length > 3) {
            result.object = ServiceIdParts.read(parts[3]);
        }
        if (parts.length > 4 && (argArr = (args = ServiceIdParts.read(parts[4])).split("\\|")).length > 0) {
            result.arguments.addAll(Arrays.asList(argArr));
        }
        return result;
    }

    public static ServiceIdParts build(String service, String cmd, String project, String object, String args) {
        String serviceId = ServiceIdParts.read(service) + "/" + ServiceIdParts.read(cmd) + "/" + ServiceIdParts.read(project) + "/" + ServiceIdParts.read(object) + "/" + ServiceIdParts.read(args);
        return ServiceIdParts.build(serviceId);
    }

    private static String read(String val) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return "";
        }
        if (PART_BLANK_HOLDER.equals(val = val.trim())) {
            return "";
        }
        return val;
    }

    public String toServiceId() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(ServiceIdParts.write(this.service));
        parts.add(ServiceIdParts.write(this.cmd));
        parts.add(ServiceIdParts.write(this.project));
        parts.add(ServiceIdParts.write(this.object));
        if (null != this.arguments && this.arguments.size() > 0) {
            String args = StringUtils.join(this.arguments, (String)"|");
            parts.add(args);
        }
        return StringUtils.join(parts, (String)"/");
    }

    private static String write(String val) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return PART_BLANK_HOLDER;
        }
        return val.trim();
    }

    public boolean match(String serviceIdPattern) {
        String serviceId = this.toServiceId();
        return Wildcard.matchPath((String)serviceId, (String)serviceIdPattern);
    }
}

