/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.dee.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.bokesoft.distro.tech.yigosupport.extension.dee.impl.NodeItr;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger log = LoggerFactory.getLogger(JSONUtils.class);

    public static List<JSONObject> evalJSONPath(JSONArray data, String jsonPath) {
        JSONArray nodes;
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        Object selection = JSONPath.compile((String)jsonPath).eval((Object)data);
        if (null == selection) {
            return result;
        }
        if (selection instanceof JSONArray) {
            nodes = (JSONArray)selection;
        } else if (selection instanceof JSONObject) {
            nodes = new JSONArray();
            nodes.add(selection);
        } else {
            log.warn("\u5ffd\u7565 JSONPath {} \u67e5\u627e\u5230\u7684\u5bf9\u8c61 {} - JSONPath \u67e5\u627e\u5230\u7684\u7ed3\u679c\u53ea\u80fd\u662f JSONArray \u6216\u8005 JSONObject", (Object)jsonPath, selection);
            nodes = new JSONArray();
        }
        for (Object obj : nodes) {
            if (obj instanceof JSONObject) {
                JSONObject node = (JSONObject)obj;
                result.add(node);
                continue;
            }
            log.warn("\u5ffd\u7565 JSONPath {} \u67e5\u627e\u7ed3\u679c\u4e2d\u7684\u5143\u7d20 {} - \u67e5\u627e\u7ed3\u679c\u4e2d\u7684\u5143\u7d20\u5fc5\u987b\u662f JSONObject", (Object)jsonPath, obj);
        }
        return result;
    }

    public static void foreachJSONPath(JSONArray data, NodeItr itr) {
        int len = data.size();
        for (int i = 0; i < len; ++i) {
            JSONObject node = data.getJSONObject(i);
            itr.process(node);
        }
    }

    public static void foreachJSONPath(JSONArray data, String jsonPath, NodeItr itr) {
        List<JSONObject> nodes = JSONUtils.evalJSONPath(data, jsonPath);
        for (JSONObject node : nodes) {
            itr.process(node);
        }
    }
}

